/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.ScatterInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.ScatterDialogDefaults;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ScatterPanel
extends JPanel
implements ActionListener,
ChangeListener,
TabPanelInterface {
    private static final long serialVersionUID = 4164067137459332278L;
    protected boolean internalUpdate;
    protected JPanel MkrGrpPanel;
    protected JCheckBox ShowMkrCheckBox;
    protected JLabel ShapeLabel;
    protected JComboBox ShapeCombo;
    protected JLabel MkrClrLabel;
    protected JPanel MkrClrPanel;
    protected JButton MkrClrBtn;
    protected JLabel MkrSizeLabel;
    protected JSlider MkrSizeSlider;
    protected JCheckBox MkrOutlineCB;
    protected JCheckBox MkrShadowCB;
    protected JLabel MkrOLClrLabel;
    protected JPanel MkrOLClrPanel;
    protected JButton MkrOLClrBtn;
    protected JCheckBox MkrFillCB;
    protected JCheckBox autoSizeMkrCB;
    protected JPanel JoinGrpPanel;
    protected JComboBox JoinLineCombo;
    protected JLabel JoinLineLabel;
    protected JLabel JoinThicknessLabel;
    protected JComboBox JoinThicknessCombo;
    protected JLabel JoinLineColorLabel;
    protected JPanel JoinLineColorPanel;
    protected JButton JoinLineColorBtn;
    protected JPanel AreaPanel;
    protected JCheckBox AreaFillCB;
    protected JPanel AreaFillPanel;
    protected JButton AreaFillBtn;
    protected JLabel AreaFillClrLabel;
    protected TitledBorder MkrGrpBorder;
    protected TitledBorder JoinGrpBorder;
    protected TitledBorder AreaGrpBorder;
    protected Vector propListeners;
    protected String sliderPattern;
    protected ScatterDialogDefaults defaults;
    protected Object[] sliderArgs;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected boolean supportsJoinLines = false;
    protected boolean supportsMarkers = false;
    protected boolean showMarkerColorWidget = true;
    protected boolean showOutlineColorWidget = true;
    protected boolean showMarkerVisibleWidget = false;

    public ScatterPanel(PropertyInterface chart) {
        this.sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Size_Slider_Text.fmt", (String)"Size: {0,number,integer}");
        this.sliderArgs = new Object[1];
        this.defaults = new ScatterDialogDefaults();
        Insets ins = this.getInsets();
        this.propListeners = new Vector();
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)chart);
        this.internalUpdate = false;
        this.setLayout(null);
        this.setSize(ins.left + ins.right + 280, ins.top + ins.bottom + 270);
        this.createControls();
    }

    protected void createControls() {
        this.MkrGrpBorder = new TitledBorder(new EtchedBorder());
        this.MkrGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.JoinGrpBorder = new TitledBorder(new EtchedBorder());
        this.JoinGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.AreaGrpBorder = new TitledBorder(new EtchedBorder());
        this.AreaGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.supportsJoinLines = false;
        this.supportsMarkers = false;
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2071);
        if (o instanceof Boolean) {
            this.supportsJoinLines = (Boolean)o;
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2070)) instanceof Boolean) {
            this.supportsMarkers = (Boolean)o;
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2075)) instanceof Boolean) {
            this.showMarkerVisibleWidget = (Boolean)o;
        }
        int y = 6;
        if (this.supportsJoinLines) {
            y = 200;
        }
        int ht = 235;
        int y2 = 175;
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2073);
        if (o instanceof Boolean) {
            this.showMarkerColorWidget = (Boolean)o;
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2074)) instanceof Boolean) {
            this.showOutlineColorWidget = (Boolean)o;
        }
        if (!this.showMarkerColorWidget && !this.showOutlineColorWidget) {
            y2 = 115;
            ht = 175;
        }
        this.MkrGrpPanel = new JPanel();
        this.ShowMkrCheckBox = new JCheckBox();
        this.ShowMkrCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShapeLabel = new JLabel();
        this.ShapeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShapeCombo = new JComboBox();
        this.ShapeCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrClrLabel = new JLabel();
        this.MkrClrLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrClrPanel = new JPanel();
        this.MkrClrBtn = new JButton();
        this.MkrClrBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrSizeLabel = new JLabel();
        this.MkrSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrSizeSlider = new JSlider();
        this.MkrOutlineCB = new JCheckBox();
        this.MkrOutlineCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrShadowCB = new JCheckBox();
        this.MkrShadowCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrOLClrLabel = new JLabel();
        this.MkrOLClrLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrOLClrPanel = new JPanel();
        this.MkrOLClrBtn = new JButton();
        this.MkrOLClrBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrFillCB = new JCheckBox();
        this.MkrFillCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.autoSizeMkrCB = new JCheckBox();
        this.autoSizeMkrCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.JoinGrpPanel = new JPanel();
        this.JoinLineCombo = new JComboBox();
        this.JoinLineCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.JoinLineLabel = new JLabel();
        this.JoinLineLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.JoinThicknessLabel = new JLabel();
        this.JoinThicknessLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.JoinThicknessCombo = new JComboBox();
        this.JoinThicknessCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.JoinLineColorLabel = new JLabel();
        this.JoinLineColorLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.JoinLineColorPanel = new JPanel();
        this.JoinLineColorBtn = new JButton();
        this.JoinLineColorBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.AreaPanel = new JPanel();
        this.AreaFillCB = new JCheckBox();
        this.AreaFillCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.AreaFillPanel = new JPanel();
        this.AreaFillBtn = new JButton();
        this.AreaFillBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.AreaFillClrLabel = new JLabel();
        this.AreaFillClrLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.setVisible(false);
        this.MkrGrpPanel.setLayout(null);
        if (this.supportsMarkers) {
            this.add(this.MkrGrpPanel);
        }
        this.MkrGrpPanel.setBounds(4, y, 272, ht);
        this.ShowMkrCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Show_Markers.txt", (String)"Show Markers"));
        this.ShowMkrCheckBox.setActionCommand("Show Markers");
        if (this.showMarkerVisibleWidget || this.supportsJoinLines && this.supportsMarkers) {
            this.MkrGrpPanel.add(this.ShowMkrCheckBox);
        }
        this.ShowMkrCheckBox.setBounds(14, 14, 180, 24);
        this.ShapeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Shape.txt", (String)"Shape:"));
        this.MkrGrpPanel.add(this.ShapeLabel);
        this.ShapeLabel.setForeground(Color.black);
        this.ShapeLabel.setBounds(14, 85, 58, 24);
        this.MkrGrpPanel.add(this.ShapeCombo);
        this.ShapeCombo.setBackground(Color.white);
        this.ShapeCombo.setBounds(84, 85, 120, 24);
        this.MkrClrLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Color.txt", (String)"Color:"));
        if (this.showMarkerColorWidget) {
            this.MkrGrpPanel.add(this.MkrClrLabel);
        }
        this.MkrClrLabel.setForeground(Color.black);
        this.MkrClrLabel.setBounds(14, 115, 58, 24);
        if (this.showMarkerColorWidget) {
            this.MkrGrpPanel.add(this.MkrClrPanel);
        }
        this.MkrClrPanel.setBackground(Color.white);
        this.MkrClrPanel.setBounds(84, 115, 120, 24);
        this.MkrClrBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Color_Button.txt", (String)"..."));
        this.MkrClrBtn.setActionCommand("...");
        if (this.showMarkerColorWidget) {
            this.MkrGrpPanel.add(this.MkrClrBtn);
        }
        this.MkrClrBtn.setBounds(206, 115, 24, 24);
        this.sliderArgs[0] = new Integer(0);
        this.MkrSizeLabel.setText(MessageFormat.format(this.sliderPattern, this.sliderArgs));
        this.MkrGrpPanel.add(this.MkrSizeLabel);
        this.MkrSizeLabel.setForeground(Color.black);
        this.MkrSizeLabel.setBounds(14, y2 + 28, 58, 24);
        this.MkrGrpPanel.add(this.MkrSizeSlider);
        this.MkrSizeSlider.setBounds(72, y2 + 28, 144, 24);
        this.MkrOutlineCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Show_Marker_Outlines.txt", (String)"Show Outlines"));
        this.MkrOutlineCB.setActionCommand("Show Outlines");
        this.MkrGrpPanel.add(this.MkrOutlineCB);
        this.MkrOutlineCB.setBounds(14, 36, 180, 24);
        this.MkrShadowCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Show_Marker_Shadows.txt", (String)"Show Shadows"));
        this.MkrShadowCB.setActionCommand("Show Shadows");
        this.MkrGrpPanel.add(this.MkrShadowCB);
        this.MkrShadowCB.setBounds(144, 36, 108, 24);
        if (this.defaults.showMarkerShadowCB) {
            this.MkrShadowCB.setVisible(true);
        } else {
            this.MkrShadowCB.setVisible(false);
        }
        this.MkrOLClrLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Outline.txt", (String)"Outline:"));
        if (this.showOutlineColorWidget) {
            this.MkrGrpPanel.add(this.MkrOLClrLabel);
        }
        this.MkrOLClrLabel.setForeground(Color.black);
        this.MkrOLClrLabel.setBounds(14, 150, 58, 24);
        if (this.showOutlineColorWidget) {
            this.MkrGrpPanel.add(this.MkrOLClrPanel);
        }
        this.MkrOLClrPanel.setBackground(Color.white);
        this.MkrOLClrPanel.setBounds(84, 150, 120, 24);
        this.MkrOLClrBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Outline_Color_Button.txt", (String)"..."));
        this.MkrOLClrBtn.setActionCommand("...");
        if (this.showOutlineColorWidget) {
            this.MkrGrpPanel.add(this.MkrOLClrBtn);
        }
        this.MkrOLClrBtn.setBounds(206, 150, 24, 24);
        this.MkrFillCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Fill_Markers.txt", (String)"Fill Markers"));
        this.MkrFillCB.setActionCommand("Show Outlines");
        this.MkrGrpPanel.add(this.MkrFillCB);
        this.MkrFillCB.setBounds(14, 61, 180, 24);
        this.autoSizeMkrCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Autosize_Markers.txt", (String)"Autosize Markers"));
        this.autoSizeMkrCB.setActionCommand("Autosize Markers");
        this.MkrGrpPanel.add(this.autoSizeMkrCB);
        this.autoSizeMkrCB.setBounds(14, y2, 220, 24);
        this.JoinGrpPanel.setLayout(null);
        if (this.supportsJoinLines) {
            this.add(this.JoinGrpPanel);
        }
        this.JoinGrpPanel.setBounds(4, 6, 272, 195);
        this.JoinGrpPanel.add(this.JoinLineCombo);
        this.JoinLineCombo.setBackground(Color.white);
        this.JoinLineCombo.setBounds(100, 24, 120, 24);
        this.JoinLineLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Style.txt", (String)"Style:"));
        this.JoinGrpPanel.add(this.JoinLineLabel);
        this.JoinLineLabel.setForeground(Color.black);
        this.JoinLineLabel.setBounds(14, 24, 58, 24);
        this.JoinThicknessLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Thickness.txt", (String)"Thickness:"));
        this.JoinGrpPanel.add(this.JoinThicknessLabel);
        this.JoinThicknessLabel.setForeground(Color.black);
        this.JoinThicknessLabel.setBounds(14, 52, 74, 24);
        this.JoinGrpPanel.add(this.JoinThicknessCombo);
        this.JoinThicknessCombo.setBackground(Color.white);
        this.JoinThicknessCombo.setBounds(100, 52, 120, 24);
        this.JoinLineColorLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Color.txt", (String)"Color:"));
        this.JoinGrpPanel.add(this.JoinLineColorLabel);
        this.JoinLineColorLabel.setForeground(Color.black);
        this.JoinLineColorLabel.setBounds(14, 80, 58, 24);
        this.JoinGrpPanel.add(this.JoinLineColorPanel);
        this.JoinLineColorPanel.setBackground(Color.white);
        this.JoinLineColorPanel.setBounds(100, 80, 120, 24);
        this.JoinLineColorBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Color_Button.txt", (String)"..."));
        this.JoinLineColorBtn.setActionCommand("...");
        this.JoinGrpPanel.add(this.JoinLineColorBtn);
        this.JoinLineColorBtn.setBounds(222, 80, 24, 24);
        this.AreaPanel.setLayout(null);
        this.JoinGrpPanel.add(this.AreaPanel);
        this.AreaPanel.setBounds(10, 114, 246, 76);
        this.AreaFillCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Fill_Area.txt", (String)"Fill Area"));
        this.AreaFillCB.setActionCommand("Fill Area");
        this.AreaPanel.add(this.AreaFillCB);
        this.AreaFillCB.setBounds(16, 16, 140, 24);
        this.AreaPanel.add(this.AreaFillPanel);
        this.AreaFillPanel.setBackground(Color.white);
        this.AreaFillPanel.setBounds(74, 46, 120, 24);
        this.AreaFillBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Area_Fill_Color_Button.txt", (String)"..."));
        this.AreaFillBtn.setActionCommand("...");
        this.AreaPanel.add(this.AreaFillBtn);
        this.AreaFillBtn.setBounds(196, 46, 24, 24);
        this.AreaFillClrLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Area_Fill_Color.txt", (String)"Color:"));
        this.AreaPanel.add(this.AreaFillClrLabel);
        this.AreaFillClrLabel.setForeground(Color.black);
        this.AreaFillClrLabel.setBounds(16, 46, 48, 24);
        this.MkrGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Markers_Title.txt", (String)"Markers"));
        this.MkrGrpBorder.setTitleColor(Color.black);
        this.MkrGrpPanel.setBorder(this.MkrGrpBorder);
        this.JoinGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLines_Title.txt", (String)"Lines"));
        this.JoinGrpBorder.setTitleColor(Color.black);
        this.JoinGrpPanel.setBorder(this.JoinGrpBorder);
        this.AreaGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Area_Fill_Title.txt", (String)"Area Fill"));
        this.AreaGrpBorder.setTitleColor(Color.black);
        this.AreaPanel.setBorder(this.AreaGrpBorder);
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2044);
        if (o != null && o instanceof String[]) {
            for (int i = 0; i < ((String[])o).length; ++i) {
                this.JoinLineCombo.addItem(new JoinEntry(((String[])o)[i], ScatterInterface.joinListValues[i]));
            }
        }
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_1.txt", (String)"1 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_2.txt", (String)"2 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_3.txt", (String)"3 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_4.txt", (String)"4 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_5.txt", (String)"5 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_6.txt", (String)"6 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_7.txt", (String)"7 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_8.txt", (String)"8 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_9.txt", (String)"9 pt."));
        this.JoinThicknessCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.JoinLine_Size_10.txt", (String)"10 pt."));
    }

    protected void fillShapeCombo() {
        int n = 0;
        Object[] list = null;
        this.ShapeCombo.removeAllItems();
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2037);
        if (o != null && o instanceof Object[]) {
            list = (Object[])o;
            n = list.length;
        }
        for (int i = 0; i < n; ++i) {
            this.ShapeCombo.addItem(list[i]);
        }
    }

    protected Color showColorChooserDialog(Color initialColor) {
        return JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.ColorChooser_Title.txt", (String)"Choose a color"), initialColor);
    }

    protected boolean getBooleanProperty(Vector props, int id, boolean defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected Color getColorProperty(Vector props, int id, Color defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Color)) {
            return defaultValue;
        }
        return (Color)o;
    }

    protected double getNumericProperty(Vector props, int id, double defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMarkerSettings() {
        boolean constantSize;
        boolean match = false;
        int nResp = 0;
        double size = -1.0;
        Color c = null;
        ScatterPanel scatterPanel = this;
        synchronized (scatterPanel) {
            this.internalUpdate = true;
        }
        boolean markersMapped = this.getBooleanProperty(this.propListeners, 2043, false);
        boolean markersOn = this.getBooleanProperty(this.propListeners, 2036, true);
        boolean shadowsOn = this.getBooleanProperty(this.propListeners, 2054, false);
        boolean sizable = this.getBooleanProperty(this.propListeners, 2033, true);
        boolean bubblePlot = this.getBooleanProperty(this.propListeners, 2062, false);
        boolean autoSize = this.getBooleanProperty(this.propListeners, 2007, true);
        boolean grpOn = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2005) != null;
        nResp = (int)this.getNumericProperty(this.propListeners, 2058, 0.0);
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2013);
        boolean constantColor = o == null ? true : o instanceof Color;
        if (constantColor) {
            c = (Color)o;
        }
        if ((constantSize = (o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2006)) == null ? true : o instanceof Number) && o != null) {
            size = ((Number)o).doubleValue();
        }
        boolean outlinesOn = this.getBooleanProperty(this.propListeners, 2018, true);
        Color olc = this.getColorProperty(this.propListeners, 2019, null);
        boolean isAnOutlineShape = this.getBooleanProperty(this.propListeners, 2035, true);
        boolean isFillableShape = this.getBooleanProperty(this.propListeners, 2034, true);
        boolean isFillOn = this.getBooleanProperty(this.propListeners, 2017, true);
        this.ShapeLabel.setEnabled(markersOn && !markersMapped);
        this.ShapeCombo.setEnabled(markersOn && !markersMapped);
        this.ShowMkrCheckBox.setSelected(markersOn || !this.showMarkerVisibleWidget && markersMapped || bubblePlot);
        this.ShowMkrCheckBox.setEnabled(this.showMarkerVisibleWidget || !markersMapped && !bubblePlot);
        this.MkrClrLabel.setEnabled(constantColor && markersOn && !grpOn && nResp < 2);
        if (constantColor) {
            this.MkrClrPanel.setBackground(c);
        }
        this.MkrClrPanel.setEnabled(constantColor && markersOn && !grpOn && nResp < 2);
        this.MkrClrBtn.setEnabled(constantColor && markersOn && !grpOn && nResp < 2);
        this.MkrOLClrLabel.setEnabled(constantColor && outlinesOn && isAnOutlineShape && markersOn);
        this.MkrOLClrPanel.setBackground(olc);
        this.MkrOLClrBtn.setEnabled(constantColor && outlinesOn && isAnOutlineShape && markersOn);
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2015);
        if (o != null) {
            String s = o.toString();
            int n = this.ShapeCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                Object o2 = this.ShapeCombo.getItemAt(i);
                if (o2 == null) continue;
                if (o2 instanceof Number && o instanceof Number && ((Number)o2).intValue() == ((Number)o).intValue()) {
                    match = true;
                } else if (s.equalsIgnoreCase(o2.toString())) {
                    match = true;
                }
                if (!match) continue;
                this.ShapeCombo.setSelectedIndex(i);
                break;
            }
        }
        this.MkrOutlineCB.setEnabled(isAnOutlineShape && markersOn && isFillOn);
        this.MkrShadowCB.setEnabled(markersOn && isFillOn && isFillableShape);
        this.MkrOutlineCB.setSelected(outlinesOn);
        this.MkrShadowCB.setSelected(shadowsOn);
        this.MkrFillCB.setEnabled(isFillableShape && markersOn && !markersMapped);
        this.MkrFillCB.setSelected(isFillOn);
        this.MkrSizeLabel.setEnabled(constantSize && markersOn && sizable && !autoSize && !bubblePlot);
        this.autoSizeMkrCB.setEnabled(constantSize && markersOn && sizable && !bubblePlot);
        this.autoSizeMkrCB.setSelected(autoSize);
        this.MkrSizeSlider.setEnabled(constantSize && markersOn && sizable && !autoSize && !bubblePlot);
        if (constantSize) {
            double min = this.getNumericProperty(this.propListeners, 2008, 2.0);
            double max = this.getNumericProperty(this.propListeners, 2009, 25.0);
            int sliderMin = this.MkrSizeSlider.getMinimum();
            int sliderMax = this.MkrSizeSlider.getMaximum();
            int sliderValue = (int)((double)(sliderMax - sliderMin) * (size - min) / (max - min) + (double)sliderMin);
            sliderValue = sliderValue < sliderMin ? sliderMin : sliderValue;
            sliderValue = sliderValue > sliderMax ? sliderMax : sliderValue;
            this.MkrSizeSlider.setValue(sliderValue);
            this.sliderArgs[0] = new Integer((int)size);
            this.MkrSizeLabel.setText(MessageFormat.format(this.sliderPattern, this.sliderArgs));
        }
        scatterPanel = this;
        synchronized (scatterPanel) {
            this.internalUpdate = false;
        }
    }

    protected int findJoinStyleEntry(Object obj) {
        int idx = -1;
        int n = 0;
        String s = null;
        if (this.JoinLineCombo == null || obj == null) {
            return -1;
        }
        if (obj instanceof String) {
            s = (String)obj;
        } else if (obj instanceof Number) {
            idx = ((Number)obj).intValue();
        } else {
            return -1;
        }
        n = this.JoinLineCombo.getItemCount();
        for (int i = 0; i < n; ++i) {
            JoinEntry je = (JoinEntry)this.JoinLineCombo.getItemAt(i);
            if (je == null) continue;
            if (idx >= 0 && je.style == idx) {
                return i;
            }
            if (s == null || !s.equalsIgnoreCase(je.s)) continue;
            return i;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateJoinLineSettings() {
        boolean joinLinesAreOn = false;
        boolean areaFillIsOn = false;
        boolean groupsPresent = false;
        Color c = null;
        ScatterPanel scatterPanel = this;
        synchronized (scatterPanel) {
            this.internalUpdate = true;
        }
        groupsPresent = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2005) != null;
        int nResp = (int)this.getNumericProperty(this.propListeners, 2058, 0.0);
        areaFillIsOn = this.getBooleanProperty(this.propListeners, 2023, false);
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2020);
        int i = this.findJoinStyleEntry(o);
        i = Math.max(i, 0);
        if (i < this.JoinLineCombo.getItemCount()) {
            this.JoinLineCombo.setSelectedIndex(i);
        }
        joinLinesAreOn = this.JoinLineCombo.getSelectedIndex() != 0;
        this.JoinThicknessLabel.setEnabled(joinLinesAreOn);
        i = (int)this.getNumericProperty(this.propListeners, 2022, 1.0);
        if (i >= 1 && i <= this.JoinThicknessCombo.getItemCount()) {
            this.JoinThicknessCombo.setSelectedIndex(i - 1);
        }
        this.JoinThicknessCombo.setEnabled(joinLinesAreOn);
        this.JoinLineColorLabel.setEnabled(joinLinesAreOn && !groupsPresent && nResp < 2);
        c = this.getColorProperty(this.propListeners, 2021, Color.black);
        this.JoinLineColorPanel.setBackground(c);
        this.JoinLineColorBtn.setEnabled(joinLinesAreOn && !groupsPresent && nResp < 2);
        this.AreaFillCB.setSelected(areaFillIsOn);
        this.AreaFillCB.setEnabled(joinLinesAreOn);
        this.AreaFillPanel.setBackground(this.getColorProperty(this.propListeners, 2024, c));
        this.AreaFillClrLabel.setEnabled(areaFillIsOn && joinLinesAreOn && !groupsPresent && nResp < 2);
        this.AreaFillBtn.setEnabled(areaFillIsOn && joinLinesAreOn && !groupsPresent && nResp < 2);
        scatterPanel = this;
        synchronized (scatterPanel) {
            this.internalUpdate = false;
        }
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            if (this.ShapeCombo.getItemCount() <= 0) {
                this.fillShapeCombo();
            }
            this.updateMarkerSettings();
            this.updateJoinLineSettings();
            if (!this.isVisible()) {
                this.MkrOutlineCB.addActionListener(this);
                this.MkrShadowCB.addActionListener(this);
                this.MkrFillCB.addActionListener(this);
                this.MkrClrBtn.addActionListener(this);
                this.MkrOLClrBtn.addActionListener(this);
                this.ShowMkrCheckBox.addActionListener(this);
                this.JoinLineColorBtn.addActionListener(this);
                this.JoinThicknessCombo.addActionListener(this);
                this.AreaFillCB.addActionListener(this);
                this.AreaFillBtn.addActionListener(this);
                this.MkrSizeSlider.addChangeListener(this);
                this.autoSizeMkrCB.addActionListener(this);
                this.ShapeCombo.addActionListener(this);
                this.JoinLineCombo.addActionListener(this);
            }
        } else {
            this.ShapeCombo.removeAllItems();
            this.MkrOutlineCB.removeActionListener(this);
            this.MkrShadowCB.removeActionListener(this);
            this.MkrFillCB.removeActionListener(this);
            this.MkrClrBtn.removeActionListener(this);
            this.MkrOLClrBtn.removeActionListener(this);
            this.ShowMkrCheckBox.removeActionListener(this);
            this.JoinLineColorBtn.removeActionListener(this);
            this.JoinThicknessCombo.removeActionListener(this);
            this.AreaFillCB.removeActionListener(this);
            this.AreaFillBtn.removeActionListener(this);
            this.MkrSizeSlider.removeChangeListener(this);
            this.autoSizeMkrCB.removeActionListener(this);
            this.ShapeCombo.removeActionListener(this);
            this.JoinLineCombo.removeActionListener(this);
        }
        super.setVisible(show);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Color c = null;
        JComboBox box = null;
        JCheckBox check = null;
        JButton button = null;
        JoinEntry je = null;
        if (this.internalUpdate) {
            return;
        }
        if (source == null) {
            return;
        }
        if (source instanceof JComboBox) {
            box = (JComboBox)source;
            Object obj = box.getSelectedItem();
            if (obj == null) {
                return;
            }
            if (box.equals(this.ShapeCombo)) {
                if (obj instanceof Number && ((Number)obj).intValue() == 7 || obj instanceof String && ((String)obj).equals("Image")) {
                    obj = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2016);
                }
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2015, (Object)obj);
                this.updateMarkerSettings();
                return;
            } else if (box.equals(this.JoinLineCombo)) {
                je = (JoinEntry)box.getSelectedItem();
                if (je == null) {
                    return;
                }
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2020, (Object)new Integer(je.style));
                this.updateJoinLineSettings();
                return;
            } else {
                if (!box.equals(this.JoinThicknessCombo)) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2022, (Object)new Integer(box.getSelectedIndex() + 1));
            }
            return;
        } else if (source instanceof JCheckBox) {
            check = (JCheckBox)source;
            boolean status = check.isSelected();
            if (check.equals(this.MkrOutlineCB)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2018, (Object)new Boolean(status));
                this.updateMarkerSettings();
                return;
            } else if (check.equals(this.MkrShadowCB)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2054, (Object)new Boolean(status));
                this.updateMarkerSettings();
                return;
            } else if (check.equals(this.MkrFillCB)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2017, (Object)new Boolean(status));
                if (!status) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2054, (Object)new Boolean(false));
                }
                this.updateMarkerSettings();
                return;
            } else if (check.equals(this.ShowMkrCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2036, (Object)new Boolean(status));
                this.updateMarkerSettings();
                return;
            } else if (check.equals(this.autoSizeMkrCB)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2007, (Object)new Boolean(status));
                this.updateMarkerSettings();
                return;
            } else {
                if (!check.equals(this.AreaFillCB)) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2023, (Object)new Boolean(status));
                this.updateJoinLineSettings();
            }
            return;
        } else {
            if (!(source instanceof JButton)) return;
            button = (JButton)source;
            if (button == this.MkrClrBtn) {
                c = this.showColorChooserDialog(this.getColorProperty(this.propListeners, 2013, Color.black));
                if (c == null) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2013, (Object)c);
                this.MkrClrPanel.setBackground(c);
                return;
            } else if (button == this.MkrOLClrBtn) {
                c = this.getColorProperty(this.propListeners, 2013, Color.black);
                if ((c = this.showColorChooserDialog(this.getColorProperty(this.propListeners, 2019, c))) == null) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2019, (Object)c);
                this.MkrOLClrPanel.setBackground(c);
                return;
            } else if (button == this.JoinLineColorBtn) {
                c = this.showColorChooserDialog(this.getColorProperty(this.propListeners, 2021, Color.black));
                if (c == null) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2021, (Object)c);
                this.updateJoinLineSettings();
                return;
            } else {
                if (button != this.AreaFillBtn || (c = this.showColorChooserDialog(this.getColorProperty(this.propListeners, 2024, Color.black))) == null) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2024, (Object)c);
                this.AreaFillPanel.setBackground(c);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.internalUpdate) {
            return;
        }
        if (source == this.MkrSizeSlider) {
            int min = this.MkrSizeSlider.getMinimum();
            int max = this.MkrSizeSlider.getMaximum();
            int v = this.MkrSizeSlider.getValue();
            double mkrMin = this.getNumericProperty(this.propListeners, 2008, 2.0);
            double mkrMax = this.getNumericProperty(this.propListeners, 2009, 2.0);
            int newSize = (int)Math.round((double)(v - min) / (double)(max - min) * (mkrMax - mkrMin) + mkrMin);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2006, (Object)new Integer(newSize));
            this.sliderArgs[0] = new Integer(newSize);
            this.MkrSizeLabel.setText(MessageFormat.format(this.sliderPattern, this.sliderArgs));
        }
    }

    @Override
    public boolean applyChanges() {
        boolean status = PropertyUtils.applyChanges((Vector)this.propListeners);
        this.updateMarkerSettings();
        this.updateJoinLineSettings();
        return status;
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    class JoinEntry {
        public int style;
        public String s;

        public JoinEntry(String name, int styleIn) {
            this.style = styleIn;
            this.s = name;
        }

        public String toString() {
            return this.s;
        }
    }
}

