/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SortDecorator;
import com.sas.graphics.util.Extract;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class RoleSelectionTable
extends JComponent
implements TableModel,
ActionListener {
    private static final long serialVersionUID = -5355987141772975425L;
    RoleInterface chart;
    Vector tableModelListeners = new Vector();
    JTable table;
    DataFilterReadInterface data;
    Object[] allRoles;
    Object[] continuousRoles;
    JComponent component = null;
    boolean allowMultipleRoleAssignments = true;
    SortDecorator decorator = null;
    JComboBox statsChooser = null;
    Image up = null;
    Image down = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    Roles roles;
    Object dataId = null;
    RoleCellEditor roleEditor = null;
    Object currentVar = null;
    GlobalDefaults silkDefaults = new GlobalDefaults();
    private Object[] responseList = null;
    private Object[] nonResponseList = null;
    private Vector disableReassignmentRoles = new Vector();
    private JPanel controlsPanel = null;

    public RoleSelectionTable(RoleInterface r, JComponent component) {
        this.chart = r;
        this.component = component;
        this.table = new JTable();
        this.table.setFont(TabbedPropertiesDialog.dialogFont);
        this.roles = Roles.getInstance(null);
        Object[] dataIds = this.chart.getDataIds();
        if (dataIds != null) {
            for (int id = 0; id < dataIds.length; ++id) {
                if (this.chart.getDataSource(dataIds[id]) == null) continue;
                this.dataId = dataIds[id];
                break;
            }
        }
        Object o = this.chart.getDataSource(this.dataId);
        this.data = FilterFactory.getDataSourceFilter((Object)o);
        this.decorator = new SortDecorator(this);
        this.table.setModel(this.decorator);
        this.decorator.sort(0);
        JTableHeader header = this.table.getTableHeader();
        header.setFont(TabbedPropertiesDialog.dialogFont);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                TableColumnModel tcm = RoleSelectionTable.this.table.getColumnModel();
                int vc = tcm.getColumnIndexAtX(me.getX());
                int mc = RoleSelectionTable.this.table.convertColumnIndexToModel(vc);
                int i = RoleSelectionTable.this.decorator.currentSort == 1 ? 0 : 1;
                RoleSelectionTable.this.decorator.sort(mc, i);
                for (int j = 0; j < RoleSelectionTable.this.decorator.getColumnCount(); ++j) {
                    TableColumn col = RoleSelectionTable.this.table.getColumnModel().getColumn(j);
                    ((HeaderRenderer)col.getHeaderRenderer()).repaint();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.buildCellEditors();
        this.add("Center", new JScrollPane(this.table));
        this.initStatsChooser();
        this.up = ResourceLoader.getImage((Component)this, (String)"icons/ascendingIcon.gif");
        this.down = ResourceLoader.getImage((Component)this, (String)"icons/descendingIcon.gif");
        for (int i = 0; i < this.decorator.getColumnCount(); ++i) {
            TableColumn col = this.table.getColumnModel().getColumn(i);
            col.setHeaderRenderer(new HeaderRenderer(this.up, this.down));
            col.setCellRenderer(new CellRenderer());
        }
    }

    public void dispose() {
        this.chart = null;
        if (this.tableModelListeners != null) {
            this.tableModelListeners.clear();
        }
        this.tableModelListeners = null;
        this.table = null;
        FilterFactory.detachFilter((DataFilterReadInterface)this.data);
        this.allRoles = null;
        this.continuousRoles = null;
        this.component = null;
        this.decorator = null;
        this.statsChooser = null;
        this.roleEditor = null;
    }

    private Object getStatisticType(RoleInterface chart) {
        Object statType = chart.getVariable((Object)this.roles.getRoleObject("ROLE_STATISTIC_TYPE"));
        if (statType == null && chart instanceof PropertyInterface) {
            statType = ((PropertyInterface)chart).getPropertyValue(60);
        }
        return statType;
    }

    private boolean initStatsChooser() {
        if (this.statsChooser != null) {
            return false;
        }
        Object statType = this.getStatisticType(this.chart);
        if (statType != null) {
            this.responseList = new Object[]{new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Sum.txt", (String)"Sum"), "Sum"), new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Mean.txt", (String)"Mean"), "Mean")};
            this.nonResponseList = new Object[]{new SILKNumber(12, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Frequency.txt", (String)"Frequency"), "Frequency"), new SILKNumber(11, ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Percent.txt", (String)"Percent"), "Percent")};
            this.statsChooser = new JComboBox<Object>(this.responseList);
            this.statsChooser.setBackground(Color.white);
            this.statsChooser.setFont(TabbedPropertiesDialog.dialogFont);
            this.statsChooser.addActionListener(this);
            this.statsChooser.setPreferredSize(new Dimension(this.statsChooser.getPreferredSize().width * 2, this.statsChooser.getPreferredSize().height));
            JPanel pan = new JPanel(new FlowLayout(0));
            JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Response_statistic.txt", (String)"Response statistic:"));
            label.setFont(TabbedPropertiesDialog.dialogFont);
            pan.add(label);
            pan.add(this.statsChooser);
            this.controlsPanel = new JPanel(new BorderLayout());
            this.controlsPanel.add((Component)pan, "North");
            this.add("South", this.controlsPanel);
            Object[] list = null;
            this.statsChooser.removeAllItems();
            list = this.chart.getVariable((Object)this.roles.getRoleObject("ROLE_RESPONSE")) == null ? this.nonResponseList : this.responseList;
            this.statsChooser.removeActionListener(this);
            int selIndex = -1;
            for (int i = 0; i < list.length; ++i) {
                this.statsChooser.addItem(list[i]);
                if (list[i] == null || !statType.toString().equalsIgnoreCase(list[i].toString())) continue;
                selIndex = i;
            }
            this.statsChooser.addActionListener(this);
            this.statsChooser.setSelectedIndex(selIndex);
            return true;
        }
        return false;
    }

    public void stopEditing() {
        this.roleEditor.stopCellEditing();
        this.table.repaint();
    }

    public void setDataId(Object id) {
        this.dataId = id;
        this.updateFromSource();
    }

    private void buildCellEditors() {
        int i;
        TableColumn tc = this.table.getColumn(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Role.txt", (String)"Role"));
        JComboBox<Object> cCombo = new JComboBox<Object>();
        cCombo.setBackground(Color.white);
        cCombo.setFont(TabbedPropertiesDialog.dialogFont);
        JComboBox<Object> dCombo = new JComboBox<Object>();
        dCombo.setBackground(Color.white);
        dCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.allRoles = this.chart.getSupportedRoles(this.dataId, true);
        this.continuousRoles = this.chart.getSupportedRoles(this.dataId, false);
        if (this.allRoles == null || this.continuousRoles == null) {
            return;
        }
        Vector<Object> contVars = new Vector<Object>();
        if (this.continuousRoles != null) {
            for (i = 0; i < this.continuousRoles.length; ++i) {
                contVars.addElement(this.continuousRoles[i]);
            }
        }
        cCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.None.txt", (String)"None"));
        dCombo.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.None.txt", (String)"None"));
        for (i = 0; i < this.allRoles.length; ++i) {
            cCombo.addItem(this.allRoles[i]);
            if (contVars.contains(this.allRoles[i])) continue;
            dCombo.addItem(this.allRoles[i]);
        }
        this.roleEditor = new RoleCellEditor(dCombo, cCombo, this.table);
        tc.setCellEditor(this.roleEditor);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.statsChooser) {
            if (this.statsChooser == null || this.statsChooser.getSelectedItem() == null) {
                return;
            }
            SILKNumber statRole = this.roles.getRoleObject("ROLE_STATISTIC_TYPE");
            Object type = this.statsChooser.getSelectedItem();
            this.chart.setRole(type, (Object)statRole);
            Object statType = this.chart.getVariable((Object)statRole);
            if (statType == null && this.chart instanceof PropertyInterface) {
                ((PropertyInterface)this.chart).setPropertyValue(60, type);
            }
        }
    }

    public void updateStatistic(String type) {
        if (this.statsChooser != null) {
            this.statsChooser.setSelectedItem(type);
        }
    }

    public boolean isMultipleRoleAssignmentAllowed() {
        return this.allowMultipleRoleAssignments;
    }

    public void setAllowMultipleRoleAssignment(boolean allow) {
        this.allowMultipleRoleAssignments = allow;
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        if (tml != null && !this.tableModelListeners.contains(tml)) {
            this.tableModelListeners.addElement(tml);
        }
    }

    public Class getColumnClass(int col) {
        return String.class;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int col) {
        String rc = null;
        switch (col) {
            case 0: {
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Variable.txt", (String)"Variable");
                break;
            }
            case 1: {
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Role.txt", (String)"Role");
                break;
            }
            case 2: {
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Type.txt", (String)"Type");
                break;
            }
            case 3: {
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Description.txt", (String)"Description");
                break;
            }
            case 4: {
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Format.txt", (String)"Format");
            }
        }
        return rc;
    }

    @Override
    public int getRowCount() {
        if (this.data == null) {
            return 0;
        }
        return this.data.getNumberVariables();
    }

    private boolean contains(Object[] arr, String s) {
        if (arr == null) {
            return false;
        }
        for (int i = 0; i < arr.length; ++i) {
            if (!arr[i].toString().equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object rc = "test";
        Object var = null;
        switch (col) {
            case 0: {
                rc = this.data.getVariableId(row);
                break;
            }
            case 1: {
                Object o = this.chart.getRole(this.data.getVariableId(row));
                String s = "";
                if (o != null) {
                    Enumeration e = Extract.elements((Object)o);
                    boolean isFirst = true;
                    while (e.hasMoreElements()) {
                        String str = e.nextElement().toString();
                        if (!this.contains(this.chart.getSupportedRoles(this.dataId, true), str) && !this.contains(this.disableReassignmentRoles.toArray(), str)) continue;
                        if (isFirst) {
                            s = s + str;
                            isFirst = false;
                            continue;
                        }
                        s = s + "," + str;
                    }
                }
                rc = s;
                break;
            }
            case 2: {
                var = this.data.getVariableId(row);
                if (this.data.isNumericVariable(var)) {
                    rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Numeric.txt", (String)"Numeric");
                    break;
                }
                rc = ResourceLoader.getResourceString((Object)this.rb, (String)"RoleSelectionTable.Character.txt", (String)"Character");
                break;
            }
            case 3: {
                rc = "";
                var = this.data.getVariableId(row);
                if (this.data.getVariableDescription(var) == null) break;
                rc = this.data.getVariableDescription(var);
                break;
            }
            case 4: {
                rc = "";
                Object format = this.data.getFormat(this.data.getVariableId(row), String.class);
                rc = format == null ? "" : format.toString();
            }
        }
        return rc;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            return !this.isDisabledRole(this.getValueAt(row, col));
        }
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener tml) {
        this.tableModelListeners.remove(tml);
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        if (col != 1) {
            return;
        }
        Object old = this.getValueAt(row, col);
        if (old != null && old.toString().length() > 0) {
            this.chart.removeRole(this.getValueAt(row, 0), old);
        }
        if (this.allowMultipleRoleAssignments) {
            int[] rows = this.table.getSelectedRows();
            if (rows.length > 1) {
                Object[] vars = new Object[rows.length];
                for (int i = 0; i < rows.length; ++i) {
                    vars[i] = this.table.getValueAt(rows[i], 0);
                }
                this.chart.addRole(vars, val);
            } else {
                this.chart.addRole(this.getValueAt(row, 0), val);
            }
        } else {
            this.chart.setRole(this.getValueAt(row, 0), val);
        }
        if (this.component != null) {
            this.component.repaint();
        }
        this.fireTableModelChanged();
        this.buildStatsChooser();
        this.buildCellEditors();
        this.decorator.sort(this.decorator.sortedCol, this.decorator.currentSort);
        this.repaint();
    }

    private void buildStatsChooser() {
        if (this.statsChooser != null) {
            Object s = this.getStatisticType(this.chart);
            this.statsChooser.removeAllItems();
            Object[] list = null;
            list = this.chart.getVariable((Object)this.roles.getRoleObject("ROLE_RESPONSE")) == null ? this.nonResponseList : this.responseList;
            int selIndex = -1;
            for (int i = 0; i < list.length; ++i) {
                this.statsChooser.addItem(list[i]);
                if (list[i] == null || s == null || !s.toString().equalsIgnoreCase(list[i].toString())) continue;
                selIndex = i;
            }
            this.statsChooser.setSelectedIndex(selIndex);
        } else if (this.initStatsChooser()) {
            this.revalidate();
            this.repaint();
        }
    }

    private void fireTableModelChanged() {
        TableModelEvent evt = new TableModelEvent(this);
        for (int i = 0; i < this.tableModelListeners.size(); ++i) {
            ((TableModelListener)this.tableModelListeners.elementAt(i)).tableChanged(evt);
        }
    }

    public void updateFromSource() {
        Object o;
        Object object = o = this.dataId == null ? this.chart.getDataSource() : this.chart.getDataSource(this.dataId);
        if (this.data != null) {
            FilterFactory.detachFilter((DataFilterReadInterface)this.data);
        }
        this.data = FilterFactory.getDataSourceFilter((Object)o);
        this.buildStatsChooser();
        this.buildCellEditors();
        this.fireTableModelChanged();
        this.decorator.sort(this.decorator.sortedCol, this.decorator.currentSort);
    }

    public void disableRoleReassignment(Object role) {
        if (!this.disableReassignmentRoles.contains(role)) {
            this.disableReassignmentRoles.add(role);
        }
    }

    private boolean isDisabledRole(Object r) {
        if (r != null && this.disableReassignmentRoles.size() > 0) {
            for (int i = 0; i < this.disableReassignmentRoles.size(); ++i) {
                Object role = this.disableReassignmentRoles.elementAt(i);
                Enumeration e = Extract.elements((Object)r);
                while (e.hasMoreElements()) {
                    if (role == null || !role.equals(e.nextElement())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void initControlPanel(Vector actions) {
        if (actions == null || actions.size() == 0) {
            return;
        }
        JPanel actionsPanel = new JPanel(new FlowLayout(0));
        for (int i = 0; i < actions.size(); ++i) {
            Object o = actions.elementAt(i);
            if (!(o instanceof AbstractAction)) continue;
            JButton jb = new JButton((AbstractAction)o);
            actionsPanel.add(jb);
        }
        if (this.controlsPanel != null) {
            this.controlsPanel.add((Component)actionsPanel, "South");
        } else {
            this.controlsPanel = new JPanel(new BorderLayout());
            this.controlsPanel.add((Component)actionsPanel, "South");
            this.add((Component)this.controlsPanel, "South");
        }
    }

    class HeaderRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = -6931870395712620187L;
        Image up = null;
        Image down = null;
        int index = -1;

        public HeaderRenderer(Image up, Image down) {
            this.setBorder(BorderFactory.createRaisedBevelBorder());
            this.up = up;
            this.down = down;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            this.index = vColIndex;
            this.setText(value.toString());
            this.setToolTipText((String)value);
            if (RoleSelectionTable.this.decorator.sortedCol == vColIndex) {
                if (RoleSelectionTable.this.decorator.currentSort == 0 && this.up != null) {
                    this.setIcon(new ImageIcon(this.up));
                } else if (this.down != null) {
                    this.setIcon(new ImageIcon(this.down));
                }
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            if (RoleSelectionTable.this.decorator.sortedCol == this.index) {
                if (RoleSelectionTable.this.decorator.currentSort == 0) {
                    this.setIcon(new ImageIcon(this.up));
                } else {
                    this.setIcon(new ImageIcon(this.down));
                }
            } else {
                this.setIcon(null);
            }
            super.paint(g);
        }
    }

    class CellRenderer
    extends DefaultTableCellRenderer {
        CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 1) {
                this.setEnabled(!RoleSelectionTable.this.isDisabledRole(value));
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    class RoleCellEditor
    extends AbstractCellEditor
    implements ActionListener,
    TableCellEditor {
        private static final long serialVersionUID = -1557668967351400863L;
        JComboBox discrete;
        JComboBox continuous;
        JComboBox current;
        JTable table;

        RoleCellEditor(JComboBox d, JComboBox c, JTable table) {
            this.discrete = d;
            this.discrete.addActionListener(this);
            this.continuous = c;
            this.continuous.addActionListener(this);
            this.table = table;
        }

        @Override
        public boolean shouldSelectCell(EventObject arg0) {
            return true;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            TableModel model = table.getModel();
            RoleSelectionTable.this.currentVar = model.getValueAt(row, 0);
            Object val = model.getValueAt(row, 2);
            this.current = val.toString().equals(ResourceLoader.getResourceString((Object)RoleSelectionTable.this.rb, (String)"RoleSelectionTable.Character.txt", (String)"Character")) ? this.discrete : this.continuous;
            if (value == null || value.toString().length() == 0) {
                this.current.setSelectedItem(ResourceLoader.getResourceString((Object)RoleSelectionTable.this.rb, (String)"RoleSelectionTable.None.txt", (String)"None"));
            } else {
                ComboBoxModel cModel = this.current.getModel();
                for (int i = 0; i < cModel.getSize(); ++i) {
                    if (!cModel.getElementAt(i).toString().equals(value.toString())) continue;
                    this.current.setSelectedIndex(i);
                }
            }
            return this.current;
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.stopCellEditing();
            this.table.repaint();
        }

        @Override
        public Object getCellEditorValue() {
            return this.current.getSelectedItem();
        }
    }
}

