/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;

public class RoleInfoPanel
extends JComponent
implements ItemListener,
ActionListener {
    private static final long serialVersionUID = -9123701368742016656L;
    RoleInterface chart = null;
    JComponent component = null;
    JComboBox roleCombo = new JComboBox();
    JCheckBox discrete = new JCheckBox();
    JComboBox sort = new JComboBox();
    public String DATA_ORDER = "Data Order";
    public String ASCENDING = "Ascending";
    public String DESCENDING = "Descending";

    public RoleInfoPanel(RoleInterface chart, JComponent component) {
        this.chart = chart;
        this.component = component;
        this.initGUI();
        this.fillRoles();
        this.updateControls();
        this.roleCombo.addItemListener(this);
        this.sort.addItemListener(this);
        this.discrete.addActionListener(this);
    }

    private void updateControls() {
        Object role = this.roleCombo.getSelectedItem();
        if (this.chart == null) {
            return;
        }
        this.discrete.setSelected(this.chart.isDiscrete(role));
        Object o = this.chart.getSortOrder(role);
        if (o != null) {
            if (o.equals(RoleInterface.ROLE_SORT_ASCENDING)) {
                this.sort.setSelectedItem(this.ASCENDING);
            } else if (o.equals(RoleInterface.ROLE_SORT_DATA)) {
                this.sort.setSelectedItem(this.DATA_ORDER);
            } else if (o.equals(RoleInterface.ROLE_SORT_DESCENDING)) {
                this.sort.setSelectedItem(this.DESCENDING);
            }
        }
    }

    private void fillRoles() {
        if (this.roleCombo == null || this.chart == null) {
            return;
        }
        Object[] list = this.chart.getSupportedRoles(null, true);
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.length; ++i) {
            this.roleCombo.addItem(list[i]);
        }
    }

    private void initGUI() {
        this.setLayout(null);
        JLabel label = new JLabel("Role:");
        label.setBounds(10, 10, 50, 25);
        label.setFont(TabbedPropertiesDialog.dialogFont);
        this.add(label);
        this.roleCombo.setBounds(50, 10, 350, 25);
        this.roleCombo.setBackground(Color.white);
        this.roleCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.add(this.roleCombo);
        JSeparator sep = new JSeparator();
        sep.setBounds(10, 40, 405, 2);
        this.add(sep);
        this.discrete.setText("Discrete");
        this.discrete.setBounds(25, 45, 85, 25);
        this.discrete.setFont(TabbedPropertiesDialog.dialogFont);
        this.add(this.discrete);
        label = new JLabel("Sort order:");
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(30, 75, 75, 25);
        this.add(label);
        this.sort.setBounds(110, 75, 200, 25);
        this.sort.setFont(TabbedPropertiesDialog.dialogFont);
        this.sort.setBackground(Color.white);
        this.sort.addItem(this.DESCENDING);
        this.sort.addItem(this.DATA_ORDER);
        this.sort.addItem(this.ASCENDING);
        this.add(this.sort);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.roleCombo) {
            this.updateControls();
        } else if (e.getSource() == this.sort && this.chart != null) {
            if (this.sort.getSelectedItem().equals(this.ASCENDING)) {
                this.chart.setSortOrder(this.roleCombo.getSelectedItem(), RoleInterface.ROLE_SORT_ASCENDING);
            } else if (this.sort.getSelectedItem().equals(this.DATA_ORDER)) {
                this.chart.setSortOrder(this.roleCombo.getSelectedItem(), RoleInterface.ROLE_SORT_DATA);
            } else if (this.sort.getSelectedItem().equals(this.DESCENDING)) {
                this.chart.setSortOrder(this.roleCombo.getSelectedItem(), RoleInterface.ROLE_SORT_DESCENDING);
            }
        }
        if (this.component != null) {
            this.component.repaint();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.discrete && this.chart != null) {
            this.chart.setDiscrete(this.roleCombo.getSelectedItem(), this.discrete.isSelected());
        }
        if (this.component != null) {
            this.component.repaint();
        }
    }
}

