/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.ui.ColorRampPanel;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ResourceBundle;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class RampView
extends JComponent
implements ActionListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = -6361762560248265367L;
    private ColorRampPanel rampPanel = null;
    private Break selectedBreak = null;
    private int selectedIndex = -1;
    private JButton missingButton = null;
    private JButton underButton = null;
    private JButton overButton = null;
    private JPanel missingPreview = null;
    private JPanel underPreview = null;
    private JPanel overPreview = null;
    private JTextField minVal = null;
    private JTextField maxVal = null;
    private Break[] breaks = null;
    private JButton addBreak = null;
    private JButton removeBreak = null;
    private JButton addException = null;
    private JButton removeException = null;
    private int rampXStartPixel = 20;
    private int rampWidth = 250;
    static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public RampView(ColorInterface rampIn) {
        this.rampPanel = new ColorRampPanel(rampIn);
        this.rampPanel.addMouseListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.missingButton) {
            Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Missing_Color.txt", (String)"Missing Color"), this.missingPreview.getBackground());
            if (c != null) {
                this.missingPreview.setBackground(c);
                this.rampPanel.getRamp().setMissingColor(c);
            }
        } else if (source == this.underButton) {
            Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Underflow_Color.txt", (String)"Underflow Color"), this.underPreview.getBackground());
            if (c != null) {
                this.underPreview.setBackground(c);
                this.rampPanel.getRamp().setUnderflowColor(c);
            }
        } else if (source == this.overButton) {
            Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Overflow_Color.txt", (String)"Overflow Color"), this.overPreview.getBackground());
            if (c != null) {
                this.overPreview.setBackground(c);
                this.rampPanel.getRamp().setOverflowColor(c);
            }
        } else if (source == this.addBreak) {
            ColorInterface ramp = this.rampPanel.getRamp();
            Object[] obj = ramp.getBreaks();
            AddPanel panel = null;
            panel = obj != null ? new AddPanel(((Number)obj[0]).doubleValue(), ((Number)obj[obj.length - 1]).doubleValue()) : new AddPanel(0.0, 1.0);
            int result = JOptionPane.showConfirmDialog(this, panel, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Pick_a_value.txt", (String)"Pick a value"), 2);
            if (result == 0) {
                double value = panel.getValue();
                if (Double.isNaN(value)) {
                    return;
                }
                Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Break_Color.txt", (String)"Break Color"), this.overPreview.getBackground());
                ramp.setBreakPoint(-3, new Double(value), c);
            }
            this.breaks = null;
            this.updateRamp();
        } else if (source == this.removeBreak) {
            int iVal;
            ColorInterface ramp = this.rampPanel.getRamp();
            Object[] objs = ramp.getBreaks();
            if (objs == null) {
                return;
            }
            JRadioButton[] checks = new JRadioButton[objs.length];
            ButtonGroup bg = new ButtonGroup();
            for (int i = 0; i < objs.length; ++i) {
                checks[i] = new JRadioButton(objs[i].toString());
                bg.add(checks[i]);
            }
            if (this.selectedIndex >= 0 && this.selectedIndex < checks.length) {
                checks[this.selectedIndex].setSelected(true);
            }
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            for (int i = 0; i < checks.length; ++i) {
                panel.add(checks[i]);
            }
            if (checks.length == 0) {
                panel.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.There_are_no_breakpoints_to_remove.txt", (String)"There are no breakpoints to remove")));
            }
            if ((iVal = JOptionPane.showOptionDialog(this, panel, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Choose_Breakpoints_to_delete.txt", (String)"Choose Breakpoints to delete"), 2, 3, null, null, null)) == 0 && checks.length > 2) {
                for (int i = 0; i < checks.length; ++i) {
                    if (!checks[i].isSelected()) continue;
                    ramp.removeBreakPoint(-3, Double.valueOf(checks[i].getText()), false);
                }
                this.breaks = null;
                this.updateRamp();
            }
        } else if (source == this.addException) {
            ColorInterface ramp = this.rampPanel.getRamp();
            Object[] obj = ramp.getBreaks();
            if (obj == null) {
                return;
            }
            AddPanel panel = new AddPanel(((Number)obj[0]).doubleValue(), ((Number)obj[obj.length - 1]).doubleValue());
            int result = JOptionPane.showConfirmDialog(this, panel, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Pick_a_value.txt", (String)"Pick a value"), 2);
            if (result == 0) {
                double value = panel.getValue();
                if (Double.isNaN(value)) {
                    return;
                }
                Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Break_Color.txt", (String)"Break Color"), this.overPreview.getBackground());
                ramp.setExceptionBreakPoint(-3, new Double(value), c);
            }
            this.updateRamp();
        } else if (source == this.removeException) {
            ColorInterface ramp = this.rampPanel.getRamp();
            Object[] objs = ramp.getExceptions();
            JPanel panel = new JPanel();
            panel.setLayout(new BoxLayout(panel, 1));
            if (objs == null) {
                panel.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.There_are_no_Exceptions_to_remove.txt", (String)"There are no Exceptions to remove")));
                JOptionPane.showConfirmDialog(this, panel, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Remove_Exception.txt", (String)"Remove Exception"), 2);
            } else {
                int i;
                JRadioButton[] checks = new JRadioButton[objs.length];
                ButtonGroup bg = new ButtonGroup();
                for (i = 0; i < objs.length; ++i) {
                    checks[i] = new JRadioButton(objs[i].toString());
                    bg.add(checks[i]);
                }
                for (i = 0; i < checks.length; ++i) {
                    panel.add(checks[i]);
                }
                JOptionPane optionPane = new JOptionPane(panel, 3, 2);
                JDialog dialog = optionPane.createDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Choose_an_Exception_to_delete.txt", (String)"Choose an Exception to delete"));
                dialog.setVisible(true);
                for (int i2 = 0; i2 < checks.length; ++i2) {
                    if (!checks[i2].isSelected()) continue;
                    ramp.removeExceptionBreakPoint(-3, Double.valueOf(checks[i2].getText()), false);
                }
            }
            this.updateRamp();
        }
    }

    @Override
    public void addNotify() {
        this.missingButton = new JButton();
        this.missingButton.setText("...");
        this.missingButton.setBounds(180, 10, 20, 20);
        this.missingButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.missingButton.addActionListener(this);
        this.underButton = new JButton();
        this.underButton.setText("...");
        this.underButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.underButton.setBounds(180, 32, 20, 20);
        this.underButton.addActionListener(this);
        this.overButton = new JButton();
        this.overButton.setText("...");
        this.overButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.overButton.setBounds(180, 54, 20, 20);
        this.overButton.addActionListener(this);
        this.missingPreview = new JPanel();
        this.missingPreview.setBounds(new Rectangle(100, 10, 80, 20));
        this.underPreview = new JPanel();
        this.underPreview.setBounds(new Rectangle(100, 32, 80, 20));
        this.overPreview = new JPanel();
        this.overPreview.setBounds(new Rectangle(100, 54, 80, 20));
        this.rampPanel.setBounds(new Rectangle(this.rampXStartPixel, 85, this.rampWidth, 50));
        this.minVal = new JTextField();
        this.minVal.setEditable(false);
        this.minVal.setFont(TabbedPropertiesDialog.dialogFont);
        this.minVal.setBounds(100, 167, 100, 20);
        this.maxVal = new JTextField();
        this.maxVal.setEditable(false);
        this.maxVal.setFont(TabbedPropertiesDialog.dialogFont);
        this.maxVal.setBounds(100, 194, 100, 20);
        this.addBreak = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Add_Breakpoint.txt", (String)"Add Breakpoint"));
        this.addBreak.setFont(TabbedPropertiesDialog.dialogFont);
        this.addBreak.setBounds(10, 230, 135, 25);
        this.addBreak.addActionListener(this);
        this.removeBreak = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Remove_Breakpoint.txt", (String)"Remove Breakpoint"));
        this.removeBreak.setFont(TabbedPropertiesDialog.dialogFont);
        this.removeBreak.setBounds(10, 260, 135, 25);
        this.removeBreak.addActionListener(this);
        this.addException = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Add_Exception.txt", (String)"Add Exception"));
        this.addException.setFont(TabbedPropertiesDialog.dialogFont);
        this.addException.setBounds(150, 230, 135, 25);
        this.addException.addActionListener(this);
        this.removeException = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Remove_Exception.txt", (String)"Remove Exception"));
        this.removeException.setFont(TabbedPropertiesDialog.dialogFont);
        this.removeException.setBounds(150, 260, 135, 25);
        this.removeException.addActionListener(this);
        this.updateRamp();
        super.addNotify();
    }

    public void updateRamp() {
        this.rampPanel.updateImage();
        ColorInterface ramp = this.rampPanel.getRamp();
        this.removeAll();
        this.setLayout(null);
        this.add(this.missingButton);
        this.add(this.missingPreview);
        this.add(this.underPreview);
        this.add(this.underButton);
        this.add(this.overPreview);
        this.add(this.overButton);
        this.add(this.rampPanel);
        this.add(this.minVal);
        this.add(this.maxVal);
        this.add(this.addBreak);
        this.add(this.removeBreak);
        this.add(this.addException);
        this.add(this.removeException);
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Missing_Color.txt", (String)"Missing Color"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(new Rectangle(10, 10, 85, 20));
        this.add(label);
        this.missingPreview.setBackground(ramp.getMissingColor());
        label = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Underflow_Color.txt", (String)"Underflow Color"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(new Rectangle(10, 32, 85, 20));
        this.add(label);
        this.underPreview.setBackground(ramp.getUnderflowColor());
        label = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Overflow_Color.txt", (String)"Overflow Color"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(new Rectangle(10, 54, 85, 20));
        this.add(label);
        this.overPreview.setBackground(ramp.getOverflowColor());
        if (this.breaks == null) {
            this.createBreaks(ramp);
        }
        if (this.breaks != null) {
            for (int i = 0; i < this.breaks.length; ++i) {
                this.add(this.breaks[i]);
                if (this.selectedIndex <= 0 || this.breaks.length <= this.selectedIndex) continue;
                this.selectedBreak = this.breaks[this.selectedIndex];
            }
        }
        label = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Min._Value.txt", (String)"Min. Value"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(10, 165, 85, 20);
        this.add(label);
        if (this.breaks != null) {
            this.minVal.setText("" + this.breaks[0].value);
        }
        label = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Max_Value.txt", (String)"Max Value"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(10, 192, 85, 20);
        this.add(label);
        if (this.breaks != null) {
            this.maxVal.setText("" + this.breaks[this.breaks.length - 1].value);
        }
    }

    private void createBreaks(ColorInterface ramp) {
        if (ramp == null || ramp.getBreaks() == null) {
            return;
        }
        this.breaks = new Break[ramp.getBreaks().length];
        Object[] rampBreaks = ramp.getBreaks();
        int width = this.rampPanel.getWidth();
        int xStart = this.rampPanel.getX();
        int yStart = this.rampPanel.getY() + this.rampPanel.getHeight();
        double dataMin = ((Number)rampBreaks[0]).doubleValue();
        double dataMax = ((Number)rampBreaks[rampBreaks.length - 1]).doubleValue();
        for (int i = 0; i < this.breaks.length; ++i) {
            double val = ((Number)rampBreaks[i]).doubleValue();
            this.breaks[i] = new Break(val, ramp.queryDouble(val, false, null));
            double percent = (val - dataMin) / (dataMax - dataMin);
            int x = xStart + (int)((double)width * percent);
            this.breaks[i].setBounds(new Rectangle(x - 5, yStart, 10, 15));
            this.breaks[i].addMouseListener(this);
            this.breaks[i].addMouseMotionListener(this);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        ColorInterface ramp = this.rampPanel.getRamp();
        Object[] obj = ramp.getExceptions();
        Color[] clrs = ramp.getExceptionColors();
        Object[] breaks = ramp.getBreaks();
        if (obj == null || clrs == null) {
            return;
        }
        int width = this.rampPanel.getWidth();
        int xStart = this.rampPanel.getX();
        int yStart = this.rampPanel.getY();
        int yEnd = this.rampPanel.getY() + this.rampPanel.getHeight();
        double dataMin = ((Number)breaks[0]).doubleValue();
        double dataMax = ((Number)breaks[breaks.length - 1]).doubleValue();
        for (int i = 0; i < obj.length; ++i) {
            double val = ((Number)obj[i]).doubleValue();
            double percent = (val - dataMin) / (dataMax - dataMin);
            int x = xStart + (int)((double)width * percent);
            g.setColor(clrs[i]);
            g.drawLine(x, yStart, x, yEnd);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(500, 200);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            if (this.selectedBreak != null) {
                this.selectedBreak.setSelected(false);
            }
            if (e.getSource() instanceof Break) {
                Break source = (Break)e.getSource();
                Color color = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Break_Color.txt", (String)"Break Color"), this.overPreview.getBackground());
                if (color != null) {
                    Object[] b = this.rampPanel.getRamp().getBreaks();
                    Color[] c = this.rampPanel.getRamp().getColors();
                    b[this.selectedIndex] = new Double(source.value);
                    c[this.selectedIndex] = color;
                    this.rampPanel.getRamp().setColors(c, b);
                    this.breaks = null;
                    this.updateRamp();
                    this.repaint();
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int val;
        if (e.getButton() == 1) {
            if (this.selectedBreak != null) {
                this.selectedBreak.setSelected(false);
            }
            if (e.getSource() instanceof Break) {
                Break source = (Break)e.getSource();
                source.setSelected(true);
                this.selectedBreak = source;
                for (int i = 0; i < this.breaks.length; ++i) {
                    if (source.value != this.breaks[i].value) continue;
                    this.selectedIndex = i;
                }
                this.repaint();
            }
        } else if (e.getSource() == this.rampPanel && (val = e.getX()) != 0 && val != this.rampWidth) {
            double d = (double)e.getPoint().x / (double)this.rampWidth;
            double dataRange = this.breaks[this.breaks.length - 1].value - this.breaks[0].value;
            d = d * dataRange + this.breaks[0].value;
            Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Break_Color.txt", (String)"Break Color"), this.overPreview.getBackground());
            this.rampPanel.getRamp().setBreakPoint(-3, new Double(d), c);
            this.breaks = null;
            this.updateRamp();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.selectedIndex == 0 || this.selectedIndex == this.breaks.length - 1) {
            return;
        }
        if (this.selectedBreak != null) {
            int xStartPixel = this.rampXStartPixel;
            int xEndPixel = this.rampXStartPixel + this.rampWidth;
            int xPixel = this.selectedBreak.getX() + e.getX();
            double percent = ((double)xPixel - (double)xStartPixel) / ((double)xEndPixel - (double)xStartPixel);
            double dataRange = this.breaks[this.breaks.length - 1].value - this.breaks[0].value;
            double newVal = this.breaks[0].value + dataRange * percent;
            newVal = Math.min(this.breaks[this.selectedIndex + 1].value, newVal);
            newVal = Math.max(this.breaks[this.selectedIndex - 1].value, newVal);
            Object[] b = this.rampPanel.getRamp().getBreaks();
            Color[] c = this.rampPanel.getRamp().getColors();
            b[this.selectedIndex] = new Double(newVal);
            this.selectedBreak.setValue(newVal);
            this.rampPanel.getRamp().setColors(c, b);
            double pct = (newVal - this.breaks[0].value) / (this.breaks[this.breaks.length - 1].value - this.breaks[0].value);
            int x = xStartPixel + (int)((double)this.rampWidth * pct);
            this.selectedBreak.setBounds(new Rectangle(x - 5, this.rampPanel.getY() + this.rampPanel.getHeight(), 10, 15));
            this.updateRamp();
            this.repaint();
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    class Break
    extends JPanel {
        private static final long serialVersionUID = -5763721073984315940L;
        private double value;
        Color color;
        Font myFont = FontManager.getFont((String)"Dialog", (int)0, (int)6);
        boolean isSelected = false;

        public Break(double value, Color c) {
            this.value = value;
            this.setToolTipText("" + value);
            this.color = c;
        }

        public void setValue(double v) {
            this.value = v;
            this.setToolTipText("" + this.value);
        }

        public void setSelected(boolean sel) {
            this.isSelected = sel;
        }

        @Override
        public void paint(Graphics g) {
            int width = this.getWidth();
            int height = this.getHeight();
            int[] x = new int[]{width / 2, width, 0};
            int[] y = new int[]{0, height - 2, height - 2};
            g.setColor(this.color);
            g.fillPolygon(x, y, 3);
            if (this.isSelected) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.black);
            }
            g.drawPolygon(x, y, 3);
        }
    }

    class DoubleDocument
    extends PlainDocument {
        private static final long serialVersionUID = 5201578489000048936L;
        double min;
        double max;
        Component parent;
        String currentDoc = "";

        public DoubleDocument(double minIn, double maxIn, Component parentComponent) {
            this.min = minIn;
            this.max = maxIn;
            this.parent = parentComponent;
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String temp = null;
            try {
                String start = this.currentDoc.length() > offs ? this.currentDoc.substring(0, offs) : this.currentDoc;
                String end = this.currentDoc.length() > offs ? this.currentDoc.substring(offs) : "";
                temp = start + str + end;
                if (temp.endsWith(".")) {
                    temp = temp + "0";
                }
                Double.parseDouble(temp);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(this.parent, ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Must_enter_a_number.txt", (String)"Must enter a number"));
                return;
            }
            this.currentDoc = temp;
            super.insertString(offs, str, a);
        }
    }

    class AddPanel
    extends JPanel {
        private static final long serialVersionUID = 9137243158268850971L;
        JTextField textField = new JTextField();

        public AddPanel(double min, double max) {
            this.textField.setDocument(new DoubleDocument(min, max, this));
            this.setLayout(new BorderLayout());
            this.add("West", new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"ColorRampEditor.Please_enter_a_value.txt", (String)"Please enter a value:")));
            this.add("Center", this.textField);
        }

        public double getValue() {
            double rc = Double.NaN;
            try {
                rc = Double.valueOf(this.textField.getText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return rc;
        }
    }
}

