/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.MenuUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;

public class OverlayPanel
extends JPanel
implements TabPanelInterface,
ListCellRenderer {
    private static final long serialVersionUID = 3032115623961488780L;
    private JList jList = null;
    private BaseElementComponent overlay = null;
    private JPanel renderer = new JPanel();
    private JLabel jLabel = null;
    private JPanel jPanel = null;
    private JButton jButton = null;
    private JSeparator jSeparator = null;
    private JPopupMenu jPopupMenu = null;
    private JMenuItem jMenuItem = null;
    private JMenuItem jMenuItem1 = null;
    private JSeparator jSeparator1 = null;
    private JMenuItem jMenuItem2 = null;
    private JMenuItem jMenuItem3 = null;
    private JSeparator jSeparator2 = null;
    private JCheckBoxMenuItem jCheckBoxMenuItem = null;
    private ImageIcon imageIcon = null;
    private JMenuItem jMenuItem4 = null;
    private String primaryChart = null;
    private String[] chartIds = null;
    private BaseElement[] charts = null;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public boolean applyChanges() {
        for (int i = 0; i < this.charts.length; ++i) {
            this.charts[i].setId(this.chartIds[i]);
        }
        this.overlay.setPrimary(this.primaryChart);
        this.overlay.setChartOrder(this.chartIds);
        return true;
    }

    @Override
    public boolean cancelChanges() {
        this.initFromSource();
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    public OverlayPanel(BaseElementComponent overlay) {
        this.overlay = overlay;
        this.initialize();
        this.initFromSource();
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.jLabel.setText("JLabel");
        this.renderer.setLayout(new BorderLayout());
        this.renderer.setSize(173, 47);
        this.renderer.setBackground(Color.white);
        this.renderer.add((Component)this.jLabel, "Center");
        this.setLayout(new BorderLayout());
        this.setSize(413, 335);
        this.add((Component)this.getJList(), "Center");
        this.renderer.add((Component)this.getJPanel(), "East");
        this.renderer.add((Component)this.getJSeparator(), "South");
    }

    private void initFromSource() {
        if (this.overlay == null) {
            return;
        }
        this.charts = this.overlay.getCharts();
        this.getJList().setListData(this.charts);
        if (this.overlay != null && this.overlay.getPrimary() != null) {
            this.primaryChart = this.overlay.getPrimary().getId().toString();
        }
        this.chartIds = new String[this.charts.length];
        for (int i = 0; i < this.charts.length; ++i) {
            this.chartIds[i] = this.charts[i].getId().toString();
        }
    }

    private JList getJList() {
        if (this.jList == null) {
            this.jList = new JList();
            this.jList.setCellRenderer(this);
            this.jList.setSelectionMode(0);
            this.jList.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int my;
                    int mx;
                    int h;
                    int selectedCell = OverlayPanel.this.jList.getSelectedIndex();
                    if (selectedCell < 0) {
                        return;
                    }
                    Rectangle cellBounds = OverlayPanel.this.jList.getCellBounds(selectedCell, selectedCell);
                    int x = OverlayPanel.this.jList.getWidth() - OverlayPanel.this.jButton.getWidth();
                    int w = OverlayPanel.this.imageIcon.getIconWidth();
                    int y = cellBounds.y + cellBounds.height - OverlayPanel.this.jButton.getHeight();
                    Rectangle bounds = new Rectangle(x, y, w, h = OverlayPanel.this.imageIcon.getIconHeight());
                    if (bounds.contains(mx = e.getX(), my = e.getY())) {
                        BaseElement element = (BaseElement)OverlayPanel.this.jList.getModel().getElementAt(selectedCell);
                        OverlayPanel.this.getJCheckBoxMenuItem().setSelected(element.getId().equals(OverlayPanel.this.primaryChart));
                        OverlayPanel.this.getJPopupMenu().show(OverlayPanel.this.jList, x, y + h);
                    }
                    super.mousePressed(e);
                }
            });
        }
        return this.jList;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        SILKChartInfo info = SILKChartInfo.getInstance(value);
        this.jLabel.setText(this.chartIds[index]);
        if (info != null) {
            this.jLabel.setIcon(new ImageIcon(info.getImage()));
        }
        return this.renderer;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBackground(Color.white);
            this.jPanel.add((Component)this.getJButton(), "South");
        }
        return this.jPanel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.imageIcon = new ImageIcon(this.getClass().getResource("/icons/button_View.gif"));
            this.jButton.setIcon(this.imageIcon);
            this.jButton.setContentAreaFilled(false);
            this.jButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 10));
            this.jButton.setOpaque(false);
        }
        return this.jButton;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    private JPopupMenu getJPopupMenu() {
        if (this.jPopupMenu == null) {
            this.jPopupMenu = new JPopupMenu();
            this.jPopupMenu.setSize(136, 158);
            this.jPopupMenu.add(this.getJMenuItem());
            this.jPopupMenu.add(this.getJMenuItem1());
            this.jPopupMenu.add(this.getJSeparator1());
            this.jPopupMenu.add(this.getJMenuItem2());
            this.jPopupMenu.add(this.getJMenuItem3());
            this.jPopupMenu.add(this.getJSeparator2());
            this.jPopupMenu.add(this.getJMenuItem4());
            this.jPopupMenu.add(this.getJCheckBoxMenuItem());
            MenuUtilities.setFontOnMenu(this.jPopupMenu, UIUtilities.getSILKDialogFont());
        }
        return this.jPopupMenu;
    }

    private JMenuItem getJMenuItem() {
        if (this.jMenuItem == null) {
            this.jMenuItem = new JMenuItem();
            this.jMenuItem.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayPanel.MoveUp.txt", (String)"Move up"));
            this.jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selected = OverlayPanel.this.jList.getSelectedIndex();
                    if (selected == 0) {
                        return;
                    }
                    OverlayPanel.this.swap(OverlayPanel.this.charts, selected, selected - 1);
                    OverlayPanel.this.swap(OverlayPanel.this.chartIds, selected, selected - 1);
                    OverlayPanel.this.getJList().setListData(OverlayPanel.this.charts);
                }
            });
        }
        return this.jMenuItem;
    }

    private void swap(Object[] array, int index1, int index2) {
        if (array == null || index1 < 0 || index2 < 0 || index1 >= array.length || index2 >= array.length) {
            return;
        }
        Object temp = array[index1];
        array[index1] = array[index2];
        array[index2] = temp;
    }

    private JMenuItem getJMenuItem1() {
        if (this.jMenuItem1 == null) {
            this.jMenuItem1 = new JMenuItem();
            this.jMenuItem1.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayPanel.MoveDown.txt", (String)"Move down"));
            this.jMenuItem1.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selected = OverlayPanel.this.jList.getSelectedIndex();
                    OverlayPanel.this.swap(OverlayPanel.this.charts, selected, selected + 1);
                    OverlayPanel.this.swap(OverlayPanel.this.chartIds, selected, selected + 1);
                    OverlayPanel.this.getJList().setListData(OverlayPanel.this.charts);
                }
            });
        }
        return this.jMenuItem1;
    }

    private JSeparator getJSeparator1() {
        if (this.jSeparator1 == null) {
            this.jSeparator1 = new JSeparator();
        }
        return this.jSeparator1;
    }

    private JMenuItem getJMenuItem2() {
        if (this.jMenuItem2 == null) {
            this.jMenuItem2 = new JMenuItem();
            this.jMenuItem2.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayPanel.MoveToTop.txt", (String)"Move to top"));
            this.jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selected = OverlayPanel.this.jList.getSelectedIndex();
                    String id = OverlayPanel.this.chartIds[selected];
                    BaseElement chart = OverlayPanel.this.charts[selected];
                    for (int i = selected; i >= 1; --i) {
                        ((OverlayPanel)OverlayPanel.this).charts[i] = OverlayPanel.this.charts[i - 1];
                        ((OverlayPanel)OverlayPanel.this).chartIds[i] = OverlayPanel.this.chartIds[i - 1];
                    }
                    ((OverlayPanel)OverlayPanel.this).charts[0] = chart;
                    ((OverlayPanel)OverlayPanel.this).chartIds[0] = id;
                    OverlayPanel.this.getJList().setListData(OverlayPanel.this.charts);
                }
            });
        }
        return this.jMenuItem2;
    }

    private JMenuItem getJMenuItem3() {
        if (this.jMenuItem3 == null) {
            this.jMenuItem3 = new JMenuItem();
            this.jMenuItem3.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayPanel.MoveToBottom.txt", (String)"Move to bottom"));
            this.jMenuItem3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int selected = OverlayPanel.this.jList.getSelectedIndex();
                    String id = OverlayPanel.this.chartIds[selected];
                    BaseElement chart = OverlayPanel.this.charts[selected];
                    for (int i = selected; i < OverlayPanel.this.charts.length - 1; ++i) {
                        ((OverlayPanel)OverlayPanel.this).charts[i] = OverlayPanel.this.charts[i + 1];
                        ((OverlayPanel)OverlayPanel.this).chartIds[i] = OverlayPanel.this.chartIds[i + 1];
                    }
                    ((OverlayPanel)OverlayPanel.this).charts[((OverlayPanel)OverlayPanel.this).charts.length - 1] = chart;
                    ((OverlayPanel)OverlayPanel.this).chartIds[((OverlayPanel)OverlayPanel.this).charts.length - 1] = id;
                    OverlayPanel.this.getJList().setListData(OverlayPanel.this.charts);
                }
            });
        }
        return this.jMenuItem3;
    }

    private JSeparator getJSeparator2() {
        if (this.jSeparator2 == null) {
            this.jSeparator2 = new JSeparator();
        }
        return this.jSeparator2;
    }

    private JCheckBoxMenuItem getJCheckBoxMenuItem() {
        if (this.jCheckBoxMenuItem == null) {
            this.jCheckBoxMenuItem = new JCheckBoxMenuItem();
            this.jCheckBoxMenuItem.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayPanel.PrimaryChart.txt", (String)"Primary chart"));
            this.jCheckBoxMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    BaseElement element = (BaseElement)OverlayPanel.this.getJList().getSelectedValue();
                    OverlayPanel.this.primaryChart = element.getId().toString();
                }
            });
        }
        return this.jCheckBoxMenuItem;
    }

    private JMenuItem getJMenuItem4() {
        if (this.jMenuItem4 == null) {
            this.jMenuItem4 = new JMenuItem();
            this.jMenuItem4.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"OverlayPanel.Rename.txt", (String)"Rename..."));
            this.jMenuItem4.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseElement element = (BaseElement)OverlayPanel.this.jList.getSelectedValue();
                    Object result = JOptionPane.showInputDialog(OverlayPanel.this.jList, ResourceLoader.getResourceString((Object)OverlayPanel.this.rb, (String)"OverlayPanel.RenameDialog.Message.txt", (String)"Enter a new chart ID"), ResourceLoader.getResourceString((Object)OverlayPanel.this.rb, (String)"OverlayPanel.RenameDialog.Title.txt", (String)"Rename"), 3, null, null, element.getId());
                    if (result != null) {
                        ((OverlayPanel)OverlayPanel.this).chartIds[((OverlayPanel)OverlayPanel.this).jList.getSelectedIndex()] = result.toString();
                    }
                    OverlayPanel.this.jList.repaint();
                }
            });
        }
        return this.jMenuItem4;
    }
}

