/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.util.ResourceLoader;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ResourceBundle;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

class NumericPlainDocument
extends PlainDocument {
    private static final long serialVersionUID = -7714692788026711448L;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected InsertErrorListener errorListener;
    protected DecimalFormat format;
    protected char decimalSeparator;
    protected char groupingSeparator;
    protected String positivePrefix;
    protected String negativePrefix;
    protected int positivePrefixLen;
    protected int negativePrefixLen;
    protected String positiveSuffix;
    protected String negativeSuffix;
    protected int positiveSuffixLen;
    protected int negativeSuffixLen;
    protected ParsePosition parsePos = new ParsePosition(0);
    protected static DecimalFormat defaultFormat = new DecimalFormat();

    public NumericPlainDocument() {
        this.setFormat(null);
    }

    public NumericPlainDocument(DecimalFormat format) {
        this.setFormat(format);
    }

    public NumericPlainDocument(AbstractDocument.Content content, DecimalFormat format) {
        super(content);
        this.setFormat(format);
        try {
            format.parseObject(content.getString(0, content.length()), this.parsePos);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(ResourceLoader.getResourceString((Object)this.rb, (String)"NumericTextField.Error.InitialContent.txt", (String)"Initial content not a valid number"));
        }
        if (this.parsePos.getIndex() != content.length() - 1) {
            throw new IllegalArgumentException(ResourceLoader.getResourceString((Object)this.rb, (String)"NumericTextField.Error.InitialContent.txt", (String)"Initial content not a valid number"));
        }
    }

    public void setFormat(DecimalFormat fmt) {
        this.format = fmt != null ? fmt : (DecimalFormat)defaultFormat.clone();
        this.decimalSeparator = this.format.getDecimalFormatSymbols().getDecimalSeparator();
        this.groupingSeparator = this.format.getDecimalFormatSymbols().getGroupingSeparator();
        this.positivePrefix = this.format.getPositivePrefix();
        this.positivePrefixLen = this.positivePrefix.length();
        this.negativePrefix = this.format.getNegativePrefix();
        this.negativePrefixLen = this.negativePrefix.length();
        this.positiveSuffix = this.format.getPositiveSuffix();
        this.positiveSuffixLen = this.positiveSuffix.length();
        this.negativeSuffix = this.format.getNegativeSuffix();
        this.negativeSuffixLen = this.negativeSuffix.length();
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public Number getNumberValue() throws ParseException {
        try {
            String content = this.getText(0, this.getLength());
            if (content.startsWith(".")) {
                content = "0" + content;
            }
            if (content.endsWith(".")) {
                content = content + "0";
            }
            this.parsePos.setIndex(0);
            Number result = this.format.parse(content, this.parsePos);
            if (this.parsePos.getIndex() != content.length()) {
                String ex = this.getMessage("NumericTextField.Error.NotValidNumberMsg.fmt.txt", "Not a valid number {0}", new Object[]{content});
                throw new ParseException(ex, 0);
            }
            return result;
        }
        catch (BadLocationException e) {
            String ex = ResourceLoader.getResourceString((Object)this.rb, (String)"NumericTextField.Error.NotValidNumber.txt", (String)"Not a valid number");
            throw new ParseException(ex, 0);
        }
    }

    protected String getMessage(String key, String defaultValue, Object[] arguments) {
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)key, (String)defaultValue);
        return MessageFormat.format(msg, arguments);
    }

    public Long getLongValue() throws ParseException {
        Number result = this.getNumberValue();
        if (!(result instanceof Long)) {
            String ex = ResourceLoader.getResourceString((Object)this.rb, (String)"NumericTextField.Error.NotValidLong.txt", (String)"Not a valid long number");
            throw new ParseException(ex, 0);
        }
        return (Long)result;
    }

    public Double getDoubleValue() throws ParseException {
        Number result = this.getNumberValue();
        if (!(result instanceof Long) && !(result instanceof Double)) {
            String ex = ResourceLoader.getResourceString((Object)this.rb, (String)"NumericTextField.Error.NotValidDouble.txt", (String)"Not a valid double number");
            throw new ParseException(ex, 0);
        }
        if (result instanceof Long) {
            result = new Double(result.doubleValue());
        }
        return (Double)result;
    }

    @Override
    public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
        block16: {
            String targetString;
            int originalLength;
            int length;
            block15: {
                int prefixLength;
                int suffixLength;
                String suffix;
                if (str == null || str.length() == 0) {
                    return;
                }
                AbstractDocument.Content content = this.getContent();
                originalLength = length = content.length();
                this.parsePos.setIndex(0);
                targetString = content.getString(0, offset) + str + content.getString(offset, length - offset - 1);
                boolean gotPositive = targetString.startsWith(this.positivePrefix);
                boolean gotNegative = targetString.startsWith(this.negativePrefix);
                length = targetString.length();
                if (!gotPositive && !gotNegative) break block15;
                if (gotPositive && gotNegative) {
                    if (this.positivePrefixLen > this.negativePrefixLen) {
                        gotNegative = false;
                    } else {
                        gotPositive = false;
                    }
                }
                if (gotPositive) {
                    suffix = this.positiveSuffix;
                    suffixLength = this.positiveSuffixLen;
                    prefixLength = this.positivePrefixLen;
                } else {
                    suffix = this.negativeSuffix;
                    suffixLength = this.negativeSuffixLen;
                    prefixLength = this.negativePrefixLen;
                }
                if (length == prefixLength) break block16;
                if (!targetString.endsWith(suffix)) {
                    int i;
                    for (i = suffixLength - 1; i > 0; --i) {
                        if (!targetString.regionMatches(length - i, suffix, 0, i)) continue;
                        targetString = targetString + suffix.substring(i);
                        break;
                    }
                    if (i == 0) {
                        targetString = targetString + suffix;
                    }
                    length = targetString.length();
                }
            }
            this.format.parse(targetString, this.parsePos);
            int endIndex = this.parsePos.getIndex();
            if (!(endIndex == length || this.positivePrefixLen > 0 && endIndex < this.positivePrefixLen && length <= this.positivePrefixLen && targetString.regionMatches(0, this.positivePrefix, 0, length) || this.negativePrefixLen > 0 && endIndex < this.negativePrefixLen && length <= this.negativePrefixLen && targetString.regionMatches(0, this.negativePrefix, 0, length))) {
                char lastChar = targetString.charAt(originalLength - 1);
                int decimalIndex = targetString.indexOf(this.decimalSeparator);
                if (!(this.format.isGroupingUsed() && lastChar == this.groupingSeparator && decimalIndex == -1 || !this.format.isParseIntegerOnly() && lastChar == this.decimalSeparator && decimalIndex == originalLength - 1)) {
                    if (this.errorListener != null) {
                        this.errorListener.insertFailed(this, offset, str, a);
                    }
                    return;
                }
            }
        }
        super.insertString(offset, str, a);
    }

    public void addInsertErrorListener(InsertErrorListener l) {
        if (this.errorListener == null) {
            this.errorListener = l;
            return;
        }
        throw new IllegalArgumentException(ResourceLoader.getResourceString((Object)this.rb, (String)"NumericTextField.Error.InsertErrorListener.txt", (String)"InsertErrorListener already registered"));
    }

    public void removeInsertErrorListener(InsertErrorListener l) {
        if (this.errorListener == l) {
            this.errorListener = null;
        }
    }

    public static interface InsertErrorListener {
        public void insertFailed(NumericPlainDocument var1, int var2, String var3, AttributeSet var4);
    }
}

