/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.data.StableHeapSort;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.table.ColumnHeaderRenderer;
import com.sas.graphics.util.Extract;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;

public class MultipleVarsRolePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -8980458438660289113L;
    private DataFilterReadInterface dataFilter = null;
    private RoleInterface ri = null;
    private SILKNumber role = null;
    private Vector listeners = null;
    private boolean discreteVars = true;
    private VarTableModel model = null;
    private ColumnHeaderRenderer[] headerRenderers = null;
    private MultipleVarsTableModel multipleVarsModel = null;
    private ImageIcon ascendingIcon = null;
    private ImageIcon descendingIcon = null;
    private final String ascendingIconPath = "icons/ascendingIcon.gif";
    private final String descendingIconPath = "icons/descendingIcon.gif";
    private ResourceBundle resourceBundle = null;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private JButton AssignButton;
    private JPanel ButtonPanel;
    private JPanel ControlButtonsPanel;
    private JButton UnAssignButton;
    private JPanel VarsPanel;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JButton moveUpButton;
    private JButton moveDownButton;
    private JTable varsTable;
    private JTable mVarsTable;
    private boolean pendingChanges = false;

    public MultipleVarsRolePanel(RoleInterface ri, SILKNumber role, DataFilterReadInterface filter, boolean discrete) {
        this.ri = ri;
        this.role = role;
        this.dataFilter = filter;
        this.listeners = new Vector();
        this.discreteVars = discrete;
        this.resourceBundle = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
        this.initComponents();
    }

    private void initComponents() {
        this.loadIcons();
        this.VarsPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.ButtonPanel = new JPanel();
        this.AssignButton = new JButton();
        this.UnAssignButton = new JButton();
        this.jScrollPane2 = new JScrollPane();
        this.ControlButtonsPanel = new JPanel();
        this.jPanel1 = new JPanel();
        this.applyButton = new JButton();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.varsTable = new JTable();
        this.mVarsTable = new JTable();
        this.setLayout(new BorderLayout());
        this.VarsPanel.setLayout(new GridBagLayout());
        JPanel jp1 = new JPanel(new BorderLayout(0, 4));
        this.model = new VarTableModel(this.dataFilter, this.discreteVars, null);
        this.varsTable.setModel(this.model);
        this.jScrollPane1.setViewportView(this.varsTable);
        this.headerRenderers = new ColumnHeaderRenderer[2];
        for (int i = 0; i < 2; ++i) {
            this.headerRenderers[i] = new ColumnHeaderRenderer(this.ascendingIcon, this.descendingIcon, null, this.varsTable);
            this.varsTable.getColumnModel().getColumn(i).setHeaderRenderer(this.headerRenderers[i]);
        }
        this.model.updateRendererState();
        this.varsTable.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int column = MultipleVarsRolePanel.this.varsTable.columnAtPoint(e.getPoint());
                int order = MultipleVarsRolePanel.this.model.getSortOrder(column);
                order = order == 1 ? -1 : 1;
                MultipleVarsRolePanel.this.model.setSortOrder(column, order);
            }
        });
        jp1.add(this.jScrollPane1);
        JTextField jtf1 = new JTextField();
        jtf1.setText(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"MultipleVarsRolePanel.AvailableVars.txt", (String)"Available Variables"));
        jtf1.setFont(TabbedPropertiesDialog.dialogFont.deriveFont(1));
        jtf1.setEditable(false);
        jtf1.setBorder(null);
        jp1.add((Component)jtf1, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 30.0;
        gridBagConstraints.weighty = 100.0;
        this.VarsPanel.add((Component)jp1, gridBagConstraints);
        this.ButtonPanel.setLayout(new GridBagLayout());
        this.AssignButton.setIcon(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/ArrowRightAdd.gif")));
        this.AssignButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.ButtonPanel.add((Component)this.AssignButton, gridBagConstraints);
        this.UnAssignButton.setIcon(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/ArrowLeftRemove.gif")));
        this.UnAssignButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 8, 0);
        this.ButtonPanel.add((Component)this.UnAssignButton, gridBagConstraints);
        this.moveUpButton.setIcon(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/uparrow.gif")));
        this.moveUpButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(16, 0, 4, 0);
        this.ButtonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveDownButton.setIcon(new ImageIcon(ResourceLoader.getImage((Component)this, (String)"icons/dnarrow.gif")));
        this.moveDownButton.addActionListener(this);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.ButtonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.weighty = 100.0;
        this.VarsPanel.add((Component)this.ButtonPanel, gridBagConstraints);
        JPanel jp2 = new JPanel(new BorderLayout(0, 4));
        this.multipleVarsModel = new MultipleVarsTableModel(this.dataFilter, this.ri, this.role);
        this.mVarsTable.setModel(this.multipleVarsModel);
        this.jScrollPane2.setViewportView(this.mVarsTable);
        jp2.add(this.jScrollPane2);
        this.model.updateModel(this.multipleVarsModel);
        JTextField jtf2 = new JTextField();
        jtf2.setText(this.role.toString());
        jtf2.setFont(TabbedPropertiesDialog.dialogFont.deriveFont(1));
        jtf2.setEditable(false);
        jtf2.setBorder(null);
        jp2.add((Component)jtf2, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 20.0;
        gridBagConstraints.weighty = 100.0;
        this.VarsPanel.add((Component)jp2, gridBagConstraints);
        this.add((Component)this.VarsPanel, "Center");
        this.ControlButtonsPanel.setLayout(new BorderLayout());
        this.jPanel1.setLayout(new GridLayout(1, 3, 4, 4));
        this.okButton.setText(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"MultipleVarsRolePanel.OK.txt", (String)"OK"));
        this.okButton.addActionListener(this);
        this.jPanel1.add(this.okButton);
        this.applyButton.setText(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"MultipleVarsRolePanel.Apply.txt", (String)"Apply"));
        this.applyButton.addActionListener(this);
        this.jPanel1.add(this.applyButton);
        this.cancelButton.setText(ResourceLoader.getResourceString((Object)this.resourceBundle, (String)"MultipleVarsRolePanel.Cancel.txt", (String)"Cancel"));
        this.cancelButton.addActionListener(this);
        this.jPanel1.add(this.cancelButton);
        this.ControlButtonsPanel.add((Component)this.jPanel1, "East");
        this.add((Component)this.ControlButtonsPanel, "Last");
    }

    @Override
    public void setVisible(boolean flag) {
        super.setVisible(flag);
        if (flag) {
            this.multipleVarsModel.updateModel(this.ri, this.role);
            this.model.updateModel(this.multipleVarsModel);
        }
    }

    public void setControlButtonsVisible(boolean visible) {
        if (!visible) {
            this.remove(this.ControlButtonsPanel);
        } else {
            this.add((Component)this.ControlButtonsPanel, "Last");
        }
    }

    private void loadIcons() {
        Image img = ResourceLoader.getImage((Component)this, (String)"icons/ascendingIcon.gif");
        if (img != null) {
            this.ascendingIcon = new ImageIcon(img);
        }
        if ((img = ResourceLoader.getImage((Component)this, (String)"icons/descendingIcon.gif")) != null) {
            this.descendingIcon = new ImageIcon(img);
        }
    }

    private void setPendingChanges(boolean pending) {
        this.pendingChanges = pending;
        Vector vars = this.getVars();
        if (vars == null || vars.size() < 2) {
            if (this.okButton != null) {
                this.okButton.setEnabled(false);
            }
            if (this.applyButton != null) {
                this.applyButton.setEnabled(false);
            }
        } else {
            if (this.okButton != null) {
                this.okButton.setEnabled(true);
            }
            if (this.applyButton != null) {
                this.applyButton.setEnabled(true);
            }
        }
        if (this.pendingChanges) {
            this.changes.firePropertyChange("ROLE_CHANGES_PENDING", null, this.getVars());
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.AssignButton) {
            int[] selIndices = this.varsTable.getSelectedRows();
            Object[] selectedVars = this.model.getSelectedVars(selIndices);
            this.multipleVarsModel.addVars(selectedVars);
            this.model.updateModel(this.multipleVarsModel);
            this.setPendingChanges(true);
        } else if (e.getSource() == this.UnAssignButton) {
            Vector<Object> matrixVars = new Vector<Object>();
            for (int i = 0; i < this.multipleVarsModel.getRowCount(); ++i) {
                if (this.mVarsTable.isRowSelected(i)) continue;
                matrixVars.add(this.multipleVarsModel.elementAt(i));
            }
            Object[] mVars = matrixVars.toArray();
            this.multipleVarsModel.updateModel(mVars);
            this.model.updateModel(this.multipleVarsModel);
            this.setPendingChanges(true);
        } else if (e.getSource() == this.applyButton) {
            this.applyRoles();
            this.fireActionEvent(1, "Apply");
        } else if (e.getSource() == this.cancelButton) {
            this.multipleVarsModel.updateModel(this.ri, this.role);
            this.model.updateModel(this.multipleVarsModel);
            this.varsTable.clearSelection();
            this.mVarsTable.clearSelection();
            this.fireActionEvent(2, "Cancel");
        } else if (e.getSource() == this.okButton) {
            this.applyRoles();
            this.fireActionEvent(3, "OK");
        } else if (e.getSource() == this.moveUpButton) {
            this.adjustOrder(-1);
            this.setPendingChanges(true);
        } else if (e.getSource() == this.moveDownButton) {
            this.adjustOrder(1);
            this.setPendingChanges(true);
        }
    }

    private void adjustOrder(int move) {
        Vector<Object> reorderedList = new Vector<Object>();
        int[] selectedIndices = this.mVarsTable.getSelectedRows();
        if (selectedIndices != null) {
            int i;
            Object[] selected = new Object[selectedIndices.length];
            for (i = 0; i < selectedIndices.length; ++i) {
                selected[i] = this.multipleVarsModel.elementAt(selectedIndices[i]);
            }
            for (i = 0; i < this.multipleVarsModel.getRowCount(); ++i) {
                if (this.mVarsTable.isRowSelected(i)) continue;
                reorderedList.addElement(this.multipleVarsModel.elementAt(i));
            }
            for (i = 0; i < selectedIndices.length; ++i) {
                if (move < 0 && selectedIndices[i] == 0) {
                    reorderedList.insertElementAt(this.multipleVarsModel.elementAt(0), 0);
                    continue;
                }
                if (move > 0 && selectedIndices[i] == this.multipleVarsModel.getRowCount() - 1) {
                    reorderedList.insertElementAt(this.multipleVarsModel.elementAt(this.multipleVarsModel.getRowCount() - 1), this.multipleVarsModel.getRowCount() - 1);
                    continue;
                }
                reorderedList.insertElementAt(this.multipleVarsModel.elementAt(selectedIndices[i]), selectedIndices[i] + move);
            }
            this.multipleVarsModel.updateModel(reorderedList.toArray());
            this.mVarsTable.clearSelection();
            for (i = 0; i < selected.length; ++i) {
                selectedIndices[i] = this.multipleVarsModel.indexOf(selected[i]);
                this.mVarsTable.addRowSelectionInterval(selectedIndices[i], selectedIndices[i]);
            }
        }
    }

    public Vector getVars() {
        Vector<Object> matrixVars = new Vector<Object>();
        for (int i = 0; i < this.multipleVarsModel.getRowCount(); ++i) {
            matrixVars.add(this.multipleVarsModel.elementAt(i));
        }
        return matrixVars;
    }

    public void applyRoles() {
        if (this.pendingChanges) {
            this.ri.setRole(this.getVars(), (Object)this.role);
        }
        this.varsTable.clearSelection();
        this.mVarsTable.clearSelection();
        this.pendingChanges = false;
    }

    public void addActionListener(ActionListener listener) {
        if (listener != null && this.listeners != null && !this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    public void removeActionListener(ActionListener listener) {
        if (listener != null && this.listeners != null) {
            this.listeners.removeElement(listener);
        }
    }

    private void fireActionEvent(int id, String actionCommand) {
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        ActionEvent e = new ActionEvent(this, id, actionCommand);
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(e);
        }
    }

    public void dispose() {
        this.dataFilter = null;
        this.ri = null;
        this.multipleVarsModel = null;
        if (this.model != null) {
            this.model.dispose();
        }
        if (this.multipleVarsModel != null) {
            this.multipleVarsModel.dispose();
        }
        this.headerRenderers = null;
        this.changes = null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }

    private class MultipleVarsTableModel
    extends DefaultTableModel {
        DataFilterReadInterface dataFilter = null;
        Vector varList = null;

        MultipleVarsTableModel(DataFilterReadInterface filter, RoleInterface ri, SILKNumber role) {
            this.dataFilter = filter;
            this.varList = new Vector();
            this.addVars(ri, role);
        }

        void addVars(RoleInterface ri, SILKNumber role) {
            if (ri != null && role != null) {
                Object roles = ri.getAllVariables((Object)role);
                Enumeration r = Extract.elements((Object)roles);
                while (r != null && r.hasMoreElements()) {
                    this.varList.addElement(r.nextElement());
                }
            }
            this.fireTableDataChanged();
        }

        void updateModel(RoleInterface ri, SILKNumber role) {
            this.varList.removeAllElements();
            this.addVars(ri, role);
        }

        void updateModel(Object[] vars) {
            this.varList.removeAllElements();
            this.addVars(vars);
        }

        void addVars(Object[] vars) {
            if (vars != null) {
                for (int i = 0; i < vars.length; ++i) {
                    if (this.varList.contains(vars[i])) continue;
                    this.varList.addElement(vars[i]);
                }
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return ResourceLoader.getResourceString((Object)MultipleVarsRolePanel.this.resourceBundle, (String)"MultipleVarsRolePanel.Name.txt", (String)"Name");
            }
            return ResourceLoader.getResourceString((Object)MultipleVarsRolePanel.this.resourceBundle, (String)"MultipleVarsRolePanel.Description.txt", (String)"Description");
        }

        @Override
        public int getRowCount() {
            if (this.varList == null) {
                return 0;
            }
            return this.varList.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.varList == null) {
                return null;
            }
            if (column == 0) {
                return this.varList.elementAt(row);
            }
            return this.dataFilter.getVariableDescription(this.varList.elementAt(row));
        }

        boolean contains(Object e) {
            return this.varList != null && this.varList.contains(e);
        }

        Object elementAt(int i) {
            if (this.varList != null) {
                return this.varList.elementAt(i);
            }
            return null;
        }

        int indexOf(Object e) {
            if (this.varList != null) {
                return this.varList.indexOf(e);
            }
            return -1;
        }

        void dispose() {
            if (this.varList != null) {
                this.varList.clear();
            }
            this.varList = null;
            this.dataFilter = null;
        }
    }

    class VarTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 6933854365510315320L;
        Vector varNames;
        Vector varDesc;
        int[] sortedIndices;
        int[] reverseIndices;
        int sortColumn = 0;
        int sortOrder = 1;
        DataFilterReadInterface filter = null;
        boolean discreteVars = true;

        VarTableModel(DataFilterReadInterface filter, boolean discreteVars, MultipleVarsTableModel excludeList) {
            this.filter = filter;
            this.discreteVars = discreteVars;
            this.updateModel(excludeList);
        }

        void updateModel(MultipleVarsTableModel excludeList) {
            if (this.filter != null) {
                Vector<Object> vars = new Vector<Object>();
                int nVars = this.filter.getNumberVariables();
                for (int i = 0; i < nVars; ++i) {
                    Object var = this.filter.getVariableId(i);
                    if (excludeList != null && excludeList.contains(var)) continue;
                    if (this.discreteVars) {
                        vars.addElement(var);
                        continue;
                    }
                    if (!this.filter.isNumericVariable(i)) continue;
                    vars.addElement(var);
                }
                this.setData(this.filter, vars);
                this.fireTableDataChanged();
            }
        }

        private void setData(DataFilterReadInterface filter, Vector vars) {
            int i;
            if (this.varNames != null) {
                this.varNames.clear();
            } else {
                this.varNames = new Vector();
            }
            this.varNames.addAll(vars);
            if (this.varDesc != null) {
                this.varDesc.clear();
            } else {
                this.varDesc = new Vector();
            }
            for (i = 0; i < this.varNames.size(); ++i) {
                this.varDesc.addElement(filter.getVariableDescription(this.varNames.elementAt(i)));
            }
            this.sortedIndices = new int[this.varNames.size()];
            this.reverseIndices = new int[this.varNames.size()];
            for (i = 0; i < this.varNames.size(); ++i) {
                this.sortedIndices[i] = this.reverseIndices[i] = i;
            }
            this.sort();
            this.updateRendererState();
        }

        int getSortOrder(int column) {
            if (this.sortColumn == column) {
                return this.sortOrder;
            }
            return -1;
        }

        void setSortOrder(int column, int order) {
            this.sortColumn = column;
            this.sortOrder = order;
            this.sort();
            this.updateRendererState();
            this.fireTableDataChanged();
        }

        void updateRendererState() {
            if (MultipleVarsRolePanel.this.headerRenderers == null) {
                return;
            }
            int otherColumn = (this.sortColumn + 1) % 2;
            MultipleVarsRolePanel.this.headerRenderers[otherColumn].setState(otherColumn, 0);
            int so = this.sortOrder == 1 ? 1 : 2;
            MultipleVarsRolePanel.this.headerRenderers[this.sortColumn].setState(this.sortColumn, so);
        }

        void sort() {
            if (this.sortColumn >= 0) {
                Vector list = null;
                if (this.sortColumn == 0) {
                    list = this.varNames;
                } else if (this.sortColumn == 1) {
                    list = this.varDesc;
                }
                StableHeapSort.heapSort(list, this.sortedIndices, this.sortOrder, 0, list.size() - 1);
                for (int i = 0; i < this.sortedIndices.length; ++i) {
                    this.reverseIndices[this.sortedIndices[i]] = i;
                }
            }
        }

        Object[] getSelectedVars(int[] selectedRows) {
            if (selectedRows == null || selectedRows.length == 0) {
                return null;
            }
            Object[] svars = new Object[selectedRows.length];
            for (int i = 0; i < selectedRows.length; ++i) {
                svars[i] = this.varNames.elementAt(this.sortedIndices[selectedRows[i]]);
            }
            return svars;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return ResourceLoader.getResourceString((Object)MultipleVarsRolePanel.this.resourceBundle, (String)"MultipleVarsRolePanel.Name.txt", (String)"Name");
            }
            return ResourceLoader.getResourceString((Object)MultipleVarsRolePanel.this.resourceBundle, (String)"MultipleVarsRolePanel.Description.txt", (String)"Description");
        }

        @Override
        public int getRowCount() {
            if (this.varNames == null) {
                return 0;
            }
            return this.varNames.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.varNames == null || this.varDesc == null) {
                return null;
            }
            Vector col = null;
            col = column == 0 ? this.varNames : this.varDesc;
            return col.elementAt(this.sortedIndices[row]);
        }

        void dispose() {
            if (this.varNames != null) {
                this.varNames.removeAllElements();
            }
            this.varNames = null;
            if (this.varDesc != null) {
                this.varDesc.removeAllElements();
            }
            this.varDesc = null;
            this.sortedIndices = null;
            this.reverseIndices = null;
            this.filter = null;
        }
    }
}

