/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.FilterFactory;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

public class MultiRoleSelectorDialog
extends JDialog
implements ActionListener,
MouseListener {
    private static final long serialVersionUID = -2994463630527305365L;
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    JLabel varLabel = new JLabel();
    JList avalibleRoles = new JList();
    JList assignedRoles = new JList();
    JButton addRole = null;
    JButton removeRole = null;
    Object currentVariable = null;
    JButton ok = null;
    RoleInterface chart = null;
    JComponent component = null;

    public MultiRoleSelectorDialog(RoleInterface chart, JComponent component) {
        this.chart = chart;
        this.component = component;
        this.addRole = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MultiRoleSelectionDialog.AddRole.txt", (String)">"));
        this.removeRole = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MultiRoleSelectionDialog.RemoveRole.txt", (String)"<"));
        this.ok = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"MultiRoleSelectionDialog.OK.txt", (String)"OK"));
        this.initGUI();
        this.addRole.addActionListener(this);
        this.removeRole.addActionListener(this);
        this.avalibleRoles.addMouseListener(this);
        this.assignedRoles.addMouseListener(this);
        this.setModal(true);
        this.setSize(600, 400);
        UIUtilities.center(this);
    }

    public void setVariable(Object var) {
        this.currentVariable = var;
        this.updateRoleLists();
    }

    private void updateRoleLists() {
        this.avalibleRoles.removeAll();
        this.assignedRoles.removeAll();
        this.varLabel.setText(this.currentVariable.toString() + ResourceLoader.getResourceString((Object)this.rb, (String)"MultiRoleSelectionDialog.Role_Assignments.txt", (String)" Role Assignments:"));
        Object src = this.chart.getDataSource();
        DataFilterReadInterface dfri = FilterFactory.getDataSourceFilter((Object)src);
        if (dfri == null) {
            return;
        }
        Vector<Object> allRoles = new Vector<Object>();
        boolean isNumeric = dfri.isNumericVariable(this.currentVariable);
        Object[] roles = this.chart.getSupportedRoles(null, true);
        for (int i = 0; i < roles.length; ++i) {
            allRoles.addElement(roles[i]);
        }
        if (!isNumeric) {
            Object[] numericOnlyRoles = this.chart.getSupportedRoles(null, false);
            for (int i = 0; i < numericOnlyRoles.length; ++i) {
                allRoles.remove(numericOnlyRoles[i]);
            }
        }
        Vector v = new Vector();
        Enumeration e = Extract.elements((Object)this.chart.getRole(this.currentVariable));
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            v.addElement(o);
            allRoles.remove(o);
        }
        this.assignedRoles.setListData(v);
        this.avalibleRoles.setListData(allRoles);
        this.avalibleRoles.setPreferredSize(new Dimension(256, 100));
        this.assignedRoles.setPreferredSize(new Dimension(256, 100));
        if (allRoles.isEmpty()) {
            this.addRole.setEnabled(false);
        } else {
            this.addRole.setEnabled(true);
        }
        if (v.isEmpty()) {
            this.removeRole.setEnabled(false);
        } else {
            this.removeRole.setEnabled(true);
        }
    }

    private void initGUI() {
        Container c = this.getContentPane();
        c.setLayout(new BorderLayout());
        JPanel panel = new JPanel(new BorderLayout());
        this.varLabel.setFont(TabbedPropertiesDialog.dialogFont);
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add("Center", this.varLabel);
        c.add("North", panel);
        panel = new JPanel(new BorderLayout());
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MultiRoleSelectionDialog.Assigned_roles.txt", (String)"Assigned roles"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add("North", label);
        panel.add("Center", new JScrollPane(this.assignedRoles));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.assignedRoles.setFont(TabbedPropertiesDialog.dialogFont);
        c.add("East", panel);
        panel = new JPanel(new BorderLayout());
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"MultiRoleSelectionDialog.Avalible_roles.txt", (String)"Avalible roles"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        panel.add("North", label);
        panel.add("Center", new JScrollPane(this.avalibleRoles));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.avalibleRoles.setFont(TabbedPropertiesDialog.dialogFont);
        c.add("West", panel);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(this.addRole);
        panel.add(this.removeRole);
        JPanel panel1 = new JPanel(new FlowLayout(1));
        panel1.add(panel);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.add(panel1);
        c.add("Center", panel2);
        JPanel panel3 = new JPanel(new FlowLayout(2));
        panel3.add(this.ok);
        this.ok.setFont(TabbedPropertiesDialog.dialogFont);
        this.ok.addActionListener(this);
        c.add("South", panel3);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.addRole) {
            this.chart.addRole(this.currentVariable, this.avalibleRoles.getSelectedValue());
        } else if (source == this.removeRole) {
            this.chart.removeRole(this.currentVariable, this.assignedRoles.getSelectedValue());
        } else if (source == this.ok) {
            this.setVisible(false);
        }
        this.component.repaint();
        this.updateRoleLists();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() == this.avalibleRoles && e.getClickCount() == 2) {
            int index = this.avalibleRoles.locationToIndex(e.getPoint());
            ListModel dlm = this.avalibleRoles.getModel();
            Object item = dlm.getElementAt(index);
            if (this.addRole.isEnabled()) {
                this.chart.addRole(this.currentVariable, item);
            }
            this.component.repaint();
            this.updateRoleLists();
        } else if (e.getSource() == this.assignedRoles && e.getClickCount() == 2) {
            int index = this.assignedRoles.locationToIndex(e.getPoint());
            ListModel dlm = this.assignedRoles.getModel();
            Object item = dlm.getElementAt(index);
            this.chart.removeRole(this.currentVariable, item);
            this.component.repaint();
            this.updateRoleLists();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

