/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class LineChartPanel
extends JPanel
implements ItemListener,
TabPanelInterface {
    private static final long serialVersionUID = 1L;
    protected static int BORDER = 8;
    protected static int GAP = 4;
    protected static int COLOR_PANE_WIDTH = 90;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected JCheckBox showLabelsCheckBox;
    protected JCheckBox skipMissCheckBox;
    protected JCheckBox honorDataValsForRespAxis;
    protected Vector propListeners = new Vector();

    public LineChartPanel() {
        this((PropertyInterface)null);
    }

    public LineChartPanel(PropertyInterface lineChart) {
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)lineChart);
        this.setSize(265, 410);
        this.layoutPanel();
        this.updatePanelUI(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (!(c instanceof JPanel)) continue;
            this.updatePanelUI((JComponent)c);
        }
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(2 * BORDER, BORDER, BORDER, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        JPanel skipMissPanel = this.makeSkipMissPanel();
        JPanel labelPanel = this.makeLabelPanel();
        JPanel honorMinDVPanel = this.makeHonorDataValuesPanel();
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        this.add(skipMissPanel);
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        this.add(labelPanel);
        this.add(Box.createRigidArea(new Dimension(0, GAP)));
        this.add(honorMinDVPanel);
    }

    protected JPanel makeSkipMissPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.skipMissCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LineChartPanel.SkipMissingValues.txt", (String)"Skip missing values"));
        panel.add(this.skipMissCheckBox);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    protected JPanel makeLabelPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.showLabelsCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LineChartPanel.ShowLabels.txt", (String)"Show labels"));
        panel.add(this.showLabelsCheckBox);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    protected JPanel makeHonorDataValuesPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.honorDataValsForRespAxis = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LineChartPanel.HonorDataValue.txt", (String)"Show labels"));
        panel.add(this.honorDataValsForRespAxis);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public void setInitialValues() {
        boolean on;
        Object obj = null;
        obj = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)19301);
        if (obj != null) {
            on = (Boolean)obj;
            this.skipMissCheckBox.setSelected(on);
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)19302)) != null) {
            on = (Boolean)obj;
            this.showLabelsCheckBox.setSelected(on);
        }
        if ((obj = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)19309)) != null) {
            on = (Boolean)obj;
            this.honorDataValsForRespAxis.setSelected(on);
        }
    }

    private void addListeners() {
        this.showLabelsCheckBox.addItemListener(this);
        this.skipMissCheckBox.addItemListener(this);
        this.honorDataValsForRespAxis.addItemListener(this);
    }

    private void removeListeners() {
        this.showLabelsCheckBox.removeItemListener(this);
        this.skipMissCheckBox.removeItemListener(this);
        this.honorDataValsForRespAxis.removeItemListener(this);
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.skipMissCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)19301, (Object)new Boolean(on));
        }
        if (source == this.showLabelsCheckBox) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)19302, (Object)new Boolean(on));
        }
        if (source == this.honorDataValsForRespAxis) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)19309, (Object)new Boolean(on));
        }
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propListeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }
}

