/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.LegendLayoutDialog;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.ColorParse;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LegendPanel
extends JPanel
implements ActionListener,
ChangeListener,
FocusListener,
TabPanelInterface {
    private static final long serialVersionUID = -2681557983899869887L;
    protected boolean internalUpdate = false;
    protected boolean listenersAdded = false;
    protected boolean hasChoices = false;
    protected JComboBox choiceCombo;
    protected JLabel choiceLabel;
    protected JPanel choicePanel;
    protected JCheckBox visibleBtn;
    protected JCheckBox insideBtn;
    protected JLabel posLabel;
    protected JComboBox posCombo;
    protected JPanel bkgPanel;
    protected JLabel bkgClrLabel;
    protected JLabel bkgOpacityLabel;
    protected JPanel bkgClrPanel;
    protected JButton bkgClrBtn;
    protected JSlider bkgOpacitySlider;
    protected TitledBorder bkgBorder;
    protected JPanel bdrPanel;
    protected JLabel bdrStyleLabel;
    protected JComboBox bdrStyleCombo;
    protected JLabel bdrClrLabel;
    protected JPanel bdrClrPanel;
    protected JButton bdrClrBtn;
    protected JCheckBox titleBtn;
    protected JPanel titlePanel;
    protected TitledBorder titleBorder;
    protected JTextField titleField;
    protected TitledBorder bdrBorder;
    protected JButton titleOptions;
    protected JButton valueOptions;
    protected JButton layoutOptions;
    protected JColorChooser colorChooser;
    protected TextDialog txtDlg = null;
    protected String textOnEnter = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected ResourceBundle lgrb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.util.silk_util_NLS");
    protected Vector propListeners = new Vector();
    protected String[] sendNames = null;
    protected int[] posIds;
    LegendLayoutDialog layoutDialog = null;

    public LegendPanel(PropertyInterface legend) {
        this(legend, null, null);
    }

    public LegendPanel(PropertyInterface legend, String[] names, String[] displayNames) {
        Object o;
        PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)legend);
        this.setLayout(null);
        this.setSize(265, 410);
        this.setPreferredSize(new Dimension(275, 450));
        if (names == null && legend != null && (o = legend.getPropertyValue(24)) != null && o instanceof String[]) {
            names = (String[])o;
        }
        if (displayNames == null && legend != null && (o = legend.getPropertyValue(25)) != null && o instanceof String[]) {
            displayNames = (String[])o;
        }
        this.createControls(names, displayNames);
    }

    protected void createControls(String[] names, String[] displayNames) {
        this.hasChoices = names != null && names.length > 1;
        this.choicePanel = new JPanel();
        this.choicePanel.setLayout(null);
        this.choicePanel.setBounds(10, 10, 245, 40);
        this.choicePanel.setBorder(new EtchedBorder());
        this.choiceLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.ChoiceLabel.txt", (String)"Legend:"));
        this.choiceLabel.setForeground(Color.black);
        this.choiceLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.choiceLabel.setBounds(6, 8, 80, 24);
        this.choicePanel.add(this.choiceLabel);
        this.choiceCombo = new JComboBox();
        this.choiceCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.choiceCombo.setBounds(88, 8, 120, 24);
        this.choiceCombo.setBackground(Color.white);
        this.choicePanel.add(this.choiceCombo);
        this.add(this.choicePanel);
        if (this.hasChoices) {
            int n = names.length;
            this.sendNames = new String[n];
            for (int i = 0; i < n; ++i) {
                if (displayNames != null && i < displayNames.length) {
                    this.choiceCombo.addItem(displayNames[i]);
                } else {
                    this.choiceCombo.addItem(names[i]);
                }
                this.sendNames[i] = names[i];
            }
            this.choicePanel.setVisible(true);
        } else {
            this.choicePanel.setVisible(false);
        }
        this.visibleBtn = new JCheckBox();
        this.visibleBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.visibleBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.ShowCheckbox.txt", (String)"Show"));
        this.visibleBtn.setForeground(Color.black);
        this.add(this.visibleBtn);
        this.visibleBtn.setBounds(10, 54, 120, 24);
        this.insideBtn = new JCheckBox();
        this.insideBtn.setFont(TabbedPropertiesDialog.dialogFont);
        Object label = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)439);
        if (label != null) {
            this.insideBtn.setText(label.toString());
        } else {
            this.insideBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.InsideCheckbox.txt", (String)"Inside"));
        }
        this.insideBtn.setForeground(Color.black);
        this.add(this.insideBtn);
        this.insideBtn.setBounds(135, 54, 120, 24);
        this.posLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.PositionLabel.txt", (String)"Position:"));
        this.posLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.posLabel.setForeground(Color.black);
        this.add(this.posLabel);
        this.posLabel.setBounds(16, 82, 80, 24);
        this.posCombo = new JComboBox();
        this.posCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.posCombo.setForeground(Color.black);
        this.posCombo.setBackground(Color.white);
        this.add(this.posCombo);
        this.posCombo.setBounds(94, 88, 120, 24);
        this.posIds = new int[8];
        this.posIds[0] = 1;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionNorth.txt", (String)"North"));
        this.posIds[1] = 6;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionNorthEast.txt", (String)"Northeast"));
        this.posIds[2] = 7;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionNorthWest.txt", (String)"Northwest"));
        this.posIds[3] = 2;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionSouth.txt", (String)"South"));
        this.posIds[4] = 9;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionSouthWest.txt", (String)"Southwest"));
        this.posIds[5] = 8;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionSouthEast.txt", (String)"Southeast"));
        this.posIds[6] = 3;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionEast.txt", (String)"East"));
        this.posIds[7] = 4;
        this.posCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.PositionWest.txt", (String)"West"));
        this.bkgBorder = new TitledBorder(new EtchedBorder());
        this.bkgBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.bkgBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BackgroundBorderTitle.txt", (String)"Background"));
        this.bkgBorder.setTitleColor(Color.black);
        this.bkgPanel = new JPanel();
        this.add(this.bkgPanel);
        this.bkgPanel.setLayout(null);
        this.bkgPanel.setBorder(this.bkgBorder);
        this.bkgPanel.setBounds(10, 114, 245, 80);
        this.bkgClrLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BackgroundColorLabel.txt", (String)"Color:"));
        this.bkgPanel.add(this.bkgClrLabel);
        this.bkgClrLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.bkgClrLabel.setForeground(Color.black);
        this.bkgClrLabel.setBounds(10, 18, 80, 24);
        this.bkgClrPanel = new JPanel();
        this.bkgPanel.add(this.bkgClrPanel);
        this.bkgClrPanel.setBounds(94, 18, 92, 24);
        this.bkgClrPanel.setBorder(new EtchedBorder());
        this.bkgClrBtn = new JButton();
        this.bkgPanel.add(this.bkgClrBtn);
        this.bkgClrBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.bkgClrBtn.setForeground(Color.black);
        this.bkgClrBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BackgroundColorButton.txt", (String)"..."));
        this.bkgClrBtn.setBounds(190, 18, 24, 24);
        this.bkgPanel.add(this.bkgClrPanel);
        this.bkgOpacityLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BackgroundOpacityLabel.txt", (String)"Opacity:"));
        this.bkgPanel.add(this.bkgOpacityLabel);
        this.bkgOpacityLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.bkgOpacityLabel.setForeground(Color.black);
        this.bkgOpacityLabel.setBounds(10, 46, 80, 24);
        this.bkgOpacitySlider = new JSlider();
        this.bkgPanel.add(this.bkgOpacitySlider);
        this.bkgOpacitySlider.setBounds(94, 48, 116, 24);
        this.bkgOpacitySlider.setMinimum(0);
        this.bkgOpacitySlider.setMaximum(100);
        this.bdrBorder = new TitledBorder(new EtchedBorder());
        this.bdrBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.bdrBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BorderBorderTitle.txt", (String)"Border"));
        this.bdrBorder.setTitleColor(Color.black);
        this.bdrPanel = new JPanel();
        this.add(this.bdrPanel);
        this.bdrPanel.setLayout(null);
        this.bdrPanel.setBorder(this.bdrBorder);
        this.bdrPanel.setBounds(10, 194, 245, 80);
        this.bdrStyleLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BorderStyleLabel.txt", (String)"Style:"));
        this.bdrPanel.add(this.bdrStyleLabel);
        this.bdrStyleLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.bdrStyleLabel.setForeground(Color.black);
        this.bdrStyleLabel.setBounds(10, 18, 80, 24);
        this.bdrStyleCombo = new JComboBox();
        this.bdrPanel.add(this.bdrStyleCombo);
        this.bdrStyleCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.bdrStyleCombo.setForeground(Color.black);
        this.bdrStyleCombo.setBackground(Color.white);
        this.bdrStyleCombo.setBounds(94, 18, 120, 24);
        this.bdrStyleCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.BorderNone.txt", (String)"None"));
        this.bdrStyleCombo.addItem(ResourceLoader.getResourceString((Object)this.lgrb, (String)"Legend.BorderLine.txt", (String)"Line"));
        this.bdrClrLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BorderColorLabel.txt", (String)"Color:"));
        this.bdrPanel.add(this.bdrClrLabel);
        this.bdrClrLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.bdrClrLabel.setForeground(Color.black);
        this.bdrClrLabel.setBounds(10, 46, 80, 24);
        this.bdrClrPanel = new JPanel();
        this.bdrPanel.add(this.bdrClrPanel);
        this.bdrClrPanel.setBounds(94, 46, 92, 24);
        this.bdrClrPanel.setBorder(new EtchedBorder());
        this.bdrClrBtn = new JButton();
        this.bdrPanel.add(this.bdrClrBtn);
        this.bdrClrBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.bdrClrBtn.setForeground(Color.black);
        this.bdrClrBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BorderColorButton.txt", (String)"..."));
        this.bdrClrBtn.setBounds(190, 46, 24, 24);
        this.bdrPanel.add(this.bdrClrPanel);
        this.titlePanel = new JPanel();
        this.titlePanel.setLayout(null);
        this.titleBorder = new TitledBorder(new EtchedBorder());
        this.titleBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.TitleBorderTitle.txt", (String)"Title"));
        this.titleBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.titleBorder.setTitleColor(Color.black);
        this.titlePanel.setBorder(this.titleBorder);
        this.add(this.titlePanel);
        this.titlePanel.setBounds(10, 278, 245, 108);
        this.titleBtn = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.ShowTitleCheckbox.txt", (String)"Show"));
        this.titleBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.titleBtn.setForeground(Color.black);
        this.titlePanel.add(this.titleBtn);
        this.titleBtn.setBounds(10, 18, 120, 24);
        this.titleField = new JTextField();
        this.titleField.setFont(TabbedPropertiesDialog.dialogFont);
        this.titleField.setForeground(Color.black);
        this.titleField.setBackground(Color.white);
        this.titlePanel.add(this.titleField);
        this.titleField.setBounds(10, 46, 225, 24);
        this.titleField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                PropertyUtils.setPropertyValue((Vector)LegendPanel.this.propListeners, (int)426, (Object)LegendPanel.this.titleField.getText());
            }
        });
        this.titleOptions = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.TitleOptionsButton.txt", (String)"Title Options..."));
        this.titleOptions.setFont(TabbedPropertiesDialog.dialogFont);
        this.titleOptions.setForeground(Color.black);
        this.titlePanel.add(this.titleOptions);
        this.titleOptions.setBounds(65, 74, 160, 24);
        this.valueOptions = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.ValueOptionsButton.txt", (String)"Value Options..."));
        this.valueOptions.setFont(TabbedPropertiesDialog.dialogFont);
        this.valueOptions.setForeground(Color.black);
        this.add(this.valueOptions);
        this.valueOptions.setBounds(75, 390, 160, 24);
        this.layoutOptions = new JButton(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.LayoutOptionsButton.txt", (String)"Layout Options..."));
        this.layoutOptions.setFont(TabbedPropertiesDialog.dialogFont);
        this.layoutOptions.setForeground(Color.black);
        this.add(this.layoutOptions);
        this.layoutOptions.setBounds(75, 417, 160, 24);
    }

    protected void addListeners() {
        if (this.listenersAdded) {
            return;
        }
        if (this.choiceCombo != null) {
            this.choiceCombo.addActionListener(this);
        }
        this.visibleBtn.addActionListener(this);
        this.insideBtn.addActionListener(this);
        this.posCombo.addActionListener(this);
        this.bkgClrBtn.addActionListener(this);
        this.bkgOpacitySlider.addChangeListener(this);
        this.bdrStyleCombo.addActionListener(this);
        this.bdrClrBtn.addActionListener(this);
        this.titleBtn.addActionListener(this);
        this.titleField.addActionListener(this);
        this.titleField.addFocusListener(this);
        this.titleOptions.addActionListener(this);
        this.valueOptions.addActionListener(this);
        this.layoutOptions.addActionListener(this);
        this.listenersAdded = true;
    }

    protected void removeListeners() {
        if (!this.listenersAdded) {
            return;
        }
        if (this.choiceCombo != null) {
            this.choiceCombo.removeActionListener(this);
        }
        this.visibleBtn.removeActionListener(this);
        this.insideBtn.removeActionListener(this);
        this.posCombo.removeActionListener(this);
        this.bkgClrBtn.removeActionListener(this);
        this.bkgOpacitySlider.removeChangeListener(this);
        this.bdrStyleCombo.removeActionListener(this);
        this.bdrClrBtn.removeActionListener(this);
        this.titleBtn.removeActionListener(this);
        this.titleField.removeActionListener(this);
        this.titleOptions.removeActionListener(this);
        this.valueOptions.removeActionListener(this);
        this.layoutOptions.removeActionListener(this);
        this.listenersAdded = false;
    }

    protected Color showColorChooserDialog(String title, Color initialColor) {
        if (this.colorChooser == null && (this.colorChooser = new JColorChooser()) == null) {
            return null;
        }
        return JColorChooser.showDialog(this, title, initialColor);
    }

    protected void showTextDialog(Object prop, String title) {
        Frame parent = null;
        JComponent jc = null;
        if (prop == null || !(prop instanceof PropertyInterface)) {
            return;
        }
        if (this.txtDlg == null) {
            for (Container c = this.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof Frame)) continue;
                parent = (Frame)c;
                break;
            }
            if ((this.txtDlg = new TextDialog(parent, jc = PropertyUtils.getJComponent((Vector)this.propListeners))) == null) {
                return;
            }
        }
        this.txtDlg.setVerticalJustificationSupported(false);
        this.txtDlg.showDialog((PropertyInterface)prop, title);
    }

    protected void showLayoutDialog(PropertyInterface prop) {
        Frame parent = null;
        JComponent jc = null;
        if (prop == null) {
            return;
        }
        if (this.layoutDialog == null) {
            for (Container c = this.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof Frame)) continue;
                parent = (Frame)c;
                break;
            }
            if ((this.layoutDialog = new LegendLayoutDialog(parent, jc = PropertyUtils.getJComponent((Vector)this.propListeners))) == null) {
                return;
            }
        }
        this.layoutDialog.setLegend(prop);
        this.layoutDialog.setVisible(true);
    }

    protected boolean getBooleanProperty(Vector props, int id, boolean defVal) {
        Object o = PropertyUtils.getPropertyValue((Vector)props, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defVal;
        }
        return (Boolean)o;
    }

    protected Color getColorProperty(Vector props, int id, Color defVal) {
        Color c;
        Object o = PropertyUtils.getPropertyValue((Vector)props, (int)id);
        if (o == null) {
            return defVal;
        }
        if (o instanceof Color) {
            return (Color)o;
        }
        if (o instanceof String && (c = ColorParse.getColorFromString((String)((String)o))) != null) {
            return c;
        }
        return defVal;
    }

    protected double getNumericProperty(Vector props, int id, double defVal) {
        Object o = PropertyUtils.getPropertyValue((Vector)props, (int)id);
        if (o == null) {
            return defVal;
        }
        if (o instanceof Number) {
            if (Double.isNaN(((Number)o).doubleValue())) {
                return defVal;
            }
            return ((Number)o).doubleValue();
        }
        return defVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateControls() {
        String s;
        boolean viz = false;
        boolean titleViz = false;
        boolean inside = false;
        boolean enableInside = false;
        Object lg = null;
        LegendPanel legendPanel = this;
        synchronized (legendPanel) {
            this.internalUpdate = true;
        }
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)24);
        Object o2 = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)25);
        boolean bl = this.hasChoices = o != null && o2 != null;
        if (this.choiceCombo != null) {
            Object item;
            int i;
            int type;
            int n;
            if (o != null && (n = Extract.getNumberItems((Object)o, (int)(type = Extract.getSourceType((Object)o)))) > 0) {
                if (this.sendNames == null || this.sendNames.length < n) {
                    this.sendNames = new String[n];
                }
                for (i = 0; i < n; ++i) {
                    item = Extract.getObject((Object)o, (int)i, (int)type);
                    this.sendNames[i] = item == null ? null : item.toString();
                }
            }
            this.choiceCombo.removeAllItems();
            if (o2 != null) {
                type = Extract.getSourceType((Object)o2);
                n = Extract.getNumberItems((Object)o2, (int)type);
                for (i = 0; i < n; ++i) {
                    item = Extract.getObject((Object)o2, (int)i, (int)type);
                    if (item == null) continue;
                    this.choiceCombo.addItem(item);
                }
            }
        }
        if (this.hasChoices) {
            this.choicePanel.setVisible(true);
        } else {
            this.choicePanel.setVisible(false);
        }
        lg = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)23);
        if (this.choiceLabel != null) {
            this.choiceLabel.setEnabled(lg != null);
        }
        if (this.choiceCombo != null) {
            if (lg == null) {
                this.choiceCombo.setEnabled(false);
            } else {
                this.choiceCombo.setEnabled(true);
                this.choiceCombo.setSelectedItem(lg.toString());
            }
        }
        viz = this.getBooleanProperty(this.propListeners, 420, this.visibleBtn.isSelected());
        inside = this.getBooleanProperty(this.propListeners, 432, this.insideBtn.isSelected());
        enableInside = this.getBooleanProperty(this.propListeners, 39, false);
        titleViz = this.getBooleanProperty(this.propListeners, 425, this.titleBtn.isSelected());
        this.posLabel.setEnabled(viz);
        this.posCombo.setEnabled(viz);
        int posProperty = inside ? 442 : 443;
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)posProperty);
        if (o != null) {
            this.posCombo.setEditable(false);
            s = null;
            if (o instanceof Number) {
                s = o.toString();
            } else if (o instanceof String) {
                s = (String)o;
            }
            if (s != null) {
                this.posCombo.setSelectedItem(s);
            }
        }
        this.visibleBtn.setEnabled(lg != null);
        this.visibleBtn.setSelected(viz);
        this.insideBtn.setEnabled(viz && lg != null && enableInside);
        this.insideBtn.setSelected(inside);
        this.bkgClrLabel.setEnabled(viz && lg != null);
        this.bkgClrPanel.setEnabled(viz && lg != null);
        this.bkgClrBtn.setEnabled(viz && lg != null);
        this.bkgOpacityLabel.setEnabled(viz && lg != null);
        this.bkgOpacitySlider.setEnabled(viz && lg != null);
        this.bkgClrPanel.setBackground(this.getColorProperty(this.propListeners, 421, Color.white));
        double d = this.getNumericProperty(this.propListeners, 422, 1.0);
        int min = this.bkgOpacitySlider.getMinimum();
        int max = this.bkgOpacitySlider.getMaximum();
        int v = (int)((double)(max - min) * d + (double)min);
        v = Math.max(v, min);
        v = Math.min(v, max);
        this.bkgOpacitySlider.setValue(v);
        this.bdrStyleLabel.setEnabled(viz && lg != null);
        this.bdrStyleCombo.setEnabled(viz && lg != null);
        this.bdrClrLabel.setEnabled(viz && lg != null);
        this.bdrClrPanel.setEnabled(viz && lg != null);
        this.bdrClrBtn.setEnabled(viz && lg != null);
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)424);
        if (o != null) {
            s = null;
            if (o instanceof Number) {
                s = o.toString();
            } else if (o instanceof String) {
                s = (String)o;
            }
            if (s != null) {
                this.bdrStyleCombo.setSelectedItem(s);
            }
        }
        this.bdrClrPanel.setBackground(this.getColorProperty(this.propListeners, 423, Color.black));
        this.titleBtn.setEnabled(viz && lg != null);
        this.titleField.setEnabled(viz && titleViz && lg != null);
        this.titleOptions.setEnabled(viz && titleViz && lg != null);
        this.valueOptions.setEnabled(viz && lg != null);
        boolean isContinuousLegend = this.getBooleanProperty(this.propListeners, 441, false);
        this.layoutOptions.setEnabled(viz && lg != null && !isContinuousLegend);
        this.titleBtn.setSelected(this.getBooleanProperty(this.propListeners, 425, this.titleBtn.isSelected()));
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)426);
        if (o == null) {
            this.titleField.setText("");
        } else {
            this.titleField.setText(o.toString());
        }
        LegendPanel legendPanel2 = this;
        synchronized (legendPanel2) {
            this.internalUpdate = false;
        }
    }

    @Override
    public void setVisible(boolean show) {
        super.setVisible(show);
        if (show) {
            this.addListeners();
            this.updateControls();
        } else {
            this.removeListeners();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (this.internalUpdate || source == null) {
            return;
        }
        if (source == this.visibleBtn) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)420, (Object)new Boolean(((JCheckBox)source).isSelected()));
        } else if (source == this.insideBtn) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)432, (Object)new Boolean(((JCheckBox)source).isSelected()));
        } else if (source == this.bkgClrBtn) {
            Color c = this.showColorChooserDialog(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BackgroundColorDialogTitle.txt", (String)"Background Color"), this.bkgClrBtn.getBackground());
            if (c == null) {
                return;
            }
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)421, (Object)c);
        } else if (source == this.bdrClrBtn) {
            Color c = this.showColorChooserDialog(ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.BorderColorDialogTitle.txt", (String)"Border Color"), this.bdrClrBtn.getBackground());
            if (c == null) {
                return;
            }
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)423, (Object)c);
        } else if (source == this.posCombo) {
            int posProperty;
            int i = this.posCombo.getSelectedIndex();
            int n = posProperty = this.insideBtn.isSelected() ? 442 : 443;
            if (i >= 0 && i < this.posIds.length) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)posProperty, (Object)new Integer(this.posIds[i]));
            }
        } else if (source == this.bdrStyleCombo) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)424, (Object)this.bdrStyleCombo.getSelectedItem());
        } else if (source == this.choiceCombo && this.sendNames != null) {
            int i = this.choiceCombo.getSelectedIndex();
            if (i < 0 || i >= this.sendNames.length) {
                return;
            }
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)23, (Object)this.sendNames[i]);
        } else if (source == this.titleOptions) {
            this.showTextDialog(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)427), ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.TitleOptionsDialogTitle.txt", (String)"Title Options"));
        } else if (source == this.valueOptions) {
            this.showTextDialog(PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)428), ResourceLoader.getResourceString((Object)this.rb, (String)"LegendPanel.ValueOptionsDialogTitle.txt", (String)"Value Options"));
        } else if (source == this.titleField) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)426, (Object)this.titleField.getText());
        } else if (source == this.titleBtn) {
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)425, (Object)new Boolean(this.titleBtn.isSelected()));
        } else if (source == this.layoutOptions) {
            this.showLayoutDialog(PropertyUtils.getPropertyMulticaster((Vector)this.propListeners));
        } else {
            return;
        }
        this.updateControls();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.internalUpdate) {
            return;
        }
        if (source == this.bkgOpacitySlider) {
            int min = this.bkgOpacitySlider.getMinimum();
            int max = this.bkgOpacitySlider.getMaximum();
            int v = this.bkgOpacitySlider.getValue();
            double opacity = (double)(v - min) / (double)(max - min);
            opacity = Math.max(opacity, 0.0);
            opacity = Math.min(opacity, 1.0);
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)422, (Object)new Double(opacity));
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (source == null || !(source instanceof JTextField)) {
            return;
        }
        this.textOnEnter = ((JTextField)source).getText();
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source == null || !(source instanceof JTextField) || this.textOnEnter == null) {
            return;
        }
        String curText = ((JTextField)source).getText();
        if (curText != null && !curText.equalsIgnoreCase(this.textOnEnter)) {
            ((JTextField)source).postActionEvent();
        }
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propListeners);
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.propListeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }
}

