/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.HistogramPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HistogramPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener,
TabPanelInterface,
HistogramPropertyInterface {
    private static final long serialVersionUID = 3602461067746983605L;
    protected static int BORDER = 8;
    protected static int GAP = 4;
    protected static int COLOR_PANE_WIDTH = 90;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected PropertyInterface hist;
    protected JCheckBox outlineCheckBox;
    protected JCheckBox missingBinCheckBox;
    protected JCheckBox byStatCheckBox;
    protected ColorPanel barColorPanel;
    protected ColorPanel outlineColorPanel;
    protected JCheckBox intervalAxisXCheckBox;
    protected JCheckBox scaledSpacingXCheckBox;
    protected JButton barColorButton;
    protected JButton outlineColorButton;
    protected JComboBox xBinCombo;
    protected JComboBox yBinCombo;
    protected JSlider widthSlider;
    protected JLabel byStatLabel;
    protected JLabel byChartLabel;
    protected JLabel outlineLabel;
    protected JLabel xBinLabel;
    protected JLabel yBinLabel;
    protected JLabel widthLabel;
    protected Color GRAYOUT;
    protected boolean byScheme;
    protected JCheckBox discreteXCheckBox;
    protected JCheckBox discreteYCheckBox;
    protected JCheckBox gradientOnCheckBox;
    protected String xBins;
    protected String yBins;

    public HistogramPanel(PropertyInterface hist) {
        this.hist = hist;
        this.setSize(265, 410);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.GRAYOUT = this.getBackground().darker();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            if (c instanceof JSlider) continue;
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
            if (!(c instanceof JComboBox)) continue;
            c.setBackground(Color.white);
        }
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(2 * BORDER, BORDER, BORDER, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        JPanel colorPanel = this.makeColorPanel();
        JPanel binPanel = this.makeBinPanel();
        int maxWt = COLOR_PANE_WIDTH + this.barColorButton.getPreferredSize().width;
        this.xBinCombo.setMaximumSize(new Dimension(maxWt, this.xBinCombo.getPreferredSize().height));
        this.yBinCombo.setMaximumSize(new Dimension(maxWt, this.yBinCombo.getPreferredSize().height));
        this.widthSlider.setPreferredSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.widthSlider.setMaximumSize(new Dimension(maxWt, this.widthSlider.getPreferredSize().height));
        this.add(colorPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(binPanel);
        JPanel intervalAxisXPanel = new JPanel();
        intervalAxisXPanel.setLayout(new BoxLayout(intervalAxisXPanel, 0));
        intervalAxisXPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.intervalAxisXCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.IntervalAxisX.txt", (String)"Horizontal Interval Axis"));
        intervalAxisXPanel.add(this.intervalAxisXCheckBox);
        intervalAxisXPanel.add(Box.createHorizontalGlue());
        this.add(intervalAxisXPanel);
        JPanel scaledSpacingXPanel = new JPanel();
        scaledSpacingXPanel.setLayout(new BoxLayout(scaledSpacingXPanel, 0));
        scaledSpacingXPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.scaledSpacingXCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ScaledSpacingX.txt", (String)"Horizontal Scaled Spacing"));
        scaledSpacingXPanel.add(this.scaledSpacingXCheckBox);
        scaledSpacingXPanel.add(Box.createHorizontalGlue());
        this.add(scaledSpacingXPanel);
    }

    protected JPanel makeColorPanel() {
        JPanel colorPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorPanel.txt", (String)"Color"));
        colorPanel.setBorder(border);
        colorPanel.setLayout(new BoxLayout(colorPanel, 1));
        JPanel statPanel = new JPanel();
        statPanel.setLayout(new BoxLayout(statPanel, 0));
        this.byStatCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorByStat.txt", (String)"Color By Stat"));
        this.barColorButton = new JButton("...");
        this.barColorPanel = new ColorPanel(Color.white, this.barColorButton.getPreferredSize().height);
        statPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        statPanel.add(this.byStatCheckBox);
        statPanel.add(Box.createHorizontalGlue());
        statPanel.add(this.barColorPanel);
        statPanel.add(this.barColorButton);
        statPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel outlinePanel = new JPanel();
        outlinePanel.setLayout(new BoxLayout(outlinePanel, 0));
        this.outlineCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Outline.txt", (String)"Outline"));
        this.outlineColorButton = new JButton("...");
        this.outlineColorPanel = new ColorPanel(Color.white, this.outlineColorButton.getPreferredSize().height);
        outlinePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        outlinePanel.add(this.outlineCheckBox);
        outlinePanel.add(Box.createHorizontalGlue());
        outlinePanel.add(this.outlineColorPanel);
        outlinePanel.add(this.outlineColorButton);
        outlinePanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        int buttHt = this.barColorButton.getPreferredSize().height;
        this.barColorButton.setPreferredSize(new Dimension(buttHt, buttHt));
        this.outlineColorButton.setPreferredSize(new Dimension(buttHt, buttHt));
        JPanel gradientOnPanel = new JPanel();
        gradientOnPanel.setLayout(new BoxLayout(gradientOnPanel, 0));
        gradientOnPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.gradientOnCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"BarPanel.Gradient.txt", (String)"Gradient"));
        gradientOnPanel.add(this.gradientOnCheckBox);
        gradientOnPanel.add(Box.createHorizontalGlue());
        colorPanel.add(statPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        colorPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        colorPanel.add(outlinePanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        colorPanel.add(gradientOnPanel);
        colorPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        return colorPanel;
    }

    protected JPanel makeBinPanel() {
        JPanel binPanel = new JPanel();
        TitledBorder border = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.BinPanel.txt", (String)"Bins"));
        binPanel.setBorder(border);
        binPanel.setLayout(new BoxLayout(binPanel, 1));
        JPanel missingBinPanel = new JPanel();
        missingBinPanel.setLayout(new BoxLayout(missingBinPanel, 1));
        this.missingBinCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.MissingBin.txt", (String)"Show Missing Bin"));
        missingBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        missingBinPanel.add(this.missingBinCheckBox);
        missingBinPanel.add(Box.createHorizontalGlue());
        JPanel discreteBinPanel = new JPanel();
        discreteBinPanel.setLayout(new BoxLayout(discreteBinPanel, 1));
        this.discreteXCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.DiscreteX.txt", (String)"Horizontal Discrete"));
        discreteBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        discreteBinPanel.add(this.discreteXCheckBox);
        discreteBinPanel.add(Box.createHorizontalGlue());
        this.discreteYCheckBox = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.DiscreteY.txt", (String)"Vertical Discrete"));
        discreteBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        discreteBinPanel.add(this.discreteYCheckBox);
        discreteBinPanel.add(Box.createHorizontalGlue());
        JPanel xBinPanel = new JPanel();
        xBinPanel.setLayout(new BoxLayout(xBinPanel, 0));
        this.xBinCombo = new JComboBox();
        this.xBinCombo.setEditable(true);
        this.makeBinCombo(this.xBinCombo);
        this.xBinCombo.setPreferredSize(new Dimension(75, 25));
        this.xBinLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.XBins.txt", (String)"Horizontal"));
        this.xBinLabel.setPreferredSize(new Dimension(150, 25));
        xBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        xBinPanel.add(this.xBinLabel);
        xBinPanel.add(Box.createHorizontalGlue());
        xBinPanel.add(this.xBinCombo);
        xBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel yBinPanel = new JPanel();
        yBinPanel.setLayout(new BoxLayout(yBinPanel, 0));
        this.yBinCombo = new JComboBox();
        this.yBinCombo.setEditable(true);
        this.makeBinCombo(this.yBinCombo);
        this.yBinCombo.setPreferredSize(new Dimension(75, 25));
        this.yBinLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.YBins.txt", (String)"Vertical"));
        this.yBinLabel.setPreferredSize(new Dimension(150, 25));
        yBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        yBinPanel.add(this.yBinLabel);
        yBinPanel.add(Box.createHorizontalGlue());
        yBinPanel.add(this.yBinCombo);
        yBinPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel widthPanel = new JPanel();
        widthPanel.setLayout(new BoxLayout(widthPanel, 0));
        this.widthLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.BinWidth.txt", (String)"Width"));
        this.widthSlider = new JSlider();
        this.widthSlider.setMinimum(1);
        this.widthSlider.setMaximum(101);
        this.widthSlider.setExtent(1);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        widthPanel.add(this.widthLabel);
        widthPanel.add(Box.createHorizontalGlue());
        widthPanel.add(this.widthSlider);
        widthPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        binPanel.add(missingBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        binPanel.add(discreteBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        binPanel.add(xBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, GAP)));
        binPanel.add(yBinPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        binPanel.add(widthPanel);
        binPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        return binPanel;
    }

    private void makeBinCombo(JComboBox comb) {
        for (int i = 5; i <= 30; i += 5) {
            comb.addItem(Integer.toString(i));
        }
        comb.setPreferredSize(new Dimension(25, 25));
    }

    public void setInitialValues() {
        this.byScheme = (Boolean)this.hist.getPropertyValue(809);
        if (this.byScheme) {
            this.byStatCheckBox.setEnabled(false);
            this.barColorPanel.setColor(this.GRAYOUT);
            this.barColorButton.setEnabled(false);
        } else {
            this.byStatCheckBox.setEnabled(true);
            boolean byStat = (Boolean)this.hist.getPropertyValue(820);
            if (byStat) {
                this.byStatCheckBox.setSelected(true);
                this.barColorPanel.setColor(this.GRAYOUT);
                this.barColorButton.setEnabled(false);
            } else {
                this.byStatCheckBox.setSelected(false);
                this.barColorPanel.setColor((Color)this.hist.getPropertyValue(801));
                this.barColorButton.setEnabled(true);
            }
        }
        boolean on = (Boolean)this.hist.getPropertyValue(803);
        if (on) {
            this.outlineCheckBox.setSelected(true);
            this.outlineColorPanel.setColor((Color)this.hist.getPropertyValue(802));
            this.outlineColorButton.setEnabled(true);
        } else {
            this.outlineCheckBox.setSelected(false);
            this.outlineColorPanel.setColor(this.GRAYOUT);
            this.outlineColorButton.setEnabled(false);
        }
        this.xBinCombo.setSelectedItem(this.hist.getPropertyValue(805));
        this.xBins = this.xBinCombo.getSelectedItem().toString();
        this.discreteXCheckBox.setSelected((Boolean)this.hist.getPropertyValue(812));
        this.intervalAxisXCheckBox.setSelected((Boolean)this.hist.getPropertyValue(821));
        this.scaledSpacingXCheckBox.setSelected((Boolean)this.hist.getPropertyValue(822));
        this.discreteYCheckBox.setSelected((Boolean)this.hist.getPropertyValue(813));
        if (((Boolean)this.hist.getPropertyValue(816)).booleanValue()) {
            this.discreteXCheckBox.setEnabled(true);
            if (this.discreteXCheckBox.isSelected()) {
                this.intervalAxisXCheckBox.setEnabled(true);
            } else {
                this.intervalAxisXCheckBox.setEnabled(false);
            }
            if (this.intervalAxisXCheckBox.isEnabled()) {
                if (this.intervalAxisXCheckBox.isSelected()) {
                    this.scaledSpacingXCheckBox.setEnabled(false);
                } else {
                    this.scaledSpacingXCheckBox.setEnabled(true);
                }
            } else {
                this.scaledSpacingXCheckBox.setEnabled(false);
            }
        } else {
            this.discreteXCheckBox.setEnabled(false);
            this.intervalAxisXCheckBox.setEnabled(false);
            this.scaledSpacingXCheckBox.setEnabled(false);
        }
        if (!this.discreteXCheckBox.isEnabled() || ((Boolean)this.hist.getPropertyValue(810)).booleanValue()) {
            this.xBinCombo.setEnabled(false);
            this.xBinLabel.setEnabled(false);
            this.xBinCombo.setSelectedItem("");
        } else {
            this.xBinCombo.setEnabled(true);
            this.xBinLabel.setEnabled(true);
            this.xBinCombo.setSelectedItem(this.xBins);
        }
        if (this.byScheme) {
            if (((Boolean)this.hist.getPropertyValue(817)).booleanValue()) {
                this.discreteYCheckBox.setEnabled(true);
            } else {
                this.discreteYCheckBox.setEnabled(false);
            }
            this.yBinCombo.setEnabled(true);
            this.yBinLabel.setEnabled(true);
            this.yBinCombo.setSelectedItem(this.hist.getPropertyValue(806));
            this.yBins = this.yBinCombo.getSelectedItem().toString();
            if (!this.discreteYCheckBox.isEnabled() || ((Boolean)this.hist.getPropertyValue(811)).booleanValue()) {
                this.yBinCombo.setEnabled(false);
                this.yBinLabel.setEnabled(false);
                this.yBinCombo.setSelectedItem("");
            } else {
                this.yBinCombo.setEnabled(true);
                this.yBinLabel.setEnabled(true);
                this.yBinCombo.setSelectedItem(this.yBins);
            }
            this.intervalAxisXCheckBox.setEnabled(false);
            this.scaledSpacingXCheckBox.setEnabled(false);
        } else {
            this.yBinCombo.setSelectedItem("");
            this.yBinCombo.setEnabled(false);
            this.yBinLabel.setEnabled(false);
            this.discreteYCheckBox.setEnabled(false);
        }
        if (this.byScheme) {
            this.gradientOnCheckBox.setEnabled(false);
        } else {
            on = (Boolean)this.hist.getPropertyValue(819);
            this.gradientOnCheckBox.setEnabled(true);
            this.gradientOnCheckBox.setSelected(on);
        }
        on = (Boolean)this.hist.getPropertyValue(819);
        this.gradientOnCheckBox.setEnabled(true);
        this.gradientOnCheckBox.setSelected(on);
        this.widthSlider.setValue((int)(((Number)this.hist.getPropertyValue(804)).doubleValue() * 100.0));
        this.missingBinCheckBox.setSelected((Boolean)this.hist.getPropertyValue(807));
    }

    private void addListeners() {
        this.barColorButton.addActionListener(this);
        this.outlineColorButton.addActionListener(this);
        this.xBinCombo.addActionListener(this);
        this.yBinCombo.addActionListener(this);
        this.byStatCheckBox.addItemListener(this);
        this.outlineCheckBox.addItemListener(this);
        this.missingBinCheckBox.addItemListener(this);
        this.discreteXCheckBox.addItemListener(this);
        this.discreteYCheckBox.addItemListener(this);
        this.widthSlider.addChangeListener(this);
        this.gradientOnCheckBox.addItemListener(this);
        this.intervalAxisXCheckBox.addItemListener(this);
        this.scaledSpacingXCheckBox.addItemListener(this);
    }

    private void removeListeners() {
        this.barColorButton.removeActionListener(this);
        this.outlineColorButton.removeActionListener(this);
        this.xBinCombo.removeActionListener(this);
        this.yBinCombo.removeActionListener(this);
        this.byStatCheckBox.removeItemListener(this);
        this.outlineCheckBox.removeItemListener(this);
        this.missingBinCheckBox.removeItemListener(this);
        this.discreteXCheckBox.removeItemListener(this);
        this.discreteYCheckBox.removeItemListener(this);
        this.widthSlider.removeChangeListener(this);
        this.gradientOnCheckBox.removeItemListener(this);
        this.intervalAxisXCheckBox.removeItemListener(this);
        this.scaledSpacingXCheckBox.removeItemListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        block17: {
            Object source = evt.getSource();
            if (source == this.barColorButton) {
                Color initColor = this.barColorPanel.getColor();
                Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorChooser.txt", (String)"Color"), initColor);
                if (newColor == null) {
                    newColor = initColor;
                }
                this.barColorPanel.setColor(newColor);
                this.hist.setPropertyValue(801, (Object)newColor);
            } else if (source == this.outlineColorButton) {
                Color initColor = this.outlineColorPanel.getColor();
                Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorChooser.txt", (String)"Color"), initColor);
                if (newColor == null) {
                    newColor = initColor;
                }
                this.outlineColorPanel.setColor(newColor);
                this.hist.setPropertyValue(802, (Object)newColor);
            } else if (source == this.xBinCombo && !this.discreteXCheckBox.isSelected()) {
                try {
                    Object obj = this.xBinCombo.getSelectedItem();
                    int bin = 0;
                    if (obj != null) {
                        bin = Integer.parseInt(this.xBinCombo.getSelectedItem().toString());
                    }
                    if (bin > 0) {
                        this.hist.setPropertyValue(805, (Object)new Integer(bin));
                        break block17;
                    }
                    this.xBinCombo.setSelectedItem(this.hist.getPropertyValue(805));
                }
                catch (NumberFormatException obj) {}
            } else if (source == this.yBinCombo && !this.discreteYCheckBox.isSelected() && ((Boolean)this.hist.getPropertyValue(809)).booleanValue()) {
                try {
                    int bin = Integer.parseInt(this.yBinCombo.getSelectedItem().toString());
                    if (bin > 0) {
                        this.hist.setPropertyValue(806, (Object)new Integer(bin));
                    } else {
                        this.yBinCombo.setSelectedItem(this.hist.getPropertyValue(806));
                    }
                }
                catch (NumberFormatException e) {
                    this.yBinCombo.setSelectedItem(this.hist.getPropertyValue(806));
                }
            }
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.intervalAxisXCheckBox) {
            this.hist.setPropertyValue(821, (Object)new Boolean(on));
            if (on) {
                this.scaledSpacingXCheckBox.setEnabled(false);
            } else {
                this.scaledSpacingXCheckBox.setEnabled(true);
            }
        }
        if (source == this.scaledSpacingXCheckBox) {
            this.hist.setPropertyValue(822, (Object)new Boolean(on));
        }
        if (source == this.byStatCheckBox) {
            if (on) {
                this.barColorPanel.setColor(this.GRAYOUT);
                this.barColorButton.setEnabled(false);
                if (!this.byScheme) {
                    this.hist.setPropertyValue(820, (Object)new Boolean(true));
                }
            } else {
                this.barColorPanel.setColor((Color)this.hist.getPropertyValue(801));
                this.barColorButton.setEnabled(true);
                this.hist.setPropertyValue(820, (Object)new Boolean(false));
            }
        }
        if (source == this.outlineCheckBox) {
            this.outlineColorButton.setEnabled(on);
            this.hist.setPropertyValue(803, (Object)new Boolean(on));
            if (on) {
                this.outlineColorPanel.setColor((Color)this.hist.getPropertyValue(802));
            } else {
                this.outlineColorPanel.setColor(this.GRAYOUT);
            }
        }
        if (source == this.missingBinCheckBox) {
            this.hist.setPropertyValue(807, (Object)new Boolean(on));
        }
        if (source == this.discreteXCheckBox) {
            this.hist.setPropertyValue(812, (Object)new Boolean(on));
            if (on) {
                this.xBins = this.xBinCombo.getSelectedItem().toString();
                this.xBinCombo.setEnabled(false);
                this.xBinLabel.setEnabled(false);
                this.xBinCombo.setSelectedItem("");
                if (this.byScheme) {
                    this.intervalAxisXCheckBox.setEnabled(false);
                    this.scaledSpacingXCheckBox.setEnabled(false);
                } else {
                    this.intervalAxisXCheckBox.setEnabled(true);
                    this.scaledSpacingXCheckBox.setEnabled(true);
                }
            } else {
                this.xBinCombo.setEnabled(true);
                this.xBinLabel.setEnabled(true);
                this.xBinCombo.setSelectedItem(this.xBins);
                this.intervalAxisXCheckBox.setEnabled(false);
                this.scaledSpacingXCheckBox.setEnabled(false);
            }
        }
        if (source == this.discreteYCheckBox) {
            this.hist.setPropertyValue(813, (Object)new Boolean(on));
            if (on) {
                this.yBins = this.yBinCombo.getSelectedItem().toString();
                this.yBinCombo.setEnabled(false);
                this.yBinLabel.setEnabled(false);
                this.yBinCombo.setSelectedItem("");
            } else {
                this.yBinCombo.setEnabled(true);
                this.yBinLabel.setEnabled(true);
                this.yBinCombo.setSelectedItem(this.yBins);
            }
        }
        if (source == this.gradientOnCheckBox) {
            this.hist.setPropertyValue(819, (Object)new Boolean(on));
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        if (evt.getSource() == this.widthSlider) {
            int wt = this.widthSlider.getValue();
            this.hist.setPropertyValue(804, (Object)new Double((double)wt / 100.0));
        }
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        this.hist.cancelPropertyChanges();
        return true;
    }

    @Override
    public boolean applyChanges() {
        this.hist.applyPropertyChanges();
        return true;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    class ColorPanel
    extends JPanel {
        private static final long serialVersionUID = 2526942777027116876L;
        Color color;
        int height;

        ColorPanel(Color c, int h) {
            this.height = h;
            this.color = c;
            this.setBackground(Color.white);
        }

        Color getColor() {
            return this.color;
        }

        void setColor(Color c) {
            this.color = c;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(2 * this.height, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(2 * this.height, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(2 * this.height, this.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.color);
            g.fillRect(0, 0, 2 * this.height, this.height);
        }
    }
}

