/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.CenteredHorizontalSeparator;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class HistElementPanel
extends JPanel
implements TabPanelInterface,
ItemListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    private JPanel mainPanel = null;
    private JPanel binsPanel = null;
    private JPanel binsPanelHeader = null;
    private JLabel binsLabel = null;
    private CenteredHorizontalSeparator centeredHorizontalSeparator1 = null;
    private JPanel jPanel1 = null;
    private JCheckBox missingBinCheckBox = null;
    private JPanel numberOfBinsPanel = null;
    private JPanel jPanel = null;
    private JLabel numberXBinsLabel = null;
    private JLabel numberYBinsLabel = null;
    private JPanel jPanel2 = null;
    private JComboBox numberXBinsComboBox = null;
    private JComboBox numberYBinsComboBox = null;
    private JPanel jPanel3 = null;
    private JPanel jPanel4 = null;
    private JPanel colorPanel = null;
    private JCheckBox outlineCheckBox = null;
    private JCheckBox gradientCheckBox = null;
    private JPanel colorHeaderPanel = null;
    private JLabel colorHeaderLabel = null;
    private CenteredHorizontalSeparator centeredHorizontalSeparator2 = null;
    private JPanel jPanel5 = null;
    private ColorMapperChooserPanel colorMapperChooserPanel = null;
    protected Vector propertyListeners = new Vector();
    private JPanel jPanel6 = null;
    private JPanel jPanel7 = null;
    private JCheckBox binAxisCheckBox = null;
    private JCheckBox endLabelsCheckBox = null;
    private JPanel valuesTypePanel2 = null;
    private JComboBox xValuesTypeComboBox = null;
    private JComboBox yValuesTypeComboBox = null;
    private JPanel valuesTypePanel = null;
    private JPanel valuesTypePanel3 = null;
    private JLabel xValuesTypeLabel = null;
    private JLabel yValuesTypeLabel = null;
    private JPanel boundaryPanel = null;
    private JComboBox boundaryComboBox = null;
    private JLabel boundaryLabel = null;
    private JPanel groupDisplayStylePanel = null;
    private JComboBox groupDisplayStyleComboBox = null;
    private JLabel groupDisplayStyleLabel = null;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    private JPanel jPanel8 = null;
    private JCheckBox binToDataRangeCheckBox = null;

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        boolean rc = PropertyUtils.addPropertyListener((Vector)this.propertyListeners, (PropertyInterface)prop);
        if (rc && this.propertyListeners.size() == 1) {
            this.updatePanels();
            this.refreshGUI();
        }
        return rc;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propertyListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges((Vector)this.propertyListeners);
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.propertyListeners);
    }

    public HistElementPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(305, 375);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.getMainPanel(), "Center");
        this.getNumberOfBinsPanel();
        this.getValuesTypePanel();
        this.getGroupDisplayStylePanel();
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.mainPanel.add((Component)this.getBinsPanel(), "North");
            this.mainPanel.add((Component)this.getJPanel3(), "Center");
        }
        return this.mainPanel;
    }

    private JPanel getBinsPanel() {
        if (this.binsPanel == null) {
            BorderLayout borderLayout1 = new BorderLayout();
            borderLayout1.setVgap(4);
            this.binsPanel = new JPanel();
            this.binsPanel.setLayout(borderLayout1);
            this.binsPanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            this.binsPanel.add((Component)this.getBinsPanelHeader(), "North");
            this.binsPanel.add((Component)this.getJPanel1(), "Center");
        }
        return this.binsPanel;
    }

    private JPanel getBinsPanelHeader() {
        if (this.binsPanelHeader == null) {
            this.binsLabel = new JLabel();
            this.binsLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.BinPanel.txt", (String)"Bins"));
            this.binsLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.binsPanelHeader = new JPanel();
            this.binsPanelHeader.setLayout(new BorderLayout());
            this.binsPanelHeader.add((Component)this.binsLabel, "West");
            this.binsPanelHeader.add((Component)this.getCenteredHorizontalSeparator1(), "Center");
        }
        return this.binsPanelHeader;
    }

    private CenteredHorizontalSeparator getCenteredHorizontalSeparator1() {
        if (this.centeredHorizontalSeparator1 == null) {
            this.centeredHorizontalSeparator1 = new CenteredHorizontalSeparator();
        }
        return this.centeredHorizontalSeparator1;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            BorderLayout borderLayout = new BorderLayout();
            borderLayout.setVgap(4);
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(borderLayout);
            this.jPanel1.add((Component)this.getJPanel6(), "North");
            this.jPanel1.add((Component)this.getNumberOfBinsPanel(), "Center");
        }
        return this.jPanel1;
    }

    private JCheckBox getMissingBinCheckBox() {
        if (this.missingBinCheckBox == null) {
            this.missingBinCheckBox = new JCheckBox();
            this.missingBinCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.missingBinCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.MissingBin.txt", (String)"Show Missing Bin"));
            this.missingBinCheckBox.addItemListener(this);
        }
        return this.missingBinCheckBox;
    }

    private JPanel getNumberOfBinsPanel() {
        if (this.numberOfBinsPanel == null) {
            this.numberOfBinsPanel = new JPanel();
            this.numberOfBinsPanel.setLayout(new BorderLayout());
            this.numberOfBinsPanel.add((Component)this.getJPanel(), "Center");
            this.numberOfBinsPanel.add((Component)this.getJPanel2(), "East");
        }
        return this.numberOfBinsPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.numberXBinsLabel = new JLabel();
            this.numberXBinsLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.numberXBinsLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.NumberXBins.txt", (String)"Number of X Bins:"));
            this.numberYBinsLabel = new JLabel();
            this.numberYBinsLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.numberYBinsLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.NumberYBins.txt", (String)"Number of Y Bins:"));
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            gridLayout.setHgap(4);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(gridLayout);
            this.jPanel.add((Component)this.numberXBinsLabel, null);
            this.jPanel.add((Component)this.numberYBinsLabel, null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.setRows(2);
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(gridLayout1);
            this.jPanel2.add((Component)this.getNumberXBinsComboBox(), null);
            this.jPanel2.add((Component)this.getNumberYBinsComboBox(), null);
        }
        return this.jPanel2;
    }

    private JComboBox getNumberXBinsComboBox() {
        if (this.numberXBinsComboBox == null) {
            this.numberXBinsComboBox = new JComboBox();
            this.numberXBinsComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.numberXBinsComboBox.setBackground(Color.white);
            this.numberXBinsComboBox.setEditable(true);
            this.initNumberBinsComboBox(this.numberXBinsComboBox);
            this.numberXBinsComboBox.addActionListener(this);
        }
        return this.numberXBinsComboBox;
    }

    private JComboBox getNumberYBinsComboBox() {
        if (this.numberYBinsComboBox == null) {
            this.numberYBinsComboBox = new JComboBox();
            this.numberYBinsComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.numberYBinsComboBox.setBackground(Color.white);
            this.numberYBinsComboBox.setEditable(true);
            this.initNumberBinsComboBox(this.numberYBinsComboBox);
            this.numberYBinsComboBox.addActionListener(this);
        }
        return this.numberYBinsComboBox;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new BorderLayout());
            this.jPanel3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.jPanel3.add((Component)this.getJPanel4(), "North");
            this.jPanel3.add((Component)this.getJPanel5(), "Center");
        }
        return this.jPanel3;
    }

    private JPanel getJPanel4() {
        if (this.jPanel4 == null) {
            this.jPanel4 = new JPanel();
            this.jPanel4.setLayout(new BorderLayout());
            this.jPanel4.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            this.jPanel4.add((Component)this.getColorHeaderPanel(), "North");
            this.jPanel4.add((Component)this.getColorPanel(), "Center");
        }
        return this.jPanel4;
    }

    private JPanel getColorPanel() {
        if (this.colorPanel == null) {
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.setRows(2);
            this.colorPanel = new JPanel();
            this.colorPanel.setLayout(gridLayout2);
            this.colorPanel.add((Component)this.getOutlineCheckBox(), null);
            this.colorPanel.add((Component)this.getGradientCheckBox(), null);
        }
        return this.colorPanel;
    }

    private JCheckBox getOutlineCheckBox() {
        if (this.outlineCheckBox == null) {
            this.outlineCheckBox = new JCheckBox();
            this.outlineCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.outlineCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ShowOutline.txt", (String)"Show Outline"));
            this.outlineCheckBox.addItemListener(this);
        }
        return this.outlineCheckBox;
    }

    private JCheckBox getGradientCheckBox() {
        if (this.gradientCheckBox == null) {
            this.gradientCheckBox = new JCheckBox();
            this.gradientCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.gradientCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Gradient.txt", (String)"Gradient"));
            this.gradientCheckBox.addItemListener(this);
        }
        return this.gradientCheckBox;
    }

    private JPanel getColorHeaderPanel() {
        if (this.colorHeaderPanel == null) {
            this.colorHeaderLabel = new JLabel();
            this.colorHeaderLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.colorHeaderLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.ColorPanel.txt", (String)"Color"));
            this.colorHeaderPanel = new JPanel();
            this.colorHeaderPanel.setLayout(new BorderLayout());
            this.colorHeaderPanel.add((Component)this.colorHeaderLabel, "West");
            this.colorHeaderPanel.add((Component)this.getCenteredHorizontalSeparator2(), "Center");
        }
        return this.colorHeaderPanel;
    }

    private CenteredHorizontalSeparator getCenteredHorizontalSeparator2() {
        if (this.centeredHorizontalSeparator2 == null) {
            this.centeredHorizontalSeparator2 = new CenteredHorizontalSeparator();
        }
        return this.centeredHorizontalSeparator2;
    }

    private JPanel getJPanel5() {
        if (this.jPanel5 == null) {
            this.jPanel5 = new JPanel();
            this.jPanel5.setLayout(new BorderLayout());
            this.jPanel5.add((Component)this.getColorMapperChooserPanel(), "North");
        }
        return this.jPanel5;
    }

    private ColorMapperChooserPanel getColorMapperChooserPanel() {
        if (this.colorMapperChooserPanel == null) {
            this.colorMapperChooserPanel = new ColorMapperChooserPanel();
            this.colorMapperChooserPanel.setListeners(this.propertyListeners);
        }
        return this.colorMapperChooserPanel;
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.refreshGUI();
        }
    }

    private void initNumberBinsComboBox(JComboBox jcb) {
        jcb.removeAllItems();
        for (int i = 5; i <= 30; i += 5) {
            jcb.addItem(Integer.toString(i));
        }
    }

    private void initValuesTypeComboBox(JComboBox jcb) {
        jcb.removeAllItems();
        jcb.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Midpoints.txt", (String)"Midpoints"));
        jcb.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Leftpoints.txt", (String)"Leftpoints"));
        jcb.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Rightpoints.txt", (String)"Rightpoints"));
    }

    protected void updatePanels() {
        Object o = null;
        this.getJPanel1().removeAll();
        this.getJPanel1().add((Component)this.getJPanel6(), "North");
        o = this.getPropertyValue(828);
        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.getJPanel1().add(this.getNumberOfBinsPanel());
        }
        if ((o = this.getPropertyValue(829)) instanceof Boolean && ((Boolean)o).booleanValue()) {
            this.getJPanel1().add(this.getValuesTypePanel());
        }
        if ((o = this.getPropertyValue(834)) instanceof Boolean && !((Boolean)o).booleanValue()) {
            this.getJPanel5().remove(this.getColorMapperChooserPanel());
        }
        if ((o = this.getPropertyValue(823)) instanceof Integer) {
            this.getBinsPanel().add((Component)this.getGroupDisplayStylePanel(), "South");
        }
        if ((o = this.getPropertyValue(832)) == null) {
            this.getJPanel8().remove(this.getBoundaryPanel());
        }
        if ((o = this.getPropertyValue(835)) == null) {
            this.getJPanel8().remove(this.getBinToDataRangeCheckBox());
        }
    }

    protected void refreshGUI() {
        boolean b;
        if (this.propertyListeners == null || this.propertyListeners.size() == 0) {
            return;
        }
        this.disableGUIListening();
        this.colorMapperChooserPanel.initFromSource();
        Object o = null;
        o = this.getPropertyValue(807);
        if (o != null && o instanceof Boolean) {
            this.missingBinCheckBox.setSelected((Boolean)o);
        }
        if ((o = this.getPropertyValue(832)) instanceof Number) {
            this.boundaryComboBox.setSelectedIndex(((Number)o).intValue());
        }
        if ((o = this.getPropertyValue(830)) instanceof Number) {
            this.xValuesTypeComboBox.setSelectedIndex(((Number)o).intValue());
        }
        if ((o = this.getPropertyValue(831)) instanceof Number) {
            this.yValuesTypeComboBox.setSelectedIndex(((Number)o).intValue());
        }
        if ((o = this.getPropertyValue(805)) != null && o instanceof Number) {
            this.numberXBinsComboBox.setSelectedItem(new Integer(((Number)o).intValue()));
        }
        if ((o = this.getPropertyValue(810)) != null && o instanceof Boolean) {
            b = (Boolean)o;
            if (b) {
                this.numberXBinsComboBox.setEnabled(false);
                this.numberXBinsLabel.setEnabled(false);
                this.xValuesTypeLabel.setEnabled(false);
                this.xValuesTypeComboBox.setEnabled(false);
            } else {
                this.numberXBinsComboBox.setEnabled(true);
                this.numberXBinsLabel.setEnabled(true);
                this.xValuesTypeLabel.setEnabled(true);
                this.xValuesTypeComboBox.setEnabled(true);
            }
        }
        if ((o = this.getPropertyValue(806)) != null && o instanceof Number) {
            this.numberYBinsComboBox.setSelectedItem(new Integer(((Number)o).intValue()));
        }
        if ((o = this.getPropertyValue(811)) != null && o instanceof Boolean) {
            b = (Boolean)o;
            if (b) {
                this.numberYBinsComboBox.setEnabled(false);
                this.numberYBinsLabel.setEnabled(false);
                this.yValuesTypeLabel.setEnabled(false);
                this.yValuesTypeComboBox.setEnabled(false);
            } else {
                this.numberYBinsComboBox.setEnabled(true);
                this.numberYBinsLabel.setEnabled(true);
                this.yValuesTypeLabel.setEnabled(true);
                this.yValuesTypeComboBox.setEnabled(true);
            }
        }
        if ((o = this.getPropertyValue(803)) != null && o instanceof Boolean) {
            this.outlineCheckBox.setSelected((Boolean)o);
        }
        if ((o = this.getPropertyValue(819)) != null && o instanceof Boolean) {
            this.gradientCheckBox.setSelected((Boolean)o);
        }
        if ((o = this.getPropertyValue(836)) != null && o instanceof Boolean) {
            this.gradientCheckBox.setEnabled((Boolean)o);
        }
        if ((o = this.getPropertyValue(827)) != null && o instanceof Boolean) {
            this.endLabelsCheckBox.setSelected((Boolean)o);
        }
        if ((o = this.getPropertyValue(826)) != null && o instanceof Boolean) {
            b = (Boolean)o;
            this.binAxisCheckBox.setSelected(b);
            if (b) {
                this.endLabelsCheckBox.setEnabled(true);
            } else {
                this.endLabelsCheckBox.setEnabled(false);
            }
        }
        if ((o = this.getPropertyValue(823)) instanceof Number) {
            int gds = ((Number)o).intValue();
            this.groupDisplayStyleComboBox.setSelectedIndex(gds);
            this.updateFillOptionsWidgets(gds);
        }
        if ((o = this.getPropertyValue(835)) instanceof Boolean) {
            this.binToDataRangeCheckBox.setSelected((Boolean)o);
        }
        this.enableGUIListening();
    }

    private void updateFillOptionsWidgets(int gds) {
        boolean enableFillOptionWidgets = true;
        switch (gds) {
            case 2: {
                enableFillOptionWidgets = false;
            }
        }
        this.outlineCheckBox.setEnabled(enableFillOptionWidgets);
        this.gradientCheckBox.setEnabled(enableFillOptionWidgets);
    }

    protected Object getPropertyValue(int propId) {
        return PropertyUtils.getPropertyValue((Vector)this.propertyListeners, (int)propId);
    }

    protected void disableGUIListening() {
        this.missingBinCheckBox.removeItemListener(this);
        this.binAxisCheckBox.removeItemListener(this);
        this.endLabelsCheckBox.removeItemListener(this);
        this.numberXBinsComboBox.removeActionListener(this);
        this.numberYBinsComboBox.removeActionListener(this);
        this.outlineCheckBox.removeItemListener(this);
        this.gradientCheckBox.removeItemListener(this);
        this.xValuesTypeComboBox.removeActionListener(this);
        this.yValuesTypeComboBox.removeActionListener(this);
        this.boundaryComboBox.removeActionListener(this);
        this.groupDisplayStyleComboBox.removeActionListener(this);
        this.binToDataRangeCheckBox.removeItemListener(this);
    }

    protected void enableGUIListening() {
        this.missingBinCheckBox.addItemListener(this);
        this.binAxisCheckBox.addItemListener(this);
        this.endLabelsCheckBox.addItemListener(this);
        this.numberXBinsComboBox.addActionListener(this);
        this.numberYBinsComboBox.addActionListener(this);
        this.outlineCheckBox.addItemListener(this);
        this.gradientCheckBox.addItemListener(this);
        this.xValuesTypeComboBox.addActionListener(this);
        this.yValuesTypeComboBox.addActionListener(this);
        this.boundaryComboBox.addActionListener(this);
        this.groupDisplayStyleComboBox.addActionListener(this);
        this.binToDataRangeCheckBox.addItemListener(this);
    }

    public void dispose() {
        if (this.propertyListeners != null) {
            this.propertyListeners.removeAllElements();
        }
        this.propertyListeners = null;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() instanceof JCheckBox) {
            Boolean b;
            Boolean bl = b = ((JCheckBox)e.getSource()).isSelected() ? Boolean.TRUE : Boolean.FALSE;
            if (this.missingBinCheckBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)807, (Object)b);
            } else if (this.binAxisCheckBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)826, (Object)b);
            } else if (this.endLabelsCheckBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)827, (Object)b);
            } else if (this.outlineCheckBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)803, (Object)b);
            } else if (this.gradientCheckBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)819, (Object)b);
            } else if (this.binToDataRangeCheckBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)835, (Object)b);
            }
            if (this.binAxisCheckBox.isSelected()) {
                this.endLabelsCheckBox.setEnabled(true);
            } else {
                this.endLabelsCheckBox.setEnabled(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JComboBox) {
            if (this.numberXBinsComboBox == e.getSource()) {
                int b = this.getInt(this.numberXBinsComboBox.getSelectedItem());
                if (b > 0) {
                    Integer bins = new Integer(b);
                    PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)805, (Object)bins);
                }
            } else if (this.numberYBinsComboBox == e.getSource()) {
                int b = this.getInt(this.numberYBinsComboBox.getSelectedItem());
                if (b > 0) {
                    Integer bins = new Integer(b);
                    PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)806, (Object)bins);
                }
            } else if (this.xValuesTypeComboBox == e.getSource()) {
                Integer type = this.getValuesType(this.xValuesTypeComboBox.getSelectedItem());
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)830, (Object)type);
            } else if (this.yValuesTypeComboBox == e.getSource()) {
                Integer type = this.getValuesType(this.yValuesTypeComboBox.getSelectedItem());
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)831, (Object)type);
            } else if (this.boundaryComboBox == e.getSource()) {
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)832, (Object)new Integer(this.boundaryComboBox.getSelectedIndex()));
            } else if (this.groupDisplayStyleComboBox == e.getSource()) {
                int gds = this.groupDisplayStyleComboBox.getSelectedIndex();
                PropertyUtils.setPropertyValue((Vector)this.propertyListeners, (int)823, (Object)new Integer(gds));
                this.updateFillOptionsWidgets(gds);
            }
        }
    }

    private int getInt(Object o) {
        if (o == null) {
            return -1;
        }
        int i = -1;
        try {
            i = Integer.parseInt(o.toString());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return i;
    }

    private Integer getValuesType(Object type) {
        if (type == null) {
            return null;
        }
        String s = type.toString();
        if ("midpoints".equalsIgnoreCase(s)) {
            return new Integer(0);
        }
        if ("leftpoints".equalsIgnoreCase(s)) {
            return new Integer(1);
        }
        if ("rightpoints".equalsIgnoreCase(s)) {
            return new Integer(2);
        }
        return null;
    }

    private JPanel getJPanel6() {
        if (this.jPanel6 == null) {
            this.jPanel6 = new JPanel();
            this.jPanel6.setLayout(new BorderLayout());
            this.jPanel6.add((Component)this.getMissingBinCheckBox(), "North");
            this.jPanel6.add((Component)this.getJPanel7(), "Center");
        }
        return this.jPanel6;
    }

    private JPanel getJPanel7() {
        if (this.jPanel7 == null) {
            this.jPanel7 = new JPanel();
            this.jPanel7.setLayout(new BorderLayout());
            this.jPanel7.add((Component)this.getBinAxisCheckBox(), "West");
            this.jPanel7.add((Component)this.getEndLabelsCheckBox(), "Center");
            this.jPanel7.add((Component)this.getJPanel8(), "South");
        }
        return this.jPanel7;
    }

    private JCheckBox getBinAxisCheckBox() {
        if (this.binAxisCheckBox == null) {
            this.binAxisCheckBox = new JCheckBox();
            this.binAxisCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.BinAxis.txt", (String)"Bin Axis"));
            this.binAxisCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.binAxisCheckBox.addItemListener(this);
        }
        return this.binAxisCheckBox;
    }

    private JCheckBox getEndLabelsCheckBox() {
        if (this.endLabelsCheckBox == null) {
            this.endLabelsCheckBox = new JCheckBox();
            this.endLabelsCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.EndLabels.txt", (String)"End Labels"));
            this.endLabelsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.endLabelsCheckBox.addItemListener(this);
        }
        return this.endLabelsCheckBox;
    }

    private JPanel getValuesTypePanel2() {
        if (this.valuesTypePanel2 == null) {
            GridLayout gridLayout4 = new GridLayout();
            gridLayout4.setRows(2);
            this.valuesTypePanel2 = new JPanel();
            this.valuesTypePanel2.setLayout(gridLayout4);
            this.valuesTypePanel2.add(this.getXValuesTypeComboBox());
            this.valuesTypePanel2.add(this.getYValuesTypeComboBox());
        }
        return this.valuesTypePanel2;
    }

    private JComboBox getXValuesTypeComboBox() {
        if (this.xValuesTypeComboBox == null) {
            this.xValuesTypeComboBox = new JComboBox();
            this.xValuesTypeComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.xValuesTypeComboBox.setBackground(Color.white);
            this.initValuesTypeComboBox(this.xValuesTypeComboBox);
            this.xValuesTypeComboBox.addActionListener(this);
        }
        return this.xValuesTypeComboBox;
    }

    private JComboBox getYValuesTypeComboBox() {
        if (this.yValuesTypeComboBox == null) {
            this.yValuesTypeComboBox = new JComboBox();
            this.yValuesTypeComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.yValuesTypeComboBox.setBackground(Color.white);
            this.initValuesTypeComboBox(this.yValuesTypeComboBox);
            this.yValuesTypeComboBox.addActionListener(this);
        }
        return this.yValuesTypeComboBox;
    }

    private JPanel getValuesTypePanel() {
        if (this.valuesTypePanel == null) {
            this.valuesTypePanel = new JPanel();
            this.valuesTypePanel.setLayout(new BorderLayout());
            this.valuesTypePanel.setSize(new Dimension(211, 61));
            this.valuesTypePanel.add((Component)this.getValuesTypePanel2(), "East");
            this.valuesTypePanel.add((Component)this.getValuesTypePanel3(), "Center");
        }
        return this.valuesTypePanel;
    }

    private JPanel getValuesTypePanel3() {
        if (this.valuesTypePanel3 == null) {
            this.xValuesTypeLabel = new JLabel();
            this.xValuesTypeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.XValues.txt", (String)"X-Values Type:"));
            this.xValuesTypeLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.yValuesTypeLabel = new JLabel();
            this.yValuesTypeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.YValues.txt", (String)"Y-Values Type:"));
            this.yValuesTypeLabel.setFont(TabbedPropertiesDialog.dialogFont);
            GridLayout gridLayout5 = new GridLayout();
            gridLayout5.setRows(2);
            this.valuesTypePanel3 = new JPanel();
            this.valuesTypePanel3.setLayout(gridLayout5);
            this.valuesTypePanel3.add((Component)this.xValuesTypeLabel, null);
            this.valuesTypePanel3.add((Component)this.yValuesTypeLabel, null);
        }
        return this.valuesTypePanel3;
    }

    private JPanel getBoundaryPanel() {
        if (this.boundaryPanel == null) {
            this.boundaryLabel = new JLabel();
            this.boundaryLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Boundary.txt", (String)"Boundary:"));
            this.boundaryLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.boundaryPanel = new JPanel();
            this.boundaryPanel.setLayout(new BorderLayout());
            this.boundaryPanel.add((Component)this.getBoundaryComboBox(), "East");
            this.boundaryPanel.add((Component)this.boundaryLabel, "Center");
        }
        return this.boundaryPanel;
    }

    private JComboBox getBoundaryComboBox() {
        if (this.boundaryComboBox == null) {
            this.boundaryComboBox = new JComboBox();
            this.boundaryComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.boundaryComboBox.setBackground(Color.white);
            this.boundaryComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Upper.txt", (String)"Upper"));
            this.boundaryComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.Lower.txt", (String)"Lower"));
            this.boundaryComboBox.addActionListener(this);
        }
        return this.boundaryComboBox;
    }

    private JPanel getGroupDisplayStylePanel() {
        if (this.groupDisplayStylePanel == null) {
            this.groupDisplayStyleLabel = new JLabel();
            this.groupDisplayStyleLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.GroupDisplayStyle.txt", (String)"Group Display Style:"));
            this.groupDisplayStyleLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.groupDisplayStylePanel = new JPanel();
            this.groupDisplayStylePanel.setLayout(new BorderLayout());
            this.groupDisplayStylePanel.setSize(new Dimension(191, 64));
            this.groupDisplayStylePanel.add((Component)this.getGroupDisplayStyleComboBox(), "East");
            this.groupDisplayStylePanel.add((Component)this.groupDisplayStyleLabel, "Center");
        }
        return this.groupDisplayStylePanel;
    }

    private JComboBox getGroupDisplayStyleComboBox() {
        if (this.groupDisplayStyleComboBox == null) {
            this.groupDisplayStyleComboBox = new JComboBox();
            this.groupDisplayStyleComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.groupDisplayStyleComboBox.setBackground(Color.white);
            this.groupDisplayStyleComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.FillFirstOutlineRest.txt", (String)"Fill First Outline Rest"));
            this.groupDisplayStyleComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.FillAll.txt", (String)"Fill All"));
            this.groupDisplayStyleComboBox.addItem(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.OutlineAll.txt", (String)"Outline All"));
            this.groupDisplayStyleComboBox.addActionListener(this);
        }
        return this.groupDisplayStyleComboBox;
    }

    private JPanel getJPanel8() {
        if (this.jPanel8 == null) {
            this.jPanel8 = new JPanel();
            this.jPanel8.setLayout(new BorderLayout());
            this.jPanel8.setSize(new Dimension(176, 44));
            this.jPanel8.add((Component)this.getBinToDataRangeCheckBox(), "North");
            this.jPanel8.add(this.getBoundaryPanel());
        }
        return this.jPanel8;
    }

    private JCheckBox getBinToDataRangeCheckBox() {
        if (this.binToDataRangeCheckBox == null) {
            this.binToDataRangeCheckBox = new JCheckBox();
            this.binToDataRangeCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.binToDataRangeCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HistogramPanel.BinToDataRange.txt", (String)"Bin to Data Range"));
            this.binToDataRangeCheckBox.addItemListener(this);
        }
        return this.binToDataRangeCheckBox;
    }
}

