/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.HeatmapElementPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.CenteredHorizontalSeparator;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeatmapPanel
extends JPanel
implements ActionListener,
ItemListener,
HeatmapElementPropertyInterface,
TabPanelInterface,
ChangeListener {
    private static final long serialVersionUID = 8630076510931810483L;
    protected Vector<PropertyInterface> propertyListeners = new Vector();
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected TitledBorder border;
    private JPanel cellStylePanel = null;
    private JPanel cellStyleOptionsPanel = null;
    private JCheckBox outlineCheckBox = null;
    private JSpinner xAxisGapSpinner = null;
    private JSpinner yAxisGapSpinner = null;
    private JPanel colorHeaderPanel = null;
    private JLabel colorHeaderLabel = null;
    private CenteredHorizontalSeparator colorHeaderPanelCenteredHorizontalSeparator = null;
    private JPanel colorMapperPanel = null;
    private ColorMapperChooserPanel colorMapperChooserPanel = null;
    private JPanel binSettingsPanel = null;
    private JPanel binSettingsHeaderPanel = null;
    private JPanel binSettingsOptionsPanel = null;
    private JSpinner xAxisNumberOfBinsSpinner = null;
    private JSpinner yAxisNumberOfBinsSpinner = null;
    private JCheckBox xAxisBinToDataRangeCheckBox = null;
    private JCheckBox yAxisBinToDataRangeCheckBox = null;
    private JCheckBox xAxisIsBinAxisCheckBox = null;
    private JCheckBox yAxisIsBinAxisCheckBox = null;
    private JCheckBox xAxisShowEndLabelsCheckBox = null;
    private JCheckBox yAxisShowEndLabelsCheckBox = null;
    private JPanel axisValuesTypePanel = null;

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener(this.propertyListeners, (PropertyInterface)prop);
    }

    @Override
    public boolean applyChanges() {
        return PropertyUtils.applyChanges(this.propertyListeners);
    }

    @Override
    public boolean cancelChanges() {
        this.updateGUI();
        return PropertyUtils.cancelChanges(this.propertyListeners);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener(this.propertyListeners, (PropertyInterface)prop);
    }

    private JPanel getBinSettingsHeaderPanel() {
        if (this.binSettingsHeaderPanel == null) {
            this.binSettingsHeaderPanel = new JPanel();
            this.binSettingsHeaderPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel();
            label.setFont(TabbedPropertiesDialog.dialogFont);
            label.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.BinSettingsPanelLabel.txt", (String)"Bin Settings"));
            this.binSettingsHeaderPanel.add((Component)label, "West");
            this.binSettingsHeaderPanel.add((Component)new CenteredHorizontalSeparator(), "Center");
        }
        return this.binSettingsHeaderPanel;
    }

    private JPanel getBinSettingsOptionsPanel() {
        if (this.binSettingsOptionsPanel == null) {
            this.binSettingsOptionsPanel = new JPanel();
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(8);
            this.binSettingsOptionsPanel.setLayout(gridLayout);
            this.binSettingsOptionsPanel.add(this.getXAxisIsBinAxisCheckBox());
            this.binSettingsOptionsPanel.add(this.getYAxisIsBinAxisCheckBox());
            this.binSettingsOptionsPanel.add(this.getXAxisEndLabelsCheckBox());
            this.binSettingsOptionsPanel.add(this.getYAxisEndLabelsCheckBox());
            this.binSettingsOptionsPanel.add(this.getXAxisBinToDataRangeCheckBox());
            this.binSettingsOptionsPanel.add(this.getYAxisBinToDataRangeCheckBox());
            this.binSettingsOptionsPanel.add(this.getXAxisNumberOfBinsPanel());
            this.binSettingsOptionsPanel.add(this.getYAxisNumberOfBinsPanel());
        }
        return this.binSettingsOptionsPanel;
    }

    private JCheckBox getXAxisIsBinAxisCheckBox() {
        if (this.xAxisIsBinAxisCheckBox == null) {
            this.xAxisIsBinAxisCheckBox = new JCheckBox();
            this.xAxisIsBinAxisCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.xAxisIsBinAxisCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.XAxisIsBinAxisLabel.txt", (String)"X Bin Axis"));
            this.xAxisIsBinAxisCheckBox.addItemListener(this);
        }
        return this.xAxisIsBinAxisCheckBox;
    }

    private JCheckBox getYAxisIsBinAxisCheckBox() {
        if (this.yAxisIsBinAxisCheckBox == null) {
            this.yAxisIsBinAxisCheckBox = new JCheckBox();
            this.yAxisIsBinAxisCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.yAxisIsBinAxisCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.YAxisIsBinAxisLabel.txt", (String)"Y Bin Axis"));
            this.yAxisIsBinAxisCheckBox.addItemListener(this);
        }
        return this.yAxisIsBinAxisCheckBox;
    }

    private JCheckBox getXAxisEndLabelsCheckBox() {
        if (this.xAxisShowEndLabelsCheckBox == null) {
            this.xAxisShowEndLabelsCheckBox = new JCheckBox();
            this.xAxisShowEndLabelsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.xAxisShowEndLabelsCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.XAxisBinLabels.txt", (String)"X End Labels"));
            this.xAxisShowEndLabelsCheckBox.addItemListener(this);
        }
        return this.xAxisShowEndLabelsCheckBox;
    }

    private JCheckBox getYAxisEndLabelsCheckBox() {
        if (this.yAxisShowEndLabelsCheckBox == null) {
            this.yAxisShowEndLabelsCheckBox = new JCheckBox();
            this.yAxisShowEndLabelsCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.yAxisShowEndLabelsCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.YAxisBinLabels.txt", (String)"Y End Labels"));
            this.yAxisShowEndLabelsCheckBox.addItemListener(this);
        }
        return this.yAxisShowEndLabelsCheckBox;
    }

    private JCheckBox getXAxisBinToDataRangeCheckBox() {
        if (this.xAxisBinToDataRangeCheckBox == null) {
            this.xAxisBinToDataRangeCheckBox = new JCheckBox();
            this.xAxisBinToDataRangeCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.xAxisBinToDataRangeCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.BinToXDataRange.txt", (String)"Bin X-values to Data Range"));
            this.xAxisBinToDataRangeCheckBox.addItemListener(this);
        }
        return this.xAxisBinToDataRangeCheckBox;
    }

    private JCheckBox getYAxisBinToDataRangeCheckBox() {
        if (this.yAxisBinToDataRangeCheckBox == null) {
            this.yAxisBinToDataRangeCheckBox = new JCheckBox();
            this.yAxisBinToDataRangeCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.yAxisBinToDataRangeCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.BinToYDataRange.txt", (String)"Bin Y-values to Data Range"));
            this.yAxisBinToDataRangeCheckBox.addItemListener(this);
        }
        return this.yAxisBinToDataRangeCheckBox;
    }

    protected void disableGUIListening() {
        this.outlineCheckBox.removeItemListener(this);
        this.xAxisGapSpinner.removeChangeListener(this);
        this.yAxisGapSpinner.removeChangeListener(this);
        this.xAxisNumberOfBinsSpinner.removeChangeListener(this);
        this.yAxisNumberOfBinsSpinner.removeChangeListener(this);
        this.xAxisBinToDataRangeCheckBox.removeItemListener(this);
        this.yAxisBinToDataRangeCheckBox.removeItemListener(this);
        this.xAxisIsBinAxisCheckBox.removeItemListener(this);
        this.yAxisIsBinAxisCheckBox.removeItemListener(this);
        this.xAxisShowEndLabelsCheckBox.removeItemListener(this);
        this.xAxisShowEndLabelsCheckBox.removeItemListener(this);
    }

    protected void enableGUIListening() {
        this.outlineCheckBox.addItemListener(this);
        this.xAxisGapSpinner.addChangeListener(this);
        this.yAxisGapSpinner.addChangeListener(this);
        this.xAxisNumberOfBinsSpinner.addChangeListener(this);
        this.yAxisNumberOfBinsSpinner.addChangeListener(this);
        this.xAxisBinToDataRangeCheckBox.addItemListener(this);
        this.yAxisBinToDataRangeCheckBox.addItemListener(this);
        this.xAxisIsBinAxisCheckBox.addItemListener(this);
        this.yAxisIsBinAxisCheckBox.addItemListener(this);
        this.xAxisShowEndLabelsCheckBox.addItemListener(this);
        this.xAxisShowEndLabelsCheckBox.addItemListener(this);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.disableGUIListening();
            this.updateGUI();
            this.enableGUIListening();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof JComboBox) {
            // empty if block
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == null) {
            return;
        }
        if (source instanceof JCheckBox) {
            JCheckBox check = (JCheckBox)source;
            boolean status = check.isSelected();
            if (check.equals(this.outlineCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333636, (Object)new Boolean(status));
            } else if (check.equals(this.xAxisBinToDataRangeCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333652, (Object)new Boolean(status));
            } else if (check.equals(this.yAxisBinToDataRangeCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333653, (Object)new Boolean(status));
            } else if (check.equals(this.xAxisIsBinAxisCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333650, (Object)new Boolean(status));
                this.xAxisShowEndLabelsCheckBox.setEnabled(status);
            } else if (check.equals(this.yAxisIsBinAxisCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333651, (Object)new Boolean(status));
                this.yAxisShowEndLabelsCheckBox.setEnabled(status);
            } else if (check.equals(this.xAxisShowEndLabelsCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333654, (Object)new Boolean(status));
            } else if (check.equals(this.yAxisShowEndLabelsCheckBox)) {
                PropertyUtils.setPropertyValue(this.propertyListeners, (int)333655, (Object)new Boolean(status));
            }
        } else {
            return;
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (source == this.xAxisGapSpinner) {
            PropertyUtils.setPropertyValue(this.propertyListeners, (int)333643, (Object)((Number)this.xAxisGapSpinner.getValue()));
        } else if (source == this.yAxisGapSpinner) {
            PropertyUtils.setPropertyValue(this.propertyListeners, (int)333644, (Object)((Number)this.yAxisGapSpinner.getValue()));
        } else if (source == this.xAxisNumberOfBinsSpinner) {
            PropertyUtils.setPropertyValue(this.propertyListeners, (int)333664, (Object)((Number)this.xAxisNumberOfBinsSpinner.getValue()));
        } else if (source == this.yAxisNumberOfBinsSpinner) {
            PropertyUtils.setPropertyValue(this.propertyListeners, (int)333665, (Object)((Number)this.yAxisNumberOfBinsSpinner.getValue()));
        }
    }

    protected double getNumericProperty(Vector props, int id, double defaultValue) {
        Object o = PropertyUtils.getPropertyValue(this.propertyListeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected boolean getBooleanProperty(Vector props, int id, boolean defaultValue) {
        Object o = PropertyUtils.getPropertyValue(this.propertyListeners, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (!(c instanceof JPanel)) continue;
            this.updatePanelUI((JComponent)c);
        }
    }

    public void updateGUI() {
        if (this.propertyListeners == null || this.propertyListeners.size() == 0) {
            return;
        }
        this.outlineCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333636));
        this.xAxisIsBinAxisCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333650));
        this.yAxisIsBinAxisCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333651));
        this.xAxisShowEndLabelsCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333654));
        this.yAxisShowEndLabelsCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333655));
        this.xAxisBinToDataRangeCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333652));
        this.yAxisBinToDataRangeCheckBox.setSelected((Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333653));
        this.xAxisGapSpinner.setValue(((Number)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333643)).intValue());
        this.yAxisGapSpinner.setValue(((Number)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333644)).intValue());
        this.xAxisNumberOfBinsSpinner.setValue(((Number)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333664)).intValue());
        this.yAxisNumberOfBinsSpinner.setValue(((Number)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333665)).intValue());
        boolean axisIsContinuous = (Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333659);
        this.xAxisIsBinAxisCheckBox.setEnabled(axisIsContinuous);
        this.xAxisShowEndLabelsCheckBox.setEnabled(axisIsContinuous && this.xAxisIsBinAxisCheckBox.isSelected());
        this.xAxisBinToDataRangeCheckBox.setEnabled(axisIsContinuous);
        this.xAxisNumberOfBinsSpinner.setEnabled(axisIsContinuous);
        axisIsContinuous = (Boolean)PropertyUtils.getPropertyValue(this.propertyListeners, (int)333660);
        this.yAxisIsBinAxisCheckBox.setEnabled(axisIsContinuous);
        this.yAxisShowEndLabelsCheckBox.setEnabled(axisIsContinuous && this.yAxisIsBinAxisCheckBox.isSelected());
        this.yAxisBinToDataRangeCheckBox.setEnabled(axisIsContinuous);
        this.yAxisNumberOfBinsSpinner.setEnabled(axisIsContinuous);
        this.colorMapperChooserPanel.initFromSource();
    }

    private JPanel getBinSettingsPanel() {
        if (this.binSettingsPanel == null) {
            this.binSettingsPanel = new JPanel();
            this.binSettingsPanel.setLayout(new BorderLayout());
            this.binSettingsPanel.add((Component)this.getBinSettingsHeaderPanel(), "North");
            this.binSettingsPanel.add((Component)this.getBinSettingsOptionsPanel(), "Center");
        }
        return this.binSettingsPanel;
    }

    private JPanel getCellStylePanel() {
        if (this.cellStylePanel == null) {
            this.cellStylePanel = new JPanel();
            this.cellStylePanel.setLayout(new BorderLayout());
            this.cellStylePanel.setBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0));
            this.cellStylePanel.add((Component)this.getColorHeaderPanel(), "North");
            this.cellStylePanel.add((Component)this.getCellStyleOptionsPanel(), "Center");
            this.cellStylePanel.add((Component)this.getColorMapperPanel(), "South");
        }
        return this.cellStylePanel;
    }

    private JPanel getColorMapperPanel() {
        if (this.colorMapperPanel == null) {
            this.colorMapperPanel = new JPanel();
            this.colorMapperPanel.setLayout(new BorderLayout());
            this.colorMapperPanel.add((Component)this.getColorMapperChooserPanel(), "North");
        }
        return this.colorMapperPanel;
    }

    private JPanel getColorHeaderPanel() {
        if (this.colorHeaderPanel == null) {
            this.colorHeaderLabel = new JLabel();
            this.colorHeaderLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.colorHeaderLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.CellStylePanelLabel.txt", (String)"Cell Style"));
            this.colorHeaderPanel = new JPanel();
            this.colorHeaderPanel.setLayout(new BorderLayout());
            this.colorHeaderPanel.add((Component)this.colorHeaderLabel, "West");
            this.colorHeaderPanel.add((Component)this.getColorHeaderPanelCenteredHorizontalSeparator(), "Center");
        }
        return this.colorHeaderPanel;
    }

    private CenteredHorizontalSeparator getColorHeaderPanelCenteredHorizontalSeparator() {
        if (this.colorHeaderPanelCenteredHorizontalSeparator == null) {
            this.colorHeaderPanelCenteredHorizontalSeparator = new CenteredHorizontalSeparator();
        }
        return this.colorHeaderPanelCenteredHorizontalSeparator;
    }

    private JPanel getCellStyleOptionsPanel() {
        if (this.cellStyleOptionsPanel == null) {
            GridLayout gridLayout2 = new GridLayout();
            gridLayout2.setRows(3);
            this.cellStyleOptionsPanel = new JPanel();
            this.cellStyleOptionsPanel.setLayout(gridLayout2);
            this.cellStyleOptionsPanel.add((Component)this.getXAxisGapPanel(), null);
            this.cellStyleOptionsPanel.add((Component)this.getYAxisGapPanel(), null);
            this.cellStyleOptionsPanel.add((Component)this.getOutlineCheckBox(), null);
        }
        return this.cellStyleOptionsPanel;
    }

    private JCheckBox getOutlineCheckBox() {
        if (this.outlineCheckBox == null) {
            this.outlineCheckBox = new JCheckBox();
            this.outlineCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.outlineCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.ShowOutline.txt", (String)"Show Outline"));
            this.outlineCheckBox.addItemListener(this);
        }
        return this.outlineCheckBox;
    }

    private JPanel getXAxisGapPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.xAxisGapLabel.txt", (String)"X-Axis Gap (pixels):"));
        panel.add((Component)label, "West");
        panel.add((Component)this.getXAxisGapSpinner(), "Center");
        return panel;
    }

    private JSpinner getXAxisGapSpinner() {
        if (this.xAxisGapSpinner == null) {
            this.xAxisGapSpinner = new JSpinner();
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 0, 100, 1);
            this.xAxisGapSpinner.setFont(TabbedPropertiesDialog.dialogFont);
            this.xAxisGapSpinner.setModel(spinnerNumberModel);
            this.xAxisGapSpinner.setEditor(new JSpinner.NumberEditor(this.xAxisGapSpinner));
        }
        return this.xAxisGapSpinner;
    }

    private JSpinner getYAxisGapSpinner() {
        if (this.yAxisGapSpinner == null) {
            this.yAxisGapSpinner = new JSpinner();
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 0, 100, 1);
            this.yAxisGapSpinner.setFont(TabbedPropertiesDialog.dialogFont);
            this.yAxisGapSpinner.setModel(spinnerNumberModel);
            this.yAxisGapSpinner.setEditor(new JSpinner.NumberEditor(this.yAxisGapSpinner));
        }
        return this.yAxisGapSpinner;
    }

    private JPanel getYAxisGapPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        JLabel label = new JLabel();
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.yAxisGapLabel.txt", (String)"Y-Axis Gap (pixels):"));
        panel.add((Component)label, "West");
        panel.add((Component)this.getYAxisGapSpinner(), "Center");
        return panel;
    }

    private JPanel getNumberOfBinsPanel() {
        JPanel panel = new JPanel();
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.setRows(4);
        panel = new JPanel();
        panel.setLayout(gridLayout2);
        panel.add((Component)this.getXAxisNumberOfBinsPanel(), null);
        panel.add((Component)this.getYAxisNumberOfBinsPanel(), null);
        return panel;
    }

    private JPanel getXAxisNumberOfBinsPanel() {
        JLabel xLabel = new JLabel();
        xLabel.setFont(TabbedPropertiesDialog.dialogFont);
        xLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.NumberofXBinsLabel.txt", (String)"Number of X Bins:"));
        JPanel xPanel = new JPanel();
        xPanel.setLayout(new BorderLayout());
        xPanel.add((Component)xLabel, "West");
        xPanel.add((Component)this.getXAxisNumberOfBinsSpinner(), "Center");
        return xPanel;
    }

    private JPanel getYAxisNumberOfBinsPanel() {
        JLabel yLabel = new JLabel();
        yLabel.setFont(TabbedPropertiesDialog.dialogFont);
        yLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"HeatmapPanel.NumberofYBinsLabel.txt", (String)"Number of Y Bins:"));
        JPanel yPanel = new JPanel();
        yPanel.setLayout(new BorderLayout());
        yPanel.add((Component)yLabel, "West");
        yPanel.add((Component)this.getYAxisNumberOfBinsSpinner(), "Center");
        return yPanel;
    }

    private JSpinner getXAxisNumberOfBinsSpinner() {
        if (this.xAxisNumberOfBinsSpinner == null) {
            this.xAxisNumberOfBinsSpinner = new JSpinner();
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 0, 200, 1);
            this.xAxisNumberOfBinsSpinner.setFont(TabbedPropertiesDialog.dialogFont);
            this.xAxisNumberOfBinsSpinner.setModel(spinnerNumberModel);
            this.xAxisNumberOfBinsSpinner.setEditor(new JSpinner.NumberEditor(this.xAxisNumberOfBinsSpinner));
        }
        return this.xAxisNumberOfBinsSpinner;
    }

    private JSpinner getYAxisNumberOfBinsSpinner() {
        if (this.yAxisNumberOfBinsSpinner == null) {
            this.yAxisNumberOfBinsSpinner = new JSpinner();
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(10, 0, 200, 1);
            this.yAxisNumberOfBinsSpinner.setFont(TabbedPropertiesDialog.dialogFont);
            this.yAxisNumberOfBinsSpinner.setModel(spinnerNumberModel);
            this.yAxisNumberOfBinsSpinner.setEditor(new JSpinner.NumberEditor(this.yAxisNumberOfBinsSpinner));
        }
        return this.yAxisNumberOfBinsSpinner;
    }

    private ColorMapperChooserPanel getColorMapperChooserPanel() {
        if (this.colorMapperChooserPanel == null) {
            this.colorMapperChooserPanel = new ColorMapperChooserPanel();
            this.colorMapperChooserPanel.setListeners(this.propertyListeners);
        }
        return this.colorMapperChooserPanel;
    }

    public HeatmapPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 4));
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add((Component)this.getBinSettingsPanel(), "North");
        this.add((Component)this.getCellStylePanel(), "Center");
    }

    public void dispose() {
        if (this.propertyListeners != null) {
            this.propertyListeners.removeAllElements();
        }
        this.propertyListeners = null;
    }
}

