/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.UIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GraphPropertiesTabPanel
extends JTabbedPane
implements TabPanelInterface {
    private static final long serialVersionUID = 7862463306550074080L;
    private Hashtable panels = new Hashtable();

    public GraphPropertiesTabPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setSize(300, 200);
        this.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = GraphPropertiesTabPanel.this.getSelectedComponent();
                if (c instanceof JScrollPane) {
                    c = ((JScrollPane)c).getViewport().getView();
                }
                c.setVisible(true);
            }
        });
        this.setPreferredSize(new Dimension(5, 5));
        this.setFont(UIUtilities.getSILKDialogFont());
    }

    public void addNewTab(String name, TabPanelInterface tab) {
        if (name == null || tab == null) {
            return;
        }
        this.panels.put(name, tab);
        if (tab instanceof Component) {
            this.addTab(name, new JScrollPane((Component)((Object)tab)));
        }
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        boolean rc = true;
        Enumeration e = this.panels.keys();
        while (e.hasMoreElements()) {
            TabPanelInterface tpi = (TabPanelInterface)this.panels.get(e.nextElement());
            rc |= tpi.addPropertyListener(prop);
        }
        return rc;
    }

    @Override
    public boolean applyChanges() {
        boolean rc = true;
        Enumeration e = this.panels.keys();
        while (e.hasMoreElements()) {
            TabPanelInterface tpi = (TabPanelInterface)this.panels.get(e.nextElement());
            rc |= tpi.applyChanges();
        }
        return rc;
    }

    @Override
    public boolean cancelChanges() {
        boolean rc = true;
        Enumeration e = this.panels.keys();
        while (e.hasMoreElements()) {
            TabPanelInterface tpi = (TabPanelInterface)this.panels.get(e.nextElement());
            rc |= tpi.cancelChanges();
        }
        return rc;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        boolean rc = true;
        Enumeration e = this.panels.keys();
        while (e.hasMoreElements()) {
            TabPanelInterface tpi = (TabPanelInterface)this.panels.get(e.nextElement());
            rc |= tpi.removePropertyListener(prop);
        }
        return rc;
    }
}

