/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyEvent;
import com.sas.text.FormatDescription;
import com.sas.text.SASCharacterFormat;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

class FormatPanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1025891370019576437L;
    TextDialog textDialog;
    JComboBox formatCombo = new JComboBox();
    JTextArea description = new JTextArea();
    FormatDescription[] charFormats;
    FormatDescription[] numberFormats;
    FormatDescription[] dateFormats;
    PropertyInterface source = null;

    public FormatPanel(TextDialog dialog, ResourceBundle rb) {
        int i;
        this.textDialog = dialog;
        this.setLayout(null);
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"TextDialog.Format_Label.txt", (String)"Format:"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(10, 10, 50, 25);
        this.add(label);
        this.formatCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.formatCombo.setBounds(65, 10, 150, 25);
        this.formatCombo.setBackground(Color.white);
        this.formatCombo.addActionListener(this);
        this.add(this.formatCombo);
        this.charFormats = SASCharacterFormat.getDescriptions();
        for (i = 0; i < this.charFormats.length; ++i) {
            this.formatCombo.addItem(this.charFormats[i].getBaseFormatName());
        }
        this.numberFormats = SASNumericFormat.getDescriptions();
        for (i = 0; i < this.numberFormats.length; ++i) {
            this.formatCombo.addItem(this.numberFormats[i].getBaseFormatName());
        }
        this.dateFormats = SASDateTimeFormat.getDescriptions();
        for (i = 0; i < this.dateFormats.length; ++i) {
            this.formatCombo.addItem(this.dateFormats[i].getBaseFormatName());
        }
        this.description.setFont(TabbedPropertiesDialog.dialogFont);
        this.description.setEditable(false);
        this.description.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"TextDialog.Description.txt", (String)"Description")));
        this.description.setBounds(10, 45, 430, 175);
        this.description.setBackground(this.getBackground());
        this.add(this.description);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int i;
        SASFormat format = SASFormat.getInstance((String)this.formatCombo.getSelectedItem().toString());
        String s = format.getBaseFormatName();
        if (this.source != null) {
            this.source.setPropertyValue(9008, (Object)new PropertyEvent(9008, (Object)this.textDialog, (Object)format));
        }
        Locale l = this.getLocale();
        for (i = 0; i < this.charFormats.length; ++i) {
            if (!s.equals(this.charFormats[i].getBaseFormatName())) continue;
            this.description.setText(this.charFormats[i].getDescription(l));
            return;
        }
        for (i = 0; i < this.numberFormats.length; ++i) {
            if (!s.equals(this.numberFormats[i].getBaseFormatName())) continue;
            this.description.setText(this.numberFormats[i].getDescription(l));
            return;
        }
        for (i = 0; i < this.dateFormats.length; ++i) {
            if (!s.equals(this.dateFormats[i].getBaseFormatName())) continue;
            this.description.setText(this.dateFormats[i].getDescription(l));
            return;
        }
    }

    public void init(PropertyInterface propertyInterface) {
        this.source = propertyInterface;
        Object object = this.source.getPropertyValue(9008);
        if (object == null) {
            return;
        }
        this.formatCombo.removeActionListener(this);
        if (object instanceof String) {
            this.formatCombo.setSelectedItem(object);
        }
        if (object instanceof SASFormat) {
            this.formatCombo.setSelectedItem(((SASFormat)object).getBaseFormatName());
        }
        this.formatCombo.addActionListener(this);
    }
}

