/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyEvent;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class EffectsPanel
extends JPanel
implements ActionListener,
ChangeListener {
    private static final long serialVersionUID = 2252426554082992472L;
    TextDialog textDialog;
    JCheckBox shadowsOn = null;
    JButton colorButton = null;
    JSlider shadowSlider = null;
    JCheckBox underline = null;
    JCheckBox strikethru = null;
    JPanel shadowColor = new JPanel();
    JSlider transSlider = new JSlider();
    PropertyInterface source = null;
    ResourceBundle rb = null;

    public EffectsPanel(TextDialog dialog, ResourceBundle res) {
        this.textDialog = dialog;
        this.rb = res;
        this.shadowsOn = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Shadows.txt", (String)"Shadows"));
        this.colorButton = new JButton("...");
        this.shadowSlider = new JSlider();
        this.underline = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Underline.txt", (String)"Underline"));
        this.strikethru = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Strikethrough.txt", (String)"Strikethrough"));
        this.shadowsOn.setFont(TabbedPropertiesDialog.dialogFont);
        this.colorButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.shadowSlider.setFont(TabbedPropertiesDialog.dialogFont);
        this.underline.setFont(TabbedPropertiesDialog.dialogFont);
        this.strikethru.setFont(TabbedPropertiesDialog.dialogFont);
        this.setLayout(null);
        this.shadowsOn.setBounds(10, 10, 125, 25);
        this.add(this.shadowsOn);
        this.shadowsOn.addActionListener(this);
        JSeparator sep = new JSeparator();
        sep.setBounds(130, 22, 350, 2);
        this.add(sep);
        JLabel label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Color_label.txt", (String)"Color:"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(50, 40, 75, 25);
        this.add(label);
        this.shadowColor.setBackground(Color.lightGray);
        this.shadowColor.setBounds(170, 40, 130, 25);
        this.add(this.shadowColor);
        this.colorButton.setBounds(300, 40, 25, 25);
        this.colorButton.addActionListener(this);
        this.add(this.colorButton);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Softness.txt", (String)"Softness:"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(50, 70, 105, 25);
        this.add(label);
        this.shadowSlider.setBounds(170, 70, 155, 25);
        this.shadowSlider.addChangeListener(this);
        this.add(this.shadowSlider);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Transparency.txt", (String)"Transparency"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(10, 95, 170, 25);
        this.add(label);
        sep = new JSeparator();
        sep.setBounds(155, 107, 345, 2);
        this.add(sep);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Fully_Transparent.txt", (String)"Fully Transparent"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(40, 125, 140, 25);
        this.add(label);
        this.transSlider.setBounds(170, 125, 155, 25);
        this.transSlider.addChangeListener(this);
        this.add(this.transSlider);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Fully_Opaque.txt", (String)"Fully Opaque"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(330, 125, 125, 25);
        this.add(label);
        label = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Effects.txt", (String)"Effects"));
        label.setFont(TabbedPropertiesDialog.dialogFont);
        label.setBounds(10, 145, 80, 25);
        this.add(label);
        sep = new JSeparator();
        sep.setBounds(85, 157, 380, 2);
        this.add(sep);
        this.underline.setBounds(50, 170, 150, 25);
        this.underline.addActionListener(this);
        this.add(this.underline);
        this.strikethru.setBounds(50, 195, 170, 25);
        this.strikethru.addActionListener(this);
        this.add(this.strikethru);
    }

    public void init(PropertyInterface source) {
        this.source = source;
        Object object = source.getPropertyValue(9003);
        if (object instanceof Boolean) {
            this.shadowsOn.setSelected((Boolean)object);
        } else {
            this.shadowsOn.setSelected(false);
        }
        if (!this.shadowsOn.isSelected()) {
            this.colorButton.setEnabled(false);
            this.shadowSlider.setEnabled(false);
        }
        if ((object = source.getPropertyValue(9005)) instanceof Color) {
            this.shadowColor.setBackground((Color)object);
        }
        if ((object = source.getPropertyValue(9004)) instanceof Number) {
            this.shadowSlider.setValue((int)(100.0 * ((Number)object).doubleValue()));
        }
        if ((object = source.getPropertyValue(9016)) instanceof Number) {
            this.transSlider.setValue((int)(100.0 * ((Number)object).doubleValue()));
        }
        if ((object = source.getPropertyValue(9009)) instanceof Boolean) {
            this.underline.setSelected((Boolean)object);
        }
        if ((object = source.getPropertyValue(9010)) instanceof Boolean) {
            this.strikethru.setSelected((Boolean)object);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.colorButton.setEnabled(this.shadowsOn.isSelected());
        this.shadowSlider.setEnabled(this.shadowsOn.isSelected());
        if (e.getSource() == this.colorButton) {
            Color c = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)this.rb, (String)"TextDialog.Shadow_Color.txt", (String)"Shadow Color"), this.shadowColor.getBackground());
            if (c != null) {
                this.shadowColor.setBackground(c);
            }
            this.source.setPropertyValue(9005, (Object)new PropertyEvent(9005, (Object)this.textDialog, (Object)this.shadowColor.getBackground()));
        } else if (e.getSource() == this.shadowsOn) {
            this.source.setPropertyValue(9003, (Object)new PropertyEvent(9003, (Object)this.textDialog, (Object)new Boolean(this.shadowsOn.isSelected())));
        } else if (e.getSource() == this.underline) {
            this.source.setPropertyValue(9009, (Object)new PropertyEvent(9009, (Object)this.textDialog, (Object)new Boolean(this.underline.isSelected())));
        } else if (e.getSource() == this.strikethru) {
            this.source.setPropertyValue(9010, (Object)new PropertyEvent(9010, (Object)this.textDialog, (Object)new Boolean(this.strikethru.isSelected())));
        }
        this.textDialog.textChanged();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.shadowSlider) {
            this.source.setPropertyValue(9004, (Object)new PropertyEvent(9004, (Object)this.textDialog, (Object)new Double((double)this.shadowSlider.getValue() / 100.0)));
        } else if (src == this.transSlider) {
            this.source.setPropertyValue(9016, (Object)new PropertyEvent(9016, (Object)this.textDialog, (Object)new Double((double)this.transSlider.getValue() / 100.0)));
        }
        this.textDialog.textChanged();
    }
}

