/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.text.SASFormat;
import com.sas.text.SASNumericFormat;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DensityPlotPanel
extends JPanel
implements TabPanelInterface {
    private static final long serialVersionUID = 7228043225508443323L;
    private JCheckBox jCheckBox = null;
    private JSlider jSlider = null;
    private Vector listeners = new Vector();
    private static SASFormat format = SASNumericFormat.getInstance((String)"4.2");
    private JLabel jLabel = null;
    private boolean ignoreEvents = false;

    public DensityPlotPanel() {
        this((PropertyInterface)null);
    }

    public DensityPlotPanel(PropertyInterface prop) {
        this.addPropertyListener(prop);
        this.initialize();
    }

    @Override
    public boolean applyChanges() {
        boolean rc = PropertyUtils.applyChanges((Vector)this.listeners);
        this.initFromSource();
        return rc;
    }

    private void setOpacityProperty() {
        if (this.jCheckBox.isSelected()) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)13001, (Object)new Double(Double.NaN));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)13000, (Object)new Double(Double.NaN));
        } else {
            double value = (double)this.jSlider.getValue() / 100.0 + 0.01;
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)13001, (Object)new Double(value));
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)13000, (Object)new Double(Double.NaN));
        }
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.listeners);
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.initFromSource();
        super.setVisible(aFlag);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return PropertyUtils.addPropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.listeners, (PropertyInterface)prop);
    }

    private void initialize() {
        this.jLabel = new JLabel();
        this.setLayout(null);
        this.setSize(256, 410);
        this.jLabel.setBounds(33, 50, 40, 20);
        this.jLabel.setText("JLabel");
        this.jLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.add((Component)this.getJCheckBox(), null);
        this.add((Component)this.getJSlider(), null);
        this.add((Component)this.jLabel, null);
        this.initFromSource();
    }

    public void initFromSource() {
        this.ignoreEvents = true;
        Object obj = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)13001);
        double sliderValue = 0.01;
        if (obj != null && obj instanceof Number && !Double.isNaN(((Number)obj).doubleValue())) {
            this.getJSlider().setEnabled(true);
            this.getJCheckBox().setSelected(false);
            sliderValue = ((Number)obj).doubleValue();
        } else {
            this.getJSlider().setEnabled(false);
            this.getJCheckBox().setSelected(true);
            obj = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)13000);
            if (obj != null && obj instanceof Number && !Double.isNaN(((Number)obj).doubleValue())) {
                sliderValue = ((Number)obj).doubleValue();
            }
        }
        this.getJSlider().setValue((int)((sliderValue - 0.01) * 100.0));
        this.ignoreEvents = false;
    }

    private JCheckBox getJCheckBox() {
        if (this.jCheckBox == null) {
            this.jCheckBox = new JCheckBox();
            this.jCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.jCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DensityPlotPanel.this.getJSlider().setEnabled(!DensityPlotPanel.this.jCheckBox.isSelected());
                    if (DensityPlotPanel.this.ignoreEvents) {
                        return;
                    }
                    DensityPlotPanel.this.setOpacityProperty();
                }
            });
            this.jCheckBox.setBounds(24, 26, 152, 21);
            this.jCheckBox.setText(ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"DensityPlotPanel.Auto_Calculate_Opacity.txt", (String)"Auto-calculate opacity"));
        }
        return this.jCheckBox;
    }

    private JSlider getJSlider() {
        if (this.jSlider == null) {
            this.jSlider = new JSlider();
            this.jSlider.setMinimum(1);
            this.jSlider.setMaximum(95);
            this.jSlider.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    double range = 94.0;
                    double value = (double)DensityPlotPanel.this.jSlider.getValue() / range;
                    value = Math.max(0.01, value);
                    value = Math.min(0.95, value);
                    DensityPlotPanel.this.jLabel.setText(format.format((Object)new Double(value)));
                    if (DensityPlotPanel.this.ignoreEvents) {
                        return;
                    }
                    DensityPlotPanel.this.setOpacityProperty();
                }
            });
            this.jSlider.setBounds(67, 51, 165, 19);
        }
        return this.jSlider;
    }
}

