/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.DatePicker;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DateTimePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 8830667879140367754L;
    private double selectedValue = 0.0;
    private DatePicker datePicker = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private JLabel jLabel2 = null;
    private JSeparator jSeparator = null;
    private SASFormat labelFormat = null;
    private int formatType = -1;
    private JSpinner jSpinner = null;
    private JSpinner jSpinner1 = null;
    private JSpinner jSpinner2 = null;
    private EventListenerList listeners = new EventListenerList();
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public DateTimePanel() {
        this.initialize();
    }

    private void initialize() {
        this.setFormat(SASFormat.getInstance((String)"DATETIME"));
        this.setLayout(new BorderLayout());
        this.setSize(243, 231);
        this.add((Component)this.getJPanel1(), "Center");
        this.add((Component)this.getJPanel2(), "South");
        this.setValue(0.0);
        this.datePicker.addActionListener(this);
    }

    public void setFormat(SASFormat format) {
        if (format == null) {
            return;
        }
        this.labelFormat = format;
        this.formatType = SILKUtilities.getFormatType((SASFormat)format);
        if (this.datePicker != null) {
            this.datePicker.setEnabled(this.formatType == 1 || this.formatType == 2);
        }
        this.setTimeWidgetsEnabled(this.formatType == 2 || this.formatType == 0);
        this.setValue(this.selectedValue);
    }

    private void setTimeWidgetsEnabled(boolean enabled) {
        this.getJSpinner().setEnabled(enabled);
        this.getJSpinner1().setEnabled(enabled);
        this.getJSpinner2().setEnabled(enabled);
    }

    public Double getValue() {
        return new Double(this.selectedValue);
    }

    public String getFormattedValue() {
        return this.labelFormat.format((Object)new Double(this.selectedValue));
    }

    public void setValue(double d) {
        this.selectedValue = d;
        Date javaDate = null;
        if (this.formatType == 1) {
            javaDate = new Date(SASDateTimeFormat.SASDateToJavaDate((double)this.selectedValue));
        } else if (this.formatType == 2) {
            javaDate = new Date(SASDateTimeFormat.SASDateTimeToJavaDate((double)this.selectedValue));
        } else if (this.formatType == 0) {
            javaDate = new Date(SASDateTimeFormat.SASTimeToJavaDate((double)this.selectedValue));
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(javaDate);
        this.getJSpinner().setValue(new Integer(cal.get(10)));
        this.getJSpinner1().setValue(new Integer(cal.get(12)));
        this.getJSpinner2().setValue(new Integer(cal.get(13)));
        if (this.datePicker != null && this.datePicker.isEnabled()) {
            this.datePicker.setCurrentYear(cal.get(1));
            this.datePicker.setCurrentMonth(cal.get(2));
            this.datePicker.setCurrentDay(cal.get(5));
        }
        if (this.jLabel2 != null) {
            this.jLabel2.setText(this.getMessage("DateTimePanel.SelectedValue.fmt.txt", "Selected Value: {0}", new Object[]{this.labelFormat.format((Object)new Double(this.selectedValue))}));
        }
        this.fireActionEvent();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.datePicker) {
            Date javaDate = null;
            if (this.formatType == 1) {
                javaDate = new Date(SASDateTimeFormat.SASDateToJavaDate((double)this.selectedValue));
            } else if (this.formatType == 2) {
                javaDate = new Date(SASDateTimeFormat.SASDateTimeToJavaDate((double)this.selectedValue));
            } else if (this.formatType == 0) {
                javaDate = new Date(SASDateTimeFormat.SASTimeToJavaDate((double)this.selectedValue));
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(javaDate);
            cal.set(this.datePicker.getCurrentYear(), this.datePicker.getCurrentMonth(), this.datePicker.getCurrentDay());
            if (this.formatType == 2) {
                this.selectedValue = SASDateTimeFormat.javaDateToSASDateTime((long)cal.getTime().getTime());
            } else if (this.formatType == 1) {
                this.selectedValue = SASDateTimeFormat.javaDateToSASDate((long)cal.getTime().getTime());
            }
            this.jLabel2.setText(this.getMessage("DateTimePanel.SelectedValue.fmt.txt", "Selected Value: {0}", new Object[]{this.labelFormat.format((Object)new Double(this.selectedValue))}));
            this.fireActionEvent();
        }
    }

    private DatePicker getDatePicker() {
        if (this.datePicker == null) {
            this.datePicker = new DatePicker();
        }
        return this.datePicker;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setFont(TabbedPropertiesDialog.dialogFont);
            this.jLabel1.setText(":");
            this.jLabel = new JLabel();
            this.jLabel.setText(":");
            this.jLabel.setFont(TabbedPropertiesDialog.dialogFont);
            this.jPanel = new JPanel();
            this.jPanel.add((Component)this.getJSpinner(), null);
            this.jPanel.add((Component)this.jLabel, null);
            this.jPanel.add((Component)this.getJSpinner1(), null);
            this.jPanel.add((Component)this.jLabel1, null);
            this.jPanel.add((Component)this.getJSpinner2(), null);
        }
        return this.jPanel;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new BorderLayout());
            this.jPanel1.add((Component)this.getDatePicker(), "Center");
            this.jPanel1.add((Component)this.getJPanel(), "South");
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setFont(TabbedPropertiesDialog.dialogFont);
            this.jLabel2.setText("JLabel");
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new BorderLayout());
            this.jPanel2.add((Component)this.jLabel2, "West");
            this.jPanel2.add((Component)this.getJSeparator(), "North");
        }
        return this.jPanel2;
    }

    private JSeparator getJSeparator() {
        if (this.jSeparator == null) {
            this.jSeparator = new JSeparator();
        }
        return this.jSeparator;
    }

    private JSpinner getJSpinner() {
        if (this.jSpinner == null) {
            this.jSpinner = new JSpinner();
            this.jSpinner.setPreferredSize(new Dimension(35, 20));
            this.jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Date current = new Date(SASDateTimeFormat.SASDateTimeToJavaDate((double)DateTimePanel.this.selectedValue));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(current);
                    int val = (Integer)DateTimePanel.this.jSpinner.getValue();
                    cal.set(11, val);
                    DateTimePanel.this.selectedValue = SASDateTimeFormat.javaDateToSASDateTime((long)cal.getTime().getTime());
                    if (DateTimePanel.this.jLabel2 != null) {
                        DateTimePanel.this.jLabel2.setText(DateTimePanel.this.getMessage("DateTimePanel.SelectedValue.fmt.txt", "Selected Value: {0}", new Object[]{DateTimePanel.this.labelFormat.format((Object)new Double(DateTimePanel.this.selectedValue))}));
                    }
                    DateTimePanel.this.fireActionEvent();
                }
            });
            SpinnerNumberModel snm = (SpinnerNumberModel)this.jSpinner.getModel();
            snm.setMinimum(new Integer(0));
            snm.setMaximum(new Integer(23));
        }
        return this.jSpinner;
    }

    private JSpinner getJSpinner1() {
        if (this.jSpinner1 == null) {
            this.jSpinner1 = new JSpinner();
            this.jSpinner1.setPreferredSize(new Dimension(35, 20));
            this.jSpinner1.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Date current = new Date(SASDateTimeFormat.SASDateTimeToJavaDate((double)DateTimePanel.this.selectedValue));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(current);
                    int val = (Integer)DateTimePanel.this.jSpinner1.getValue();
                    cal.set(12, val);
                    DateTimePanel.this.selectedValue = SASDateTimeFormat.javaDateToSASDateTime((long)cal.getTime().getTime());
                    if (DateTimePanel.this.jLabel2 != null) {
                        DateTimePanel.this.jLabel2.setText(DateTimePanel.this.getMessage("DateTimePanel.SelectedValue.fmt.txt", "Selected Value: {0}", new Object[]{DateTimePanel.this.labelFormat.format((Object)new Double(DateTimePanel.this.selectedValue))}));
                    }
                    DateTimePanel.this.fireActionEvent();
                }
            });
            SpinnerNumberModel snm = (SpinnerNumberModel)this.jSpinner1.getModel();
            snm.setMinimum(new Integer(0));
            snm.setMaximum(new Integer(59));
        }
        return this.jSpinner1;
    }

    private JSpinner getJSpinner2() {
        if (this.jSpinner2 == null) {
            this.jSpinner2 = new JSpinner();
            this.jSpinner2.setPreferredSize(new Dimension(35, 20));
            this.jSpinner2.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    Date current = new Date(SASDateTimeFormat.SASDateTimeToJavaDate((double)DateTimePanel.this.selectedValue));
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(current);
                    int val = (Integer)DateTimePanel.this.jSpinner.getValue();
                    cal.set(13, val);
                    DateTimePanel.this.selectedValue = SASDateTimeFormat.javaDateToSASDateTime((long)cal.getTime().getTime());
                    if (DateTimePanel.this.jLabel2 != null) {
                        DateTimePanel.this.jLabel2.setText(DateTimePanel.this.getMessage("DateTimePanel.SelectedValue.fmt.txt", "Selected Value: {0}", new Object[]{DateTimePanel.this.labelFormat.format((Object)new Double(DateTimePanel.this.selectedValue))}));
                    }
                    DateTimePanel.this.fireActionEvent();
                }
            });
            SpinnerNumberModel snm = (SpinnerNumberModel)this.jSpinner2.getModel();
            snm.setMinimum(new Integer(0));
            snm.setMaximum(new Integer(59));
        }
        return this.jSpinner2;
    }

    public void addActionListener(ActionListener listener) {
        this.listeners.add(ActionListener.class, listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.listeners.remove(ActionListener.class, listener);
    }

    private void fireActionEvent() {
        ActionEvent ae = new ActionEvent(this, 0, "Date Chosen");
        EventListener[] l = this.listeners.getListeners(ActionListener.class);
        for (int i = 0; i < l.length; ++i) {
            ((ActionListener)l[i]).actionPerformed(ae);
        }
    }

    protected String getMessage(String key, String defaultValue, Object[] arguments) {
        String msg = ResourceLoader.getResourceString((Object)this.rb, (String)key, (String)defaultValue);
        return MessageFormat.format(msg, arguments);
    }
}

