/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.FontManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;

public class DatePicker
extends JComponent
implements MouseListener,
ActionListener {
    private static final long serialVersionUID = 852519479543552818L;
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    String[] months = new String[]{ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.January.txt", (String)"January"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.February.txt", (String)"February"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.March.txt", (String)"March"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.April.txt", (String)"April"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.May.txt", (String)"May"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.June.txt", (String)"June"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.July.txt", (String)"July"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.August.txt", (String)"August"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.September.txt", (String)"September"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.October.txt", (String)"October"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.November.txt", (String)"November"), ResourceLoader.getResourceString((Object)this.rb, (String)"DatePicker.December.txt", (String)"December")};
    static final int FEBRUARY = 1;
    int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    JButton[] buttons = null;
    int currentDay = 0;
    int currentMonth = 0;
    int currentYear = 2003;
    Font buttonFont = FontManager.getFont((String)"Serif", (int)0, (int)12);
    Border activeBorder = BorderFactory.createLoweredBevelBorder();
    Border inactiveBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    Border currentDayBorder = BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createLineBorder(Color.red));
    Border mouseOverOldBorder = this.inactiveBorder;
    JLabel monthLabel = new JLabel();
    JLabel yearLabel = new JLabel();
    JButton nextMonth = new JButton(">");
    JButton lastMonth = new JButton("<");
    JButton nextYear = new JButton(">");
    JButton lastYear = new JButton("<");
    Vector listeners = new Vector();

    public DatePicker() {
        this.setupComponents();
    }

    private void setupComponents() {
        int i;
        this.removeAll();
        this.nextMonth = new JButton(">");
        this.lastMonth = new JButton("<");
        this.nextYear = new JButton(">");
        this.lastYear = new JButton("<");
        this.setLayout(new BorderLayout());
        JPanel daysPanel = new JPanel();
        daysPanel.setLayout(new GridLayout(0, 7));
        int day = this.calcFirstOfMonth(this.currentYear, this.currentMonth);
        for (i = 0; i < day; ++i) {
            daysPanel.add(new JPanel());
        }
        this.buttons = new JButton[this.daysInMonth[this.currentMonth]];
        for (i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new JButton(i + 1 + "");
            this.buttons[i].setFont(this.buttonFont);
            this.buttons[i].setBorder(this.inactiveBorder);
            if (this.currentDay == i + 1) {
                this.buttons[i].setBorder(this.currentDayBorder);
            }
            this.buttons[i].addMouseListener(this);
            this.buttons[i].setMargin(new Insets(1, 1, 1, 1));
            this.buttons[i].addActionListener(this);
            daysPanel.add(this.buttons[i]);
        }
        this.add("Center", daysPanel);
        this.monthLabel.setText(this.months[this.currentMonth]);
        this.monthLabel.setFont(this.buttonFont);
        this.monthLabel.setHorizontalAlignment(0);
        Dimension dim = new Dimension(0, 0);
        for (int i2 = 0; i2 < this.months.length; ++i2) {
            JLabel label = new JLabel(this.months[i2]);
            label.setFont(this.buttonFont);
            Dimension d = label.getPreferredSize();
            if (d.width > dim.width) {
                dim.width = d.width;
            }
            if (d.height <= dim.height) continue;
            dim.height = d.height;
        }
        this.monthLabel.setPreferredSize(dim);
        this.yearLabel.setText(this.currentYear + "");
        this.yearLabel.setFont(this.buttonFont);
        JPanel topPanel = new JPanel();
        topPanel.add(this.lastMonth);
        topPanel.add(this.monthLabel);
        topPanel.add(this.nextMonth);
        topPanel.add(this.lastYear);
        topPanel.add(this.yearLabel);
        topPanel.add(this.nextYear);
        this.nextMonth.setBorder(this.inactiveBorder);
        this.nextMonth.addMouseListener(this);
        this.nextMonth.setFont(this.buttonFont);
        this.nextMonth.addActionListener(this);
        this.lastMonth.setBorder(this.inactiveBorder);
        this.lastMonth.addMouseListener(this);
        this.lastMonth.setFont(this.buttonFont);
        this.lastMonth.addActionListener(this);
        this.nextYear.setBorder(this.inactiveBorder);
        this.nextYear.addMouseListener(this);
        this.nextYear.setFont(this.buttonFont);
        this.nextYear.addActionListener(this);
        this.lastYear.setBorder(this.inactiveBorder);
        this.lastYear.addMouseListener(this);
        this.lastYear.setFont(this.buttonFont);
        this.lastYear.addActionListener(this);
        this.add("North", topPanel);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (int i = 0; i < this.buttons.length; ++i) {
            if (this.buttons[i] == null) continue;
            this.buttons[i].setEnabled(enabled);
        }
        this.nextMonth.setEnabled(enabled);
        this.lastMonth.setEnabled(enabled);
        this.nextYear.setEnabled(enabled);
        this.lastYear.setEnabled(enabled);
    }

    public void showDialog(JFrame parent, int x, int y) {
        JWindow dialog = new JWindow(parent);
        dialog.setLocation(x, y);
        dialog.getContentPane().add("Center", this);
        dialog.setSize(new Dimension(150, 125));
        dialog.setVisible(true);
    }

    public Date getCurrentDate() {
        Date d = new Date(this.currentYear, this.currentMonth, this.currentDay);
        return d;
    }

    public static void main(String[] args) {
        final DatePicker dp = new DatePicker();
        dp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                System.out.println(dp.getCurrentDate());
            }
        });
        dp.showDialog(null, 0, 0);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.isEnabled() && e.getSource() instanceof JButton) {
            this.mouseOverOldBorder = ((JButton)e.getSource()).getBorder();
            ((JButton)e.getSource()).setBorder(this.activeBorder);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.isEnabled() && e.getSource() instanceof JButton) {
            ((JButton)e.getSource()).setBorder(this.mouseOverOldBorder);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private int calcFirstOfMonth(int year, int month) {
        if (year < 1582) {
            return -1;
        }
        if (month < 0 || month > 11) {
            return -1;
        }
        int firstDay = this.calcJanuaryFirst(year);
        for (int i = 0; i < month; ++i) {
            firstDay += this.daysInMonth[i];
        }
        if (month > 1 && this.IsLeapYear(year)) {
            ++firstDay;
        }
        return firstDay % 7;
    }

    private int calcJanuaryFirst(int year) {
        if (year < 1582) {
            return -1;
        }
        return (5 + (year - 1582) + this.calcLeapYears(year)) % 7;
    }

    private int calcLeapYears(int year) {
        if (year < 1582) {
            return -1;
        }
        int leapYears = (year - 1581) / 4;
        int hundreds = (year - 1501) / 100;
        leapYears -= hundreds;
        int fourHundreds = (year - 1201) / 400;
        return leapYears += fourHundreds;
    }

    private boolean IsLeapYear(int year) {
        if (year % 100 == 0) {
            return year % 400 == 0;
        }
        return year % 4 == 0;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.nextMonth) {
            ++this.currentMonth;
        } else if (source == this.lastMonth) {
            --this.currentMonth;
        } else if (source == this.nextYear) {
            ++this.currentYear;
        } else if (source == this.lastYear) {
            --this.currentYear;
        } else if (source instanceof JButton) {
            this.currentDay = Integer.valueOf(((JButton)source).getText());
        }
        if (this.currentMonth < 0) {
            this.currentMonth = 11;
            --this.currentYear;
        }
        if (this.currentMonth > 11) {
            this.currentMonth = 0;
            ++this.currentYear;
        }
        this.setupComponents();
        this.fireDayPickedEvent();
    }

    public void addActionListener(ActionListener al) {
        if (al != null) {
            this.listeners.addElement(al);
        }
    }

    public void removeActionListener(ActionListener al) {
        if (al != null && this.listeners.contains(al)) {
            this.listeners.remove(al);
        }
    }

    private void fireDayPickedEvent() {
        ActionEvent ae = new ActionEvent(this, this.currentDay, "DayPicked");
        for (int i = 0; i < this.listeners.size(); ++i) {
            ((ActionListener)this.listeners.elementAt(i)).actionPerformed(ae);
        }
    }

    public int getCurrentDay() {
        return this.currentDay;
    }

    public void setCurrentDay(int currentDay) {
        this.currentDay = currentDay;
        this.setupComponents();
    }

    public int getCurrentMonth() {
        return this.currentMonth;
    }

    public void setCurrentMonth(int currentMonth) {
        this.currentMonth = currentMonth;
        this.setupComponents();
    }

    public int getCurrentYear() {
        return this.currentYear;
    }

    public void setCurrentYear(int currentYear) {
        this.currentYear = currentYear;
        this.setupComponents();
    }
}

