/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.ContourLevelsDialog;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ContourPanel
extends JPanel
implements TabPanelInterface,
ActionListener {
    private static final long serialVersionUID = 5250690086485833449L;
    protected Vector listeners = new Vector();
    protected JComboBox contourStyleCombo;
    protected JCheckBox showContourLinesCheck;
    protected JComboBox labelOrientationCombo;
    protected JCheckBox labelOnCheck;
    protected JLabel labelOrientationLabel;
    protected JButton levelsButton;
    protected ContourLevelsDialog levelsDialog;
    protected JCheckBox autoCalcCheck;
    protected ColorMapperChooserPanel colorMapperChooserPanel = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public ContourPanel() {
        this((PropertyInterface)null);
    }

    public ContourPanel(PropertyInterface contour) {
        this.addPropertyListener(contour);
        this.initGUI();
        this.initComboBoxes();
        this.addListeners();
        this.levelsDialog = new ContourLevelsDialog(UIUtilities.getParentFrame(this));
        UIUtilities.center(this.levelsDialog);
        this.levelsDialog.setListeners(this.listeners);
    }

    private void addListeners() {
        this.contourStyleCombo.addActionListener(this);
        this.showContourLinesCheck.addActionListener(this);
        this.labelOrientationCombo.addActionListener(this);
        this.labelOnCheck.addActionListener(this);
        this.autoCalcCheck.addActionListener(this);
        this.levelsButton.addActionListener(this);
    }

    private void removeListeners() {
        this.contourStyleCombo.removeActionListener(this);
        this.showContourLinesCheck.removeActionListener(this);
        this.labelOrientationCombo.removeActionListener(this);
        this.labelOnCheck.removeActionListener(this);
        this.autoCalcCheck.removeActionListener(this);
        this.levelsButton.removeActionListener(this);
    }

    @Override
    public boolean applyChanges() {
        boolean status = PropertyUtils.applyChanges((Vector)this.listeners);
        this.initFromSource();
        return status;
    }

    @Override
    public boolean cancelChanges() {
        return PropertyUtils.cancelChanges((Vector)this.listeners);
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null) {
            return false;
        }
        this.listeners.addElement(prop);
        if (this.listeners.size() == 1) {
            this.initComboBoxes();
        }
        return true;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        if (prop == null || this.listeners == null || !this.listeners.contains(prop)) {
            return false;
        }
        return this.listeners.remove(prop);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Object source = ae.getSource();
        if (source == this.contourStyleCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10401, (Object)this.contourStyleCombo.getSelectedItem());
            this.setControlsEnabled();
        } else if (source == this.showContourLinesCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10410, (Object)new Boolean(this.showContourLinesCheck.isSelected()));
            this.setControlsEnabled();
        } else if (source == this.labelOnCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10403, (Object)new Boolean(this.labelOnCheck.isSelected()));
            this.setControlsEnabled();
        } else if (source == this.labelOrientationCombo) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10404, (Object)this.labelOrientationCombo.getSelectedItem());
        } else if (source == this.autoCalcCheck) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10409, (Object)new Boolean(this.autoCalcCheck.isSelected()));
        } else if (source == this.levelsButton) {
            this.levelsDialog.setVisible(true);
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout(5, 5));
        JLabel contourStyleLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.ContourStyle.txt", (String)"Contour Style:"));
        contourStyleLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.contourStyleCombo = new JComboBox();
        this.contourStyleCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.contourStyleCombo.setBackground(Color.WHITE);
        JPanel contourStylePanel = new JPanel();
        contourStylePanel.setLayout(new BorderLayout(5, 5));
        contourStylePanel.add((Component)contourStyleLabel, "West");
        contourStylePanel.add((Component)this.contourStyleCombo, "Center");
        this.showContourLinesCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.ShowContourLines.txt", (String)"Show Contour Lines"));
        this.showContourLinesCheck.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel showLinesPanel = new JPanel();
        showLinesPanel.setLayout(new BorderLayout(5, 5));
        showLinesPanel.add((Component)this.showContourLinesCheck, "West");
        showLinesPanel.add((Component)new JPanel(), "East");
        JPanel stylePanel = new JPanel();
        stylePanel.setLayout(new GridLayout(0, 1, 5, 5));
        TitledBorder styleBorder = new TitledBorder(new EtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.Style.txt", (String)"Style"));
        styleBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        stylePanel.setBorder(new CompoundBorder(styleBorder, new EmptyBorder(5, 5, 5, 5)));
        stylePanel.add(contourStylePanel);
        stylePanel.add(showLinesPanel);
        this.labelOnCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.LabelsOn.txt", (String)"Labels On"));
        this.labelOnCheck.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel labelOnPanel = new JPanel();
        labelOnPanel.setLayout(new BorderLayout(5, 5));
        labelOnPanel.add((Component)this.labelOnCheck, "West");
        labelOnPanel.add((Component)new JPanel(), "East");
        this.labelOrientationLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.LabelOrientation.txt", (String)"Label Orientation:"));
        this.labelOrientationLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelOrientationCombo = new JComboBox();
        this.labelOrientationCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.labelOrientationCombo.setBackground(Color.WHITE);
        JPanel labelOrientationPanel = new JPanel();
        labelOrientationPanel.setLayout(new BorderLayout(5, 5));
        labelOrientationPanel.add((Component)this.labelOrientationLabel, "West");
        labelOrientationPanel.add((Component)this.labelOrientationCombo, "Center");
        JPanel lineLabelPanel = new JPanel();
        lineLabelPanel.setLayout(new GridLayout(0, 1, 5, 5));
        TitledBorder lineLabelBorder = new TitledBorder(new EtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.LineLabels.txt", (String)"Line Labels"));
        lineLabelBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        lineLabelPanel.setBorder(new CompoundBorder(lineLabelBorder, new EmptyBorder(5, 5, 5, 5)));
        lineLabelPanel.add(labelOnPanel);
        lineLabelPanel.add(labelOrientationPanel);
        this.levelsButton = new JButton();
        this.levelsButton.setFont(TabbedPropertiesDialog.dialogFont);
        this.levelsButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.LevelsButton.txt", (String)"Levels..."));
        JPanel levelsButtonPanel = new JPanel(new BorderLayout(5, 5));
        levelsButtonPanel.add((Component)this.levelsButton, "West");
        this.autoCalcCheck = new JCheckBox(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.AutoCalculateLevels.txt", (String)"Auto Calculate Levels"));
        this.autoCalcCheck.setFont(TabbedPropertiesDialog.dialogFont);
        JPanel autoCalcPanel = new JPanel();
        autoCalcPanel.setLayout(new BorderLayout(5, 5));
        autoCalcPanel.add((Component)this.autoCalcCheck, "West");
        autoCalcPanel.add((Component)new JPanel(), "East");
        JPanel levelsPanel = new JPanel();
        levelsPanel.setLayout(new BorderLayout(5, 5));
        TitledBorder levelsBorder = new TitledBorder(new EtchedBorder(), ResourceLoader.getResourceString((Object)this.rb, (String)"ContourPanel.Levels.txt", (String)"Levels"));
        levelsBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        levelsPanel.setBorder(new CompoundBorder(levelsBorder, new EmptyBorder(5, 5, 5, 5)));
        levelsPanel.add((Component)autoCalcPanel, "North");
        levelsPanel.add((Component)levelsButtonPanel, "South");
        this.colorMapperChooserPanel = new ColorMapperChooserPanel(this.listeners);
        JPanel panel0 = new JPanel();
        JPanel panel1 = new JPanel();
        JPanel panel2 = new JPanel();
        JPanel panel3 = new JPanel();
        panel0.setLayout(new BorderLayout(5, 5));
        panel0.setBorder(new EmptyBorder(10, 10, 10, 10));
        panel0.add((Component)panel1, "Center");
        panel1.setLayout(new BorderLayout(5, 5));
        panel1.add((Component)stylePanel, "North");
        panel1.add((Component)panel2, "Center");
        panel2.setLayout(new BorderLayout(5, 5));
        panel2.add((Component)lineLabelPanel, "North");
        panel2.add((Component)panel3, "Center");
        panel3.setLayout(new BorderLayout(5, 5));
        panel3.add((Component)levelsPanel, "North");
        panel3.add((Component)this.colorMapperChooserPanel, "Center");
        this.add((Component)panel0, "North");
    }

    protected void initComboBoxes() {
        int i;
        Object[] list;
        if (this.listeners == null || this.listeners.size() == 0) {
            return;
        }
        this.contourStyleCombo.removeAllItems();
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10402);
        if (o != null && o instanceof Object[]) {
            list = (Object[])o;
            for (i = 0; i < list.length; ++i) {
                this.contourStyleCombo.addItem(list[i]);
            }
        }
        this.labelOrientationCombo.removeAllItems();
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10405);
        if (o != null && o instanceof Object[]) {
            list = (Object[])o;
            for (i = 0; i < list.length; ++i) {
                this.labelOrientationCombo.addItem(list[i]);
            }
        }
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }

    private void initFromSource() {
        this.colorMapperChooserPanel.initFromSource();
        this.removeListeners();
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10401);
        if (o != null && o instanceof String) {
            this.contourStyleCombo.setSelectedItem(o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10410)) != null && o instanceof Boolean) {
            this.showContourLinesCheck.setSelected((Boolean)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10403)) != null && o instanceof Boolean) {
            this.labelOnCheck.setSelected((Boolean)o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10404)) != null && o instanceof String) {
            this.labelOrientationCombo.setSelectedItem(o);
        }
        this.setControlsEnabled();
        o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10409);
        if (o != null && o instanceof Boolean) {
            this.autoCalcCheck.setSelected((Boolean)o);
        }
        this.addListeners();
    }

    private void setControlsEnabled() {
        boolean isLineContour = false;
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10402);
        if (o != null && o instanceof Object[] && this.contourStyleCombo.getSelectedItem() == ((Object[])o)[2]) {
            isLineContour = true;
        }
        this.showContourLinesCheck.setEnabled(!isLineContour);
        isLineContour = isLineContour || this.showContourLinesCheck.isSelected();
        this.labelOnCheck.setEnabled(isLineContour);
        this.labelOrientationLabel.setEnabled(isLineContour && this.labelOnCheck.isSelected());
        this.labelOrientationCombo.setEnabled(isLineContour && this.labelOnCheck.isSelected());
    }
}

