/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class ContourLevelsDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 7837697112315723016L;
    protected Vector listeners = new Vector();
    protected JSpinner numLevelSpinner;
    protected JTextField minLevelText;
    protected JLabel minLevelLabel;
    protected JTextField maxLevelText;
    protected JLabel maxLevelLabel;
    protected JPanel buttonPanel = null;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JButton applyButton = null;
    protected JPanel jContentPane = null;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public ContourLevelsDialog(Frame parent) {
        super(parent);
        this.setModal(true);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.ContourLevels.txt", (String)"Contour Levels"));
        this.initialize();
    }

    public void setListeners(Vector listeners) {
        this.listeners = listeners;
    }

    private void initialize() {
        this.setBounds(new Rectangle(0, 0, 300, 200));
        this.setResizable(true);
        this.setContentPane(this.getJContentPane());
        this.addListeners();
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel(new BorderLayout(5, 5));
            this.jContentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
            this.jContentPane.add((Component)this.getInputPanel(), "North");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getInputPanel() {
        JPanel inputPanel = new JPanel(new BorderLayout(5, 5));
        JLabel numLevelLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.NumLevels.txt", (String)"Num Levels:"));
        numLevelLabel.setFont(TabbedPropertiesDialog.dialogFont);
        SpinnerNumberModel model = new SpinnerNumberModel(1, 1, 100, 1);
        this.numLevelSpinner = new JSpinner(model);
        this.minLevelLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.MinLevel.txt", (String)"Min Level:"));
        this.minLevelLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.minLevelText = new JTextField();
        this.minLevelText.setFont(TabbedPropertiesDialog.dialogFont);
        this.minLevelText.setBackground(Color.WHITE);
        this.maxLevelLabel = new JLabel(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.MaxLevel.txt", (String)"Max Level:"));
        this.maxLevelLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.maxLevelText = new JTextField();
        this.maxLevelText.setFont(TabbedPropertiesDialog.dialogFont);
        this.maxLevelText.setBackground(Color.WHITE);
        JPanel levelLabelPanel = new JPanel();
        levelLabelPanel.setLayout(new GridLayout(0, 1, 5, 5));
        levelLabelPanel.add(numLevelLabel);
        levelLabelPanel.add(this.minLevelLabel);
        levelLabelPanel.add(this.maxLevelLabel);
        JPanel levelControlsPanel = new JPanel();
        levelControlsPanel.setLayout(new GridLayout(0, 1, 5, 5));
        levelControlsPanel.add(this.numLevelSpinner);
        levelControlsPanel.add(this.minLevelText);
        levelControlsPanel.add(this.maxLevelText);
        inputPanel.add((Component)levelLabelPanel, "West");
        inputPanel.add((Component)levelControlsPanel, "Center");
        return inputPanel;
    }

    private JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout(5, 5));
            JPanel gridPanel = new JPanel(new GridLayout(0, 3, 5, 5));
            gridPanel.add(this.getOkButton());
            gridPanel.add(this.getApplyButton());
            gridPanel.add(this.getCancelButton());
            this.buttonPanel.add((Component)gridPanel, "East");
        }
        return this.buttonPanel;
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton();
            this.okButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.okButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.OK.txt", (String)"OK"));
        }
        return this.okButton;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton();
            this.applyButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.applyButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.Apply.txt", (String)"Apply"));
        }
        return this.applyButton;
    }

    private JButton getCancelButton() {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton();
            this.cancelButton.setFont(TabbedPropertiesDialog.dialogFont);
            this.cancelButton.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ContourLevelsDialog.Cancel.txt", (String)"Cancel"));
        }
        return this.cancelButton;
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            this.initFromSource();
        }
        super.setVisible(show);
    }

    private void initFromSource() {
        Object o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10406);
        if (o != null && o instanceof Integer) {
            this.numLevelSpinner.setValue(o);
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10407)) != null && o instanceof Double) {
            this.minLevelText.setText(o.toString());
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10408)) != null && o instanceof Double) {
            this.maxLevelText.setText(o.toString());
        }
    }

    private void addListeners() {
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.applyProperties();
            this.setVisible(false);
        } else if (e.getSource() == this.applyButton) {
            this.applyProperties();
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
    }

    private void applyProperties() {
        block6: {
            Object o;
            Double d;
            Number min;
            NumberFormat format;
            block5: {
                format = NumberFormat.getNumberInstance();
                try {
                    min = format.parse(this.minLevelText.getText());
                    d = new Double(min.doubleValue());
                    PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10407, (Object)d);
                }
                catch (ParseException e) {
                    o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10407);
                    if (o == null || !(o instanceof Double)) break block5;
                    this.minLevelText.setText(o.toString());
                }
            }
            try {
                min = format.parse(this.maxLevelText.getText());
                d = new Double(min.doubleValue());
                PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10408, (Object)d);
            }
            catch (ParseException e) {
                o = PropertyUtils.getPropertyValue((Vector)this.listeners, (int)10408);
                if (o == null || !(o instanceof Double)) break block6;
                this.maxLevelText.setText(o.toString());
            }
        }
        Object o = this.numLevelSpinner.getValue();
        if (o != null && o instanceof Integer) {
            PropertyUtils.setPropertyValue((Vector)this.listeners, (int)10406, (Object)o);
        }
        PropertyUtils.applyChanges((Vector)this.listeners);
    }
}

