/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TextDialog;
import com.sas.graphics.util.PropertyEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ColorPanel
extends JPanel
implements ChangeListener {
    private static final long serialVersionUID = 7418042180083362462L;
    TextDialog textDialog;
    Color currentColor = Color.black;
    PropertyInterface source = null;
    JColorChooser colorChooser = null;

    public ColorPanel(TextDialog dialog) {
        this.textDialog = dialog;
        this.setLayout(new BorderLayout());
        if (this.colorChooser == null) {
            this.colorChooser = new JColorChooser();
        }
        AbstractColorChooserPanel[] panels = this.colorChooser.getChooserPanels();
        panels[0].getColorSelectionModel().addChangeListener(this);
        this.add("Center", this.colorChooser.getChooserPanels()[0]);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.currentColor = this.colorChooser.getSelectionModel().getSelectedColor();
        this.source.setPropertyValue(9001, (Object)new PropertyEvent(9001, (Object)this.textDialog, (Object)this.currentColor));
        this.textDialog.textChanged();
    }

    public void init(PropertyInterface propertyInterface) {
        this.source = propertyInterface;
        Object obj = this.source.getPropertyValue(9001);
        this.currentColor = obj != null && obj instanceof Color ? (Color)obj : Color.black;
        if (this.colorChooser != null) {
            this.colorChooser.getSelectionModel().setSelectedColor(this.currentColor);
        }
    }

    public Color getColor() {
        return this.currentColor;
    }
}

