/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.ui.ColorMapperPanel;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.ui.UIUtilities;
import com.sas.graphics.silk.util.ColorMapper;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ColorMapperChooserPanel
extends JPanel
implements ListCellRenderer,
ItemListener {
    private static final long serialVersionUID = 7744125215317926129L;
    private JPanel jPanel = null;
    private JComboBox jComboBox = null;
    private JButton jButton = null;
    private static ColorMapperPanel colorMapperPanel = null;
    private Vector charts = null;
    private boolean ignoreItemEvents = false;
    private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private JPanel rendererPanel = new JPanel(new BorderLayout());
    private GradientRenderer gradientRenderer = new GradientRenderer();

    public ColorMapperChooserPanel() {
        this((Vector)null);
    }

    public ColorMapperChooserPanel(Vector propetyListeners) {
        this.charts = propetyListeners;
        this.initialize();
        this.initFromSource();
    }

    public void setListeners(Vector listeners) {
        this.charts = listeners;
        this.initFromSource();
    }

    private void disableListeners() {
        this.getJComboBox().removeItemListener(this);
    }

    private void enableListeners() {
        this.getJComboBox().addItemListener(this);
    }

    public void initFromSource() {
        if (this.charts == null) {
            return;
        }
        this.disableListeners();
        Object obj = PropertyUtils.getPropertyValue((Vector)this.charts, (int)53);
        this.getJComboBox().setEnabled(obj != null);
        this.getJButton().setEnabled(obj != null);
        if (obj != null) {
            this.getJComboBox().setSelectedItem(obj.toString());
        } else {
            this.ignoreItemEvents = true;
            this.getJComboBox().setSelectedItem("ThreeColorRamp");
            this.ignoreItemEvents = false;
        }
        this.enableListeners();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(259, 85);
        this.setBorder(BorderFactory.createTitledBorder(null, ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.ui.silk_ui_NLS", (String)"ColorMapperChooserPanel.Gradient.txt", (String)"Gradient"), 0, 0, TabbedPropertiesDialog.dialogFont, null));
        this.add((Component)this.getJPanel(), "Center");
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
            this.jPanel.add((Component)this.getJComboBox(), "Center");
            this.jPanel.add((Component)this.getJButton(), "East");
        }
        return this.jPanel;
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setBackground(Color.white);
            this.jComboBox.setFont(TabbedPropertiesDialog.dialogFont);
            this.jComboBox.setRenderer(this);
            this.jComboBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
            String[] arr = ColorMapper.getDefinedColorMappers();
            for (int i = 0; i < arr.length; ++i) {
                this.getJComboBox().addItem(arr[i]);
            }
            this.jComboBox.addItemListener(this);
        }
        return this.jComboBox;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.charts != null && !this.ignoreItemEvents) {
            PropertyUtils.setPropertyValue((Vector)this.charts, (int)53, (Object)this.getJComboBox().getSelectedItem());
        }
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setText("...");
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (colorMapperPanel == null) {
                        colorMapperPanel = new ColorMapperPanel();
                    }
                    colorMapperPanel.setCurrentMapper(ColorMapperChooserPanel.this.getJComboBox().getSelectedItem().toString());
                    if (UIUtilities.getParentDialog(ColorMapperChooserPanel.this.jButton) != null) {
                        colorMapperPanel.showDialog(UIUtilities.getParentDialog(ColorMapperChooserPanel.this.jButton));
                    } else {
                        colorMapperPanel.showDialog(UIUtilities.getParentFrame(ColorMapperChooserPanel.this.jButton));
                    }
                    String[] mappers = ColorMapper.getDefinedColorMappers();
                    ColorMapperChooserPanel.this.ignoreItemEvents = true;
                    ColorMapperChooserPanel.this.getJComboBox().removeAllItems();
                    for (int i = 0; i < mappers.length; ++i) {
                        ColorMapperChooserPanel.this.getJComboBox().addItem(mappers[i]);
                    }
                    ColorMapperChooserPanel.this.ignoreItemEvents = false;
                    ColorMapperChooserPanel.this.getJComboBox().setSelectedItem(colorMapperPanel.getCurrentMapperId());
                    PropertyUtils.setPropertyValue((Vector)ColorMapperChooserPanel.this.charts, (int)53, (Object)ColorMapperChooserPanel.this.getJComboBox().getSelectedItem());
                }
            });
            this.jButton.setFont(TabbedPropertiesDialog.dialogFont);
        }
        return this.jButton;
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (index < 0) {
            return c;
        }
        this.rendererPanel.add(c, "North");
        this.gradientRenderer.setBackground(c.getBackground());
        if (value != null) {
            this.gradientRenderer.mapperName = value.toString();
        }
        this.rendererPanel.add((Component)this.gradientRenderer, "Center");
        return this.rendererPanel;
    }

    class GradientRenderer
    extends JComponent {
        private static final long serialVersionUID = -8223046284483549626L;
        Dimension prefSize = new Dimension(100, 25);
        String mapperName = null;

        public GradientRenderer() {
            this.setOpaque(true);
        }

        @Override
        protected void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            ColorMapper mapper = ColorMapper.getInstance(this.mapperName);
            if (mapper == null) {
                return;
            }
            int h = this.getHeight() - 10;
            if (mapper.getNeutralColor() == null || Double.isNaN(mapper.getNeutralValue())) {
                int x1 = 10;
                int x3 = x1 + this.getWidth() - 20;
                GradientPaint gp = new GradientPaint(x1, 0.0f, mapper.getMinColor(), x3, 0.0f, mapper.getMaxColor());
                ((Graphics2D)g).setPaint(gp);
                g.fillRect(x1, 5, x3 - x1, h);
                g.setColor(Color.BLACK);
                g.drawRect(x1, 5, x3 - x1, h);
            } else {
                double d1 = mapper.getNeutralValue() - mapper.getMinValue();
                double d2 = mapper.getMaxValue() - mapper.getMinValue();
                double ratio = d1 / d2;
                int x1 = 10;
                int x2 = (int)((double)x1 + ratio * (double)(this.getWidth() - 20));
                int x3 = x1 + this.getWidth() - 20;
                GradientPaint gp = new GradientPaint(x1, 0.0f, mapper.getMinColor(), x2, 0.0f, mapper.getNeutralColor());
                ((Graphics2D)g).setPaint(gp);
                g.fillRect(x1, 5, x2 - x1, h);
                gp = new GradientPaint(x2, 0.0f, mapper.getNeutralColor(), x3, 0.0f, mapper.getMaxColor());
                ((Graphics2D)g).setPaint(gp);
                g.fillRect(x2, 5, x3 - x2, h);
                g.setColor(Color.BLACK);
                g.drawRect(x1, 5, x3 - x1, h);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return this.prefSize;
        }
    }
}

