/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.BoxPlotPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BoxPlotDataPointsPanel
extends JPanel
implements ActionListener,
ItemListener,
ChangeListener,
TabPanelInterface,
BoxPlotPropertyInterface {
    private static final long serialVersionUID = 7674939457922068878L;
    protected static int BORDER = 4;
    protected static int COLOR_PANE_WIDTH = 90;
    protected static ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected static String[] MARKERS = new String[]{ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerCircle.txt", (String)"Circle"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerPlus.txt", (String)"Plus"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerUp.txt", (String)"Triangle"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerSquare.txt", (String)"Square"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerX.txt", (String)"Cross"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerDown.txt", (String)"Triangle_Down"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerDiamond.txt", (String)"Diamond"), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerStar.txt", (String)"Star")};
    protected PropertyInterface chart;
    protected JPanel medianPanel;
    protected JPanel meanPanel;
    protected JPanel outlierPanel;
    protected JCheckBox markers;
    protected ColorPanel medianColor;
    protected ColorPanel meanColor;
    protected ColorPanel markerColor;
    protected JButton medianColorB;
    protected JButton meanColorB;
    protected JButton markerColorB;
    protected JComboBox medianShape;
    protected JComboBox meanShape;
    protected JComboBox markerShape;
    protected JSlider medianWidth;
    protected JSlider meanWidth;
    protected JSlider markerWidth;
    protected JLabel medianWidthLabel;
    protected JLabel meanWidthLabel;
    protected JLabel markerWidthLabel;
    private int comboBoxHeight;
    private int comboBoxWidth;
    private int colorPanelHeight;
    protected Color GRAYOUT;
    protected boolean byScheme;

    public BoxPlotDataPointsPanel(PropertyInterface chart) {
        this.chart = chart;
        this.setSize(265, 410);
        this.layoutPanel();
        this.updatePanelUI(this);
        this.GRAYOUT = this.getBackground().darker();
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.removeListeners();
            this.setInitialValues();
            this.addListeners();
        }
    }

    protected void updatePanelUI(JComponent comp) {
        Border b = comp.getBorder();
        if (b != null && b instanceof TitledBorder) {
            ((TitledBorder)b).setTitleFont(TabbedPropertiesDialog.dialogFont);
            ((TitledBorder)b).setTitleColor(Color.black);
        }
        int count = comp.getComponentCount();
        for (int i = 0; i < count; ++i) {
            Component c = comp.getComponent(i);
            if (c instanceof JPanel) {
                this.updatePanelUI((JComponent)c);
                continue;
            }
            if (c instanceof JSlider) continue;
            if (c instanceof JComboBox) {
                c.setBackground(Color.white);
            }
            c.setForeground(Color.black);
            c.setFont(TabbedPropertiesDialog.dialogFont);
        }
    }

    protected void setEnablePanel(JPanel panel, boolean all, boolean enable) {
        Serializable c;
        Border b = panel.getBorder();
        if (all && b != null && b instanceof TitledBorder) {
            c = enable ? Color.black : this.GRAYOUT;
            ((TitledBorder)b).setTitleColor((Color)c);
        }
        int count = panel.getComponentCount();
        for (int i = 0; i < count; ++i) {
            c = panel.getComponent(i);
            if (c instanceof JPanel && !(c instanceof ColorPanel)) {
                this.setEnablePanel((JPanel)c, all, enable);
                continue;
            }
            if (!all && c instanceof JCheckBox) continue;
            ((Component)c).setEnabled(enable);
        }
        panel.repaint();
    }

    private JPanel makeMedianPanel() {
        this.medianPanel = new JPanel();
        this.medianPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MedianPanel.txt", (String)"Median")));
        this.medianPanel.setLayout(new BoxLayout(this.medianPanel, 1));
        JPanel colorP = new JPanel();
        colorP.setLayout(new BoxLayout(colorP, 0));
        this.medianColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Etc.txt", (String)"..."));
        this.colorPanelHeight = this.medianColorB.getPreferredSize().height;
        this.medianColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.medianColor = new ColorPanel(Color.black, this.colorPanelHeight);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        colorP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Color.txt", (String)"Color:")));
        colorP.add(Box.createHorizontalGlue());
        colorP.add(this.medianColor);
        colorP.add(this.medianColorB);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel sizeP = new JPanel();
        sizeP.setLayout(new BoxLayout(sizeP, 0));
        this.medianWidth = new JSlider();
        this.medianWidth.setMinimum(1);
        this.medianWidth.setMaximum(36);
        this.medianWidthLabel = new JLabel();
        sizeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        sizeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Size.txt", (String)"Size:")));
        sizeP.add(this.medianWidthLabel);
        sizeP.add(Box.createRigidArea(new Dimension(6 * BORDER, 0)));
        sizeP.add(this.medianWidth);
        JPanel shapeP = new JPanel();
        shapeP.setLayout(new BoxLayout(shapeP, 0));
        this.medianShape = new JComboBox();
        this.comboBoxHeight = this.medianShape.getPreferredSize().height;
        this.comboBoxWidth = COLOR_PANE_WIDTH + this.colorPanelHeight;
        this.medianShape.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerLine.txt", (String)"Line"));
        for (int i = 0; i < MARKERS.length; ++i) {
            this.medianShape.addItem(MARKERS[i]);
        }
        this.medianShape.setMaximumSize(new Dimension(this.comboBoxWidth, this.comboBoxHeight));
        shapeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        shapeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Shape.txt", (String)"Shape:")));
        shapeP.add(Box.createHorizontalGlue());
        shapeP.add(this.medianShape);
        shapeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.medianPanel.add(colorP);
        this.medianPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.medianPanel.add(shapeP);
        this.medianPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.medianPanel.add(sizeP);
        return this.medianPanel;
    }

    private JPanel makeMeanPanel() {
        this.meanPanel = new JPanel();
        this.meanPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MeanPanel.txt", (String)"Mean")));
        this.meanPanel.setLayout(new BoxLayout(this.meanPanel, 1));
        JPanel colorP = new JPanel();
        colorP.setLayout(new BoxLayout(colorP, 0));
        this.meanColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Etc.txt", (String)"..."));
        this.meanColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.meanColor = new ColorPanel(Color.black, this.colorPanelHeight);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        colorP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Color.txt", (String)"Color:")));
        colorP.add(Box.createHorizontalGlue());
        colorP.add(this.meanColor);
        colorP.add(this.meanColorB);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel sizeP = new JPanel();
        sizeP.setLayout(new BoxLayout(sizeP, 0));
        this.meanWidth = new JSlider();
        this.meanWidth.setMinimum(1);
        this.meanWidth.setMaximum(36);
        this.meanWidthLabel = new JLabel();
        sizeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        sizeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Size.txt", (String)"Size:")));
        sizeP.add(this.meanWidthLabel);
        sizeP.add(Box.createRigidArea(new Dimension(6 * BORDER, 0)));
        sizeP.add(this.meanWidth);
        JPanel shapeP = new JPanel();
        shapeP.setLayout(new BoxLayout(shapeP, 0));
        this.meanShape = new JComboBox();
        this.meanShape.addItem(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.MarkerLine.txt", (String)"Line"));
        for (int i = 0; i < MARKERS.length; ++i) {
            this.meanShape.addItem(MARKERS[i]);
        }
        this.meanShape.setMaximumSize(new Dimension(this.comboBoxWidth, this.comboBoxHeight));
        shapeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        shapeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Shape.txt", (String)"Shape:")));
        shapeP.add(Box.createHorizontalGlue());
        shapeP.add(this.meanShape);
        shapeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.meanPanel.add(colorP);
        this.meanPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.meanPanel.add(shapeP);
        this.meanPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.meanPanel.add(sizeP);
        return this.meanPanel;
    }

    private JPanel makeOutlierPanel() {
        this.outlierPanel = new JPanel();
        this.outlierPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.OutlierPanel.txt", (String)"Outliers")));
        this.outlierPanel.setLayout(new BoxLayout(this.outlierPanel, 1));
        JPanel markerPanel = new JPanel();
        markerPanel.setLayout(new BoxLayout(markerPanel, 0));
        this.markers = new JCheckBox(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Marker.txt", (String)"Markers"));
        markerPanel.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        markerPanel.add(this.markers);
        markerPanel.add(Box.createHorizontalGlue());
        JPanel colorP = new JPanel();
        colorP.setLayout(new BoxLayout(colorP, 0));
        this.markerColorB = new JButton(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Etc.txt", (String)"..."));
        this.markerColorB.setPreferredSize(new Dimension(this.colorPanelHeight, this.colorPanelHeight));
        this.markerColor = new ColorPanel(Color.black, this.colorPanelHeight);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        colorP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Color.txt", (String)"Color:")));
        colorP.add(Box.createHorizontalGlue());
        colorP.add(this.markerColor);
        colorP.add(this.markerColorB);
        colorP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        JPanel sizeP = new JPanel();
        sizeP.setLayout(new BoxLayout(sizeP, 0));
        this.markerWidth = new JSlider();
        this.markerWidth.setMinimum(1);
        this.markerWidth.setMaximum(36);
        this.markerWidthLabel = new JLabel();
        sizeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        sizeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Size.txt", (String)"Size:")));
        sizeP.add(this.markerWidthLabel);
        sizeP.add(Box.createRigidArea(new Dimension(6 * BORDER, 0)));
        sizeP.add(this.markerWidth);
        JPanel shapeP = new JPanel();
        shapeP.setLayout(new BoxLayout(shapeP, 0));
        this.markerShape = new JComboBox();
        for (int i = 0; i < MARKERS.length; ++i) {
            this.markerShape.addItem(MARKERS[i]);
        }
        this.markerShape.setMaximumSize(new Dimension(this.comboBoxWidth, this.comboBoxHeight));
        shapeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        shapeP.add(new JLabel(ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.Shape.txt", (String)"Shape:")));
        shapeP.add(Box.createHorizontalGlue());
        shapeP.add(this.markerShape);
        shapeP.add(Box.createRigidArea(new Dimension(BORDER, 0)));
        this.outlierPanel.add(markerPanel);
        this.outlierPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.outlierPanel.add(colorP);
        this.outlierPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.outlierPanel.add(shapeP);
        this.outlierPanel.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.outlierPanel.add(sizeP);
        return this.outlierPanel;
    }

    protected void layoutPanel() {
        this.setBorder(BorderFactory.createEmptyBorder(BORDER * 4, BORDER, BORDER * 4, BORDER));
        this.setLayout(new BoxLayout(this, 1));
        this.medianPanel = this.makeMedianPanel();
        this.meanPanel = this.makeMeanPanel();
        this.outlierPanel = this.makeOutlierPanel();
        this.add(this.outlierPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(this.medianPanel);
        this.add(Box.createRigidArea(new Dimension(0, BORDER)));
        this.add(this.meanPanel);
    }

    public void setInitialValues() {
        this.medianColor.setColor((Color)this.chart.getPropertyValue(809));
        this.meanColor.setColor((Color)this.chart.getPropertyValue(812));
        this.markerColor.setColor((Color)this.chart.getPropertyValue(816));
        boolean on = (Boolean)this.chart.getPropertyValue(801);
        this.setEnablePanel(this.outlierPanel, true, !on);
        if (!on) {
            on = (Boolean)this.chart.getPropertyValue(815);
            this.markers.setSelected(on);
            this.setEnablePanel(this.outlierPanel, false, on);
        }
        this.markerShape.setSelectedIndex((Integer)this.chart.getPropertyValue(817));
        this.meanShape.setSelectedIndex((Integer)this.chart.getPropertyValue(813) + 1);
        this.medianShape.setSelectedIndex((Integer)this.chart.getPropertyValue(810) + 1);
        this.markerWidth.setValue((Integer)this.chart.getPropertyValue(818));
        this.meanWidth.setValue((Integer)this.chart.getPropertyValue(814));
        this.medianWidth.setValue((Integer)this.chart.getPropertyValue(811));
        this.markerWidthLabel.setText(((Integer)this.chart.getPropertyValue(818)).toString());
        this.meanWidthLabel.setText(((Integer)this.chart.getPropertyValue(814)).toString());
        this.medianWidthLabel.setText(((Integer)this.chart.getPropertyValue(811)).toString());
    }

    private void addListeners() {
        this.markers.addItemListener(this);
        this.medianColorB.addActionListener(this);
        this.meanColorB.addActionListener(this);
        this.markerColorB.addActionListener(this);
        this.markerShape.addActionListener(this);
        this.medianShape.addActionListener(this);
        this.meanShape.addActionListener(this);
        this.markerWidth.addChangeListener(this);
        this.medianWidth.addChangeListener(this);
        this.meanWidth.addChangeListener(this);
    }

    private void removeListeners() {
        this.markers.removeItemListener(this);
        this.medianColorB.removeActionListener(this);
        this.meanColorB.removeActionListener(this);
        this.markerColorB.removeActionListener(this);
        this.markerShape.removeActionListener(this);
        this.medianShape.removeActionListener(this);
        this.meanShape.removeActionListener(this);
        this.markerWidth.removeChangeListener(this);
        this.medianWidth.removeChangeListener(this);
        this.meanWidth.removeChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source == this.medianColorB) {
            Color initColor = this.medianColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.medianColor.setColor(newColor);
            this.chart.setPropertyValue(809, (Object)newColor);
        } else if (source == this.meanColorB) {
            Color initColor = this.meanColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.meanColor.setColor(newColor);
            this.chart.setPropertyValue(812, (Object)newColor);
        } else if (source == this.markerColorB) {
            Color initColor = this.markerColor.getColor();
            Color newColor = JColorChooser.showDialog(this, ResourceLoader.getResourceString((Object)rb, (String)"BoxPlotDataPointsPanel.ColorChooser.txt", (String)"Color"), initColor);
            if (newColor == null) {
                newColor = initColor;
            }
            this.markerColor.setColor(newColor);
            this.chart.setPropertyValue(816, (Object)newColor);
        } else if (source == this.markerShape) {
            int shape = this.markerShape.getSelectedIndex();
            this.chart.setPropertyValue(817, (Object)new Integer(shape));
        } else if (source == this.medianShape) {
            int shape = this.medianShape.getSelectedIndex() - 1;
            this.chart.setPropertyValue(810, (Object)new Integer(shape));
        } else if (source == this.meanShape) {
            int shape = this.meanShape.getSelectedIndex() - 1;
            this.chart.setPropertyValue(813, (Object)new Integer(shape));
        }
    }

    @Override
    public void itemStateChanged(ItemEvent evt) {
        boolean on;
        Object source = evt.getSource();
        boolean bl = on = evt.getStateChange() == 1;
        if (source == this.markers) {
            this.setEnablePanel(this.outlierPanel, false, on);
            this.chart.setPropertyValue(815, (Object)new Boolean(on));
        }
    }

    @Override
    public void stateChanged(ChangeEvent evt) {
        Object source = evt.getSource();
        if (!(source instanceof JSlider)) {
            return;
        }
        int wt = ((JSlider)source).getValue();
        if (source == this.markerWidth) {
            this.chart.setPropertyValue(818, (Object)new Integer(wt));
            this.markerWidthLabel.setText(String.valueOf(wt));
        } else if (source == this.medianWidth) {
            this.chart.setPropertyValue(811, (Object)new Integer(wt));
            this.medianWidthLabel.setText(String.valueOf(wt));
        } else if (source == this.meanWidth) {
            this.chart.setPropertyValue(814, (Object)new Integer(wt));
            this.meanWidthLabel.setText(String.valueOf(wt));
        }
    }

    @Override
    public boolean cancelChanges() {
        this.setInitialValues();
        this.chart.cancelPropertyChanges();
        return true;
    }

    @Override
    public boolean applyChanges() {
        this.chart.applyPropertyChanges();
        return true;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        return false;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return false;
    }

    class ColorPanel
    extends JPanel {
        private static final long serialVersionUID = 664797906343391036L;
        Color color;
        int height;
        boolean enabled = true;

        ColorPanel(Color c, int h) {
            this.height = h;
            this.color = c;
            this.setBackground(Color.white);
            Border inBorder = BorderFactory.createLineBorder(new Color(128, 128, 128), BORDER);
            Border outBorder = BorderFactory.createEtchedBorder();
            this.setBorder(BorderFactory.createCompoundBorder(outBorder, inBorder));
        }

        Color getColor() {
            return this.color;
        }

        void setColor(Color c) {
            this.color = c;
            this.repaint();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(COLOR_PANE_WIDTH, this.height);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(COLOR_PANE_WIDTH, this.height);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(COLOR_PANE_WIDTH, this.height);
        }

        @Override
        protected void paintComponent(Graphics g) {
            if (this.enabled) {
                g.setColor(this.color);
            } else {
                g.setColor(BoxPlotDataPointsPanel.this.GRAYOUT);
            }
            g.fillRect(0, 0, COLOR_PANE_WIDTH, this.height);
        }

        @Override
        public void setEnabled(boolean on) {
            this.enabled = on;
        }
    }
}

