/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.ColorMapperChooserPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.MarkerShapeOption;
import com.sas.graphics.silk.util.PropertyUtils;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.ScatterDialogDefaults;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class BaseScatterPanel
extends JPanel
implements ActionListener,
ChangeListener,
TabPanelInterface {
    private static final long serialVersionUID = 5945998805514768110L;
    protected boolean internalUpdate;
    protected JPanel MkrGrpPanel;
    protected JCheckBox ShowMkrCheckBox;
    protected JLabel ShapeLabel;
    protected JComboBox ShapeCombo;
    protected JLabel MkrSizeLabel;
    protected JSlider MkrSizeSlider;
    protected JCheckBox MkrOutlineCB;
    protected JCheckBox MkrFillCB;
    protected JCheckBox autoSizeMkrCB;
    protected TitledBorder MkrGrpBorder;
    protected Vector propListeners;
    protected String sliderPattern;
    protected ScatterDialogDefaults defaults;
    protected Object[] sliderArgs;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected boolean supportsMarkers = false;
    protected boolean showMarkerVisibleWidget = false;
    protected boolean supportsJoinLines = false;
    protected ColorMapperChooserPanel colorMapperChooserPanel = null;

    public BaseScatterPanel() {
        this.sliderPattern = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Size_Slider_Text.fmt", (String)"Size: {0,number,integer}");
        this.sliderArgs = new Object[1];
        this.defaults = new ScatterDialogDefaults();
        Insets ins = this.getInsets();
        this.propListeners = new Vector();
        this.internalUpdate = false;
        this.setLayout(new BorderLayout());
        this.createControls();
    }

    protected void fillShapeCombo() {
        int n = 0;
        MarkerShapeOption[] list = null;
        this.ShapeCombo.removeAllItems();
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2037);
        if (o != null && o instanceof MarkerShapeOption[]) {
            list = (MarkerShapeOption[])o;
            n = list.length;
        }
        for (int i = 0; i < n; ++i) {
            this.ShapeCombo.addItem(list[i]);
        }
    }

    @Override
    public void setVisible(boolean show) {
        if (show) {
            if (this.ShapeCombo.getItemCount() <= 0) {
                this.fillShapeCombo();
            }
            this.updateMarkerSettings();
            if (!this.isVisible()) {
                this.MkrOutlineCB.addActionListener(this);
                this.MkrFillCB.addActionListener(this);
                this.ShowMkrCheckBox.addActionListener(this);
                this.MkrSizeSlider.addChangeListener(this);
                this.autoSizeMkrCB.addActionListener(this);
                this.ShapeCombo.addActionListener(this);
            }
            if (this.colorMapperChooserPanel != null) {
                this.colorMapperChooserPanel.initFromSource();
            }
        } else {
            this.ShapeCombo.removeAllItems();
            this.MkrOutlineCB.removeActionListener(this);
            this.MkrFillCB.removeActionListener(this);
            this.ShowMkrCheckBox.removeActionListener(this);
            this.MkrSizeSlider.removeChangeListener(this);
            this.autoSizeMkrCB.removeActionListener(this);
            this.ShapeCombo.removeActionListener(this);
        }
        super.setVisible(show);
    }

    protected void createControls() {
        if (this.propListeners == null || this.propListeners.size() == 0) {
            return;
        }
        this.supportsJoinLines = false;
        this.supportsMarkers = false;
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2071);
        if (o instanceof Boolean) {
            this.supportsJoinLines = (Boolean)o;
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2070)) instanceof Boolean) {
            this.supportsMarkers = (Boolean)o;
        }
        if ((o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2075)) instanceof Boolean) {
            this.showMarkerVisibleWidget = (Boolean)o;
        }
        int y = 6;
        int ht = 125;
        int y2 = 65;
        this.MkrGrpBorder = new TitledBorder(new EtchedBorder());
        this.MkrGrpBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.MkrGrpBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Markers_Title.txt", (String)"Markers"));
        this.MkrGrpBorder.setTitleColor(Color.black);
        JPanel controlPanel = new JPanel();
        BoxLayout ctrlPanelLayout = new BoxLayout(controlPanel, 1);
        controlPanel.setLayout(ctrlPanelLayout);
        this.MkrGrpPanel = new JPanel();
        this.ShowMkrCheckBox = new JCheckBox();
        this.ShowMkrCheckBox.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShowMkrCheckBox.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Show_Markers.txt", (String)"Show Markers"));
        this.ShowMkrCheckBox.setActionCommand("Show Markers");
        this.ShapeLabel = new JLabel();
        this.ShapeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShapeLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Marker_Shape.txt", (String)"Shape:"));
        this.ShapeLabel.setForeground(Color.black);
        this.ShapeCombo = new JComboBox();
        this.ShapeCombo.setFont(TabbedPropertiesDialog.dialogFont);
        this.ShapeCombo.setBackground(Color.white);
        this.MkrSizeLabel = new JLabel();
        this.MkrSizeLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.sliderArgs[0] = new Integer(0);
        this.MkrSizeLabel.setText(MessageFormat.format(this.sliderPattern, this.sliderArgs));
        this.MkrSizeLabel.setForeground(Color.black);
        this.MkrSizeSlider = new JSlider();
        this.MkrOutlineCB = new JCheckBox();
        this.MkrOutlineCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrOutlineCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Show_Marker_Outlines.txt", (String)"Show Outlines"));
        this.MkrOutlineCB.setActionCommand("Show Outlines");
        this.MkrFillCB = new JCheckBox();
        this.MkrFillCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.MkrFillCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Fill_Markers.txt", (String)"Fill Markers"));
        this.MkrFillCB.setActionCommand("Show Outlines");
        this.autoSizeMkrCB = new JCheckBox();
        this.autoSizeMkrCB.setFont(TabbedPropertiesDialog.dialogFont);
        this.autoSizeMkrCB.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterPanel.Autosize_Markers.txt", (String)"Autosize Markers"));
        this.autoSizeMkrCB.setActionCommand("Autosize Markers");
        this.setVisible(false);
        BoxLayout bl = new BoxLayout(this.MkrGrpPanel, 1);
        this.MkrGrpPanel.setLayout(bl);
        if (this.supportsMarkers) {
            controlPanel.add(this.MkrGrpPanel);
        }
        if (this.showMarkerVisibleWidget || this.supportsJoinLines && this.supportsMarkers) {
            this.MkrGrpPanel.add(this.ShowMkrCheckBox);
        }
        Box mkrShapeBox = new Box(0);
        mkrShapeBox.add(this.ShapeLabel);
        mkrShapeBox.add(Box.createHorizontalStrut(20));
        mkrShapeBox.add(this.ShapeCombo);
        mkrShapeBox.add(Box.createHorizontalStrut(60));
        this.MkrGrpPanel.add(mkrShapeBox);
        Box mkrOutlineBox = new Box(0);
        mkrOutlineBox.add(this.MkrOutlineCB);
        mkrOutlineBox.add(Box.createHorizontalGlue());
        this.MkrGrpPanel.add(mkrOutlineBox);
        Box autoSizeMkrBox = new Box(0);
        autoSizeMkrBox.add(this.autoSizeMkrCB);
        autoSizeMkrBox.add(Box.createHorizontalGlue());
        this.MkrGrpPanel.add(autoSizeMkrBox);
        Box mkrSizeBox = new Box(0);
        mkrSizeBox.add(this.MkrSizeLabel);
        mkrSizeBox.add(Box.createHorizontalGlue());
        mkrSizeBox.add(this.MkrSizeSlider);
        this.MkrGrpPanel.add(mkrSizeBox);
        this.MkrGrpPanel.setBorder(this.MkrGrpBorder);
        this.colorMapperChooserPanel = new ColorMapperChooserPanel(this.propListeners);
        controlPanel.add(this.colorMapperChooserPanel);
        controlPanel.add(Box.createVerticalStrut(240));
        this.add((Component)controlPanel, "Center");
    }

    protected boolean getBooleanProperty(Vector props, int id, boolean defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMarkerSettings() {
        double size = -1.0;
        BaseScatterPanel baseScatterPanel = this;
        synchronized (baseScatterPanel) {
            this.internalUpdate = true;
        }
        boolean markersMapped = this.getBooleanProperty(this.propListeners, 2043, false);
        boolean markersOn = this.getBooleanProperty(this.propListeners, 2036, true);
        boolean sizable = this.getBooleanProperty(this.propListeners, 2033, true);
        boolean bubblePlot = this.getBooleanProperty(this.propListeners, 2062, false);
        boolean autoSize = this.getBooleanProperty(this.propListeners, 2007, true);
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2006);
        boolean constantSize = o == null ? true : o instanceof Number;
        if (constantSize && o != null) {
            size = ((Number)o).doubleValue();
        }
        boolean outlinesOn = this.getBooleanProperty(this.propListeners, 2018, true);
        boolean isAnOutlineShape = this.getBooleanProperty(this.propListeners, 2035, true);
        boolean isFillableShape = this.getBooleanProperty(this.propListeners, 2034, true);
        boolean isFillOn = this.getBooleanProperty(this.propListeners, 2017, true);
        this.ShapeLabel.setEnabled(markersOn && !markersMapped);
        this.ShapeCombo.setEnabled(markersOn && !markersMapped);
        this.ShowMkrCheckBox.setSelected(markersOn || !this.showMarkerVisibleWidget && markersMapped || bubblePlot);
        this.ShowMkrCheckBox.setEnabled(this.showMarkerVisibleWidget || !markersMapped && !bubblePlot);
        boolean isMarkerFilled = true;
        o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)2015);
        if (o != null) {
            int markerEnum = 0;
            if (o instanceof Number) {
                markerEnum = ((Number)o).intValue();
            }
            this.ShapeCombo.setSelectedItem(null);
            for (int i = 0; i < this.ShapeCombo.getItemCount(); ++i) {
                MarkerShapeOption ms;
                Object obj = this.ShapeCombo.getItemAt(i);
                if (!(obj instanceof MarkerShapeOption) || (ms = (MarkerShapeOption)obj).getMarkerEnum() != markerEnum) continue;
                this.ShapeCombo.setSelectedItem(ms);
                isMarkerFilled = ms.isFilled();
            }
            if (this.ShapeCombo.getSelectedObjects().length == 0) {
                this.ShapeCombo.setEnabled(false);
            }
        }
        this.MkrOutlineCB.setEnabled(isAnOutlineShape && markersOn && isFillOn && isMarkerFilled);
        this.MkrOutlineCB.setSelected(outlinesOn);
        this.MkrFillCB.setEnabled(isFillableShape && markersOn && !markersMapped);
        this.MkrFillCB.setSelected(isFillOn);
        this.MkrSizeLabel.setEnabled(constantSize && markersOn && sizable && !autoSize && !bubblePlot);
        this.autoSizeMkrCB.setEnabled(constantSize && markersOn && sizable && !bubblePlot);
        this.autoSizeMkrCB.setSelected(autoSize);
        this.MkrSizeSlider.setEnabled(constantSize && markersOn && sizable && !autoSize && !bubblePlot);
        if (constantSize) {
            double min = this.getNumericProperty(this.propListeners, 2008, 2.0);
            double max = this.getNumericProperty(this.propListeners, 2009, 25.0);
            int sliderMin = this.MkrSizeSlider.getMinimum();
            int sliderMax = this.MkrSizeSlider.getMaximum();
            int sliderValue = (int)((double)(sliderMax - sliderMin) * (size - min) / (max - min) + (double)sliderMin);
            sliderValue = sliderValue < sliderMin ? sliderMin : sliderValue;
            sliderValue = sliderValue > sliderMax ? sliderMax : sliderValue;
            this.MkrSizeSlider.setValue(sliderValue);
            this.sliderArgs[0] = new Integer((int)size);
            this.MkrSizeLabel.setText(MessageFormat.format(this.sliderPattern, this.sliderArgs));
        }
        BaseScatterPanel baseScatterPanel2 = this;
        synchronized (baseScatterPanel2) {
            this.internalUpdate = false;
        }
    }

    protected double getNumericProperty(Vector props, int id, double defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).doubleValue();
    }

    protected String getStringProperty(Vector props, int id, String defaultValue) {
        Object o = PropertyUtils.getPropertyValue((Vector)this.propListeners, (int)id);
        if (o == null || !(o instanceof String)) {
            return defaultValue;
        }
        return (String)o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JCheckBox check = null;
        if (this.internalUpdate) {
            return;
        }
        if (source == null) {
            return;
        }
        if (source instanceof JComboBox) {
            JComboBox box = (JComboBox)source;
            Object obj = box.getSelectedItem();
            if (obj == null) {
                return;
            }
            if (!box.equals(this.ShapeCombo)) return;
            if (!(obj instanceof MarkerShapeOption)) return;
            MarkerShapeOption msoption = (MarkerShapeOption)obj;
            Integer markerShapeEnum = msoption.getMarkerEnum();
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2015, (Object)markerShapeEnum);
            this.updateMarkerSettings();
            return;
        } else {
            if (!(source instanceof JCheckBox)) return;
            check = (JCheckBox)source;
            boolean status = check.isSelected();
            if (check.equals(this.MkrOutlineCB)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2018, (Object)new Boolean(status));
                this.updateMarkerSettings();
                return;
            } else if (check.equals(this.MkrFillCB)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2017, (Object)new Boolean(status));
                if (!status) {
                    PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2054, (Object)new Boolean(false));
                }
                this.updateMarkerSettings();
                return;
            } else if (check.equals(this.ShowMkrCheckBox)) {
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2036, (Object)new Boolean(status));
                this.updateMarkerSettings();
                return;
            } else {
                if (!check.equals(this.autoSizeMkrCB)) return;
                PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2007, (Object)new Boolean(status));
                this.updateMarkerSettings();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.internalUpdate) {
            return;
        }
        if (source == this.MkrSizeSlider) {
            int min = this.MkrSizeSlider.getMinimum();
            int max = this.MkrSizeSlider.getMaximum();
            int v = this.MkrSizeSlider.getValue();
            double mkrMin = this.getNumericProperty(this.propListeners, 2008, 2.0);
            double mkrMax = this.getNumericProperty(this.propListeners, 2009, 2.0);
            int newSize = (int)Math.round((double)(v - min) / (double)(max - min) * (mkrMax - mkrMin) + mkrMin);
            newSize = newSize % 2 == 0 ? newSize - 1 : newSize;
            PropertyUtils.setPropertyValue((Vector)this.propListeners, (int)2006, (Object)new Integer(newSize));
            this.sliderArgs[0] = new Integer(newSize);
            this.MkrSizeLabel.setText(MessageFormat.format(this.sliderPattern, this.sliderArgs));
        }
    }

    @Override
    public boolean applyChanges() {
        boolean status = PropertyUtils.applyChanges((Vector)this.propListeners);
        this.updateMarkerSettings();
        return status;
    }

    @Override
    public boolean cancelChanges() {
        boolean rc = PropertyUtils.cancelChanges((Vector)this.propListeners);
        this.updateMarkerSettings();
        return rc;
    }

    @Override
    public boolean addPropertyListener(PropertyInterface prop) {
        boolean rc = PropertyUtils.addPropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
        if (rc && this.propListeners.size() == 1) {
            this.createControls();
        }
        return rc;
    }

    @Override
    public boolean removePropertyListener(PropertyInterface prop) {
        return PropertyUtils.removePropertyListener((Vector)this.propListeners, (PropertyInterface)prop);
    }
}

