/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.ui;

import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.ui.TabbedPropertiesDialog;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.util.PropertyEvent;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AxisOptionsDialog
extends JDialog
implements ActionListener,
ChangeListener,
FocusListener,
WindowListener {
    private static final long serialVersionUID = -5136395069203522348L;
    protected static final int WIDTH = 232;
    protected static final int HEIGHT = 270;
    protected boolean internalUpdate = false;
    protected boolean addCalled = false;
    protected String textOnEnter = null;
    protected JPanel radioPanel;
    protected JRadioButton autoAxis;
    protected JRadioButton specifyAxis;
    protected TitledBorder radioBorder;
    protected ButtonGroup radioGroup;
    protected JLabel startLabel;
    protected JTextField startValue;
    protected JLabel endLabel;
    protected JTextField endValue;
    protected JLabel majorTickLabel;
    protected JSlider majorTickSlider;
    protected JLabel minorTickLabel;
    protected JSlider minorTickSlider;
    protected JButton cancelBtn;
    protected JButton applyBtn;
    protected JButton OKBtn;
    protected JTextField curTextField = null;
    protected PropertyInterface axis;
    protected ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");

    public AxisOptionsDialog(Frame parent) {
        super(parent);
        this.getContentPane().setLayout(null);
        this.setSize(232, 270);
        this.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Axis_Settings.txt", (String)"Axis Settings"));
        this.createControls();
        this.addWindowListener(this);
        this.startValue.addFocusListener(this);
        this.endValue.addFocusListener(this);
    }

    public AxisOptionsDialog(String title) {
        this();
        this.setTitle(title);
    }

    public AxisOptionsDialog() {
        this((Frame)null);
    }

    protected void createControls() {
        this.radioBorder = new TitledBorder(new EtchedBorder());
        this.radioBorder.setTitleFont(TabbedPropertiesDialog.dialogFont);
        this.radioPanel = new JPanel();
        this.autoAxis = new JRadioButton();
        this.autoAxis.setFont(TabbedPropertiesDialog.dialogFont);
        this.autoAxis.setForeground(Color.black);
        this.specifyAxis = new JRadioButton();
        this.specifyAxis.setFont(TabbedPropertiesDialog.dialogFont);
        this.specifyAxis.setForeground(Color.black);
        this.radioGroup = new ButtonGroup();
        this.radioBorder.setTitle(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Axis_Determination.txt", (String)"Axis Determination"));
        this.radioBorder.setTitleColor(Color.black);
        this.radioPanel.setLayout(null);
        this.getContentPane().add(this.radioPanel);
        this.radioPanel.setBounds(4, 4, 214, 72);
        this.radioPanel.setBorder(this.radioBorder);
        this.autoAxis.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Compute_Nice_Values.txt", (String)"Compute Nice Values"));
        this.autoAxis.setActionCommand("Compute Nice Values");
        this.radioPanel.add(this.autoAxis);
        this.autoAxis.setBounds(8, 16, 200, 24);
        this.specifyAxis.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Use_The_Values_I_Specify.txt", (String)"Use The Values I Specify"));
        this.specifyAxis.setActionCommand("Use The Values I Specify");
        this.radioPanel.add(this.specifyAxis);
        this.specifyAxis.setBounds(8, 44, 200, 24);
        this.radioGroup.add(this.autoAxis);
        this.radioGroup.add(this.specifyAxis);
        this.autoAxis.setSelected(true);
        this.startLabel = new JLabel();
        this.startLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.startLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Start.txt", (String)"Start"));
        this.startLabel.setForeground(Color.black);
        this.getContentPane().add(this.startLabel);
        this.startLabel.setBounds(10, 86, 80, 24);
        this.startValue = new JTextField();
        this.startValue.setFont(TabbedPropertiesDialog.dialogFont);
        this.getContentPane().add(this.startValue);
        this.startValue.setBounds(94, 86, 80, 24);
        this.endLabel = new JLabel();
        this.endLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.endLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.End.txt", (String)"End"));
        this.endLabel.setForeground(Color.black);
        this.getContentPane().add(this.endLabel);
        this.endLabel.setBounds(10, 114, 80, 24);
        this.endValue = new JTextField();
        this.endValue.setFont(TabbedPropertiesDialog.dialogFont);
        this.getContentPane().add(this.endValue);
        this.endValue.setBounds(94, 114, 80, 24);
        this.majorTickLabel = new JLabel();
        this.majorTickLabel.setFont(TabbedPropertiesDialog.dialogFont);
        this.majorTickLabel.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Major_Ticks__2.txt", (String)"Major Ticks: 2"));
        this.majorTickLabel.setForeground(Color.black);
        this.getContentPane().add(this.majorTickLabel);
        this.majorTickLabel.setBounds(10, 142, 80, 24);
        this.majorTickSlider = new JSlider();
        this.getContentPane().add(this.majorTickSlider);
        this.majorTickSlider.setBounds(94, 142, 120, 24);
        this.majorTickSlider.setMinimum(2);
        this.majorTickSlider.setMaximum(20);
        this.majorTickSlider.setValue(2);
        this.minorTickLabel = new JLabel();
        this.minorTickSlider = new JSlider();
        this.OKBtn = new JButton();
        this.OKBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.OKBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.OK.txt", (String)"OK"));
        this.OKBtn.setForeground(Color.black);
        this.getContentPane().add(this.OKBtn);
        this.OKBtn.setBounds(6, 202, 68, 24);
        this.cancelBtn = new JButton();
        this.cancelBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.cancelBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Cancel.txt", (String)"Cancel"));
        this.cancelBtn.setForeground(Color.black);
        this.getContentPane().add(this.cancelBtn);
        this.cancelBtn.setBounds(78, 202, 68, 24);
        this.applyBtn = new JButton();
        this.applyBtn.setFont(TabbedPropertiesDialog.dialogFont);
        this.applyBtn.setText(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Apply.txt", (String)"Apply"));
        this.applyBtn.setForeground(Color.black);
        this.getContentPane().add(this.applyBtn);
        this.applyBtn.setBounds(150, 202, 68, 24);
    }

    protected boolean getBooleanProperty(PropertyInterface prop, int id, boolean defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Boolean)) {
            return defaultValue;
        }
        return (Boolean)o;
    }

    protected int getIntegerProperty(PropertyInterface prop, int id, int defaultValue) {
        if (prop == null) {
            return defaultValue;
        }
        Object o = prop.getPropertyValue(id);
        if (o == null || !(o instanceof Number)) {
            return defaultValue;
        }
        return ((Number)o).intValue();
    }

    protected boolean setProperty(PropertyInterface prop, int id, Object value) {
        if (prop == null) {
            return false;
        }
        PropertyEvent pe = new PropertyEvent(id, (Object)this, value);
        return prop.setPropertyValue(id, (Object)pe);
    }

    protected Object[] getSetAxisArgs(boolean auto) {
        int n;
        Double high;
        Double low;
        Integer minorTicks = new Integer(-1);
        Object[] out = null;
        try {
            low = Double.valueOf(this.startValue.getText());
            high = Double.valueOf(this.endValue.getText());
        }
        catch (NumberFormatException e) {
            return null;
        }
        Integer majorTicks = new Integer(this.majorTickSlider.getValue());
        if (this.majorTickSlider.isEnabled()) {
            minorTicks = new Integer(this.minorTickSlider.getValue());
        }
        if ((out = new Object[n = auto ? 5 : 6]) == null) {
            return null;
        }
        out[0] = new Boolean(this.autoAxis.isSelected());
        out[1] = low;
        out[2] = high;
        out[3] = majorTicks;
        out[4] = minorTicks;
        if (!auto) {
            out[4] = new Integer(this.minorTickSlider.getValue());
            out[5] = null;
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAxisSettings() {
        if (this.axis == null) {
            return;
        }
        AxisOptionsDialog axisOptionsDialog = this;
        synchronized (axisOptionsDialog) {
            this.internalUpdate = true;
        }
        boolean autoCalc = this.getBooleanProperty(this.axis, 240, this.autoAxis.isSelected());
        boolean majorVisible = this.getBooleanProperty(this.axis, 223, true);
        boolean minorVisible = this.getBooleanProperty(this.axis, 226, false);
        int nMajor = this.getIntegerProperty(this.axis, 234, this.majorTickSlider.getValue());
        int nMinor = this.getIntegerProperty(this.axis, 235, this.minorTickSlider.getValue());
        this.autoAxis.setSelected(autoCalc);
        this.specifyAxis.setSelected(!autoCalc);
        Object o = this.axis.getPropertyValue(232);
        if (o != null) {
            this.startValue.setText(o.toString());
        }
        if ((o = this.axis.getPropertyValue(233)) != null) {
            this.endValue.setText(o.toString());
        }
        if (autoCalc) {
            this.startLabel.setEnabled(false);
            this.startValue.setEnabled(false);
            this.startValue.setEditable(false);
            this.endLabel.setEnabled(false);
            this.endValue.setEnabled(false);
            this.endValue.setEditable(false);
        } else {
            this.startLabel.setEnabled(true);
            this.startValue.setEnabled(true);
            this.startValue.setEditable(true);
            this.endLabel.setEnabled(true);
            this.endValue.setEnabled(true);
            this.endValue.setEditable(true);
        }
        this.majorTickLabel.setEnabled(majorVisible);
        Message majorTicksText = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Major_ticks.fmt.txt", (String)"{0}: {1}"));
        String tmpStr = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Major_Ticks.txt", (String)"Major_Ticks");
        tmpStr = majorTicksText.toString((Object)tmpStr, (Object)Integer.toString(nMajor));
        this.majorTickLabel.setText(tmpStr);
        this.majorTickSlider.setEnabled(majorVisible);
        this.majorTickSlider.setValue(nMajor);
        this.minorTickLabel.setEnabled(majorVisible && minorVisible);
        tmpStr = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Minor_Ticks.txt", (String)"Minor_Ticks");
        tmpStr = majorTicksText.toString((Object)tmpStr, (Object)Integer.toString(nMinor));
        this.minorTickLabel.setText(tmpStr);
        this.minorTickSlider.setEnabled(majorVisible && minorVisible);
        this.minorTickSlider.setValue(nMinor);
        AxisOptionsDialog axisOptionsDialog2 = this;
        synchronized (axisOptionsDialog2) {
            this.internalUpdate = false;
        }
    }

    public void setVisible(boolean show, PropertyInterface axisIn) {
        if (show) {
            this.axis = axisIn;
        }
        this.setVisible(show);
    }

    @Override
    public void setVisible(boolean show) {
        if (show && !this.addCalled) {
            this.autoAxis.addActionListener(this);
            this.specifyAxis.addActionListener(this);
            this.startValue.addActionListener(this);
            this.endValue.addActionListener(this);
            this.majorTickSlider.addChangeListener(this);
            this.minorTickSlider.addChangeListener(this);
            this.cancelBtn.addActionListener(this);
            this.applyBtn.addActionListener(this);
            this.OKBtn.addActionListener(this);
            this.addCalled = true;
            this.updateAxisSettings();
        } else if (this.addCalled) {
            this.autoAxis.removeActionListener(this);
            this.specifyAxis.removeActionListener(this);
            this.startValue.removeActionListener(this);
            this.endValue.removeActionListener(this);
            this.majorTickSlider.removeChangeListener(this);
            this.minorTickSlider.removeChangeListener(this);
            this.cancelBtn.removeActionListener(this);
            this.applyBtn.removeActionListener(this);
            this.OKBtn.removeActionListener(this);
            this.addCalled = false;
        }
        super.setVisible(show);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        JRadioButton radio = null;
        JButton button = null;
        if (this.internalUpdate) {
            return;
        }
        if (source == null || this.axis == null) {
            return;
        }
        if (source instanceof JRadioButton) {
            radio = (JRadioButton)source;
            if (radio != this.autoAxis && radio != this.specifyAxis) return;
            this.setProperty(this.axis, 242, new Integer(-1));
            this.setProperty(this.axis, 239, this.getSetAxisArgs(this.autoAxis.isSelected()));
            this.updateAxisSettings();
            return;
        } else if (source instanceof JTextField) {
            this.setProperty(this.axis, 242, new Integer(-1));
            this.setProperty(this.axis, 239, this.getSetAxisArgs(this.autoAxis.isSelected()));
            this.curTextField = null;
            return;
        } else {
            if (!(source instanceof JButton)) return;
            button = (JButton)source;
            if (button == this.cancelBtn) {
                this.axis.cancelPropertyChanges((Object)this);
            } else if (button == this.applyBtn || button == this.OKBtn) {
                this.axis.applyPropertyChanges((Object)this);
                if (this.getParent() != null) {
                    this.getParent().repaint();
                }
            }
            if (button == this.applyBtn) {
                this.updateAxisSettings();
                return;
            } else {
                this.dispose();
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object source = e.getSource();
        if (this.internalUpdate || this.axis == null) {
            return;
        }
        if (source == this.majorTickSlider) {
            int v = this.majorTickSlider.getValue();
            this.setProperty(this.axis, 242, new Integer(-1));
            this.setProperty(this.axis, 239, this.getSetAxisArgs(this.autoAxis.isSelected()));
            Message majorTicksText = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Major_ticks.fmt.txt", (String)"{0}: {1}"));
            String tmpStr = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Major_Ticks.txt", (String)"Major_Ticks");
            tmpStr = majorTicksText.toString((Object)tmpStr, (Object)Integer.toString(v));
            this.majorTickLabel.setText(tmpStr);
        } else if (source == this.minorTickSlider) {
            int v = this.minorTickSlider.getValue();
            this.setProperty(this.axis, 242, new Integer(-1));
            this.setProperty(this.axis, 239, this.getSetAxisArgs(this.autoAxis.isSelected()));
            Message minorTicksText = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Minor_ticks.fmt.txt", (String)"{0}: {1}"));
            String tmpStr = ResourceLoader.getResourceString((Object)this.rb, (String)"AxisOptionsDialog.Minor_Ticks.txt", (String)"Minor_Ticks");
            tmpStr = minorTicksText.toString((Object)tmpStr, (Object)Integer.toString(v));
            this.majorTickLabel.setText(tmpStr);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        Object source = e.getSource();
        if (!(source instanceof JTextField)) {
            return;
        }
        this.curTextField = (JTextField)source;
        this.textOnEnter = this.curTextField.getText();
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (this.curTextField == null) {
            return;
        }
        String curText = this.curTextField.getText();
        if (curText != null && !curText.equalsIgnoreCase(this.textOnEnter)) {
            this.curTextField.postActionEvent();
        }
        this.curTextField = null;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent event) {
        if (this.axis != null) {
            this.axis.cancelPropertyChanges((Object)this);
        }
        this.dispose();
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }
}

