/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import com.sas.graphics.silk.interfaces.GraphBackgroundInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.util.ColorParse;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;

public class Wall
implements GraphBackgroundInterface,
ImageObserver,
RenderInterface {
    public boolean redrawRequired;
    protected boolean visible = true;
    protected int paintOrientation;
    protected int paintX;
    protected int paintY;
    protected int paintWidth;
    protected int paintHeight;
    protected int imageFitStyle;
    protected double opacity1;
    protected double opacity2;
    protected double imageBlend;
    protected Color defaultColor;
    protected Object bg;
    protected Image backImage;
    protected Image scaledBackImage;
    protected Component comp;
    protected Toolkit tk = null;

    public Wall(Component c) {
        this.comp = c;
        this.redrawRequired = true;
        this.paintOrientation = 0;
        this.imageFitStyle = 1;
        this.opacity1 = 1.0;
        this.opacity2 = Double.NaN;
        this.imageBlend = 1.0;
        this.backImage = null;
        this.scaledBackImage = null;
        this.paintY = -1;
        this.paintX = -1;
        this.paintHeight = 10;
        this.paintWidth = 10;
        this.defaultColor = new Color(225, 229, 250);
        this.setSolidBackground(this.defaultColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scaleIfNeeded(int x, int y, int width, int height) {
        GradientPaint gp = null;
        if (!(this.bg != null && this.bg instanceof GradientPaint || this.backImage != null)) {
            return;
        }
        if (x == this.paintX && y == this.paintY && this.paintWidth == width && this.paintHeight == height) {
            this.redrawRequired = false;
            return;
        }
        Wall wall = this;
        synchronized (wall) {
            this.paintX = x;
            this.paintY = y;
            this.paintWidth = width;
            this.paintHeight = height;
        }
        if (this.bg != null && this.bg instanceof GradientPaint) {
            gp = (GradientPaint)this.bg;
        }
        if (this.bg != null) {
            float y2;
            float y1;
            float x1;
            float x2;
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            switch (this.paintOrientation) {
                default: {
                    x1 = x2 = (float)(x + width / 2);
                    y1 = y;
                    y2 = y + height;
                    break;
                }
                case 3: {
                    x1 = x2 = (float)(x + width / 2);
                    y1 = y + height;
                    y2 = y;
                    break;
                }
                case 0: {
                    x1 = x;
                    x2 = x + width;
                    y1 = y2 = (float)(y + height / 2);
                    break;
                }
                case 1: {
                    x1 = x + width;
                    x2 = x;
                    y1 = y2 = (float)(y + height / 2);
                    break;
                }
                case 4: {
                    x1 = x;
                    x2 = x + width;
                    y1 = x;
                    y2 = y + height;
                }
            }
            this.bg = new GradientPaint(x1, y1, c1, x2, y2, c2);
        }
        if (this.scaledBackImage != null) {
            this.setImageBackground(this.backImage, new Integer(0), 0, 0, this.imageBlend);
        }
    }

    public void draw(Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = null;
        Composite c = null;
        if (this.redrawRequired) {
            this.redrawRequired = false;
        }
        if (!this.visible) {
            return;
        }
        if (g == null || !(g instanceof Graphics2D)) {
            return;
        }
        g2 = (Graphics2D)g;
        if (this.bg == null) {
            g2.setColor(this.defaultColor);
        } else if (this.bg instanceof Color) {
            g2.setColor((Color)this.bg);
        } else if (this.bg instanceof GradientPaint || this.backImage != null) {
            this.scaleIfNeeded(x, y, width, height);
            g2.setPaint((GradientPaint)this.bg);
        }
        if (Double.isNaN(this.opacity2) && this.opacity1 < 1.0) {
            c = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, (float)this.opacity1));
        }
        g2.fillRect(x, y, width, height);
        if (c != null) {
            g2.setComposite(c);
        }
        c = null;
        if (this.imageBlend < 1.0) {
            c = g2.getComposite();
            g2.setComposite(AlphaComposite.getInstance(3, (float)this.imageBlend));
        }
        if (this.backImage != null) {
            switch (this.imageFitStyle) {
                default: {
                    break;
                }
                case 0: {
                    if (this.scaledBackImage == null) break;
                    g2.drawImage(this.scaledBackImage, x, y, this);
                    break;
                }
                case 1: {
                    int w = this.backImage.getWidth(this);
                    int h = this.backImage.getHeight(this);
                    if (w <= 0 || h <= 0) break;
                    for (int iy = 0; iy < height; iy += h) {
                        for (int ix = 0; ix < width; ix += w) {
                            g2.drawImage(this.backImage, ix + x, iy + y, this);
                        }
                    }
                    break;
                }
                case 2: {
                    int w = this.backImage.getWidth(this);
                    int h = this.backImage.getHeight(this);
                    g2.drawImage(this.backImage, (width - w) / 2 + x, (height - h) / 2 + y, this);
                }
            }
        }
        if (c != null) {
            g2.setComposite(c);
        }
    }

    @Override
    public Object[] getGraphBackground() {
        Object[] array = null;
        if (this.backImage != null) {
            array = new Object[4];
            if (array == null) {
                return null;
            }
            array[0] = this.bg != null ? this.bg : this.defaultColor;
            array[1] = this.backImage;
            array[2] = new Integer(this.imageFitStyle);
            array[3] = new Double(this.imageBlend);
            return array;
        }
        array = new Object[1];
        if (array == null) {
            return null;
        }
        array[0] = this.backImage != null ? this.backImage : (this.bg != null ? this.bg : this.defaultColor);
        return array;
    }

    @Override
    public boolean supportsImageBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setImageBackground(Image img, Object fitStyle, int x, int y, double blend) {
        Wall wall;
        int fit = this.imageFitStyle;
        int flags = 0;
        Image tmp = null;
        if (img == null) {
            this.backImage = null;
            this.scaledBackImage = null;
            Wall wall2 = this;
            synchronized (wall2) {
                this.redrawRequired = true;
                return true;
            }
        }
        if (fitStyle != null) {
            if (fitStyle instanceof String) {
                if (((String)fitStyle).equalsIgnoreCase("Stretch") || ((String)fitStyle).equalsIgnoreCase("Stretch to fit")) {
                    fit = 0;
                } else if (((String)fitStyle).equalsIgnoreCase("Tile")) {
                    fit = 1;
                } else if (((String)fitStyle).equalsIgnoreCase("Center")) {
                    fit = 2;
                } else {
                    if (!((String)fitStyle).equalsIgnoreCase("Locate")) return false;
                    fit = 3;
                }
            } else if (fitStyle instanceof Number) {
                fit = ((Number)fitStyle).intValue();
            }
        }
        if (!Double.isNaN(blend) && !Double.isInfinite(blend)) {
            this.imageBlend = blend;
        }
        if (this.imageBlend < 0.0) {
            this.imageBlend = 0.0;
        } else if (this.imageBlend > 1.0) {
            this.imageBlend = 1.0;
        }
        switch (fit) {
            case 1: 
            case 2: 
            case 3: {
                this.backImage = img;
                this.scaledBackImage = null;
                this.imageFitStyle = fit;
                break;
            }
            case 0: {
                if (this.paintWidth < 0 || this.paintHeight < 0) {
                    return false;
                }
                if (this.tk == null) {
                    if (this.comp == null) {
                        return false;
                    }
                    this.tk = this.comp.getToolkit();
                    if (this.tk == null) {
                        return false;
                    }
                }
                wall = this;
                synchronized (wall) {
                    this.imageFitStyle = fit;
                    this.backImage = img;
                    this.scaledBackImage = null;
                }
                tmp = img.getScaledInstance(this.paintWidth, this.paintHeight, 1);
                if (tmp == null || ((flags = this.tk.checkImage(img, -1, -1, this)) & 0x20) == 0) break;
                this.scaledBackImage = tmp;
            }
        }
        wall = this;
        synchronized (wall) {
            this.redrawRequired = true;
            return true;
        }
    }

    @Override
    public boolean supportsGradientBackground() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setGradientBackground(Object startColor, Object endColor, Object orientation) {
        GradientPaint gp;
        float y2;
        float y1;
        float x1;
        float x2;
        Color c2;
        Color c1;
        int orient = this.paintOrientation;
        if (startColor == null || endColor == null && (this.bg == null || !(this.bg instanceof GradientPaint))) {
            return false;
        }
        if (startColor == null) {
            c1 = ((GradientPaint)this.bg).getColor1();
        } else if (startColor instanceof Color) {
            c1 = (Color)startColor;
        } else {
            if (!(startColor instanceof String)) return false;
            c1 = ColorParse.getColorFromString((String)((String)startColor));
            if (c1 == null) {
                return false;
            }
        }
        if (endColor == null) {
            c2 = ((GradientPaint)this.bg).getColor2();
        } else if (endColor instanceof Color) {
            c2 = (Color)endColor;
        } else {
            if (!(endColor instanceof String)) return false;
            c2 = ColorParse.getColorFromString((String)((String)endColor));
            if (c2 == null) {
                return false;
            }
        }
        if (orientation != null) {
            if (orientation instanceof String) {
                if (((String)orientation).equalsIgnoreCase("Left to right")) {
                    orient = 0;
                } else if (((String)orientation).equalsIgnoreCase("Right to left")) {
                    orient = 1;
                } else if (((String)orientation).equalsIgnoreCase("Top to bottom")) {
                    orient = 2;
                } else if (((String)orientation).equalsIgnoreCase("Bottom to top")) {
                    orient = 3;
                } else {
                    if (!((String)orientation).equalsIgnoreCase("Diagonal")) return false;
                    orient = 4;
                }
            } else {
                if (!(orientation instanceof Number)) return false;
                orient = ((Number)orientation).intValue();
            }
        }
        if (this.paintX < 0) {
            this.paintX = 0;
        }
        if (this.paintY < 0) {
            this.paintY = 0;
        }
        if (this.paintWidth < 0) {
            this.paintWidth = 10;
        }
        if (this.paintHeight < 0) {
            this.paintHeight = 10;
        }
        switch (orient) {
            default: {
                return false;
            }
            case 2: {
                x1 = x2 = (float)(this.paintX + this.paintWidth / 2);
                y1 = this.paintY;
                y2 = this.paintY + this.paintHeight;
                break;
            }
            case 3: {
                x1 = x2 = (float)(this.paintX + this.paintWidth / 2);
                y1 = this.paintY + this.paintHeight;
                y2 = this.paintY;
                break;
            }
            case 0: {
                x1 = this.paintX;
                x2 = this.paintX + this.paintWidth;
                y1 = y2 = (float)(this.paintY + this.paintHeight / 2);
                break;
            }
            case 1: {
                x1 = this.paintX + this.paintWidth;
                x2 = this.paintX;
                y1 = y2 = (float)(this.paintY + this.paintHeight / 2);
                break;
            }
            case 4: {
                x1 = this.paintX;
                x2 = this.paintX + this.paintWidth;
                y1 = this.paintY;
                y2 = this.paintY + this.paintHeight;
            }
        }
        this.paintOrientation = orient;
        if (c1 != null && c2 != null && !Double.isNaN(this.opacity2)) {
            c1 = new Color(c1.getRed(), c1.getGreen(), c1.getBlue(), (int)(255.0 * this.opacity1));
            c2 = new Color(c2.getRed(), c2.getGreen(), c2.getBlue(), (int)(255.0 * this.opacity2));
        }
        if ((gp = new GradientPaint(x1, y1, c1, x2, y2, c2)) == null) {
            return false;
        }
        this.bg = gp;
        Wall wall = this;
        synchronized (wall) {
            this.redrawRequired = true;
            return true;
        }
    }

    @Override
    public Color getSolidBackground() {
        if (this.bg == null) {
            return this.defaultColor;
        }
        if (this.bg instanceof Color) {
            return (Color)this.bg;
        }
        if (this.bg instanceof GradientPaint) {
            return ((GradientPaint)this.bg).getColor1();
        }
        return this.defaultColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setSolidBackground(Object c) {
        if (c == null) {
            return false;
        }
        if (c instanceof Color) {
            this.bg = c;
        } else if (c instanceof String) {
            Color color = ColorParse.getColorFromString((String)((String)c));
            if (color == null) {
                return false;
            }
            this.bg = color;
        } else {
            return false;
        }
        Wall wall = this;
        synchronized (wall) {
            this.redrawRequired = true;
        }
        return true;
    }

    @Override
    public void redrawGraphBackground(Component c) {
        if (c != null) {
            c.repaint();
        } else if (this.comp != null) {
            this.comp.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if ((flags & 0xC0) != 0) {
            return false;
        }
        if ((flags & 0x20) != 0) {
            if (this.imageFitStyle == 0) {
                this.scaledBackImage = img;
            } else {
                this.backImage = img;
            }
            Wall wall = this;
            synchronized (wall) {
                this.redrawRequired = true;
            }
            if (this.comp != null) {
                this.comp.repaint();
            }
            return false;
        }
        return true;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        Wall wall = this;
        synchronized (wall) {
            this.redrawRequired = true;
        }
    }

    @Override
    public Object getOpacityValue() {
        double[] array = null;
        if (Double.isNaN(this.opacity2)) {
            return new Double(this.opacity1);
        }
        array = new double[2];
        if (array == null) {
            return new Double(this.opacity1);
        }
        array[0] = this.opacity1;
        array[1] = this.opacity2;
        return array;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setOpacityValue(Object newOpacity) {
        double d1;
        Color c1 = null;
        Color c2 = null;
        if (newOpacity == null) {
            return false;
        }
        if (newOpacity instanceof Number) {
            d1 = ((Number)newOpacity).doubleValue();
            if (Double.isInfinite(d1) || Double.isNaN(d1) || d1 < 0.0 || d1 > 1.0) {
                return false;
            }
        } else {
            int type = Extract.getSourceType((Object)newOpacity);
            if (type <= 0 || Extract.getNumberItems((Object)newOpacity, (int)type) < 1) {
                return false;
            }
            double d12 = Extract.getNumeric((Object)newOpacity, (int)0, (int)type);
            if (Double.isInfinite(d12) || Double.isNaN(d12) || d12 < 0.0 || d12 > 1.0) {
                return false;
            }
            double d2 = Extract.getNumeric((Object)newOpacity, (int)1, (int)type);
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 < 0.0 || d2 > 1.0) {
                return false;
            }
            if (this.bg != null) {
                if (this.bg instanceof Color) {
                    c1 = c2 = (Color)this.bg;
                } else if (this.bg instanceof GradientPaint) {
                    c1 = ((GradientPaint)this.bg).getColor1();
                    c2 = ((GradientPaint)this.bg).getColor2();
                }
            }
            if (c1 != null && c2 != null) {
                this.opacity1 = d12;
                this.opacity2 = d2;
                this.setGradientBackground(c1, c2, null);
                return true;
            }
            return false;
        }
        this.opacity1 = d1;
        Wall wall = this;
        synchronized (wall) {
            this.redrawRequired = true;
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (this.comp != null) {
            this.comp.repaint();
        }
    }

    @Override
    public void drawHighlight(Object p) {
    }
}

