/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import com.sas.graphics.data.IOBSInterface;
import com.sas.graphics.silk.band.Band;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterUpdateInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.interfaces.URLSourceInterface;
import com.sas.graphics.silk.scatter.PickAreaList;
import com.sas.graphics.silk.scatter.ScatterObject;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.Marker;
import com.sas.graphics.silk.util.Marker2;
import com.sas.graphics.silk.util.Marker3;
import com.sas.graphics.silk.util.Marker4;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.UniqueValueMapper;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.util.Iterator;
import java.util.Vector;

public class ScatterObjectJ2D
extends ScatterObject
implements DataFilterListenerInterface,
IOBSInterface,
URLSourceInterface {
    public static final int RENDER = 1;
    public static final int SELECTION = 2;
    protected static final int LINES = 0;
    protected static final int MARKERS = 1;
    protected boolean ourPicking = false;
    protected boolean projectMarkers = true;
    protected boolean dataValuesChanged = false;
    protected int renderMode = 1;
    protected int markerLevel = 1;
    protected int mkrLvlNeeded = 0;
    protected int nElements = 0;
    protected double xMin;
    protected double xMax;
    protected double yMin = Double.NaN;
    protected double yMax;
    protected Point firstMarkerLoc;
    protected Color effectiveShadowColor = null;
    protected Marker pickedMarker = null;
    protected BasicStroke borderStroke = null;
    protected Vector markers;
    protected Vector selectedMarkers = null;
    protected Vector urlConsumers;
    protected boolean[][] paUse;
    protected double[] temp;

    public ScatterObjectJ2D(Object dataSource, boolean singleUseIn) {
        super(dataSource, singleUseIn);
        this.xMin = Double.NaN;
        this.yMax = Double.NaN;
        this.xMax = Double.NaN;
        this.firstMarkerLoc = new Point(-1, -1);
        this.urlConsumers = new Vector();
        this.paUse = new boolean[4][4];
        this.temp = new double[3];
        this.markers = new Vector();
        if (this.markers == null) {
            throw new OutOfMemoryError(ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.DisplayListMemMsg", (String)"No memory for display list"));
        }
    }

    public ScatterObjectJ2D(boolean singleUseIn) {
        this(null, singleUseIn);
    }

    public ScatterObjectJ2D() {
        this(null, false);
    }

    public boolean getOurPicking() {
        return this.ourPicking;
    }

    public void setOurPicking(boolean us) {
        this.ourPicking = us;
    }

    public void setPickAreaBounds(int x, int y, int w, int h) {
        this.paX = x;
        this.paY = y;
        this.paWidth = w;
        this.paHeight = h;
        if (this.groups == null) {
            return;
        }
        Iterator itr = this.groups.iterator();
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            PickAreaList pa;
            ScatterObject.GroupData gd = (ScatterObject.GroupData)itr.next();
            if (gd == null || (pa = gd.getPickAreaList()) == null) continue;
            pa = this.setPickAreaBounds(pa, x, y, w, h);
            gd.setPickAreaList(pa);
        }
    }

    protected PickAreaList setPickAreaBounds(PickAreaList pa, int x, int y, int w, int h) {
        if (this.singleUse) {
            return null;
        }
        if (pa == null) {
            pa = new PickAreaList();
        }
        pa.setBounds(x, y, w, h);
        return pa;
    }

    public void setSelectedMarkers(Vector vec) {
        this.selectedMarkers = vec;
    }

    protected Marker getMarker(int idx) {
        if (this.markers == null || idx < 0 || idx >= this.nElements) {
            return null;
        }
        return (Marker)this.markers.elementAt(idx);
    }

    protected int compare(Marker m1, Marker m2) {
        if (this.isBubblePlot) {
            return this.compare2(m1, m2);
        }
        return this.compare1(m1, m2);
    }

    protected int compare1(Marker m1, Marker m2) {
        double d2;
        double d1 = m1.getNumericX();
        if (d1 < (d2 = m2.getNumericX())) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    protected int compare2(Marker m1, Marker m2) {
        double d2;
        double d1 = m1.getDataSize();
        if (d1 < (d2 = m2.getDataSize())) {
            return -1;
        }
        if (d1 > d2) {
            return 1;
        }
        return 0;
    }

    protected int compare(int idx, Marker m2) {
        if (idx < m2.getObsIndex()) {
            return -1;
        }
        if (idx > m2.getObsIndex()) {
            return 1;
        }
        return 0;
    }

    protected int binarylookup(Marker val, Vector vec, int uselen) {
        if (val == null) {
            return -1;
        }
        return this.binarylookup(val.getObsIndex(), vec, uselen);
    }

    protected int binarylookup(int idx, Vector vec, int uselen) {
        int len = uselen;
        Marker vecEntry = null;
        if (len < 0) {
            len = vec.size();
        }
        int ret = -1;
        int lo = 0;
        int mi = 0;
        int hi = len - 1;
        while (lo <= hi) {
            mi = (lo + hi) / 2;
            vecEntry = (Marker)vec.elementAt(mi);
            ret = this.compare(idx, vecEntry);
            switch (ret) {
                case -1: {
                    hi = mi - 1;
                    break;
                }
                case 0: {
                    return mi;
                }
                case 1: {
                    lo = mi + 1;
                }
            }
        }
        if (ret != 1) {
            ret = 0;
        }
        return -(mi + 1 + ret);
    }

    protected boolean shouldWriteURLs() {
        return this.dataFilter != null && this.urlConsumers != null && this.urlConsumers.size() > 0;
    }

    protected boolean writeURLs(long iobs) {
        int i;
        int n;
        String s = null;
        Vector tipList = new Vector();
        String[] strings = new String[10];
        String tipString = "";
        if (this.urlConsumers == null || (n = this.urlConsumers.size()) <= 0) {
            return false;
        }
        if (this.dataFilter == null) {
            return false;
        }
        Object o = this.dataFilter.getValue(this.urlVariable, iobs);
        if (o != null) {
            s = o.toString();
        }
        Marker m = this.getMarker((int)iobs);
        this.pick(m.screenX, m.screenY, null, false, 0, true, false, tipList);
        int num = this.getPickContents(tipList, strings);
        for (i = 0; i < num; ++i) {
            tipString = tipString + strings[i] + (i == num - 1 ? "" : "\n");
        }
        for (i = 0; i < n; ++i) {
            URLConsumer con = (URLConsumer)this.urlConsumers.elementAt(i);
            if (con == null) continue;
            con.consumer.beginURL(con.context, s, tipString);
        }
        return true;
    }

    protected void closeURLs() {
        int n;
        if (this.urlConsumers == null || (n = this.urlConsumers.size()) <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            URLConsumer con = (URLConsumer)this.urlConsumers.elementAt(i);
            if (con == null) continue;
            con.consumer.endURL(con.context);
        }
    }

    protected Object pullObjectFromList(Vector list, int idx) {
        if (list == null || idx < 0 || list.size() <= idx) {
            return null;
        }
        return list.elementAt(idx);
    }

    protected boolean pushObjectToList(Vector list, Object obj) {
        if (obj == null || list == null) {
            return false;
        }
        int count = list.size();
        if (this.nElements < count) {
            list.setElementAt(obj, this.nElements);
        } else {
            list.addElement(obj);
        }
        ++this.nElements;
        return true;
    }

    protected int playIt(int type, int size, boolean fillit, Graphics2D g, FontRenderContext fr, Font labelFont, Object obj, int pickX, int pickY, Rectangle rect, boolean isSelectionEvent, int select, boolean updatePickList, boolean pickObs, Vector pickList, int grow, Color color, Color markerLabelColor, TextStyleInterface lblAttribs, boolean keepPartialMarkers) {
        boolean picked = false;
        double halfSize = 0.0;
        Marker mkr = (Marker)obj;
        if (this.dataViewported) {
            double d;
            double dataX = mkr.getNumericX();
            double dataY = mkr.getNumericY();
            if (keepPartialMarkers && !Double.isNaN(d = mkr.getDataSize())) {
                halfSize = d * 0.5;
            }
            if (dataX + halfSize < this.minDrawX || dataY + halfSize < this.minDrawY || dataX - halfSize > this.maxDrawX || dataY - halfSize > this.maxDrawY) {
                return 0;
            }
        }
        if (this.isBubblePlot) {
            size = mkr.projectMarkerSize(this.transObj, this.temp);
        }
        switch (this.renderMode) {
            case 1: {
                mkr.draw(type, size, g, fr, labelFont, fillit, color, this.scatterDefaults.outlinesOn, this.markerOutlineColor, grow, this.effectiveShadowColor, this.markerShadowSoftness, this.scatterDefaults.markerShadowOffset, markerLabelColor, lblAttribs, this.isBubblePlot | this.simpleMarkers, !this.isBubblePlot);
                break;
            }
            case 2: {
                picked = rect != null ? mkr.pick(type, size, rect) : mkr.pick(type, size, pickX, pickY);
                if (!updatePickList || !picked || pickList.contains(mkr)) break;
                pickList.addElement(mkr);
            }
        }
        if (isSelectionEvent && picked && pickObs && this.dataFilter != null) {
            int idx = mkr.getObsIndex();
            boolean status = this.dataFilter.isSelected((long)idx);
            switch (select) {
                case -1: {
                    status = !status;
                    break;
                }
                case 0: {
                    status = false;
                    break;
                }
                case 1: {
                    status = true;
                }
            }
            this.dataFilter.setSelected((long)idx, status);
        }
        if (picked) {
            return 1;
        }
        return 0;
    }

    protected void drawErrorBars(Graphics2D g, Marker mkr, int size) {
        int halfSize = size / 2;
        int msx = mkr.screenX;
        int lowY = -999;
        int highY = -999;
        Color c = g.getColor();
        Color ebClr = null;
        double low = mkr.getErrorLow();
        double high = mkr.getErrorHigh();
        double mx = mkr.getNumericX();
        double my = mkr.getNumericY();
        if (this.dataViewported && (mx < this.minDrawX || my < this.minDrawY || mx > this.maxDrawX || my > this.maxDrawY)) {
            return;
        }
        LineStyleInterface ls = this.getErrorBars();
        if (ls != null) {
            ebClr = ls.getColor();
        }
        if (ebClr == null) {
            ebClr = Color.black;
        }
        g.setColor(ebClr);
        if (!Double.isNaN(low)) {
            this.transObj.project(mx, low, 0.0, this.temp);
            lowY = (int)this.temp[1];
            g.drawLine(msx - halfSize, lowY, msx + halfSize, lowY);
        }
        if (!Double.isNaN(high)) {
            this.transObj.project(mx, high, 0.0, this.temp);
            highY = (int)this.temp[1];
            g.drawLine(msx - halfSize, highY, msx + halfSize, highY);
        }
        if (lowY > -500 && highY > -500 && this.getErrorBars().isVisible()) {
            g.drawLine(msx, lowY, msx, highY);
        }
        g.setColor(c);
    }

    public int getPickContents(Vector v, String[] contents) {
        int count;
        int out = 0;
        Object o = null;
        if (this.tipText == null || (count = v.size()) <= 0) {
            return 0;
        }
        Object e = v.elementAt(count - 1);
        o = e;
        if (e == null) {
            return 0;
        }
        if (this.dataFilter != null) {
            for (int i = count - 1; i >= 0; --i) {
                int iobs;
                Object o2 = v.elementAt(i);
                if (o2 == null || (iobs = ((Marker)o2).getObsIndex()) < 0 || !this.dataFilter.isSelected((long)iobs)) continue;
                o = o2;
                break;
            }
        }
        this.pickedMarker = o;
        this.curTipVarIdx = 0;
        this.curTipValueIdx = 0;
        out = this.tipText.doSubstitution(this, this.dataFilter, contents);
        this.curTipVarIdx = 0;
        this.curTipValueIdx = 0;
        this.pickedMarker = null;
        return out;
    }

    protected int pick(int pickX, int pickY, Rectangle rect, boolean isSelectionEvent, int select, boolean updatePickList, boolean pickObs, Vector pickList) {
        boolean keepPartial = this.isBubbleStylePlot();
        boolean mappedMkr = this.isMappedMarker(this.markerShape);
        boolean constantSize = this.areMarkersConstantSize();
        int ni = 1;
        int nj = 1;
        int oldRenderMode = this.renderMode;
        int count = 0;
        int type = this.getMarkerTypeInt(-1, -1L);
        int typeVarIdx = -1;
        int size = 10;
        Object o = null;
        Vector markers = this.markers;
        Iterator itr = null;
        PickAreaList pa = null;
        int[] indicies = null;
        if (updatePickList && pickList == null) {
            return 0;
        }
        if (updatePickList) {
            pickList.removeAllElements();
        }
        if (mappedMkr) {
            typeVarIdx = this.dataFilter.getVariableIndex(this.markerShape);
        }
        if (constantSize) {
            size = ((Number)this.markerSize).intValue();
        }
        this.setRenderMode(2);
        if (this.groups != null) {
            itr = this.groups.iterator();
        }
        do {
            int idx;
            int n;
            if (itr == null) {
                nj = 1;
                ni = 1;
                n = this.nElements;
            } else {
                ScatterObject.GroupData grpData;
                if (!itr.hasNext() || (grpData = (ScatterObject.GroupData)itr.next()) == null) break;
                n = grpData.getNumberMarkers();
                if (this.isBubblePlot) {
                    switch (this.sizeSorted) {
                        default: {
                            break;
                        }
                        case -1: 
                        case 1: {
                            indicies = grpData.getSortIndicies();
                        }
                    }
                }
                markers = grpData.getMarkers();
                if (rect != null && (pa = grpData.getPickAreaList()) != null) {
                    pa.getSectors(rect, this.paUse);
                    nj = 4;
                    ni = 4;
                }
            }
            if (rect != null) {
                for (int i = 0; i < ni; ++i) {
                    for (int j = 0; j < nj; ++j) {
                        int k = 0;
                        if (this.singleUse || pa == null) {
                            if ((idx = k++) >= this.nElements) {
                                idx = -1;
                            }
                        } else {
                            if (!this.paUse[i][j]) continue;
                            idx = pa.getNextObsInSector(i, j, k++);
                        }
                        while (idx >= 0 && idx < n) {
                            Object e = markers.elementAt(idx);
                            o = e;
                            if (e == null) continue;
                            if (mappedMkr) {
                                type = this.getMarkerTypeInt(typeVarIdx, ((Marker)o).getObsIndex());
                            }
                            if (!constantSize && !this.isBubblePlot) {
                                size = this.mapMarkerSize(((Marker)o).getDataSize());
                            }
                            count += this.playIt(type, size, false, null, null, null, o, pickX, pickY, rect, isSelectionEvent, select, updatePickList, pickObs, pickList, 0, null, null, null, keepPartial);
                            if (this.singleUse || pa == null) {
                                if ((idx = k++) < this.nElements) continue;
                                idx = -1;
                                continue;
                            }
                            idx = pa.getNextObsInSector(i, j, k++);
                        }
                    }
                }
            } else {
                for (idx = 0; idx < n; ++idx) {
                    o = indicies != null ? markers.elementAt((int)indicies[idx]) : markers.elementAt(idx);
                    if (o == null) continue;
                    if (mappedMkr) {
                        type = this.getMarkerTypeInt(typeVarIdx, ((Marker)o).getObsIndex());
                    }
                    if (!constantSize && !this.isBubblePlot) {
                        size = this.mapMarkerSize(((Marker)o).getDataSize());
                    }
                    count += this.playIt(type, size, false, null, null, null, o, pickX, pickY, rect, isSelectionEvent, select, updatePickList, pickObs, pickList, 0, null, null, null, keepPartial);
                }
            }
        } while (itr != null);
        this.setRenderMode(oldRenderMode);
        return count;
    }

    public int pick(Object region, boolean isSelectEvent, int select, boolean updatePickList, boolean pickObs, Vector pickList) {
        if (region == null) {
            return 0;
        }
        if (region instanceof Rectangle) {
            return this.pick((Rectangle)region, isSelectEvent, select, updatePickList, pickObs, pickList);
        }
        if (region instanceof Point) {
            return this.pick(((Point)region).x, ((Point)region).y, isSelectEvent, select, updatePickList, pickObs, pickList);
        }
        return 0;
    }

    public int pick(int x, int y, boolean isSelectEvent, int select, boolean updatePickList, boolean pickObs, Vector pickList) {
        return this.pick(x, y, null, isSelectEvent, select, updatePickList, pickObs, pickList);
    }

    public int pick(Rectangle rect, boolean isSelectEvent, int select, boolean updatePickList, boolean pickObs, Vector pickList) {
        return this.pick(0, 0, rect, isSelectEvent, select, updatePickList, pickObs, pickList);
    }

    public int unPick(Object region, Vector pickList) {
        Vector<Marker> removeList;
        boolean mappedMkr = this.isMappedMarker(this.markerShape);
        boolean constantSize = this.areMarkersConstantSize();
        boolean regionIsRect = region != null && region instanceof Rectangle;
        boolean regionIsPoint = region != null && region instanceof Point;
        int count = 0;
        int n = pickList == null ? 0 : pickList.size();
        int type = this.getMarkerTypeInt(-1, -1L);
        int typeVarIdx = -1;
        int size = 10;
        if (n <= 0 || this.dataFilter == null) {
            return 0;
        }
        if (region != null && !regionIsRect && !regionIsPoint) {
            return 0;
        }
        if (mappedMkr) {
            typeVarIdx = this.dataFilter.getVariableIndex(this.markerShape);
        }
        if (constantSize) {
            size = ((Number)this.markerSize).intValue();
        }
        if (region == null) {
            removeList = new Vector<Marker>(pickList);
        } else {
            removeList = new Vector();
            if (removeList == null) {
                return 0;
            }
            for (int i = 0; i < n; ++i) {
                boolean picked;
                Marker mkr = (Marker)pickList.elementAt(i);
                if (mkr == null) continue;
                if (mappedMkr) {
                    type = this.getMarkerTypeInt(typeVarIdx, mkr.getObsIndex());
                }
                if (!constantSize && !this.isBubblePlot) {
                    size = this.mapMarkerSize(mkr.getDataSize());
                }
                if (regionIsRect) {
                    picked = mkr.pick(type, size, (Rectangle)region);
                } else {
                    if (!regionIsPoint) continue;
                    picked = mkr.pick(type, size, ((Point)region).x, ((Point)region).y);
                }
                if (!picked) continue;
                removeList.addElement(mkr);
            }
        }
        count = removeList.size();
        this.dataFilter.setSelected(removeList, false, (IOBSInterface)this);
        return count;
    }

    public boolean setRenderMode(int mode) {
        switch (mode) {
            case 1: 
            case 2: {
                this.renderMode = mode;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setDataLimits(double xmin, double ymin, double xmax, double ymax) {
        this.xMin = Double.isNaN(xmin) ? this.dataMin[0] : xmin;
        this.yMin = Double.isNaN(ymin) ? this.dataMin[1] : ymin;
        this.xMax = Double.isNaN(xmax) ? this.dataMax[0] : xmax;
        this.yMax = Double.isNaN(ymax) ? this.dataMax[1] : ymax;
        return true;
    }

    @Override
    protected boolean buildSetup() {
        this.nElements = 0;
        this.largestMarkerDrawn = 0;
        this.mkrLvlNeeded = this.isMarkerShapeAGlyph() ? 4 : (this.scatterDefaults.coalesceOn || this.markerSize != null && this.markerSize instanceof String || this.markerOpacity != null && this.markerOpacity instanceof String || this.respErrorLow != null || this.respErrorHigh != null || this.labelVariable != null || this.hasSplineJoin(-1) ? 3 : (this.categoryIsCharacter || this.responseIsCharacter ? 2 : 1));
        return true;
    }

    @Override
    protected boolean buildCleanup() {
        if (!this.singleUse) {
            this.setPickAreaBounds(this.paX, this.paY, this.paWidth, this.paHeight);
        }
        return true;
    }

    @Override
    protected void buildError() {
        this.nElements = 0;
    }

    protected int coalesce(Object x, Object y, double size) {
        int n = 0;
        if (x == null || y == null || !(x instanceof Number) || !(y instanceof Number)) {
            return -1;
        }
        n = this.nElements;
        if (n <= 0) {
            return -2;
        }
        double cdistsq = this.coalesceDistance * this.coalesceDistance;
        double xval = ((Number)x).doubleValue();
        double yval = ((Number)y).doubleValue();
        for (int i = 0; i < n; ++i) {
            double d;
            Marker m = (Marker)this.pullObjectFromList(this.markers, i);
            if (m == null) continue;
            double xmkrval = m.getNumericX();
            double ymkrval = m.getNumericY();
            double xdistsq = xval - xmkrval;
            xdistsq *= xdistsq;
            double ydistsq = yval - ymkrval;
            if (!(xdistsq + (ydistsq *= ydistsq) < cdistsq)) continue;
            switch (this.coalesceStatistic) {
                default: {
                    d = m.getDataSize() + 1.0;
                    break;
                }
                case 2: 
                case 3: {
                    d = m.getDataSize() + size;
                    m.setCount(m.getCount() + 1);
                }
            }
            m.setDataSize(d);
            this.updateMinMax(d, 2);
            return i;
        }
        return -2;
    }

    protected Marker getNextMarker(ScatterObject.GroupData gd, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        Marker m = (Marker)this.pullObjectFromList(this.markers, this.nElements);
        if (this.mkrLvlNeeded != this.markerLevel) {
            this.markers.removeAllElements();
            m = null;
        }
        if (m == null) {
            switch (this.mkrLvlNeeded) {
                default: {
                    m = new Marker(gd.getIndex(), img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
                    this.markerLevel = 1;
                    break;
                }
                case 2: {
                    m = new Marker2(gd.getIndex(), img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
                    this.markerLevel = 2;
                    break;
                }
                case 3: {
                    m = new Marker3(gd.getIndex(), img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
                    this.markerLevel = 3;
                    break;
                }
                case 4: {
                    m = new Marker4(gd.getIndex(), img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
                    this.markerLevel = 4;
                }
            }
            if (!this.pushObjectToList(this.markers, m)) {
                return null;
            }
        } else {
            m.init(gd.getIndex(), img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
            ++this.nElements;
        }
        gd.addMarker(m);
        return m;
    }

    @Override
    protected int onMarker(ScatterObject.GroupData gd, Image img, Object x, Object y, Object z, int iobs, double dataSize, double dataOpacity, double opacity, String label, double errLow, double errHigh) {
        int out;
        int n = 0;
        int idx = this.scatterDefaults.coalesceOn ? this.coalesce(x, y, dataSize) : -1;
        switch (idx) {
            case -2: {
                switch (this.coalesceStatistic) {
                    case 1: {
                        dataSize = 1.0;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n = 1;
                    }
                }
                this.updateMinMax(dataSize, 2);
            }
            case -1: {
                Marker m = this.getNextMarker(gd, img, x, y, z, iobs, dataSize, dataOpacity, opacity, label, errLow, errHigh);
                if (m != null) {
                    m.setCount(n);
                    if (this.dataFilter != null && this.dataFilter.isSelected((long)iobs) && this.selectedMarkers != null && !this.selectedMarkers.contains(m)) {
                        this.selectedMarkers.addElement(m);
                    }
                }
                out = this.nElements - 1;
                break;
            }
            default: {
                return idx;
            }
        }
        return out;
    }

    @Override
    protected void onText(String text, double x, double y, double z, int justLR, int justTB, Object obj) {
    }

    protected boolean bubblesort(Vector sortlist, int[] indicies, int n) {
        boolean done;
        int count = n;
        if (sortlist == null || sortlist.size() < n) {
            return false;
        }
        do {
            done = true;
            for (int i = 0; i < count - 1; ++i) {
                if (this.compare((Marker)sortlist.elementAt(indicies[i]), (Marker)sortlist.elementAt(indicies[i + 1])) <= 0) continue;
                int holder = indicies[i];
                indicies[i] = indicies[i + 1];
                indicies[i + 1] = holder;
                done = false;
            }
            --count;
        } while (!done);
        return true;
    }

    protected boolean heapsort(Vector sortlist, int[] indicies, int n) {
        if (sortlist == null || sortlist.size() < n) {
            return false;
        }
        int parent = n / 2 + 1;
        int curlen = n;
        while (true) {
            int holder;
            if (parent > 1) {
                holder = indicies[--parent - 1];
            } else {
                holder = indicies[curlen - 1];
                indicies[curlen - 1] = indicies[0];
                if (--curlen == 0) {
                    indicies[0] = holder;
                    return true;
                }
            }
            int curnode = parent;
            int largest_child = parent + parent;
            while (largest_child <= curlen) {
                if (largest_child < curlen && this.compare((Marker)sortlist.elementAt(indicies[largest_child - 1]), (Marker)sortlist.elementAt(indicies[largest_child])) < 0) {
                    ++largest_child;
                }
                if (this.compare((Marker)sortlist.elementAt(holder), (Marker)sortlist.elementAt(indicies[largest_child - 1])) < 0) {
                    indicies[curnode - 1] = indicies[largest_child - 1];
                    curnode = largest_child;
                    largest_child += largest_child;
                    continue;
                }
                largest_child = curlen + 1;
            }
            indicies[curnode - 1] = holder;
        }
    }

    @Override
    protected boolean sortMarkers(Vector markers, int[] indicies, int nindicies, int order) {
        boolean result;
        if (indicies == null || nindicies <= 0 || indicies.length < nindicies) {
            return false;
        }
        switch (this.scatterDefaults.sortAlgorithm) {
            default: {
                if (nindicies > this.scatterDefaults.sortLimit) {
                    result = this.heapsort(markers, indicies, nindicies);
                    break;
                }
                result = this.bubblesort(markers, indicies, nindicies);
                break;
            }
            case 1: {
                result = this.bubblesort(markers, indicies, nindicies);
                break;
            }
            case 2: {
                result = this.heapsort(markers, indicies, nindicies);
            }
        }
        if (order == -1) {
            for (int i = 0; i < nindicies; ++i) {
                indicies[i] = nindicies - i - 1;
            }
        }
        return result;
    }

    @Override
    protected void finalizeMarkers(UniqueValueMapper catMapper, UniqueValueMapper respMapper) {
        int i;
        boolean runLoop = false;
        int n = this.nElements;
        Marker mkr = null;
        if (n <= 0 || this.markers == null || this.markers.size() < n) {
            return;
        }
        if (this.scatterDefaults.coalesceOn && this.coalesceStatistic == 3) {
            this.dataMax[2] = Double.NaN;
            this.dataMin[2] = Double.NaN;
            for (i = 0; i < n; ++i) {
                mkr = this.getMarker(i);
                if (mkr == null) continue;
                this.updateMinMax(mkr.getDataSize() / (double)mkr.getCount(), 2);
            }
            this.setMinimumMarkerDataValue(this.dataMin[2]);
            this.setMaximumMarkerDataValue(this.dataMax[2]);
        }
        if (this.categoryIsCharacter || this.responseIsCharacter || this.groupVariable != null) {
            runLoop = true;
        }
        if (!runLoop) {
            return;
        }
        for (i = 0; i < n; ++i) {
            mkr = this.getMarker(i);
            if (mkr == null) continue;
            if (this.categoryIsCharacter || this.responseIsCharacter) {
                mkr.adjustShape(catMapper, respMapper);
            }
            if (this.isBubblePlot) continue;
            if (this.scatterDefaults.coalesceOn) {
                switch (this.coalesceStatistic) {
                    default: {
                        mkr.getDataSize();
                        break;
                    }
                    case 3: {
                        mkr.getDataSize();
                        mkr.getCount();
                        break;
                    }
                }
                continue;
            }
            mkr.getDataSize();
        }
    }

    protected boolean hasSplineJoin(int nToSearch) {
        int n = nToSearch;
        if (this.joinStyle == null) {
            return this.defaultJoinStyle == 6;
        }
        if (n < 0) {
            n = this.joinStyle.length;
        }
        n = Math.min(n, this.joinStyle.length);
        for (int i = 1; i < n; ++i) {
            if (this.joinStyle[i] != 6) continue;
            return true;
        }
        return false;
    }

    protected int getMaxJoinStyle(int nToSearch) {
        int n = nToSearch;
        int max = this.defaultJoinStyle;
        if (this.joinStyle == null) {
            return max;
        }
        if (n < 0) {
            n = this.joinStyle.length;
        }
        n = Math.min(n, this.joinStyle.length);
        max = this.joinStyle[0];
        for (int i = 1; i < n; ++i) {
            if (this.joinStyle[i] <= max) continue;
            max = this.joinStyle[i];
        }
        return max;
    }

    protected boolean hasBands(int nToSearch) {
        Iterator itr;
        int n = nToSearch;
        if (this.groups == null || (itr = this.groups.iterator()) == null) {
            return false;
        }
        n = Math.min(n, this.groups.size());
        while (itr.hasNext()) {
            ScatterObject.GroupData gd = (ScatterObject.GroupData)itr.next();
            if (gd == null || !gd.isBand()) continue;
            return true;
        }
        return false;
    }

    protected int getMaxGroupCount(int nToSearch) {
        Iterator itr;
        int n = nToSearch;
        int max = 0;
        if (this.groups == null || (itr = this.groups.iterator()) == null) {
            return 0;
        }
        n = Math.min(n, this.groups.size());
        while (itr.hasNext()) {
            ScatterObject.GroupData gd = (ScatterObject.GroupData)itr.next();
            if (gd == null || !gd.isBand() || gd.getNumberMarkers() <= max) continue;
            max = gd.getNumberMarkers();
        }
        return max;
    }

    protected boolean checkForProjectChanges() {
        int n = this.nElements;
        if (this.projectMarkers) {
            return true;
        }
        if (this.markers == null || n <= 0) {
            return false;
        }
        Marker m = this.getMarker(0);
        int ix = m.screenX;
        int iy = m.screenY;
        m.projectMarker(this.transObj, this.temp);
        if (ix != m.screenX || iy != m.screenY) {
            return true;
        }
        m = this.getMarker(n / 2);
        ix = m.screenX;
        iy = m.screenY;
        m.projectMarker(this.transObj, this.temp);
        if (ix != m.screenX || iy != m.screenY) {
            return true;
        }
        m = this.getMarker(n - 1);
        ix = m.screenX;
        iy = m.screenY;
        m.projectMarker(this.transObj, this.temp);
        return ix != m.screenX || iy != m.screenY;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean build(Object bldPtr) {
        boolean status;
        if (this.selectedMarkers != null) {
            this.selectedMarkers.removeAllElements();
        }
        if (status = super.build(bldPtr)) {
            if (Double.isNaN(this.xMin)) {
                this.xMin = this.dataMin[0];
            }
            if (Double.isNaN(this.xMax)) {
                this.xMax = this.dataMax[0];
            }
            if (Double.isNaN(this.yMin)) {
                this.yMin = this.dataMin[1];
            }
            if (Double.isNaN(this.yMax)) {
                this.yMax = this.dataMax[1];
            }
        }
        this.projectMarkers = true;
        return status;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    public void drawSelectedMarkers(Graphics2D g, FontRenderContext fr, Vector list) {
        boolean useColor = this.useColorAsSelection();
        boolean keepPartial = this.isBubbleStylePlot();
        boolean mappedMkr = this.isMappedMarker(this.markerShape);
        boolean areGroups = this.hasGroups(true);
        boolean fillit = this.scatterDefaults.fillShapes;
        boolean constantSize = this.areMarkersConstantSize();
        boolean markersOn = this.areMarkersOn();
        int grow = 0;
        int n = list.size();
        int curGrpIdx = -1;
        int clrVarIdx = -1;
        int size = 10;
        Color c = g.getColor();
        Color c2 = null;
        Color c3 = this.getMarkerLabelColor();
        Stroke s = null;
        Font labelFont = this.getMarkerLabelFont();
        int type = this.getMarkerTypeInt(-1, -1L);
        int typeVarIdx = -1;
        int grpVarIdx = -1;
        int grpIdxVarIdx = -1;
        Object grpValue = null;
        ScatterObject.GroupData grpData = null;
        if (!this.scatterDefaults.alwaysShowSelectedMarkers && !markersOn) {
            return;
        }
        if (mappedMkr) {
            typeVarIdx = this.dataFilter.getVariableIndex(this.markerShape);
        }
        if (this.markerColor != null && this.markerColor instanceof String && this.contRamp != null && this.selectionIndicator != 1) {
            clrVarIdx = this.dataFilter.getVariableIndex(this.markerColor);
        }
        if (constantSize) {
            size = ((Number)this.markerSize).intValue();
        }
        if (this.hasGroups(true)) {
            grpVarIdx = this.dataFilter.getVariableIndex(this.groupVariable);
            if (this.groupIndexVariable != null) {
                grpIdxVarIdx = this.dataFilter.getVariableIndex(this.groupIndexVariable);
            }
        }
        if (useColor) {
            g.setColor(this.getSelectionColor());
        } else {
            if (this.markerColor != null && this.markerColor instanceof Color) {
                g.setColor((Color)this.markerColor);
            }
            grow = this.markerSize instanceof Number ? ((Number)this.markerSize).intValue() >> 1 : this.minMarkerSize + this.maxMarkerSize >> 2;
        }
        if (this.isBubblePlot) {
            s = g.getStroke();
            g.setStroke(new BasicStroke(this.scatterDefaults.bubbleThickness));
        }
        for (int i = 0; i < n; ++i) {
            Marker m = (Marker)list.elementAt(i);
            int idx = m.getIndex();
            if (!this.scatterDefaults.alwaysShowSelectedMarkers && !this.isMarkerOn(idx)) continue;
            if (!useColor && (areGroups || this.nRespVarsToShow > 1) && idx != curGrpIdx) {
                g.setColor(this.clrRamp.query(idx, true, (int[])null));
                curGrpIdx = idx;
            }
            if (mappedMkr) {
                Object value = this.dataFilter.getValue(typeVarIdx, (long)m.getObsIndex());
                type = this.getMarkerMapping(value);
                fillit = this.getMarkerFillMapping(value);
            }
            if (Double.isNaN(m.getNumericX()) || Double.isNaN(m.getNumericY())) continue;
            if (this.projectMarkers) {
                m.projectMarker(this.transObj, this.temp);
            }
            if (clrVarIdx >= 0) {
                double d = this.getNumericValue(clrVarIdx, m.getObsIndex());
                c2 = this.clrRamp.queryDouble(d, this.discreteColor, null);
            }
            if (grpVarIdx >= 0 && !this.maxGroupsExceeded && (grpValue = this.dataFilter.getValue(grpVarIdx, (long)m.getObsIndex())) != null) {
                grpData = this.getGroupData(grpValue);
                if (grpIdxVarIdx >= 0) {
                    if (grpData == null || grpData.getColor() == null) {
                        int j = this.getGroupIndexValue(grpIdxVarIdx, i);
                        if (j >= 0) {
                            c2 = this.clrRamp.query(j, true, (int[])null);
                        }
                    } else {
                        c2 = grpData.getColor();
                    }
                }
            }
            if (!constantSize && !this.isBubblePlot) {
                size = this.mapMarkerSize(m.getDataSize());
            }
            if (this.categoryIsCharacter && m.getNumericX() < 0.0) continue;
            this.playIt(type, size, fillit, g, fr, labelFont, m, 0, 0, null, false, 0, false, false, null, grow, c2, c3, this.markerLabelAttribs, keepPartial);
        }
        if (s != null) {
            g.setStroke(s);
        }
        g.setColor(c);
    }

    public void drawSimpleLine(Graphics2D g, Marker m1, Marker m2, int style, boolean fill, Color fillColor, int base) {
        Color save = null;
        if (m1 == null) {
            return;
        }
        if (style != 5 && m2 == null) {
            return;
        }
        switch (style) {
            default: {
                break;
            }
            case 1: {
                if (fill) {
                    if (fillColor != null) {
                        save = g.getColor();
                        g.setColor(fillColor);
                    }
                    this.xPoints[0] = this.xPoints[3] = m1.screenX;
                    this.xPoints[1] = this.xPoints[2] = m2.screenX;
                    this.yPoints[0] = m1.screenY;
                    this.yPoints[1] = m2.screenY;
                    this.yPoints[2] = this.yPoints[3] = base;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                    if (save != null) {
                        g.setColor(save);
                    }
                }
                g.drawLine(m1.screenX, m1.screenY, m2.screenX, m2.screenY);
                break;
            }
            case 3: {
                int halfx = (m1.screenX + m2.screenX) / 2;
                if (fill) {
                    if (fillColor != null) {
                        save = g.getColor();
                        g.setColor(fillColor);
                    }
                    this.xPoints[0] = this.xPoints[3] = m1.screenX;
                    this.xPoints[1] = this.xPoints[2] = halfx;
                    this.yPoints[0] = this.yPoints[1] = m1.screenY;
                    this.yPoints[2] = this.yPoints[3] = base;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                    this.xPoints[0] = this.xPoints[3] = halfx;
                    this.xPoints[1] = this.xPoints[2] = m2.screenX;
                    this.yPoints[0] = this.yPoints[1] = m2.screenY;
                    this.yPoints[2] = this.yPoints[3] = base;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                    if (save != null) {
                        g.setColor(save);
                    }
                }
                g.drawLine(m1.screenX, m1.screenY, halfx, m1.screenY);
                g.drawLine(halfx, m1.screenY, halfx, m2.screenY);
                g.drawLine(halfx, m2.screenY, m2.screenX, m2.screenY);
                break;
            }
            case 2: {
                if (fill) {
                    if (fillColor != null) {
                        save = g.getColor();
                        g.setColor(fillColor);
                    }
                    this.xPoints[0] = this.xPoints[3] = m1.screenX;
                    this.xPoints[1] = this.xPoints[2] = m2.screenX;
                    this.yPoints[0] = this.yPoints[1] = m2.screenY;
                    this.yPoints[2] = this.yPoints[3] = base;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                    if (save != null) {
                        g.setColor(save);
                    }
                }
                g.drawLine(m1.screenX, m1.screenY, m1.screenX, m2.screenY);
                g.drawLine(m1.screenX, m2.screenY, m2.screenX, m2.screenY);
                break;
            }
            case 4: {
                if (fill) {
                    if (fillColor != null) {
                        save = g.getColor();
                        g.setColor(fillColor);
                    }
                    this.xPoints[0] = this.xPoints[3] = m1.screenX;
                    this.xPoints[1] = this.xPoints[2] = m2.screenX;
                    this.yPoints[0] = this.yPoints[1] = m1.screenY;
                    this.yPoints[2] = this.yPoints[3] = base;
                    g.fillPolygon(this.xPoints, this.yPoints, 4);
                    if (save != null) {
                        g.setColor(save);
                    }
                }
                g.drawLine(m1.screenX, m1.screenY, m2.screenX, m1.screenY);
                g.drawLine(m2.screenX, m1.screenY, m2.screenX, m2.screenY);
                break;
            }
            case 5: {
                g.drawLine(m1.screenX, m1.screenY, m1.screenX, base);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        boolean joinLinesOn;
        double y2;
        double y1;
        double x2;
        double x1;
        int i;
        boolean localOutlinesOn = this.scatterDefaults.outlinesOn;
        boolean localBandPlot = false;
        boolean keepPartial = this.isBubbleStylePlot();
        boolean areGroups = false;
        boolean writeURLs = this.shouldWriteURLs();
        boolean didWriteURLs = false;
        boolean localAreaFillOn = this.scatterDefaults.areaFillOn;
        boolean mappedMkr = this.isMappedMarker(this.markerShape);
        boolean constantSize = this.areMarkersConstantSize();
        boolean fillit = this.scatterDefaults.fillShapes;
        boolean markersOn = this.areMarkersOn();
        int nGrps = 1;
        int ix1 = 0;
        int iy1 = 0;
        int ix2 = 0;
        int iy2 = 0;
        int np = 0;
        int maxPoints = 0;
        int turn = 0;
        int js = this.defaultJoinStyle;
        int iBaseLine = 0;
        int type = this.getMarkerTypeInt(-1, -1L);
        int typeVarIdx = -1;
        int clrVarIdx = -1;
        int size = 10;
        double slope = 0.0;
        double intercept = this.getMinY(false);
        Object rhVal = null;
        Composite c = null;
        Stroke s = null;
        Paint oldPaint = null;
        Color clr = null;
        Color fillColor = null;
        Color mkrLblClr = this.getMarkerLabelColor();
        Font labelFont = this.getMarkerLabelFont();
        Iterator itr = null;
        PickAreaList pa = null;
        int[] indicies = null;
        if (p == null) return;
        if (this.transObj == null || this.temp == null || this.groups == null || this.dataFilter == null) {
            return;
        }
        if (mappedMkr) {
            typeVarIdx = this.dataFilter.getVariableIndex(this.markerShape);
        }
        if (this.markerColor != null && this.markerColor instanceof String && this.contRamp != null) {
            clrVarIdx = this.dataFilter.getVariableIndex(this.markerColor);
        }
        Graphics2D g = (Graphics2D)p;
        FontRenderContext fr = g.getFontRenderContext();
        oldPaint = g.getPaint();
        if (this.areMarkerShadowsOn()) {
            if (this.markerShadowSoftness < 1.0) {
                int a = (int)(255.0 * this.markerShadowSoftness);
                a = Math.min(a, 255);
                a = Math.max(a, 0);
                this.effectiveShadowColor = new Color(this.markerShadowColor.getRed(), this.markerShadowColor.getGreen(), this.markerShadowColor.getBlue(), a);
            } else {
                this.effectiveShadowColor = this.markerShadowColor;
            }
        } else {
            this.effectiveShadowColor = null;
        }
        if (this.constOnlyBands != null && this.nConstBands > 0 && this.verifyPoints(4)) {
            this.transObj.project(this.cbArea[0], this.cbArea[1], 0.0, this.temp);
            ix1 = (int)this.temp[0];
            this.transObj.project(this.cbArea[2], this.cbArea[3], 0.0, this.temp);
            ix2 = (int)this.temp[0];
            for (i = 0; i < this.nConstBands; ++i) {
                if (Double.isNaN(this.constOnlyBands[i][0]) || Double.isNaN(this.constOnlyBands[i][1])) continue;
                np = 0;
                this.transObj.project(this.cbArea[0], this.constOnlyBands[i][1], 0.0, this.temp);
                this.xPoints[np] = ix1;
                this.yPoints[np] = (int)this.temp[1];
                this.xPoints[++np] = ix2;
                this.yPoints[np] = (int)this.temp[1];
                turn = ++np;
                this.transObj.project(this.cbArea[0], this.constOnlyBands[i][0], 0.0, this.temp);
                this.xPoints[np] = ix2;
                this.yPoints[np] = (int)this.temp[1];
                this.xPoints[++np] = ix1;
                this.yPoints[np] = (int)this.temp[1];
                clr = this.disRamp == null ? null : this.disRamp.query(i, true, (int[])null);
                Band.draw(g, this.xPoints, this.yPoints, ++np, turn, this.scatterDefaults.bandOpacity, clr);
            }
        }
        if (!this.noRegression && !this.categoryIsCharacter && !this.responseIsCharacter && this.regressionLine != null && this.regressionLine.isVisible()) {
            if (this.scatterDefaults.antiAliasLines) {
                rhVal = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            x1 = this.dataMin[0];
            x2 = this.dataMax[0];
            y1 = this.getLinearRegressionY(x1);
            y2 = this.getLinearRegressionY(x2);
            if (!(Double.isNaN(x1) || Double.isNaN(x2) || Double.isNaN(y1) || Double.isNaN(y2))) {
                this.transObj.project(x1, y1, 0.0, this.temp);
                ix1 = (int)this.temp[0];
                iy1 = (int)this.temp[1];
                this.transObj.project(x2, y2, 0.0, this.temp);
                ix2 = (int)this.temp[0];
                iy2 = (int)this.temp[1];
                if (this.regressionLine.getColor() != null) {
                    g.setColor(this.regressionLine.getColor());
                }
                if (this.regressionLine.getWidth() > 1) {
                    s = g.getStroke();
                    g.setStroke(new BasicStroke(this.regressionLine.getWidth()));
                }
                g.drawLine(ix1, iy1, ix2, iy2);
                if (s != null) {
                    g.setStroke(s);
                }
                s = null;
            }
            if (rhVal != null) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rhVal);
            }
            rhVal = null;
        }
        if (this.scatterDefaults.areaFillOn && (this.xPoints == null || this.xPoints.length < 4 || this.yPoints == null || this.yPoints.length < 4)) {
            localAreaFillOn = false;
        }
        this.transObj.project(this.cbArea[0], this.cbArea[1], 0.0, this.temp);
        iBaseLine = (int)this.temp[1];
        if (this.baseLineValue != null) {
            slope = this.getBaseLineSlope();
            intercept = this.getBaseLineIntercept();
            if (slope == 0.0) {
                this.transObj.project(this.getMinX(false), intercept, 0.0, this.temp);
                iBaseLine = (int)this.temp[1];
            }
        }
        if (this.nRespVarsToShow < 2 && this.groupVariable == null || this.groups == null) {
            nGrps = 1;
            areGroups = false;
        } else {
            nGrps = this.groups.size();
            areGroups = true;
        }
        localBandPlot = this.hasBands(nGrps);
        boolean bl = joinLinesOn = this.getMaxJoinStyle(nGrps) > 0;
        if (constantSize) {
            size = ((Number)this.markerSize).intValue();
        }
        if (markersOn || joinLinesOn) {
            if (this.markerOpacity == null && this.opacity1 < 1.0) {
                c = g.getComposite();
                g.setComposite(AlphaComposite.getInstance(3, (float)this.opacity1));
            }
            if (constantSize && size < 2) {
                this.scatterDefaults.outlinesOn = false;
            }
        }
        this.projectMarkers = this.checkForProjectChanges();
        if (this.baseLineValue != null && this.baseLine != null && this.baseLine.isVisible()) {
            if (this.scatterDefaults.antiAliasLines) {
                rhVal = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            if (this.getBaseLineThickness() > 1) {
                s = g.getStroke();
                g.setStroke(new BasicStroke(this.getBaseLineThickness()));
            } else {
                s = null;
            }
            if (slope == 0.0) {
                this.transObj.project(this.cbArea[0], this.cbArea[1], 0.0, this.temp);
                x1 = (int)this.temp[0];
                this.transObj.project(this.cbArea[2], this.cbArea[3], 0.0, this.temp);
                x2 = (int)this.temp[0];
                g.drawLine((int)x1, iBaseLine, (int)x2, iBaseLine);
            } else {
                y1 = slope * this.cbArea[0] + intercept;
                y2 = slope * this.cbArea[2] + intercept;
                this.transObj.project(this.cbArea[0], y1, 0.0, this.temp);
                x1 = this.temp[0];
                y1 = this.temp[1];
                this.transObj.project(this.cbArea[2], y2, 0.0, this.temp);
                x2 = this.temp[0];
                y2 = this.temp[1];
                g.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
            }
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rhVal);
            rhVal = null;
            if (s != null) {
                g.setStroke(s);
            }
        }
        s = null;
        if (this.isBubblePlot) {
            s = g.getStroke();
            g.setStroke(new BasicStroke(this.scatterDefaults.bubbleThickness));
        }
        block24: for (int which = 0; which <= 1; ++which) {
            ScatterObject.GroupData gd;
            int iGrp;
            switch (which) {
                case 0: {
                    if (!joinLinesOn && !localBandPlot) continue block24;
                    if (this.scatterDefaults.antiAliasLines) {
                        rhVal = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    }
                    if (!localBandPlot || this.verifyPoints(maxPoints = 2 * this.getMaxGroupCount(nGrps))) break;
                    localBandPlot = false;
                    break;
                }
                case 1: {
                    if (!markersOn) continue block24;
                    if (this.isBubblePlot && this.scatterDefaults.antiAliasBubbles) {
                        rhVal = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
                        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    } else {
                        rhVal = null;
                    }
                    s = null;
                }
            }
            if (areGroups) {
                itr = this.groups.iterator();
                iGrp = 0;
            } else {
                itr = null;
                iGrp = 0;
            }
            while (!(itr == null ? this.groupMap == null || (gd = (ScatterObject.GroupData)this.groupMap.get(null)) == null : !itr.hasNext() || (gd = (ScatterObject.GroupData)itr.next()) == null)) {
                double d;
                Vector mkrList = gd.getMarkers();
                if (mkrList == null) break;
                int n = mkrList.size();
                if (!this.singleUse) {
                    pa = gd.getPickAreaList();
                    if (this.projectMarkers && pa != null) {
                        pa.clearCounts();
                    }
                }
                switch (this.catSorted) {
                    case -1: 
                    case 1: {
                        indicies = gd.getSortIndicies();
                        break;
                    }
                    default: {
                        indicies = null;
                    }
                }
                boolean localMarkersOn = gd != null ? (gd.isBand() ? false : this.isMarkerOn(iGrp)) : markersOn;
                if (itr == null && !localBandPlot) {
                    gd = null;
                }
                switch (which) {
                    case 0: {
                        clr = this.getJoinLineColor(iGrp);
                        if (clr == null) {
                            clr = gd != null ? gd.getColor() : (this.defaultJoinLine != null && this.defaultJoinLine.getColor() != null ? this.defaultJoinLine.getColor() : Color.black);
                        }
                        fillColor = localAreaFillOn && !areGroups ? (this.areaFillColor != null ? this.areaFillColor : this.getJoinLineColor(0)) : null;
                        if (this.getJoinLineThickness(iGrp) > 1) {
                            s = g.getStroke();
                            g.setStroke(new BasicStroke(this.getJoinLineThickness(iGrp)));
                            break;
                        }
                        s = null;
                        break;
                    }
                    case 1: {
                        clr = this.getMarkerColor(iGrp);
                        if (clr != null) break;
                        if (gd == null) {
                            clr = this.markerColor instanceof Color ? (Color)this.markerColor : this.defaultMarkerColor;
                            break;
                        }
                        clr = this.getGroupColor(gd.value, iGrp);
                        break;
                    }
                }
                if (clr != null) {
                    g.setColor(clr);
                    clr = null;
                }
                if (which == 0) {
                    if (localBandPlot && gd.isBand()) {
                        switch (gd.getType()) {
                            case 0: 
                            case 2: {
                                np = 0;
                                turn = 0;
                                break;
                            }
                            case 1: {
                                turn = np;
                                break;
                            }
                        }
                    }
                    if ((js = this.getJoinLineStyle(iGrp)) == 6) {
                        if (this.cardSpline == null) continue;
                        if (this.updateTangents) {
                            this.cardSpline.calculateTangentVectors(mkrList, indicies, n);
                        }
                        this.cardSpline.drawCurve(g, this.transObj, mkrList, indicies, n);
                        if (s != null) {
                            g.setStroke(s);
                        }
                        if (itr == null) break;
                        ++iGrp;
                        continue;
                    }
                }
                Marker lastMkr = null;
                for (i = 0; i < n; ++i) {
                    Marker mkr;
                    int idx;
                    switch (which) {
                        case 0: {
                            if (!localBandPlot || gd == null || gd.getType() != 1) {
                                idx = i;
                                break;
                            }
                            idx = n - i - 1;
                            break;
                        }
                        default: {
                            idx = i;
                        }
                    }
                    if (indicies != null) {
                        idx = indicies[idx];
                    }
                    if ((mkr = (Marker)mkrList.elementAt(idx)) == null) continue;
                    if (Double.isNaN(mkr.getNumericX()) || Double.isNaN(mkr.getNumericY())) {
                        if (!this.scatterDefaults.skipMiss) continue;
                        lastMkr = null;
                        continue;
                    }
                    if (which == 0 && js == 5 && slope != 0.0) {
                        this.transObj.project(mkr.getNumericX(), slope * mkr.getNumericX() + intercept, 0.0, this.temp);
                        iBaseLine = (int)this.temp[1];
                    }
                    if ((this.projectMarkers || this.dataValuesChanged) && !mkr.projectMarker(this.transObj, this.temp)) break;
                    if (!this.singleUse && (this.projectMarkers || this.dataValuesChanged) && pa != null) {
                        pa.addPoint(mkr.screenX, mkr.screenY, idx);
                    }
                    if (which == 1) {
                        if (!constantSize && !this.isBubblePlot) {
                            size = this.mapMarkerSize(mkr.getDataSize());
                        }
                        if (this.haveErrorBars && !this.errorBarsFront && !this.isBubblePlot) {
                            this.drawErrorBars(g, mkr, size);
                        }
                        if (localMarkersOn) {
                            if (mappedMkr) {
                                Object o = this.dataFilter.getValue(typeVarIdx, (long)mkr.getObsIndex());
                                type = this.getMarkerMapping(o);
                                fillit = this.getMarkerFillMapping(o);
                            }
                            if (writeURLs) {
                                didWriteURLs = this.writeURLs(mkr.getObsIndex());
                            }
                            if (clrVarIdx >= 0) {
                                d = this.getNumericValue(clrVarIdx, mkr.getObsIndex());
                                clr = this.clrRamp.queryDouble(d, this.discreteColor, null);
                            }
                            this.playIt(type, size, fillit, g, fr, labelFont, mkr, 0, 0, null, false, 0, false, false, null, 0, clr, mkrLblClr, this.markerLabelAttribs, keepPartial);
                            if (didWriteURLs) {
                                this.closeURLs();
                            }
                        }
                        if (this.haveErrorBars && this.errorBarsFront && !this.isBubblePlot) {
                            this.drawErrorBars(g, mkr, size);
                        }
                    }
                    if (which == 0 && localBandPlot && gd.isBand()) {
                        this.xPoints[np] = mkr.screenX;
                        this.yPoints[np++] = mkr.screenY;
                    } else if (which == 0) {
                        if (js == 5) {
                            this.drawSimpleLine(g, mkr, null, js, localAreaFillOn, fillColor, iBaseLine);
                        } else {
                            this.drawSimpleLine(g, lastMkr, mkr, js, localAreaFillOn, fillColor, iBaseLine);
                        }
                    }
                    lastMkr = mkr;
                }
                if (which == 0 && localBandPlot && gd != null && gd.isBand) {
                    iy1 = iBaseLine;
                    boolean bandDone = false;
                    switch (gd.getType()) {
                        default: {
                            break;
                        }
                        case 1: {
                            bandDone = true;
                            break;
                        }
                        case 3: {
                            d = gd.getBandValue();
                            if (!Double.isNaN(d)) {
                                this.transObj.project(this.cbArea[0], d, 0.0, this.temp);
                                iy1 = (int)this.temp[1];
                            }
                        }
                        case 2: {
                            if (np < 2) break;
                            turn = np;
                            this.xPoints[np] = this.xPoints[np - 1];
                            this.yPoints[np] = iy1;
                            this.xPoints[++np] = this.xPoints[0];
                            this.yPoints[np] = iy1;
                            ++np;
                            bandDone = true;
                        }
                    }
                    if (bandDone) {
                        Band.draw(g, this.xPoints, this.yPoints, np, turn, this.scatterDefaults.bandOpacity, clr);
                    }
                }
                if (s != null) {
                    g.setStroke(s);
                }
                if (itr == null) break;
                ++iGrp;
            }
            if (rhVal != null) {
                g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, rhVal);
            }
            if (s != null) {
                g.setStroke(s);
            }
            this.scatterDefaults.outlinesOn = localOutlinesOn;
        }
        if (c != null) {
            g.setComposite(c);
        }
        if (!(!this.scatterDefaults.chartBorderOn || this.cbArea == null || Double.isNaN(this.cbArea[0]) || Double.isNaN(this.cbArea[1]) || Double.isNaN(this.cbArea[2]) || Double.isNaN(this.cbArea[3]))) {
            this.transObj.project(this.cbArea[0], this.cbArea[1], 0.0, this.temp);
            ix1 = (int)this.temp[0];
            iy1 = (int)this.temp[1];
            this.transObj.project(this.cbArea[2], this.cbArea[3], 0.0, this.temp);
            ix2 = (int)this.temp[0];
            iy2 = (int)this.temp[1];
            g.setPaint(this.chartBorderColor);
            s = null;
            if (this.chartBorderLineWidth > 1 && this.borderStroke != null) {
                s = g.getStroke();
                g.setStroke(this.borderStroke);
            }
            g.drawRect(ix1, iy2, ix2 - ix1 + 1, iy1 - iy2 + 1);
            if (s != null) {
                g.setStroke(s);
            }
        }
        g.setPaint(oldPaint);
        this.redrawRequired = false;
        this.dataValuesChanged = false;
        this.updateTangents = false;
        this.projectMarkers = false;
    }

    @Override
    public void drawHighlight(Object p) {
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        int iobs = -1;
        int type = 0;
        Marker mkr = null;
        if (evt == null) {
            return;
        }
        switch (evt.type) {
            case 1: {
                this.ourDataChanged = true;
                break;
            }
            case 3: 
            case 8: {
                this.ourDataChanged = this.ourDataChanged || this.isOurVariable(evt.varStartIndex, evt.varEndIndex);
                this.dataValuesChanged = true;
                this.clearAllPickAreas();
                break;
            }
            case 9: {
                if (this.groupVariable != null) break;
            }
            case 2: {
                if (this.dataFilter == null) break;
                int first = 0;
                type = Extract.getSourceType((Object)evt.oldValue);
                if (evt.newValue == null) {
                    return;
                }
                int last = ((Number)evt.newValue).intValue() - 1;
                for (int i = first; i <= last; ++i) {
                    int idx;
                    iobs = evt.oldValue == null ? i : Extract.getInteger((Object)evt.oldValue, (int)i, (int)type);
                    if (this.singleUse ? (idx = this.binarylookup(iobs, this.markers, -1)) < 0 : (idx = this.findFirstMarkerIndex(iobs)) < 0) continue;
                    block11: for (int j = 0; j < this.nRespVarsToShow; ++j) {
                        mkr = this.getMarker(idx + j);
                        if (mkr == null) continue;
                        switch (evt.type) {
                            case 2: {
                                if (this.dataFilter.isSelected((long)iobs)) {
                                    if (this.selectedMarkers.contains(mkr)) continue block11;
                                    this.selectedMarkers.addElement(mkr);
                                    continue block11;
                                }
                                int k = this.selectedMarkers.indexOf(mkr);
                                if (k < 0) continue block11;
                                this.selectedMarkers.removeElementAt(k);
                                continue block11;
                            }
                            case 9: {
                                this.redrawRequired = true;
                            }
                        }
                    }
                }
                break;
            }
        }
    }

    @Override
    public boolean setChartBorderLineWidth(int newWidth) {
        if (!super.setChartBorderLineWidth(newWidth)) {
            return false;
        }
        this.borderStroke = new BasicStroke(this.chartBorderLineWidth);
        return true;
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        if (!super.setDataSource(source, id)) {
            return false;
        }
        if (this.selectedMarkers != null) {
            this.selectedMarkers.removeAllElements();
        }
        this.clearAllPickAreas();
        this.projectMarkers = true;
        return true;
    }

    @Override
    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        if (this.pickedMarker != null && irole == 25) {
            int idx = this.nRespVarsToShow > 1 ? this.pickedMarker.getIndex() : 0;
            return this.responseVariables.elementAt(idx);
        }
        return super.getVariable(role);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        String out = null;
        if (which != 2) {
            return super.getRoleValue(role, which);
        }
        if (role == null || this.pickedMarker == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 1: 
            case 24: {
                if (this.categoryVariable == null) break;
                out = this.getFormattedValue(this.categoryVariable, this.pickedMarker.getX());
                break;
            }
            case 17: 
            case 25: {
                int idx = this.nRespVarsToShow > 1 ? this.pickedMarker.getIndex() : 0;
                if (this.responseVariables.elementAt(idx) == null) break;
                out = this.getFormattedValue(this.responseVariables.elementAt(idx), this.pickedMarker.getY());
                break;
            }
            case 19: {
                if (this.markerSize == null || !(this.markerSize instanceof String)) break;
                out = this.getFormattedValue(this.markerSize, this.pickedMarker.getDataSize());
                break;
            }
            case 8: {
                out = this.pickedMarker.getLabel();
                break;
            }
            case 2: {
                int varIdx;
                if (this.markerColor == null || !(this.markerColor instanceof String) || this.dataFilter == null || (varIdx = this.dataFilter.getVariableIndex(this.markerColor)) < 0) break;
                out = this.getFormattedValue(this.markerColor, this.getNumericValue(varIdx, this.pickedMarker.getObsIndex()));
                break;
            }
            case 22: {
                out = this.getTipString(this.pickedMarker.getObsIndex());
                ++this.curTipValueIdx;
                break;
            }
            case 11: 
            case 52: {
                if (this.markerOpacity == null || !(this.markerOpacity instanceof String)) break;
                out = this.getFormattedValue(this.markerOpacity, this.pickedMarker.getDataOpacity());
                break;
            }
            case 18: {
                if (this.markerShape == null || !(this.markerShape instanceof String)) break;
                out = this.getFormattedValue(this.markerShape, this.dataFilter.getValue(this.markerShape, (long)this.pickedMarker.getObsIndex()));
                break;
            }
            case 6: {
                if (this.groupVariable == null || this.dataFilter == null) break;
                out = this.getFormattedValue(this.groupVariable, this.dataFilter.getValue(this.groupVariable, (long)this.pickedMarker.getObsIndex()));
            }
        }
        return out;
    }

    public long getObservationIndex(Object o) {
        if (o == null) {
            return -1L;
        }
        return ((Marker)o).getObsIndex();
    }

    @Override
    public synchronized void addURLConsumer(Object context, URLConsumerInterface consumer) {
        URLConsumer con;
        Object o;
        int i;
        int n = 0;
        if (consumer == null || this.urlConsumers == null) {
            return;
        }
        n = this.urlConsumers.size();
        for (i = 0; !(i >= n || (o = this.urlConsumers.elementAt(i)) != null && o instanceof URLConsumer && consumer.equals(con = (URLConsumer)o)); ++i) {
        }
        if (i < n) {
            return;
        }
        this.urlConsumers.addElement(new URLConsumer(context, consumer));
    }

    @Override
    public synchronized void removeURLConsumer(URLConsumerInterface consumer) {
        URLConsumer con;
        Object o;
        int i;
        int n = 0;
        if (consumer == null || this.urlConsumers == null) {
            return;
        }
        n = this.urlConsumers.size();
        for (i = 0; !(i >= n || (o = this.urlConsumers.elementAt(i)) != null && o instanceof URLConsumer && consumer.equals(con = (URLConsumer)o)); ++i) {
        }
        if (i >= n) {
            return;
        }
        this.urlConsumers.removeElementAt(i);
    }

    public void drawEditedMarkers(Graphics2D g, FontRenderContext fr, Vector markers, Point moveDistance) {
        if (markers == null) {
            return;
        }
        if (moveDistance == null) {
            return;
        }
        if (this.transObj == null) {
            return;
        }
        int type = this.getMarkerTypeInt(-1, -1L);
        int size = ((Number)this.markerSize).intValue();
        Color clr = Color.gray;
        Object o = this.getMarkerColor();
        if (o instanceof Color) {
            clr = (Color)o;
        }
        Composite save = null;
        save = g.getComposite();
        g.setComposite(AlphaComposite.getInstance(3, 0.25f));
        for (int i = 0; i < markers.size(); ++i) {
            Marker m = (Marker)markers.elementAt(i);
            int screenX = m.screenX;
            int screenY = m.screenY;
            m.screenX += moveDistance.x;
            m.screenY += moveDistance.y;
            m.draw(type, size + 2, g, fr, null, true, clr, this.scatterDefaults.outlinesOn, this.markerOutlineColor, -1, this.effectiveShadowColor, this.markerShadowSoftness, this.scatterDefaults.markerShadowOffset, null, null, this.isBubblePlot | this.simpleMarkers, !this.isBubblePlot);
            m.screenX = screenX;
            m.screenY = screenY;
        }
        g.setComposite(save);
    }

    public void moveMarkers(Vector markers, Point moveDistance) {
        if (!(this.dataFilter instanceof DataFilterUpdateInterface)) {
            return;
        }
        if (this.transObj == null) {
            return;
        }
        if (this.responseVariables == null) {
            return;
        }
        if (markers == null) {
            return;
        }
        if (moveDistance == null) {
            return;
        }
        DataFilterUpdateInterface updateInterface = (DataFilterUpdateInterface)this.dataFilter;
        for (int i = 0; i < markers.size(); ++i) {
            Marker m = (Marker)markers.elementAt(i);
            int obs = m.getObsIndex();
            int newScreenX = m.screenX + moveDistance.x;
            int newScreenY = m.screenY + moveDistance.y;
            double[] dataXY = this.transObj.unProject(newScreenX, newScreenY, 0.0, null);
            if (dataXY == null) continue;
            updateInterface.setValue((Object)new Object[]{this.categoryVariable, this.responseVariables.elementAt(0)}, (long)obs, (Object)new Double[]{new Double(dataXY[0]), new Double(dataXY[1])});
        }
    }

    class URLConsumer {
        public Object context;
        public URLConsumerInterface consumer;

        public URLConsumer(Object context, URLConsumerInterface consumer) {
            this.context = context;
            this.consumer = consumer;
        }
    }
}

