/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import com.sas.graphics.silk.interfaces.AlphaInterface;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.CustomBaseLineValueInterface;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.LineStyleInterface;
import com.sas.graphics.silk.interfaces.MarkerStyleInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.ScatterInterface;
import com.sas.graphics.silk.interfaces.TextStyleInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.scatter.Cardinal;
import com.sas.graphics.silk.scatter.PickAreaList;
import com.sas.graphics.silk.scatter.ScatterDefaults;
import com.sas.graphics.silk.util.ColorRamp;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SubstitutionPattern;
import com.sas.graphics.silk.util.TextAttrib;
import com.sas.graphics.silk.util.UniqueValueMapper;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.FontManager;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.PropertyList;
import com.sas.graphics.util.SortKeyInterface;
import com.sas.graphics.util.SortedVector;
import com.sas.graphics.util.StringCompare;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Vector;

public abstract class ScatterObject
implements GeometryInterface,
PropertyInterface,
RenderInterface,
RoleInterface,
ScatterInterface,
UpdateInterface {
    protected static final int MAX_RESP = 100;
    protected static final int CATEGORY = 0;
    protected static final int RESPONSE = 1;
    protected static final int SIZE = 2;
    protected static final int SHAPE = 3;
    protected static final int ALPHA = 4;
    protected static final int RERRLOW = 5;
    protected static final int RERRHIGH = 6;
    protected static final int GROUP = 7;
    protected static final int NSTATROLES = 7;
    protected static final String defTipText1 = "{&L[CAT,RESP,GRP,SIZE,COLOR,TYPE,OPACITY,LABEL]{&G_*DESC}{&- = }{&G_*VALUE}{&-\n}}{&RS}{&G_TIPDESC}{&- = }{&G_TIP_VALUE}{&-\n}{&RE";
    protected boolean singleUse;
    protected boolean maxGroupsExceeded;
    protected boolean invertOpacity;
    protected boolean haveErrorBars;
    protected boolean honorGraphed;
    protected boolean honorColors;
    protected boolean colorRoleToMappedDataRange;
    protected boolean dataViewported;
    protected boolean redrawRequired;
    protected boolean ourDataChanged;
    protected boolean visible;
    protected boolean rebuildRequired;
    protected boolean updateTangents;
    protected boolean discreteColor;
    protected boolean categoryIsCharacter;
    protected boolean responseIsCharacter;
    protected boolean catIsExternal;
    protected boolean respIsExternal;
    protected boolean noRegression;
    protected boolean allCatMissing;
    protected boolean allRespMissing;
    protected boolean errorBarsFront;
    protected boolean isBubblePlot;
    protected boolean simpleMarkers;
    protected int catSorted;
    protected int sizeSorted;
    protected int chartBorderLineWidth;
    protected int defaultJoinLineThickness;
    protected int nRespVarsTotal;
    protected int nRespVarsToShow;
    protected int nConstBands;
    protected int curTipVarIdx;
    protected int curTipValueIdx;
    protected int minMarkerSize;
    protected int maxMarkerSize;
    protected int coalesceStatistic;
    protected int nPoints;
    protected int selectionIndicator;
    protected int largestMarkerDrawn;
    protected int componentWidth;
    protected int componentHeight;
    protected int defaultJoinStyle;
    protected int paX;
    protected int paY;
    protected int paWidth;
    protected int paHeight;
    protected double sumX;
    protected double sumY;
    protected double sumXX;
    protected double sumXY;
    protected double rSlope;
    protected double rIntercept;
    protected double minDrawX;
    protected double minDrawY;
    protected double maxDrawX;
    protected double maxDrawY;
    protected double minMarkerDataValue;
    protected double maxMarkerDataValue;
    protected double opacity1;
    protected double opacity2;
    protected double coalesceDistance;
    protected double markerShadowSoftness;
    protected Color chartBorderColor;
    protected Color markerOutlineColor;
    protected Color areaFillColor;
    protected Color selectionColor;
    protected Color markerShadowColor;
    protected Object markerColor;
    protected Object markerOpacity;
    protected Object categoryVariable;
    protected Vector responseVariables;
    protected Object groupVariable;
    protected Object urlVariable;
    protected Object labelVariable;
    protected Object groupIndexVariable;
    protected Object markerSize;
    protected Object markerShape;
    protected Object respErrorLow;
    protected Object respErrorHigh;
    protected Object groupMin;
    protected Object groupMax;
    protected String smartNLS;
    protected String colorNLS;
    protected String growNLS;
    protected String freqNLS;
    protected String sumNLS;
    protected String meanNLS;
    protected Vector tipVariables;
    protected String userTip;
    protected LineStyleInterface regressionLine;
    protected LineStyleInterface errorBarAttribs;
    protected LineStyleInterface defaultJoinLine;
    protected LineStyleInterface baseLine;
    protected MarkerStyleInterface defaultMarkerAttrib;
    protected TextAttrib markerLabelAttribs;
    protected Image lastGlyph;
    protected int[] respIdx;
    protected int[] respSlotIdx;
    protected boolean[] respSlotIsUpper;
    protected int[] joinStyle;
    protected int[] xPoints;
    protected int[] yPoints;
    protected double[] dataMin;
    protected double[] dataMax;
    protected LineStyleInterface[] joinLineAttribs;
    protected MarkerStyleInterface[] markerAttribs;
    protected DataFilterReadInterface dataFilter;
    protected ColorInterface clrRamp;
    protected ColorInterface contRamp;
    protected ColorInterface disRamp;
    protected AlphaInterface alphaRamp;
    protected TransformInterface transObj;
    protected SortedVector typMapper;
    protected SortedVector catDiscrete;
    protected Cardinal cardSpline;
    protected PropertyList pendingProperties;
    protected ScatterDefaults scatterDefaults;
    protected SubstitutionPattern tipText;
    protected Roles roles;
    protected RoleEvent roleEvt;
    protected ResourceBundle rb;
    protected LinkedHashMap groupMap;
    protected Collection groups;
    protected Vector grpVals;
    protected Object baseLineValue;
    protected double[] cbArea;
    protected double[][] constOnlyBands;
    protected int[] markerObsLookup;
    protected Object[] catMinMax;
    protected Object[] respMinMax;
    protected Object[] catValues;
    protected Object[] respValues;
    protected Color defaultMarkerColor = new Color(100, 100, 175);
    protected Integer defaultMarkerShape = new Integer(5);
    protected int[] defaultShapes = new int[]{1, 2, 3, 4, 5, 6, 1, 2, 3, 5, 6};
    protected boolean[] shapeFills = new boolean[]{true, true, true, true, true, true, false, false, false, false, false};
    protected String[] shapeList = null;
    protected String[] englishShapeList = null;
    protected String[] joinList = null;
    protected String[] englishJoinList = null;

    public ScatterObject(Object dataObject, boolean singleUseIn) {
        this.roleEvt = new RoleEvent();
        this.roles = new Roles();
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.scatter.silk_scatter_NLS");
        this.smartNLS = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Selection_Smart.txt", (String)"Smart");
        this.colorNLS = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Selection_Color.txt", (String)"Color");
        this.growNLS = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Selection_Grow.txt", (String)"Grow");
        this.freqNLS = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Coalesce_Frequency.txt", (String)"Frequency");
        this.sumNLS = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Coalesce_Sum.txt", (String)"Sum");
        this.meanNLS = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Coalesce_Mean.txt", (String)"Mean");
        this.shapeList = new String[ScatterInterface.shapeObjList.length];
        this.shapeList[0] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Dot.txt", (String)"Dot");
        this.shapeList[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Circle.txt", (String)"Circle");
        this.shapeList[2] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Cross.txt", (String)"Cross");
        this.shapeList[3] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Diamond.txt", (String)"Diamond");
        this.shapeList[4] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Plus.txt", (String)"Plus");
        this.shapeList[5] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Square.txt", (String)"Square");
        this.shapeList[6] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Triangle.txt", (String)"Triangle");
        this.shapeList[7] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Image.txt", (String)"Image");
        this.englishShapeList = new String[ScatterInterface.shapeObjList.length];
        this.englishShapeList[0] = "Dot";
        this.englishShapeList[1] = "Circle";
        this.englishShapeList[2] = "Cross";
        this.englishShapeList[3] = "Diamond";
        this.englishShapeList[4] = "Plus";
        this.englishShapeList[5] = "Square";
        this.englishShapeList[6] = "Triangle";
        this.englishShapeList[7] = "Image";
        this.joinList = new String[ScatterInterface.joinListValues.length];
        this.joinList[0] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_None.txt", (String)"None");
        this.joinList[1] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_Simple.txt", (String)"Simple");
        this.joinList[2] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_Step_Left.txt", (String)"Step Left");
        this.joinList[3] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_Step_Center.txt", (String)"Step Center");
        this.joinList[4] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_Step_Right.txt", (String)"Step Right");
        this.joinList[5] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_Needle.txt", (String)"Needle");
        this.joinList[6] = ResourceLoader.getResourceString((Object)this.rb, (String)"ScatterObject.Join_Spline.txt", (String)"Spline");
        this.englishJoinList = new String[ScatterInterface.joinListValues.length];
        this.englishJoinList[0] = "None";
        this.englishJoinList[1] = "Simple";
        this.englishJoinList[2] = "Step Left";
        this.englishJoinList[3] = "Step Center";
        this.englishJoinList[4] = "Step Right";
        this.englishJoinList[5] = "Needle";
        this.englishJoinList[6] = "Spline";
        this.rb = null;
        this.scatterDefaults = new ScatterDefaults();
        this.singleUse = singleUseIn;
        this.paHeight = 0;
        this.paWidth = 0;
        this.paY = 0;
        this.paX = 0;
        this.groupMap = new LinkedHashMap();
        this.groups = null;
        this.selectionColor = new Color(255, 197, 0);
        this.cardSpline = null;
        this.maxGroupsExceeded = false;
        this.isBubblePlot = false;
        this.updateTangents = false;
        this.haveErrorBars = false;
        this.errorBarsFront = true;
        this.markerLabelAttribs = null;
        this.curTipVarIdx = 0;
        this.curTipValueIdx = 0;
        this.tipVariables = null;
        this.joinLineAttribs = null;
        this.defaultJoinLine = null;
        this.markerAttribs = null;
        this.defaultMarkerAttrib = null;
        this.baseLine = null;
        this.catValues = null;
        this.respValues = null;
        this.groupMax = null;
        this.groupMin = null;
        this.markerShadowColor = this.scatterDefaults.markerShadowColor == null ? Color.black : this.scatterDefaults.markerShadowColor;
        this.setMarkerShadowSoftness(this.scatterDefaults.markerShadowSoftness);
        this.nRespVarsTotal = 0;
        this.nRespVarsToShow = 0;
        this.nConstBands = 0;
        this.largestMarkerDrawn = 0;
        this.allCatMissing = true;
        this.allRespMissing = true;
        this.pendingProperties = null;
        this.colorRoleToMappedDataRange = true;
        this.dataViewported = false;
        this.catSorted = 0;
        this.sizeSorted = 0;
        this.redrawRequired = false;
        this.visible = true;
        this.discreteColor = false;
        this.noRegression = true;
        this.coalesceStatistic = 1;
        this.coalesceDistance = Double.NaN;
        this.userTip = null;
        this.tipText = new SubstitutionPattern();
        this.nPoints = 0;
        this.sumXY = 0.0;
        this.sumXX = 0.0;
        this.sumY = 0.0;
        this.sumX = 0.0;
        this.rIntercept = Double.NaN;
        this.rSlope = Double.NaN;
        this.componentHeight = 0;
        this.componentWidth = 0;
        this.regressionLine = null;
        this.selectionIndicator = 0;
        this.dataMin = new double[7];
        this.dataMax = new double[7];
        this.minMarkerSize = this.scatterDefaults.defaultMinMarkerSize;
        this.maxMarkerSize = this.scatterDefaults.defaultMaxMarkerSize;
        this.minMarkerDataValue = Double.NaN;
        this.maxMarkerDataValue = Double.NaN;
        this.cbArea = new double[4];
        if (this.cbArea != null) {
            this.cbArea[1] = this.cbArea[2] = this.cbArea[3];
            this.cbArea[0] = this.cbArea[2];
        }
        this.opacity1 = 1.0;
        this.opacity2 = Double.NaN;
        this.markerSize = new Integer(this.scatterDefaults.defaultMarkerSize);
        this.markerShape = this.defaultMarkerShape;
        this.lastGlyph = null;
        this.chartBorderLineWidth = 2;
        this.defaultJoinLineThickness = this.scatterDefaults.joinLineThickness;
        this.chartBorderColor = Color.black;
        this.markerOutlineColor = Color.black;
        this.areaFillColor = null;
        this.markerColor = this.defaultMarkerColor;
        this.invertOpacity = false;
        this.markerOpacity = null;
        this.respErrorLow = null;
        this.respErrorHigh = null;
        this.errorBarAttribs = null;
        this.disRamp = new ColorRamp();
        this.contRamp = new ColorRamp();
        this.clrRamp = null;
        this.alphaRamp = null;
        this.categoryVariable = null;
        this.responseVariables = new Vector();
        this.respIdx = new int[100];
        this.respSlotIdx = new int[100];
        this.respSlotIsUpper = new boolean[100];
        this.constOnlyBands = new double[100][2];
        this.defaultJoinStyle = this.scatterDefaults.joinStyle;
        this.joinStyle = null;
        this.yPoints = null;
        this.xPoints = null;
        this.groupVariable = null;
        this.urlVariable = null;
        this.labelVariable = null;
        this.groupIndexVariable = null;
        this.transObj = null;
        this.catMinMax = null;
        this.respMinMax = null;
        this.catDiscrete = null;
        this.typMapper = null;
        this.markerObsLookup = null;
        this.grpVals = null;
        this.rebuildRequired = false;
        this.setDataSource(dataObject);
    }

    protected abstract boolean buildSetup();

    protected abstract boolean buildCleanup();

    protected abstract void buildError();

    protected abstract int onMarker(GroupData var1, Image var2, Object var3, Object var4, Object var5, int var6, double var7, double var9, double var11, String var13, double var14, double var16);

    protected abstract void onText(String var1, double var2, double var4, double var6, int var8, int var9, Object var10);

    protected abstract void finalizeMarkers(UniqueValueMapper var1, UniqueValueMapper var2);

    protected abstract boolean sortMarkers(Vector var1, int[] var2, int var3, int var4);

    protected boolean removeResponseRole(Object variableId, int irole) {
        BandData bd;
        Object var;
        int i;
        boolean found = false;
        int n = 0;
        Object oldVar = null;
        if (this.responseVariables == null || (n = this.responseVariables.size()) <= 0) {
            return false;
        }
        variableId = this.dataFilter == null ? variableId : this.dataFilter.getExactVariableId(variableId);
        for (i = n - 1; i >= 0; --i) {
            var = this.responseVariables.elementAt(i);
            if (var == null) continue;
            switch (irole) {
                case 54: 
                case 56: 
                case 57: {
                    if (!(var instanceof BandData)) break;
                    bd = (BandData)var;
                    if (!(irole != 54 && irole != 56 || bd.upper == null || variableId != null && !variableId.equals(bd.upper))) {
                        if (oldVar == null) {
                            oldVar = bd.upper;
                        }
                        bd.upper = null;
                        if (variableId != null) {
                            found = true;
                        }
                    }
                    if (!(irole != 54 && irole != 57 || bd.lower == null || variableId != null && !variableId.equals(bd.lower))) {
                        if (oldVar == null) {
                            oldVar = bd.lower;
                        }
                        bd.lower = null;
                        if (variableId != null) {
                            found = true;
                        }
                    }
                    if (bd.upper != null || bd.lower != null) break;
                    this.responseVariables.removeElementAt(i);
                    break;
                }
                case 17: 
                case 25: {
                    if (var instanceof BandData || variableId != null && !variableId.equals(var)) break;
                    if (oldVar == null) {
                        oldVar = var;
                    }
                    this.responseVariables.removeElementAt(i);
                    if (variableId == null) break;
                    found = true;
                }
            }
            if (found) break;
        }
        this.nRespVarsTotal = 0;
        n = this.responseVariables == null ? 0 : this.responseVariables.size();
        for (i = 0; i < n; ++i) {
            var = this.responseVariables.elementAt(i);
            if (var == null) continue;
            if (var instanceof BandData) {
                bd = (BandData)var;
                if (bd.upper != null) {
                    this.respSlotIdx[this.nRespVarsTotal] = i;
                    this.respSlotIsUpper[this.nRespVarsTotal++] = true;
                }
                if (bd.lower == null) continue;
                this.respSlotIdx[this.nRespVarsTotal] = i;
                this.respSlotIsUpper[this.nRespVarsTotal++] = false;
                continue;
            }
            this.respSlotIdx[this.nRespVarsTotal] = i;
            this.respSlotIsUpper[this.nRespVarsTotal++] = false;
        }
        this.dataViewported = false;
        this.dataMax[1] = Double.NaN;
        this.dataMin[1] = Double.NaN;
        this.rebuildRequired = true;
        this.ourDataChanged = true;
        this.nRespVarsToShow = this.nRespVarsTotal;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 3;
            this.roleEvt.role = 25;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = null;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    public boolean removeBandRole(Object id, int irole) {
        boolean status = true;
        int type = Extract.getSourceType((Object)id);
        int n = Extract.getNumberItems((Object)id, (int)type);
        for (int i = 0; i < n; ++i) {
            Object o = Extract.getObject((Object)id, (int)i, (int)type);
            if (o == null) continue;
            status &= this.removeResponseRole(o, irole);
        }
        return status;
    }

    protected Object getVariableId(Object variableId, boolean allowIndex) {
        Object out = variableId;
        if (allowIndex && variableId != null && variableId instanceof Number) {
            if (this.dataFilter == null) {
                return null;
            }
            int nVars = this.dataFilter.getNumberVariables();
            int i = ((Number)variableId).intValue();
            if (i < 0 || i >= nVars) {
                return null;
            }
            out = this.dataFilter.getVariableId(i);
        }
        return out;
    }

    protected GroupData getGroupData(Object key) {
        if (this.groupMap == null) {
            return null;
        }
        return (GroupData)this.groupMap.get(key);
    }

    protected Color getGroupColor(Object value, int idx) {
        Color c = null;
        GroupData grpData = null;
        MarkerStyleInterface ms = this.getMarkers(idx);
        if (ms != null) {
            c = ms.getColor();
        }
        if (c == null && (grpData = this.getGroupData(value)) != null) {
            c = grpData.getColor();
        }
        return c;
    }

    protected Color getGroupColor(int idx) {
        MarkerStyleInterface ms = this.getMarkers(idx);
        if (ms != null && ms.getColor() != null) {
            return ms.getColor();
        }
        if (this.clrRamp == null || idx < 0) {
            return null;
        }
        return this.clrRamp.query(idx, true, (int[])null);
    }

    protected boolean isMarkerOn(int grpIdx) {
        boolean on = this.scatterDefaults.markersOn;
        if (this.markerAttribs == null || grpIdx >= this.markerAttribs.length) {
            return on;
        }
        if (grpIdx >= 0) {
            if (this.markerAttribs[grpIdx] == null) {
                return on;
            }
            return this.markerAttribs[grpIdx].isVisible();
        }
        for (int i = 0; i < this.markerAttribs.length; ++i) {
            if (this.markerAttribs[i] == null || !this.markerAttribs[i].isVisible()) continue;
            return true;
        }
        return on;
    }

    protected boolean hasGroups(boolean andValid) {
        boolean areValid = true;
        if (andValid) {
            areValid = !this.maxGroupsExceeded;
        }
        return this.groupVariable != null && this.groupMap != null && areValid;
    }

    protected void clearAllPickAreas() {
        if (this.groups == null) {
            return;
        }
        Iterator itr = this.groups.iterator();
        if (itr == null) {
            return;
        }
        while (itr.hasNext()) {
            PickAreaList pa;
            GroupData gd = (GroupData)itr.next();
            if (gd == null || (pa = gd.getPickAreaList()) == null) continue;
            pa.clearCounts();
        }
    }

    protected boolean isEqual(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    protected boolean verifyVariableId(Object id, boolean numericOnly) {
        if (id == null || this.dataFilter == null) {
            return false;
        }
        if (!this.dataFilter.verifyVariable(id)) {
            return false;
        }
        return !numericOnly || !this.isVariableIdCharacter(id);
    }

    protected int getMarkerTypeInt(int ivar, long iobs) {
        Object value = null;
        if (iobs >= 0L) {
            value = this.dataFilter.getValue(ivar, iobs);
        }
        return this.getMarkerMapping(value);
    }

    protected boolean isVariableIdCharacter(Object id) {
        if (id == null || this.dataFilter == null) {
            return false;
        }
        return !this.dataFilter.isNumericVariable(id);
    }

    protected void updateMinMax(Object value, int index) {
        if (value == null) {
            return;
        }
        if (index == 7) {
            if (value instanceof Number) {
                this.updateMinMax(((Number)value).doubleValue(), index);
            } else if (value instanceof String) {
                if (this.groupMin == null) {
                    this.groupMin = value;
                } else if (StringCompare.compareTo((String)((String)value), (String)this.groupMin.toString()) < 0) {
                    this.groupMin = value;
                }
                if (this.groupMax == null) {
                    this.groupMax = value;
                } else if (StringCompare.compareTo((String)((String)value), (String)this.groupMax.toString()) > 0) {
                    this.groupMax = value;
                }
            }
            return;
        }
        if (!(value instanceof Number)) {
            return;
        }
        this.updateMinMax(((Number)value).doubleValue(), index);
    }

    protected double getBaseLineSlope() {
        if (this.baseLineValue == null || !(this.baseLineValue instanceof double[])) {
            return 0.0;
        }
        return ((double[])this.baseLineValue)[0];
    }

    protected double getBaseLineIntercept() {
        if (this.baseLineValue == null) {
            return this.getMinY(false);
        }
        if (this.baseLineValue instanceof Number) {
            return ((Number)this.baseLineValue).doubleValue();
        }
        if (this.baseLineValue instanceof double[]) {
            return ((double[])this.baseLineValue)[1];
        }
        if (this.baseLineValue instanceof Object[] && ((Object[])this.baseLineValue)[0] != null) {
            CustomBaseLineValueInterface bvi = (CustomBaseLineValueInterface)((Object[])this.baseLineValue)[0];
            Object o = bvi.getCustomBaseLineValue(((Object[])this.baseLineValue)[1], 0);
            if (o == null || !(o instanceof Number)) {
                return this.getMinY(false);
            }
            return ((Number)o).doubleValue();
        }
        return Double.NaN;
    }

    protected void updateMinMax(double value, double offset, int index) {
        if (Double.isNaN(value) || Double.isNaN(offset)) {
            return;
        }
        if (Double.isNaN(this.dataMin[index])) {
            this.dataMin[index] = value - offset;
        } else if (value - offset < this.dataMin[index]) {
            this.dataMin[index] = value - offset;
        }
        if (Double.isNaN(this.dataMax[index])) {
            this.dataMax[index] = value + offset;
        } else if (value + offset > this.dataMax[index]) {
            this.dataMax[index] = value + offset;
        }
    }

    protected void updateMinMax(double value, int index) {
        if (Double.isNaN(value)) {
            return;
        }
        if (index == 7) {
            if (this.groupMin == null) {
                this.groupMin = new Double(value);
            } else if (value < ((Number)this.groupMin).doubleValue()) {
                this.groupMin = new Double(value);
            }
            if (this.groupMax == null) {
                this.groupMax = new Double(value);
            } else if (value > ((Number)this.groupMax).doubleValue()) {
                this.groupMax = new Double(value);
            }
            return;
        }
        if (Double.isNaN(this.dataMin[index])) {
            this.dataMin[index] = value;
        } else if (value < this.dataMin[index]) {
            this.dataMin[index] = value;
        }
        if (Double.isNaN(this.dataMax[index])) {
            this.dataMax[index] = value;
        } else if (value > this.dataMax[index]) {
            this.dataMax[index] = value;
        }
    }

    protected Color getMarkerLabelColor() {
        if (this.markerLabelAttribs == null) {
            return this.scatterDefaults.markerLabelColor;
        }
        return this.markerLabelAttribs.getColor();
    }

    protected Font getMarkerLabelFont() {
        if (this.markerLabelAttribs == null) {
            return null;
        }
        return this.markerLabelAttribs.getFont();
    }

    protected boolean areMarkersConstantSize() {
        return this.markerSize != null && this.markerSize instanceof Number && !this.scatterDefaults.coalesceOn;
    }

    protected int mapMarkerSize(double v) {
        double min = this.dataMin[2];
        double max = this.dataMax[2];
        if (Double.isNaN(v)) {
            return this.minMarkerSize;
        }
        if (!Double.isNaN(this.minMarkerDataValue)) {
            min = this.minMarkerDataValue;
        }
        if (!Double.isNaN(this.maxMarkerDataValue)) {
            max = this.maxMarkerDataValue;
        }
        if (min == max) {
            return this.minMarkerSize + this.maxMarkerSize >> 1;
        }
        int out = (int)Math.round((double)(this.maxMarkerSize - this.minMarkerSize) * ((v - min) / (max - min)) + (double)this.minMarkerSize);
        if (out < this.minMarkerSize) {
            out = this.minMarkerSize;
        } else if (out > this.maxMarkerSize) {
            out = this.maxMarkerSize;
        }
        return out;
    }

    protected boolean isMappedMarker(Object mkr) {
        return mkr != null && mkr instanceof String;
    }

    protected int getMarkerMapping(Object value) {
        int idx = -1;
        if (this.typMapper == null || value == null || (idx = this.typMapper.indexOf(value)) < 0) {
            if (this.markerShape != null && this.markerShape instanceof Number) {
                return ((Number)this.markerShape).intValue();
            }
            if (this.defaultMarkerShape != null) {
                return this.defaultMarkerShape;
            }
            return 5;
        }
        int n = this.defaultShapes.length;
        return this.defaultShapes[idx % n];
    }

    protected int getGroupIndexValue(int varIdx, long iobs) {
        if (this.dataFilter == null || varIdx < 0) {
            return -1;
        }
        double d = this.dataFilter.getNumericValue(varIdx, iobs);
        if (Double.isNaN(d)) {
            return -1;
        }
        return (int)Math.round(d);
    }

    protected boolean getMarkerFillMapping(Object value) {
        int idx = -1;
        if (this.typMapper == null || value == null || (idx = this.typMapper.indexOf(value)) < 0) {
            return true;
        }
        int n = this.shapeFills.length;
        return this.shapeFills[idx % n];
    }

    protected boolean isMarkerShapeAGlyph() {
        return this.markerShape != null && this.markerShape instanceof Image;
    }

    protected String getFormattedValue(Object var, double v) {
        return this.getFormattedValue(var, new Double(v));
    }

    protected String getFormattedValue(Object var, Object v) {
        if (v == null) {
            return "";
        }
        if (this.dataFilter == null) {
            return v.toString();
        }
        return this.dataFilter.getFormattedValue(var, v, null);
    }

    protected double getNumericValue(int varIdx, long indx) {
        double d = this.dataFilter.getNumericValue(varIdx, indx);
        return d;
    }

    protected boolean isBandVariable(int idx) {
        if (this.respSlotIdx == null || this.responseVariables == null || this.respSlotIsUpper == null || idx < 0 || idx >= this.nRespVarsTotal) {
            return false;
        }
        int slotIdx = this.respSlotIdx[idx];
        if (slotIdx < 0 || slotIdx >= this.responseVariables.size()) {
            return false;
        }
        Object o = this.responseVariables.elementAt(slotIdx);
        if (o == null) {
            return false;
        }
        return o instanceof BandData;
    }

    protected int getFirstEmptyConstBand(boolean findEmptyLower) {
        int n;
        int n2 = n = this.constOnlyBands == null ? 0 : this.nConstBands;
        if (this.constOnlyBands == null) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            if (findEmptyLower && Double.isNaN(this.constOnlyBands[i][1])) {
                return i;
            }
            if (findEmptyLower || !Double.isNaN(this.constOnlyBands[i][0])) continue;
            return i;
        }
        return -1;
    }

    protected int getFirstEmptyBand(boolean findEmptyLower) {
        int n;
        int n2 = n = this.responseVariables == null ? 0 : this.responseVariables.size();
        if (this.responseVariables == null) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            Object o = this.responseVariables.elementAt(i);
            if (o == null || !(o instanceof BandData)) continue;
            BandData bd = (BandData)o;
            if (findEmptyLower && bd.lower == null) {
                return i;
            }
            if (findEmptyLower || bd.upper != null) continue;
            return i;
        }
        return -1;
    }

    protected BandData getBandData(int idx) {
        Object o = null;
        if (this.responseVariables == null || idx < 0 || idx >= this.responseVariables.size()) {
            return null;
        }
        Object e = this.responseVariables.elementAt(idx);
        o = e;
        if (e == null || !(o instanceof BandData)) {
            return null;
        }
        return o;
    }

    protected int isOurResponseVariable(Object id) {
        int n;
        int n2 = n = this.responseVariables == null ? 0 : this.responseVariables.size();
        if (id == null || this.responseVariables == null || this.dataFilter == null) {
            return -1;
        }
        if ((id = this.dataFilter.getExactVariableId(id)) == null) {
            return -1;
        }
        for (int i = 0; i < n; ++i) {
            Object o = this.responseVariables.elementAt(i);
            if (o == null) continue;
            if (o instanceof BandData) {
                BandData bd = (BandData)o;
                if (bd.upper != null && id.equals(bd.upper)) {
                    return i;
                }
                if (bd.lower == null || !id.equals(bd.lower)) continue;
                return i;
            }
            if (!id.equals(o)) continue;
            return i;
        }
        return -1;
    }

    protected boolean isOurVariable(int firstVar, int lastVar) {
        for (int i = firstVar; i <= lastVar; ++i) {
            Object varId = this.dataFilter.getVariableId(i);
            if (varId == null || !varId.equals(this.categoryVariable) && this.isOurResponseVariable(varId) <= -1 && !varId.equals(this.markerColor) && !varId.equals(this.markerSize) && !varId.equals(this.markerShape) && !varId.equals(this.markerOpacity) && !varId.equals(this.labelVariable)) continue;
            return true;
        }
        return false;
    }

    protected boolean verifyPoints(int maxCount) {
        if (maxCount <= 0) {
            return false;
        }
        if (this.xPoints == null || this.xPoints.length < maxCount) {
            this.xPoints = new int[maxCount];
        }
        if (this.yPoints == null || this.yPoints.length < maxCount) {
            this.yPoints = new int[maxCount];
        }
        return this.xPoints != null && this.xPoints.length >= maxCount && this.yPoints != null && this.yPoints.length >= maxCount;
    }

    protected void initializeObsLookup(int n) {
        if (this.markerObsLookup == null || this.markerObsLookup.length < n && n > 0) {
            this.markerObsLookup = new int[n];
        }
        if (this.markerObsLookup == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            this.markerObsLookup[i] = -1;
        }
    }

    protected int findFirstMarkerIndex(int obsidx) {
        if (this.markerObsLookup == null || obsidx < 0 || obsidx >= this.markerObsLookup.length) {
            return -1;
        }
        return this.markerObsLookup[obsidx];
    }

    protected void setMarkerObsIndex(int mkridx, int obsidx) {
        if (this.markerObsLookup == null || obsidx < 0 || obsidx >= this.markerObsLookup.length) {
            return;
        }
        this.markerObsLookup[obsidx] = mkridx;
    }

    protected String getTipString(int obs) {
        if (this.tipVariables == null || this.curTipValueIdx >= this.tipVariables.size() || this.dataFilter == null || obs < 0 || obs >= this.dataFilter.getNumberObservations(this.tipVariables.elementAt(this.curTipValueIdx))) {
            return null;
        }
        Object o = this.dataFilter.getValue(this.tipVariables.elementAt(this.curTipValueIdx), (long)obs);
        if (o == null) {
            return null;
        }
        String s = this.dataFilter.getFormattedValue(this.tipVariables.elementAt(this.curTipValueIdx), o, null);
        return s.trim();
    }

    protected void updateRegressionValues(Object xobj, Object yobj) {
        if (this.categoryIsCharacter || this.responseIsCharacter) {
            return;
        }
        if (xobj == null || yobj == null || !(xobj instanceof Number) || !(yobj instanceof Number)) {
            return;
        }
        double x = ((Number)xobj).doubleValue();
        double y = ((Number)yobj).doubleValue();
        if (Double.isInfinite(x) || Double.isNaN(x) || Double.isInfinite(y) || Double.isNaN(y)) {
            return;
        }
        ++this.nPoints;
        this.sumX += x;
        this.sumXX += x * x;
        this.sumY += y;
        this.sumXY += x * y;
    }

    protected void setupLinearRegression() {
        double denom = (double)this.nPoints * this.sumXX - this.sumX * this.sumX;
        if (this.nPoints == 0 || denom == 0.0) {
            this.rSlope = Double.NaN;
            this.rIntercept = Double.NaN;
            this.noRegression = true;
        }
        this.rSlope = ((double)this.nPoints * this.sumXY - this.sumX * this.sumY) / denom;
        this.rIntercept = (this.sumY - this.rSlope * this.sumX) / (double)this.nPoints;
        this.noRegression = false;
    }

    protected double getLinearRegressionY(double x) {
        if (this.noRegression || Double.isNaN(x) || Double.isInfinite(x)) {
            return Double.NaN;
        }
        return this.rSlope * x + this.rIntercept;
    }

    protected boolean growMarkerAttribs(int newSize) {
        int i;
        int nCopy = 0;
        if (this.markerAttribs != null) {
            nCopy = this.markerAttribs.length;
        }
        if (nCopy >= newSize) {
            return true;
        }
        MarkerAttrib[] ma = new MarkerAttrib[newSize];
        if (ma == null) {
            return false;
        }
        for (i = 0; i < nCopy; ++i) {
            ma[i] = this.markerAttribs[i];
        }
        for (i = nCopy; i < ma.length; ++i) {
            ma[i] = null;
        }
        this.markerAttribs = ma;
        return true;
    }

    protected boolean growLineAttribs(int newSize) {
        int i;
        int nCopy = 0;
        if (this.joinLineAttribs != null) {
            nCopy = this.joinLineAttribs.length;
        }
        if (nCopy >= newSize) {
            return true;
        }
        LineAttrib[] ls = new LineAttrib[newSize];
        if (ls == null) {
            return false;
        }
        for (i = 0; i < nCopy; ++i) {
            ls[i] = this.joinLineAttribs[i];
        }
        for (i = nCopy; i < ls.length; ++i) {
            ls[i] = null;
        }
        this.joinLineAttribs = ls;
        return true;
    }

    protected int getJoinLineStyle(int idx) {
        if (this.joinStyle == null || idx < 0 || idx >= this.joinStyle.length || this.joinStyle[idx] < 0) {
            return this.defaultJoinStyle;
        }
        return this.joinStyle[idx];
    }

    protected LineStyleInterface getJoinLine(int which) {
        LineStyleInterface ls = null;
        switch (which) {
            case -1: {
                ls = this.defaultJoinLine;
                break;
            }
            default: {
                if (this.joinLineAttribs == null || which < 0 || this.joinLineAttribs.length <= which) break;
                ls = this.joinLineAttribs[which];
            }
        }
        return ls;
    }

    protected boolean setJoinLine(Object attrib, int which) {
        int end;
        LineStyleInterface ls = null;
        switch (which) {
            case -2: {
                if (this.joinLineAttribs == null) {
                    return false;
                }
                int start = 0;
                end = this.joinLineAttribs.length - 1;
                break;
            }
            case -1: {
                if (this.defaultJoinLine == null) {
                    this.defaultJoinLine = new LineAttrib(true, Color.black, this.defaultJoinLineThickness);
                }
                end = -1;
                int start = -1;
                break;
            }
            default: {
                if (which < 0) {
                    return false;
                }
                if (!this.growLineAttribs(which + 1)) {
                    return false;
                }
                int start = end = which;
            }
        }
        for (int i = start; i <= end; ++i) {
            if (i == -1) {
                if (attrib == null) {
                    this.defaultJoinLine = null;
                    continue;
                }
                ls = this.defaultJoinLine;
            } else {
                if (attrib == null) {
                    this.joinLineAttribs[i] = null;
                    continue;
                }
                ls = this.joinLineAttribs[i] == null ? (this.joinLineAttribs[i] = new LineAttrib(true, null, this.defaultJoinLineThickness)) : this.joinLineAttribs[i];
            }
            if (ls == null) continue;
            if (attrib instanceof Color || attrib instanceof String) {
                ls.setColor(attrib);
                continue;
            }
            if (attrib instanceof Number) {
                ls.setWidth(((Number)attrib).intValue());
                continue;
            }
            if (attrib instanceof Boolean) {
                ls.setVisible((Boolean)attrib);
                continue;
            }
            if (!(attrib instanceof LineStyleInterface)) continue;
            ls = this.joinLineAttribs[i] = new LineAttrib((LineStyleInterface)attrib);
        }
        this.redrawRequired = true;
        return true;
    }

    protected boolean growJoinLineStyles(int nGrps) {
        int i;
        int n = 0;
        int maxStyle = -1;
        int[] temp = null;
        if (this.joinStyle != null) {
            n = this.joinStyle.length;
        }
        if (this.joinStyle != null && this.joinStyle.length >= nGrps) {
            return true;
        }
        int nCopy = n;
        n = Math.max(nGrps, 1);
        temp = new int[n];
        if (temp == null) {
            return false;
        }
        for (i = 0; i < nCopy; ++i) {
            if (this.joinStyle[i] > maxStyle) {
                maxStyle = this.joinStyle[i];
            }
            temp[i] = this.joinStyle[i];
        }
        for (i = nCopy; i < n; ++i) {
            temp[i] = maxStyle;
        }
        this.joinStyle = temp;
        return true;
    }

    protected MarkerStyleInterface getMarkers(int idx) {
        MarkerStyleInterface ms = null;
        switch (idx) {
            case -1: {
                ms = this.defaultMarkerAttrib;
                break;
            }
            default: {
                if (this.markerAttribs == null || idx < 0 || this.markerAttribs.length <= idx) break;
                ms = this.markerAttribs[idx];
            }
        }
        return ms;
    }

    protected boolean setMarkers(int idx, Object attrib) {
        int end;
        MarkerStyleInterface ms = null;
        switch (idx) {
            case -2: {
                if (this.markerAttribs == null) {
                    return false;
                }
                int start = 0;
                end = this.markerAttribs.length - 1;
                break;
            }
            case -1: {
                if (this.defaultMarkerAttrib == null) {
                    this.defaultMarkerAttrib = new MarkerAttrib(true, null);
                }
                end = -1;
                int start = -1;
                break;
            }
            default: {
                if (idx < 0) {
                    return false;
                }
                if (!this.growMarkerAttribs(idx + 1)) {
                    return false;
                }
                int start = end = idx;
            }
        }
        for (int i = start; i <= end; ++i) {
            if (i == -1) {
                if (attrib == null) {
                    this.defaultMarkerAttrib = null;
                    continue;
                }
                ms = this.defaultMarkerAttrib;
            } else {
                if (attrib == null) {
                    this.markerAttribs[i] = null;
                    continue;
                }
                if (this.markerAttribs[i] == null) {
                    ms = this.markerAttribs[i] = new MarkerAttrib(true, null);
                    ms.setShape(new Integer(this.getStandardMarkerShape(this.getMarkerMapping(null))));
                } else {
                    ms = this.markerAttribs[i];
                }
            }
            if (ms == null) continue;
            if (attrib instanceof Boolean) {
                ms.setVisible((Boolean)attrib);
                continue;
            }
            if (attrib instanceof Color || attrib instanceof String) {
                ms.setColor(attrib);
                continue;
            }
            if (attrib instanceof MarkerStyleInterface) {
                if (i == -1) {
                    this.defaultMarkerAttrib = new MarkerAttrib((MarkerStyleInterface)attrib);
                    continue;
                }
                this.markerAttribs[i] = new MarkerAttrib((MarkerStyleInterface)attrib);
                continue;
            }
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    public MarkerStyleInterface[] getMarkers(Object role, Object[] values, boolean fillWithDefaults) {
        int n = 0;
        MarkerStyleInterface[] ms = null;
        if (role == null) {
            return null;
        }
        if (values == null && (values = this.getValues(role)) == null) {
            return null;
        }
        n = values.length;
        if (n <= 0) {
            return null;
        }
        ms = new MarkerStyleInterface[n];
        if (ms == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                return null;
            }
            case 6: 
        }
        for (int i = 0; i < n; ++i) {
            ms[i] = this.getMarkers(i);
            if (ms[i] != null) {
                if (ms[i].getColor() != null || !fillWithDefaults) continue;
                ms[i] = new MarkerAttrib(ms[i]);
                ms[i].setColor(this.getGroupColor(values[i], i));
                continue;
            }
            if (!fillWithDefaults) continue;
            Color c = this.getGroupColor(values[i], i);
            boolean on = this.isMarkerOn(i);
            ms[i] = new MarkerAttrib(on, c);
            if (ms[i] == null) continue;
            ms[i].setShape(new Integer(this.getStandardMarkerShape(this.getMarkerMapping(null))));
        }
        return ms;
    }

    public LineStyleInterface[] getLines(Object role, Object[] values, boolean fillWithDefaults) {
        int n = 0;
        LineStyleInterface[] ls = null;
        if (role == null) {
            return null;
        }
        if (values == null && (values = this.getValues(role)) == null) {
            return null;
        }
        n = values.length;
        if (n <= 0) {
            return null;
        }
        ls = new LineStyleInterface[n];
        if (ls == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                return null;
            }
            case 6: 
        }
        for (int i = 0; i < n; ++i) {
            ls[i] = fillWithDefaults ? new LineAttrib(this.getJoinLineStyle(i) > 0, this.getJoinLineColor(i), this.defaultJoinLineThickness) : null;
            GroupData gd = this.getGroupData(values[i]);
            if (gd == null) continue;
            if (this.getJoinLineStyle(gd.getIndex()) < 1) {
                if (ls[i] == null) continue;
                ls[i].setVisible(false);
                continue;
            }
            LineStyleInterface la = this.getJoinLine(gd.getIndex());
            if (la != null) {
                ls[i] = la;
                continue;
            }
            if (!fillWithDefaults) continue;
            Color c = this.getGroupColor(values[i], i);
            ls[i] = new LineAttrib(true, c, this.defaultJoinLineThickness);
        }
        return ls;
    }

    public LineStyleInterface[] getLineStyles() {
        if (this.joinLineAttribs == null) {
            if (this.getJoinLineStyle(-1) <= 0) {
                return null;
            }
            return new LineStyleInterface[]{this.defaultJoinLine};
        }
        return this.joinLineAttribs;
    }

    public MarkerStyleInterface[] getMarkerStyles() {
        if (!this.areMarkersOn()) {
            return null;
        }
        if (this.markerAttribs == null) {
            if (this.defaultMarkerAttrib != null) {
                return new MarkerStyleInterface[]{this.defaultMarkerAttrib};
            }
            Color c = this.markerColor instanceof Color ? (Color)this.markerColor : this.defaultMarkerColor;
            MarkerAttrib ms = new MarkerAttrib(true, c);
            ms.setShape(new Integer(this.getStandardMarkerShape(this.markerShape)));
            ms.setFilled(this.isMarkerFilled());
            return new MarkerStyleInterface[]{ms};
        }
        return this.markerAttribs;
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color c) {
        this.selectionColor = c;
    }

    public boolean areAllMissing() {
        return (this.allCatMissing || this.allRespMissing) && this.nConstBands <= 0;
    }

    public boolean areMaxGroupsExceeded() {
        return this.maxGroupsExceeded;
    }

    public double getMinX(boolean fullrange) {
        if (fullrange || !this.dataViewported) {
            return this.dataMin[0];
        }
        return this.minDrawX;
    }

    public double getMinY(boolean fullrange) {
        double d = this.dataMin[1];
        if (fullrange || !this.dataViewported) {
            if (!Double.isNaN(this.dataMin[5])) {
                d = Math.min(d, this.dataMin[5]);
            }
            if (!Double.isNaN(this.dataMin[6])) {
                d = Math.min(d, this.dataMin[6]);
            }
            return d;
        }
        return this.minDrawY;
    }

    public double getMaxX(boolean fullrange) {
        if (fullrange || !this.dataViewported) {
            return this.dataMax[0];
        }
        return this.maxDrawX;
    }

    public double getMaxY(boolean fullrange) {
        double d = this.dataMax[1];
        if (fullrange || !this.dataViewported) {
            if (!Double.isNaN(this.dataMax[5])) {
                d = Math.max(d, this.dataMax[5]);
            }
            if (!Double.isNaN(this.dataMax[6])) {
                d = Math.max(d, this.dataMax[6]);
            }
            return d;
        }
        return this.maxDrawY;
    }

    public SortedVector getDiscreteMapper(Object var) {
        if (var == null || this.categoryVariable == null) {
            return null;
        }
        String s1 = var.toString();
        String s2 = this.categoryVariable.toString();
        if (s1 != null && s2 != null && s1.equalsIgnoreCase(s2)) {
            return this.catDiscrete;
        }
        return null;
    }

    public boolean getDataChanged() {
        return this.ourDataChanged;
    }

    public void setDataChanged(boolean changed) {
        this.ourDataChanged = changed;
    }

    public boolean isRedrawRequired() {
        return this.redrawRequired;
    }

    public void setRedrawRequired(boolean redraw) {
        this.redrawRequired = redraw;
    }

    public void setRebuildRequired(boolean rebuild) {
        this.rebuildRequired = rebuild;
    }

    public double[] getChartBorderArea() {
        return this.cbArea;
    }

    public void setChartBorderArea(double minx, double miny, double maxx, double maxy) {
        if (this.cbArea == null && (this.cbArea = new double[4]) == null) {
            return;
        }
        this.cbArea[0] = minx;
        this.cbArea[1] = miny;
        this.cbArea[2] = maxx;
        this.cbArea[3] = maxy;
    }

    public int getLargestMarkerDrawn() {
        if (this.isBubblePlot) {
            return 0;
        }
        return this.largestMarkerDrawn;
    }

    protected boolean verifySortedOrder(int sorted) {
        switch (sorted) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    protected boolean verifyCategory(Object id) {
        return this.verifyVariableId(id, false);
    }

    protected boolean verifyTip(Object id, boolean allowPattern) {
        if (id != null && !this.verifyVariableId(id, false)) {
            return allowPattern && id != null && id instanceof String;
        }
        return true;
    }

    protected boolean verifyGroup(Object id) {
        return id == null || this.verifyVariableId(id, false);
    }

    protected boolean verifyURL(Object id) {
        if (this.dataFilter == null) {
            return false;
        }
        if (id != null && !this.verifyVariableId(id, false)) {
            return false;
        }
        return !this.dataFilter.isNumericVariable(id);
    }

    protected boolean verifyMarkerSize(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Number) {
            if (((Number)value).intValue() <= 0) {
                return false;
            }
        } else if (value instanceof String) {
            if (!this.verifyVariableId(value, true)) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected boolean verifyMarkerColor(Object value) {
        if (value == null || value instanceof Color) {
            return true;
        }
        if (value instanceof String) {
            return this.verifyVariableId(value, true) || ColorParse.getColorFromString((String)((String)value)) != null;
        }
        return false;
    }

    protected boolean verifyMarkerOpacity(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            if (!this.verifyVariableId(value, true)) {
                return false;
            }
        } else if (value instanceof Number) {
            double d1 = (Double)value;
            if (Double.isInfinite(d1) || Double.isNaN(d1) || d1 < 0.0 || d1 > 1.0) {
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean verifyMarkerShape(Object value) {
        String s = null;
        if (value == null) {
            return false;
        }
        if (value instanceof String) {
            int i;
            int n;
            s = (String)value;
            if (this.verifyVariableId(s, false)) {
                return true;
            }
            if (this.shapeList == null && this.englishShapeList == null) return false;
            if (this.shapeList != null) {
                n = this.shapeList.length;
                for (i = 0; i < n; ++i) {
                    if (!s.equalsIgnoreCase(this.shapeList[i])) continue;
                    return true;
                }
            }
            if (this.englishShapeList == null) return false;
            n = this.englishShapeList.length;
            for (i = 0; i < n; ++i) {
                if (!s.equalsIgnoreCase(this.englishShapeList[i])) continue;
                return true;
            }
            return false;
        } else {
            int i;
            if (value instanceof Image) {
                return true;
            }
            if (!(value instanceof Number) || (i = ((Number)value).intValue()) < 0 || i > 7) return false;
            return true;
        }
    }

    protected double getCoalesceRange() {
        double max;
        double min;
        if (Double.isNaN(this.dataMin[1]) || Double.isNaN(this.dataMax[1])) {
            min = this.dataMin[0];
            max = this.dataMax[0];
        } else if (Double.isNaN(this.dataMin[0]) || Double.isNaN(this.dataMax[0])) {
            min = this.dataMin[1];
            max = this.dataMax[1];
        } else if (this.dataMax[0] - this.dataMin[0] < this.dataMax[1] - this.dataMin[1]) {
            min = this.dataMin[1];
            max = this.dataMax[1];
        } else {
            min = this.dataMin[0];
            max = this.dataMax[0];
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            return Double.NaN;
        }
        return max - min;
    }

    protected Object[] getCurrentShapeList() {
        int i;
        boolean constant = this.areMarkersConstantSize();
        int j = 0;
        int count = 0;
        int len = this.shapeList.length;
        if (this.lastGlyph == null) {
            --len;
        }
        if (constant) {
            count = len;
        } else {
            for (i = 0; i < len; ++i) {
                if (!this.isSizableMarker(ScatterInterface.shapeObjList[i])) continue;
                ++count;
            }
        }
        Object[] out = new Object[len];
        if (out == null) {
            return this.shapeList;
        }
        for (i = 0; i < len; ++i) {
            if (!constant && !this.isSizableMarker(ScatterInterface.shapeObjList[i])) continue;
            out[j++] = new SILKNumber(ScatterInterface.shapeObjList[i], this.shapeList[i], this.englishShapeList[i]);
        }
        return out;
    }

    protected Object fetchProperty(int id) {
        Object out = null;
        if (this.isPropertyPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        switch (id) {
            case 2070: {
                out = new Boolean(true);
                break;
            }
            case 2071: {
                out = new Boolean(true);
                break;
            }
            case 2068: {
                if (!this.areMarkersOn()) break;
                MarkerStyleInterface ms = this.getMarkers(-1);
                if (ms == null) {
                    Color c = this.markerColor instanceof Color ? (Color)this.markerColor : this.defaultMarkerColor;
                    ms = new MarkerAttrib(true, c);
                    ms.setShape(new Integer(this.getStandardMarkerShape(this.markerShape)));
                    ms.setFilled(this.isMarkerFilled());
                }
                out = ms;
                break;
            }
            case 2069: {
                if (this.getJoinLineStyle(-1) <= 0) break;
                out = this.getJoinLine(-1);
                break;
            }
            case 2066: {
                out = this.getBaseLine();
                break;
            }
            case 2065: {
                out = this.getBaseLineValue();
                break;
            }
            case 2064: {
                out = new Boolean(this.scatterDefaults.skipMiss);
                break;
            }
            case 2063: {
                out = new Boolean(this.singleUse);
                break;
            }
            case 2062: {
                out = new Boolean(this.isBubbleStylePlot());
                break;
            }
            case 2001: {
                out = this.getSortOrder(RoleInterface.ROLE_X);
                break;
            }
            case 2061: {
                out = new Integer(this.getSortAlgorithm());
                break;
            }
            case 2002: {
                out = this.getCategory();
                break;
            }
            case 2004: {
                out = this.getTip();
                break;
            }
            case 2005: {
                out = this.getGroup();
                break;
            }
            case 2006: {
                out = this.getMarkerSize();
                break;
            }
            case 2016: {
                out = this.getMarkerGlyph();
                break;
            }
            case 2007: {
                out = new Boolean(this.areMarkersAutoSized());
                break;
            }
            case 2051: {
                out = new Boolean(this.scatterDefaults.alwaysShowSelectedMarkers);
                break;
            }
            case 2053: {
                out = new Integer(this.selectionIndicator);
                break;
            }
            case 2052: {
                out = this.getSelectionIndicator();
                break;
            }
            case 2036: {
                out = new Boolean(this.areMarkersOn());
                break;
            }
            case 2018: {
                out = new Boolean(this.areMarkerOutlinesOn());
                break;
            }
            case 2033: {
                Object o = this.isPropertyPending(2015) ? this.fetchProperty(2015) : this.getMarkerShape();
                out = new Boolean(this.isSizableMarker(o));
                break;
            }
            case 2034: {
                Object o = this.isPropertyPending(2015) ? this.fetchProperty(2015) : this.getMarkerShape();
                out = new Boolean(this.isFillableMarker(o));
                break;
            }
            case 2035: {
                Object o = this.isPropertyPending(2015) ? this.fetchProperty(2015) : this.getMarkerShape();
                out = new Boolean(this.isOutlinedMarker(o));
                break;
            }
            case 2008: {
                out = new Integer(this.getMinimumMarkerSize());
                break;
            }
            case 2009: {
                out = new Integer(this.getMaximumMarkerSize());
                break;
            }
            case 2010: {
                out = new Double(this.getMinimumMarkerDataValue());
                break;
            }
            case 2011: {
                out = new Double(this.getMaximumMarkerDataValue());
                break;
            }
            case 2013: {
                out = this.getMarkerColor();
                break;
            }
            case 2014: {
                out = this.getMarkerOpacity();
                break;
            }
            case 2015: {
                out = this.getMarkerShapeString();
                break;
            }
            case 2043: {
                out = new Boolean(this.isMappedMarker(this.markerShape));
                break;
            }
            case 2017: {
                out = new Boolean(this.isMarkerFilled());
                break;
            }
            case 2020: {
                out = new Integer(this.getJoinLineStyle(null));
                break;
            }
            case 2019: {
                out = this.getMarkerOutlineColor();
                break;
            }
            case 2021: {
                out = this.getJoinLineColor();
                break;
            }
            case 2022: {
                out = new Integer(this.getJoinLineThickness());
                break;
            }
            case 2023: {
                out = new Boolean(this.isAreaFillOn());
                break;
            }
            case 2024: {
                if (this.areaFillColor == null) {
                    out = this.getPropertyValue(2021);
                    break;
                }
                out = this.getAreaFillColor();
                break;
            }
            case 2037: {
                out = this.getCurrentShapeList();
                break;
            }
            case 2044: {
                if (this.dataFilter != null && this.dataFilter.getNumberObservations(-1) > this.scatterDefaults.maxSplineCount) {
                    int n;
                    if (this.joinList == null || this.joinList.length <= 1 || (out = new String[n = this.joinList.length - 1]) == null) break;
                    for (int i = 0; i < n; ++i) {
                        ((String[])out)[i] = this.joinList[i];
                    }
                    break;
                }
                out = this.joinList;
                break;
            }
            case 2025: {
                out = new Boolean(this.isChartBorderOn());
                break;
            }
            case 2026: {
                out = this.getChartBorderColor();
                break;
            }
            case 2027: {
                out = new Integer(this.getChartBorderLineWidth());
                break;
            }
            case 2028: {
                out = this.getColorRamp();
                break;
            }
            case 2029: 
            case 2030: {
                out = this.getColorRamp(id == 2029);
                break;
            }
            case 2031: {
                out = this.getAlphaRamp();
                break;
            }
            case 2038: {
                out = new Boolean(this.isCoalesceOn());
                break;
            }
            case 2039: {
                out = new Double(this.getCoalesceDistance());
                break;
            }
            case 2041: {
                out = new Integer(this.coalesceStatistic);
                break;
            }
            case 2040: {
                out = this.getCoalesceStatistic();
                break;
            }
            case 2042: {
                out = new Double(this.getCoalesceRange());
                break;
            }
            case 2049: {
                out = new Boolean(this.categoryIsCharacter);
                break;
            }
            case 2050: {
                out = new Boolean(this.responseIsCharacter);
                break;
            }
            case 2045: {
                out = this.getLinearRegressionLine();
                break;
            }
            case 2046: {
                LineStyleInterface ls = this.getLinearRegressionLine();
                if (ls == null) break;
                out = new Boolean(ls.isVisible());
                break;
            }
            case 2047: {
                LineStyleInterface ls = this.getLinearRegressionLine();
                if (ls == null) break;
                out = ls.getColor();
                break;
            }
            case 2048: {
                LineStyleInterface ls = this.getLinearRegressionLine();
                if (ls == null) break;
                out = new Integer(ls.getWidth());
                break;
            }
            case 2054: {
                out = new Boolean(this.areMarkerShadowsOn());
                break;
            }
            case 2055: {
                out = this.getMarkerShadowColor();
                break;
            }
            case 2056: {
                out = new Double(this.getMarkerShadowSoftness());
                break;
            }
            case 2057: {
                out = new Integer(this.getMarkerShadowOffset());
                break;
            }
            case 2058: {
                out = new Integer(this.nRespVarsTotal);
            }
        }
        return out;
    }

    protected boolean handleProperty(int id, Object value, boolean execute, boolean verify) {
        if (!execute && this.pendingProperties == null && (this.pendingProperties = new PropertyList()) == null) {
            return false;
        }
        switch (id) {
            case 2070: 
            case 2071: {
                return verify;
            }
            case 2033: 
            case 2034: 
            case 2035: 
            case 2037: 
            case 2043: 
            case 2044: 
            case 2049: 
            case 2050: 
            case 2058: 
            case 2062: 
            case 2068: 
            case 2069: {
                return verify;
            }
            case 2066: {
                if (verify) {
                    return true;
                }
                if (!execute) break;
                this.setBaseLine(value);
                break;
            }
            case 2065: {
                if (verify) {
                    return true;
                }
                if (!execute) break;
                this.setBaseLineValue(value);
                break;
            }
            case 2064: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setSkipMiss((Boolean)value);
                break;
            }
            case 2063: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.singleUse = (Boolean)value;
                break;
            }
            case 2001: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                this.setSortOrder(RoleInterface.ROLE_X, value);
                break;
            }
            case 2061: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setSortAlgorithm(((Number)value).intValue());
                break;
            }
            case 2002: {
                if (verify) {
                    return true;
                }
                if (!this.verifyCategory(value)) {
                    return false;
                }
                if (!execute) break;
                this.setCategory(value);
                break;
            }
            case 2004: {
                if (verify) {
                    return true;
                }
                if (!this.verifyTip(value, true)) {
                    return false;
                }
                if (!execute) break;
                this.setTip(value);
                break;
            }
            case 2005: {
                if (verify) {
                    return true;
                }
                if (!this.verifyGroup(value)) {
                    return false;
                }
                if (!execute) break;
                this.setGroup(value);
                break;
            }
            case 2006: {
                if (verify) {
                    return true;
                }
                if (!this.verifyMarkerSize(value)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerSize(value);
                break;
            }
            case 2016: {
                if (verify) {
                    return true;
                }
                if (value != null && !(value instanceof Image)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerShape(value);
                break;
            }
            case 2007: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setAutoSizeMarkers((Boolean)value);
                break;
            }
            case 2051: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setAlwaysShowSelectedMarkers((Boolean)value);
                break;
            }
            case 2052: 
            case 2053: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                this.setSelectionIndicator(value);
                break;
            }
            case 2036: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkersOn((Boolean)value);
                break;
            }
            case 2018: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerOutlinesOn((Boolean)value);
                break;
            }
            case 2008: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setMinimumMarkerSize(((Number)value).intValue());
                break;
            }
            case 2009: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setMaximumMarkerSize(((Number)value).intValue());
                break;
            }
            case 2010: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (execute) {
                    this.setMinimumMarkerDataValue(((Number)value).doubleValue());
                }
            }
            case 2011: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setMaximumMarkerDataValue(((Number)value).doubleValue());
                break;
            }
            case 2013: {
                if (verify) {
                    return true;
                }
                if (!this.verifyMarkerColor(value)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerColor(value);
                break;
            }
            case 2014: {
                if (verify) {
                    return true;
                }
                if (!this.verifyMarkerOpacity(value)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerOpacity(value);
                break;
            }
            case 2015: {
                if (verify) {
                    return true;
                }
                if (!this.verifyMarkerShape(value)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerShape(value);
                break;
            }
            case 2017: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerFilled((Boolean)value);
                break;
            }
            case 2019: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!(value instanceof Color) && !(value instanceof String)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerOutlineColor(value);
                break;
            }
            case 2020: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof String) && !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setJoinLineStyle(value);
                break;
            }
            case 2021: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!(value instanceof Color) && !(value instanceof String)) {
                    return false;
                }
                if (!execute) break;
                this.setJoinLineColor(value);
                break;
            }
            case 2022: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                int intval = ((Number)value).intValue();
                if (intval < 0 || intval > 10) {
                    return false;
                }
                if (!execute) break;
                this.setJoinLineThickness(intval);
                break;
            }
            case 2023: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setAreaFillOn((Boolean)value);
                break;
            }
            case 2024: {
                if (verify) {
                    return true;
                }
                if (!this.verifyAreaFillColor(value)) {
                    return false;
                }
                if (!execute) break;
                this.setAreaFillColor(value);
                break;
            }
            case 2025: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setChartBorderOn((Boolean)value);
                break;
            }
            case 2026: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!(value instanceof Color) && !(value instanceof String)) {
                    return false;
                }
                if (!execute) break;
                this.setChartBorderColor(value);
                break;
            }
            case 2027: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setChartBorderLineWidth(((Number)value).intValue());
                break;
            }
            case 2028: 
            case 2029: 
            case 2030: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof ColorInterface)) {
                    return false;
                }
                if (!execute) break;
                if (id == 2028) {
                    this.setColorRamp(value);
                    break;
                }
                this.setColorRamp(value, id == 2029);
                break;
            }
            case 2031: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof AlphaInterface)) {
                    return false;
                }
                if (!execute) break;
                this.setAlphaRamp(value);
                break;
            }
            case 2038: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setCoalesceOn((Boolean)value);
                break;
            }
            case 2039: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setCoalesceDistance(((Number)value).doubleValue());
                break;
            }
            case 2040: 
            case 2041: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof String) && !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setCoalesceStatistic(value);
                break;
            }
            case 2045: 
            case 2046: 
            case 2047: 
            case 2048: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                this.setLinearRegressionLine(value);
                break;
            }
            case 2054: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Boolean)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerShadowsOn((Boolean)value);
                break;
            }
            case 2055: {
                if (verify) {
                    return true;
                }
                if (value == null) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerShadowColor(value);
                break;
            }
            case 2056: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (!execute) break;
                this.setMarkerShadowSoftness(((Number)value).doubleValue());
                break;
            }
            case 2057: {
                if (verify) {
                    return true;
                }
                if (value == null || !(value instanceof Number)) {
                    return false;
                }
                if (execute) {
                    this.setMarkerShadowOffset(((Number)value).intValue());
                }
            }
            default: {
                return false;
            }
        }
        if (!execute) {
            this.pendingProperties.store(id, value);
        }
        return true;
    }

    protected int getJoinLineStyleIntValue(Object style) {
        int js;
        block6: {
            block13: {
                block4: {
                    block12: {
                        String s;
                        block11: {
                            block10: {
                                block9: {
                                    block8: {
                                        block7: {
                                            block5: {
                                                js = -1;
                                                if (style == null) {
                                                    return -1;
                                                }
                                                if (!(style instanceof String)) break block4;
                                                s = (String)style;
                                                if (!s.equalsIgnoreCase(this.joinList[0]) && !s.equalsIgnoreCase(this.englishJoinList[0])) break block5;
                                                js = 0;
                                                break block6;
                                            }
                                            if (!s.equalsIgnoreCase(this.joinList[1]) && !s.equalsIgnoreCase(this.englishJoinList[1])) break block7;
                                            js = 1;
                                            break block6;
                                        }
                                        if (!s.equalsIgnoreCase(this.joinList[2]) && !s.equalsIgnoreCase(this.englishJoinList[2])) break block8;
                                        js = 2;
                                        break block6;
                                    }
                                    if (!s.equalsIgnoreCase(this.joinList[3]) && !s.equalsIgnoreCase(this.englishJoinList[3])) break block9;
                                    js = 3;
                                    break block6;
                                }
                                if (!s.equalsIgnoreCase(this.joinList[4]) && !s.equalsIgnoreCase(this.englishJoinList[4])) break block10;
                                js = 4;
                                break block6;
                            }
                            if (!s.equalsIgnoreCase(this.joinList[5]) && !s.equalsIgnoreCase(this.englishJoinList[5])) break block11;
                            js = 5;
                            break block6;
                        }
                        if (!s.equalsIgnoreCase(this.joinList[6]) && !s.equalsIgnoreCase(this.englishJoinList[6])) break block12;
                        js = 6;
                        break block6;
                    }
                    return -1;
                }
                if (!(style instanceof Number)) break block13;
                switch (((Number)style).intValue()) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        js = ((Number)style).intValue();
                        break block6;
                    }
                    default: {
                        return -1;
                    }
                }
            }
            return -1;
        }
        return js;
    }

    protected int getJoinLineStyleIdIndex(Object id) {
        int idx = -1;
        if (id == null) {
            idx = 0;
        } else if (id instanceof Number) {
            idx = ((Number)id).intValue();
        } else if (id instanceof String) {
            idx = this.isOurResponseVariable(id);
        } else {
            return -1;
        }
        return idx;
    }

    public Object[] getLabels(Object role) {
        int n = 0;
        Iterator itr = null;
        Object[] out = null;
        if (this.getRoleIntValue(role) != 6) {
            return null;
        }
        if (this.nRespVarsToShow < 2 || !this.scatterDefaults.multipleResponseUseLabels || this.groups == null || (itr = this.groups.iterator()) == null) {
            return null;
        }
        Vector<Object> v = new Vector<Object>();
        if (v == null) {
            return null;
        }
        while (itr.hasNext()) {
            Object o;
            GroupData grpData = (GroupData)itr.next();
            if (grpData == null || (o = grpData.getLabel()) == null) continue;
            v.addElement(o);
        }
        n = v.size();
        if (n <= 0) {
            return null;
        }
        out = new Object[n];
        if (out == null) {
            return null;
        }
        v.copyInto(out);
        return out;
    }

    @Override
    public Object getTransformObject() {
        return this.transObj;
    }

    @Override
    public boolean setTransformObject(Object transIn) {
        if (transIn == null || !(transIn instanceof TransformInterface)) {
            return false;
        }
        this.transObj = (TransformInterface)transIn;
        return true;
    }

    @Override
    public double[] getBoundingBox() {
        double[] out = new double[6];
        if (out == null || this.dataMin == null || this.dataMax == null) {
            return null;
        }
        if (this.dataViewported) {
            out[0] = this.minDrawX;
            out[1] = this.minDrawY;
            out[3] = this.maxDrawX;
            out[4] = this.maxDrawY;
        } else {
            this.minDrawX = out[0] = this.dataMin[0];
            this.minDrawY = out[1] = this.dataMin[1];
            if (!Double.isNaN(this.dataMin[5])) {
                this.minDrawY = Math.min(out[1], this.dataMin[5]);
            }
            if (!Double.isNaN(this.dataMin[6])) {
                this.minDrawY = Math.min(out[1], this.dataMin[6]);
            }
            this.maxDrawX = out[3] = this.dataMax[0];
            this.maxDrawY = out[4] = this.dataMax[1];
            if (!Double.isNaN(this.dataMax[5])) {
                this.maxDrawY = out[4] = Math.max(out[4], this.dataMax[5]);
            }
            if (!Double.isNaN(this.dataMax[6])) {
                this.maxDrawY = out[4] = Math.max(out[4], this.dataMax[6]);
            }
        }
        out[2] = 0.0;
        out[5] = 0.0;
        return out;
    }

    @Override
    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        return false;
    }

    @Override
    public Rectangle getScreenArea() {
        return null;
    }

    @Override
    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired || this.ourDataChanged;
    }

    @Override
    public boolean build(Object bldPtr) {
        Iterator itr;
        int j;
        Object o;
        boolean dataChanged;
        int i;
        boolean mappedMarker = this.isMappedMarker(this.markerShape);
        boolean invert = this.invertOpacity;
        boolean doRegress = this.regressionLine != null && this.regressionLine.isVisible();
        int grpVarIdx = -1;
        int mkrSizeIdx = -1;
        int lblVarIdx = -1;
        int mkrOpacityIdx = -1;
        int shapeVarIdx = -1;
        int grpIdxVarIdx = -1;
        int isSorted = this.catSorted;
        int curMkrIdx = 0;
        int errLowIdx = -1;
        int errHighIdx = -1;
        int nGroupsFound = 0;
        int nRespVarsToProcess = 0;
        double opacity = 1.0;
        double d2 = Double.NaN;
        double d = Double.NaN;
        double dataSize = Double.NaN;
        double errLow = Double.NaN;
        double errHigh = Double.NaN;
        double alphaLow = Double.NaN;
        double alphaHigh = Double.NaN;
        String labelValue = null;
        Object grpValue = null;
        Object typValue = null;
        Color c = null;
        Image img = null;
        GroupData grpData = null;
        UniqueValueMapper catMapper = null;
        UniqueValueMapper respMapper = null;
        this.allRespMissing = true;
        this.allCatMissing = true;
        if (this.dataFilter == null) {
            return false;
        }
        if (this.categoryIsCharacter) {
            catMapper = new UniqueValueMapper();
            if (catMapper == null) {
                return false;
            }
            if (this.catIsExternal && this.catValues != null) {
                for (i = 0; i < this.catValues.length; ++i) {
                    catMapper.addValue(this.catValues[i]);
                }
            }
        } else if (!this.catIsExternal) {
            this.catValues = null;
        }
        if (this.responseIsCharacter) {
            respMapper = new UniqueValueMapper();
            if (respMapper == null) {
                return false;
            }
            if (this.respIsExternal && this.respValues != null) {
                for (i = 0; i < this.respValues.length; ++i) {
                    respMapper.addValue(this.respValues[i]);
                }
            }
        } else if (!this.respIsExternal) {
            this.respValues = null;
        }
        if (bldPtr != null && bldPtr instanceof Boolean) {
            dataChanged = (Boolean)bldPtr;
        } else if (this.ourDataChanged) {
            dataChanged = true;
        } else {
            boolean bl = dataChanged = Double.isNaN(this.dataMin[0]) || Double.isNaN(this.dataMin[1]);
        }
        if (dataChanged) {
            this.dataMax[0] = Double.NaN;
            this.dataMin[0] = Double.NaN;
            this.dataMax[1] = Double.NaN;
            this.dataMin[1] = Double.NaN;
            this.dataMax[2] = Double.NaN;
            this.dataMin[2] = Double.NaN;
        }
        this.dataMin[6] = Double.NaN;
        this.dataMax[5] = Double.NaN;
        this.dataMin[6] = Double.NaN;
        this.dataMin[5] = Double.NaN;
        int catIdx = this.dataFilter.getVariableIndex(this.categoryVariable);
        if (catIdx < 0) {
            return false;
        }
        if (this.respErrorLow != null) {
            errLowIdx = this.dataFilter.getVariableIndex(this.respErrorLow);
        }
        if (this.respErrorHigh != null) {
            errHighIdx = this.dataFilter.getVariableIndex(this.respErrorHigh);
        }
        for (i = 0; i < this.nRespVarsTotal && i < this.nRespVarsToShow; ++i) {
            o = this.getResponse(i);
            this.respIdx[i] = this.dataFilter.getVariableIndex(o);
            if (this.respIdx[i] < 0) continue;
            ++nRespVarsToProcess;
        }
        this.maxGroupsExceeded = false;
        if (this.groupMap != null) {
            this.groupMap.clear();
        }
        this.groupMax = null;
        this.groupMin = null;
        if (this.nRespVarsToShow > 1 && this.groupMap != null) {
            for (i = 0; i < this.responseVariables.size(); ++i) {
                Object o2;
                o = this.responseVariables.elementAt(i);
                if (o instanceof BandData) {
                    int bandType;
                    BandData bd = (BandData)o;
                    if (bd.upper != null) {
                        if (bd.upper instanceof Number) {
                            o = null;
                            d = ((Number)bd.upper).doubleValue();
                        } else {
                            o = bd.upper;
                            d = Double.NaN;
                        }
                        o2 = this.scatterDefaults.multipleResponseUseLabels ? this.dataFilter.getVariableDescription(bd.upper) : null;
                        bandType = !Double.isNaN(d) ? 3 : (bd.lower == null ? 2 : 0);
                        this.groupMap.put(o, new GroupData(true, bandType, i, d, o, o2, null));
                        this.updateMinMax(o, 7);
                    }
                    if (bd.lower == null) continue;
                    if (bd.lower instanceof Number) {
                        o = null;
                        d = ((Number)bd.lower).doubleValue();
                    } else {
                        o = bd.lower;
                        d = Double.NaN;
                    }
                    o2 = this.scatterDefaults.multipleResponseUseLabels ? this.dataFilter.getVariableDescription(bd.lower) : null;
                    bandType = !Double.isNaN(d) ? 3 : (bd.upper == null ? 2 : 1);
                    this.groupMap.put(o, new GroupData(true, bandType, i, d, o, o2, null));
                    this.updateMinMax(o, 7);
                    continue;
                }
                o2 = this.scatterDefaults.multipleResponseUseLabels ? this.dataFilter.getVariableDescription(o) : null;
                this.groupMap.put(o, new GroupData(false, -1, i, Double.NaN, o, o2, null));
                this.updateMinMax(o, 7);
            }
        } else if (this.hasGroups(true)) {
            grpVarIdx = this.dataFilter.getVariableIndex(this.groupVariable);
            if (this.groupIndexVariable != null) {
                grpIdxVarIdx = this.dataFilter.getVariableIndex(this.groupIndexVariable);
            }
        } else if (this.groupMap != null) {
            if (this.isBandVariable(0)) {
                grpData = new GroupData(true, 2, -1, Double.NaN, null, null, null);
                this.groupMap.put(null, grpData);
            } else {
                grpData = new GroupData(null, null);
                this.groupMap.put(null, grpData);
            }
        }
        if (mappedMarker) {
            if (this.typMapper == null) {
                this.typMapper = new SortedVector();
            }
            if (this.typMapper != null) {
                shapeVarIdx = this.dataFilter.getVariableIndex(this.markerShape);
                this.typMapper.removeAllElements();
            }
        }
        if (!this.buildSetup()) {
            this.buildError();
            return false;
        }
        this.noRegression = true;
        this.nPoints = 0;
        this.sumXY = 0.0;
        this.sumXX = 0.0;
        this.sumY = 0.0;
        this.sumX = 0.0;
        if (this.markerSize != null && this.markerSize instanceof String) {
            mkrSizeIdx = this.dataFilter.getVariableIndex(this.markerSize);
        }
        if (this.markerOpacity instanceof String) {
            mkrOpacityIdx = this.dataFilter.getVariableIndex(this.markerOpacity);
        }
        if (mkrOpacityIdx >= 0 && this.alphaRamp != null) {
            alphaLow = this.alphaRamp.getMinAlpha();
            alphaHigh = this.alphaRamp.getMaxAlpha();
            if (invert && (Double.isNaN(alphaLow) || Double.isNaN(alphaHigh))) {
                invert = false;
            }
        }
        if (this.labelVariable != null) {
            lblVarIdx = this.dataFilter.getVariableIndex(this.labelVariable);
        }
        if (this.isMarkerShapeAGlyph()) {
            img = (Image)this.markerShape;
        }
        int count = this.dataFilter.getNumberObservations(this.categoryVariable);
        if (!this.singleUse) {
            this.initializeObsLookup(count);
        }
        if (this.categoryIsCharacter && dataChanged && !this.catIsExternal) {
            catMapper.removeAllValues();
        } else if (this.catDiscrete != null && dataChanged) {
            this.catDiscrete.removeAllElements();
        }
        if (this.responseIsCharacter && dataChanged && !this.respIsExternal) {
            respMapper.removeAllValues();
        }
        for (i = 0; i < count; ++i) {
            if (this.honorGraphed && !this.dataFilter.isGraphed((long)i)) continue;
            Object catValue = this.dataFilter.getValue(catIdx, (long)i);
            double x = this.isBubblePlot && catValue != null && catValue instanceof Number ? ((Number)catValue).doubleValue() : Double.NaN;
            if (mkrSizeIdx >= 0) {
                dataSize = this.getNumericValue(mkrSizeIdx, i);
                if (dataChanged && !this.scatterDefaults.coalesceOn) {
                    this.updateMinMax(dataSize, 2);
                }
            }
            if (grpVarIdx >= 0 && !this.maxGroupsExceeded && (grpValue = this.dataFilter.getValue(grpVarIdx, (long)i)) != null) {
                grpData = this.getGroupData(grpValue);
                if (grpIdxVarIdx >= 0 && (grpData == null || grpData.getColor() == null)) {
                    j = this.getGroupIndexValue(grpIdxVarIdx, i);
                    if (j >= 0) {
                        c = this.clrRamp.query(j, true, (int[])null);
                    }
                } else {
                    c = null;
                }
                if (grpData == null) {
                    grpData = new GroupData(false, -1, nGroupsFound, Double.NaN, grpValue, null, c);
                    this.groupMap.put(grpValue, grpData);
                    this.updateMinMax(grpValue, 7);
                }
                if ((nGroupsFound = this.groupMap.size()) > this.scatterDefaults.maxGroups) {
                    this.maxGroupsExceeded = true;
                }
            }
            if (errHighIdx >= 0) {
                errHigh = this.getNumericValue(errHighIdx, i);
                this.updateMinMax(errHigh, 6);
            }
            if (errLowIdx >= 0) {
                errLow = this.getNumericValue(errLowIdx, i);
                this.updateMinMax(errLow, 5);
            }
            if (mkrOpacityIdx >= 0 && this.alphaRamp != null) {
                d2 = this.getNumericValue(mkrOpacityIdx, i);
                opacity = this.alphaRamp.queryDouble(d2, false);
                if (invert) {
                    opacity = alphaHigh - opacity + alphaLow;
                }
            }
            if (lblVarIdx >= 0) {
                o = this.dataFilter.getValue(lblVarIdx, (long)i);
                labelValue = o != null ? this.dataFilter.getFormattedValue(this.labelVariable, o, null) : null;
            }
            if (shapeVarIdx >= 0 && (typValue = this.dataFilter.getValue(shapeVarIdx, (long)i)) != null) {
                this.typMapper.addElement(typValue);
            }
            boolean catIsMissing = this.dataFilter.isMissing(catIdx, catValue);
            if (this.categoryIsCharacter && !catIsMissing && !this.catIsExternal) {
                catMapper.addValue((String)catValue);
            } else if (this.catDiscrete != null && !catIsMissing) {
                this.catDiscrete.addElement(catValue);
            }
            for (j = 0; j < nRespVarsToProcess; ++j) {
                if (this.nRespVarsToShow > 1 && this.clrRamp != null) {
                    o = this.getResponse(j);
                    grpData = this.getGroupData(o);
                }
                Object respValue = this.dataFilter.getValue(this.respIdx[j], (long)i);
                double y = this.isBubblePlot && respValue != null && respValue instanceof Number ? ((Number)respValue).doubleValue() : Double.NaN;
                if (this.responseIsCharacter && !this.respIsExternal) {
                    respMapper.addValue((String)respValue);
                }
                if (this.allCatMissing) {
                    this.allCatMissing = catIsMissing;
                }
                boolean respIsMissing = this.dataFilter.isMissing(this.respIdx[j], respValue);
                if (dataChanged && !respIsMissing) {
                    if (this.isBubblePlot) {
                        this.updateMinMax(x, dataSize / 2.0, 0);
                    } else {
                        this.updateMinMax(catValue, 0);
                    }
                }
                if (this.allRespMissing) {
                    this.allRespMissing = respIsMissing;
                }
                int idx = this.onMarker(grpData, img, catValue, respValue, null, i, dataSize, d2, opacity, labelValue, errLow, errHigh);
                if (doRegress) {
                    this.updateRegressionValues(catValue, respValue);
                }
                if (j == 0) {
                    curMkrIdx = idx;
                }
                if (!dataChanged) continue;
                if (this.isBubblePlot) {
                    this.updateMinMax(y, dataSize / 2.0, 1);
                    continue;
                }
                this.updateMinMax(respValue, 1);
            }
            if (this.singleUse) continue;
            this.setMarkerObsIndex(curMkrIdx, i);
        }
        for (i = 0; i < this.nConstBands; ++i) {
            this.updateMinMax(this.constOnlyBands[i][0], 1);
            this.updateMinMax(this.constOnlyBands[i][1], 1);
        }
        this.largestMarkerDrawn = this.areMarkersConstantSize() ? ((Number)this.markerSize).intValue() : this.mapMarkerSize(this.dataMax[2]);
        this.groups = this.groupMap.values();
        if ((this.hasGroups(true) || this.nRespVarsToShow > 1) && (itr = this.groups.iterator()) != null) {
            j = 0;
            if (this.grpVals == null) {
                this.grpVals = new Vector();
            } else {
                this.grpVals.removeAllElements();
            }
            while (itr.hasNext()) {
                grpData = (GroupData)itr.next();
                if (grpData == null) continue;
                if (grpIdxVarIdx < 0) {
                    grpData.color = this.getGroupColor(j++);
                }
                if (this.grpVals == null) continue;
                this.grpVals.addElement(grpData.value);
            }
        } else if (this.grpVals != null) {
            this.grpVals.removeAllElements();
        }
        if (doRegress) {
            this.setupLinearRegression();
        }
        if (this.categoryIsCharacter) {
            this.dataMin[0] = 0.0;
            if (this.catIsExternal && this.catValues != null) {
                this.dataMax[0] = this.catValues.length - 1;
            } else if (catMapper != null) {
                this.dataMax[0] = catMapper.getNumberValues() - 1;
            }
        } else if (this.catDiscrete != null) {
            o = this.catDiscrete.firstElement();
            this.dataMin[0] = o == null || !(o instanceof Number) ? 0.0 : ((Number)o).doubleValue();
            o = this.catDiscrete.lastElement();
            this.dataMax[0] = o == null || !(o instanceof Number) ? (double)(this.catDiscrete.size() - 1) : ((Number)o).doubleValue();
        }
        if (this.responseIsCharacter) {
            this.dataMin[1] = 0.0;
            if (this.respIsExternal && this.respValues != null) {
                this.dataMax[1] = this.respValues.length - 1;
            } else if (respMapper != null) {
                this.dataMax[1] = respMapper.getNumberValues() - 1;
            }
        }
        if (Double.isNaN(this.coalesceDistance)) {
            this.setCoalesceDistance(Double.NaN);
        }
        if (this.scatterDefaults.coalesceOn) {
            this.setMinimumMarkerDataValue(this.dataMin[2]);
            this.setMaximumMarkerDataValue(this.dataMax[2]);
        }
        if (catMapper != null && !this.catIsExternal) {
            int isort;
            switch (isSorted) {
                default: {
                    isort = 0;
                    break;
                }
                case 1: {
                    isort = 1;
                    break;
                }
                case -1: {
                    isort = -1;
                }
            }
            this.catValues = catMapper.getValues(isort);
            catMapper.reindexValues(this.catValues);
        }
        if (this.categoryIsCharacter) {
            if (this.catMinMax == null) {
                this.catMinMax = new Object[2];
            }
            if (this.catMinMax != null && this.catValues != null) {
                this.catMinMax[0] = this.catValues[0];
                this.catMinMax[1] = this.catValues[this.catValues.length - 1];
            }
        }
        if (respMapper != null && !this.respIsExternal) {
            this.respValues = respMapper.getValues(0);
            if (this.respMinMax == null) {
                this.respMinMax = new Object[2];
            }
            if (this.respMinMax != null && this.respValues != null) {
                this.respMinMax[0] = this.respValues[0];
                this.respMinMax[1] = this.respValues[this.respValues.length - 1];
            }
        }
        if (this.responseIsCharacter) {
            if (this.respMinMax == null) {
                this.respMinMax = new Object[2];
            }
            if (this.respMinMax != null && this.respValues != null) {
                this.respMinMax[0] = this.respValues[0];
                this.respMinMax[1] = this.respValues[this.respValues.length - 1];
            }
        }
        this.finalizeMarkers(catMapper, respMapper);
        if (catMapper != null) {
            catMapper.removeAllValues();
            catMapper = null;
        }
        if (respMapper != null) {
            respMapper.removeAllValues();
            respMapper = null;
        }
        if (this.isBubblePlot) {
            isSorted = this.sizeSorted;
        }
        switch (isSorted) {
            case -1: 
            case 1: {
                itr = this.groups.iterator();
                if (itr == null) {
                    isSorted = 0;
                    break;
                }
                while (itr.hasNext()) {
                    int[] indicies;
                    grpData = (GroupData)itr.next();
                    if (grpData == null || (indicies = grpData.createSortIndicies()) == null) continue;
                    this.sortMarkers(grpData.getMarkers(), indicies, indicies.length, isSorted);
                }
                break;
            }
        }
        if (Double.isNaN(this.cbArea[0])) {
            this.cbArea[0] = this.dataMin[0];
        }
        if (Double.isNaN(this.cbArea[2])) {
            this.cbArea[2] = this.dataMax[0];
        }
        if (Double.isNaN(this.cbArea[1])) {
            this.cbArea[1] = this.dataMin[1];
        }
        if (!Double.isNaN(this.dataMin[5])) {
            this.cbArea[1] = Math.min(this.cbArea[1], this.dataMin[5]);
        }
        if (!Double.isNaN(this.dataMin[6])) {
            this.cbArea[1] = Math.min(this.cbArea[1], this.dataMin[6]);
        }
        if (Double.isNaN(this.cbArea[3])) {
            this.cbArea[3] = this.dataMax[1];
        }
        if (!Double.isNaN(this.dataMax[5])) {
            this.cbArea[3] = Math.max(this.cbArea[3], this.dataMax[5]);
        }
        if (!Double.isNaN(this.dataMax[6])) {
            this.cbArea[3] = Math.max(this.cbArea[3], this.dataMax[6]);
        }
        if (!this.buildCleanup()) {
            this.buildError();
            return false;
        }
        this.rebuildRequired = false;
        this.redrawRequired = true;
        this.updateTangents = true;
        return true;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
    }

    @Override
    public Object getOpacityValue() {
        double[] array = null;
        if (Double.isNaN(this.opacity2)) {
            return new Double(this.opacity1);
        }
        array = new double[2];
        if (array == null) {
            return new Double(this.opacity1);
        }
        array[0] = this.opacity1;
        array[1] = this.opacity2;
        return array;
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null) {
            return false;
        }
        if (newOpacity instanceof Number) {
            double d1 = ((Number)newOpacity).doubleValue();
            if (Double.isInfinite(d1) || Double.isNaN(d1) || d1 < 0.0 || d1 > 1.0) {
                return false;
            }
            this.opacity1 = d1;
            this.opacity2 = Double.NaN;
        } else {
            int type = Extract.getSourceType((Object)newOpacity);
            if (type <= 0 || Extract.getNumberItems((Object)newOpacity, (int)type) < 1) {
                return false;
            }
            double d1 = Extract.getNumeric((Object)newOpacity, (int)0, (int)type);
            if (Double.isInfinite(d1) || Double.isNaN(d1) || d1 < 0.0 || d1 > 1.0) {
                return false;
            }
            double d2 = Extract.getNumeric((Object)newOpacity, (int)1, (int)type);
            if (Double.isInfinite(d2) || Double.isNaN(d2) || d2 < 0.0 || d2 > 1.0) {
                return false;
            }
            this.opacity1 = d1;
            this.opacity2 = d2;
        }
        return true;
    }

    @Override
    public Object getCategory() {
        return this.categoryVariable;
    }

    @Override
    public boolean setCategory(Object id) {
        Object oldVar = this.categoryVariable;
        if (!this.verifyCategory(id)) {
            return false;
        }
        this.catDiscrete = null;
        this.categoryIsCharacter = this.isVariableIdCharacter(id);
        this.catIsExternal = false;
        this.categoryVariable = this.dataFilter.getExactVariableId(id);
        this.dataMax[0] = Double.NaN;
        this.dataMin[0] = Double.NaN;
        this.dataViewported = false;
        this.rebuildRequired = true;
        this.ourDataChanged = true;
        this.coalesceDistance = Double.NaN;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 24;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = this.categoryVariable;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public int getNumberResponse() {
        return this.nRespVarsTotal;
    }

    @Override
    public Object getResponse(int idx) {
        if (this.respSlotIdx == null || this.responseVariables == null || this.respSlotIsUpper == null || idx < 0 || idx >= this.nRespVarsTotal) {
            return null;
        }
        int slotIdx = this.respSlotIdx[idx];
        if (slotIdx < 0 || slotIdx >= this.responseVariables.size()) {
            return null;
        }
        Object o = this.responseVariables.elementAt(slotIdx);
        if (o == null) {
            return null;
        }
        if (o instanceof BandData) {
            o = this.respSlotIsUpper[idx] ? ((BandData)o).upper : ((BandData)o).lower;
        }
        return o;
    }

    @Override
    public boolean setResponse(Object id, boolean add) {
        boolean newVarIsChar = false;
        int slot = this.isOurResponseVariable(id);
        Object oldVar = null;
        if (id == null) {
            return false;
        }
        if (add && slot >= 0) {
            return true;
        }
        if (add && slot < 0 && this.nRespVarsTotal >= this.respIdx.length) {
            return false;
        }
        if (add && this.groupVariable != null) {
            return false;
        }
        if (!this.verifyVariableId(id, false)) {
            return false;
        }
        newVarIsChar = this.isVariableIdCharacter(id);
        if (add && this.nRespVarsTotal >= 1 && newVarIsChar != this.responseIsCharacter) {
            return false;
        }
        this.respIsExternal = false;
        if (slot >= 0 && (oldVar = (Object)this.responseVariables.elementAt(slot)) != null && oldVar instanceof BandData) {
            BandData bd = (BandData)oldVar;
            oldVar = bd.upper != null ? bd.upper : bd.lower;
        }
        if (!add) {
            this.removeResponseRole(null, 25);
        }
        this.responseVariables.addElement(this.dataFilter.getExactVariableId(id));
        this.respSlotIdx[this.nRespVarsTotal++] = this.responseVariables.size() - 1;
        this.dataViewported = false;
        this.dataMax[1] = Double.NaN;
        this.dataMin[1] = Double.NaN;
        this.rebuildRequired = true;
        this.ourDataChanged = true;
        this.nRespVarsToShow = this.nRespVarsTotal;
        if (this.nRespVarsToShow > 1) {
            if (this.markerColor instanceof String) {
                this.setMarkerColor(null);
            }
            this.clrRamp = this.disRamp;
        }
        this.responseIsCharacter = newVarIsChar;
        this.coalesceDistance = Double.NaN;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = add ? 2 : 1;
            this.roleEvt.role = 25;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = id;
            this.roleEvt.oldValue = add ? null : oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public boolean removeResponse(Object variableId) {
        return this.removeResponseRole(variableId, 25);
    }

    @Override
    public boolean getMultipleResponseUseLabels() {
        return this.scatterDefaults.multipleResponseUseLabels;
    }

    @Override
    public void setMultipleResponseUseLabels(boolean useLabels) {
        this.scatterDefaults.multipleResponseUseLabels = useLabels;
        this.rebuildRequired = true;
        this.ourDataChanged = true;
    }

    @Override
    public Object getTip() {
        if (this.tipVariables == null || this.curTipVarIdx >= this.tipVariables.size()) {
            return null;
        }
        return this.tipVariables.elementAt(this.curTipVarIdx);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setTip(Object id) {
        if (!this.verifyTip(id, true)) {
            return false;
        }
        Object varId = this.dataFilter.getExactVariableId(id);
        if (this.tipVariables == null) {
            this.tipVariables = new Vector();
        }
        if (this.tipVariables == null) {
            return false;
        }
        if (varId == null) {
            if (id == null) {
                this.tipVariables.removeAllElements();
                return true;
            } else {
                if (!(id instanceof String) || this.tipText == null) return false;
                this.tipText.setPattern((String)id);
            }
            return true;
        } else if (this.tipVariables.size() <= 0) {
            this.tipVariables.addElement(this.dataFilter.getExactVariableId(varId));
            return true;
        } else {
            this.tipVariables.setElementAt(this.dataFilter.getExactVariableId(varId), 0);
        }
        return true;
    }

    @Override
    public Object getGroup() {
        return this.groupVariable;
    }

    @Override
    public boolean setGroup(Object id) {
        Object oldVar = this.groupVariable;
        if (!this.verifyGroup(id)) {
            return false;
        }
        if (this.groupMap != null) {
            this.groupMap.clear();
        }
        this.groups = null;
        if (id == null) {
            this.groupVariable = null;
            this.rebuildRequired = true;
            if (this.groupVariable == null && this.responseVariables != null) {
                this.nRespVarsToShow = this.nRespVarsTotal;
            }
            this.dataMax[1] = Double.NaN;
            this.dataMin[1] = Double.NaN;
            if (this.roles != null && this.roleEvt != null) {
                this.roleEvt.type = 3;
                this.roleEvt.role = 6;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = true;
                this.roleEvt.newValue = this.groupVariable;
                this.roleEvt.oldValue = oldVar;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
            }
            return true;
        }
        if (this.markerColor instanceof String) {
            this.setMarkerColor(null);
        }
        if (this.nRespVarsToShow > 1) {
            this.nRespVarsToShow = 1;
        }
        this.dataMax[1] = Double.NaN;
        this.dataMin[1] = Double.NaN;
        this.groupVariable = this.dataFilter.getExactVariableId(id);
        this.clrRamp = this.disRamp;
        this.ourDataChanged = true;
        this.rebuildRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 6;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = this.groupVariable;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public Object getURL() {
        return this.urlVariable;
    }

    @Override
    public boolean setURL(Object id) {
        Object oldVar = this.urlVariable;
        if (id == null) {
            this.urlVariable = null;
            if (this.roles != null && this.roleEvt != null) {
                this.roleEvt.type = 3;
                this.roleEvt.role = 41;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = false;
                this.roleEvt.newValue = this.groupVariable;
                this.roleEvt.oldValue = oldVar;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
            }
            return true;
        }
        this.urlVariable = this.dataFilter.getExactVariableId(id);
        this.redrawRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 41;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = this.urlVariable;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public Object getLabel() {
        return this.labelVariable;
    }

    @Override
    public boolean setLabel(Object id) {
        Object oldVar = this.labelVariable;
        if (id != null && !this.verifyVariableId(id, false)) {
            return false;
        }
        if (id == null) {
            this.labelVariable = null;
            this.rebuildRequired = true;
            if (this.roles != null && this.roleEvt != null) {
                this.roleEvt.type = 3;
                this.roleEvt.role = 8;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = true;
                this.roleEvt.newValue = this.labelVariable;
                this.roleEvt.oldValue = oldVar;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
            }
            return true;
        }
        if (!this.verifyVariableId(id, false)) {
            return false;
        }
        this.labelVariable = this.dataFilter.getExactVariableId(id);
        this.rebuildRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 8;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = this.labelVariable;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public TextStyleInterface getLabelText() {
        if (this.markerLabelAttribs == null) {
            this.markerLabelAttribs = new TextAttrib(null, null, this.scatterDefaults.markerLabelColor);
            if (this.markerLabelAttribs == null) {
                return null;
            }
            this.markerLabelAttribs.setJustification(this.scatterDefaults.markerLabelHorzJust, this.scatterDefaults.markerLabelVertJust);
        }
        return this.markerLabelAttribs;
    }

    @Override
    public boolean setLabelText(Object attrib) {
        if (attrib == null) {
            return false;
        }
        if (this.markerLabelAttribs == null) {
            this.markerLabelAttribs = new TextAttrib(null, null, this.scatterDefaults.markerLabelColor);
            if (this.markerLabelAttribs == null) {
                return false;
            }
            this.markerLabelAttribs.setJustification(this.scatterDefaults.markerLabelHorzJust, this.scatterDefaults.markerLabelVertJust);
        }
        if (attrib instanceof Color) {
            this.markerLabelAttribs.setColor(attrib);
        } else if (attrib instanceof Font) {
            if (!this.markerLabelAttribs.setFont(attrib)) {
                return false;
            }
        } else if (attrib instanceof String) {
            Font f = this.markerLabelAttribs.getFont();
            if (f == null) {
                return false;
            }
            if (!this.markerLabelAttribs.setFont(FontManager.getFont((String)((String)attrib), (int)f.getStyle(), (int)f.getSize()))) {
                return false;
            }
        } else if (attrib instanceof TextStyleInterface) {
            this.markerLabelAttribs = new TextAttrib((TextStyleInterface)attrib);
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public Object getGroupIndex() {
        return this.groupIndexVariable;
    }

    @Override
    public boolean setGroupIndex(Object id) {
        Object oldVar = this.groupIndexVariable;
        if (id == null) {
            this.groupIndexVariable = null;
            this.rebuildRequired = true;
            if (this.roles != null && this.roleEvt != null) {
                this.roleEvt.type = 3;
                this.roleEvt.role = 7;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = false;
                this.roleEvt.newValue = this.groupIndexVariable;
                this.roleEvt.oldValue = oldVar;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
            }
            return true;
        }
        if (!this.verifyVariableId(id, false)) {
            return false;
        }
        if (!this.dataFilter.isNumericVariable(id)) {
            return false;
        }
        this.groupIndexVariable = this.dataFilter.getExactVariableId(id);
        this.rebuildRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 7;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = false;
            this.roleEvt.newValue = this.groupVariable;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    public Object getBand(Object id) {
        return null;
    }

    public boolean setBand(Object role, Object ids, boolean add) {
        boolean varUpperIsNumber = false;
        boolean varLowerIsNumber = false;
        int count = 0;
        int irole = this.getRoleIntValue(role);
        Object varUpper = null;
        Object varLower = null;
        if (this.dataFilter == null || this.getGroup() != null) {
            return false;
        }
        int type = Extract.getSourceType((Object)ids);
        count = Extract.getNumberItems((Object)ids, (int)type);
        switch (irole) {
            default: {
                return false;
            }
            case 54: {
                if (count < 2) {
                    return false;
                }
                varUpper = Extract.getObject((Object)ids, (int)0, (int)type);
                varLower = Extract.getObject((Object)ids, (int)1, (int)type);
                break;
            }
            case 56: {
                if (count < 1) {
                    return false;
                }
                varUpper = Extract.getObject((Object)ids, (int)0, (int)type);
                break;
            }
            case 57: {
                if (count < 1) {
                    return false;
                }
                varLower = Extract.getObject((Object)ids, (int)0, (int)type);
            }
        }
        Object temp = this.dataFilter.getExactVariableId(varUpper);
        if (temp == null && varUpper != null && varUpper instanceof Number) {
            temp = varUpper;
            varUpperIsNumber = true;
        }
        varUpper = temp;
        temp = this.dataFilter.getExactVariableId(varLower);
        if (temp == null && varLower != null && varLower instanceof Number) {
            temp = varLower;
            varLowerIsNumber = true;
        }
        varLower = temp;
        if (!add) {
            this.removeResponseRole(null, irole);
        }
        if (this.isOurResponseVariable(varUpper) >= 0 || this.isOurResponseVariable(varUpper) >= 0) {
            return false;
        }
        switch (irole) {
            case 54: {
                if (varUpper == null || varUpper == null) {
                    return false;
                }
                if (varUpperIsNumber && varLowerIsNumber) {
                    if (this.nConstBands >= 100) {
                        return false;
                    }
                    this.constOnlyBands[this.nConstBands][0] = ((Number)varUpper).doubleValue();
                    this.constOnlyBands[this.nConstBands][1] = ((Number)varLower).doubleValue();
                    ++this.nConstBands;
                    break;
                }
                this.responseVariables.addElement(new BandData(varUpper, varLower));
                this.respSlotIsUpper[this.nRespVarsTotal] = true;
                this.respSlotIdx[this.nRespVarsTotal++] = this.responseVariables.size() - 1;
                this.respSlotIsUpper[this.nRespVarsTotal] = false;
                this.respSlotIdx[this.nRespVarsTotal++] = this.responseVariables.size() - 1;
                break;
            }
            case 56: {
                if (varUpper == null) {
                    return false;
                }
                int idx = this.getFirstEmptyBand(false);
                BandData bd = this.getBandData(idx);
                if (bd != null) {
                    bd.upper = varUpper;
                    this.respSlotIsUpper[this.nRespVarsTotal] = true;
                    this.respSlotIdx[this.nRespVarsTotal++] = idx;
                    break;
                }
                if (varUpperIsNumber) {
                    idx = this.getFirstEmptyConstBand(false);
                    if (idx < 0) {
                        this.constOnlyBands[this.nConstBands][0] = ((Number)varUpper).doubleValue();
                        this.constOnlyBands[this.nConstBands][1] = Double.NaN;
                        ++this.nConstBands;
                        break;
                    }
                    this.constOnlyBands[idx][0] = ((Number)varUpper).doubleValue();
                    break;
                }
                this.responseVariables.addElement(new BandData(varUpper, null));
                this.respSlotIsUpper[this.nRespVarsTotal] = true;
                this.respSlotIdx[this.nRespVarsTotal++] = this.responseVariables.size() - 1;
                break;
            }
            case 57: {
                if (varLower == null) {
                    return false;
                }
                int idx = this.getFirstEmptyBand(true);
                BandData bd = this.getBandData(idx);
                if (bd != null) {
                    bd.lower = varLower;
                    this.respSlotIsUpper[this.nRespVarsTotal] = false;
                    this.respSlotIdx[this.nRespVarsTotal++] = idx;
                    break;
                }
                if (varLowerIsNumber) {
                    idx = this.getFirstEmptyConstBand(true);
                    if (idx < 0) {
                        this.constOnlyBands[this.nConstBands][0] = Double.NaN;
                        this.constOnlyBands[this.nConstBands][1] = ((Number)varLower).doubleValue();
                        ++this.nConstBands;
                        break;
                    }
                    this.constOnlyBands[idx][1] = ((Number)varLower).doubleValue();
                    break;
                }
                this.responseVariables.addElement(new BandData(null, varLower));
                this.respSlotIsUpper[this.nRespVarsTotal] = false;
                this.respSlotIdx[this.nRespVarsTotal++] = this.responseVariables.size() - 1;
            }
        }
        this.setSortOrder(RoleInterface.ROLE_X, RoleInterface.ROLE_SORT_ASCENDING);
        this.nRespVarsToShow = this.nRespVarsTotal;
        if (this.nRespVarsToShow > 1) {
            if (this.markerColor instanceof String) {
                this.setMarkerColor(null);
            }
            this.clrRamp = this.disRamp;
        }
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = irole;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            Object[] vars = new Object[]{varUpper, varLower};
            this.roleEvt.newValue = vars;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        this.rebuildRequired = true;
        this.dataMax[1] = Double.NaN;
        this.dataMin[1] = Double.NaN;
        this.ourDataChanged = true;
        return true;
    }

    public boolean removeBand(Object id) {
        boolean status = true;
        int type = Extract.getSourceType((Object)id);
        int n = Extract.getNumberItems((Object)id, (int)type);
        for (int i = 0; i < n; ++i) {
            Object o = Extract.getObject((Object)id, (int)i, (int)type);
            if (o == null) continue;
            status &= this.removeResponseRole(o, 54);
        }
        return status;
    }

    @Override
    public Object[] getValues(Object role) {
        boolean getSorted = false;
        boolean reverse = false;
        int n = 0;
        SortedVector vec = null;
        Object[] out = null;
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 6: {
                if (this.grpVals == null || (n = this.grpVals.size()) <= 0) {
                    return null;
                }
                out = new Object[n];
                if (out == null) {
                    return null;
                }
                this.grpVals.copyInto(out);
                return out;
            }
            case 18: {
                vec = this.typMapper;
                break;
            }
            case 1: 
            case 24: {
                switch (this.catSorted) {
                    default: {
                        break;
                    }
                    case -1: {
                        reverse = true;
                    }
                    case 1: {
                        getSorted = true;
                    }
                }
                if (this.catValues != null) {
                    return this.catValues;
                }
                if (this.catDiscrete == null) break;
                vec = this.catDiscrete;
                break;
            }
            case 17: 
            case 25: {
                if (this.respValues == null) break;
                return this.respValues;
            }
        }
        if (vec == null || (n = vec.size()) <= 0) {
            return null;
        }
        out = new Object[n];
        if (out == null) {
            return null;
        }
        boolean sorted = vec.isRetrieveInSortedOrder();
        vec.setRetrieveInSortedOrder(getSorted);
        for (int i = 0; i < n; ++i) {
            switch (irole) {
                default: 
            }
            if (reverse) {
                out[n - 1 - i] = vec.elementAt(i);
                continue;
            }
            out[i] = vec.elementAt(i);
        }
        vec.setRetrieveInSortedOrder(sorted);
        return out;
    }

    @Override
    public boolean setValues(Object role, Object values) {
        int i;
        int n = 0;
        int irole = this.getRoleIntValue(role);
        Object[] vm = null;
        Vector<Object> v = null;
        switch (irole) {
            case 1: 
            case 24: {
                if (values == null || this.categoryIsCharacter) break;
                return false;
            }
            case 17: 
            case 25: {
                if (values == null || this.responseIsCharacter) break;
                return false;
            }
            default: {
                return false;
            }
        }
        if (values != null) {
            v = new Vector<Object>();
            if (v == null) {
                return false;
            }
            if (values instanceof Enumeration) {
                while (((Enumeration)values).hasMoreElements()) {
                    v.addElement(((Enumeration)values).nextElement());
                }
                n = v.size();
            } else {
                int type = Extract.getSourceType((Object)values);
                n = Extract.getNumberItems((Object)values, (int)type);
                if (n > 0) {
                    return false;
                }
                for (i = 0; i < n; ++i) {
                    v.addElement(Extract.getObject((Object)values, (int)i, (int)type));
                }
            }
        }
        switch (irole) {
            case 1: 
            case 24: {
                if (!this.categoryIsCharacter) {
                    return false;
                }
                if (v == null) {
                    this.catIsExternal = false;
                    break;
                }
                vm = new Object[n];
                if (vm == null) {
                    return false;
                }
                this.catIsExternal = true;
                this.catValues = vm;
                break;
            }
            case 17: 
            case 25: {
                if (!this.responseIsCharacter) {
                    return false;
                }
                if (v == null) {
                    this.respIsExternal = false;
                    break;
                }
                vm = new Object[n];
                if (vm == null) {
                    return false;
                }
                this.respIsExternal = true;
                this.respValues = vm;
            }
        }
        if (vm != null) {
            n = v.size();
            for (i = 0; i < n; ++i) {
                Object o = v.elementAt(i);
                if (o == null) continue;
                vm[i] = o;
            }
        }
        this.rebuildRequired = true;
        this.redrawRequired = true;
        return true;
    }

    @Override
    public Color[] getColors(Object role, Object[] values) {
        int n = 0;
        Color[] out = null;
        int irole = this.getRoleIntValue(role);
        if (values == null || (n = values.length) <= 0) {
            return null;
        }
        switch (irole) {
            case 6: {
                out = new Color[n];
                if (out == null) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    out[i] = this.getGroupColor(values[i], i);
                }
                break;
            }
            case 18: {
                out = new Color[n];
                if (out == null) {
                    return null;
                }
                for (int i = 0; i < n; ++i) {
                    out[i] = this.defaultMarkerColor;
                }
                break;
            }
        }
        return out;
    }

    @Override
    public Color[] getColors() {
        if (this.clrRamp == null || this.clrRamp.getNumberColors() <= 0) {
            return null;
        }
        return this.clrRamp.getColors();
    }

    @Override
    public Object getMarkerSize() {
        return this.markerSize;
    }

    @Override
    public boolean setMarkerSize(Object value) {
        boolean wasMapped = this.markerSize instanceof String;
        Object oldValue = this.markerSize;
        if (!this.verifyMarkerSize(value)) {
            return false;
        }
        if (value == null) {
            this.setAutoSizeMarkers(true);
            value = !this.calculateMarkerSize(this.componentWidth, this.componentHeight) ? new Integer(this.scatterDefaults.defaultMarkerSize) : this.markerSize;
        } else if (value instanceof String) {
            this.dataMax[2] = Double.NaN;
            this.dataMin[2] = Double.NaN;
        }
        if (value instanceof String) {
            this.markerSize = this.dataFilter.getExactVariableId(value);
        } else {
            this.markerSize = value;
            this.coalesceStatistic = 1;
        }
        if (!this.isSizableMarker(this.getMarkerShape())) {
            this.setMarkerShape("Square");
        }
        this.ourDataChanged = true;
        this.rebuildRequired = true;
        if (wasMapped || this.markerSize instanceof String && this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = this.markerSize instanceof String ? 1 : 3;
            this.roleEvt.role = 19;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = this.markerSize instanceof String ? this.markerSize : null;
            this.roleEvt.oldValue = wasMapped ? oldValue : null;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        if (this.isBubblePlot && this.markerSize != null && this.markerSize instanceof String && this.markerOpacity == null) {
            this.setRole(this.markerSize, RoleInterface.ROLE_TRANSPARENCY);
        }
        return true;
    }

    @Override
    public boolean areMarkersAutoSized() {
        return this.scatterDefaults.autoSizeMarkers;
    }

    @Override
    public void setAutoSizeMarkers(boolean auto) {
        this.scatterDefaults.autoSizeMarkers = auto;
        this.calculateMarkerSize(this.componentWidth, this.componentHeight);
        this.rebuildRequired = true;
    }

    @Override
    public boolean getAlwaysShowSelectedMarkers() {
        return this.scatterDefaults.alwaysShowSelectedMarkers;
    }

    @Override
    public void setAlwaysShowSelectedMarkers(boolean always) {
        this.scatterDefaults.alwaysShowSelectedMarkers = always;
    }

    protected Color getBaseLineColor() {
        if (this.baseLine == null || this.baseLine.getColor() == null) {
            return this.getJoinLineColor(-1);
        }
        return this.baseLine.getColor();
    }

    protected int getBaseLineThickness() {
        if (this.baseLine == null || this.baseLine.getWidth() <= 0) {
            return this.getJoinLineThickness(-1);
        }
        return this.baseLine.getWidth();
    }

    protected Color getMarkerColor(int idx) {
        Color c = null;
        switch (idx) {
            case -1: {
                if (this.defaultMarkerAttrib == null) break;
                c = this.defaultMarkerAttrib.getColor();
                break;
            }
            default: {
                if (this.markerAttribs == null || this.markerAttribs.length <= idx || this.markerAttribs[idx] == null) break;
                c = this.markerAttribs[idx].getColor();
            }
        }
        return c;
    }

    protected Color getJoinLineColor(int idx) {
        Color c = null;
        switch (idx) {
            case -1: {
                if (this.defaultJoinLine == null) break;
                c = this.defaultJoinLine.getColor();
                break;
            }
            default: {
                if (this.joinLineAttribs == null || this.joinLineAttribs.length <= idx || this.joinLineAttribs[idx] == null) break;
                c = this.joinLineAttribs[idx].getColor();
            }
        }
        return c;
    }

    protected int getJoinLineThickness(int idx) {
        int thick = this.defaultJoinLineThickness;
        switch (idx) {
            case -1: {
                if (this.defaultJoinLine == null) break;
                thick = this.defaultJoinLine.getWidth();
                break;
            }
            default: {
                if (this.joinLineAttribs == null || this.joinLineAttribs.length <= idx || this.joinLineAttribs[idx] == null) {
                    if (this.defaultJoinLine == null) break;
                    thick = this.defaultJoinLine.getWidth();
                    break;
                }
                thick = this.joinLineAttribs[idx].getWidth();
            }
        }
        return thick;
    }

    protected boolean useColorAsSelection() {
        boolean out = false;
        switch (this.selectionIndicator) {
            default: {
                if (!this.areMarkersConstantSize()) {
                    out = true;
                    break;
                }
                out = this.groupVariable == null && this.nRespVarsToShow <= 1 && (this.markerColor == null || !(this.markerColor instanceof String));
                break;
            }
            case 1: {
                out = true;
                break;
            }
            case 2: {
                out = false;
            }
        }
        return out;
    }

    @Override
    public String getSelectionIndicator() {
        String s = null;
        switch (this.selectionIndicator) {
            default: {
                s = this.smartNLS;
                break;
            }
            case 1: {
                s = this.colorNLS;
                break;
            }
            case 2: {
                s = this.growNLS;
            }
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSelectionIndicator(Object indicator) {
        int ival = -1;
        if (indicator == null) {
            return false;
        }
        if (indicator instanceof Number) {
            ival = ((Number)indicator).intValue();
        } else {
            if (!(indicator instanceof String)) return false;
            String s = (String)indicator;
            if (s.equalsIgnoreCase("SMART") || s.equalsIgnoreCase(this.smartNLS)) {
                ival = 0;
            } else if (s.equalsIgnoreCase("COLOR") || s.equalsIgnoreCase(this.colorNLS)) {
                ival = 1;
            } else {
                if (!s.equalsIgnoreCase("GROW") && !s.equalsIgnoreCase(this.growNLS)) return false;
                ival = 2;
            }
        }
        switch (ival) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        this.selectionIndicator = ival;
        return true;
    }

    public boolean calculateMarkerSize(int w, int h) {
        if (h <= 0) {
            return false;
        }
        this.componentWidth = w;
        this.componentHeight = h;
        if (!this.scatterDefaults.autoSizeMarkers || this.markerSize != null && !(this.markerSize instanceof Number)) {
            return false;
        }
        int oldSize = ((Number)this.markerSize).intValue();
        int isize = (int)((double)h * this.scatterDefaults.autoSizeFraction);
        isize = Math.max(isize, this.minMarkerSize);
        isize = Math.min(isize, this.maxMarkerSize);
        this.markerSize = new Integer(isize);
        this.rebuildRequired = oldSize != isize;
        return true;
    }

    @Override
    public boolean isSizableMarker() {
        return this.isSizableMarker(this.markerShape);
    }

    protected boolean isSizableMarker(Object mkrShape) {
        if (mkrShape == null) {
            return false;
        }
        if (mkrShape instanceof Image) {
            return false;
        }
        if (mkrShape instanceof Number) {
            switch (((Number)mkrShape).intValue()) {
                default: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
            }
            return true;
        }
        return mkrShape instanceof String;
    }

    @Override
    public int getMinimumMarkerSize() {
        return this.minMarkerSize;
    }

    @Override
    public boolean setMinimumMarkerSize(int newSize) {
        if (newSize <= 0) {
            return false;
        }
        this.minMarkerSize = newSize;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public int getMaximumMarkerSize() {
        return this.maxMarkerSize;
    }

    @Override
    public boolean setMaximumMarkerSize(int newSize) {
        if (newSize <= 0) {
            return false;
        }
        this.maxMarkerSize = newSize;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public double getMinimumMarkerDataValue() {
        return this.minMarkerDataValue;
    }

    @Override
    public boolean setMinimumMarkerDataValue(double newValue) {
        if (Double.isInfinite(newValue) || Double.isNaN(newValue)) {
            return false;
        }
        this.minMarkerDataValue = newValue;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public double getMaximumMarkerDataValue() {
        return this.maxMarkerDataValue;
    }

    @Override
    public boolean setMaximumMarkerDataValue(double newValue) {
        if (Double.isInfinite(newValue) || Double.isNaN(newValue)) {
            return false;
        }
        this.maxMarkerDataValue = newValue;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public boolean isColorRoleToMappedDataRange() {
        return this.colorRoleToMappedDataRange;
    }

    @Override
    public void setColorRoleToMappedDataRange(boolean map) {
        this.colorRoleToMappedDataRange = map;
        if (this.contRamp != null && this.markerColor instanceof String) {
            if (this.dataFilter != null && this.dataFilter instanceof DataFilterInfoInterface) {
                this.contRamp.setRange(((DataFilterInfoInterface)this.dataFilter).getMinimumValue(this.markerColor), ((DataFilterInfoInterface)this.dataFilter).getMaximumValue(this.markerColor));
            }
            this.rebuildRequired = true;
        }
    }

    @Override
    public Object getMarkerColor() {
        return this.markerColor;
    }

    @Override
    public boolean setMarkerColor(Object value) {
        Color c = null;
        Object oldValue = this.markerColor;
        if (!(value == null || this.groupVariable == null && this.nRespVarsToShow <= 1 && this.verifyMarkerColor(value))) {
            return false;
        }
        if (value == null) {
            c = this.defaultMarkerColor;
        } else if (value instanceof String) {
            if (!this.verifyVariableId(value, true) && (c = ColorParse.getColorFromString((String)((String)value))) == null) {
                return false;
            }
        } else if (value instanceof Color) {
            c = (Color)value;
        }
        this.markerColor = c != null ? c : value;
        if (!(oldValue instanceof Color) || c == null || this.nRespVarsToShow > 1) {
            this.rebuildRequired = true;
        }
        if (value == null) {
            this.redrawRequired = true;
            if (oldValue instanceof String && this.roles != null && this.roleEvt != null) {
                this.roleEvt.type = 3;
                this.roleEvt.role = 2;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = false;
                this.roleEvt.newValue = null;
                this.roleEvt.oldValue = oldValue;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
            }
            return true;
        }
        if (this.markerColor instanceof String) {
            this.clrRamp = this.contRamp;
            if (this.nRespVarsToShow > 1) {
                this.nRespVarsToShow = 1;
            }
        }
        if (this.colorRoleToMappedDataRange && this.contRamp != null && this.dataFilter != null && this.dataFilter instanceof DataFilterInfoInterface) {
            this.contRamp.setRange(((DataFilterInfoInterface)this.dataFilter).getMinimumValue(this.markerColor), ((DataFilterInfoInterface)this.dataFilter).getMaximumValue(this.markerColor));
        }
        this.redrawRequired = true;
        if ((this.markerColor instanceof String || oldValue instanceof String) && this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = 2;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = false;
            this.roleEvt.newValue = this.markerColor;
            this.roleEvt.oldValue = oldValue;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public boolean setMarkerOpacity(Object value) {
        boolean status = false;
        Object oldValue = this.markerOpacity;
        if (value == null) {
            this.markerOpacity = null;
            status = true;
        } else if (value instanceof String) {
            if (!this.verifyVariableId(value, true)) {
                return false;
            }
            this.markerOpacity = value;
            status = true;
        } else {
            status = this.setOpacityValue(value);
        }
        if (oldValue == null && this.markerOpacity != null) {
            this.rebuildRequired = true;
        } else if (oldValue != null && this.markerOpacity == null) {
            this.rebuildRequired = true;
        }
        if (oldValue instanceof String || this.markerOpacity instanceof String && this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 1;
            this.roleEvt.role = this.invertOpacity ? 52 : 11;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = false;
            this.roleEvt.newValue = this.markerOpacity instanceof String ? this.markerOpacity : null;
            this.roleEvt.oldValue = oldValue instanceof String ? oldValue : null;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return status;
    }

    @Override
    public Object getMarkerOpacity() {
        if (this.markerOpacity != null) {
            return this.markerOpacity;
        }
        return this.getOpacityValue();
    }

    @Override
    public Object getMarkerType() {
        return this.getMarkerShape();
    }

    @Override
    public Object getMarkerShape() {
        if (this.markerShape instanceof String) {
            return this.markerShape;
        }
        if (this.markerShape instanceof Image) {
            return new SILKNumber(7, this.shapeList[7], this.englishShapeList[7]);
        }
        int i = ((Number)this.markerShape).intValue();
        return new SILKNumber(i, this.shapeList[i], this.englishShapeList[i]);
    }

    @Override
    public String getMarkerTypeString() {
        return this.getMarkerShapeString();
    }

    @Override
    public String getMarkerShapeString() {
        Object o = this.getMarkerShape();
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    @Override
    public boolean setMarkerType(Object type) {
        return this.setMarkerShape(type);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setMarkerShape(Object shape) {
        boolean found = false;
        boolean wasMapped = this.isMappedMarker(this.markerShape);
        String s = null;
        Object oldValue = this.markerShape;
        if (shape == null) {
            if (!wasMapped) return false;
            this.markerShape = this.defaultMarkerShape;
            this.rebuildRequired = true;
            if (this.roles == null || this.roleEvt == null) return true;
            this.roleEvt.type = 3;
            this.roleEvt.role = 18;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = null;
            this.roleEvt.oldValue = oldValue;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
            return true;
        }
        if (shape instanceof String) {
            s = (String)shape;
            if (this.verifyVariableId(s, false)) {
                this.markerShape = s;
            } else {
                int i;
                int n;
                if (this.shapeList == null && this.englishShapeList == null) return false;
                if (this.shapeList != null) {
                    n = this.shapeList.length;
                    for (i = 0; i < n; ++i) {
                        if (!s.equalsIgnoreCase(this.shapeList[i])) continue;
                        this.markerShape = new Integer(i);
                        found = true;
                        break;
                    }
                }
                if (!found && this.englishShapeList != null) {
                    n = this.englishShapeList.length;
                    for (i = 0; i < n; ++i) {
                        if (!s.equalsIgnoreCase(this.englishShapeList[i])) continue;
                        this.markerShape = new Integer(i);
                        break;
                    }
                }
            }
        } else if (shape instanceof Image) {
            this.lastGlyph = (Image)shape;
            this.markerShape = this.lastGlyph;
        } else {
            if (!(shape instanceof Number)) return false;
            int i = ((Number)shape).intValue();
            if (i < 0 || i > 7) return false;
            this.markerShape = new Integer(i);
        }
        this.rebuildRequired = true;
        if (!wasMapped && (!this.isMappedMarker(this.markerShape) || this.roles == null || this.roleEvt == null)) return true;
        this.roleEvt.type = this.isMappedMarker(this.markerShape) ? 1 : 3;
        this.roleEvt.role = 18;
        this.roleEvt.isAdjusting = false;
        this.roleEvt.rangeChangeEvent = true;
        this.roleEvt.newValue = this.isMappedMarker(this.markerShape) ? this.markerShape : null;
        this.roleEvt.oldValue = wasMapped ? oldValue : null;
        this.roleEvt.source = this;
        this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
        this.roleEvt.target = null;
        this.roles.throwRoleEvent(this.roleEvt);
        return true;
    }

    @Override
    public int[] getShapeTypes(Object[] values) {
        int n = 0;
        int[] out = null;
        if (values == null || (n = values.length) <= 0 || (out = new int[n]) == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            out[i] = this.getStandardMarkerShape(this.getMarkerMapping(values[i]));
        }
        return out;
    }

    @Override
    public boolean[] getShapeFills(Object[] values) {
        int n = 0;
        boolean[] out = null;
        if (values == null || (n = values.length) <= 0 || (out = new boolean[n]) == null) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            out[i] = this.getMarkerFillMapping(values[i]);
        }
        return out;
    }

    @Override
    public Image getMarkerGlyph() {
        return this.lastGlyph;
    }

    @Override
    public boolean isFillableMarker() {
        if (this.isMappedMarker(this.markerShape)) {
            return false;
        }
        return this.isFillableMarker(this.markerShape);
    }

    protected boolean isFillableMarker(Object mkrShape) {
        if (mkrShape == null) {
            return false;
        }
        if (mkrShape instanceof Image) {
            return false;
        }
        if (mkrShape instanceof Number) {
            switch (((Number)mkrShape).intValue()) {
                case 0: 
                case 4: 
                case 7: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean isMarkerFilled() {
        return this.scatterDefaults.fillShapes;
    }

    @Override
    public void setMarkerFilled(boolean fill) {
        this.scatterDefaults.fillShapes = fill;
        this.redrawRequired = true;
    }

    @Override
    public boolean isOutlinedMarker() {
        return this.isOutlinedMarker(this.markerShape);
    }

    protected boolean isOutlinedMarker(Object mkrShape) {
        if (mkrShape == null) {
            return false;
        }
        if (mkrShape instanceof Image) {
            return false;
        }
        if (mkrShape instanceof Number) {
            switch (((Number)mkrShape).intValue()) {
                default: {
                    return false;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: 
            }
            return true;
        }
        return true;
    }

    @Override
    public void setMarkersOn(boolean on) {
        this.scatterDefaults.markersOn = on;
        this.redrawRequired = true;
    }

    @Override
    public boolean areMarkersOn() {
        return this.isMarkerOn(-1);
    }

    @Override
    public boolean areMarkerOutlinesOn() {
        return this.scatterDefaults.outlinesOn;
    }

    @Override
    public void setMarkerOutlinesOn(boolean on) {
        this.redrawRequired = true;
        this.scatterDefaults.outlinesOn = on;
    }

    @Override
    public Color getMarkerOutlineColor() {
        return this.markerOutlineColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setMarkerOutlineColor(Object color) {
        if (color == null) {
            return false;
        }
        if (color instanceof Color) {
            this.markerOutlineColor = (Color)color;
        } else {
            if (!(color instanceof String)) return false;
            Color c = ColorParse.getColorFromString((String)((String)color));
            if (c == null) return false;
            this.markerOutlineColor = c;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public int getJoinLineStyle(Object id) {
        int idx = this.getJoinLineStyleIdIndex(id);
        return this.getJoinLineStyle(idx);
    }

    @Override
    public boolean setJoinLineStyle(Object style) {
        int js = this.getJoinLineStyleIntValue(style);
        if (js < 0) {
            return false;
        }
        this.defaultJoinStyle = js;
        if (js == 6 && this.cardSpline == null) {
            this.cardSpline = new Cardinal();
        } else if (js == 5 && this.scatterDefaults.setDefaultBaseLineForNeedles) {
            this.setBaseLineValue(new Double(this.scatterDefaults.needleDefaultBaseLine));
        }
        this.rebuildRequired = true;
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean setJoinLineStyle(Object id, Object style) {
        int js = this.getJoinLineStyleIntValue(style);
        int start = 0;
        int end = 0;
        if (js < 0) {
            return false;
        }
        if (id == null || id instanceof Number && ((Number)id).intValue() == -1) {
            if (this.joinStyle != null) {
                end = this.joinStyle.length;
            }
            this.defaultJoinStyle = js;
        } else {
            start = this.getJoinLineStyleIdIndex(id);
            if (start < 0) {
                return false;
            }
            end = start + 1;
            if (!this.growJoinLineStyles(end)) {
                return false;
            }
        }
        if (js == 6 && this.cardSpline == null) {
            this.cardSpline = new Cardinal();
        }
        for (int idx = start; idx < end; ++idx) {
            this.joinStyle[idx] = js;
        }
        this.rebuildRequired = true;
        this.redrawRequired = true;
        return true;
    }

    @Override
    public Color getJoinLineColor() {
        return this.getJoinLineColor(-1);
    }

    @Override
    public boolean setJoinLineColor(Object colorIn) {
        return this.setJoinLine(colorIn, -1);
    }

    @Override
    public int getJoinLineThickness() {
        return this.getJoinLineThickness(-1);
    }

    @Override
    public boolean setJoinLineThickness(int thickness) {
        return this.setJoinLine((Object)new Integer(thickness), -1);
    }

    @Override
    public LineStyleInterface getJoinLine(Object id) {
        return this.getJoinLine(this.getJoinLineStyleIdIndex(id));
    }

    @Override
    public boolean setJoinLine(Object id, Object attrib) {
        return this.setJoinLine(attrib, this.getJoinLineStyleIdIndex(id));
    }

    @Override
    public LineStyleInterface getLinearRegressionLine() {
        if (this.regressionLine == null) {
            this.regressionLine = new LineAttrib(false, Color.red, 1);
        }
        return this.regressionLine;
    }

    @Override
    public boolean setLinearRegressionLine(Object line) {
        boolean status = false;
        LineStyleInterface ls = null;
        if (line == null) {
            return false;
        }
        ls = this.getLinearRegressionLine();
        if (ls == null) {
            return false;
        }
        if (line instanceof Boolean) {
            ls.setVisible((Boolean)line);
            status = true;
        } else if (line instanceof Color || line instanceof String) {
            status = ls.setColor(line);
        } else if (line instanceof Number) {
            status = ls.setWidth(((Number)line).intValue());
        } else if (line instanceof LineStyleInterface) {
            this.regressionLine = (LineStyleInterface)line;
            status = true;
        } else {
            return false;
        }
        this.redrawRequired = status || this.redrawRequired;
        this.rebuildRequired = status;
        return status;
    }

    @Override
    public boolean isAreaFillOn() {
        return this.scatterDefaults.areaFillOn;
    }

    @Override
    public void setAreaFillOn(boolean on) {
        if (on && !this.verifyPoints(4)) {
            return;
        }
        this.scatterDefaults.areaFillOn = on;
        this.redrawRequired = true;
    }

    @Override
    public Color getAreaFillColor() {
        if (this.areaFillColor == null) {
            return this.getJoinLineColor(0);
        }
        return this.areaFillColor;
    }

    protected boolean verifyAreaFillColor(Object color) {
        return color == null || color instanceof Color || color instanceof String;
    }

    public int getRoleIntValue(Object role) {
        if (role == null) {
            return -1;
        }
        if (role instanceof Number) {
            return ((Number)role).intValue();
        }
        if (!(role instanceof String)) {
            return -1;
        }
        String s = (String)role;
        if (this.roles.equalsRoleNLSName("ROLE_X", s) || s.equalsIgnoreCase("CATEGORY") || s.equalsIgnoreCase("INDEPENDENT") || s.equalsIgnoreCase("X") || s.equalsIgnoreCase("HORIZONTAL")) {
            return 24;
        }
        if (this.roles.equalsRoleNLSName("ROLE_Y", s) || s.startsWith("RESPONSE") || s.startsWith("DEPENDENT") || s.startsWith("response") || s.startsWith("dependent") || s.startsWith("Response") || s.startsWith("Dependent") || s.equalsIgnoreCase("Y") || s.equalsIgnoreCase("VERTICAL")) {
            return 25;
        }
        if (this.roles.equalsRoleNLSName("ROLE_TIP", s) || s.equalsIgnoreCase("TIP")) {
            return 22;
        }
        if (this.roles.equalsRoleNLSName("ROLE_SIZE", s) || s.equalsIgnoreCase("MARKERSIZE") || s.equalsIgnoreCase("SIZE")) {
            return 19;
        }
        if (this.roles.equalsRoleNLSName("ROLE_COLOR", s) || s.equalsIgnoreCase("MARKERCOLOR") || s.equalsIgnoreCase("COLOR")) {
            return 2;
        }
        if (this.roles.equalsRoleNLSName("ROLE_OPACITY", s) || s.equalsIgnoreCase("MARKEROPACITY") || s.equalsIgnoreCase("OPACITY")) {
            return 11;
        }
        if (this.roles.equalsRoleNLSName("ROLE_TRANSPARENCY", s) || s.equalsIgnoreCase("MARKERTRANSPARENCY") || s.equalsIgnoreCase("TRANSPARENCY")) {
            return 52;
        }
        if (this.roles.equalsRoleNLSName("ROLE_LABEL", s) || s.equalsIgnoreCase("MARKERLABEL") || s.equalsIgnoreCase("LABEL")) {
            return 8;
        }
        if (this.roles.equalsRoleNLSName("ROLE_SHAPE", s) || s.equalsIgnoreCase("MARKERSHAPE") || s.equalsIgnoreCase("SHAPE") || s.equals("MARKERTYPE") || s.equals("TYPE")) {
            return 18;
        }
        if (this.roles.equalsRoleNLSName("ROLE_GROUP", s) || s.equalsIgnoreCase("GROUP")) {
            return 6;
        }
        if (this.roles.equalsRoleNLSName("ROLE_URL", s) || s.equalsIgnoreCase("URL")) {
            return 41;
        }
        if (this.roles.equalsRoleNLSName("ROLE_GROUP_INDEX", s) || s.equalsIgnoreCase("GROUP INDEX")) {
            return 7;
        }
        if (this.roles.equalsRoleNLSName("ROLE_ERROR_LOW", s) || s.equalsIgnoreCase("ERROR LOW") || s.equalsIgnoreCase("LOW")) {
            return 4;
        }
        if (this.roles.equalsRoleNLSName("ROLE_ERROR_HIGH", s) || s.equalsIgnoreCase("ERROR HIGH") || s.equalsIgnoreCase("HIGH") || s.equalsIgnoreCase("ERROR")) {
            return 5;
        }
        if (this.roles.equalsRoleNLSName("ROLE_BAND", s) || s.equalsIgnoreCase("BAND")) {
            return 54;
        }
        if (this.roles.equalsRoleNLSName("ROLE_UPPER_BAND", s) || s.equalsIgnoreCase("UPPER BAND")) {
            return 56;
        }
        if (this.roles.equalsRoleNLSName("ROLE_LOWER_BAND", s) || s.equalsIgnoreCase("LOWER BAND")) {
            return 57;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setAreaFillColor(Object color) {
        if (!this.verifyAreaFillColor(color)) {
            return false;
        }
        if (color == null) {
            this.areaFillColor = null;
        } else if (color instanceof Color) {
            this.areaFillColor = (Color)color;
        } else {
            if (!(color instanceof String)) return false;
            Color c = ColorParse.getColorFromString((String)((String)color));
            if (c == null) return false;
            this.areaFillColor = c;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public String[] getMarkerTypes() {
        return this.getMarkerShapes();
    }

    @Override
    public String[] getMarkerShapes() {
        return this.shapeList;
    }

    @Override
    public boolean isChartBorderOn() {
        return this.scatterDefaults.chartBorderOn;
    }

    @Override
    public void setChartBorderOn(boolean on) {
        this.scatterDefaults.chartBorderOn = on;
    }

    @Override
    public Color getChartBorderColor() {
        return this.chartBorderColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setChartBorderColor(Object color) {
        if (color == null) {
            return false;
        }
        if (color instanceof Color) {
            this.chartBorderColor = (Color)color;
            return true;
        } else {
            if (!(color instanceof String)) return false;
            Color c = ColorParse.getColorFromString((String)((String)color));
            if (c == null) return false;
            this.chartBorderColor = c;
        }
        return true;
    }

    @Override
    public int getChartBorderLineWidth() {
        return this.chartBorderLineWidth;
    }

    @Override
    public boolean setChartBorderLineWidth(int newWidth) {
        if (newWidth <= 0) {
            return false;
        }
        this.redrawRequired = true;
        this.chartBorderLineWidth = newWidth;
        return true;
    }

    @Override
    public ColorInterface getColorRamp() {
        return this.clrRamp;
    }

    @Override
    public ColorInterface getColorRamp(boolean discrete) {
        if (discrete) {
            return this.disRamp;
        }
        return this.contRamp;
    }

    @Override
    public boolean setColorRamp(Object ramp) {
        if (!this.setColorRamp(ramp, false)) {
            return false;
        }
        return this.setColorRamp(ramp, true);
    }

    @Override
    public boolean setColorRamp(Object ramp, boolean discrete) {
        if (!(ramp instanceof ColorInterface)) {
            return false;
        }
        if (discrete) {
            this.disRamp = (ColorInterface)ramp;
        } else {
            this.contRamp = (ColorInterface)ramp;
        }
        if ((this.markerColor instanceof String || this.groupVariable != null) && this.clrRamp == ramp) {
            this.rebuildRequired = true;
        }
        return true;
    }

    @Override
    public AlphaInterface getAlphaRamp() {
        return this.alphaRamp;
    }

    @Override
    public boolean setAlphaRamp(Object ramp) {
        if (!(ramp instanceof AlphaInterface)) {
            return false;
        }
        this.alphaRamp = (AlphaInterface)ramp;
        if (this.markerOpacity instanceof String) {
            this.rebuildRequired = true;
        }
        return true;
    }

    @Override
    public Color getDefaultMarkerColor() {
        return this.defaultMarkerColor;
    }

    @Override
    public boolean setDefaultMarkerColor(Color c) {
        if (c == null) {
            return false;
        }
        this.defaultMarkerColor = c;
        return true;
    }

    @Override
    public Object getValue(String role, String type) {
        boolean min = false;
        int slot = -1;
        Double out = null;
        if (role == null || type == null) {
            return null;
        }
        if (this.roles.equalsRoleNLSName("ROLE_X", role) || role.equalsIgnoreCase("Category") || role.equalsIgnoreCase("X") || role.equalsIgnoreCase("Horizontal") || role.equalsIgnoreCase("Independent")) {
            slot = 0;
        } else if (this.roles.equalsRoleNLSName("ROLE_Y", role) || role.equalsIgnoreCase("Response") || role.equalsIgnoreCase("Y") || role.equalsIgnoreCase("Vertical") || role.equalsIgnoreCase("Dependent")) {
            slot = 1;
        } else if ((this.roles.equalsRoleNLSName("ROLE_SIZE", role) || role.equalsIgnoreCase("MarkerSize") || role.equalsIgnoreCase("Size")) && this.markerSize instanceof String) {
            slot = 2;
        } else if ((this.roles.equalsRoleNLSName("ROLE_OPACITY", role) || role.equalsIgnoreCase("MarkerOpacity") || role.equalsIgnoreCase("Opacity")) && this.markerOpacity instanceof String) {
            slot = 4;
        }
        if (type.equalsIgnoreCase("Min")) {
            min = true;
        }
        switch (slot) {
            default: {
                return null;
            }
            case 0: {
                if (this.categoryIsCharacter) {
                    if (this.catMinMax == null) {
                        return null;
                    }
                    if (min) {
                        return this.catMinMax[0];
                    }
                    return this.catMinMax[1];
                }
            }
            case 1: {
                if (!this.responseIsCharacter) break;
                if (this.respMinMax == null) {
                    return null;
                }
                if (min) {
                    return this.respMinMax[0];
                }
                return this.respMinMax[1];
            }
            case 2: 
            case 4: 
        }
        double d = min ? this.dataMin[slot] : this.dataMax[slot];
        out = new Double(d);
        return out;
    }

    @Override
    public boolean isCoalesceOn() {
        return this.scatterDefaults.coalesceOn;
    }

    @Override
    public void setCoalesceOn(boolean on) {
        this.scatterDefaults.coalesceOn = on;
        if (Double.isNaN(this.coalesceDistance)) {
            this.setCoalesceDistance(Double.NaN);
        }
        this.rebuildRequired = true;
    }

    @Override
    public double getCoalesceDistance() {
        return this.coalesceDistance;
    }

    @Override
    public boolean setCoalesceDistance(double distance) {
        if (Double.isNaN(distance)) {
            double range = this.getCoalesceRange();
            if (Double.isNaN(range)) {
                return false;
            }
            distance = 0.05 * range;
        }
        if (Double.isInfinite(distance) || distance < 0.0) {
            return false;
        }
        this.coalesceDistance = distance;
        this.ourDataChanged = true;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public String getCoalesceStatistic() {
        String s;
        if (this.markerSize == null || !(this.markerSize instanceof String)) {
            return this.freqNLS;
        }
        switch (this.coalesceStatistic) {
            default: {
                s = this.freqNLS;
                break;
            }
            case 2: {
                s = this.sumNLS;
                break;
            }
            case 3: {
                s = this.meanNLS;
            }
        }
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setCoalesceStatistic(Object stat) {
        int i;
        if (stat == null) {
            return false;
        }
        if (stat instanceof String) {
            if (((String)stat).equalsIgnoreCase("Frequency") || ((String)stat).equalsIgnoreCase(this.freqNLS)) {
                i = 1;
            } else if (((String)stat).equalsIgnoreCase("Sum") || ((String)stat).equalsIgnoreCase(this.sumNLS)) {
                i = 3;
            } else {
                if (!((String)stat).equalsIgnoreCase("Mean") && !((String)stat).equalsIgnoreCase(this.meanNLS)) return false;
                i = 2;
            }
        } else {
            if (!(stat instanceof Number)) return false;
            i = ((Number)stat).intValue();
        }
        if (i != 1 && this.markerSize == null || !(this.markerSize instanceof String)) {
            return false;
        }
        switch (i) {
            default: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
        }
        this.coalesceStatistic = i;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public boolean areMarkerShadowsOn() {
        return this.scatterDefaults.markerShadowsOn && this.markerShadowColor != null;
    }

    @Override
    public void setMarkerShadowsOn(boolean on) {
        this.scatterDefaults.markerShadowsOn = on;
        this.redrawRequired = true;
    }

    @Override
    public double getMarkerShadowSoftness() {
        return this.markerShadowSoftness;
    }

    @Override
    public boolean setMarkerShadowSoftness(double soft) {
        if (Double.isInfinite(soft) || Double.isNaN(soft) || soft < 0.0 || soft > 1.0) {
            return false;
        }
        this.markerShadowSoftness = soft;
        this.redrawRequired = true;
        return true;
    }

    @Override
    public int getMarkerShadowOffset() {
        return this.scatterDefaults.markerShadowOffset;
    }

    @Override
    public Color getMarkerShadowColor() {
        return this.markerShadowColor;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setMarkerShadowColor(Object color) {
        if (color == null) {
            return false;
        }
        if (color instanceof Color) {
            this.markerShadowColor = (Color)color;
        } else {
            if (!(color instanceof String)) return false;
            Color c = ColorParse.getColorFromString((String)((String)color));
            if (c == null) return false;
            this.markerShadowColor = c;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean setMarkerShadowOffset(int off) {
        this.scatterDefaults.markerShadowOffset = off;
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean setDataViewport(double xmin, double ymin, double xmax, double ymax) {
        if (Double.isNaN(xmin) && Double.isNaN(ymin) && Double.isNaN(xmax) && Double.isNaN(ymax)) {
            return false;
        }
        if (!Double.isNaN(xmin)) {
            this.minDrawX = xmin;
        }
        if (!Double.isNaN(ymin)) {
            this.minDrawY = ymin;
        }
        if (!Double.isNaN(xmax)) {
            this.maxDrawX = xmax;
        }
        if (!Double.isNaN(ymax)) {
            this.maxDrawY = ymax;
        }
        this.dataViewported = true;
        return true;
    }

    @Override
    public void clearDataViewport() {
        this.dataViewported = false;
    }

    public boolean isDataViewported() {
        return this.dataViewported;
    }

    @Override
    public Object getError(Object which) {
        int id = -1;
        Object out = null;
        if (which == null) {
            return null;
        }
        if (which instanceof Number) {
            id = ((Number)which).intValue();
        } else if (which instanceof String) {
            if (this.roles.equalsRoleNLSName("ROLE_ERROR_LOW", (String)which) || ((String)which).equalsIgnoreCase("LOW") || ((String)which).equalsIgnoreCase("ERROR LOW")) {
                id = 1;
            } else if (this.roles.equalsRoleNLSName("ROLE_ERROR_HIGH", (String)which) || ((String)which).equalsIgnoreCase("HIGH") || ((String)which).equalsIgnoreCase("ERROR HIGH") || ((String)which).equalsIgnoreCase("ERROR")) {
                id = 2;
            }
        } else {
            return null;
        }
        switch (id) {
            case 1: {
                out = this.respErrorLow;
                break;
            }
            case 2: {
                out = this.respErrorHigh;
            }
        }
        return out;
    }

    @Override
    public boolean setError(Object which, Object error) {
        int id = -1;
        int irole = 5;
        Object oldVar = null;
        if (error != null && !this.verifyVariableId(error, true)) {
            return false;
        }
        if (error != null && !this.dataFilter.isNumericVariable(error)) {
            return false;
        }
        if (which == null) {
            return false;
        }
        if (which instanceof Number) {
            id = ((Number)which).intValue();
        } else if (which instanceof String) {
            if (((String)which).equalsIgnoreCase("LOW") || ((String)which).equalsIgnoreCase("ERROR LOW")) {
                id = 1;
            }
            if (((String)which).equalsIgnoreCase("HIGH") || ((String)which).equalsIgnoreCase("ERROR HIGH") || ((String)which).equalsIgnoreCase("ERROR")) {
                id = 2;
            }
        } else {
            return false;
        }
        switch (id) {
            default: {
                return false;
            }
            case 1: {
                oldVar = this.respErrorLow;
                irole = 4;
                this.respErrorLow = error == null ? null : this.dataFilter.getExactVariableId(error);
                this.dataMax[5] = Double.NaN;
                this.dataMin[5] = Double.NaN;
                break;
            }
            case 2: {
                oldVar = this.respErrorHigh;
                irole = 5;
                this.respErrorHigh = error == null ? null : this.dataFilter.getExactVariableId(error);
                this.dataMax[6] = Double.NaN;
                this.dataMin[6] = Double.NaN;
            }
        }
        this.haveErrorBars = this.respErrorLow != null || this.respErrorHigh != null;
        this.rebuildRequired = true;
        this.redrawRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = error == null ? 3 : 1;
            this.roleEvt.role = irole;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = error;
            this.roleEvt.oldValue = oldVar;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = null;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public LineStyleInterface getErrorBars() {
        if (this.errorBarAttribs == null && (this.errorBarAttribs = new LineAttrib(true, Color.black, 1)) == null) {
            return null;
        }
        return this.errorBarAttribs;
    }

    @Override
    public boolean setErrorBars(Object errs) {
        this.errorBarAttribs = this.getErrorBars();
        if (this.errorBarAttribs == null || errs == null) {
            return false;
        }
        if (errs instanceof Boolean) {
            this.errorBarAttribs.setVisible((Boolean)errs);
        } else if (errs instanceof Color || errs instanceof String) {
            this.errorBarAttribs.setColor(errs);
        } else if (errs instanceof Number) {
            this.errorBarAttribs.setWidth(((Number)errs).intValue());
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean areErrorBarsInFront() {
        return this.errorBarsFront;
    }

    @Override
    public void setErrorBarsInFront(boolean front) {
        this.errorBarsFront = front;
        this.redrawRequired = true;
    }

    @Override
    public boolean isBubbleStylePlot() {
        return this.isBubblePlot;
    }

    @Override
    public void setBubbleStylePlot(boolean on) {
        TextStyleInterface ti;
        this.isBubblePlot = on;
        this.setMarkerFilled(!on);
        if (this.getRole(RoleInterface.ROLE_SHAPE) == null) {
            this.setMarkerShape("CIRCLE");
        }
        if ((ti = this.getLabelText()) != null) {
            ti.setJustification(0, 0);
        }
        if (this.markerOpacity == null && this.markerSize != null && this.markerSize instanceof String) {
            this.setRole(this.markerSize, RoleInterface.ROLE_TRANSPARENCY);
        }
        if (on) {
            this.setSortOrder(RoleInterface.ROLE_SIZE, RoleInterface.ROLE_SORT_DESCENDING);
        } else {
            this.setSortOrder(RoleInterface.ROLE_SIZE, RoleInterface.ROLE_SORT_DATA);
        }
        this.rebuildRequired = true;
    }

    @Override
    public int getSmartSortLimit() {
        return this.scatterDefaults.sortLimit;
    }

    @Override
    public boolean setSmartSortLimit(int limit) {
        if (limit <= 0) {
            return false;
        }
        this.scatterDefaults.sortLimit = limit;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public int getSortAlgorithm() {
        return this.scatterDefaults.sortAlgorithm;
    }

    @Override
    public boolean setSortAlgorithm(int sort) {
        switch (sort) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                return false;
            }
        }
        this.scatterDefaults.sortAlgorithm = sort;
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public boolean isGraphedHonored() {
        return this.honorGraphed;
    }

    @Override
    public void setGraphedHonored(boolean honorit) {
        this.honorGraphed = honorit;
        this.rebuildRequired = true;
    }

    @Override
    public boolean isObsColorHonored() {
        return this.honorColors;
    }

    @Override
    public void setObsColorHonored(boolean honorit) {
        this.honorColors = honorit;
        this.redrawRequired = true;
    }

    @Override
    public boolean isUsingSimpleMarkers() {
        return this.simpleMarkers;
    }

    @Override
    public void setUseSimpleMarkers(boolean simple) {
        this.simpleMarkers = simple;
        this.rebuildRequired = true;
    }

    @Override
    public MarkerStyleInterface getMarkers(Object id) {
        return this.getMarkers(this.getJoinLineStyleIdIndex(id));
    }

    @Override
    public boolean setMarkers(Object id, Object attrib) {
        return this.setMarkers(this.getJoinLineStyleIdIndex(id), attrib);
    }

    @Override
    public boolean getUsageMode(int mode) {
        switch (mode) {
            case 2: {
                return this.singleUse;
            }
        }
        return false;
    }

    @Override
    public void setUsageMode(int mode, boolean on) {
        switch (mode) {
            case 2: {
                this.singleUse = on;
            }
        }
    }

    @Override
    public boolean getSkipMiss() {
        return this.scatterDefaults.skipMiss;
    }

    @Override
    public void setSkipMiss(boolean skip) {
        this.scatterDefaults.skipMiss = skip;
        this.redrawRequired = true;
    }

    @Override
    public Object getBaseLineValue() {
        if (this.baseLineValue == null || this.baseLineValue instanceof Number) {
            return this.baseLineValue;
        }
        double[] d = new double[2];
        if (d == null) {
            return null;
        }
        d[0] = this.getBaseLineSlope();
        d[1] = this.getBaseLineIntercept();
        return d;
    }

    @Override
    public LineStyleInterface getBaseLine() {
        if (this.baseLine == null) {
            this.baseLine = new LineAttrib(false, null, 0);
        }
        return this.baseLine;
    }

    @Override
    public boolean setBaseLine(Object value) {
        LineStyleInterface ls = this.getBaseLine();
        if (ls == null) {
            return false;
        }
        if (value == null || value instanceof Color || value instanceof String) {
            if (value == null) {
                ls.setColor(null);
            } else if (value instanceof Color) {
                ls.setColor((Color)value);
            } else {
                Color c = ColorParse.getColorFromString((String)((String)value));
                if (c == null) {
                    return false;
                }
                ls.setColor(c);
            }
        } else if (value instanceof Boolean) {
            ls.setVisible((Boolean)value);
        } else if (value instanceof Number && ((Number)value).intValue() > 0) {
            ls.setWidth(((Number)value).intValue());
        } else if (value instanceof LineStyleInterface) {
            this.baseLine = new LineAttrib((LineStyleInterface)value);
        } else {
            return false;
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean setBaseLineValue(Object base) {
        if (base == null) {
            this.baseLineValue = null;
            return true;
        }
        int type = Extract.getSourceType((Object)base);
        int n = Extract.getNumberItems((Object)base, (int)type);
        if (n <= 0) {
            return false;
        }
        switch (n) {
            case 1: {
                Object o = Extract.getObject((Object)base, (int)0, (int)type);
                if (o instanceof CustomBaseLineValueInterface) {
                    Object[] temp = new Object[2];
                    if (temp == null) {
                        return false;
                    }
                    temp[0] = o;
                    temp[1] = null;
                    this.baseLineValue = temp;
                    break;
                }
                double d = Extract.getNumeric((Object)base, (int)0, (int)type);
                if (Double.isNaN(d)) {
                    return false;
                }
                this.baseLineValue = new Double(d);
                break;
            }
            default: {
                Object o = Extract.getObject((Object)base, (int)0, (int)type);
                if (o instanceof CustomBaseLineValueInterface) {
                    Object[] temp = new Object[2];
                    if (temp == null) {
                        return false;
                    }
                    temp[0] = o;
                    temp[1] = Extract.getObject((Object)base, (int)1, (int)type);
                    this.baseLineValue = temp;
                    break;
                }
                double[] temp = new double[2];
                if (temp == null) {
                    return false;
                }
                double d = Extract.getNumeric((Object)base, (int)0, (int)type);
                if (Double.isNaN(d)) {
                    return false;
                }
                temp[0] = d;
                d = Extract.getNumeric((Object)base, (int)1, (int)type);
                if (Double.isNaN(d)) {
                    return false;
                }
                temp[1] = d;
                this.baseLineValue = temp;
            }
        }
        this.redrawRequired = true;
        return true;
    }

    @Override
    public boolean areOutlinesAutoColored() {
        return false;
    }

    @Override
    public boolean setAutoColorOutlines(boolean auto) {
        return false;
    }

    public boolean isPropertySupported(int id) {
        return this.handleProperty(id, null, false, true);
    }

    public boolean isPropertyPending(int id) {
        if (this.pendingProperties == null) {
            return false;
        }
        return this.pendingProperties.isPending(id);
    }

    public Object getPropertyValue(int idx) {
        return this.fetchProperty(idx);
    }

    public boolean setPropertyValue(int idx, Object value) {
        return this.handleProperty(idx, value, false, false);
    }

    public int getNumberPendingProperties() {
        if (this.pendingProperties == null) {
            return 0;
        }
        return this.pendingProperties.getNumberPending(null);
    }

    public boolean applyPropertyChanges() {
        return this.applyPropertyChanges(null);
    }

    public boolean applyPropertyChanges(Object source) {
        if (this.pendingProperties == null) {
            return false;
        }
        Vector v = this.pendingProperties.getChangesBySource(source);
        if (v == null || v.size() <= 0) {
            return false;
        }
        int n = v.size();
        for (int i = 0; i < n; ++i) {
            PropertyEvent pe = (PropertyEvent)v.elementAt(i);
            if (pe == null) continue;
            this.handleProperty(pe.id, pe.value, true, false);
        }
        this.pendingProperties.removeChangesBySource(source);
        if (this.isRebuildRequired()) {
            this.build(null);
        }
        return true;
    }

    public void cancelPropertyChanges() {
        this.cancelPropertyChanges(null);
    }

    public void cancelPropertyChanges(Object source) {
        if (this.pendingProperties != null) {
            this.pendingProperties.removeChangesBySource(source);
        }
    }

    public int[] getPendingChanges() {
        return this.getPendingChanges(null);
    }

    public int[] getPendingChanges(Object source) {
        if (this.pendingProperties == null) {
            return null;
        }
        return this.pendingProperties.getPending(source);
    }

    public boolean hasUserSetValue(int id) {
        boolean rc = true;
        return rc;
    }

    public Object[] getDataIds() {
        return null;
    }

    public Object getDataSource() {
        return this.getDataSource(null);
    }

    public Object getDataSource(Object id) {
        return this.dataFilter;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    public boolean setDataSource(Object source, Object id) {
        int i;
        if (source == null) {
            this.dataFilter = null;
        } else if (source instanceof DataFilterReadInterface) {
            this.dataFilter = (DataFilterReadInterface)source;
        } else {
            return false;
        }
        this.dataViewported = false;
        if (this.dataMin != null) {
            for (i = 0; i < 7; ++i) {
                this.dataMin[i] = Double.NaN;
            }
        }
        if (this.dataMax != null) {
            for (i = 0; i < 7; ++i) {
                this.dataMax[i] = Double.NaN;
            }
        }
        this.rebuildRequired = true;
        return true;
    }

    @Override
    public Object getAllVariables(Object role) {
        int n = 0;
        int count = 0;
        int irole = this.getRoleIntValue(role);
        Object[] out = null;
        switch (irole) {
            default: {
                out = this.getVariable(role);
                break;
            }
            case 17: 
            case 25: 
            case 54: 
            case 56: 
            case 57: {
                int i;
                if (this.nRespVarsTotal <= 0) break;
                block12: for (i = 0; i < this.nRespVarsTotal; ++i) {
                    if (this.isBandVariable(i)) {
                        ++count;
                    }
                    switch (irole) {
                        case 17: 
                        case 25: {
                            if (this.isBandVariable(i)) continue block12;
                            ++count;
                            continue block12;
                        }
                        case 54: 
                        case 56: 
                        case 57: {
                            if (!this.isBandVariable(i)) continue block12;
                            ++count;
                        }
                    }
                }
                if (count <= 0 || (out = new Object[count]) == null) break;
                count = 0;
                block13: for (i = 0; i < this.nRespVarsTotal; ++i) {
                    Object o = this.getResponse(i);
                    switch (irole) {
                        case 17: 
                        case 25: {
                            if (this.isBandVariable(i)) continue block13;
                            out[count++] = o;
                            continue block13;
                        }
                        case 54: 
                        case 56: 
                        case 57: {
                            if (this.isBandVariable(i)) continue block13;
                            out[count++] = o;
                        }
                    }
                }
                break;
            }
            case 22: {
                if (this.tipVariables == null || (n = this.tipVariables.size()) <= 0 || (out = new Object[n]) == null) break;
                for (int i = 0; i < n; ++i) {
                    out[i] = this.tipVariables.elementAt(i);
                }
            }
        }
        return out;
    }

    @Override
    public Object getVariable(Object role) {
        if (role == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 1: 
            case 24: {
                return this.categoryVariable;
            }
            case 17: 
            case 25: 
            case 54: 
            case 56: 
            case 57: {
                int idx;
                String s = role instanceof String ? (String)role : null;
                if (s == null || this.roles.equalsRoleNLSName("ROLE_Y", s) || s.equalsIgnoreCase("Y") || s.equalsIgnoreCase("VERTICAL") || s.equalsIgnoreCase("RESPONSE") || s.equalsIgnoreCase("DEPENDENT")) {
                    idx = 0;
                } else {
                    s = s.startsWith("RESPONSE") || s.startsWith("response") || s.startsWith("Response") ? s.substring(8) : s.substring(9);
                    try {
                        idx = Integer.parseInt(s);
                    }
                    catch (NumberFormatException e) {
                        return null;
                    }
                }
                if (this.responseVariables == null || idx < 0 || idx >= this.responseVariables.size()) {
                    return null;
                }
                switch (irole) {
                    case 17: 
                    case 25: {
                        Object o = this.getResponse(idx);
                        if (o == null) {
                            return null;
                        }
                        if (this.isBandVariable(idx)) {
                            return null;
                        }
                        return o;
                    }
                    case 54: 
                    case 56: 
                    case 57: {
                        Object o = this.getResponse(idx);
                        if (o == null) {
                            return null;
                        }
                        if (!this.isBandVariable(idx)) {
                            return null;
                        }
                        switch (irole) {
                            case 54: {
                                return o;
                            }
                            case 56: {
                                if (this.respSlotIsUpper[idx]) {
                                    return o;
                                }
                                return null;
                            }
                            case 57: {
                                if (!this.respSlotIsUpper[idx]) {
                                    return o;
                                }
                                return null;
                            }
                        }
                    }
                }
                break;
            }
            case 22: {
                if (this.tipVariables == null || this.tipVariables.size() <= 0 || this.curTipVarIdx >= this.tipVariables.size()) {
                    return null;
                }
                return this.tipVariables.elementAt(this.curTipVarIdx++);
            }
            case 19: {
                Object o = this.getMarkerSize();
                if (!(o instanceof String)) {
                    o = null;
                }
                return o;
            }
            case 2: {
                Object o = this.getMarkerColor();
                if (!(o instanceof String)) {
                    o = null;
                }
                return o;
            }
            case 11: 
            case 52: {
                Object o = this.getMarkerOpacity();
                if (!(o instanceof String)) {
                    o = null;
                }
                return o;
            }
            case 18: {
                Object o = this.markerShape;
                if (!(o instanceof String)) {
                    o = null;
                }
                return o;
            }
            case 8: {
                return this.getLabel();
            }
            case 6: {
                return this.getGroup();
            }
            case 7: {
                return this.getGroupIndex();
            }
            case 41: {
                return this.getURL();
            }
            case 5: {
                return this.getError("ERROR HIGH");
            }
            case 4: {
                return this.getError("ERROR LOW");
            }
        }
        return null;
    }

    @Override
    public Object getRole(Object variableId) {
        int n = 0;
        if ((variableId = this.getVariableId(variableId, true)) == null) {
            return null;
        }
        if (this.isEqual(variableId, this.categoryVariable)) {
            return this.roles.getRoleObject("ROLE_X");
        }
        int i = this.isOurResponseVariable(variableId);
        if (i > -1) {
            Object o = this.responseVariables.elementAt(i);
            if (o == null) {
                return null;
            }
            if (o instanceof BandData) {
                BandData bd = (BandData)o;
                if (bd.upper != null && variableId.equals(bd.upper)) {
                    return this.roles.getRoleObject("ROLE_UPPER_BAND");
                }
                if (bd.lower != null && variableId.equals(bd.lower)) {
                    return this.roles.getRoleObject("ROLE_LOWER_BAND");
                }
                return null;
            }
            return this.roles.getRoleObject("ROLE_Y");
        }
        if (this.isEqual(variableId, this.markerSize)) {
            return this.roles.getRoleObject("ROLE_SIZE");
        }
        if (this.isEqual(variableId, this.markerColor)) {
            return this.roles.getRoleObject("ROLE_COLOR");
        }
        if (this.isEqual(variableId, this.groupVariable)) {
            return this.roles.getRoleObject("ROLE_GROUP");
        }
        if (this.isEqual(variableId, this.urlVariable)) {
            return this.roles.getRoleObject("ROLE_URL");
        }
        if (this.isEqual(variableId, this.groupIndexVariable)) {
            return this.roles.getRoleObject("ROLE_GROUP_INDEX");
        }
        if (this.isEqual(variableId, this.markerOpacity)) {
            if (this.invertOpacity) {
                return this.roles.getRoleObject("ROLE_TRANSPARENCY");
            }
            return this.roles.getRoleObject("ROLE_OPACITY");
        }
        if (this.isEqual(variableId, this.markerShape)) {
            return this.roles.getRoleObject("ROLE_SHAPE");
        }
        if (this.isEqual(variableId, this.labelVariable)) {
            return this.roles.getRoleObject("ROLE_LABEL");
        }
        if (this.isEqual(variableId, this.respErrorLow)) {
            return this.roles.getRoleObject("ROLE_ERROR_LOW");
        }
        if (this.isEqual(variableId, this.respErrorHigh)) {
            return this.roles.getRoleObject("ROLE_ERROR_HIGH");
        }
        if (this.tipVariables != null) {
            n = this.tipVariables.size();
            for (i = 0; i < n; ++i) {
                if (!this.isEqual(variableId, this.tipVariables.elementAt(i))) continue;
                return this.roles.getRoleObject("ROLE_TIP");
            }
        }
        return null;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        boolean status = false;
        boolean save = this.invertOpacity;
        boolean add = false;
        boolean allowIndex = true;
        if (variableId == null || role == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                allowIndex = false;
            }
        }
        variableId = this.getVariableId(variableId, allowIndex);
        switch (irole) {
            case 1: 
            case 24: {
                status = this.setCategory(variableId);
                break;
            }
            case 17: 
            case 25: {
                status = this.setResponse(variableId, add);
                break;
            }
            case 22: {
                if (!this.verifyTip(variableId, false)) break;
                status = this.setTip(variableId);
                break;
            }
            case 19: {
                status = this.setMarkerSize(variableId);
                break;
            }
            case 2: {
                status = this.setMarkerColor(variableId);
                break;
            }
            case 52: {
                this.invertOpacity = true;
                status = this.setMarkerOpacity(variableId);
                if (status) break;
                this.invertOpacity = save;
                break;
            }
            case 11: {
                this.invertOpacity = false;
                status = this.setMarkerOpacity(variableId);
                if (status) break;
                this.invertOpacity = save;
                break;
            }
            case 8: {
                status = this.setLabel(variableId);
                break;
            }
            case 18: {
                status = this.setMarkerShape(variableId);
                break;
            }
            case 6: {
                status = this.setGroup(variableId);
                break;
            }
            case 41: {
                status = this.setURL(variableId);
                break;
            }
            case 7: {
                status = this.setGroupIndex(variableId);
                break;
            }
            case 4: {
                status = this.setError("ERROR LOW", variableId);
                break;
            }
            case 5: {
                status = this.setError("ERROR HIGH", variableId);
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                switch (irole) {
                    case 56: {
                        if (this.getFirstEmptyBand(false) < 0) break;
                        add = true;
                        break;
                    }
                    case 57: {
                        if (this.getFirstEmptyBand(true) < 0) break;
                        add = true;
                    }
                }
                status = this.setBand(role, variableId, add);
            }
        }
        return status;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        boolean allowIndex = true;
        Object s = null;
        if (role == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                allowIndex = false;
            }
        }
        variableId = this.getVariableId(variableId, allowIndex);
        switch (irole) {
            case 17: 
            case 25: {
                if (this.groupVariable != null) {
                    return this.setResponse(variableId, false);
                }
                return this.setResponse(variableId, true);
            }
            case 54: 
            case 56: 
            case 57: {
                if (this.groupVariable != null) {
                    return this.setBand(role, variableId, false);
                }
                return this.setBand(role, variableId, true);
            }
            case 22: {
                if (this.tipVariables == null) {
                    return false;
                }
                if (this.tipVariables.contains(variableId)) {
                    return true;
                }
                if (!this.verifyTip(variableId, false)) {
                    return false;
                }
                this.tipVariables.addElement(variableId);
                if (this.tipVariables.size() > 1 && this.tipText != null) {
                    this.tipText.setPattern(defTipText1 + this.tipVariables.size() + "}");
                }
                return true;
            }
        }
        return this.setRole(variableId, s);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        boolean status = false;
        boolean allowIndex = true;
        Object oldVar = null;
        if (variableId == null || role == null) {
            return false;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            default: {
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                allowIndex = false;
            }
        }
        variableId = this.getVariableId(variableId, allowIndex);
        switch (irole) {
            case 1: 
            case 24: {
                oldVar = this.categoryVariable;
                this.categoryVariable = null;
                this.ourDataChanged = true;
                this.catValues = null;
                this.catDiscrete = null;
                this.catIsExternal = false;
                this.rebuildRequired = true;
                status = true;
                if (this.roles == null || this.roleEvt == null) break;
                this.roleEvt.type = 3;
                this.roleEvt.role = 24;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = true;
                this.roleEvt.newValue = this.categoryVariable;
                this.roleEvt.oldValue = oldVar;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
                break;
            }
            case 17: 
            case 25: {
                status = this.removeResponse(variableId);
                break;
            }
            case 22: {
                this.tipVariables.removeAllElements();
                status = true;
                if (this.roles == null || this.roleEvt == null) break;
                this.roleEvt.type = 3;
                this.roleEvt.role = 22;
                this.roleEvt.isAdjusting = false;
                this.roleEvt.rangeChangeEvent = false;
                this.roleEvt.newValue = null;
                this.roleEvt.oldValue = oldVar;
                this.roleEvt.source = this;
                this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
                this.roleEvt.target = null;
                this.roles.throwRoleEvent(this.roleEvt);
                break;
            }
            case 19: {
                status = this.setMarkerSize(null);
                break;
            }
            case 2: {
                status = this.setMarkerColor(null);
                break;
            }
            case 11: 
            case 52: {
                status = this.setMarkerOpacity(null);
                break;
            }
            case 8: {
                status = this.setLabel(null);
                break;
            }
            case 18: {
                status = this.setMarkerShape(null);
                break;
            }
            case 6: {
                status = this.setGroup(null);
                break;
            }
            case 41: {
                status = this.setURL(null);
                break;
            }
            case 7: {
                status = this.setGroupIndex(null);
                break;
            }
            case 4: {
                status = this.setError("ERROR LOW", null);
                break;
            }
            case 5: {
                status = this.setError("ERROR HIGH", null);
                break;
            }
            case 54: 
            case 56: 
            case 57: {
                status = this.removeBandRole(variableId, irole);
            }
        }
        return status;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] o = null;
        o = discrete ? new Object[]{this.roles.getRoleObject("ROLE_X"), this.roles.getRoleObject("ROLE_Y"), this.roles.getRoleObject("ROLE_GROUP"), this.roles.getRoleObject("ROLE_GROUP_INDEX"), this.roles.getRoleObject("ROLE_SIZE"), this.roles.getRoleObject("ROLE_COLOR"), this.roles.getRoleObject("ROLE_SHAPE"), this.roles.getRoleObject("ROLE_ERROR_LOW"), this.roles.getRoleObject("ROLE_ERROR_HIGH"), this.roles.getRoleObject("ROLE_OPACITY"), this.roles.getRoleObject("ROLE_TRANSPARENCY"), this.roles.getRoleObject("ROLE_TIP"), this.roles.getRoleObject("ROLE_LABEL"), this.roles.getRoleObject("ROLE_URL")} : new Object[]{this.roles.getRoleObject("ROLE_SIZE"), this.roles.getRoleObject("ROLE_COLOR"), this.roles.getRoleObject("ROLE_ERROR_LOW"), this.roles.getRoleObject("ROLE_ERROR_HIGH"), this.roles.getRoleObject("ROLE_OPACITY"), this.roles.getRoleObject("ROLE_TRANSPARENCY")};
        return o;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        int slot = -1;
        Object out = null;
        if (role == null) {
            return null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 1: 
            case 24: {
                slot = 0;
                break;
            }
            case 17: 
            case 25: {
                slot = 1;
                break;
            }
            case 19: {
                slot = 2;
                break;
            }
            case 11: 
            case 52: {
                slot = 4;
                break;
            }
            case 18: {
                slot = 3;
                break;
            }
            case 4: {
                slot = 5;
                break;
            }
            case 5: {
                slot = 6;
                break;
            }
            case 6: {
                switch (which) {
                    case 0: {
                        out = this.groupMin;
                        break;
                    }
                    case 1: {
                        out = this.groupMax;
                        break;
                    }
                }
                return out;
            }
            default: {
                return null;
            }
        }
        if (this.isRebuildRequired()) {
            this.build(new Boolean(true));
        }
        switch (which) {
            case 0: {
                out = new Double(this.dataMin[slot]);
                break;
            }
            case 1: {
                out = new Double(this.dataMax[slot]);
                break;
            }
        }
        return out;
    }

    @Override
    public boolean isDiscrete(Object role) {
        int irole = this.getRoleIntValue(role);
        if (role == null) {
            irole = 24;
        }
        switch (irole) {
            case 1: 
            case 24: {
                return this.catDiscrete != null;
            }
        }
        return false;
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        int irole = this.getRoleIntValue(role);
        Boolean oldValue = new Boolean(this.catDiscrete != null);
        if (role == null) {
            irole = 24;
        }
        switch (irole) {
            case 1: 
            case 24: {
                break;
            }
            default: {
                return false;
            }
        }
        this.catDiscrete = discrete ? new SortedVector() : null;
        this.rebuildRequired = true;
        if (this.roles != null && this.roleEvt != null) {
            this.roleEvt.type = 4;
            this.roleEvt.role = 24;
            this.roleEvt.isAdjusting = false;
            this.roleEvt.rangeChangeEvent = true;
            this.roleEvt.newValue = new Boolean(discrete);
            this.roleEvt.oldValue = oldValue;
            this.roleEvt.source = this;
            this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
            this.roleEvt.target = this.categoryVariable;
            this.roles.throwRoleEvent(this.roleEvt);
        }
        return true;
    }

    @Override
    public Object getSortOrder(Object role) {
        int irole = this.getRoleIntValue(role);
        SILKNumber o = null;
        if (role == null) {
            irole = 24;
        }
        if (irole != 1 && irole != 24) {
            return this.roles.getSortObject("ROLE_SORT_DATA");
        }
        switch (this.catSorted) {
            case 1: {
                o = this.roles.getSortObject("ROLE_SORT_ASCENDING");
                break;
            }
            case -1: {
                o = this.roles.getSortObject("ROLE_SORT_DESCENDING");
                break;
            }
            default: {
                o = this.roles.getSortObject("ROLE_SORT_DATA");
            }
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setSortOrder(Object role, Object order) {
        int old;
        int irole = this.getRoleIntValue(role);
        int in = 0;
        if (role == null) {
            irole = 24;
        }
        if (irole != 1 && irole != 24 && irole != 19) {
            return false;
        }
        if (order == null) {
            return false;
        }
        if (order instanceof Number) {
            in = ((Number)order).intValue();
        } else {
            if (!(order instanceof String)) return false;
            String s = (String)order;
            if (this.roles.equalsSortNLSName("ROLE_SORT_DATA", s) || s.equalsIgnoreCase("Data")) {
                in = 0;
            } else if (this.roles.equalsSortNLSName("ROLE_SORT_ASCENDING", s) || s.equalsIgnoreCase("Ascending")) {
                in = 1;
            } else {
                if (!this.roles.equalsSortNLSName("ROLE_SORT_DESCENDING", s) && !s.equalsIgnoreCase("Descending")) return false;
                in = -1;
            }
        }
        if (!this.verifySortedOrder(in)) {
            return false;
        }
        switch (irole) {
            default: {
                if (this.catSorted == in) {
                    return true;
                }
                old = this.catSorted = in;
                break;
            }
            case 19: {
                if (this.sizeSorted == in) {
                    return true;
                }
                old = this.sizeSorted = in;
            }
        }
        this.rebuildRequired = true;
        switch (irole) {
            case 1: 
            case 24: {
                this.dataMax[0] = Double.NaN;
                this.dataMin[0] = Double.NaN;
                break;
            }
            case 19: {
                this.dataMax[2] = Double.NaN;
                this.dataMin[2] = Double.NaN;
            }
        }
        if (this.roles == null || this.roleEvt == null) return true;
        this.roleEvt.type = 5;
        this.roleEvt.role = 24;
        this.roleEvt.isAdjusting = false;
        this.roleEvt.rangeChangeEvent = true;
        this.roleEvt.newValue = new Integer(this.catSorted);
        this.roleEvt.oldValue = new Integer(old);
        this.roleEvt.source = this;
        this.roleEvt.dataSource = this.dataFilter == null ? null : this.dataFilter.getSource();
        this.roleEvt.target = null;
        this.roles.throwRoleEvent(this.roleEvt);
        return true;
    }

    @Override
    public int getMaxAllowed(Object role) {
        if (role == null) {
            return 0;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 17: 
            case 22: 
            case 25: {
                return 100;
            }
        }
        return 1;
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        if (role == null) {
            return this.getGroup() == null;
        }
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 17: 
            case 25: 
            case 54: 
            case 56: 
            case 57: {
                return this.getGroup() == null;
            }
            case 22: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
        if (this.roles == null) {
            return;
        }
        this.roles.addRoleListener(listener);
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
        if (this.roles == null) {
            return;
        }
        this.roles.removeRoleListener(listener);
    }

    @Override
    public Object getLimit(Object role) {
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 6: {
                return this.scatterDefaults == null ? null : new Integer(this.scatterDefaults.maxGroups);
            }
        }
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        int irole = this.getRoleIntValue(role);
        switch (irole) {
            case 6: {
                int n;
                if (this.scatterDefaults == null || value == null || !(value instanceof Number) || (n = ((Number)value).intValue()) < 0) break;
                this.scatterDefaults.maxGroups = n;
                this.rebuildRequired = true;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        return new Object[][]{{this.roles.getRoleObject("ROLE_X")}};
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (this.roles.getRoleObject("ROLE_X").equals(role) && (this.isDiscrete((Object)this.roles.getRoleObject("ROLE_X")) || this.isVariableIdCharacter(this.categoryVariable))) {
            return new int[]{1, -1, 0};
        }
        return null;
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    protected int getStandardMarkerShape(Object shape) {
        if (shape instanceof String) {
            int markerInt = -1;
            String s = shape.toString();
            if (this.shapeList != null || this.englishShapeList != null) {
                int i;
                if (this.shapeList != null) {
                    for (i = 0; i < this.shapeList.length; ++i) {
                        if (!s.equalsIgnoreCase(this.shapeList[i])) continue;
                        markerInt = i;
                        break;
                    }
                }
                if (markerInt == -1 && this.englishShapeList != null) {
                    for (i = 0; i < this.englishShapeList.length; ++i) {
                        if (!s.equalsIgnoreCase(this.englishShapeList[i])) continue;
                        markerInt = i;
                        break;
                    }
                }
            }
            return this.getStandardMarkerShape(markerInt);
        }
        if (shape instanceof Number) {
            return this.getStandardMarkerShape(((Number)shape).intValue());
        }
        return 19;
    }

    protected int getStandardMarkerShape(int shape) {
        switch (shape) {
            case 0: {
                return 16;
            }
            case 1: {
                return 16;
            }
            case 2: {
                return 17;
            }
            case 3: {
                return 22;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 19;
            }
            case 6: {
                return 18;
            }
        }
        return 19;
    }

    class BandData {
        public Object upper;
        public Object lower;

        public BandData(Object upper, Object lower) {
            this.upper = upper;
            this.lower = lower;
        }
    }

    class GroupData
    implements SortKeyInterface {
        public static final int BAND_START = 0;
        public static final int BAND_END = 1;
        public static final int BAND_OPEN = 2;
        public static final int BAND_CONST = 3;
        protected boolean isBand;
        protected int bandType;
        protected int idx;
        protected double bandValue;
        protected Object value;
        protected Object label;
        protected Color color;
        protected Vector markers;
        protected PickAreaList pa;
        protected int[] sortIndicies;

        public GroupData(boolean isBandIn, int bandTypeIn, int idxIn, double bandValueIn, Object valueIn, Object labelIn, Color colorIn) {
            this.isBand = isBandIn;
            this.bandType = bandTypeIn;
            this.idx = idxIn;
            this.bandValue = bandValueIn;
            this.value = valueIn;
            this.label = labelIn;
            this.color = colorIn;
            this.sortIndicies = null;
            this.pa = new PickAreaList();
            this.markers = new Vector();
        }

        public GroupData(Object valueIn, Object labelIn) {
            this(false, -1, -1, Double.NaN, valueIn, labelIn, null);
        }

        public boolean isBand() {
            return this.isBand;
        }

        public int getType() {
            return this.bandType;
        }

        public void setBand(boolean band) {
            this.isBand = band;
        }

        public int getIndex() {
            return this.idx;
        }

        public void setIndex(int idxIn) {
            this.idx = idxIn;
        }

        public Object getLabel() {
            return this.label;
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color c) {
            this.color = c;
        }

        public double getBandValue() {
            return this.bandValue;
        }

        public void setBandValue(double v) {
            this.bandValue = v;
        }

        public void addMarker(Object marker) {
            if (this.markers != null) {
                this.markers.addElement(marker);
            }
        }

        public int getNumberMarkers() {
            return this.markers == null ? 0 : this.markers.size();
        }

        public Vector getMarkers() {
            return this.markers;
        }

        public PickAreaList getPickAreaList() {
            return this.pa;
        }

        public void setPickAreaList(PickAreaList paIn) {
            this.pa = paIn;
        }

        public int[] createSortIndicies() {
            int size = 0;
            if (this.markers == null) {
                return null;
            }
            size = this.markers.size();
            if (size <= 0) {
                return null;
            }
            this.sortIndicies = new int[size];
            if (this.sortIndicies == null) {
                return null;
            }
            for (int i = 0; i < size; ++i) {
                this.sortIndicies[i] = i;
            }
            return this.sortIndicies;
        }

        public int[] getSortIndicies() {
            return this.sortIndicies;
        }

        public double getNumericKeyValue() {
            if (this.value == null) {
                return Double.NaN;
            }
            return ((Number)this.value).doubleValue();
        }

        public Object getKeyValue() {
            return this.value;
        }

        public int getKeyType() {
            if (this.value instanceof String) {
                return 1;
            }
            return 0;
        }
    }
}

