/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import java.awt.Point;
import java.awt.Rectangle;

public class PickAreaList {
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected int halfWidth;
    protected int halfHeight;
    protected int qtrWidth;
    protected int qtrHeight;
    protected int minSize;
    protected int growSize;
    protected int[] temp;
    protected int[][] counts;
    protected int[][][] sectors;

    public PickAreaList(int x, int y, int w, int h, int minSize, int growSize) {
        this.minSize = Math.max(minSize, 0);
        this.growSize = Math.max(growSize, 1);
        this.setBounds(x, y, w, h);
        this.counts = new int[4][4];
        this.temp = new int[2];
        this.clearCounts();
        this.sectors = new int[4][4][];
    }

    public PickAreaList(int w, int h) {
        this(0, 0, w, h, 100, 100);
    }

    public PickAreaList() {
        this(0, 0, 0, 0, 100, 100);
    }

    protected int getNumberSlots(int ix, int iy) {
        if (this.sectors[ix][iy] == null) {
            return 0;
        }
        return this.sectors[ix][iy].length;
    }

    protected boolean grow(int ix, int iy, int requiredSize) {
        int n = this.getNumberSlots(ix, iy);
        if (n >= requiredSize) {
            return true;
        }
        if (n == 0) {
            this.sectors[ix][iy] = new int[Math.max(requiredSize, this.minSize)];
            if (this.sectors[ix][iy] == null) {
                return false;
            }
        } else if (n < requiredSize) {
            int[] temp = new int[n + this.growSize];
            if (temp == null) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                temp[i] = this.sectors[ix][iy][i];
            }
            this.sectors[ix][iy] = temp;
            temp = null;
        }
        return true;
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.halfWidth = width / 2;
        this.qtrWidth = width / 4;
        this.halfHeight = height / 2;
        this.qtrHeight = height / 4;
    }

    public void setBounds(Rectangle r) {
        if (r == null) {
            return;
        }
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void clearCounts() {
        if (this.counts == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.counts[i][j] = 0;
            }
        }
    }

    public void getSector(int x, int y, int[] idx) {
        int ix = x - this.x;
        int iy = y - this.y;
        idx[0] = ix < this.qtrWidth ? 0 : (ix > this.width - this.qtrWidth ? 3 : (ix < this.halfWidth ? 1 : 2));
        idx[1] = iy < this.qtrHeight ? 0 : (iy > this.height - this.qtrHeight ? 3 : (iy < this.halfHeight ? 1 : 2));
    }

    public void getSector(Point p, int[] idx) {
        this.getSector(p.x, p.y, idx);
    }

    public boolean getSectors(Rectangle rect, boolean[][] use) {
        if (rect == null || use == null) {
            return false;
        }
        this.getSector(rect.x, rect.y, this.temp);
        int startX = this.temp[0];
        int startY = this.temp[1];
        this.getSector(rect.x + rect.width, rect.y + rect.height, this.temp);
        int endX = this.temp[0];
        int endY = this.temp[1];
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                use[i][j] = i >= startX && i <= endX && j >= startY && j <= endY;
            }
        }
        return true;
    }

    public void addPoint(int x, int y, int obs) {
        this.getSector(x, y, this.temp);
        int ix = this.temp[0];
        int iy = this.temp[1];
        this.grow(ix, iy, this.counts[ix][iy] + 1);
        this.sectors[ix][iy][this.counts[ix][iy]] = obs;
        int[] nArray = this.counts[ix];
        int n = iy;
        nArray[n] = nArray[n] + 1;
    }

    public int getNextObsInSector(int ix, int iy, int idx) {
        if (ix < 0 || ix > 3 || ix < 0 || ix > 3 || this.sectors == null || idx < 0 || idx >= this.counts[ix][iy]) {
            return -1;
        }
        return this.sectors[ix][iy][idx];
    }
}

