/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.scatter;

import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.HControl;
import com.sas.graphics.silk.util.Marker;
import com.sas.graphics.silk.util.Vect2d;
import java.awt.Graphics;
import java.util.Vector;

public class Hermite {
    protected int numSegs;
    protected double[] temp = new double[3];
    protected double[] h0;
    protected double[] h1;
    protected double[] h2;
    protected double[] h3;

    Hermite(int numsegsIn) {
        this.setNumberSegments(numsegsIn);
    }

    public Hermite() {
        this(8);
    }

    public int getNumberSegments() {
        return this.numSegs;
    }

    public boolean setNumberSegments(int numSegsIn) {
        double u = 0.0;
        if (numSegsIn <= 0) {
            return false;
        }
        this.numSegs = numSegsIn;
        --this.numSegs;
        double du = 1.0 / (double)this.numSegs;
        this.h0 = new double[this.numSegs];
        this.h1 = new double[this.numSegs];
        this.h2 = new double[this.numSegs];
        this.h3 = new double[this.numSegs];
        for (int i = 0; i < this.numSegs; ++i) {
            double u2 = (u += du) * u;
            double u3 = u2 * u;
            this.h0[i] = 2.0 * u3 - 3.0 * u2 + 1.0;
            this.h1[i] = -2.0 * u3 + 3.0 * u2;
            this.h2[i] = u3 - 2.0 * u2 + u;
            this.h3[i] = u3 - u2;
        }
        return true;
    }

    protected HControl getKnot(Vector mkrList, int idx) {
        Marker mkr = (Marker)mkrList.elementAt(idx);
        if (mkr == null) {
            return null;
        }
        return (HControl)mkr.getKnot();
    }

    public void drawCurve(Graphics g, TransformInterface transObj, Vector mkrList, int[] indicies, int nMkrs) {
        if (g == null || transObj == null || this.temp == null) {
            return;
        }
        int numHsegs = nMkrs - 1;
        HControl CurrPt = null;
        HControl NextPt = null;
        for (int im = 0; im < nMkrs; ++im) {
            int i = indicies != null ? indicies[im] : im;
            HControl knot = this.getKnot(mkrList, i);
            if (knot == null) continue;
            if (CurrPt == null) {
                CurrPt = knot;
                continue;
            }
            if (NextPt == null) {
                NextPt = knot;
            }
            for (i = 0; i < numHsegs; ++i) {
                this.drawCurveSegment(g, transObj, CurrPt, NextPt);
            }
            CurrPt = NextPt;
            NextPt = null;
        }
    }

    protected Vect2d add(Vect2d v1, Vect2d v2) {
        return v1.add(v2);
    }

    protected Vect2d add(Vect2d v1, Vect2d v2, Vect2d v3, Vect2d v4) {
        return this.add(this.add(v1, v2), this.add(v3, v4));
    }

    protected void drawCurveSegment(Graphics g, TransformInterface transObj, HControl A, HControl B) {
        Vect2d currPt = A.Pt;
        for (int j = 0; j < this.numSegs; ++j) {
            Vect2d nextPt = this.add(A.Pt.multiply(this.h0[j]), B.Pt.multiply(this.h1[j]), A.Tang.multiply(this.h2[j]), B.Tang.multiply(this.h3[j]));
            this.line(g, transObj, currPt.x, currPt.y, nextPt.x, nextPt.y);
            currPt = nextPt;
        }
        this.line(g, transObj, currPt.x, currPt.y, B.Pt.x, B.Pt.y);
    }

    protected void line(Graphics g, TransformInterface transObj, double x1, double y1, double x2, double y2) {
        transObj.project(x1, y1, 0.0, this.temp);
        int ix = (int)this.temp[0];
        int iy = (int)this.temp[1];
        transObj.project(x2, y2, 0.0, this.temp);
        int ix2 = (int)this.temp[0];
        int iy2 = (int)this.temp[1];
        g.drawLine(ix, iy, ix2, iy2);
    }
}

