/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.pie;

import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.LegendEntryInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.URLConsumerInterface;
import com.sas.graphics.silk.pie.ArcInfoItem;
import com.sas.graphics.silk.pie.PieDataModel;
import com.sas.graphics.silk.pie.PieDefaults;
import com.sas.graphics.silk.pie.Slice;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.Text;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.FillPattern;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;

public class SliceRenderer {
    private PieDataModel model = null;
    private Hashtable globalSliceColors = new Hashtable();
    private boolean sliceColorsComputed = false;
    private Point center;
    private double radius;
    private Hashtable angleLists = new Hashtable();
    private Hashtable arcLists = new Hashtable();
    private boolean angleListsComputed = false;
    private Style style = null;
    public Text labels = null;
    private boolean outlinesVisible = true;
    private int outlineThickness = 1;
    private Dimension[] outerLabelBounds = null;
    private String nameLabelPosition = "Outside";
    private String dataLabelPosition = "Arrow";
    private String percentLabelPosition = "None";
    ResourceBundle rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.pie.silk_pie_NLS");
    private int maxLabelWidth = 100;
    private int realMaxLabelWidth = 0;
    private PieDefaults pieDefaults = null;
    private boolean treatOpacityValueAsTransparency = false;
    private int pieDirection;
    private int startAngle = 0;
    private Vector urlConsumers = new Vector();
    private int labelScheme = 0;
    private int defaultLabelScheme = 1;
    private Rectangle componentBounds = null;
    private Hashtable ringBounds = new Hashtable();
    private boolean ringBoundsComputed = false;
    private int ringSeperation = 5;
    private boolean shapesComputed = false;
    private boolean drawGroupLabels = true;
    private int groupLabelAreaWidth = 0;
    private String otherLabel;
    private Point2D[] startPoints;
    private Point2D[] endPoints;
    protected GlobalDefaults globalDefaults = new GlobalDefaults();
    static final int labelHeightSeperationAtMargin = 12;
    static final double centerAngleConstraintForLabel = 60.0;
    private int labelCompsMask = 1;
    private String labelPos = "INSIDE";
    private String labelSeparator;
    private static final int ABOVE_PIE = 0;
    private static final int BELOW_PIE = 1;
    private static final int TOP_RIGHT_QUADRANT = 2;
    private static final int TOP_LEFT_QUADRANT = 3;
    private static final int BOTTOM_RIGHT_QUADRANT = 4;
    private static final int BOTTOM_LEFT_QUADRANT = 5;
    private static final int LEFT_OF_PIE = 6;
    private static final int RIGHT_OF_PIE = 7;
    static final double BRIGHTNESS_LOWER_BOUND = 0.45;

    public SliceRenderer(PieDataModel modelIn) {
        this.style = (Style)SILKGlobal.getInstance().getPropertyValue(29);
        this.model = modelIn;
        this.pieDefaults = new PieDefaults();
        this.labels = new Text();
        this.labels.setFormatSupported(false);
        this.labels.setJustifySupported(false);
        this.pieDirection = this.pieDefaults.pieDirection;
        this.startAngle = this.pieDefaults.startAngle;
        this.labelSeparator = modelIn.getDefaultLabelSeparator();
        this.otherLabel = ResourceLoader.getResourceString((Object)this.rb, (String)"SliceRenderer.Other.txt", (String)"Other");
        this.setStyle((Style)SILKGlobal.getInstance().getPropertyValue(29));
    }

    public void dispose() {
        this.model = null;
        this.center = null;
        this.style = null;
        this.labels = null;
        this.outerLabelBounds = null;
        this.urlConsumers = null;
    }

    public void reset() {
        this.outerLabelBounds = null;
        this.sliceColorsComputed = false;
        this.ringBoundsComputed = false;
        this.angleListsComputed = false;
        this.shapesComputed = false;
    }

    public void paintSelections(Graphics2D g) {
        if (this.center == null || this.angleLists == null || this.model == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Stroke oldStroke = g.getStroke();
        if (this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
            g.setStroke(new BasicStroke(this.outlineThickness + 4, 1, 2, 0.0f, null, 0.0f));
        } else {
            g.setStroke(new BasicStroke(Math.max((float)this.outlineThickness, 2.0f), 1, 2, 0.0f, null, 0.0f));
        }
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            double[] angleList = (double[])this.angleLists.get(grp);
            if (angleList == null) continue;
            double[] bounds = (double[])this.ringBounds.get(grp);
            if (bounds == null) {
                return;
            }
            int outerWidth = (int)(2.0 * bounds[1]);
            int innerWidth = (int)(2.0 * bounds[0]);
            double ringWidth = bounds[1] - bounds[0];
            int outerX = (int)((double)this.center.x - bounds[1]);
            int outerY = (int)((double)this.center.y - bounds[1]);
            int innerX = (int)((double)this.center.x - bounds[0]);
            int innerY = (int)((double)this.center.y - bounds[0]);
            Color selC = this.style.getFillStyleElement("Selection").getFillColor();
            g.setColor(selC);
            TexturePaint tp = null;
            if (!this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
                FillPattern fillPattern = new FillPattern();
                tp = fillPattern.getHatch45(selC);
            }
            for (int i = 0; i < slices.length; ++i) {
                if (slices[i].getSelectionCount() <= 0) continue;
                int start = (int)Math.round(angleList[i]);
                int end = (int)Math.round(angleList[i + 1]);
                GeneralPath path = null;
                double percent = (double)slices[i].getSelectionCount() / (double)slices[i].getObservationCount();
                int selectionHeight = (int)(ringWidth * percent);
                int selectionRadius = (int)bounds[0] + selectionHeight;
                outerX = this.center.x - selectionRadius;
                outerY = this.center.y - selectionRadius;
                outerWidth = (int)(2.0 * (bounds[0] + (double)selectionHeight));
                Arc2D.Double outerArc = new Arc2D.Double(outerX, outerY, outerWidth, outerWidth, (double)this.startAngle + (double)start, end - start, 0);
                Arc2D.Double innerArc = new Arc2D.Double(innerX, innerY, innerWidth, innerWidth, (double)this.startAngle + (double)start + (double)(end - start), -(end - start), 0);
                path = new GeneralPath();
                if (slices.length == 1) {
                    path.append(outerArc, false);
                    path.append(innerArc, false);
                } else {
                    path.append(outerArc, false);
                    path.append(innerArc, true);
                }
                path.closePath();
                if (path == null) continue;
                if (this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
                    g.draw(path);
                    continue;
                }
                g.setPaint(tp);
                g.fill(path);
                g.setPaint(selC);
                g.draw(path);
            }
        }
        g.setStroke(oldStroke);
    }

    public String getLabelPosition() {
        return this.labelPos;
    }

    public void setLabelPosition(String labelPos) {
        if (!(labelPos.equalsIgnoreCase("INSIDE") || labelPos.equalsIgnoreCase("OUTSIDE") || labelPos.equalsIgnoreCase("MARGIN") || labelPos.equalsIgnoreCase("BESTFIT"))) {
            return;
        }
        this.labelPos = labelPos;
    }

    public void setLabelSeparator(String sep) {
        this.labelSeparator = sep;
    }

    public String getLabelSeparator() {
        return this.labelSeparator;
    }

    public int getLabelCompMask() {
        return this.labelCompsMask;
    }

    public void setLabelCompMask(int mask) {
        this.labelCompsMask = mask;
    }

    private void computeRingBounds() {
        if (this.model == null || this.model.getNumGroups() == 0) {
            return;
        }
        this.ringBounds = new Hashtable();
        int numGroups = this.model.getNumGroups();
        this.ringSeperation = 5;
        while ((double)(numGroups * this.ringSeperation) > this.radius * 0.2 && this.ringSeperation > 1) {
            --this.ringSeperation;
            this.radius += (double)(this.ringSeperation * 2);
        }
        double ringWidth = this.radius / (double)numGroups;
        if (this.model.getAllGroupsCount() > 1) {
            ringWidth -= (double)this.ringSeperation;
        }
        Enumeration e = this.model.getGroups();
        int num = this.model.getNumGroups();
        double currentRadius = this.radius - (double)num * ringWidth;
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            double end = currentRadius;
            double start = currentRadius + ringWidth;
            currentRadius = start + (double)this.ringSeperation;
            this.ringBounds.put(grp, new double[]{start, end});
        }
        this.ringBoundsComputed = true;
    }

    private void buildShapes() {
        if (this.model == null || this.model.getNumGroups() == 0) {
            return;
        }
        if (!this.ringBoundsComputed) {
            this.computeRingBounds();
        }
        if (!this.ringBoundsComputed) {
            return;
        }
        if (!this.angleListsComputed) {
            this.buildAngleLists();
        }
        if (!this.angleListsComputed) {
            return;
        }
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            double[] angleList = (double[])this.angleLists.get(grp);
            if (angleList == null) continue;
            double[] bounds = (double[])this.ringBounds.get(grp);
            int outerWidth = (int)(2.0 * bounds[1]);
            int innerWidth = (int)(2.0 * bounds[0]);
            int outerX = (int)((double)this.center.x - bounds[1]);
            int outerY = (int)((double)this.center.y - bounds[1]);
            int innerX = (int)((double)this.center.x - bounds[0]);
            int innerY = (int)((double)this.center.y - bounds[0]);
            this.startPoints = new Point2D[slices.length];
            this.endPoints = new Point2D[slices.length];
            Arc2D[] innerOuterArcs = new Arc2D[slices.length * 2];
            for (int i = 0; i < slices.length; ++i) {
                int start = (int)Math.round(angleList[i]);
                int end = (int)Math.round(angleList[i + 1]);
                GeneralPath path = null;
                Arc2D.Double outerArc = new Arc2D.Double(outerX, outerY, outerWidth, outerWidth, (double)this.startAngle + (double)start, end - start, 0);
                Arc2D.Double innerArc = new Arc2D.Double(innerX, innerY, innerWidth, innerWidth, (double)this.startAngle + (double)start + (double)(end - start), -(end - start), 0);
                this.startPoints[i] = innerArc.getStartPoint();
                this.endPoints[i] = innerArc.getEndPoint();
                innerOuterArcs[2 * i] = innerArc;
                innerOuterArcs[2 * i + 1] = outerArc;
                path = new GeneralPath();
                path.append(outerArc, false);
                boolean radialConnector = true;
                if (((RectangularShape)outerArc).getWidth() == 0.0 && Math.abs(((Arc2D)innerArc).getAngleExtent()) == 360.0) {
                    radialConnector = false;
                }
                path.append(innerArc, radialConnector);
                if (((RectangularShape)outerArc).getWidth() != 0.0) {
                    path.closePath();
                }
                slices[i].setSliceShape(path);
            }
            this.arcLists.put(grp, innerOuterArcs);
        }
        this.shapesComputed = true;
    }

    public void paint(Graphics2D g, Rectangle componentBounds) {
        if (this.center == null || this.angleLists == null) {
            return;
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        String str = null;
        if (this.model == null || this.model.getNumGroups() == 0) {
            str = ResourceLoader.getResourceString((Object)this.rb, (String)"SliceRenderer.Chart_has_no_data.txt", (String)"Chart has no data.");
        } else if (this.model.isTooManyGroups()) {
            str = ResourceLoader.getResourceString((Object)this.rb, (String)"SliceRenderer.Chart_has_too_many_groups.txt", (String)"Chart has too many groups.");
        } else if (this.model.isTooManyCategories()) {
            str = ResourceLoader.getResourceString((Object)this.rb, (String)"SliceRenderer.Chart_has_too_many_categories.txt", (String)"Chart has too many categories.");
        }
        if (str != null) {
            this.center.x = componentBounds.x + componentBounds.width / 2;
            this.center.y = componentBounds.y + componentBounds.height / 2;
            Font f = g.getFont();
            g.setColor(Color.black);
            Rectangle2D rect = f.getStringBounds(str, g.getFontRenderContext());
            g.drawString(str, this.center.x - (int)rect.getWidth() / 2, this.center.y - (int)rect.getHeight() / 2);
            return;
        }
        if (!this.sliceColorsComputed) {
            this.computeSliceColors();
        }
        if (!this.shapesComputed) {
            this.buildShapes();
        }
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            for (int i = 0; i < slices.length; ++i) {
                URLConsumerInterface consumer;
                Enumeration en;
                URL url = null;
                try {
                    url = new URL(slices[i].getSliceURL());
                }
                catch (MalformedURLException me) {
                    url = null;
                }
                if (!this.urlConsumers.isEmpty()) {
                    en = this.urlConsumers.elements();
                    while (en.hasMoreElements()) {
                        consumer = (URLConsumerInterface)en.nextElement();
                        consumer.beginURL(null, url, slices[i].getDisplayName());
                    }
                }
                g.setColor(slices[i].getSliceColor());
                if (slices[i].getSliceShape() != null) {
                    g.fill(slices[i].getSliceShape());
                }
                if (this.urlConsumers.isEmpty()) continue;
                en = this.urlConsumers.elements();
                while (en.hasMoreElements()) {
                    consumer = (URLConsumerInterface)en.nextElement();
                    consumer.endURL(null);
                }
            }
            if (!this.outlinesVisible) continue;
            g.setColor(this.style.getLineStyleElement("BorderLines").getLineColor());
            Stroke oldStroke = g.getStroke();
            g.setStroke(new BasicStroke(this.outlineThickness, 0, 2, 0.0f, null, 0.0f));
            for (int i = 0; i < slices.length; ++i) {
                if (slices[i].getSliceShape() == null) continue;
                g.draw(slices[i].getSliceShape());
            }
            g.setStroke(oldStroke);
        }
        int totalGroupCount = this.model.getAllGroupsCount();
        if (totalGroupCount > 1 && this.drawGroupLabels && this.groupLabelAreaWidth > 0) {
            this.drawGroupLabels(g);
        }
        this.drawLabels(g, componentBounds);
    }

    private void drawGroupLabels(Graphics2D g) {
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        Color backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
        Rectangle area = new Rectangle(this.componentBounds.x + this.componentBounds.width - this.groupLabelAreaWidth + this.pieDefaults.labelSeperation, this.componentBounds.y + this.componentBounds.height / 2 - (int)this.radius, this.groupLabelAreaWidth - this.pieDefaults.labelSeperation, (int)(this.radius * 2.0));
        Object obj = this.model.getGroupVariableLabel();
        String group = null;
        if (obj != null) {
            group = obj.toString();
        }
        Rectangle2D titleBounds = this.labels.getStringBounds(group, frc);
        if (area.getHeight() < titleBounds.getHeight() * (double)(this.model.getNumGroups() + 2)) {
            area.height = Math.min((int)(titleBounds.getHeight() * (double)(this.model.getNumGroups() + 2)), this.componentBounds.height);
        }
        if (area.getHeight() / (double)this.model.getNumGroups() > titleBounds.getHeight() * 3.0) {
            area.height = (int)((double)this.model.getNumGroups() * titleBounds.getHeight() * 3.0);
        }
        area.y = (int)((double)(this.componentBounds.y + this.componentBounds.height / 2 - area.height / 2) + titleBounds.getHeight() / 2.0);
        if ((double)area.x > (double)this.center.x + this.radius * 1.5) {
            area.x = (int)((double)this.center.x + this.radius * 1.5);
        }
        if (group != null) {
            this.labels.drawText(g, group, new Point(area.x, area.y), true, backgroundColor);
        }
        area.y += this.pieDefaults.labelSeperation;
        area.height -= this.pieDefaults.labelSeperation;
        int labelHeight = area.height / this.model.getNumGroups();
        Enumeration e = this.model.getGroups();
        int current = 0;
        this.labels.setJustifySupported(false);
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            String str = null;
            DataFilterReadInterface dfri = this.model.getDataFilter();
            str = grp instanceof Number && Double.isNaN(((Number)grp).doubleValue()) ? ResourceLoader.getResourceString((Object)this.rb, (String)"Slice.Missing.txt", (String)"Missing") : (dfri != null ? dfri.getFormattedValue(this.model.getGroupVariable(), grp, dfri.getFormat(this.model.getGroupVariable(), SASFormat.class)) : grp.toString());
            Rectangle2D r = this.labels.getStringBounds(str, frc);
            int yPos = (int)((double)(area.y + current * labelHeight) + r.getHeight() / 2.0);
            double[] bounds = (double[])this.ringBounds.get(grp);
            double angle = Math.asin((double)(yPos - this.center.y) / this.distance(new Point(this.center.x, this.center.y), new Point(area.x, yPos)));
            int x = (int)(Math.cos(angle) * bounds[0]);
            int y = (int)(Math.sin(angle) * bounds[0]);
            g.drawLine(this.center.x + x, this.center.y + y, area.x, (int)((double)yPos - r.getHeight() / 3.0));
            this.labels.drawText(g, str, new Point(area.x + this.pieDefaults.labelSeperation, yPos), true, backgroundColor);
            ++current;
        }
    }

    public int getSliceLabelHeight(Graphics2D g) {
        int width = 0;
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        if (frc == null) {
            return width;
        }
        return (int)this.labels.getStringBounds("W", frc).getHeight();
    }

    public int calculateGroupLabelWidth(Graphics2D g) {
        int width = 0;
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        if (frc == null) {
            return width;
        }
        Object obj = this.model.getGroupVariableLabel();
        String groupLabel = null;
        if (obj != null) {
            groupLabel = obj.toString();
        }
        if (groupLabel != null) {
            Rectangle2D titleBounds = this.labels.getStringBounds(groupLabel, frc);
            width = (int)Math.max((double)width, titleBounds.getWidth());
        }
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            String str = null;
            DataFilterReadInterface dfri = this.model.getDataFilter();
            str = grp instanceof Number && Double.isNaN(((Number)grp).doubleValue()) ? ResourceLoader.getResourceString((Object)this.rb, (String)"Slice.Missing.txt", (String)"Missing") : (dfri != null ? dfri.getFormattedValue(this.model.getGroupVariable(), grp, dfri.getFormat(this.model.getGroupVariable(), SASFormat.class)) : grp.toString());
            if (str == null) continue;
            Rectangle2D r = this.labels.getStringBounds(str, frc);
            width = (int)Math.max((double)width, r.getWidth() + (double)this.pieDefaults.labelSeperation);
        }
        return width += 8;
    }

    private void computeSliceColors() {
        if (this.model == null || this.style == null) {
            return;
        }
        Hashtable<Object, Color> sliceColors = new Hashtable<Object, Color>();
        Object[] cats = this.model.getGlobalCategoryList();
        Object[] allCats = this.model.fetchUniqueValues(false);
        if (allCats == null) {
            allCats = cats;
        }
        if (cats == null) {
            return;
        }
        for (int i = 0; i < allCats.length; ++i) {
            DataStyleElement dse;
            if (allCats[i] instanceof Double && Double.isNaN((Double)allCats[i]) || allCats[i] instanceof String && ((String)allCats[i]).length() == 0) {
                dse = this.style.getDataStyleElement("Missing");
                sliceColors.put(Slice.MISSING_SLICE, dse.getFillColor());
                sliceColors.put(Slice.MISSING_STRING, dse.getFillColor());
                continue;
            }
            dse = SILKUtilities.getStyleElement(allCats[i].toString(), i, 2, this.style, (String)null, null).getAsDataStyle();
            sliceColors.put(allCats[i], dse.getFillColor());
        }
        double shiftToZero = 0.0;
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Slice[] slices = this.model.getSlices(e.nextElement());
            for (int i = 0; i < slices.length; ++i) {
                if (!(slices[i].getTransparencyValue() < shiftToZero)) continue;
                shiftToZero = slices[i].getTransparencyValue();
            }
        }
        shiftToZero = Math.abs(shiftToZero);
        double opacitySum = 0.0;
        e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Slice[] slices = this.model.getSlices(e.nextElement());
            for (int i = 0; i < slices.length; ++i) {
                opacitySum += slices[i].getTransparencyValue() + shiftToZero;
            }
        }
        Hashtable transArrays = new Hashtable();
        this.globalSliceColors = new Hashtable();
        e = this.model.getGroups();
        int maxOpacityValue = 0;
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            int[] transArray = new int[slices.length];
            for (int i = 0; i < slices.length; ++i) {
                int index = slices[i].getColorIndex();
                Color c = null;
                if (index < 0 && !slices[i].isOtherSlice) {
                    c = (Color)sliceColors.get(slices[i].getName());
                }
                if (c == null) {
                    if (slices[i].isMissingSlice) {
                        DataStyleElement dse = this.style.getDataStyleElement("Missing");
                        c = dse.getFillColor();
                    } else if (slices[i].isOtherSlice) {
                        DataStyleElement dse = this.style.getDataStyleElement("GraphDataStyleOther");
                        c = dse.getFillColor();
                    } else {
                        DataStyleElement dse = SILKUtilities.getStyleElement(slices[i].getName().toString(), index, 2, this.style, (String)null, null).getAsDataStyle();
                        c = dse.getFillColor();
                    }
                }
                this.globalSliceColors.put(slices[i].getName(), c);
                int transparency = 255;
                double trans = (slices[i].getTransparencyValue() + shiftToZero) / opacitySum;
                transparency = !Double.isNaN(trans) ? (int)(255.0 * trans) : 0;
                transArray[i] = transparency;
                if (maxOpacityValue < transparency) {
                    maxOpacityValue = transparency;
                }
                slices[i].setSliceColor(c);
            }
            transArrays.put(grp, transArray);
        }
        int diff = 255 - maxOpacityValue;
        e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            int[] transArray = (int[])transArrays.get(grp);
            for (int i = 0; i < slices.length; ++i) {
                int opacityValue = transArray[i] + diff;
                if (this.treatOpacityValueAsTransparency) {
                    opacityValue = 255 - transArray[i];
                }
                Color sliceColor = slices[i].getSliceColor();
                slices[i].setSliceColor(new Color(sliceColor.getRed(), sliceColor.getGreen(), sliceColor.getBlue(), opacityValue));
            }
        }
        this.sliceColorsComputed = true;
    }

    private String getSliceLabel(Slice s) {
        String sep = this.getLabelSeparator();
        int labelCompMask = this.getLabelCompMask();
        StringBuffer sliceLabel = new StringBuffer("");
        if (this.model.getAllGroupsCount() > 1) {
            if ((labelCompMask & 2) == 2) {
                sliceLabel.append(this.getResponseString(s).trim());
            }
        } else {
            if ((labelCompMask & 1) == 1) {
                sliceLabel.append(s.getNonTruncatedDisplayName().trim());
            }
            if ((labelCompMask & 2) == 2) {
                if (sliceLabel.length() > 0) {
                    sliceLabel.append(sep);
                    sliceLabel.append(" ");
                }
                sliceLabel.append(this.getResponseString(s).trim());
            }
            if ((labelCompMask & 4) == 4) {
                if (sliceLabel.length() > 0) {
                    sliceLabel.append(sep);
                    sliceLabel.append(" ");
                }
                sliceLabel.append(this.formatPercentLabel(s).trim());
            }
        }
        return sliceLabel.toString();
    }

    private void drawLabels(Graphics2D g, Rectangle chartAreaBounds) {
        String labelPosition = this.getLabelPosition();
        if (this.model.getAllGroupsCount() > 1) {
            this.drawInsideLabelsForPieGroups(g);
        } else if (labelPosition.equals("INSIDE")) {
            this.drawLabelsInside(g);
        } else if (labelPosition.equals("OUTSIDE")) {
            this.drawLabelsOutside(g, chartAreaBounds);
        } else if (labelPosition.equals("MARGIN")) {
            this.drawLabelsMargin(g, chartAreaBounds);
        } else if (labelPosition.equals("BESTFIT")) {
            this.drawLabelsBestFit(g);
        }
    }

    private void drawInsideLabelsForPieGroups(Graphics2D g) {
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object group = e.nextElement();
            double[] angleList = (double[])this.angleLists.get(group);
            Slice[] slices = this.model.getSlices(group);
            Arc2D[] innerOuterArcs = (Arc2D[])this.arcLists.get(group);
            for (int i = 0; i < slices.length; ++i) {
                Arc2D innerArc = innerOuterArcs[2 * i];
                Arc2D outerArc = innerOuterArcs[2 * i + 1];
                double innerRadius = innerArc.getStartPoint().distance(this.center);
                double outerRadius = outerArc.getStartPoint().distance(this.center);
                double startSliceAngle = angleList[i];
                double endSliceAngle = angleList[i + 1];
                double endHalfSliceAngle = startSliceAngle + (endSliceAngle - startSliceAngle) / 2.0;
                Arc2D.Double halfInnerArc = new Arc2D.Double();
                halfInnerArc.setArcByCenter(this.center.getX(), this.center.getY(), innerRadius, startSliceAngle + (endHalfSliceAngle - startSliceAngle), -(endHalfSliceAngle - startSliceAngle), 0);
                Arc2D.Double halfOuterArc = new Arc2D.Double();
                halfOuterArc.setArcByCenter(this.center.getX(), this.center.getY(), outerRadius, startSliceAngle + (endHalfSliceAngle - startSliceAngle), -(endHalfSliceAngle - startSliceAngle), 0);
                double arcCenterX = (halfInnerArc.getStartPoint().getX() + halfOuterArc.getStartPoint().getX()) / 2.0;
                double arcCenterY = (halfInnerArc.getStartPoint().getY() + halfOuterArc.getStartPoint().getY()) / 2.0;
                String label = this.getSliceLabel(slices[i]);
                Rectangle2D labelBounds = this.labels.getStringBounds(label, g.getFontRenderContext());
                int xpos = (int)(arcCenterX - labelBounds.getWidth() / 2.0);
                int ypos = (int)arcCenterY;
                this.drawSliceText(g, slices[i], label, new Point(xpos, ypos));
            }
        }
    }

    private void drawLabelsInside(Graphics2D g) {
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object group = e.nextElement();
            this.drawLabelsInside(g, group);
        }
    }

    private void drawLabelsInside(Graphics2D g, Object group) {
        Slice[] slices = this.model.getSlices(group);
        double[] angleList = (double[])this.angleLists.get(group);
        for (int i = 0; i < slices.length; ++i) {
            Point2D arcStartPoint = this.startPoints[i];
            Point2D arcEndPoint = this.endPoints[i];
            int angle = (int)(angleList[i + 1] - angleList[i]);
            String label = this.getSliceLabel(slices[i]);
            Point2D centroid = null;
            Line2D.Double line1 = null;
            Line2D.Double line2 = null;
            if (slices.length == 1) {
                centroid = this.center;
                line1 = new Line2D.Double(this.center, arcStartPoint);
                line2 = new Line2D.Double(new Point2D.Double(arcStartPoint.getX() - 2.0 * this.radius, arcStartPoint.getY()), this.center);
            } else {
                centroid = this.getSliceCentroid(arcStartPoint, arcEndPoint, this.center, angleList[i], angleList[i + 1]);
                line1 = new Line2D.Double(this.center, arcStartPoint);
                line2 = new Line2D.Double(this.center, arcEndPoint);
            }
            Point2D leftmostPt1 = this.getLeftMostIntersectionForHorizontalLine(line1, line2, slices[i].getSliceShape(), centroid.getY());
            Point2D leftmostPt2 = null;
            if (angleList[i + 1] >= 180.0 && 180.0 >= angleList[i]) {
                leftmostPt2 = this.getLeftMostIntersectionForHorizontalLine(line1, line2, slices[i].getSliceShape(), this.center.getY());
            } else {
                Point2D maxHorizontalInterceptPt = this.getMaximalHorizontalIntersectionPoint(arcStartPoint, arcEndPoint, angle);
                leftmostPt2 = this.getLeftMostIntersectionForHorizontalLine(line1, line2, slices[i].getSliceShape(), maxHorizontalInterceptPt.getY());
            }
            Point2D.Double adjustedPos = new Point2D.Double();
            this.adjustLabelPositionInsideSlice(g, slices[i], label, leftmostPt1, leftmostPt2, centroid, adjustedPos);
            int xpos = (int)((Point2D)adjustedPos).getX();
            int ypos = (int)((Point2D)adjustedPos).getY();
            this.drawSliceText(g, slices[i], label, new Point(xpos, ypos));
        }
    }

    private void drawSliceText(Graphics2D g, Slice slice, String label, Point location) {
        Color oldTextColor = this.labels.getColor();
        Color bgColor = slice.getSliceColor();
        Color newTextColor = this.getContrastTextColor(bgColor);
        this.labels.setColor(newTextColor);
        this.labels.drawText(g, label, location);
        this.labels.setColor(oldTextColor);
    }

    private Color getContrastTextColor(Color bgColor) {
        boolean isDark;
        float[] hsb = new float[3];
        hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), hsb);
        boolean bl = isDark = (double)hsb[2] < 0.45;
        if (isDark) {
            return Color.white;
        }
        return Color.black;
    }

    private boolean[] determineShiftDirection(Shape s, Point2D startPos, Point2D endPos, boolean isTopAnchored, Rectangle2D labelBounds) {
        boolean shiftRight;
        Point2D.Double rightPos;
        Point2D.Double leftPos;
        Point2D.Double downPos;
        Point2D.Double upPos;
        boolean[] shiftFlags = new boolean[3];
        if (isTopAnchored) {
            upPos = new Point2D.Double(startPos.getX(), startPos.getY() + labelBounds.getHeight() - 5.0);
            downPos = new Point2D.Double(startPos.getX(), startPos.getY() + labelBounds.getHeight() + 5.0);
            leftPos = new Point2D.Double(startPos.getX() - 5.0, startPos.getY() + labelBounds.getHeight());
            rightPos = new Point2D.Double(startPos.getX() + 5.0, startPos.getY() + labelBounds.getHeight());
        } else {
            upPos = new Point2D.Double(startPos.getX(), startPos.getY() - 5.0);
            downPos = new Point2D.Double(startPos.getX(), startPos.getY() + 5.0);
            leftPos = new Point2D.Double(startPos.getX() - 5.0, startPos.getY());
            rightPos = new Point2D.Double(startPos.getX() + 5.0, startPos.getY());
        }
        boolean shiftUp = startPos.getY() > endPos.getY();
        boolean bl = shiftRight = startPos.getX() < endPos.getX();
        if (shiftUp) {
            boolean shouldYShift = s.contains(upPos);
        } else {
            boolean shouldYShift = s.contains(downPos);
        }
        boolean shouldXShift = shiftRight ? s.contains(rightPos) : s.contains(leftPos);
        shiftFlags[0] = shouldXShift;
        shiftFlags[1] = shiftRight;
        shiftFlags[2] = shiftUp;
        return shiftFlags;
    }

    private boolean adjustLabelPositionInsideSlice(Graphics2D g, Slice s, String label, Point2D startPos, Point2D endPos, Point2D centroid, Point2D adjustedPos) {
        boolean flag2;
        if (label.length() == 0) {
            adjustedPos.setLocation(startPos);
            return true;
        }
        Rectangle2D labelBounds = this.labels.getStringBounds(label, g.getFontRenderContext()).getBounds2D();
        Rectangle2D charBounds = this.labels.getStringBounds(label.substring(0, 1), g.getFontRenderContext()).getBounds2D();
        double top = startPos.getY() - labelBounds.getHeight() / 2.0;
        double bottom = startPos.getY() + labelBounds.getHeight() / 2.0;
        double left = startPos.getX();
        double horizonInterceptWidth = (centroid.getX() - left) * 2.0;
        double centreAligned = centroid.getX() - labelBounds.getWidth() / 2.0;
        if (labelBounds.getWidth() < horizonInterceptWidth) {
            String lastChar = label.substring(label.length() - 1, label.length());
            Rectangle2D lastCharBounds = this.labels.getStringBounds(lastChar, g.getFontRenderContext());
            double ypos = centroid.getY();
            if (Math.abs(centroid.getY() - this.center.getY()) <= labelBounds.getHeight()) {
                ypos = centroid.getY() <= this.center.getY() ? centroid.getY() - labelBounds.getHeight() / 2.0 : centroid.getY() + labelBounds.getHeight() / 2.0;
            }
            if (s.getSliceShape().contains(centreAligned + labelBounds.getWidth() / 4.0, ypos - labelBounds.getHeight() / 2.0, labelBounds.getWidth() - lastCharBounds.getWidth() / 2.0, labelBounds.getHeight())) {
                adjustedPos.setLocation(centreAligned, ypos + labelBounds.getHeight() / 2.0);
                return true;
            }
        }
        boolean isTopAnchored = false;
        Point2D.Double testPos = new Point2D.Double(startPos.getX(), startPos.getY() - 5.0);
        isTopAnchored = !s.getSliceShape().contains(testPos);
        boolean isLabelInside = false;
        if (isTopAnchored) {
            while (!s.getSliceShape().contains(left, top, charBounds.getWidth(), charBounds.getHeight())) {
                if (s.getSliceShape().contains(left += 0.5, top)) continue;
                left = startPos.getX();
                break;
            }
        }
        Point2D arcIntersectionPt = this.getIntersectionWithArc(s.getSliceShape(), this.center, this.radius, centroid.getY());
        adjustedPos.setLocation(left, startPos.getY());
        Point2D.Double labelStartPos = new Point2D.Double(adjustedPos.getX(), adjustedPos.getY());
        Point2D.Double labelEndPos = new Point2D.Double(adjustedPos.getX() + labelBounds.getWidth(), adjustedPos.getY());
        boolean flag1 = labelStartPos.distance(this.center) > this.radius;
        boolean bl = flag2 = labelEndPos.distance(this.center) > this.radius;
        if (arcIntersectionPt != null && (flag1 || flag2)) {
            boolean lastCharInside;
            boolean firstCharInside = s.getSliceShape().contains(left, startPos.getY()) && s.getSliceShape().contains(left, startPos.getY() - labelBounds.getHeight());
            boolean bl2 = lastCharInside = s.getSliceShape().contains(left + labelBounds.getWidth(), startPos.getY()) && s.getSliceShape().contains(left + labelBounds.getWidth(), startPos.getY() - labelBounds.getHeight());
            isLabelInside = firstCharInside || lastCharInside;
        } else {
            Point2D.Double anchorPos = null;
            anchorPos = isTopAnchored ? new Point2D.Double(left, top) : new Point2D.Double(left, bottom);
            int distance = (int)Math.sqrt(Math.pow(((Point2D)anchorPos).getX() - endPos.getX(), 2.0) + Math.pow(((Point2D)anchorPos).getY() - endPos.getY(), 2.0));
            adjustedPos.setLocation(left, bottom);
            for (int i = 1; i < distance; ++i) {
                double x = (double)(distance - i) * ((Point2D)anchorPos).getX() / (double)distance + (double)i * endPos.getX() / (double)distance;
                double y = (double)(distance - i) * ((Point2D)anchorPos).getY() / (double)distance + (double)i * endPos.getY() / (double)distance;
                if (isTopAnchored) {
                    if (!s.getSliceShape().contains(x, y + labelBounds.getHeight())) break;
                    adjustedPos.setLocation(x, y + labelBounds.getHeight());
                    isLabelInside = s.getSliceShape().contains(x + 1.0, y + 1.0, labelBounds.getWidth() - 2.0, labelBounds.getHeight() - 2.0);
                } else {
                    if (!s.getSliceShape().contains(x, y - labelBounds.getHeight())) break;
                    adjustedPos.setLocation(x, y);
                    isLabelInside = s.getSliceShape().contains(x + 1.0, y - labelBounds.getHeight() + 1.0, labelBounds.getWidth() - 2.0, labelBounds.getHeight() - 2.0);
                }
                if (isLabelInside) break;
            }
            if (!isTopAnchored) {
                String lastChar = label.substring(label.length() - 1, label.length());
                Rectangle2D lastCharBounds = this.labels.getStringBounds(lastChar, g.getFontRenderContext());
                boolean labelStatus = s.getSliceShape().contains(adjustedPos.getX() + labelBounds.getWidth() - lastCharBounds.getWidth() / 2.0, adjustedPos.getY() - labelBounds.getHeight());
                if (!labelStatus) {
                    Point2D intersectionPt = this.getIntersectionWithArc(s.getSliceShape(), this.center, this.radius, adjustedPos.getY() - labelBounds.getHeight());
                    Point2D.Double labelPos = new Point2D.Double(adjustedPos.getX(), adjustedPos.getY());
                    if (intersectionPt != null) {
                        while (s.getSliceShape().contains(((Point2D)labelPos).getX(), ((Point2D)labelPos).getY())) {
                            if (s.getSliceShape().contains(((Point2D)labelPos).getX() + labelBounds.getWidth(), ((Point2D)labelPos).getY())) {
                                adjustedPos.setLocation(((Point2D)labelPos).getX(), ((Point2D)labelPos).getY());
                                break;
                            }
                            ((Point2D)labelPos).setLocation(((Point2D)labelPos).getX() - 1.0, ((Point2D)labelPos).getY());
                        }
                    }
                }
            }
        }
        return isLabelInside;
    }

    private boolean sliceContainsLabel(Graphics2D g, Slice s, String label, Point2D baselinePt) {
        Rectangle2D labelBounds = this.labels.getStringBounds(label, g.getFontRenderContext()).getBounds2D();
        double top = baselinePt.getY() - labelBounds.getHeight();
        double left = baselinePt.getX();
        boolean status = s.getSliceShape().contains(left, top, labelBounds.getWidth(), labelBounds.getHeight());
        return status;
    }

    private Point2D getFontAdjustedLeftMostPoint(Line2D line1, Line2D line2, int fontHeight) {
        double m1 = (line1.getY1() - line1.getY2()) / (line1.getX1() - line1.getX2());
        double c1 = line1.getY1() - m1 * line1.getX1();
        double m2 = (line2.getY1() - line2.getY2()) / (line2.getX1() - line2.getX2());
        double c2 = line2.getY1() - m2 * line2.getX1();
        return this.getFontAdjustedLeftMostPoint(m1, c1, m2, c2, fontHeight);
    }

    private Point2D getFontAdjustedLeftMostPoint(double m1, double c1, double m2, double c2, int fontHeight) {
        double u1 = ((double)fontHeight - (c1 - c2)) / (m1 - m2);
        double u2 = ((double)fontHeight - (c2 - c1)) / (m2 - m1);
        double x = u1 > u2 ? u1 : u2;
        double y = m2 * x + c2;
        return new Point2D.Double(x, y);
    }

    private double getSliceArea(Point2D p1, Point2D p2, Point2D p3, Point2D p4) {
        double[] xlist = new double[]{p1.getX(), p2.getX(), p3.getX(), p4.getX()};
        double[] ylist = new double[]{p1.getY(), p2.getY(), p3.getY(), p4.getY()};
        double area = 0.0;
        for (int i = 0; i < xlist.length - 1; ++i) {
            area += xlist[i] * ylist[i + 1] - xlist[i + 1] * ylist[i];
        }
        return area /= 2.0;
    }

    private Point2D getSliceCentroid(Point2D p1, Point2D p2, Point2D center, double startSliceAngle, double endSliceAngle) {
        Arc2D.Double halfSlice = new Arc2D.Double();
        double endHalfSliceAngle = startSliceAngle + (endSliceAngle - startSliceAngle) / 2.0;
        halfSlice.setArcByCenter(center.getX(), center.getY(), this.radius, startSliceAngle + (endHalfSliceAngle - startSliceAngle), -(endHalfSliceAngle - startSliceAngle), 0);
        double[] xlist = new double[]{p1.getX(), halfSlice.getStartPoint().getX(), p2.getX(), center.getX(), p1.getX()};
        double[] ylist = new double[]{p1.getY(), halfSlice.getStartPoint().getY(), p2.getY(), center.getY(), p1.getY()};
        double area = 0.0;
        for (int i = 0; i < xlist.length - 1; ++i) {
            area += xlist[i] * ylist[i + 1] - xlist[i + 1] * ylist[i];
        }
        area /= 2.0;
        double xcentroid = 0.0;
        for (int i = 0; i < xlist.length - 1; ++i) {
            xcentroid += (xlist[i] + xlist[i + 1]) * (xlist[i] * ylist[i + 1] - xlist[i + 1] * ylist[i]);
        }
        xcentroid /= 6.0 * area;
        double ycentroid = 0.0;
        for (int i = 0; i < ylist.length - 1; ++i) {
            ycentroid += (ylist[i] + ylist[i + 1]) * (xlist[i] * ylist[i + 1] - xlist[i + 1] * ylist[i]);
        }
        return new Point2D.Double(xcentroid, ycentroid /= 6.0 * area);
    }

    private Point2D getLeftMostIntersectionForHorizontalLine(Line2D line1, Line2D line2, Shape s, double yintercept) {
        Point2D leftmostPoint = null;
        Point2D intersection1 = this.calculateIntersection(line1.getP1(), line1.getP2(), yintercept);
        Point2D intersection2 = this.calculateIntersection(line2.getP1(), line2.getP2(), yintercept);
        Point2D arcIntersectionPt = this.getIntersectionWithArc(s, this.center, this.radius, yintercept);
        if (Math.abs(intersection1.getX()) != Double.POSITIVE_INFINITY && Math.abs(intersection2.getX()) != Double.POSITIVE_INFINITY) {
            boolean intersectStatus = Math.abs(intersection1.getX() - intersection2.getX()) < 0.1 && Math.abs(intersection1.getY() - intersection2.getY()) < 0.1;
            Rectangle2D.Double rect1 = new Rectangle2D.Double(intersection1.getX() - 1.0, intersection1.getY() - 1.0, 2.0, 2.0);
            Rectangle2D.Double rect2 = new Rectangle2D.Double(intersection2.getX() - 1.0, intersection2.getY() - 1.0, 2.0, 2.0);
            leftmostPoint = !intersectStatus && s.intersects(rect1) && s.intersects(rect2) ? (intersection1.getX() < intersection2.getX() ? intersection1 : intersection2) : (s.intersects(rect1) ? intersection1 : intersection2);
        } else if (Math.abs(intersection1.getX()) == Double.POSITIVE_INFINITY) {
            leftmostPoint = intersection2;
        } else if (Math.abs(intersection2.getX()) == Double.POSITIVE_INFINITY) {
            leftmostPoint = intersection1;
        }
        if (leftmostPoint == null) {
            leftmostPoint = arcIntersectionPt;
        } else if (arcIntersectionPt != null && arcIntersectionPt.getX() < leftmostPoint.getX()) {
            leftmostPoint = arcIntersectionPt;
        }
        return leftmostPoint;
    }

    private Point2D getIntersectionWithArc(Shape s, Point2D center, double radius, double yintercept) {
        Point2D arcIntersectionPt = null;
        double x1 = center.getX() + Math.sqrt(Math.pow(radius, 2.0) - Math.pow(yintercept - center.getY(), 2.0));
        double x2 = center.getX() - Math.sqrt(Math.pow(radius, 2.0) - Math.pow(yintercept - center.getY(), 2.0));
        Rectangle2D.Double rect1 = new Rectangle2D.Double(x1 - 1.0, yintercept - 1.0, 2.0, 2.0);
        Rectangle2D.Double rect2 = new Rectangle2D.Double(x2 - 1.0, yintercept - 1.0, 2.0, 2.0);
        ArrayList<Point2D.Double> points = new ArrayList<Point2D.Double>();
        if (s.intersects(rect1)) {
            points.add(new Point2D.Double(x1, yintercept));
        }
        if (s.intersects(rect2)) {
            points.add(new Point2D.Double(x2, yintercept));
        }
        if (points.size() > 0) {
            arcIntersectionPt = (Point2D)points.get(0);
            for (int i = 1; i < points.size(); ++i) {
                Point2D pt = (Point2D)points.get(i);
                if (!(pt.getX() < arcIntersectionPt.getX())) continue;
                arcIntersectionPt = pt;
            }
        }
        return arcIntersectionPt;
    }

    private Point2D getMaximalHorizontalIntersectionPoint(Point2D arcStartPoint, Point2D arcEndPoint, int angle) {
        double distance2;
        Point2D intersectionPt = null;
        double distance1 = Math.abs(arcStartPoint.getX() - (double)this.center.x);
        intersectionPt = distance1 > (distance2 = Math.abs(arcEndPoint.getX() - (double)this.center.x)) ? this.calculateIntersection(arcEndPoint, this.center, arcStartPoint.getY()) : this.calculateIntersection(arcStartPoint, this.center, arcEndPoint.getY());
        return intersectionPt;
    }

    private Point2D calculateIntersection(Point2D pt1, Point2D pt2, double yintercept) {
        if (Math.abs(pt1.getY() - pt2.getY()) < 0.01 && Math.abs(pt2.getY() - yintercept) < 0.01) {
            return new Point2D.Double(pt1.getX(), yintercept);
        }
        double x = 0.0;
        x = Math.abs(pt1.getY() - pt2.getY()) < 0.01 ? Double.POSITIVE_INFINITY : pt1.getX() + (yintercept - pt1.getY()) * (pt1.getX() - pt2.getX()) / (pt1.getY() - pt2.getY());
        double y = 0.0;
        y = Math.abs(pt1.getX() - pt2.getX()) < 0.01 ? yintercept : pt1.getY() + (x - pt1.getX()) * (pt1.getY() - pt2.getY()) / (pt1.getX() - pt2.getX());
        if (Double.isNaN(y)) {
            y = yintercept;
        }
        return new Point2D.Double(x, y);
    }

    private void drawLabelsOutside(Graphics2D g, Rectangle chartAreaBounds) {
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object group = e.nextElement();
            Slice[] slices = this.model.getSlices(group);
            double[] angleList = (double[])this.angleLists.get(group);
            for (int i = 0; i < slices.length; ++i) {
                Arc2D.Double halfSlice = new Arc2D.Double();
                double startSliceAngle = angleList[i];
                double endSliceAngle = angleList[i + 1];
                double endHalfSliceAngle = startSliceAngle + (endSliceAngle - startSliceAngle) / 2.0;
                halfSlice.setArcByCenter(this.center.getX(), this.center.getY(), this.radius, startSliceAngle + (endHalfSliceAngle - startSliceAngle), -(endHalfSliceAngle - startSliceAngle), 0);
                Point2D.Double labelPos = new Point2D.Double();
                Point2D.Double connectorPos = new Point2D.Double();
                int orientation = this.calculateLabelPosOutsideSlice(g, slices[i], halfSlice, 4, labelPos, connectorPos);
                g.drawLine((int)halfSlice.getStartPoint().getX(), (int)halfSlice.getStartPoint().getY(), (int)((Point2D)connectorPos).getX(), (int)((Point2D)connectorPos).getY());
                int xpos = (int)((Point2D)labelPos).getX();
                int ypos = (int)((Point2D)labelPos).getY();
                this.drawWrappableText(g, this.getSliceLabel(slices[i]), new Point(xpos, ypos), connectorPos, orientation, chartAreaBounds);
            }
        }
    }

    private void drawWrappableText(Graphics2D g, String s, Point p, Point2D connectorPos, int orientation, Rectangle componentBounds) {
        if (s.length() == 0) {
            return;
        }
        Rectangle2D labelBounds = this.labels.getStringBounds(s, g.getFontRenderContext());
        if (p.getX() < 0.0) {
            p.setLocation(0.0, p.getY());
        }
        if (orientation == 0) {
            this.labels.drawText(g, s, p);
        } else if (orientation == 1) {
            this.labels.drawText(g, s, p);
        } else {
            double availableWidth = 0.0;
            double avgCharWidth = this.labels.getStringBounds(s, g.getFontRenderContext()).getWidth() / (double)s.length();
            availableWidth = orientation == 2 || orientation == 4 || orientation == 7 ? componentBounds.getX() + componentBounds.getWidth() - p.getX() : connectorPos.getX() - p.getX();
            if (availableWidth >= labelBounds.getWidth()) {
                this.labels.drawText(g, s, p);
            } else {
                int numLines = (int)Math.ceil(labelBounds.getWidth() / availableWidth);
                StringBuffer[] labelParts = new StringBuffer[numLines];
                labelParts[0] = new StringBuffer();
                int iter = 0;
                for (int j = 0; j < s.length(); ++j) {
                    labelParts[iter].append(s.charAt(j));
                    if (!(this.labels.getStringBounds(labelParts[iter].toString(), g.getFontRenderContext()).getWidth() >= availableWidth)) continue;
                    labelParts[++iter] = new StringBuffer();
                }
                double labelHeight = 0.0;
                for (int i = 0; i < labelParts.length; ++i) {
                    if (labelParts[i] == null) continue;
                    this.labels.drawText(g, labelParts[i].toString(), new Point(p.x, (int)((double)p.y + labelHeight)));
                    labelHeight += this.labels.getStringBounds(labelParts[i].toString(), g.getFontRenderContext()).getHeight();
                }
            }
        }
    }

    private int calculateLabelPosOutsideSlice(Graphics2D g, Slice s, Arc2D halfSlice, int radialOffset, Point2D labelPos, Point2D connectorPos) {
        connectorPos.setLocation(this.calculateOuterLabelPositon(halfSlice.getStartPoint(), radialOffset));
        double angle = this.getAngleWithHorizontalDiameter(connectorPos);
        int orientation = this.getOrientation(angle);
        String label = this.getSliceLabel(s);
        Rectangle2D labelBounds = this.labels.getStringBounds(label, g.getFontRenderContext());
        if (orientation == 0) {
            labelPos.setLocation(connectorPos.getX() - labelBounds.getWidth() / 2.0, connectorPos.getY());
        } else if (orientation == 1) {
            labelPos.setLocation(connectorPos.getX() - labelBounds.getWidth() / 2.0, connectorPos.getY() + labelBounds.getHeight());
        } else if (orientation == 2) {
            labelPos.setLocation(connectorPos);
        } else if (orientation == 3) {
            labelPos.setLocation(connectorPos.getX() - labelBounds.getWidth(), connectorPos.getY());
        } else if (orientation == 5) {
            labelPos.setLocation(connectorPos.getX() - labelBounds.getWidth(), connectorPos.getY() + labelBounds.getHeight());
        } else if (orientation == 4) {
            labelPos.setLocation(connectorPos.getX(), connectorPos.getY() + labelBounds.getHeight());
        } else if (orientation == 6) {
            labelPos.setLocation(connectorPos.getX() - labelBounds.getWidth(), connectorPos.getY() + labelBounds.getHeight() / 2.0);
        } else if (orientation == 7) {
            labelPos.setLocation(connectorPos.getX(), connectorPos.getY() + labelBounds.getHeight() / 2.0);
        }
        return orientation;
    }

    private int getOrientation(double angle) {
        int orientation = 0;
        if (angle >= -10.0 && angle <= 10.0) {
            orientation = 7;
        } else if (angle > 10.0 && angle < 80.0) {
            orientation = 2;
        } else if (angle >= 80.0 && angle <= 100.0) {
            orientation = 0;
        } else if (angle > 100.0 && angle < 170.0) {
            orientation = 3;
        } else if (angle >= 170.0 && angle <= 180.0 || angle <= -170.0 && angle >= -180.0) {
            orientation = 6;
        } else if (angle > -170.0 && angle < -110.0) {
            orientation = 5;
        } else if (angle >= -110.0 && angle <= -80.0) {
            orientation = 1;
        } else if (angle > -80.0 && angle < 0.0) {
            orientation = 4;
        }
        return orientation;
    }

    private double getAngleWithHorizontalDiameter(Point2D arcMidPoint) {
        Point2D.Double vector1 = new Point2D.Double(arcMidPoint.getX() - this.center.getX(), arcMidPoint.getY() - this.center.getY());
        Point2D.Double vector2 = new Point2D.Double(this.radius, 0.0);
        double radianAngle = Math.atan2(((Point2D)vector2).getY(), ((Point2D)vector2).getX()) - Math.atan2(((Point2D)vector1).getY(), ((Point2D)vector1).getX());
        double angle = Math.toDegrees(radianAngle);
        return angle;
    }

    private Point2D calculateOuterLabelPosition(Point2D arcPoint, double optimalRadius, int offset) {
        Point2D.Double vectorA = new Point2D.Double(this.center.getX(), this.center.getY());
        Point2D vectorB = arcPoint;
        Point2D.Double ABVector = new Point2D.Double(vectorB.getX() - ((Point2D)vectorA).getX(), vectorB.getY() - ((Point2D)vectorA).getY());
        double ABVectorMag = Math.sqrt(Math.pow(vectorB.getX() - ((Point2D)vectorA).getX(), 2.0) + Math.pow(vectorB.getY() - ((Point2D)vectorA).getY(), 2.0));
        Point2D.Double unitABVector = new Point2D.Double(((Point2D)ABVector).getX() / ABVectorMag, ((Point2D)ABVector).getY() / ABVectorMag);
        Point2D.Double radialABVector = new Point2D.Double(((Point2D)unitABVector).getX() * (optimalRadius + (double)offset), ((Point2D)unitABVector).getY() * (optimalRadius + (double)offset));
        Point2D.Double vectorC = new Point2D.Double(((Point2D)vectorA).getX() + ((Point2D)radialABVector).getX(), ((Point2D)vectorA).getY() + ((Point2D)radialABVector).getY());
        return vectorC;
    }

    private Point2D calculateOuterLabelPositon(Point2D arcMidPoint, int offset) {
        return this.calculateOuterLabelPosition(arcMidPoint, this.radius, offset);
    }

    private void drawLabelsMargin(Graphics2D g, Rectangle chartAreaBounds) {
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object group = e.nextElement();
            Slice[] slices = this.model.getSlices(group);
            double[] angleList = (double[])this.angleLists.get(group);
            ArrayList<ArcInfoItem> firstQuadrantList = new ArrayList<ArcInfoItem>();
            ArrayList<ArcInfoItem> secondQuadrantList = new ArrayList<ArcInfoItem>();
            ArrayList<ArcInfoItem> thirdQuadrantList = new ArrayList<ArcInfoItem>();
            ArrayList<ArcInfoItem> fourthQuadrantList = new ArrayList<ArcInfoItem>();
            for (int i = 0; i < slices.length; ++i) {
                Arc2D.Double halfSlice = new Arc2D.Double();
                double startSliceAngle = angleList[i];
                double endSliceAngle = angleList[i + 1];
                double endHalfSliceAngle = startSliceAngle + (endSliceAngle - startSliceAngle) / 2.0;
                halfSlice.setArcByCenter(this.center.getX(), this.center.getY(), this.radius, startSliceAngle + (endHalfSliceAngle - startSliceAngle), -(endHalfSliceAngle - startSliceAngle), 0);
                double angle = this.getAngleWithHorizontalDiameter(halfSlice.getStartPoint());
                Point2D arcStartPoint = this.startPoints[i];
                Point2D arcEndPoint = this.endPoints[i];
                ArcInfoItem arcInfoItem = new ArcInfoItem(angle, i, halfSlice.getStartPoint(), arcStartPoint, arcEndPoint);
                if (angle >= 0.0 && angle <= 90.0) {
                    firstQuadrantList.add(arcInfoItem);
                    continue;
                }
                if (angle > 90.0 && angle <= 180.0) {
                    secondQuadrantList.add(arcInfoItem);
                    continue;
                }
                if (angle >= -180.0 && angle <= -90.0) {
                    thirdQuadrantList.add(arcInfoItem);
                    continue;
                }
                if (!(angle > -90.0) || !(angle < 0.0)) continue;
                fourthQuadrantList.add(arcInfoItem);
            }
            this.sortQuadrantList(firstQuadrantList, false);
            this.sortQuadrantList(secondQuadrantList, false);
            this.sortQuadrantList(thirdQuadrantList, false);
            this.sortQuadrantList(fourthQuadrantList, false);
            ArrayList<ArcInfoItem> leftMarginLabels = new ArrayList<ArcInfoItem>();
            leftMarginLabels.addAll(thirdQuadrantList);
            leftMarginLabels.addAll(secondQuadrantList);
            ArrayList<ArcInfoItem> rightMarginLabels = new ArrayList<ArcInfoItem>();
            rightMarginLabels.addAll(firstQuadrantList);
            rightMarginLabels.addAll(fourthQuadrantList);
            this.drawMarginLabels(g, slices, leftMarginLabels, chartAreaBounds, true);
            this.drawMarginLabels(g, slices, rightMarginLabels, chartAreaBounds, false);
        }
    }

    private boolean isLabellingTopDown(int orientation) {
        boolean isTopDown = false;
        switch (orientation) {
            case 0: {
                isTopDown = true;
                break;
            }
            case 1: {
                isTopDown = false;
                break;
            }
            case 6: {
                isTopDown = true;
                break;
            }
            case 7: {
                isTopDown = true;
                break;
            }
            case 3: {
                isTopDown = true;
                break;
            }
            case 2: {
                isTopDown = true;
                break;
            }
            case 5: {
                isTopDown = false;
                break;
            }
            case 4: {
                isTopDown = false;
            }
        }
        return isTopDown;
    }

    private void drawMarginLabels(Graphics2D g, Slice[] slices, List labelsList, Rectangle chartAreaBounds, boolean isLeftMargin) {
        if (labelsList.size() == 0) {
            return;
        }
        ArcInfoItem tempArcInfoItem = (ArcInfoItem)labelsList.get(0);
        int tindex = tempArcInfoItem.sliceIndex;
        String tempLabel = this.getSliceLabel(slices[tindex]);
        Rectangle2D tlabelBounds = this.labels.getStringBounds(tempLabel, g.getFontRenderContext());
        int numLabels = labelsList.size();
        int orientation = this.getOrientation(tempArcInfoItem.angle);
        boolean isLabellingTopDown = this.isLabellingTopDown(orientation);
        double interLabelGap = (chartAreaBounds.getHeight() - (double)numLabels * tlabelBounds.getHeight()) / (double)(numLabels - 1);
        double xpos = chartAreaBounds.getX();
        double ypos = isLabellingTopDown ? chartAreaBounds.getY() : chartAreaBounds.getY() + chartAreaBounds.getHeight();
        double minypos = chartAreaBounds.getY();
        double maxypos = chartAreaBounds.getY() + chartAreaBounds.getHeight();
        for (int i = 0; i < labelsList.size(); ++i) {
            ArcInfoItem arcInfo = (ArcInfoItem)labelsList.get(i);
            int sliceIndex = arcInfo.sliceIndex;
            String label = this.getSliceLabel(slices[sliceIndex]);
            Rectangle2D labelBounds = this.labels.getStringBounds(label, g.getFontRenderContext());
            if (isLeftMargin) {
                xpos = chartAreaBounds.getX();
                ypos = isLabellingTopDown ? ypos + labelBounds.getHeight() + (i == 0 ? 0.0 : interLabelGap) : ypos - labelBounds.getHeight() - (i == 0 ? 0.0 : interLabelGap);
            } else {
                xpos = chartAreaBounds.getX() + chartAreaBounds.getWidth() - labelBounds.getWidth();
                ypos = isLabellingTopDown ? ypos + labelBounds.getHeight() + (i == 0 ? 0.0 : interLabelGap) : ypos - labelBounds.getHeight() - (i == 0 ? 0.0 : interLabelGap);
            }
            if (ypos >= maxypos) {
                ypos = maxypos - labelBounds.getHeight();
            }
            if (ypos <= minypos) {
                ypos = minypos + labelBounds.getHeight();
            }
            Point2D.Double startPoint = null;
            startPoint = isLeftMargin ? new Point2D.Double(xpos + labelBounds.getWidth(), ypos - labelBounds.getHeight() / 2.0) : new Point2D.Double(xpos, ypos - labelBounds.getHeight() / 2.0);
            Point2D endPoint = arcInfo.arcMidPoint;
            if (isLeftMargin && ((Point2D)startPoint).getX() > endPoint.getX() || !isLeftMargin && ((Point2D)startPoint).getX() < endPoint.getX()) {
                g.drawLine((int)endPoint.getX(), (int)ypos, (int)endPoint.getX(), (int)endPoint.getY());
            } else if (((Point2D)startPoint).getY() != endPoint.getY()) {
                Point2D.Double intersectionPt = new Point2D.Double(endPoint.getX(), ((Point2D)startPoint).getY());
                Point2D.Double midPt = new Point2D.Double((endPoint.getX() + ((Point2D)intersectionPt).getX()) / 2.0, (endPoint.getY() + ((Point2D)intersectionPt).getY()) / 2.0);
                if (midPt.distance(this.center) > this.radius) {
                    g.drawLine((int)((Point2D)startPoint).getX(), (int)((Point2D)startPoint).getY(), (int)((Point2D)intersectionPt).getX(), (int)((Point2D)intersectionPt).getY());
                    g.drawLine((int)((Point2D)intersectionPt).getX(), (int)((Point2D)intersectionPt).getY(), (int)endPoint.getX(), (int)endPoint.getY());
                } else {
                    if (((Point2D)startPoint).getY() < endPoint.getY()) {
                        ypos = endPoint.getY() + labelBounds.getHeight() / 2.0;
                        g.drawLine((int)((Point2D)startPoint).getX(), (int)(ypos - labelBounds.getHeight() / 2.0), (int)endPoint.getX(), (int)endPoint.getY());
                    } else if (((Point2D)startPoint).getY() > endPoint.getY()) {
                        ypos = endPoint.getY() + labelBounds.getHeight() / 2.0;
                        g.drawLine((int)((Point2D)startPoint).getX(), (int)(ypos - labelBounds.getHeight() / 2.0), (int)endPoint.getX(), (int)endPoint.getY());
                    }
                    double availableHeight = 0.0;
                    availableHeight = isLabellingTopDown ? maxypos - ypos : ypos - labelBounds.getHeight() - minypos;
                    int numRemainingLabels = labelsList.size() - i - 1;
                    interLabelGap = (availableHeight - tlabelBounds.getHeight() * (double)numRemainingLabels) / (double)(numRemainingLabels + 1);
                }
            } else if (((Point2D)startPoint).getY() == endPoint.getY()) {
                g.drawLine((int)((Point2D)startPoint).getX(), (int)((Point2D)startPoint).getY(), (int)endPoint.getX(), (int)endPoint.getY());
            }
            this.labels.drawText(g, label, new Point((int)xpos, (int)ypos));
        }
    }

    private void sortQuadrantList(List quadrantList, final boolean ascending) {
        Comparator quadComparator = new Comparator(){

            public int compare(Object o1, Object o2) {
                ArcInfoItem arcInfo1 = (ArcInfoItem)o1;
                ArcInfoItem arcInfo2 = (ArcInfoItem)o2;
                int status = 0;
                if (arcInfo1.angle > arcInfo2.angle) {
                    status = ascending ? 1 : -1;
                } else if (arcInfo1.angle < arcInfo2.angle) {
                    status = ascending ? -1 : 1;
                } else if (arcInfo1.angle == arcInfo2.angle) {
                    status = 0;
                }
                return status;
            }
        };
        Collections.sort(quadrantList, quadComparator);
    }

    private void drawLabelsBestFit(Graphics2D g) {
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object group = e.nextElement();
            Slice[] slices = this.model.getSlices(group);
            double[] angleList = (double[])this.angleLists.get(group);
            Rectangle2D[] labelRects = new Rectangle2D[slices.length];
            block1: for (int i = 0; i < slices.length; ++i) {
                Point2D.Double labelPos = new Point2D.Double();
                String label = this.getSliceLabel(slices[i]);
                Rectangle2D labelBounds = this.labels.getStringBounds(label, g.getFontRenderContext());
                boolean labelStatus = this.doesLabelFitInsideSlice(g, slices[i], this.startPoints[i], this.endPoints[i], angleList[i], angleList[i + 1], labelPos);
                if (labelStatus) {
                    int xpos = (int)((Point2D)labelPos).getX();
                    int ypos = (int)((Point2D)labelPos).getY();
                    this.drawSliceText(g, slices[i], label, new Point(xpos, ypos));
                    labelRects[i] = new Rectangle2D.Double(((Point2D)labelPos).getX(), ((Point2D)labelPos).getY(), labelBounds.getWidth(), labelBounds.getHeight());
                    continue;
                }
                int radialOffset = 4;
                Arc2D.Double halfSlice = new Arc2D.Double();
                double startSliceAngle = angleList[i];
                double endSliceAngle = angleList[i + 1];
                double endHalfSliceAngle = startSliceAngle + (endSliceAngle - startSliceAngle) / 2.0;
                halfSlice.setArcByCenter(this.center.getX(), this.center.getY(), this.radius, startSliceAngle + (endHalfSliceAngle - startSliceAngle), -(endHalfSliceAngle - startSliceAngle), 0);
                Point2D.Double connectorPos = new Point2D.Double();
                while (true) {
                    int orientation = this.calculateLabelPosOutsideSlice(g, slices[i], halfSlice, radialOffset, labelPos, connectorPos);
                    boolean overlapStatus = false;
                    overlapStatus = i > 0 ? labelRects[i - 1].intersects(((Point2D)labelPos).getX(), ((Point2D)labelPos).getY(), labelBounds.getWidth(), labelBounds.getHeight()) : false;
                    if (!overlapStatus) {
                        g.drawLine((int)halfSlice.getStartPoint().getX(), (int)halfSlice.getStartPoint().getY(), (int)((Point2D)connectorPos).getX(), (int)((Point2D)connectorPos).getY());
                        int xpos = (int)((Point2D)labelPos).getX();
                        int ypos = (int)((Point2D)labelPos).getY();
                        this.drawWrappableText(g, this.getSliceLabel(slices[i]), new Point(xpos, ypos), connectorPos, orientation, this.componentBounds);
                        labelRects[i] = new Rectangle2D.Double(((Point2D)labelPos).getX(), ((Point2D)labelPos).getY(), labelBounds.getWidth(), labelBounds.getHeight());
                        continue block1;
                    }
                    ++radialOffset;
                }
            }
        }
    }

    private boolean doesLabelFitInsideSlice(Graphics2D g, Slice s, Point2D arcStartPoint, Point2D arcEndPoint, double startSliceAngle, double endSliceAngle, Point2D labelPos) {
        int angle = (int)(endSliceAngle - startSliceAngle);
        String label = this.getSliceLabel(s);
        Point2D centroid = this.getSliceCentroid(arcStartPoint, arcEndPoint, this.center, startSliceAngle, endSliceAngle);
        Line2D.Double line1 = new Line2D.Double(this.center, arcStartPoint);
        Line2D.Double line2 = new Line2D.Double(this.center, arcEndPoint);
        Point2D leftmostPt1 = this.getLeftMostIntersectionForHorizontalLine(line1, line2, s.getSliceShape(), centroid.getY());
        Point2D leftmostPt2 = null;
        if (endSliceAngle >= 180.0 && 180.0 >= startSliceAngle) {
            leftmostPt2 = this.getLeftMostIntersectionForHorizontalLine(line1, line2, s.getSliceShape(), this.center.getY());
        } else {
            Point2D maxHorizontalInterceptPt = this.getMaximalHorizontalIntersectionPoint(arcStartPoint, arcEndPoint, angle);
            leftmostPt2 = this.getLeftMostIntersectionForHorizontalLine(line1, line2, s.getSliceShape(), maxHorizontalInterceptPt.getY());
        }
        Point2D.Double adjustedPos = new Point2D.Double();
        boolean labelStatus = this.adjustLabelPositionInsideSlice(g, s, label, leftmostPt1, leftmostPt2, centroid, adjustedPos);
        labelPos.setLocation(adjustedPos);
        return labelStatus;
    }

    private boolean determineInsideLabelPosition(Graphics2D g, Slice s, String label, Rectangle labelPos) {
        return false;
    }

    private void drawInnerLabels(Graphics2D g) {
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            if (!this.angleListsComputed) {
                this.buildAngleLists();
            }
            if (!this.ringBoundsComputed) {
                this.computeRingBounds();
            }
            double[] angleList = (double[])this.angleLists.get(grp);
            double[] rBounds = (double[])this.ringBounds.get(grp);
            for (int i = 0; i < slices.length; ++i) {
                String s;
                double sliceWidth = rBounds[0] - rBounds[1];
                double point = rBounds[1] + sliceWidth / 1.5;
                Dimension bounds = this.computeSliceInnerLabelBounds(slices[i], angleList[i + 1], angleList[i], frc);
                double an = (double)this.startAngle + angleList[i] + (angleList[i + 1] - angleList[i]) * 0.5;
                int x = 0;
                int y = 0;
                Point labelOrigin = this.getPointForPolar((int)point, an);
                x = labelOrigin.x - (int)bounds.getWidth() / 2;
                y = labelOrigin.y + (int)bounds.getHeight() / 2;
                int xPos = this.center.x + x;
                int yPos = this.center.y + y - bounds.height - 2;
                int textHeight = (int)this.labels.getStringBounds("T", frc).getHeight();
                Color backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
                if (this.nameLabelPosition.equalsIgnoreCase("Inside")) {
                    this.labels.drawText(g, slices[i].getDisplayName(), new Point(xPos, yPos += textHeight), false, backgroundColor);
                }
                if (this.dataLabelPosition.equalsIgnoreCase("Inside")) {
                    s = this.getResponseString(slices[i]);
                    this.labels.drawText(g, s, new Point(xPos, yPos += textHeight + 2), false, backgroundColor);
                }
                if (!this.percentLabelPosition.equalsIgnoreCase("Inside")) continue;
                s = this.formatPercentLabel(slices[i]);
                this.labels.drawText(g, s, new Point(xPos, yPos += textHeight + 2), false, backgroundColor);
            }
        }
    }

    private int getNumLabelLines(String pos) {
        int numLines = 0;
        if (this.nameLabelPosition.equalsIgnoreCase(pos)) {
            ++numLines;
        }
        if (this.dataLabelPosition.equalsIgnoreCase(pos)) {
            ++numLines;
        }
        if (this.percentLabelPosition.equalsIgnoreCase(pos)) {
            ++numLines;
        }
        return numLines;
    }

    private String formatPercentLabel(Slice slice) {
        String s = this.radius < 75.0 || this.model.getAllGroupsCount() > 1 ? SASFormat.getInstance((String)"PERCENT8.0").format((Object)new Double(slice.getPercentage())) : (this.radius < 150.0 ? SASFormat.getInstance((String)"PERCENT8.1").format((Object)new Double(slice.getPercentage())) : SASFormat.getInstance((String)"PERCENT8.2").format((Object)new Double(slice.getPercentage())));
        return s;
    }

    private String getResponseString(Slice s) {
        String rc = null;
        if (s != null) {
            SASFormat fmt = SASFormat.getInstance((String)"BEST8.");
            Object respVar = this.model.getRoles().getVariable(RoleInterface.ROLE_RESPONSE, 0);
            if (respVar != null && this.model.getDataFilter().getFormat(respVar, SASFormat.class) != null) {
                fmt = (SASFormat)this.model.getDataFilter().getFormat(respVar, SASFormat.class);
            }
            rc = fmt.format((Object)new Double(s.getResponseValue()));
        }
        return rc;
    }

    private void drawOuterLabels(Graphics2D g) {
        if (this.model.getAllGroupsCount() > 1) {
            return;
        }
        if (!(this.nameLabelPosition.equalsIgnoreCase("Arrow") || this.nameLabelPosition.equalsIgnoreCase("Outside") || this.dataLabelPosition.equalsIgnoreCase("Arrow") || this.dataLabelPosition.equalsIgnoreCase("Outside") || this.percentLabelPosition.equalsIgnoreCase("Arrow") || this.percentLabelPosition.equalsIgnoreCase("Outside"))) {
            return;
        }
        switch (this.labelScheme) {
            case 1: {
                this.drawRadialOuterLabels(g);
                break;
            }
            case 2: {
                this.drawMarginOuterLabels(g);
                break;
            }
            case 0: {
                if (this.defaultLabelScheme == 1) {
                    this.drawRadialOuterLabels(g);
                    break;
                }
                if (this.defaultLabelScheme != 2) break;
                this.drawMarginOuterLabels(g);
            }
        }
    }

    private Rectangle drawLabelInBox(Rectangle box, Graphics2D g, FontRenderContext frc, int index, Slice slice, double[] angleList, boolean rightAlign) {
        int textHeight = (int)this.labels.getStringBounds("T", frc).getHeight();
        Rectangle rc = new Rectangle(box);
        int reqHeight = 0;
        String line1 = null;
        String line2 = null;
        String line3 = null;
        double line1Width = 0.0;
        double line2Width = 0.0;
        double line3Width = 0.0;
        if (this.nameLabelPosition.equalsIgnoreCase("Arrow") || this.nameLabelPosition.equalsIgnoreCase("Outside")) {
            reqHeight += textHeight;
            line1 = slice.getNonTruncatedDisplayName();
            line1Width = this.labels.getStringBounds(line1.trim(), frc).getWidth();
        }
        if (this.dataLabelPosition.equalsIgnoreCase("Arrow") || this.dataLabelPosition.equalsIgnoreCase("Outside")) {
            reqHeight += textHeight;
            line2 = this.getResponseString(slice);
            line2Width = this.labels.getStringBounds(line2.trim(), frc).getWidth();
        }
        if (this.percentLabelPosition.equalsIgnoreCase("Arrow") || this.percentLabelPosition.equalsIgnoreCase("Outside")) {
            reqHeight += textHeight;
            line3 = this.formatPercentLabel(slice);
            line3Width = this.labels.getStringBounds(line3.trim(), frc).getWidth();
        }
        int yPos = box.y + box.height - (box.height - reqHeight) / 2 - reqHeight;
        int curYPos = yPos - reqHeight / 2;
        rc.y = yPos;
        int xPos = box.x;
        int origXPos = xPos++;
        int largest = Integer.MIN_VALUE;
        if (!rightAlign) {
            // empty if block
        }
        Color backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
        if (line1 != null) {
            if (this.labels.getStringBounds(line1 = line1.trim(), frc).getWidth() > (double)box.width) {
                if (box.height - reqHeight > textHeight) {
                    String[] str = this.labels.wrap(line1, box.width, 2, frc);
                    if (str == null) {
                        return null;
                    }
                    if (rightAlign) {
                        for (int i = 0; i < str.length; ++i) {
                            int width = (int)this.labels.getStringBounds(str[i], frc).getWidth();
                            if (width <= largest) continue;
                            largest = width;
                        }
                        largest = Math.max(largest, (int)line2Width);
                        largest = Math.max(largest, (int)line3Width);
                        xPos += box.width - largest;
                    }
                    this.labels.drawText(g, str[0], new Point(xPos, curYPos += textHeight), true, backgroundColor);
                    rc.width = (int)this.labels.getStringBounds(str[0], frc).getWidth();
                    if (str.length > 1) {
                        curYPos += textHeight;
                        reqHeight += textHeight;
                        int w = (int)this.labels.getStringBounds(str[1], frc).getWidth();
                        if (w > rc.width) {
                            rc.width = w;
                        }
                        this.labels.drawText(g, str[1], new Point(xPos, curYPos), true, backgroundColor);
                    }
                } else {
                    curYPos += textHeight;
                    if (rightAlign) {
                        xPos += box.width - (int)this.labels.getStringBounds(slice.getDisplayName(), frc).getWidth();
                    }
                    rc.width = (int)this.labels.getStringBounds(slice.getDisplayName(), frc).getWidth();
                    this.labels.drawText(g, slice.getDisplayName(), new Point(xPos, curYPos), true, backgroundColor);
                }
            } else {
                curYPos += textHeight;
                if (rightAlign) {
                    xPos += box.width;
                    xPos = (int)((double)xPos - line1Width);
                }
                rc.width = (int)this.labels.getStringBounds(line1, frc).getWidth() + 2 * this.pieDefaults.labelSeperation;
                this.labels.drawText(g, line1, new Point(xPos, curYPos), true, backgroundColor);
            }
        }
        if (line2 != null) {
            int width;
            line2 = line2.trim();
            if (line2Width > (double)box.width) {
                line2 = this.truncatePieOuterLabel(line2, frc);
                line2Width = this.labels.getStringBounds(line2, frc).getWidth();
            }
            curYPos += textHeight;
            if (rightAlign) {
                xPos = origXPos + box.width;
                xPos = (int)((double)xPos - line2Width);
            }
            if ((width = (int)this.labels.getStringBounds(line2, frc).getWidth()) > rc.width) {
                rc.width = width;
            }
            this.labels.drawText(g, line2, new Point(xPos, curYPos), true, backgroundColor);
        }
        if (line3 != null) {
            int width;
            line3 = line3.trim();
            if (line3Width > (double)box.width) {
                line3 = this.truncatePieOuterLabel(line3, frc);
                line3Width = this.labels.getStringBounds(line3, frc).getWidth();
            }
            curYPos += textHeight;
            if (rightAlign) {
                xPos = origXPos + box.width;
                xPos = (int)((double)xPos - line3Width);
            }
            if ((width = (int)this.labels.getStringBounds(line3, frc).getWidth()) > rc.width) {
                rc.width = width;
            }
            this.labels.drawText(g, line3, new Point(xPos, curYPos), true, backgroundColor);
        }
        rc.x = xPos - this.pieDefaults.labelSeperation;
        rc.height = reqHeight;
        return box;
    }

    private void drawMarginOuterLabels(Graphics2D g) {
        Rectangle box;
        Rectangle rc;
        Point textPt;
        int numLines;
        Point pt1;
        int toDo;
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        Enumeration e = this.model.getGroups();
        Object group = e.nextElement();
        if (!this.angleListsComputed) {
            this.buildAngleLists();
        }
        Slice[] slices = this.model.getSlices(group);
        double[] angleList = (double[])this.angleLists.get(group);
        Double[] centerAngles = new Double[slices.length];
        for (int i = 0; i < centerAngles.length; ++i) {
            centerAngles[i] = new Double((double)this.startAngle + angleList[i] + (angleList[i + 1] - angleList[i]) * 0.5);
        }
        Vector<Integer> zeroTo90 = new Vector<Integer>();
        Vector<Integer> zeroTo270 = new Vector<Integer>();
        Vector<Integer> leftSide = new Vector<Integer>();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        for (int i = 0; i < centerAngles.length; ++i) {
            if (centerAngles[i] >= 0.0 && centerAngles[i] <= 90.0) {
                zeroTo90.addElement(new Integer(i));
                continue;
            }
            if (centerAngles[i] > 270.0) {
                zeroTo270.addElement(new Integer(i));
                continue;
            }
            leftSide.addElement(new Integer(i));
        }
        int rightSideStart = this.componentBounds.x + this.componentBounds.width - this.realMaxLabelWidth;
        int textHeight = (int)this.labels.getStringBounds("T", frc).getHeight();
        boolean topOrBottom = false;
        int lastLabelTop = 0;
        int firstLabelBot = 0;
        boolean firstTime = true;
        while (!zeroTo90.isEmpty()) {
            Rectangle box2;
            Rectangle rc2;
            int currLabelHt;
            int bot;
            int toDo2 = 0;
            int centerAngleIndex = (Integer)zeroTo90.elementAt(toDo2);
            zeroTo90.remove(toDo2);
            if (zeroTo90.isEmpty()) {
                topOrBottom = true;
            }
            Point pt12 = this.getPointForPolar((int)this.radius - this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
            int numLines2 = this.getNumLabelLines("Outside") + this.getNumLabelLines("Arrow");
            Point pt2 = topOrBottom && (double)this.componentBounds.height > this.radius * 2.0 + (double)(numLines2 * textHeight * 2) ? this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation * (numLines2 + 1), centerAngles[centerAngleIndex]) : this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
            pt12.x += this.center.x;
            pt12.y += this.center.y;
            pt2.x += this.center.x;
            pt2.y += this.center.y;
            int textXPos = rightSideStart;
            if ((double)textXPos > (double)this.center.x + this.radius * 1.5) {
                textXPos = (int)((double)this.center.x + this.radius * 1.5);
            }
            Point textPt2 = new Point(textXPos, pt2.y);
            if (!firstTime && (bot = textPt2.y + (int)((double)(currLabelHt = textHeight / 2 * numLines2) / 2.0)) > lastLabelTop) {
                textPt2.y -= bot - lastLabelTop;
            }
            if ((rc2 = this.drawLabelInBox(box2 = new Rectangle(textPt2.x, textPt2.y + textHeight / 2 * numLines2 / 2, this.realMaxLabelWidth, textHeight / 2 * numLines2), g, frc, centerAngleIndex, slices[centerAngleIndex], angleList, false)) == null) continue;
            if (topOrBottom && centerAngles[centerAngleIndex] <= 60.0) {
                pt2 = this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
                pt2.x += this.center.x;
                pt2.y += this.center.y;
            }
            if (pt2.x > textPt2.x - 5) {
                pt2.x = textPt2.x - 5;
                pt2.y = textPt2.y;
            }
            g.drawLine(pt12.x, pt12.y, pt2.x, pt2.y);
            g.drawLine(pt2.x, pt2.y, textPt2.x - 5, textPt2.y);
            if (firstTime) {
                firstLabelBot = textPt2.y + textHeight / 2 * numLines2 / 2 + 12;
            }
            if (topOrBottom) {
                topOrBottom = false;
            }
            firstTime = false;
            lastLabelTop = textPt2.y - textHeight / 2 * numLines2 / 2 - 12;
        }
        topOrBottom = false;
        int lastLabelBot = 0;
        firstTime = true;
        while (!zeroTo270.isEmpty()) {
            int top;
            int currLabelHt;
            toDo = zeroTo270.size() - 1;
            int centerAngleIndex = (Integer)zeroTo270.elementAt(toDo);
            zeroTo270.remove(toDo);
            if (zeroTo270.isEmpty()) {
                topOrBottom = true;
            }
            pt1 = this.getPointForPolar((int)this.radius - this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
            numLines = this.getNumLabelLines("Outside") + this.getNumLabelLines("Arrow");
            Point pt2 = topOrBottom && (double)this.componentBounds.height > this.radius * 2.0 + (double)(numLines * textHeight * 2) ? this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation * (numLines + 1), centerAngles[centerAngleIndex]) : this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
            pt1.x += this.center.x;
            pt1.y += this.center.y;
            pt2.x += this.center.x;
            pt2.y += this.center.y;
            int textXPos = rightSideStart;
            if ((double)textXPos > (double)this.center.x + this.radius * 1.5) {
                textXPos = (int)((double)this.center.x + this.radius * 1.5);
            }
            textPt = new Point(textXPos, pt2.y);
            if (!firstTime) {
                currLabelHt = textHeight / 2 * numLines;
                top = textPt.y - (int)((double)currLabelHt / 2.0);
                if (top < lastLabelBot) {
                    textPt.y += lastLabelBot - top;
                }
            } else {
                currLabelHt = textHeight / 2 * numLines;
                top = textPt.y - (int)((double)currLabelHt / 2.0);
                if (top < firstLabelBot) {
                    textPt.y += firstLabelBot - top;
                }
            }
            if ((rc = this.drawLabelInBox(box = new Rectangle(textPt.x, textPt.y + textHeight / 2 * numLines / 2, this.realMaxLabelWidth, textHeight / 2 * numLines), g, frc, centerAngleIndex, slices[centerAngleIndex], angleList, false)) == null) continue;
            if (topOrBottom && centerAngles[centerAngleIndex] >= 300.0) {
                pt2 = this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
                pt2.x += this.center.x;
                pt2.y += this.center.y;
            }
            if (pt2.x > textPt.x - 5) {
                pt2.x = textPt.x - 5;
                pt2.y = textPt.y;
            }
            g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
            g.drawLine(pt2.x, pt2.y, textPt.x - 5, textPt.y);
            firstTime = false;
            if (topOrBottom) {
                topOrBottom = false;
            }
            lastLabelBot = textPt.y + textHeight / 2 * numLines / 2 + 12;
        }
        topOrBottom = true;
        lastLabelBot = 0;
        firstTime = true;
        while (!leftSide.isEmpty()) {
            int currLabelHt;
            int top;
            toDo = 0;
            int centerAngleIndex = (Integer)leftSide.elementAt(toDo);
            leftSide.remove(toDo);
            if (leftSide.isEmpty()) {
                topOrBottom = true;
            }
            pt1 = this.getPointForPolar((int)this.radius - this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
            numLines = this.getNumLabelLines("Outside") + this.getNumLabelLines("Arrow");
            Point pt2 = topOrBottom && (double)this.componentBounds.height > this.radius * 2.0 + (double)(numLines * textHeight * 2) ? this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation * (numLines + 1), centerAngles[centerAngleIndex]) : this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
            pt1.x += this.center.x;
            pt1.y += this.center.y;
            pt2.x += this.center.x;
            pt2.y += this.center.y;
            int textXPos = this.componentBounds.x + this.realMaxLabelWidth;
            if ((double)textXPos < (double)this.center.x - this.radius * 1.5) {
                textXPos = (int)((double)this.center.x - this.radius * 1.5);
            }
            textPt = new Point(textXPos, pt2.y);
            if (!firstTime && (top = textPt.y - (int)((double)(currLabelHt = textHeight / 2 * numLines) / 2.0)) < lastLabelBot) {
                textPt.y += lastLabelBot - top;
            }
            if ((rc = this.drawLabelInBox(box = new Rectangle(textPt.x - this.realMaxLabelWidth, textPt.y + textHeight / 2 * numLines / 2, this.realMaxLabelWidth, textHeight / 2 * numLines), g, frc, centerAngleIndex, slices[centerAngleIndex], angleList, true)) == null) continue;
            if (topOrBottom && centerAngles[centerAngleIndex] >= 120.0 && centerAngles[centerAngleIndex] <= 240.0) {
                pt2 = this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation / 2, centerAngles[centerAngleIndex]);
                pt2.x += this.center.x;
                pt2.y += this.center.y;
            }
            if (pt2.x < textPt.x + 5) {
                pt2.x = textPt.x + 5;
                pt2.y = textPt.y;
            }
            g.drawLine(pt1.x, pt1.y, pt2.x, pt2.y);
            g.drawLine(pt2.x, pt2.y, textPt.x + 5, textPt.y);
            firstTime = false;
            if (topOrBottom) {
                topOrBottom = false;
            }
            lastLabelBot = textPt.y + textHeight / 2 * numLines / 2 + 12;
        }
    }

    private void drawRadialOuterLabels(Graphics2D g) {
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        Enumeration e = this.model.getGroups();
        Object group = e.nextElement();
        if (!this.angleListsComputed) {
            this.buildAngleLists();
        }
        double[] angleList = (double[])this.angleLists.get(group);
        Slice[] slices = this.model.getSlices(group);
        if (this.outerLabelBounds == null) {
            return;
        }
        for (int i = 0; i < this.outerLabelBounds.length; ++i) {
            String s;
            Dimension bounds = this.outerLabelBounds[i];
            if (bounds == null) continue;
            double an = (double)this.startAngle + angleList[i] + (angleList[i + 1] - angleList[i]) * 0.5;
            int x = 0;
            int y = 0;
            Point labelOrigin = this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation - 3, an);
            this.labels.setJustifySupported(true);
            if (this.nameLabelPosition.equalsIgnoreCase("Arrow") || this.dataLabelPosition.equalsIgnoreCase("Arrow") || this.percentLabelPosition.equalsIgnoreCase("Arrow")) {
                Point arrowOrigin = this.getPointForPolar((int)this.radius, an);
                g.drawLine(arrowOrigin.x + this.center.x, arrowOrigin.y + this.center.y, labelOrigin.x + this.center.x, labelOrigin.y + this.center.y);
            }
            labelOrigin = this.getPointForPolar((int)this.radius + this.pieDefaults.labelSeperation, an);
            int textHeight = (int)this.labels.getStringBounds("T", frc).getHeight();
            if (an <= 22.5 || an > 337.5) {
                x = labelOrigin.x;
                y = labelOrigin.y + bounds.height / 2;
                this.labels.setJustification(1, 8);
            } else if (an > 22.5 && an <= 67.5) {
                x = labelOrigin.x;
                y = labelOrigin.y;
                this.labels.setJustification(1, 8);
            } else if (an > 67.5 && an <= 112.5) {
                x = labelOrigin.x;
                y = labelOrigin.y;
                this.labels.setJustification(0, 8);
            } else if (an > 112.5 && an <= 157.5) {
                x = labelOrigin.x;
                y = labelOrigin.y;
                this.labels.setJustification(2, 8);
            } else if (an > 157.5 && an <= 202.5) {
                x = labelOrigin.x;
                y = labelOrigin.y + bounds.height / 2;
                this.labels.setJustification(2, 8);
            } else if (an > 202.5 && an <= 247.5) {
                x = labelOrigin.x;
                y = labelOrigin.y + bounds.height / 2;
                this.labels.setJustification(2, 8);
            } else if (an > 247.5 && an <= 292.5) {
                x = labelOrigin.x;
                y = labelOrigin.y + bounds.height - textHeight / 2;
                this.labels.setJustification(0, 8);
            } else if (an > 292.5 && an <= 337.5) {
                x = labelOrigin.x;
                y = labelOrigin.y + bounds.height / 2;
                this.labels.setJustification(1, 8);
            }
            this.labels.setCurrentValueAsDefault(9006);
            this.labels.setCurrentValueAsDefault(9007);
            int xPos = this.center.x + x;
            int yPos = this.center.y + y - bounds.height;
            Color backgroundColor = this.style.getFillStyleElement("Backfill").getFillColor();
            if (this.nameLabelPosition.equalsIgnoreCase("Arrow") || this.nameLabelPosition.equalsIgnoreCase("Outside")) {
                String str = slices[i].getDisplayName();
                this.labels.drawText(g, str.trim(), new Point(xPos, yPos += textHeight), true, backgroundColor);
            }
            if (this.dataLabelPosition.equalsIgnoreCase("Arrow") || this.dataLabelPosition.equalsIgnoreCase("Outside")) {
                s = this.getResponseString(slices[i]);
                this.labels.drawText(g, s.trim(), new Point(xPos, yPos += textHeight), true, backgroundColor);
            }
            if (!this.percentLabelPosition.equalsIgnoreCase("Arrow") && !this.percentLabelPosition.equalsIgnoreCase("Outside")) continue;
            s = this.formatPercentLabel(slices[i]);
            this.labels.drawText(g, s.trim(), new Point(xPos, yPos += textHeight), true, backgroundColor);
        }
        this.labels.setJustifySupported(false);
    }

    private String truncatePieOuterLabel(String label, FontRenderContext frc) {
        String rc = label;
        String elipsis = "...";
        int elipsisWidth = (int)this.labels.getStringBounds(elipsis, frc).getWidth();
        if ((double)this.maxLabelWidth < (double)elipsisWidth * 1.5) {
            return "";
        }
        while (rc.length() > 1 && this.labels.getStringBounds(rc, frc).getWidth() + (double)elipsisWidth > (double)this.maxLabelWidth) {
            rc = rc.substring(0, rc.length() - 2);
        }
        return rc + elipsis;
    }

    public Point getPointForPolar(int radius, double angle) {
        double rad = Math.PI / 180 * angle;
        return new Point((int)((double)radius * Math.cos(rad)), -((int)((double)radius * Math.sin(rad))));
    }

    public Slice getSliceAtPoint(Point p) {
        if (this.model == null) {
            return null;
        }
        Enumeration e = this.model.getGroups();
        while (e.hasMoreElements()) {
            Slice[] slices = this.model.getSlices(e.nextElement());
            for (int i = 0; i < slices.length; ++i) {
                if (slices[i].getSliceShape() == null || !slices[i].getSliceShape().contains(p)) continue;
                return slices[i];
            }
        }
        return null;
    }

    public double getTheta(Point p) {
        double result = 57.29577951308232 * Math.atan((double)p.y / (double)p.x);
        int quadrant = this.getQuadrant(p);
        double rc = 0.0;
        switch (quadrant) {
            case 1: {
                rc = Math.abs(result);
                break;
            }
            case 2: {
                rc = 90.0 + (90.0 - result);
                break;
            }
            case 3: {
                rc = 180.0 + Math.abs(result);
                break;
            }
            case 4: {
                rc = 270.0 + (90.0 - result);
            }
        }
        return rc;
    }

    private int getQuadrant(Point p) {
        if (p.x > 0 && p.y > 0) {
            return 4;
        }
        if (p.x < 0 && p.y > 0) {
            return 3;
        }
        if (p.x < 0 && p.y < 0) {
            return 2;
        }
        return 1;
    }

    public double distance(Point p1, Point p2) {
        if (p1 == null || p2 == null) {
            return 0.0;
        }
        int x = p1.x - p2.x;
        int y = p1.y - p2.y;
        return Math.sqrt(x * x + y * y);
    }

    public void setCenter(Point center) {
        this.center = center;
    }

    public Point getCenter() {
        return this.center;
    }

    public void setRadius(double radius) {
        this.radius = radius;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setStyle(Style style) {
        this.style = style;
        this.labels.setColor(style.getTextStyleElement("ValueText").getTextColor());
        this.labels.setCurrentValueAsDefault(9001);
        this.labels.setFont(style.getTextStyleElement("ValueText").getFont());
        this.labels.setCurrentValueAsDefault(9002);
        this.computeSliceColors();
    }

    private void buildAngleLists() {
        if (this.model == null) {
            return;
        }
        Enumeration e = this.model.getGroups();
        this.angleLists = new Hashtable();
        while (e.hasMoreElements()) {
            double angle;
            Object grp = e.nextElement();
            Slice[] slices = this.model.getSlices(grp);
            if (slices == null) continue;
            double responseSum = 0.0;
            for (int i = 0; i < slices.length; ++i) {
                double val = slices[i].getResponseValue();
                if (Double.isNaN(val)) continue;
                responseSum += val;
            }
            double[] angleList = new double[]{};
            if (responseSum <= 0.0) continue;
            angleList = new double[slices.length + 1];
            if (this.labelScheme == 0) {
                this.defaultLabelScheme = angleList.length > 7 ? 2 : 1;
            }
            if (this.labelScheme == 0 && angleList.length == 3 && this.model.getNumGroups() < 2) {
                double startAngle;
                angle = slices[0].getResponseValue() / responseSum * 360.0;
                angleList[0] = startAngle = 90.0 - slices[0].getResponseValue() / responseSum * 360.0 / 2.0;
                angleList[1] = startAngle + angle;
                angleList[2] = startAngle + 360.0;
            } else if (this.pieDirection == 0) {
                angle = 360.0;
                for (int i = 0; i < angleList.length - 1; ++i) {
                    angleList[i] = angle;
                    angle -= slices[i].getResponseValue() / responseSum * 360.0;
                }
                angleList[angleList.length - 1] = 0.0;
            } else {
                angle = 0.0;
                for (int i = 0; i < angleList.length - 1; ++i) {
                    angleList[i] = angle;
                    angle += slices[i].getResponseValue() / responseSum * 360.0;
                }
                angleList[angleList.length - 1] = 360.0;
            }
            this.angleLists.put(grp, angleList);
        }
        this.angleListsComputed = true;
    }

    public Text getLabels() {
        return this.labels;
    }

    public boolean setLabelFont(Text f) {
        if (f == null) {
            return false;
        }
        this.labels = f;
        return true;
    }

    public boolean areOutlinesVisible() {
        return this.outlinesVisible;
    }

    public void setOutlinesVisible(boolean b) {
        this.outlinesVisible = b;
    }

    public int getOutlineThickness() {
        return this.outlineThickness;
    }

    public void setOutlineThickness(int i) {
        this.outlineThickness = Math.min(10, Math.max(1, i));
    }

    public void setMaxLabelWidth(int width) {
        this.maxLabelWidth = width;
        this.outerLabelBounds = null;
    }

    public int getMaxLabelWidth() {
        return this.maxLabelWidth;
    }

    private void computeLabelBounds(Graphics2D g) {
        this.realMaxLabelWidth = 0;
        if (this.model.getAllGroupsCount() > 1) {
            return;
        }
        Enumeration e = this.model.getGroups();
        if (!e.hasMoreElements()) {
            return;
        }
        Object grp = e.nextElement();
        Slice[] slices = this.model.getSlices(grp);
        if (slices == null) {
            return;
        }
        FontRenderContext frc = null;
        frc = g != null ? g.getFontRenderContext() : new FontRenderContext(null, true, true);
        if (!this.angleListsComputed) {
            this.buildAngleLists();
        }
        if (!this.angleListsComputed) {
            return;
        }
        this.outerLabelBounds = new Dimension[slices.length];
        double[] angleList = (double[])this.angleLists.get(grp);
        for (int i = 0; i < this.outerLabelBounds.length; ++i) {
            slices[i].setTruncatedDisplayName(null);
            this.outerLabelBounds[i] = this.computeSliceOuterLabelBounds(slices[i], angleList[i + 1], angleList[1], frc);
            this.realMaxLabelWidth = Math.max(this.outerLabelBounds[i].width, this.realMaxLabelWidth);
        }
    }

    private Dimension computeSliceOuterLabelBounds(Slice slice, double startAngle, double endAngle, FontRenderContext frc) {
        String s;
        if (!(this.nameLabelPosition.equalsIgnoreCase("Arrow") || this.nameLabelPosition.equalsIgnoreCase("Outside") || this.dataLabelPosition.equalsIgnoreCase("Arrow") || this.dataLabelPosition.equalsIgnoreCase("Outside") || this.percentLabelPosition.equalsIgnoreCase("Arrow") || this.percentLabelPosition.equalsIgnoreCase("Outside"))) {
            return new Dimension(0, 0);
        }
        int height = (int)this.labels.getStringBounds("T", frc).getHeight();
        int rcHeight = 0;
        int rcWidth = 0;
        if (this.nameLabelPosition.equalsIgnoreCase("Arrow") || this.nameLabelPosition.equalsIgnoreCase("Outside")) {
            rcHeight += height;
            rcWidth = (int)this.labels.getStringBounds(slice.getDisplayName().trim(), frc).getWidth();
            if (rcWidth > this.maxLabelWidth) {
                slice.setTruncatedDisplayName(this.truncatePieOuterLabel(slice.getDisplayName(), frc));
                rcWidth = (int)this.labels.getStringBounds(slice.getDisplayName(), frc).getWidth();
                rcWidth = Math.min(rcWidth, this.maxLabelWidth);
            }
        }
        if (this.dataLabelPosition.equalsIgnoreCase("Arrow") || this.dataLabelPosition.equalsIgnoreCase("Outside")) {
            rcHeight += height;
            s = this.getResponseString(slice);
            rcWidth = Math.max(rcWidth, (int)this.labels.getStringBounds(s.trim(), frc).getWidth());
            rcWidth = Math.min(rcWidth, this.maxLabelWidth);
        }
        if (this.percentLabelPosition.equalsIgnoreCase("Arrow") || this.percentLabelPosition.equalsIgnoreCase("Outside")) {
            rcHeight += height;
            s = this.formatPercentLabel(slice);
            rcWidth = Math.max(rcWidth, (int)this.labels.getStringBounds(s.trim(), frc).getWidth());
            rcWidth = Math.min(rcWidth, this.maxLabelWidth);
        }
        return new Dimension(rcWidth, rcHeight);
    }

    private Dimension computeSliceInnerLabelBounds(Slice s, double startAngle, double endAngle, FontRenderContext frc) {
        String str;
        if (!(this.nameLabelPosition.equalsIgnoreCase("Inside") || this.dataLabelPosition.equalsIgnoreCase("Inside") || this.percentLabelPosition.equalsIgnoreCase("Inside"))) {
            return new Dimension(0, 0);
        }
        int height = (int)this.labels.getStringBounds("T", frc).getHeight();
        int rcHeight = 0;
        int rcWidth = 0;
        if (this.nameLabelPosition.equalsIgnoreCase("Inside")) {
            rcHeight += height;
            rcWidth = (int)this.labels.getStringBounds(s.getDisplayName().trim(), frc).getWidth();
        }
        if (this.dataLabelPosition.equalsIgnoreCase("Inside")) {
            rcHeight += height;
            str = this.getResponseString(s);
            rcWidth = Math.max(rcWidth, (int)this.labels.getStringBounds(str.trim(), frc).getWidth());
        }
        if (this.percentLabelPosition.equalsIgnoreCase("Inside")) {
            rcHeight += height;
            str = this.formatPercentLabel(s);
            rcWidth = Math.max(rcWidth, (int)this.labels.getStringBounds(str.trim(), frc).getWidth());
        }
        return new Dimension(rcWidth, rcHeight);
    }

    public double getLabelHeight(Graphics2D g) {
        return this.labels.getStringBounds("X", g.getFontRenderContext()).getHeight();
    }

    public int getOuterLabelWidth(Graphics2D g) {
        if (this.outerLabelBounds == null) {
            this.computeLabelBounds(g);
        }
        if (this.outerLabelBounds == null) {
            return 0;
        }
        int rc = 0;
        for (int i = 0; i < this.outerLabelBounds.length; ++i) {
            if (this.outerLabelBounds[i].width <= rc) continue;
            rc = this.outerLabelBounds[i].width;
        }
        return rc + this.pieDefaults.labelSeperation;
    }

    public int getOuterLabelHeight(Graphics2D g) {
        if (this.outerLabelBounds == null) {
            this.computeLabelBounds(g);
        }
        if (this.outerLabelBounds == null) {
            return 0;
        }
        int rc = 0;
        for (int i = 0; i < this.outerLabelBounds.length; ++i) {
            if (this.outerLabelBounds[i].height <= rc) continue;
            rc = this.outerLabelBounds[i].height;
        }
        return rc + this.pieDefaults.labelSeperation;
    }

    private boolean isValidLabelPosition(String s) {
        return s.equalsIgnoreCase("None") || s.equalsIgnoreCase("Outside") || s.equalsIgnoreCase("Inside") || s.equalsIgnoreCase("Arrow");
    }

    public String getNameLabelPosition() {
        return this.nameLabelPosition;
    }

    public boolean setNameLabelPosition(String s) {
        if (this.isValidLabelPosition(s)) {
            this.nameLabelPosition = s;
            return true;
        }
        return false;
    }

    public boolean setOtherLabel(String s) {
        if (s != null) {
            this.otherLabel = s;
            return true;
        }
        return false;
    }

    public String getDataLabelPosition() {
        return this.dataLabelPosition;
    }

    public boolean setDataLabelPosition(String s) {
        if (this.isValidLabelPosition(s)) {
            this.dataLabelPosition = s;
            return true;
        }
        return false;
    }

    public String getPercentLabelPosition() {
        return this.percentLabelPosition;
    }

    public boolean setPercentLabelPosition(String s) {
        if (this.isValidLabelPosition(s)) {
            this.percentLabelPosition = s;
            return true;
        }
        return false;
    }

    public boolean isTreatingOpacityValueAsTransparency() {
        return this.treatOpacityValueAsTransparency;
    }

    public void setTreatOpacityValueAsTransparency(boolean b) {
        this.treatOpacityValueAsTransparency = b;
    }

    public int getPieDirection() {
        return this.pieDirection;
    }

    public boolean setPieDirection(int dir) {
        if (dir != 0 && dir != 1) {
            return false;
        }
        this.pieDirection = dir;
        this.angleListsComputed = false;
        this.shapesComputed = false;
        return true;
    }

    public int getStartAngle() {
        return this.startAngle;
    }

    public boolean setStartAngle(int angle) {
        this.startAngle = angle % 360;
        return true;
    }

    public Vector getURLConsumers() {
        return this.urlConsumers;
    }

    public void setComponentBounds(Rectangle r) {
        this.componentBounds = r;
    }

    public LegendEntryInterface[] getLegendEntries() {
        if (this.globalSliceColors == null) {
            return null;
        }
        if (!this.sliceColorsComputed) {
            this.computeSliceColors();
        }
        Color[] colors = new Color[this.globalSliceColors.size()];
        Object[] labels = new Object[this.globalSliceColors.size()];
        Hashtable uToFCatHash = this.model.getUnformatToFormatHash();
        Enumeration unformattedVals = uToFCatHash.keys();
        Object[] sortedUnfArray = new Object[Math.max(this.globalSliceColors.size(), uToFCatHash.size())];
        int current = 0;
        while (unformattedVals.hasMoreElements()) {
            Object obj = unformattedVals.nextElement();
            if (obj instanceof Double && !((Double)obj).isNaN() || !(obj instanceof String) || !uToFCatHash.containsKey(new Double(Double.NaN))) continue;
            Object ob = uToFCatHash.remove(new Double(Double.NaN));
            uToFCatHash.put(Slice.MISSING_STRING, ob);
        }
        current = 0;
        unformattedVals = uToFCatHash.keys();
        Double NUMBER_OTHER_PLACE_HOLDER = new Double(Double.MAX_VALUE);
        String STRING_OTHER_PLACE_HOLDER = "}Other}";
        while (unformattedVals.hasMoreElements()) {
            Object obj = unformattedVals.nextElement();
            sortedUnfArray[current] = obj instanceof Double && ((Double)obj).isNaN() ? new Double(Double.NaN) : (obj instanceof String && (String)obj == Slice.MISSING_SLICE ? Slice.MISSING_SLICE : (obj instanceof String && (String)obj == Slice.MISSING_STRING ? Slice.MISSING_STRING : (obj instanceof String && ((String)obj).equals("}Other}") ? "}Other}" : (obj instanceof Double && ((Double)obj).doubleValue() == NUMBER_OTHER_PLACE_HOLDER.doubleValue() ? NUMBER_OTHER_PLACE_HOLDER : obj))));
            ++current;
        }
        if (sortedUnfArray != null && sortedUnfArray.length > 1) {
            Arrays.sort(sortedUnfArray);
        }
        if (sortedUnfArray[0].equals(Slice.MISSING_STRING)) {
            Object temp = sortedUnfArray[0];
            for (int i = 0; i < sortedUnfArray.length; ++i) {
                sortedUnfArray[i] = i == sortedUnfArray.length - 1 ? temp : sortedUnfArray[i + 1];
            }
        }
        int labelI = 0;
        for (current = 0; current < sortedUnfArray.length && labelI < labels.length; ++current) {
            if (this.globalSliceColors.get(uToFCatHash.get(sortedUnfArray[current])) != null) {
                labels[labelI] = uToFCatHash.get(sortedUnfArray[current]);
                colors[labelI] = (Color)this.globalSliceColors.get(labels[labelI]);
                if (labels[labelI] == Slice.MISSING_SLICE) {
                    labels[labelI] = this.model.getDataFilter().getFormattedValue(this.model.getCategoryVariable(), sortedUnfArray[current], null);
                }
                ++labelI;
            }
            if (this.globalSliceColors.get(uToFCatHash.get(sortedUnfArray[current])) != null || uToFCatHash.get(sortedUnfArray[current]) != Slice.MISSING_STRING) continue;
            labels[labelI] = this.model.getDataFilter().getFormattedValue(this.model.getCategoryVariable(), sortedUnfArray[current], null);
            colors[labelI] = (Color)this.globalSliceColors.get(Slice.MISSING_SLICE);
            ++labelI;
        }
        if (colors == null || colors.length == 0) {
            return null;
        }
        LegendEntryInterface[] legEntries = new LegendEntryInterface[colors.length];
        for (int i = 0; i < colors.length; ++i) {
            MarkerAttrib ms = new MarkerAttrib();
            if (colors != null && colors[i] != null) {
                ms.setColor(colors[i]);
            }
            if (labels[i] == Slice.MISSING_STRING) {
                labels[i] = "";
            }
            legEntries[i] = new LegendEntry(labels[i], ms, null);
        }
        return legEntries;
    }

    public boolean isDrawGroupLabels() {
        return this.drawGroupLabels;
    }

    public void setDrawGroupLabels(boolean drawGroupLabels) {
        this.drawGroupLabels = drawGroupLabels;
    }

    public int getGroupLabelAreaWidth() {
        return this.groupLabelAreaWidth;
    }

    public void setGroupLabelAreaWidth(int groupLabelAreaWidth) {
        this.groupLabelAreaWidth = groupLabelAreaWidth;
    }

    public int getLabelScheme() {
        return this.labelScheme;
    }

    public boolean setLabelScheme(int ls) {
        if (ls != 2 && ls != 1 && ls != 0) {
            return false;
        }
        this.labelScheme = ls;
        return true;
    }
}

