/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.info;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.data.JTableDataFilter;
import com.sas.graphics.silk.info.RoleInfo;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.SourceInterface;
import com.sas.graphics.silk.ui.NoPropertiesLabel;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.xml.SILKParser;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.awt.Component;
import java.awt.Image;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.ListSelectionModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SILKChartInfo {
    private ResourceBundle rb = ResourceLoader.loadBundle((String)"com/sas/graphics/silk/info/silk_info_NLS");
    private Element element = null;
    private static Properties lookupTable = null;
    private static Hashtable imageCache = null;
    private static JComponent dummyComponent = new NoPropertiesLabel();
    private static Hashtable instanceCache = new Hashtable();
    private Roles roles = null;

    protected SILKChartInfo() {
        if (imageCache == null) {
            imageCache = new Hashtable();
        }
    }

    public static SILKChartInfo getInstance(Object chart) {
        String classname;
        if (chart == null) {
            return null;
        }
        if (lookupTable == null) {
            lookupTable = ResourceLoader.loadProperties((String)"com/sas/graphics/silk/info/lookuptable.config");
        }
        String string = classname = chart instanceof String ? (String)chart : chart.getClass().getName();
        if (lookupTable == null || !lookupTable.containsKey(classname)) {
            return null;
        }
        String xmlFile = lookupTable.getProperty(classname);
        if (instanceCache.containsKey(xmlFile)) {
            return (SILKChartInfo)instanceCache.get(xmlFile);
        }
        SILKChartInfo rc = SILKChartInfo.getInstance(SILKChartInfo.class.getResourceAsStream(xmlFile));
        if (rc != null) {
            instanceCache.put(xmlFile, rc);
        }
        return rc;
    }

    private static SILKChartInfo getInstance(InputStream is) {
        return SILKChartInfo.getInstance(SILKParser.getElement(is));
    }

    private static SILKChartInfo getInstance(Element element) {
        if (element == null || !element.hasAttribute("classname")) {
            return null;
        }
        SILKChartInfo rc = (SILKChartInfo)SILKChartInfo.loadClass(element.getAttribute("classname"), SILKChartInfo.class);
        if (rc != null) {
            rc.setChartElement(element);
        }
        return rc;
    }

    private void setChartElement(Element element) {
        this.element = element;
    }

    public String getName() {
        return this.element.getAttribute("name");
    }

    public String getDisplayName() {
        return ResourceLoader.getResourceString((Object)this.rb, (String)this.element.getAttribute("displayNameKey"), (String)this.getName());
    }

    public String getDescription() {
        if (this.element == null) {
            return null;
        }
        Element e = ParserUtils.getChildWithTagName((String)"Description", (Element)this.element);
        if (e == null) {
            return null;
        }
        return ResourceLoader.getResourceString((Object)this.rb, (String)e.getAttribute("key"), (String)this.getDisplayName());
    }

    private Image loadImage(String imagePath) {
        if (imageCache.containsKey(imagePath)) {
            return (Image)imageCache.get(imagePath);
        }
        Image i = ResourceLoader.getImage((Component)dummyComponent, (String)imagePath);
        if (i == null) {
            return null;
        }
        imageCache.put(imagePath, i);
        return i;
    }

    public Icon getIcon() {
        if (!this.element.hasAttribute("icon")) {
            return null;
        }
        String iconPath = this.element.getAttribute("icon");
        Image i = this.loadImage(iconPath);
        if (i == null) {
            return null;
        }
        return new ImageIcon(i);
    }

    public Image getImage() {
        if (!this.element.hasAttribute("image")) {
            return null;
        }
        String iconPath = this.element.getAttribute("image");
        Image i = this.loadImage(iconPath);
        return i;
    }

    private static Object loadClass(String classname, Class type) {
        if (classname != null) {
            try {
                Class<?> c = Class.forName(classname);
                Object o = c.newInstance();
                if (type.isInstance(o)) {
                    return o;
                }
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public BaseElement newElementInstance() {
        return (BaseElement)SILKChartInfo.loadClass(this.element.getAttribute("chartElement"), BaseElement.class);
    }

    public String getComponentClassname() {
        return this.element.getAttribute("component");
    }

    public String getElementClassname() {
        return this.element.getAttribute("chartElement");
    }

    public Component newCommponentInstance() {
        return (Component)SILKChartInfo.loadClass(this.element.getAttribute("component"), Component.class);
    }

    public boolean requiresMultipleRoleAssignments() {
        if (this.element == null) {
            return false;
        }
        return ParserUtils.getBooleanValue((String)this.element.getAttribute("requiresMultipleRoleAssignment"));
    }

    public boolean areRequiredRolesAssigned(Object chart) {
        RoleInfo[] info = this.getRequiredRoles(chart);
        if (info == null || info.length == 0) {
            return true;
        }
        if (chart == null) {
            return false;
        }
        if (!(chart instanceof RoleInterface)) {
            return true;
        }
        for (int i = 0; i < info.length; ++i) {
            String roleName = info[i].getRoleName();
            Object vars = ((RoleInterface)chart).getAllVariables((Object)this.roles.getRoleObjectForUSName(roleName));
            if (vars == null) {
                return false;
            }
            int num = Extract.getNumberItems((Object)vars, (int)Extract.getSourceType((Object)vars));
            if (num >= info[i].getNumRequired()) continue;
            return false;
        }
        return true;
    }

    public void assignDataSource(Object chart, Object source) {
        String defaultDataId = null;
        if (this.element.hasAttribute("defaultDataId")) {
            defaultDataId = this.element.getAttribute("defaultDataId");
        }
        Object realSource = source;
        if (source instanceof DataInterface) {
            DataInterface di = (DataInterface)source;
            if (chart instanceof SourceInterface) {
                Object[] ids = ((SourceInterface)chart).getDataIds();
                for (int i = 0; i < ids.length; ++i) {
                    DataFilterReadInterface o = di.getDataSource(ids[i]);
                    if (o == null) continue;
                    ((SourceInterface)chart).setDataSource((Object)ids[i].toString(), (Object)o);
                }
            }
        } else {
            while (realSource instanceof DataFilterReadInterface && ((DataFilterReadInterface)realSource).getSource() != realSource) {
                realSource = ((DataFilterReadInterface)realSource).getSource();
            }
            if (source instanceof JTableDataFilter) {
                ListSelectionModel lsm = ((JTableDataFilter)source).getListSelectionModel();
                JTableDataFilter filter = new JTableDataFilter(realSource, null);
                filter.setListSelectionModel(lsm);
                if (defaultDataId == null) {
                    ((SourceInterface)chart).setDataSource((Object)filter);
                } else {
                    ((SourceInterface)chart).setDataSource((Object)filter, (Object)defaultDataId);
                }
            } else if (chart instanceof SourceInterface) {
                if (defaultDataId == null) {
                    ((SourceInterface)chart).setDataSource(realSource);
                } else {
                    ((SourceInterface)chart).setDataSource(realSource, (Object)defaultDataId);
                }
            }
        }
    }

    public RoleInfo[] getRequiredRoles(Object chart) {
        Vector<RoleInfo> requiredRoles = new Vector<RoleInfo>();
        int index = 1;
        Element role = null;
        while ((role = ParserUtils.getChildWithTagName((String)"RequiredRole", (Element)this.element, (int)index++)) != null) {
            requiredRoles.addElement(new RoleInfo(role, this.getRoles()));
        }
        Object[] rc = new RoleInfo[requiredRoles.size()];
        requiredRoles.copyInto(rc);
        return rc;
    }

    private Roles getRoles() {
        if (this.roles == null) {
            this.roles = Roles.getInstance(null);
        }
        return this.roles;
    }

    public void doXMLInit(Object chart) {
        Element xmlInit = ParserUtils.getChildWithTagName((String)"XMLInit", (Element)this.element);
        if (xmlInit != null) {
            NodeList nodes = xmlInit.getChildNodes();
            Node child = null;
            for (int i = 0; i < nodes.getLength(); ++i) {
                if (nodes.item(i).getNodeType() != 1) continue;
                child = nodes.item(i);
            }
            if (child != null) {
                SILKParser.initComponentFromXML(chart, (Element)child, null);
            }
        }
    }
}

