/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.info;

import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import java.util.Vector;
import org.w3c.dom.Element;

public class RoleInfo {
    public static final int ANY = 0;
    public static final int NUMERIC = 1;
    public static final int CHARACHTER = 2;
    private int prefferedType = 0;
    private Vector variableNameHints = null;
    private Roles roles = null;
    private String roleKey = null;
    private int numToAssign = 1;
    private int numRequired = 1;

    public RoleInfo(Roles roles) {
        this.roles = roles;
    }

    public RoleInfo(Element info, Roles roles) {
        this(roles);
        this.initFromXML(info);
    }

    public int getPrefferedType() {
        return this.prefferedType;
    }

    public String getRoleName() {
        return this.roles.getRoleUSName(this.roleKey);
    }

    public String getRoleDisplayName() {
        return this.roles.getRoleNLSName(this.roleKey);
    }

    public SILKNumber getRoleObject() {
        return this.roles.getRoleObject(this.roleKey);
    }

    public void initFromXML(Element roleInfo) {
        if (roleInfo == null) {
            return;
        }
        if (roleInfo.hasAttribute("preferredType")) {
            String pt = roleInfo.getAttribute("preferredType");
            this.prefferedType = pt.equalsIgnoreCase("Numeric") ? 1 : (pt.equalsIgnoreCase("Charachter") ? 2 : 0);
        }
        this.roleKey = roleInfo.getAttribute("roleName");
        if (roleInfo.hasAttribute("variableNameHint")) {
            this.variableNameHints = new Vector();
            String[] hints = ParserUtils.parseStringArray((String)roleInfo.getAttribute("variableNameHint"), (String)",");
            for (int i = 0; i < hints.length; ++i) {
                this.variableNameHints.addElement(hints[i]);
            }
        }
        if (roleInfo.hasAttribute("numToAssign")) {
            this.numToAssign = ParserUtils.getIntValue((String)roleInfo.getAttribute("numToAssign"));
        }
        if (roleInfo.hasAttribute("numRequired")) {
            this.numRequired = ParserUtils.getIntValue((String)roleInfo.getAttribute("numRequired"));
        }
    }

    public String[] getVariableNameHints() {
        if (this.variableNameHints == null) {
            return new String[0];
        }
        Object[] rc = new String[this.variableNameHints.size()];
        this.variableNameHints.copyInto(rc);
        return rc;
    }

    public int getNumToAssign() {
        return this.numToAssign;
    }

    public int getNumRequired() {
        return this.numRequired;
    }
}

