/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.info;

import com.sas.graphics.silk.data.StableHeapSort;
import com.sas.graphics.silk.info.RoleInfo;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.util.Extract;
import java.util.Hashtable;
import java.util.Vector;

public class RoleAssigner {
    protected DataFilterReadInterface filter;
    protected SILKChartInfo info = null;
    private Hashtable varIndices = new Hashtable();

    public RoleAssigner(DataFilterReadInterface filter, SILKChartInfo info) {
        this.filter = filter;
        this.info = info;
    }

    public void doRoleAssignments(RoleInterface chart) {
        int i;
        RoleInfo[] roles = this.info.getRequiredRoles(chart);
        if (this.filter == null) {
            return;
        }
        Object[] varids = new Object[this.filter.getNumberVariables()];
        int[] indexes = new int[this.filter.getNumberVariables()];
        Vector<Object> vec = new Vector<Object>();
        for (i = 0; i < this.filter.getNumberVariables(); ++i) {
            vec.add(this.filter.getVariableId(i));
            indexes[i] = i;
        }
        StableHeapSort.heapSort(vec, indexes, 1, 0, vec.size() - 1);
        for (i = 0; i < this.filter.getNumberVariables(); ++i) {
            varids[i] = vec.elementAt(indexes[i]);
        }
        boolean[] assignedVariables = new boolean[this.filter.getNumberVariables()];
        Vector<RoleInfo> rolesAssigned = new Vector<RoleInfo>();
        for (int i2 = 0; i2 < roles.length; ++i2) {
            RoleInfo ri = roles[i2];
            boolean assigned = false;
            boolean beenAssigned = false;
            if (rolesAssigned.contains(roles[i2])) {
                beenAssigned = true;
            }
            int numAssigned = 0;
            Object allVars = chart.getAllVariables(ri.getRoleName());
            numAssigned = Extract.getNumberItems((Object)allVars, (int)Extract.getSourceType((Object)allVars));
            int numToAssign = ri.getNumToAssign();
            if (numToAssign <= numAssigned) continue;
            if (!assigned && ri.getVariableNameHints() != null) {
                String[] hints = ri.getVariableNameHints();
                for (int j = 0; j < hints.length; ++j) {
                    int index = this.filter.getVariableIndex((Object)hints[j]);
                    if (index == -1) continue;
                    if (beenAssigned) {
                        chart.addRole(hints[j], ri.getRoleName());
                    } else {
                        chart.setRole(hints[j], ri.getRoleName());
                    }
                    assignedVariables[index] = true;
                    ++numAssigned;
                    assigned = true;
                }
            }
            int numLeftToAssign = numToAssign - numAssigned;
            for (int k = 0; k < numLeftToAssign; ++k) {
                Object variableId = null;
                int index = -1;
                if (ri.getPrefferedType() == 1) {
                    index = this.getNextNumeric(indexes, 0, varids, assignedVariables);
                } else if (ri.getPrefferedType() == 2) {
                    index = this.getNextCharachter(indexes, 0, varids, assignedVariables);
                }
                if (index >= 0) {
                    variableId = varids[index];
                }
                if (variableId != null) {
                    if (numAssigned >= 1) {
                        chart.addRole(variableId, roles[i2].getRoleName());
                    } else {
                        chart.setRole(variableId, roles[i2].getRoleName());
                    }
                    assigned = true;
                    ++numAssigned;
                    assignedVariables[index] = true;
                    continue;
                }
                if (ri.getPrefferedType() == 1) {
                    index = this.getNextCharachter(indexes, 0, varids, assignedVariables);
                } else if (ri.getPrefferedType() == 2) {
                    index = this.getNextNumeric(indexes, 0, varids, assignedVariables);
                }
                if (index >= 0) {
                    variableId = varids[index];
                }
                if (variableId == null) continue;
                if (numAssigned >= 1) {
                    chart.addRole(variableId, roles[i2].getRoleName());
                } else {
                    chart.setRole(variableId, roles[i2].getRoleName());
                }
                assigned = true;
                ++numAssigned;
                assignedVariables[index] = true;
            }
            if (!assigned || beenAssigned) continue;
            rolesAssigned.addElement(roles[i2]);
        }
    }

    protected int getNextNumeric(int[] indexes, int lastIndex, Object[] varids, boolean[] assigned) {
        for (int i = lastIndex; i < this.filter.getNumberVariables(); ++i) {
            if (assigned[i]) continue;
            int idx = -1;
            if (!this.varIndices.containsKey(varids[i])) {
                this.varIndices.put(varids[i], indexes[i]);
            }
            if (!this.filter.isNumericVariable(idx = ((Number)this.varIndices.get(varids[i])).intValue())) continue;
            return i;
        }
        return -1;
    }

    protected int getNextCharachter(int[] indexes, int lastIndex, Object[] varids, boolean[] assigned) {
        for (int i = lastIndex; i < this.filter.getNumberVariables(); ++i) {
            if (assigned[i]) continue;
            int idx = -1;
            if (!this.varIndices.containsKey(varids[i])) {
                this.varIndices.put(varids[i], indexes[i]);
            }
            if (this.filter.isNumericVariable(idx = ((Number)this.varIndices.get(varids[i])).intValue())) continue;
            return i;
        }
        return -1;
    }

    protected int getNextNumeric(boolean[] vars, Object[] varids, boolean[] assigned) {
        for (int i = 0; i < vars.length; ++i) {
            if (assigned[i] || !vars[i]) continue;
            return i;
        }
        return -1;
    }

    protected int getNextCharachter(boolean[] vars, Object[] varids, boolean[] assigned) {
        for (int i = 0; i < vars.length; ++i) {
            if (assigned[i] || vars[i]) continue;
            return i;
        }
        return -1;
    }
}

