/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.info;

import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.base.BaseElementComponent;
import com.sas.graphics.silk.info.RoleAssigner;
import com.sas.graphics.silk.info.RoleInfo;
import com.sas.graphics.silk.info.SILKChartInfo;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.SortedVector;
import java.util.Enumeration;
import java.util.Vector;

public class OverlayRoleAssigner
extends RoleAssigner {
    private BaseElementComponent overlay = null;

    public OverlayRoleAssigner(DataFilterReadInterface filter, SILKChartInfo info, BaseElementComponent overlay) {
        super(filter, info);
        this.overlay = overlay;
    }

    @Override
    public void doRoleAssignments(RoleInterface chart) {
        int i;
        if (chart == null) {
            return;
        }
        if (this.overlay == null || this.overlay.getCharts() == null || this.overlay.getCharts().length == 0) {
            super.doRoleAssignments(chart);
            return;
        }
        BaseElement primary = this.overlay.getPrimary();
        RoleInfo[] roles = this.info.getRequiredRoles(chart);
        if (this.filter == null) {
            return;
        }
        Object[] varids = new Object[this.filter.getNumberVariables()];
        SortedVector sv = new SortedVector();
        sv.setSortingOn(false);
        for (i = 0; i < this.filter.getNumberVariables(); ++i) {
            sv.addElement(this.filter.getVariableId(i));
        }
        sv.setSortingOn(true);
        for (i = 0; i < varids.length; ++i) {
            varids[i] = sv.elementAt(i);
        }
        boolean[] vars = new boolean[this.filter.getNumberVariables()];
        for (int i2 = 0; i2 < vars.length; ++i2) {
            vars[i2] = this.filter.isNumericVariable(varids[i2]);
        }
        boolean[] assignedVariables = new boolean[this.filter.getNumberVariables()];
        Vector<RoleInfo> rolesAssigned = new Vector<RoleInfo>();
        for (int i3 = 0; i3 < roles.length; ++i3) {
            Object variableId;
            Object v;
            RoleInfo ri = roles[i3];
            boolean assigned = false;
            boolean beenAssigned = false;
            if (rolesAssigned.contains(roles[i3])) {
                beenAssigned = true;
            }
            if (!assigned && ri.getVariableNameHints() != null) {
                String[] hints = ri.getVariableNameHints();
                for (int j = 0; j < hints.length; ++j) {
                    int index = this.filter.getVariableIndex((Object)hints[j]);
                    if (index == -1) continue;
                    if (beenAssigned) {
                        chart.addRole(hints[j], roles[i3].getRoleName());
                    } else {
                        chart.setRole(hints[j], roles[i3].getRoleName());
                    }
                    for (int k = 0; k < varids.length; ++k) {
                        if (!hints[j].equalsIgnoreCase(varids[k].toString())) continue;
                        assignedVariables[k] = true;
                    }
                    assigned = true;
                }
            }
            if (!assigned && primary != null && (v = primary.getAllVariables(roles[i3].getRoleName())) != null) {
                Enumeration e = Extract.elements((Object)v);
                while (e.hasMoreElements() && !assigned) {
                    boolean res;
                    Object variable = e.nextElement();
                    if (!this.filter.verifyVariable(variable) || !(res = chart.setRole(variable, roles[i3].getRoleName()))) continue;
                    assigned = true;
                    for (int k = 0; k < varids.length; ++k) {
                        if (!variable.toString().equalsIgnoreCase(varids[k].toString())) continue;
                        assignedVariables[k] = true;
                    }
                }
            }
            if (!assigned) {
                variableId = null;
                int index = -1;
                if (ri.getPrefferedType() == 1) {
                    index = this.getNextNumeric(vars, varids, assignedVariables);
                } else if (ri.getPrefferedType() == 2) {
                    index = this.getNextCharachter(vars, varids, assignedVariables);
                }
                if (index >= 0) {
                    variableId = varids[index];
                }
                if (variableId != null) {
                    if (beenAssigned) {
                        chart.addRole(variableId, roles[i3].getRoleName());
                    } else {
                        chart.setRole(variableId, roles[i3].getRoleName());
                    }
                    assigned = true;
                    assignedVariables[index] = true;
                }
            }
            if (!assigned) {
                variableId = null;
                int index = -1;
                if (ri.getPrefferedType() == 1) {
                    index = this.getNextCharachter(vars, varids, assignedVariables);
                } else if (ri.getPrefferedType() == 2) {
                    index = this.getNextNumeric(vars, varids, assignedVariables);
                }
                if (index >= 0) {
                    variableId = varids[index];
                }
                if (variableId != null) {
                    if (beenAssigned) {
                        chart.addRole(variableId, roles[i3].getRoleName());
                    } else {
                        chart.setRole(variableId, roles[i3].getRoleName());
                    }
                    assigned = true;
                    assignedVariables[index] = true;
                }
            }
            if (!assigned || beenAssigned) continue;
            rolesAssigned.addElement(roles[i3]);
        }
    }
}

