/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.histogram;

import com.sas.graphics.silk.HistogramComponent;
import com.sas.graphics.silk.histogram.HistogramChart;
import com.sas.graphics.silk.histogram.HistogramPreviewRedrawEvent;
import com.sas.graphics.silk.histogram.HistogramPreviewRedrawListener;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.util.ResourceLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.util.Vector;
import javax.swing.JPanel;

public class HistogramPreviewPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
TransformInterface,
HistogramPreviewRedrawListener {
    private static final long serialVersionUID = 2680633339735286341L;
    protected static final int BORDER = 16;
    protected static final int NONE = 0;
    protected static final int MOVE = 1;
    protected static final int RESIZE_L = 2;
    protected static final int RESIZE_R = 3;
    protected static final int RESIZE_T = 4;
    protected static final int RESIZE_B = 5;
    protected static final int RESIZE_TL = 6;
    protected static final int RESIZE_TR = 7;
    protected static final int RESIZE_BL = 8;
    protected static final int RESIZE_BR = 9;
    protected static final int MIN_SIZE = 4;
    protected static final int HANDLE_SIZE = 6;
    protected int xMargin = 16;
    protected int yMargin = 16;
    protected int compWidth = 0;
    protected int compHeight = 0;
    protected int viewportX = this.xMargin;
    protected int viewportY = this.yMargin;
    protected int viewportWidth = this.compWidth - 2 * this.xMargin;
    protected int viewportHeight = this.compHeight - 2 * this.yMargin;
    protected int chartClipX = this.viewportX;
    protected int chartClipY = this.viewportY;
    protected int chartClipWidth = this.viewportWidth;
    protected int chartClipHeight = this.viewportHeight;
    protected Image backBuffer = null;
    protected Image backBuffer2 = null;
    protected Insets chartOuterMargin = new Insets(0, 0, 0, 0);
    protected double[] chartBBox = null;
    protected HistogramChart chart = null;
    protected Color backgroundColor = Color.white;
    protected boolean redrawBackBuffer = false;
    protected Rectangle2D.Double viewportRect;
    protected Rectangle2D.Double rubberband = null;
    protected Point startPt;
    protected int action;
    protected Rectangle2D.Double resizeL;
    protected Rectangle2D.Double resizeR;
    protected Rectangle2D.Double resizeT;
    protected Rectangle2D.Double resizeB;
    protected Rectangle2D.Double resizeTL;
    protected Rectangle2D.Double resizeTR;
    protected Rectangle2D.Double resizeBL;
    protected Rectangle2D.Double resizeBR;
    protected boolean error = false;
    protected Cursor openMoveCursor;
    protected Cursor closeMoveCursor;

    public HistogramPreviewPanel() {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image img = ResourceLoader.getImage((Component)this, (String)"icons/MoveOpen.gif");
        this.openMoveCursor = tk.createCustomCursor(img, new Point(6, 2), "icons/MoveOpen.gif");
        img = ResourceLoader.getImage((Component)this, (String)"icons/MoveClosed.gif");
        this.closeMoveCursor = tk.createCustomCursor(img, new Point(6, 2), "icons/MoveClosed.gif");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    public HistogramPreviewPanel(HistogramComponent hist) {
        this();
        this.setComponent(hist);
    }

    public void setComponent(HistogramComponent hist) {
        this.chart = (HistogramChart)hist.getChart();
        hist.addHistogramPreviewRedrawListener(this);
    }

    public void setChartBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        if (this.chartBBox == null) {
            this.chartBBox = new double[6];
        }
        this.chartBBox[0] = xmin;
        this.chartBBox[1] = ymin;
        this.chartBBox[2] = zmin;
        this.chartBBox[3] = xmax;
        this.chartBBox[4] = ymax;
        this.chartBBox[5] = zmax;
        this.viewportRect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        this.updateChartClipArea();
        this.redrawBackBuffer = true;
    }

    public void setRubberbandBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        Rectangle2D.Double rect = new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
        this.viewportRect.setRect(rect);
        this.repaint();
    }

    protected int getMouseSpot(Point pt) {
        this.createHandleRects();
        int spot = 0;
        if (this.resizeL.contains(pt)) {
            spot = 2;
        } else if (this.resizeR.contains(pt)) {
            spot = 3;
        }
        if (this.chart.getHistogramModel().isBivariateHistogram() && spot == 0) {
            if (this.resizeT.contains(pt)) {
                spot = 4;
            } else if (this.resizeB.contains(pt)) {
                spot = 5;
            } else if (this.resizeTL.contains(pt)) {
                spot = 6;
            } else if (this.resizeTR.contains(pt)) {
                spot = 7;
            } else if (this.resizeBL.contains(pt)) {
                spot = 8;
            } else if (this.resizeBR.contains(pt)) {
                spot = 9;
            }
        }
        if (spot == 0 && this.rubberband.contains(pt)) {
            spot = 1;
        }
        return spot;
    }

    private void createHandleRects() {
        if (this.rubberband.width > 24.0 && this.rubberband.height > 24.0) {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y - 3.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width - 3.0, this.rubberband.y + this.rubberband.height - 3.0, 6.0, 6.0);
        } else {
            this.resizeL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + 0.5 * this.rubberband.height - 3.0, 6.0, 6.0);
            this.resizeT = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeB = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width * 0.5 - 3.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeTL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeTR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y - 6.0, 6.0, 6.0);
            this.resizeBL = new Rectangle2D.Double(this.rubberband.x - 6.0, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
            this.resizeBR = new Rectangle2D.Double(this.rubberband.x + this.rubberband.width, this.rubberband.y + this.rubberband.height, 6.0, 6.0);
        }
    }

    protected void updateChartClipArea() {
        this.chartClipX = this.viewportX + this.chartOuterMargin.left;
        this.chartClipY = this.viewportY + this.chartOuterMargin.top;
        this.chartClipWidth = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        this.chartClipHeight = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
    }

    protected void resizePanel(int width, int height) {
        this.compWidth = width;
        this.compHeight = height;
        if (this.backBuffer == null || width > this.backBuffer.getWidth(this) || height > this.backBuffer.getHeight(this)) {
            this.backBuffer = this.createImage(width, height);
        }
        if (this.backBuffer2 == null || width > this.backBuffer2.getWidth(this) || height > this.backBuffer2.getHeight(this)) {
            this.backBuffer2 = this.createImage(width, height);
        }
        this.viewportWidth = this.compWidth - 2 * this.xMargin;
        this.viewportHeight = this.compHeight - 2 * this.yMargin;
        this.updateChartClipArea();
        this.redrawBackBuffer = true;
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.resizePanel(width, height);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.chart == null || this.chartBBox == null) {
            this.eraseGraph(g);
            return;
        }
        if (this.redrawBackBuffer) {
            this.drawToBackBuffer();
        }
        Graphics2D backGraphics2 = (Graphics2D)this.backBuffer2.getGraphics();
        backGraphics2.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
        double[] scr1 = new double[3];
        double[] scr2 = new double[3];
        this.project(this.viewportRect.x, this.viewportRect.y, 0.0, scr1);
        this.project(this.viewportRect.x + this.viewportRect.width, this.viewportRect.y + this.viewportRect.height, 0.0, scr2);
        if (this.rubberband == null) {
            this.rubberband = new Rectangle2D.Double();
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(scr1[0], scr2[1], scr2[0] - scr1[0], scr1[1] - scr2[1]);
        this.rubberband.setRect(rect);
        backGraphics2.setColor(Color.red);
        backGraphics2.draw(this.rubberband);
        g.drawImage(this.backBuffer2, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
        backGraphics2.dispose();
    }

    protected void drawToBackBuffer() {
        Graphics2D g = (Graphics2D)this.backBuffer.getGraphics();
        g.setClip(this.chartClipX, this.chartClipY, this.chartClipWidth, this.chartClipHeight);
        g.setColor(this.backgroundColor);
        g.fillRect(0, 0, this.compWidth, this.compHeight);
        double[] scr1 = new double[3];
        double[] scr2 = new double[3];
        Vector displayList = this.chart.displayList;
        int size = displayList.size();
        for (int i = 0; i < size; ++i) {
            HistogramChart.HistogramElement e = (HistogramChart.HistogramElement)displayList.elementAt(i);
            if (e.element instanceof Color) {
                g.setColor((Color)e.element);
                continue;
            }
            if (!(e.element instanceof Rectangle2D.Double)) continue;
            Rectangle2D.Double rect2D = (Rectangle2D.Double)e.element;
            this.project(rect2D.x, rect2D.y, 0.0, scr1);
            this.project(rect2D.x + rect2D.width, rect2D.y - rect2D.height, 0.0, scr2);
            Rectangle2D.Double projectedRect = new Rectangle2D.Double(scr1[0], scr1[1], scr2[0] - scr1[0], scr2[1] - scr1[1]);
            g.fill(projectedRect);
            if (!this.chart.outlineOn) continue;
            g.setColor(this.chart.outlineColor);
            g.draw(projectedRect);
        }
        if (this.chart.chartBorderOn) {
            g.setColor(this.chart.chartBorderColor);
            this.project(this.chartBBox[0], this.chartBBox[1], 0.0, scr1);
            this.project(this.chartBBox[3], this.chartBBox[4], 0.0, scr2);
            g.drawRect((int)scr1[0], (int)scr2[1], (int)(scr2[0] - scr1[0]), (int)(scr1[1] - scr2[1]));
        }
        this.redrawBackBuffer = false;
        g.dispose();
    }

    protected void eraseGraph(Graphics g) {
        Graphics2D bg = (Graphics2D)this.backBuffer.getGraphics();
        bg.setColor(this.backgroundColor);
        bg.fillRect(0, 0, this.compWidth, this.compHeight);
        g.drawImage(this.backBuffer, 0, 0, this.compWidth, this.compHeight, 0, 0, this.compWidth, this.compHeight, this);
        bg.dispose();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.chart == null || this.chartBBox == null || this.error) {
            return;
        }
        this.startPt = e.getPoint();
        this.action = this.getMouseSpot(this.startPt);
        switch (this.action) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                this.setCursor(this.closeMoveCursor);
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.setCursor(new Cursor(0));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.rubberband == null) {
            return;
        }
        this.startPt = e.getPoint();
        switch (this.getMouseSpot(this.startPt)) {
            case 2: {
                this.setCursor(new Cursor(10));
                break;
            }
            case 3: {
                this.setCursor(new Cursor(11));
                break;
            }
            case 4: {
                this.setCursor(new Cursor(8));
                break;
            }
            case 5: {
                this.setCursor(new Cursor(9));
                break;
            }
            case 6: {
                this.setCursor(new Cursor(6));
                break;
            }
            case 7: {
                this.setCursor(new Cursor(7));
                break;
            }
            case 8: {
                this.setCursor(new Cursor(4));
                break;
            }
            case 9: {
                this.setCursor(new Cursor(5));
                break;
            }
            case 1: {
                this.setCursor(this.openMoveCursor);
                break;
            }
            default: {
                this.setCursor(new Cursor(0));
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.chart == null || this.chartBBox == null || this.error) {
            return;
        }
        Point pt = e.getPoint();
        double x = 0.0;
        double y = 0.0;
        double width = 0.0;
        double height = 0.0;
        switch (this.action) {
            case 1: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, (double)this.chartClipX);
                x = Math.min(x, (double)(this.chartClipX + this.chartClipWidth) - this.rubberband.width);
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, (double)this.chartClipY);
                y = Math.min(y, (double)(this.chartClipY + this.chartClipHeight) - this.rubberband.height);
                width = this.rubberband.width;
                height = this.rubberband.height;
                break;
            }
            case 2: {
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, (double)this.chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 3: {
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, (double)(this.chartClipX + this.chartClipWidth) - this.rubberband.x);
                height = this.rubberband.height;
                break;
            }
            case 4: {
                if (!this.chart.getHistogramModel().isBivariateHistogram()) {
                    return;
                }
                x = this.rubberband.x;
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, (double)this.chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width;
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 5: {
                if (!this.chart.getHistogramModel().isBivariateHistogram()) {
                    return;
                }
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width;
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, (double)(this.chartClipY + this.chartClipHeight) - this.rubberband.y);
                break;
            }
            case 6: {
                if (!this.chart.getHistogramModel().isBivariateHistogram()) {
                    return;
                }
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, (double)this.chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, (double)this.chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 7: {
                if (!this.chart.getHistogramModel().isBivariateHistogram()) {
                    return;
                }
                x = this.rubberband.x;
                y = this.rubberband.y + (double)(pt.y - this.startPt.y);
                y = Math.max(y, (double)this.chartClipY);
                y = Math.min(y, this.rubberband.y + this.rubberband.height - 4.0);
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, (double)(this.chartClipX + this.chartClipWidth) - this.rubberband.x);
                height = this.rubberband.height - (y - this.rubberband.y);
                break;
            }
            case 8: {
                if (!this.chart.getHistogramModel().isBivariateHistogram()) {
                    return;
                }
                x = this.rubberband.x + (double)(pt.x - this.startPt.x);
                x = Math.max(x, (double)this.chartClipX);
                x = Math.min(x, this.rubberband.x + this.rubberband.width - 4.0);
                y = this.rubberband.y;
                width = this.rubberband.width - (x - this.rubberband.x);
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, (double)(this.chartClipY + this.chartClipHeight) - this.rubberband.y);
                break;
            }
            case 9: {
                if (!this.chart.getHistogramModel().isBivariateHistogram()) {
                    return;
                }
                x = this.rubberband.x;
                y = this.rubberband.y;
                width = this.rubberband.width + (double)(pt.x - this.startPt.x);
                width = Math.max(width, 4.0);
                width = Math.min(width, (double)(this.chartClipX + this.chartClipWidth) - this.rubberband.x);
                height = this.rubberband.height + (double)(pt.y - this.startPt.y);
                height = Math.max(height, 4.0);
                height = Math.min(height, (double)(this.chartClipY + this.chartClipHeight) - this.rubberband.y);
                break;
            }
            default: {
                return;
            }
        }
        double[] min = new double[3];
        double[] max = new double[3];
        this.unProject(x, y + height, 0.0, min);
        this.unProject(x + width, y, 0.0, max);
        this.chart.setBoundingBox(min[0], min[1], min[2], max[0], max[1], max[2]);
        Rectangle2D.Double newRect = new Rectangle2D.Double(min[0], min[1], max[0] - min[0], max[1] - min[1]);
        this.viewportRect.setRect(newRect);
        this.repaint();
        this.startPt = pt;
    }

    @Override
    public double[] project(double x, double y, double z, double[] out) {
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        double xMin = this.chartBBox[0];
        double yMin = this.chartBBox[1];
        double xMax = this.chartBBox[3];
        double yMax = this.chartBBox[4];
        ret[0] = (double)w * (x - xMin) / (xMax - xMin) + (double)xo;
        ret[1] = (double)h - (double)h * (y - yMin) / (yMax - yMin) + (double)yo;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public double[] unProject(double pixelX, double pixelY, double pixelZ, double[] out) {
        double[] ret = out;
        if (ret == null && (ret = new double[3]) == null) {
            return null;
        }
        int w = this.viewportWidth - this.chartOuterMargin.left - this.chartOuterMargin.right;
        int h = this.viewportHeight - this.chartOuterMargin.top - this.chartOuterMargin.bottom;
        int xo = this.viewportX + this.chartOuterMargin.left;
        int yo = this.viewportY + this.chartOuterMargin.top;
        double xMin = this.chartBBox[0];
        double yMin = this.chartBBox[1];
        double xMax = this.chartBBox[3];
        double yMax = this.chartBBox[4];
        ret[0] = (xMax - xMin) * (pixelX - (double)xo) / (double)w + xMin;
        ret[1] = (yMax - yMin) * ((double)(h + yo) - pixelY) / (double)h + yMin;
        ret[2] = 0.0;
        return ret;
    }

    @Override
    public void setReverse(int axis, boolean flag) {
    }

    @Override
    public boolean isReverse(int axis) {
        return false;
    }

    @Override
    public void redraw(HistogramPreviewRedrawEvent e) {
        this.redrawBackBuffer = true;
        this.repaint();
    }

    @Override
    public void chartChanged(HistogramPreviewRedrawEvent e) {
        double[] bbox = e.newChartBoundingBox;
        if (bbox == null) {
            return;
        }
        if (this.chart == null) {
            this.chart = e.chart;
        }
        this.setChartBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], bbox[4], bbox[5]);
        this.repaint();
    }

    @Override
    public void rubberbandChanged(HistogramPreviewRedrawEvent e) {
        double[] bbox = e.newRubberband;
        if (bbox == null) {
            return;
        }
        this.setRubberbandBoundingBox(bbox[0], bbox[1], bbox[2], bbox[3], bbox[4], bbox[5]);
        this.repaint();
    }
}

