/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.histogram;

import com.sas.graphics.silk.data.JavaDataFilter;
import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.DataFilterWriteInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.HistogramDefaults;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.NumericFormat;
import com.sas.graphics.util.StringCompare;
import com.sas.text.SASFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;

public class HistogramModel
implements RoleInterface,
DataFilterListenerInterface {
    public static final int ROLE_X = 0;
    public static final int ROLE_Y = 1;
    public static final int ROLE_FREQ = 2;
    public static final int ROLE_STAT = 3;
    public static final int ROLE_TIP = 4;
    public static final int ROLE_DENSITY_X = 5;
    public static final int ROLE_DENSITY_Y = 6;
    public static final int ROLE_GROUP = 7;
    public static final int ROLE_COLORINDEX = 8;
    public static final int NUM_ROLES = 9;
    public static final int STAT_SUM = 1;
    public static final int STAT_MEAN = 2;
    public static final int STAT_FREQUENCY = 3;
    public static final int STAT_DENSITY = 5;
    public static final int STAT_PERCENT = 4;
    public static final String[] varNames = new String[]{"X", "Y", "Group", "Frequency", "Sum", "Mean", "Observations", "Density_X", "Density_Y", "Tip"};
    protected DataFilterReadInterface dataIn;
    protected DataFilterReadInterface densityCurveData;
    protected DataFilterWriteInterface dataOut;
    protected int numXBins;
    protected int numYBins;
    protected Object[] variables;
    protected Hashtable discrete;
    protected int numberXBins = 10;
    protected int numberYBins = 10;
    protected double xBinInterval;
    protected double yBinInterval;
    protected boolean userSetXBins = false;
    protected boolean userSetYBins = false;
    protected boolean rebin = true;
    protected HashMap xBinNames;
    protected HashMap yBinNames;
    protected Map groupNames;
    protected Vector tipNames;
    protected Map densityNames;
    protected double[] densityXMinMax = new double[2];
    protected double[] densityYMinMax = new double[2];
    protected boolean densitySet = false;
    protected int nonMissingObs;
    protected boolean density = false;
    protected boolean missingBin;
    protected int statType;
    protected double[] selectedValues;
    protected double userMinResp;
    protected double userMaxResp;
    protected double userMinXData;
    protected double userMaxXData;
    protected double userMinYData;
    protected double userMaxYData;
    protected boolean userSetXBinNames = false;
    protected boolean userSetYBinNames = false;
    protected static final Roles ROLES = Roles.getInstance(null);
    protected static final SILKNumber X_ROLE_NAME = ROLES.getRoleObject("ROLE_X");
    protected static final SILKNumber Y_ROLE_NAME = ROLES.getRoleObject("ROLE_Y");
    protected static final SILKNumber FREQ_ROLE_NAME = ROLES.getRoleObject("ROLE_FREQUENCY");
    protected static final SILKNumber GROUP_ROLE_NAME = ROLES.getRoleObject("ROLE_GROUP");
    protected static final SILKNumber STAT_ROLE_NAME = ROLES.getRoleObject("ROLE_STATISTIC");
    protected static final SILKNumber RESPONSE_ROLE_NAME = ROLES.getRoleObject("ROLE_RESPONSE");
    protected static final SILKNumber TIP_ROLE_NAME = ROLES.getRoleObject("ROLE_TIP");
    protected static final SILKNumber COLORINDEX_ROLE_NAME = ROLES.getRoleObject("ROLE_COLOR_INDEX");
    protected static int MAX_OBS_IN_MODEL = 10000;
    protected int sortOrderX = 1;
    protected int sortOrderY = 1;
    protected ArrayList currSelectedObs;
    protected boolean selectedAll = false;
    protected boolean outOfMemory;
    protected boolean roleXChanged = true;
    protected boolean roleYChanged = true;
    protected boolean roleResponseChanged = true;
    protected boolean responseScaleToNonMissing = false;
    protected boolean summarized;
    private Hashtable lastSelected = new Hashtable();
    private double[] minMaxX;
    private double[] minMaxY;
    protected double totalFreqVal = 0.0;
    protected SASFormat defaultFormatX = null;
    protected SASFormat defaultFormatY = null;

    public HistogramModel(DataFilterReadInterface data) {
        this.variables = new Object[9];
        this.discrete = new Hashtable();
        this.userMaxResp = Double.NaN;
        this.userMinResp = Double.NaN;
        this.userMaxXData = Double.NaN;
        this.userMinXData = Double.NaN;
        this.userMaxYData = Double.NaN;
        this.userMinYData = Double.NaN;
        this.minMaxX = new double[]{Double.NaN, Double.NaN};
        this.minMaxY = new double[]{Double.NaN, Double.NaN};
        this.currSelectedObs = new ArrayList();
        this.setDataSource(data);
        HistogramDefaults histDefaults = new HistogramDefaults();
        if (histDefaults.maximumBinCombinations < MAX_OBS_IN_MODEL) {
            MAX_OBS_IN_MODEL = histDefaults.maximumBinCombinations;
        }
    }

    public HistogramModel() {
        this(null);
    }

    public int getNumberXBins() {
        return this.numXBins - 1;
    }

    public void setNumberXBins(int num) {
        if (num <= 0) {
            return;
        }
        this.numberXBins = num;
        this.userSetXBins = true;
        this.rebin = true;
    }

    public int getNumberYBins() {
        return this.numYBins - 1;
    }

    public void setNumberYBins(int num) {
        if (num <= 0) {
            return;
        }
        this.numberYBins = num;
        this.userSetYBins = true;
        this.rebin = true;
    }

    public boolean isBivariateHistogram() {
        return this.yBinNames != null || this.rebin && this.variables[1] != null;
    }

    public HashMap getXBinNames() {
        return this.xBinNames;
    }

    public HashMap getYBinNames() {
        return this.yBinNames;
    }

    public int getNonMissingObservations() {
        return this.nonMissingObs;
    }

    public boolean isOutOfMemory() {
        return this.outOfMemory;
    }

    protected boolean isZeroObservation() {
        long obs = this.dataIn.getNumberObservations(-1);
        return obs <= 0L;
    }

    protected void setShowDensity(boolean d) {
        this.density = d;
    }

    protected boolean isShowDensity() {
        return this.density;
    }

    protected boolean isShowMissingBins() {
        return this.missingBin;
    }

    protected void setShowMissingBins(boolean missing) {
        if (this.responseScaleToNonMissing) {
            this.rebin = true;
        }
        this.missingBin = missing;
    }

    protected void setStatistic(int stat) {
        if (stat != this.statType) {
            this.roleResponseChanged = true;
            this.statType = stat;
            if (this.dataOut != null) {
                if (this.statType == 3) {
                    SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                    this.dataOut.setFormat((Object)"Frequency", (Object)sf);
                } else {
                    SASFormat sf = SASFormat.getInstance((String)"BEST8.");
                    this.dataOut.setFormat((Object)"Frequency", (Object)sf);
                }
            }
        }
    }

    protected void setFormat(Object varId, Object fmt) {
        this.dataOut.setFormat(varId, fmt);
    }

    protected boolean isUnselectedAll() {
        return this.selectedAll && this.currSelectedObs.size() == 0;
    }

    protected ArrayList getCurrentSelectedObservations() {
        return this.selectedAll ? null : this.currSelectedObs;
    }

    protected double[] getSelectedValues() {
        return this.selectedValues;
    }

    protected boolean doBinning() {
        int i;
        int cutOffObs;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (this.variables[0] == null) {
            return false;
        }
        this.outOfMemory = false;
        this.freeMemory();
        if (!this.userSetXBinNames) {
            this.xBinNames = this.getBinNames(this.variables[0]);
        }
        this.numXBins = this.xBinNames.size();
        this.densitySet = false;
        this.densityNames = null;
        if (this.variables[5] != null && this.variables[6] != null && this.variables[1] == null) {
            this.densityNames = this.getDensityNames(this.variables[5], this.variables[6]);
            this.densitySet = true;
        }
        if (this.variables[1] != null) {
            if (!this.userSetYBinNames) {
                this.yBinNames = this.getBinNames(this.variables[1]);
            }
            this.numYBins = this.yBinNames.size();
        } else {
            this.numYBins = 0;
            this.yBinNames = null;
        }
        this.groupNames = this.variables[7] != null && this.variables[1] == null ? this.setGroupNames() : null;
        int obs = this.numXBins;
        if (this.groupNames != null) {
            obs *= this.getGroupSize();
        } else if (this.numYBins > 0) {
            obs *= this.numYBins;
        }
        int n = cutOffObs = this.numYBins == 0 ? this.numXBins - 1 : (this.numXBins - 1) * (this.numYBins - 1);
        if (cutOffObs > MAX_OBS_IN_MODEL) {
            this.outOfMemory = true;
            this.rebin = false;
            return false;
        }
        this.nonMissingObs = 0;
        this.dataOut = new JavaDataFilter();
        for (i = 0; i < varNames.length; ++i) {
            this.dataOut.defineVariable((Object)varNames[i], (Object)"", null);
        }
        if (this.variables[4] != null) {
            int tmp = this.xBinNames.size();
            if (this.numYBins > 0) {
                tmp *= this.numYBins;
            } else if (this.isGroup()) {
                tmp *= this.getGroupSize();
            }
            this.tipNames = new Vector();
            for (int i2 = 0; i2 < tmp; ++i2) {
                this.tipNames.addElement(null);
            }
        } else {
            this.dataOut.removeVariable((Object)"Tip");
        }
        this.selectedValues = new double[obs];
        for (i = 0; i < obs; ++i) {
            for (int j = 0; j < varNames.length; ++j) {
                this.dataOut.setValue((Object)varNames[j], -1L, (Object)new Double(0.0));
            }
        }
        boolean rc = this.numYBins == 0 ? this.doBinning_1d() : this.doBinning_2d();
        String fmt = null;
        if (this.variables[0] != null && (fmt = this.defaultFormatX != null ? this.defaultFormatX.getName() : (String)this.dataIn.getFormat(this.variables[0], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat((Object)"X", (Object)fmt);
        }
        if (this.variables[1] != null && (fmt = this.defaultFormatY != null ? this.defaultFormatY.getName() : (String)this.dataIn.getFormat(this.variables[1], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat((Object)"Y", (Object)fmt);
        }
        if (this.variables[3] != null && (fmt = (String)this.dataIn.getFormat(this.variables[3], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat((Object)"Sum", (Object)fmt);
            this.dataOut.setFormat((Object)"Mean", (Object)fmt);
        }
        if (this.variables[7] != null && (fmt = (String)this.dataIn.getFormat(this.variables[7], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat((Object)"Group", (Object)fmt);
        }
        if (this.variables[4] != null && (fmt = (String)this.dataIn.getFormat(this.variables[4], String.class)) != null && !fmt.equals("")) {
            this.dataOut.setFormat((Object)"Tip", (Object)fmt);
        }
        this.rebin = false;
        return rc;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doBinning_1d() {
        int i;
        int index;
        int[] obsNo;
        int rows;
        Object tip;
        int grpId;
        int tId;
        int statId;
        int fId;
        int xId;
        int[] numObs;
        double[] selection;
        double[] miss;
        double[] freq;
        double[] sum;
        int count;
        int obs = this.numXBins;
        int grpSize = this.isGroup() ? this.getGroupSize() : 1;
        Iterator iter = this.xBinNames.keySet().iterator();
        Object[] objArray = null;
        if (this.isGroup()) {
            objArray = this.groupNames.keySet().toArray();
        }
        this.summarized = false;
        this.minMaxX = this.getMinMaxValues(this.getVariable("X"), this.dataIn);
        int i2 = 0;
        while (true) {
            Object value;
            if (i2 < obs) {
                value = iter.next();
            } else {
                count = obs * grpSize;
                sum = new double[count];
                freq = new double[count];
                miss = new double[count];
                selection = new double[count];
                numObs = new int[count];
                for (int i3 = 0; i3 < count; ++i3) {
                    sum[i3] = 0.0;
                    freq[i3] = 0.0;
                    miss[i3] = 0.0;
                    selection[i3] = 0.0;
                    numObs[i3] = 0;
                }
                xId = this.dataIn.getVariableIndex(this.variables[0]);
                fId = this.dataIn.getVariableIndex(this.variables[2]);
                statId = this.dataIn.getVariableIndex(this.variables[3]);
                tId = this.dataIn.getVariableIndex(this.variables[4]);
                grpId = this.dataIn.getVariableIndex(this.variables[7]);
                tip = null;
                rows = this.dataIn.getNumberObservations(-1);
                obsNo = new int[rows];
                break;
            }
            for (int j = 0; j < grpSize; ++j) {
                index = grpSize * i2 + j;
                this.dataOut.setValue((Object)"X", (long)index, value);
                this.dataOut.setValue((Object)"Y", (long)index, null);
                if (objArray == null) {
                    this.dataOut.setValue((Object)"Group", (long)index, null);
                    continue;
                }
                this.dataOut.setValue((Object)"Group", (long)index, objArray[j]);
            }
            ++i2;
        }
        for (int i4 = 0; i4 < rows; ++i4) {
            Object s;
            int xBinNo;
            block27: {
                Object x = this.dataIn.getValue(xId, (long)i4);
                if (this.dataIn.isMissing(xId, x)) {
                    if (this.missingBin || !this.responseScaleToNonMissing) {
                        index = xBinNo = this.numXBins - 1;
                        break block27;
                    } else {
                        obsNo[i4] = count - 1;
                        int n = count - 1;
                        numObs[n] = numObs[n] + 1;
                        continue;
                    }
                }
                xBinNo = this.getBinNo(0, x);
                index = xBinNo;
                if (index < 0) {
                    obsNo[i4] = count - 1;
                    int n = count - 1;
                    numObs[n] = numObs[n] + 1;
                }
                ++this.nonMissingObs;
            }
            if (xBinNo <= -1 || xBinNo >= obs) continue;
            if (grpId >= 0 && grpSize > 1) {
                Object grp = this.dataIn.getValue(grpId, (long)i4);
                int grpIndex = this.getGroupIndex(grpId, this.groupNames, grp);
                index = grpSize * xBinNo + grpIndex;
            }
            double freqVal = 1.0;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, (long)i4);
                freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).doubleValue() >= 0.0 ? ((Number)s).doubleValue() : 0.0;
            }
            int n = index;
            freq[n] = freq[n] + freqVal;
            this.totalFreqVal += freqVal;
            if (!this.summarized && freq[index] > 1.0) {
                this.summarized = true;
            }
            if (statId >= 0 && !this.isDiscrete("Response") && this.dataIn.isNumericVariable(statId)) {
                s = this.dataIn.getValue(statId, (long)i4);
                if (!this.dataIn.isMissing(statId, s)) {
                    int n2 = index;
                    sum[n2] = sum[n2] + (Double)s * freqVal;
                } else {
                    int n3 = index;
                    miss[n3] = miss[n3] + 1.0;
                }
            }
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, (long)i4);
                this.tipNames.setElementAt(tip, index);
            }
            if (!this.isGroup() && this.dataIn.isSelected((long)i4)) {
                int n4 = index;
                selection[n4] = selection[n4] + 1.0;
            }
            obsNo[i4] = index;
            int n5 = index;
            numObs[n5] = numObs[n5] + 1;
        }
        int[][] obsArray = new int[count][];
        int[] idx = new int[count];
        for (i = 0; i < count; ++i) {
            obsArray[i] = new int[numObs[i]];
            idx[i] = 0;
        }
        for (i = 0; i < rows; ++i) {
            obsArray[obsNo[i]][idx[obsNo[i]]] = i;
            int n = obsNo[i];
            idx[n] = idx[n] + 1;
        }
        i = 0;
        while (i < count) {
            if (tId > -1) {
                this.dataOut.setValue((Object)"Tip", (long)i, this.tipNames.elementAt(i));
            }
            if (freq[i] == 0.0 || freq[i] - miss[i] < 0.0) {
                this.dataOut.setValue((Object)"Sum", (long)i, null);
                this.dataOut.setValue((Object)"Mean", (long)i, null);
            } else {
                this.dataOut.setValue((Object)"Sum", (long)i, (Object)new Double(sum[i]));
                this.dataOut.setValue((Object)"Mean", (long)i, (Object)new Double(sum[i] / (freq[i] - miss[i])));
            }
            this.dataOut.setValue((Object)"Frequency", (long)i, (Object)new Double(freq[i]));
            this.dataOut.setValue((Object)"Observations", (long)i, (Object)obsArray[i]);
            this.selectedValues[i] = selection[i];
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean doBinning_2d() {
        int i;
        int idx = 0;
        this.summarized = false;
        this.minMaxX = this.getMinMaxValues(this.getVariable("X"), this.dataIn);
        this.minMaxY = this.getMinMaxValues(this.getVariable("Y"), this.dataIn);
        Iterator yIter = this.yBinNames.keySet().iterator();
        for (int i2 = 0; i2 < this.numYBins; ++i2) {
            Object yObj = yIter.next();
            Iterator xIter = this.xBinNames.keySet().iterator();
            for (int j = 0; j < this.numXBins; ++idx, ++j) {
                this.dataOut.setValue((Object)"X", (long)idx, xIter.next());
                this.dataOut.setValue((Object)"Y", (long)idx, yObj);
            }
        }
        int obs = this.numXBins * this.numYBins;
        double[] sum = new double[obs];
        double[] freq = new double[obs];
        double[] miss = new double[obs];
        double[] selection = new double[obs];
        int[] numObs = new int[obs];
        for (int i3 = 0; i3 < obs; ++i3) {
            sum[i3] = 0.0;
            freq[i3] = 0.0;
            miss[i3] = 0.0;
            selection[i3] = 0.0;
            numObs[i3] = 0;
        }
        int xId = this.dataIn.getVariableIndex(this.variables[0]);
        int yId = this.dataIn.getVariableIndex(this.variables[1]);
        int fId = this.dataIn.getVariableIndex(this.variables[2]);
        int statId = this.dataIn.getVariableIndex(this.variables[3]);
        int tId = this.dataIn.getVariableIndex(this.variables[4]);
        Object tip = null;
        int rows = this.dataIn.getNumberObservations(-1);
        int[] obsNo = new int[rows];
        for (int i4 = 0; i4 < rows; ++i4) {
            Object s;
            int yBinNo;
            int xBinNo;
            block27: {
                Object y;
                block26: {
                    Object x = this.dataIn.getValue(xId, (long)i4);
                    y = this.dataIn.getValue(yId, (long)i4);
                    idx = 0;
                    if (this.dataIn.isMissing(xId, x)) {
                        if (this.missingBin || !this.responseScaleToNonMissing) {
                            xBinNo = this.numXBins - 1;
                            break block26;
                        } else {
                            obsNo[i4] = this.numXBins - 1;
                            int n = this.numXBins - 1;
                            numObs[n] = numObs[n] + 1;
                            continue;
                        }
                    }
                    xBinNo = this.getBinNo(0, x);
                }
                if (xBinNo < 0) {
                    idx = -1;
                }
                if (this.dataIn.isMissing(yId, y)) {
                    if (this.missingBin || !this.responseScaleToNonMissing) {
                        yBinNo = this.numYBins - 1;
                        break block27;
                    } else {
                        obsNo[i4] = this.numYBins - 1;
                        int n = this.numYBins - 1;
                        numObs[n] = numObs[n] + 1;
                        continue;
                    }
                }
                ++this.nonMissingObs;
                yBinNo = this.getBinNo(1, y);
                if (yBinNo < 0 || idx == -1) {
                    idx = -1;
                    numObs[0] = numObs[0] + 1;
                    continue;
                }
            }
            idx = yBinNo * this.numXBins + xBinNo;
            if (idx <= -1 || idx >= obs) continue;
            if (tId > -1) {
                tip = this.dataIn.getValue(tId, (long)i4);
                this.tipNames.setElementAt(tip, idx);
            }
            double freqVal = 1.0;
            if (fId >= 0) {
                s = this.dataIn.getValue(fId, (long)i4);
                freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).doubleValue() >= 0.0 ? ((Number)s).doubleValue() : 0.0;
            }
            int n = idx;
            freq[n] = freq[n] + freqVal;
            this.totalFreqVal += freqVal;
            if (!this.summarized && freq[idx] > 1.0) {
                this.summarized = true;
            }
            if (statId >= 0 && !this.isDiscrete("Response") && this.dataIn.isNumericVariable(statId)) {
                s = this.dataIn.getValue(statId, (long)i4);
                if (!this.dataIn.isMissing(statId, s)) {
                    int n2 = idx;
                    sum[n2] = sum[n2] + ((Number)s).doubleValue() * freqVal;
                } else {
                    int n3 = idx;
                    miss[n3] = miss[n3] + 1.0;
                }
            }
            if (this.dataIn.isSelected((long)i4)) {
                int n4 = idx;
                selection[n4] = selection[n4] + 1.0;
            }
            obsNo[i4] = idx;
            int n5 = idx;
            numObs[n5] = numObs[n5] + 1;
        }
        int[][] obsArray = new int[obs][];
        int[] I = new int[obs];
        for (i = 0; i < obs; ++i) {
            obsArray[i] = new int[numObs[i]];
            I[i] = 0;
        }
        for (i = 0; i < rows; ++i) {
            obsArray[obsNo[i]][I[obsNo[i]]] = i;
            int n = obsNo[i];
            I[n] = I[n] + 1;
        }
        i = 0;
        while (i < obs) {
            if (tId > -1) {
                this.dataOut.setValue((Object)"Tip", (long)i, this.tipNames.elementAt(i));
            }
            if (freq[i] == 0.0 || freq[i] - miss[i] < 0.0) {
                this.dataOut.setValue((Object)"Sum", (long)i, null);
                this.dataOut.setValue((Object)"Mean", (long)i, null);
            } else {
                this.dataOut.setValue((Object)"Sum", (long)i, (Object)new Double(sum[i]));
                this.dataOut.setValue((Object)"Mean", (long)i, (Object)new Double(sum[i] / (freq[i] - miss[i])));
            }
            this.dataOut.setValue((Object)"Frequency", (long)i, (Object)new Double(freq[i]));
            this.dataOut.setValue((Object)"Observations", (long)i, (Object)obsArray[i]);
            this.selectedValues[i] = selection[i];
            ++i;
        }
        return true;
    }

    public boolean sendSelectionEvent() {
        this.dataIn.sendEvent((Object)new DvrDataFilterEvent(7));
        return true;
    }

    public boolean setSelection(int[] bins, boolean selected) {
        if (this.isGroup()) {
            return false;
        }
        int num = 0;
        int len = bins.length;
        for (int i = 0; i < len; ++i) {
            int[] obsArray = (int[])this.dataOut.getValue((Object)"Observations", (long)bins[i]);
            num += obsArray.length;
        }
        int[] obs = new int[num];
        int idx = 0;
        for (int i = 0; i < len; ++i) {
            for (int obs[idx] : (int[])this.dataOut.getValue((Object)"Observations", (long)bins[i])) {
                ++idx;
            }
        }
        this.dataIn.setSelected((Object)obs, selected);
        return true;
    }

    public boolean setSelection(long i, boolean selected) {
        if (this.isGroup()) {
            return false;
        }
        int[] obsNo = (int[])this.dataOut.getValue((Object)"Observations", i);
        this.dataIn.setSelected((Object)obsNo, selected);
        return true;
    }

    public boolean setSelectionAll(boolean selected) {
        if (this.isGroup()) {
            return false;
        }
        if (!selected) {
            this.dataIn.unselectAll();
        } else {
            int rows = this.dataIn.getNumberObservations(-1);
            int[] obs = new int[rows];
            for (int i = 0; i < rows; ++i) {
                obs[i] = i;
            }
            this.dataIn.setSelected((Object)obs, selected);
        }
        return true;
    }

    public double getMinimumValue(Object varId, long obs1, long obs2) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        if (!Double.isNaN(this.userMinResp)) {
            return this.userMinResp;
        }
        int idx = this.dataOut.getVariableIndex(varId);
        double min = Double.MAX_VALUE;
        for (long i = obs1; i < obs2; ++i) {
            double d;
            Object o = this.dataOut.getValue(idx, i);
            if (this.dataOut.isMissing(idx, o) || !((d = ((Number)o).doubleValue()) < min)) continue;
            min = d;
        }
        if (this.density) {
            int count = this.missingBin ? this.dataIn.getNumberObservations(-1) : this.nonMissingObs;
            min = min / (double)count / this.xBinInterval;
        }
        return min;
    }

    public double getMinimumValue(Object varId) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        return this.getMinimumValue(varId, (DataFilterReadInterface)this.dataOut);
    }

    public double getMinimumValue(Object varId, DataFilterReadInterface data) {
        if (varId == null || !data.verifyVariable(varId) || this.isDiscrete(this.getRole(varId)) || !data.isNumericVariable(varId)) {
            return Double.NaN;
        }
        long obs = data.getNumberObservations(varId);
        int idx = data.getVariableIndex(varId);
        double min = Double.MAX_VALUE;
        for (long i = 0L; i < obs; ++i) {
            double d;
            Object o = data.getValue(idx, i);
            if (data.isMissing(idx, o) || !((d = ((Number)o).doubleValue()) < min)) continue;
            min = d;
        }
        return min;
    }

    public double getMaximumValue(Object varId, long obs1, long obs2) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        if (!Double.isNaN(this.userMaxResp)) {
            return this.userMaxResp;
        }
        int idx = this.dataOut.getVariableIndex(varId);
        double max = -1.7976931348623157E308;
        for (long i = obs1; i < obs2; ++i) {
            double d;
            Object o = this.dataOut.getValue(idx, i);
            if (this.dataOut.isMissing(idx, o) || !((d = ((Number)o).doubleValue()) > max)) continue;
            max = d;
        }
        if (this.density) {
            int count = this.missingBin ? this.dataIn.getNumberObservations(-1) : this.nonMissingObs;
            max = max / (double)count / this.xBinInterval;
        }
        return max;
    }

    public double getMaximumValue(Object varId) {
        if (this.dataOut == null) {
            return Double.NaN;
        }
        return this.getMaximumValue(varId, (DataFilterReadInterface)this.dataOut);
    }

    public double getMaximumValue(Object varId, DataFilterReadInterface data) {
        if (varId == null || !data.verifyVariable(varId) || this.isDiscrete(this.getRole(varId)) || !data.isNumericVariable(varId)) {
            return Double.NaN;
        }
        long obs = data.getNumberObservations(varId);
        int idx = data.getVariableIndex(varId);
        double max = -1.7976931348623157E308;
        for (long i = 0L; i < obs; ++i) {
            double d;
            Object o = data.getValue(idx, i);
            if (data.isMissing(idx, o) || !((d = ((Number)o).doubleValue()) > max)) continue;
            max = d;
        }
        return max;
    }

    public void setMinimumData(Object role, double min) {
        if (!(role instanceof String)) {
            return;
        }
        if (((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString())) {
            this.userMinXData = min;
        } else if (((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString())) {
            this.userMinYData = min;
        } else {
            return;
        }
        this.rebin = true;
    }

    public void setMaximumData(Object role, double max) {
        if (!(role instanceof String)) {
            return;
        }
        if (((String)role).equalsIgnoreCase("X") || ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString())) {
            this.userMaxXData = max;
        } else if (((String)role).equalsIgnoreCase("Y") || ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString())) {
            this.userMaxYData = max;
        } else {
            return;
        }
        this.rebin = true;
    }

    public void setXBinNames(Object[] name) {
        this.setXBinNames(name, false);
    }

    public void setXBinNames(Object[] name, boolean honorSort) {
        if (this.dataIn.isNumericVariable(this.variables[0]) && !this.isDiscrete((Object)X_ROLE_NAME)) {
            if (name != null && name[0] instanceof Number) {
                LinkedHashMap<Object, Integer> names = new LinkedHashMap<Object, Integer>();
                for (int i = 0; i < name.length; ++i) {
                    if (!(name[i] instanceof Number)) {
                        return;
                    }
                    names.put(name[i], new Integer(i));
                }
                Collection c = CollectionSorter.getValues(names.keySet(), 1);
                Iterator iter = c.iterator();
                int num = 0;
                names.clear();
                while (iter.hasNext()) {
                    names.put(iter.next(), new Integer(num));
                    ++num;
                }
                if (this.xBinNames == null) {
                    this.xBinNames = new LinkedHashMap();
                } else {
                    this.xBinNames.clear();
                }
                Object[] namesArray = names.keySet().toArray();
                this.setNumberXBins(name.length - 1);
                for (int i = 0; i < this.numberXBins; ++i) {
                    double[] values = new double[]{((Number)namesArray[i]).doubleValue(), ((Number)namesArray[i + 1]).doubleValue()};
                    this.xBinNames.put(values, new Integer(i));
                }
                if (!this.xBinNames.containsKey("")) {
                    this.xBinNames.put("", new Integer(names.size()));
                }
                this.userSetXBinNames = true;
                this.rebin = true;
                return;
            }
            return;
        }
        if (this.xBinNames == null) {
            this.xBinNames = new LinkedHashMap();
        } else {
            this.xBinNames.clear();
        }
        for (int i = 0; i < name.length; ++i) {
            this.xBinNames.put(name[i], new Integer(i));
        }
        if (honorSort) {
            int order = 0;
            if (this.sortOrderX == 1) {
                order = 1;
            } else if (this.sortOrderX == -1) {
                order = -1;
            }
            if (order != 0) {
                Collection c = CollectionSorter.getValues(this.xBinNames.keySet(), order);
                Iterator iter = c.iterator();
                int num = 0;
                this.xBinNames.clear();
                while (iter.hasNext()) {
                    this.xBinNames.put(iter.next(), new Integer(num));
                    ++num;
                }
            }
        }
        if (!this.xBinNames.containsKey("")) {
            this.xBinNames.put("", new Integer(name.length));
        }
        this.userSetXBinNames = true;
        this.rebin = true;
    }

    public void setYBinNames(Object[] name) {
        this.setYBinNames(name, false);
    }

    public void setYBinNames(Object[] name, boolean honorSort) {
        if (this.dataIn.isNumericVariable(this.variables[1]) && !this.isDiscrete((Object)Y_ROLE_NAME)) {
            if (name != null && name[0] instanceof Number) {
                LinkedHashMap<Object, Integer> names = new LinkedHashMap<Object, Integer>();
                for (int i = 0; i < name.length; ++i) {
                    if (!(name[i] instanceof Number)) {
                        return;
                    }
                    names.put(name[i], new Integer(i));
                }
                Collection c = CollectionSorter.getValues(names.keySet(), 1);
                Iterator iter = c.iterator();
                int num = 0;
                names.clear();
                while (iter.hasNext()) {
                    names.put(iter.next(), new Integer(num));
                    ++num;
                }
                if (this.yBinNames == null) {
                    this.yBinNames = new LinkedHashMap();
                } else {
                    this.yBinNames.clear();
                }
                Object[] namesArray = names.keySet().toArray();
                this.setNumberYBins(name.length - 1);
                for (int i = 0; i < this.numberYBins; ++i) {
                    double[] values = new double[]{((Number)namesArray[i]).doubleValue(), ((Number)namesArray[i + 1]).doubleValue()};
                    this.yBinNames.put(values, new Integer(i));
                }
                if (!this.yBinNames.containsKey("")) {
                    this.yBinNames.put("", new Integer(names.size()));
                }
                this.userSetYBinNames = true;
                this.rebin = true;
                return;
            }
            return;
        }
        if (this.yBinNames == null) {
            this.yBinNames = new LinkedHashMap();
        } else {
            this.yBinNames.clear();
        }
        for (int i = 0; i < name.length; ++i) {
            this.yBinNames.put(name[i], new Integer(i));
        }
        if (honorSort) {
            int order = 0;
            if (this.sortOrderY == 1) {
                order = 1;
            } else if (this.sortOrderY == -1) {
                order = -1;
            }
            if (order != 0) {
                Collection c = CollectionSorter.getValues(this.yBinNames.keySet(), order);
                Iterator iter = c.iterator();
                int num = 0;
                this.yBinNames.clear();
                while (iter.hasNext()) {
                    this.yBinNames.put(iter.next(), new Integer(num));
                    ++num;
                }
            }
        }
        if (!this.yBinNames.containsKey("")) {
            this.yBinNames.put("", new Integer(name.length));
        }
        this.userSetYBinNames = true;
        this.rebin = true;
    }

    public void setMinimumResponse(double min) {
        this.userMinResp = min;
    }

    public void setMaximumResponse(double max) {
        this.userMaxResp = max;
    }

    protected double getMinimumResponse() {
        if (this.dataOut == null) {
            this.getDataSource();
        }
        if (this.dataOut == null) {
            return Double.NaN;
        }
        String resp = null;
        resp = this.statType == 1 ? "Sum" : (this.statType == 2 ? "Mean" : "Frequency");
        return this.getMinimumValue(resp, 0L, this.dataOut.getNumberObservations(-1));
    }

    protected double getMaximumResponse() {
        if (this.dataOut == null) {
            this.getDataSource();
        }
        if (this.dataOut == null) {
            return Double.NaN;
        }
        String resp = null;
        resp = this.statType == 1 ? "Sum" : (this.statType == 2 ? "Mean" : "Frequency");
        return this.getMaximumValue(resp, 0L, this.dataOut.getNumberObservations(-1));
    }

    protected double[] getMinMaxValues(Object varId, DataFilterReadInterface data) {
        if (varId == null || !data.verifyVariable(varId) || this.isDiscrete(this.getRole(varId)) || !data.isNumericVariable(varId)) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        long obs = data.getNumberObservations(varId);
        int idx = data.getVariableIndex(varId);
        for (long i = 0L; i < obs; ++i) {
            Object o = data.getValue(idx, i);
            if (data.isMissing(idx, o)) continue;
            double d = ((Number)o).doubleValue();
            if (d > max) {
                max = d;
            }
            if (!(d < min)) continue;
            min = d;
        }
        return new double[]{min, max};
    }

    public Object getVariableDescription(Object role) {
        Object varId = this.getVariable(role);
        Object desc = this.dataIn.getVariableDescription(varId);
        if (desc == null || ((String)desc).equals("")) {
            return varId;
        }
        return desc;
    }

    private HashMap getBinNames(Object varId) {
        double userMaxData;
        double userMinData;
        if (this.getRole(varId).equals((Object)X_ROLE_NAME)) {
            userMinData = this.userMinXData;
            userMaxData = this.userMaxXData;
            this.defaultFormatX = null;
        } else {
            userMinData = this.userMinYData;
            userMaxData = this.userMaxYData;
            this.defaultFormatY = null;
        }
        LinkedHashMap<Object, Integer> names = new LinkedHashMap<Object, Integer>();
        int index = this.dataIn.getVariableIndex(varId);
        if (!this.isDiscrete(this.getRole(varId)) && this.dataIn.isNumericVariable(varId)) {
            Object[] gGoodFormat;
            int numBins;
            double min;
            double[] minMax = new double[2];
            if (Double.isNaN(userMinData) || Double.isNaN(userMaxData)) {
                minMax = this.getMinMaxValues(varId, this.dataIn);
            }
            double d = min = Double.isNaN(userMinData) ? minMax[0] : userMinData;
            if (min == Double.MAX_VALUE) {
                names.put(".", new Integer(0));
                return names;
            }
            double max = Double.isNaN(userMaxData) ? minMax[1] : userMaxData;
            double step = (max - min) / (double)(numBins = this.getRole(varId).equals((Object)Y_ROLE_NAME) ? this.numberYBins : this.numberXBins);
            if (step == 0.0) {
                names.put(new Double(min), new Integer(0));
                names.put(".", new Integer(1));
                return names;
            }
            SASFormat defaultFormat = null;
            defaultFormat = this.getRole(varId).equals((Object)X_ROLE_NAME) ? (SASFormat)this.dataIn.getFormat(this.variables[0], SASFormat.class) : (SASFormat)this.dataIn.getFormat(this.variables[1], SASFormat.class);
            int maxwIn = -1;
            int maxdecIn = -1;
            int okdecIn = -1;
            if (step < 1.0 && step > 0.0) {
                double inv = 1.0 / step;
                int sigdec = (int)Math.floor(Math.log(inv) / Math.log(10.0) + 1.0);
                int sign = min < 0.0 ? 1 : 0;
                int intWidth = (int)Math.floor(Math.log(Math.abs(max)) / Math.log(10.0) + 1.0);
                if (intWidth == 0) {
                    intWidth = 1;
                }
                maxwIn = sign + intWidth + sigdec + 1;
                maxdecIn = sigdec;
                okdecIn = sigdec;
                if (maxwIn < 8) {
                    okdecIn = -1;
                    maxdecIn = -1;
                    maxwIn = -1;
                } else if (maxwIn > 32) {
                    maxwIn = 32;
                    maxdecIn = sigdec = maxwIn - sign - intWidth - 1;
                    okdecIn = sigdec;
                }
            }
            if ((gGoodFormat = NumericFormat.getGGoodFormat((SASFormat)defaultFormat, (double)min, (double)max, (double)step, (int)maxwIn, (int)maxdecIn, (int)okdecIn, (boolean)false)) != null && gGoodFormat.length == 2 && gGoodFormat[0] instanceof SASFormat) {
                defaultFormat = (SASFormat)gGoodFormat[0];
            }
            if (this.getRole(varId).equals((Object)X_ROLE_NAME)) {
                this.xBinInterval = step;
                this.defaultFormatX = defaultFormat;
            } else {
                this.yBinInterval = step;
                this.defaultFormatY = defaultFormat;
            }
            double start = min;
            for (int i = 0; i < numBins; ++i) {
                double[] values;
                values = new double[]{start, values[0] + step};
                if (i == numBins - 1) {
                    values[1] = max;
                }
                names.put(values, new Integer(i));
                start = values[1];
            }
        } else {
            int num = 0;
            for (long i = 0L; i < (long)this.dataIn.getNumberObservations(index); ++i) {
                Object obj = this.dataIn.getValue(index, i);
                if (this.dataIn.isMissing(index, obj) || names.containsKey(obj)) continue;
                names.put(obj, new Integer(num));
                ++num;
            }
            int order = 0;
            if (this.dataIn.isNumericVariable(varId)) {
                order = 1;
                if (this.getRole(varId).equals((Object)X_ROLE_NAME)) {
                    this.sortOrderX = 1;
                }
                if (this.getRole(varId).equals((Object)Y_ROLE_NAME)) {
                    this.sortOrderY = 1;
                }
            } else if (this.getRole(varId).equals((Object)X_ROLE_NAME)) {
                if (this.sortOrderX == 1) {
                    order = 1;
                } else if (this.sortOrderX == -1) {
                    order = -1;
                }
            } else if (this.getRole(varId).equals((Object)Y_ROLE_NAME)) {
                if (this.sortOrderY == 1) {
                    order = 1;
                } else if (this.sortOrderY == -1) {
                    order = -1;
                }
            }
            if (order != 0) {
                Collection c = CollectionSorter.getValues(names.keySet(), order);
                Iterator iter = c.iterator();
                num = 0;
                names.clear();
                while (iter.hasNext()) {
                    names.put(iter.next(), new Integer(num));
                    ++num;
                }
            }
        }
        int num = names.size();
        names.put("", new Integer(num));
        return names;
    }

    private int getBinNo(int role, Object value) {
        Object val;
        HashMap binNames = null;
        if (role == 0) {
            binNames = this.xBinNames;
        } else if (role == 1) {
            binNames = this.yBinNames;
        }
        int num = 0;
        double v = value instanceof Number ? ((Number)value).doubleValue() : 0.0;
        double maxVal = role == 0 ? this.minMaxX[1] : this.minMaxY[1];
        Iterator iterator = binNames.keySet().iterator();
        Object v0 = val = iterator != null ? iterator.next() : null;
        if (val != null && val instanceof double[]) {
            double fisrtValue = 0.0;
            double lastValue = 0.0;
            while (val != null && val instanceof double[]) {
                fisrtValue = ((double[])val)[0];
                lastValue = ((double[])val)[1];
                if (v >= fisrtValue && (v < lastValue || lastValue == maxVal && v == lastValue)) {
                    return num;
                }
                ++num;
                val = iterator.next();
            }
            return -1;
        }
        Object NO = binNames.get(value);
        return NO == null ? -1 : (Integer)NO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getModelObservationNo(int obs) {
        int yNo;
        int xNo;
        Object xObj = this.dataIn.getValue(this.variables[0], (long)obs);
        if (this.dataIn.isMissing(this.variables[0], xObj)) {
            if (!this.missingBin && this.responseScaleToNonMissing) return -1;
            xNo = this.numXBins - 1;
        } else {
            xNo = this.getBinNo(0, xObj);
        }
        if (this.variables[1] != null) {
            Object yObj = this.dataIn.getValue(this.variables[1], (long)obs);
            if (this.dataIn.isMissing(this.variables[1], yObj)) {
                if (!this.missingBin && this.responseScaleToNonMissing) return -1;
                yNo = this.numYBins - 1;
                return yNo * this.numXBins + xNo;
            } else {
                yNo = this.getBinNo(1, yObj);
            }
            return yNo * this.numXBins + xNo;
        } else {
            yNo = 0;
        }
        return yNo * this.numXBins + xNo;
    }

    protected int getXBinNo(int obs) {
        int no = this.variables[1] == null ? obs : obs % this.numXBins;
        return no;
    }

    protected int getYBinNo(int obs) {
        int no = this.variables[1] == null ? 0 : obs / this.numXBins;
        return no;
    }

    public Object getDataSource() {
        if (this.rebin && !this.doBinning()) {
            return null;
        }
        return this.dataOut;
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public boolean setDataSource(Object source, Object id) {
        if (!(source instanceof DataFilterReadInterface)) {
            return false;
        }
        if (id == null) {
            this.dataIn = (DataFilterReadInterface)source;
            this.dataIn.addDataFilterListener((Object)this);
            this.densityCurveData = this.dataIn;
        } else if (id instanceof String && ((String)id).equalsIgnoreCase("DensityCurve")) {
            this.densityCurveData = (DataFilterReadInterface)source;
        }
        this.rebin = true;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null || ((String)this.variables[i]).equals((String)this.dataIn.getExactVariableId(this.variables[i]))) continue;
            this.variables[i] = null;
        }
        this.userMaxResp = Double.NaN;
        this.userMinResp = Double.NaN;
        this.userMaxXData = Double.NaN;
        this.userMinXData = Double.NaN;
        this.userMaxYData = Double.NaN;
        this.userMinYData = Double.NaN;
        this.userSetYBinNames = false;
        this.userSetXBinNames = false;
        return true;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        int id;
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            id = 0;
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            id = 1;
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 38) || role instanceof String && (((String)role).equalsIgnoreCase("STAT") || ((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()))) {
            id = 3;
        } else if (role instanceof Number && ((Number)role).intValue() == 22 || role instanceof String && ((String)role).equalsIgnoreCase(TIP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Tip")) {
            id = 4;
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Group")) {
            id = 7;
        } else if (role instanceof Number && ((Number)role).intValue() == 3 || role instanceof String && (((String)role).equalsIgnoreCase("ColorIndex") || ((String)role).equalsIgnoreCase("Color Index") || ((String)role).equalsIgnoreCase(COLORINDEX_ROLE_NAME.toString()))) {
            id = 8;
        } else if (role instanceof Number && ((Number)role).intValue() == 70 || role instanceof String && (((String)role).equalsIgnoreCase("Freq") || ((String)role).equalsIgnoreCase(FREQ_ROLE_NAME.toString()))) {
            id = 2;
        } else {
            return null;
        }
        return this.variables[id];
    }

    @Override
    public Object getRole(Object variableId) {
        SILKNumber obj;
        int id = -1;
        for (int i = 0; i < this.variables.length; ++i) {
            if (this.variables[i] == null || !this.variables[i].equals(variableId)) continue;
            id = i;
            break;
        }
        switch (id) {
            default: {
                obj = null;
                break;
            }
            case 0: {
                obj = X_ROLE_NAME;
                break;
            }
            case 1: {
                obj = Y_ROLE_NAME;
                break;
            }
            case 3: {
                obj = RESPONSE_ROLE_NAME;
                break;
            }
            case 4: {
                obj = TIP_ROLE_NAME;
                break;
            }
            case 7: {
                obj = GROUP_ROLE_NAME;
                break;
            }
            case 8: {
                obj = COLORINDEX_ROLE_NAME;
                break;
            }
            case 2: {
                obj = FREQ_ROLE_NAME;
            }
        }
        return obj;
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            id = 0;
            this.roleXChanged = true;
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            id = 1;
            this.roleYChanged = true;
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 38) || role instanceof String && (((String)role).equalsIgnoreCase("STAT") || ((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()))) {
            id = 3;
            this.roleResponseChanged = true;
        } else if (role instanceof Number && ((Number)role).intValue() == 22 || role instanceof String && ((String)role).equalsIgnoreCase(TIP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Tip")) {
            id = 4;
        } else if (role instanceof String && ((String)role).equalsIgnoreCase("DensityX")) {
            id = 5;
        } else if (role instanceof String && ((String)role).equalsIgnoreCase("DensityY")) {
            id = 6;
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Group")) {
            id = 7;
        } else if (role instanceof Number && ((Number)role).intValue() == 3 || role instanceof String && (((String)role).equalsIgnoreCase("ColorIndex") || ((String)role).equalsIgnoreCase("Color Index") || ((String)role).equalsIgnoreCase(COLORINDEX_ROLE_NAME.toString()))) {
            id = 8;
        } else if (role instanceof Number && ((Number)role).intValue() == 70 || role instanceof String && (((String)role).equalsIgnoreCase("Freq") || ((String)role).equalsIgnoreCase(FREQ_ROLE_NAME.toString()))) {
            id = 2;
            this.roleResponseChanged = true;
        } else {
            return false;
        }
        if (variableId == null) {
            return false;
        }
        if (id == 5 || id == 6) {
            if (variableId != null && !this.densityCurveData.verifyVariable(variableId)) {
                return false;
            }
            this.variables[id] = this.densityCurveData.getExactVariableId(variableId);
        } else {
            if (variableId != null && !this.dataIn.verifyVariable(variableId)) {
                return false;
            }
            this.variables[id] = this.dataIn.getExactVariableId(variableId);
            this.rebin = true;
            this.userMaxResp = Double.NaN;
            this.userMinResp = Double.NaN;
            if (this.roleXChanged) {
                this.userMaxXData = Double.NaN;
                this.userMinXData = Double.NaN;
                this.userSetXBinNames = false;
            }
            if (this.roleYChanged) {
                this.userMaxYData = Double.NaN;
                this.userMinYData = Double.NaN;
                this.userSetYBinNames = false;
            }
        }
        return true;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        return this.setRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        int id;
        if (this.dataIn == null || !(this.dataIn instanceof DataFilterReadInterface)) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            id = 0;
            this.roleXChanged = true;
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            id = 1;
            this.roleYChanged = true;
            this.roleResponseChanged = true;
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 17) || role instanceof String && (((String)role).equalsIgnoreCase("STAT") || ((String)role).equalsIgnoreCase("Response")) || ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString())) {
            id = 3;
            this.roleResponseChanged = true;
        } else if (role instanceof Number && ((Number)role).intValue() == 22 || role instanceof String && ((String)role).equalsIgnoreCase(TIP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Tip")) {
            id = 4;
        } else if (role instanceof String && ((String)role).equalsIgnoreCase("DensityX")) {
            id = 5;
        } else if (role instanceof String && ((String)role).equalsIgnoreCase("DensityY")) {
            id = 6;
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && ((String)role).equalsIgnoreCase(GROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Group")) {
            id = 7;
        } else if (role instanceof Number && ((Number)role).intValue() == 3 || role instanceof String && (((String)role).equalsIgnoreCase("ColorIndex") || ((String)role).equalsIgnoreCase("Color Index") || ((String)role).equalsIgnoreCase(COLORINDEX_ROLE_NAME.toString()))) {
            id = 8;
        } else if (role instanceof Number && ((Number)role).intValue() == 70 || role instanceof String && (((String)role).equalsIgnoreCase("Freq") || ((String)role).equalsIgnoreCase(FREQ_ROLE_NAME.toString()))) {
            id = 2;
            this.roleResponseChanged = true;
        } else {
            return false;
        }
        if (this.variables[id] == null || !((String)this.variables[id]).equalsIgnoreCase((String)variableId)) {
            return false;
        }
        this.variables[id] = null;
        this.rebin = true;
        this.userMaxResp = Double.NaN;
        this.userMinResp = Double.NaN;
        if (id == 0) {
            this.userMaxXData = Double.NaN;
            this.userMinXData = Double.NaN;
            this.userSetXBinNames = false;
            this.numXBins = 0;
            this.xBinNames = null;
        }
        if (id == 1) {
            this.userMaxYData = Double.NaN;
            this.userMinYData = Double.NaN;
            this.userSetYBinNames = false;
            this.numYBins = 0;
            this.yBinNames = null;
        }
        return true;
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (role == null) {
            return false;
        }
        String str = null;
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            str = "X";
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            str = "Y";
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 38) || role instanceof String && (((String)role).equalsIgnoreCase("STAT") || ((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()))) {
            str = "Response";
        }
        if (str == null) {
            return false;
        }
        Boolean dis = (Boolean)this.discrete.get(str);
        if (dis != null) {
            return dis;
        }
        return false;
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (role == null) {
            return false;
        }
        String str = null;
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            str = "X";
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            str = "Y";
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 38) || role instanceof String && (((String)role).equalsIgnoreCase("STAT") || ((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString()))) {
            str = "Response";
        }
        if (str == null) {
            return false;
        }
        this.discrete.put(str, new Boolean(discrete));
        if (str == "X") {
            this.userMaxXData = Double.NaN;
            this.userMinXData = Double.NaN;
            this.userSetXBinNames = false;
        }
        if (str == "Y") {
            this.userMaxYData = Double.NaN;
            this.userMinYData = Double.NaN;
            this.userSetYBinNames = false;
        }
        this.rebin = true;
        return true;
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (((String)role).equalsIgnoreCase("Stat") || ((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase(STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(RESPONSE_ROLE_NAME.toString())) {
            if (which == 0) {
                double val = this.getMinimumResponse();
                if (this.statType == 4) {
                    double totalCount = this.getTotalFreqVal();
                    val *= 100.0 / totalCount;
                }
                return new Double(val);
            }
            if (which == 1) {
                double val = this.getMaximumResponse();
                if (this.statType == 4) {
                    double totalCount = this.getTotalFreqVal();
                    val *= 100.0 / totalCount;
                }
                return new Double(val);
            }
            return null;
        }
        Object id = this.getVariable(role);
        if (id == null) {
            return null;
        }
        if (this.isDiscrete(role) || !this.dataIn.isNumericVariable(id)) {
            return null;
        }
        if (which == 0) {
            return new Double(this.getMinimumValue(id, this.dataIn));
        }
        if (which == 1) {
            return new Double(this.getMaximumValue(id, this.dataIn));
        }
        return null;
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        return null;
    }

    @Override
    public int getMaxAllowed(Object role) {
        return -1;
    }

    @Override
    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            return new Integer(this.sortOrderX);
        }
        if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            return new Integer(this.sortOrderY);
        }
        return null;
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            this.sortOrderX = ((Number)order).intValue();
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            this.sortOrderY = ((Number)order).intValue();
        } else {
            return false;
        }
        this.rebin = true;
        return true;
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        boolean charX = !this.dataIn.isNumericVariable(this.getVariable("X"));
        boolean charY = false;
        if (this.yBinNames != null) {
            boolean bl = charY = !this.dataIn.isNumericVariable(this.getVariable("Y"));
        }
        if (charX && charY) {
            return new Object[][]{{ROLES.getRoleObject("ROLE_X")}, {ROLES.getRoleObject("ROLE_Y")}};
        }
        if (charX) {
            return new Object[][]{{ROLES.getRoleObject("ROLE_X")}};
        }
        if (charY) {
            return new Object[][]{{ROLES.getRoleObject("ROLE_Y")}};
        }
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (role == null) {
            return null;
        }
        return new int[]{1, -1, 0};
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        if (this.dataOut == null) {
            return;
        }
        switch (evt.type) {
            case 1: {
                this.rebin = true;
                this.userMaxResp = Double.NaN;
                this.userMinResp = Double.NaN;
                this.userMaxXData = Double.NaN;
                this.userMinXData = Double.NaN;
                this.userMaxYData = Double.NaN;
                this.userMinYData = Double.NaN;
                this.userSetYBinNames = false;
                this.userSetXBinNames = false;
                this.dataOut.setSource(null);
                break;
            }
            case 3: {
                this.lastSelected.clear();
                boolean matter = false;
                block6: for (int i = evt.varStartIndex; i <= evt.varEndIndex; ++i) {
                    for (int j = 0; j < this.variables.length; ++j) {
                        if (this.variables[j] == null || this.dataIn.getVariableIndex(this.variables[j]) != i) continue;
                        this.rebin = true;
                        matter = true;
                        continue block6;
                    }
                }
                if (!matter) break;
                this.userMaxResp = Double.NaN;
                this.userMinResp = Double.NaN;
                if (this.roleXChanged) {
                    this.userMaxXData = Double.NaN;
                    this.userMinXData = Double.NaN;
                    this.userSetXBinNames = false;
                }
                if (this.roleYChanged) {
                    this.userMaxYData = Double.NaN;
                    this.userMinYData = Double.NaN;
                    this.userSetYBinNames = false;
                }
                this.dataOut.setSource(null);
                break;
            }
            case 5: {
                boolean matter = false;
                block8: for (int i = evt.varStartIndex; i <= evt.varEndIndex; ++i) {
                    for (int j = 0; j < this.variables.length; ++j) {
                        if (this.variables[j] == null || this.dataIn.getVariableIndex(this.variables[j]) != i) continue;
                        this.variables[j] = null;
                        this.rebin = true;
                        matter = true;
                        continue block8;
                    }
                }
                if (!matter) break;
                this.userMaxResp = Double.NaN;
                this.userMinResp = Double.NaN;
                this.userMaxXData = Double.NaN;
                this.userMinXData = Double.NaN;
                this.userMaxYData = Double.NaN;
                this.userMinYData = Double.NaN;
                this.userSetYBinNames = false;
                this.userSetXBinNames = false;
                this.dataOut.setSource(null);
                break;
            }
            case 2: {
                if (evt.oldValue == null) {
                    if (this.dataIn.getNumberObservations(-1) <= 0) break;
                    boolean selected = this.dataIn.isSelected(0L);
                    this.lastSelected.clear();
                    int rows = this.dataOut.getNumberObservations(-1);
                    if (!selected) {
                        for (int i = 0; i < rows; ++i) {
                            this.selectedValues[i] = 0.0;
                        }
                    } else {
                        for (int i = 0; i < rows; ++i) {
                            Object obj = this.dataOut.getValue((Object)"Observations", (long)i);
                            this.selectedValues[i] = ((int[])obj).length;
                        }
                    }
                    this.selectedAll = true;
                } else {
                    int[] indicies = (int[])evt.oldValue;
                    int size = indicies.length;
                    if (evt.newValue instanceof Number) {
                        size = Math.min(size, ((Number)evt.newValue).intValue());
                    }
                    for (int o = 0; o < size; ++o) {
                        int oo = indicies[o];
                        if (oo < 0 || oo >= this.dataIn.getNumberObservations(-1)) continue;
                        boolean selected = this.dataIn.isSelected((long)oo);
                        Object sel = this.lastSelected.get(new Integer(oo));
                        if (sel instanceof Boolean) {
                            if ((Boolean)sel == selected) continue;
                            this.lastSelected.remove(new Integer(oo));
                        }
                        this.lastSelected.put(new Integer(oo), new Boolean(selected));
                        int obs = this.getModelObservationNo(oo);
                        if (obs < 0) continue;
                        double sValue = this.selectedValues[obs];
                        double freqVal = 1.0;
                        int fId = this.dataIn.getVariableIndex(this.variables[2]);
                        if (fId >= 0) {
                            Object s = this.dataIn.getValue(fId, (long)oo);
                            freqVal = !this.dataIn.isMissing(fId, s) && ((Number)s).doubleValue() >= 0.0 ? ((Number)s).doubleValue() : 0.0;
                        }
                        this.selectedValues[obs] = sValue = selected ? sValue + freqVal : sValue - freqVal;
                        Integer I = new Integer(obs);
                        if (this.currSelectedObs.contains(I)) continue;
                        this.currSelectedObs.add(I);
                    }
                }
                if (evt.isAdjusting) break;
                DvrDataFilterEvent event = new DvrDataFilterEvent(2);
                event.source = this.dataOut;
                this.dataOut.sendEvent((Object)event);
                this.currSelectedObs.clear();
                this.selectedAll = false;
            }
        }
        if (evt.type == 7) {
            this.dataOut.sendEvent((Object)new DvrDataFilterEvent(7));
        }
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    protected Vector getSortedBinNames(Object varId, Vector names, boolean reverse) {
        Vector sortedNames;
        block8: {
            Vector tmpNames;
            int size;
            block7: {
                boolean numeric = this.dataIn.isNumericVariable(varId);
                size = names.size();
                sortedNames = new Vector();
                tmpNames = new Vector();
                for (int i = 0; i < size; ++i) {
                    if (numeric) {
                        sortedNames.addElement(names.elementAt(i));
                        continue;
                    }
                    if (reverse) {
                        this.binarySearch(tmpNames, (String)names.elementAt(i));
                        continue;
                    }
                    this.binarySearch(sortedNames, (String)names.elementAt(i));
                }
                if (!numeric) break block7;
                for (int ii = 0; ii < size; ++ii) {
                    for (int jj = size - 1; jj > ii; --jj) {
                        double val1 = ((Number)sortedNames.elementAt(jj - 1)).doubleValue();
                        double val2 = ((Number)sortedNames.elementAt(jj)).doubleValue();
                        if (reverse) {
                            if (!(val1 < val2)) continue;
                            Object temp = sortedNames.elementAt(jj - 1);
                            sortedNames.setElementAt(sortedNames.elementAt(jj), jj - 1);
                            sortedNames.setElementAt(temp, jj);
                            continue;
                        }
                        if (!(val1 > val2)) continue;
                        Object temp = sortedNames.elementAt(jj - 1);
                        sortedNames.setElementAt(sortedNames.elementAt(jj), jj - 1);
                        sortedNames.setElementAt(temp, jj);
                    }
                }
                break block8;
            }
            if (!reverse || tmpNames.size() <= 1) break block8;
            size = tmpNames.size();
            for (int j = 0; j < size; ++j) {
                sortedNames.addElement(tmpNames.elementAt(size - 1 - j));
            }
        }
        return sortedNames;
    }

    protected void binarySearch(Vector values, String obj) {
        int size = values.size();
        if (size == 0) {
            values.addElement(obj);
        } else {
            String mid_v;
            int left = 0;
            int right = size - 1;
            do {
                int i;
                if (StringCompare.compareTo((String)obj, (String)(mid_v = (String)values.elementAt(i = (left + right) / 2))) < 0) {
                    right = i - 1;
                    continue;
                }
                left = i + 1;
            } while (StringCompare.compareTo((String)obj, (String)mid_v) != 0 && left <= right);
            if (StringCompare.compareTo((String)obj, (String)mid_v) != 0) {
                int index = Math.max(left, right);
                values.insertElementAt(obj, index);
            }
        }
    }

    protected boolean isRoleXChanged() {
        return this.roleXChanged;
    }

    protected void setRoleXChanged(boolean flag) {
        this.roleXChanged = flag;
    }

    protected boolean isRoleYChanged() {
        return this.roleYChanged;
    }

    protected void setRoleYChanged(boolean flag) {
        this.roleYChanged = flag;
    }

    protected boolean isRoleResponseChanged() {
        return this.roleResponseChanged;
    }

    protected void setRoleResponseChanged(boolean flag) {
        this.roleResponseChanged = flag;
    }

    protected void freeMemory() {
        if (this.xBinNames != null && !this.userSetXBinNames) {
            this.xBinNames.clear();
        }
        if (this.yBinNames != null && !this.userSetYBinNames) {
            this.yBinNames.clear();
        }
        if (this.tipNames != null) {
            this.tipNames.removeAllElements();
        }
        if (this.dataOut != null) {
            this.dataOut = null;
        }
    }

    protected void setResponseScaleToNonMissingOnly(boolean scaleToNonMissing) {
        this.responseScaleToNonMissing = scaleToNonMissing;
    }

    protected Map getDensityNames(Object varIdX, Object varIdY) {
        if (varIdX == null || varIdY == null) {
            return null;
        }
        LinkedHashMap<double[], Integer> names = new LinkedHashMap<double[], Integer>();
        int keyIndex = 0;
        int indexX = this.densityCurveData.getVariableIndex(varIdX);
        int indexY = this.densityCurveData.getVariableIndex(varIdY);
        Object objX = null;
        Object objY = null;
        int obsNo = this.densityCurveData.getNumberObservations(indexX);
        for (long i = 0L; i < (long)obsNo; ++i) {
            objX = this.densityCurveData.getValue(indexX, i);
            objY = this.densityCurveData.getValue(indexY, i);
            double[] densityXY = new double[]{((Number)objX).doubleValue(), ((Number)objY).doubleValue()};
            names.put(densityXY, new Integer(keyIndex++));
        }
        this.densityXMinMax = this.getMinMaxValues(varIdX, this.densityCurveData);
        this.densityYMinMax = this.getMinMaxValues(varIdY, this.densityCurveData);
        return names;
    }

    public double[] getDensityXMinMax() {
        return this.densityXMinMax;
    }

    public double[] getDensityYMinMax() {
        return this.densityYMinMax;
    }

    public boolean isDensitySet() {
        return this.densitySet;
    }

    public Map getDensityNames() {
        return this.densityNames;
    }

    protected Map getGroupNames() {
        return this.groupNames;
    }

    protected Map setGroupNames() {
        Object varId = this.variables[7];
        if (varId == null) {
            return null;
        }
        int clrId = this.dataIn.getVariableIndex(this.variables[8]);
        LinkedHashMap<Object, Object> names = new LinkedHashMap<Object, Object>();
        int valueIndex = 0;
        int index = this.dataIn.getVariableIndex(varId);
        boolean missing = false;
        boolean numeric = this.dataIn.isNumericVariable(varId);
        Object grpObj = null;
        if (clrId > -1) {
            int intClr = -1;
            Object clrObj = null;
            for (long i = 0L; i < (long)this.dataIn.getNumberObservations(index); ++i) {
                clrObj = this.dataIn.getValue(clrId, i);
                grpObj = this.dataIn.getValue(index, i);
                if (this.dataIn.isMissing(index, grpObj)) {
                    grpObj = numeric ? new Double(Double.NaN) : "";
                }
                if (names.containsKey(grpObj)) continue;
                if (clrObj instanceof Number && !Double.isNaN(((Number)clrObj).doubleValue())) {
                    intClr = Math.abs(((Number)clrObj).intValue());
                    names.put(grpObj, new Integer(intClr));
                    continue;
                }
                names.put(grpObj, new Integer(Integer.MAX_VALUE));
            }
            Collection c = CollectionSorter.getValues(names.values(), 1);
            Iterator iter = c.iterator();
            intClr = names.size();
            Object[] valueArray = names.values().toArray();
            Object[] keyArray = names.keySet().toArray();
            names.clear();
            boolean matched = false;
            iter = c.iterator();
            while (iter.hasNext()) {
                matched = false;
                Object value = iter.next();
                for (int i = 0; i < intClr && !matched; ++i) {
                    if (!value.equals(valueArray[i]) || names.containsKey(keyArray[i])) continue;
                    names.put(keyArray[i], valueArray[i]);
                    matched = true;
                }
            }
        } else {
            for (long i = 0L; i < (long)this.dataIn.getNumberObservations(index); ++i) {
                grpObj = this.dataIn.getValue(index, i);
                if (this.dataIn.isMissing(index, grpObj)) {
                    missing = true;
                    continue;
                }
                if (names.containsKey(grpObj)) continue;
                names.put(grpObj, new Integer(valueIndex));
                ++valueIndex;
            }
            if (missing) {
                if (numeric) {
                    names.put(new Double(Double.NaN), new Integer(valueIndex));
                } else {
                    names.put("", new Integer(valueIndex));
                }
            }
        }
        return names;
    }

    protected int getGroupIndex(int varId, Map names, Object value) {
        boolean numeric = this.dataIn.isNumericVariable(varId);
        if (this.dataIn.isMissing(varId, value)) {
            value = numeric ? new Double(Double.NaN) : "";
        }
        Iterator iterKey = names.keySet().iterator();
        int index = 0;
        while (iterKey.hasNext()) {
            if (iterKey.next().equals(value)) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    protected int getGroupSize() {
        int grpSize = this.groupNames != null ? this.groupNames.size() : 0;
        return grpSize;
    }

    protected boolean isGroup() {
        return this.groupNames != null;
    }

    protected boolean isSummarized() {
        return this.summarized;
    }

    protected boolean isUserSetXBinNames() {
        return this.userSetXBinNames;
    }

    protected boolean isUserSetYBinNames() {
        return this.userSetYBinNames;
    }

    protected double getTotalFreqVal() {
        int fId = this.dataIn.getVariableIndex(this.variables[2]);
        if (fId >= 0) {
            return this.totalFreqVal > 0.0 ? this.totalFreqVal : 1.0;
        }
        return this.missingBin ? this.dataIn.getNumberObservations(-1) : this.getNonMissingObservations();
    }
}

