/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.histogram;

import com.sas.graphics.silk.event.DataFilterListenerInterface;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.event.RedrawEvent;
import com.sas.graphics.silk.histogram.ChartInterface;
import com.sas.graphics.silk.histogram.HistogramModel;
import com.sas.graphics.silk.interfaces.ColorInterface;
import com.sas.graphics.silk.interfaces.DataFilterReadInterface;
import com.sas.graphics.silk.interfaces.GeometryInterface;
import com.sas.graphics.silk.interfaces.HistogramInterface;
import com.sas.graphics.silk.interfaces.HistogramPropertyInterface;
import com.sas.graphics.silk.interfaces.PropertyInterface;
import com.sas.graphics.silk.interfaces.RedrawListener;
import com.sas.graphics.silk.interfaces.RenderInterface;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.interfaces.RoleListenerInterface;
import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.silk.interfaces.UpdateInterface;
import com.sas.graphics.silk.util.Axes;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.GlobalDefaults;
import com.sas.graphics.silk.util.LegendObject;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.UserSetPropertyBitMask;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.Style;
import com.sas.graphics.util.ColorParse;
import com.sas.graphics.util.FillPattern;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Vector;

public class HistogramChart
implements GeometryInterface,
HistogramInterface,
RenderInterface,
RoleInterface,
UpdateInterface,
DataFilterListenerInterface,
ChartInterface,
PropertyInterface,
HistogramPropertyInterface {
    protected static SILKNumber[] statName;
    public static final double EXTRA_SPACE = 0.02;
    protected boolean visible = true;
    protected double opacity = 1.0;
    protected boolean rebuildRequired = true;
    protected boolean chartBorderOn = false;
    protected boolean outlineOn = true;
    protected Color chartBorderColor;
    protected Color chartWallColor;
    protected Color selectionColor;
    protected Color outlineColor;
    protected DataFilterReadInterface dataIn = null;
    protected HistogramModel histModel = null;
    protected DataFilterReadInterface dataOut = null;
    protected ColorInterface colorRamp = null;
    protected TransformInterface transObj = null;
    protected LegendObject legend;
    protected Axes xAxis = null;
    protected Axes yAxis = null;
    protected Object xVariable = null;
    protected Object yVariable = null;
    protected Object colorVariable = null;
    protected Object xVariable2 = null;
    protected Object yVariable2 = null;
    protected Object tipVariable = null;
    protected Object groupVariable = null;
    protected int statistic = 1;
    protected int statistic2;
    protected boolean isData2D = false;
    protected double xMin;
    protected double xMax;
    protected double yMin;
    protected double yMax;
    protected double cMin;
    protected double cMax;
    protected Vector displayList;
    protected Vector selectionList;
    protected double[] selectedValues;
    protected Vector redrawListener;
    protected double scaleFactor = 1.0;
    protected boolean dataChanged = false;
    protected boolean dataPrepared = false;
    protected double[] chartBBox = new double[6];
    protected double[] scr1 = new double[3];
    protected double[] scr2 = new double[3];
    protected Rectangle2D clipRect;
    protected Dimension chartAreaDimension;
    protected boolean fixedDataRange = true;
    protected boolean redraw = false;
    protected boolean missingBin = false;
    protected Color barColor;
    protected Color groupColor;
    protected boolean colorByChart = true;
    protected boolean density;
    protected double totalCount;
    protected Vector propertyIndex;
    protected Vector propertyValue;
    protected Object[] legendValues;
    protected Roles roles;
    protected ResourceBundle rb;
    protected GlobalDefaults globalDefaults;
    double[] xOffset = new double[2];
    double[] yOffset = new double[2];
    protected Graphics2D graphics2D;
    protected Insets outerMargin;
    protected Insets innerMargin;
    protected double respTickmarkOffset;
    protected double xMinD;
    protected double xMaxD;
    protected double xBinWidth;
    protected double yMinD;
    protected double yMaxD;
    protected double yBinWidth;
    private boolean oneObsX = false;
    private boolean oneObsY = false;
    private LineAttrib densityCurveLine = null;
    private double xAxisMin = Double.NaN;
    private double xAxisMax = Double.NaN;
    protected Color[] dataColor;
    protected Color[] lineColor;
    protected int[] grpClrIndices;
    protected boolean rebinOnZoom = false;
    protected boolean xMinMaxSet = false;
    protected double[] xMinMax = null;
    private boolean equalWidth_X = true;
    protected boolean gradient = true;
    protected boolean intervalAxis = false;
    protected boolean scaledSpacingX = true;
    private int numberOfVirtualBins;
    protected Style style;
    protected String styleElement = "GraphDataStyleDefault";
    protected int[] supportedProperties = new int[]{801, 802, 803, 804, 805, 806, 807, 808, 820, 812, 813, 814, 815, 818, 819, 821, 822};
    protected UserSetPropertyBitMask userSetProperties = new UserSetPropertyBitMask(this.supportedProperties);

    public HistogramChart(Object dataObject) {
        this.chartBorderColor = Color.black;
        this.outlineColor = Color.black;
        this.selectionColor = new Color(255, 197, 0);
        this.chartWallColor = new Color(225, 229, 250);
        this.barColor = new Color(100, 100, 175);
        this.groupColor = new Color(1.0f, 0.0f, 0.0f);
        this.displayList = new Vector();
        this.selectionList = new Vector();
        this.redrawListener = new Vector();
        this.globalDefaults = new GlobalDefaults();
        this.roles = Roles.getInstance(null);
        this.rb = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.histogram.silk_histogram_NLS");
        statName = new SILKNumber[6];
        HistogramChart.statName[0] = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.None.txt", (String)"None"), "None");
        HistogramChart.statName[1] = new SILKNumber(1, ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Sum.txt", (String)"Sum"), "Sum");
        HistogramChart.statName[2] = new SILKNumber(2, ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Mean.txt", (String)"Mean"), "Mean");
        HistogramChart.statName[3] = new SILKNumber(3, ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Frequency.txt", (String)"Frequency"), "Frequency");
        HistogramChart.statName[4] = new SILKNumber(4, ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Percent.txt", (String)"Percent"), "Percent");
        HistogramChart.statName[5] = new SILKNumber(5, ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Density.txt", (String)"Density"), "Density");
        this.propertyIndex = new Vector();
        this.propertyValue = new Vector();
        this.setDataSource(dataObject);
        this.xOffset[1] = 0.0;
        this.xOffset[0] = 0.0;
        this.yOffset[1] = 0.0;
        this.yOffset[0] = 0.0;
        this.graphics2D = null;
        this.outerMargin = new Insets(0, 0, 0, 0);
        this.innerMargin = new Insets(0, 0, 0, 0);
        this.respTickmarkOffset = 0.0;
    }

    public HistogramChart() {
        this(null);
    }

    public void setXAxis(Axes axis) {
        this.xAxis = axis;
    }

    public void setYAxis(Axes axis) {
        this.yAxis = axis;
    }

    public void setLegend(LegendObject leg) {
        this.legend = leg;
    }

    @Override
    public boolean isLegendRequired() {
        return this.histModel != null && (this.histModel.isBivariateHistogram() || this.histModel.isGroup());
    }

    @Override
    public boolean isDataChanged() {
        return this.dataChanged;
    }

    private void decideVariables() {
        Object sVar = this.histModel.getVariable("STAT");
        this.statistic2 = sVar == null || sVar != null && (this.isDiscrete(this.getRole(sVar)) || !this.dataIn.isNumericVariable(sVar)) ? 3 : this.statistic;
        if (this.statistic == 3 || this.statistic == 4) {
            this.colorVariable = "Frequency";
            this.statistic2 = this.statistic == 4 ? 4 : 3;
        }
        this.histModel.setStatistic(this.statistic2);
        if (sVar != null) {
            switch (this.statistic2) {
                case 0: 
                case 3: 
                case 4: 
                case 5: {
                    this.colorVariable = "Frequency";
                    break;
                }
                case 1: {
                    this.colorVariable = "Sum";
                    break;
                }
                case 2: {
                    this.colorVariable = "Mean";
                }
            }
        } else {
            this.colorVariable = "Frequency";
        }
        if (!this.histModel.isBivariateHistogram()) {
            this.yVariable = this.yVariable2 = this.colorVariable;
            this.isData2D = false;
        } else {
            this.yVariable = "Y";
            this.yVariable2 = "YBinNo";
            this.isData2D = true;
        }
        this.xVariable = "X";
        this.xVariable2 = "XBinNo";
        this.tipVariable = "Tip";
        this.groupVariable = "Group";
    }

    @Override
    public void setChartAreaDimension(Dimension d) {
        this.chartAreaDimension = d;
        this.xAxis.setChartAreaDimension(d);
        this.yAxis.setChartAreaDimension(d);
    }

    public boolean setChartClipArea(Rectangle2D rect) {
        this.clipRect = rect;
        this.xAxis.setScreenArea((int)this.clipRect.getX(), (int)this.clipRect.getY(), (int)this.clipRect.getWidth(), (int)this.clipRect.getHeight());
        this.yAxis.setOffset(0, 0);
        this.yAxis.setScreenArea((int)this.clipRect.getX(), (int)this.clipRect.getY(), (int)this.clipRect.getWidth(), (int)this.clipRect.getHeight());
        this.xAxis.setGridLineLength(this.clipRect.getHeight());
        this.yAxis.setGridLineLength(this.clipRect.getWidth());
        return !this.isData2D;
    }

    @Override
    public Insets getOuterMargin(Graphics2D g) {
        Insets margin = new Insets(0, 0, 0, 0);
        this.graphics2D = g;
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return margin;
        }
        if (!this.prepareChartData()) {
            return margin;
        }
        this.setMargins();
        margin = this.outerMargin;
        return margin;
    }

    public Insets getInnerMargin() {
        this.setMargins();
        return this.innerMargin;
    }

    @Override
    public double getResponseAxisTickmarkOffset() {
        return this.respTickmarkOffset;
    }

    public double[] adjustYMinYMax() {
        if (this.histModel.isZeroObservation()) {
            double[] out = new double[]{0.0, 1.0};
            return out;
        }
        if (!this.histModel.isBivariateHistogram()) {
            double[] ends = this.yAxis.getMinMaxTickMarkValues();
            if (ends[0] == ends[1]) {
                ends[1] = ends[1] + 1.0;
            }
            this.yMin = ends[0];
            this.yMax = ends[1];
        }
        double[] out = new double[]{this.yMin, this.yMax};
        return out;
    }

    @Override
    public boolean isHighlightRequired() {
        return this.selectionList.size() > 0;
    }

    private boolean prepareChartData() {
        HashMap binNames;
        if (this.dataPrepared) {
            return true;
        }
        if (this.histModel == null) {
            return false;
        }
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.histModel.setShowMissingBins(this.missingBin);
        this.dataOut = (DataFilterReadInterface)this.histModel.getDataSource();
        if (this.dataOut == null) {
            return false;
        }
        this.dataOut.addDataFilterListener((Object)this);
        this.density = this.statistic == 5;
        this.histModel.setShowDensity(this.density);
        this.totalCount = this.histModel.getTotalFreqVal();
        this.decideVariables();
        this.xAxis.setDataSource((DataFilterReadInterface)this.histModel.getDataSource());
        if (this.histModel.isRoleXChanged()) {
            this.xAxis.setRole(this.xVariable, "XAxis");
            this.xAxis.setLabel(this.buildAxisLabel(true, this.xVariable));
            this.histModel.setRoleXChanged(false);
        }
        Object[] nm = (binNames = this.histModel.getXBinNames()) != null ? binNames.keySet().toArray() : null;
        nm[nm.length - 1] = ".";
        boolean bl = this.oneObsX = nm != null && nm[0] instanceof Number && nm.length == 2;
        if (binNames != null) {
            Object fmt;
            Object[] values;
            if (!this.dataIn.isNumericVariable(this.getVariable("X")) || this.oneObsX || nm.length == 1) {
                this.xBinWidth = 1.0;
                if (this.histModel.isBivariateHistogram()) {
                    this.xAxis.setTickInCenter(true, this.xBinWidth / 2.0);
                } else {
                    this.xAxis.setTickInCenter(true, 0.0);
                }
                this.xAxis.setAxis(null, null, -1, -1, nm, null, null);
            } else if (this.isDiscrete("X")) {
                if (((Number)this.getSortOrder(new Integer(24))).intValue() == 1 && this.isOrdinal(binNames) && !this.histModel.isBivariateHistogram() && (this.xMinMaxSet || this.intervalAxis || this.scaledSpacingX)) {
                    this.xBinWidth = this.getBinWidth(nm);
                    if (this.xMinMaxSet) {
                        this.xMinD = this.xAxisMin;
                        this.xMaxD = this.xAxisMax;
                        this.numberOfVirtualBins = (int)((this.xMaxD - this.xMinD) / this.xBinWidth);
                        this.xAxis.setRangeMinSet(false);
                        this.xAxis.setRangeMaxSet(false);
                        this.xAxis.setAxis(new Double(this.xMinD - this.xBinWidth / 2.0), new Double(this.xMaxD + this.xBinWidth / 2.0), -1, -1, null, Boolean.TRUE, null);
                        double[] endpts = this.xAxis.getEndPoint(false, false);
                        if (endpts != null) {
                            this.xMinD = endpts[0];
                            this.xMaxD = endpts[1];
                        }
                        this.xAxis.setShowMissing(this.missingBin, this.xMinD - this.xBinWidth);
                        this.xAxis.build(null);
                    } else if (this.intervalAxis) {
                        long obs = this.dataOut.getNumberObservations(-1);
                        int grpSize = this.histModel.isGroup() ? this.histModel.getGroupSize() : 1;
                        long num = obs - (long)grpSize;
                        this.xMinD = this.histModel.getMinimumValue(this.xVariable, 0L, num);
                        this.xMaxD = this.histModel.getMaximumValue(this.xVariable, 0L, num);
                        this.xMinD -= this.xBinWidth / 2.0;
                        this.xMaxD += this.xBinWidth / 2.0;
                        this.xAxis.setRangeMinSet(false);
                        this.xAxis.setRangeMaxSet(false);
                        this.xAxis.setAxis(new Double(this.xMinD), new Double(this.xMaxD), -1, -1, null, Boolean.TRUE, null);
                        double[] endpts1 = this.xAxis.getEndPoint(false, false);
                        if (endpts1 != null) {
                            this.xMinD = endpts1[0];
                            this.xMaxD = endpts1[1];
                        }
                        this.numberOfVirtualBins = (int)((this.xMaxD - this.xMinD) / this.xBinWidth);
                        this.xAxis.setShowMissing(this.missingBin, this.xMinD - this.xBinWidth);
                        this.xAxis.build(null);
                    } else if (!this.equalWidth_X) {
                        this.xMinD = ((Number)nm[0]).doubleValue() - this.xBinWidth / 2.0;
                        this.xMaxD = ((Number)nm[binNames.size() - 2]).doubleValue() + this.xBinWidth / 2.0;
                        this.numberOfVirtualBins = (int)((this.xMaxD - this.xMinD) / this.xBinWidth);
                        if (this.histModel.isBivariateHistogram()) {
                            this.xAxis.setTickInCenter(true, this.xBinWidth / 2.0);
                        } else {
                            this.xAxis.setTickInCenter(true, 0.0);
                        }
                        this.xAxis.setShowMissing(this.missingBin, this.xMinD - this.xBinWidth / 2.0);
                        this.xAxis.setAxis(new Double(this.xMinD), new Double(this.xMaxD), -1, -1, nm, null, Boolean.FALSE);
                    } else {
                        this.xMinD = ((Number)nm[0]).doubleValue() - this.xBinWidth / 2.0;
                        this.xMaxD = ((Number)nm[binNames.size() - 2]).doubleValue() + this.xBinWidth / 2.0;
                        if (this.histModel.isBivariateHistogram()) {
                            this.xAxis.setTickInCenter(true, this.xBinWidth / 2.0);
                        } else {
                            this.xAxis.setTickInCenter(true, 0.0);
                        }
                        this.numberOfVirtualBins = (int)((this.xMaxD - this.xMinD) / this.xBinWidth);
                        this.xAxis.setShowMissing(this.missingBin, this.xMinD - this.xBinWidth / 2.0);
                        this.xAxis.setAxis(new Double(this.xMinD), new Double(this.xMaxD), -1, -1, nm, null, Boolean.TRUE);
                    }
                } else {
                    this.xBinWidth = 1.0;
                    if (this.histModel.isBivariateHistogram()) {
                        this.xAxis.setTickInCenter(true, this.xBinWidth / 2.0);
                    } else {
                        this.xAxis.setTickInCenter(true, 0.0);
                    }
                    this.xAxis.setAxis(null, null, -1, -1, nm, null, null);
                    this.numberOfVirtualBins = this.histModel.getNumberXBins();
                }
            } else {
                this.xAxis.setTickInCenter(false, 0.0);
                Object nmi = nm[0];
                this.xMinD = ((double[])nmi)[0];
                this.xBinWidth = ((double[])nmi)[1] - ((double[])nmi)[0];
                nmi = nm[binNames.size() - 2];
                this.xMaxD = ((double[])nmi)[1];
                this.numberOfVirtualBins = this.histModel.getNumberXBins();
                if (this.histModel.isDensitySet()) {
                    double[] minmax = this.histModel.getDensityXMinMax();
                    this.xMinD = !Double.isNaN(this.xAxisMin) ? this.xAxisMin : Math.min(this.xMinD, minmax[0]);
                    this.xMaxD = !Double.isNaN(this.xAxisMax) ? this.xAxisMax : Math.max(this.xMaxD, minmax[1]);
                    this.xAxis.setAxis(new Double(this.xMinD), new Double(this.xMaxD), -1, -1, null, Boolean.FALSE, null);
                } else if (this.xMinMaxSet) {
                    this.xMinD = this.xAxisMin;
                    this.xMaxD = this.xAxisMax;
                    this.xAxis.setAxis(new Double(this.xMinD), new Double(this.xMaxD), -1, -1, null, Boolean.TRUE, null);
                    double[] endpts = this.xAxis.getEndPoint(false, false);
                    if (endpts != null) {
                        this.xMinD = endpts[0];
                        this.xMaxD = endpts[1];
                    }
                    this.xAxis.setShowMissing(this.missingBin, this.xMinD - this.xBinWidth);
                    this.xAxis.build(null);
                } else if (this.histModel.isUserSetXBinNames()) {
                    Object val;
                    values = new Object[binNames.size()];
                    for (int i = 0; i < binNames.size() - 1; ++i) {
                        val = nm[i];
                        values[i] = new Double(((double[])val)[0]);
                    }
                    val = nm[binNames.size() - 2];
                    values[binNames.size() - 1] = new Double(((double[])val)[1]);
                    this.xBinWidth = (((Number)values[values.length - 1]).doubleValue() - ((Number)values[0]).doubleValue()) / (double)(binNames.size() - 1);
                    this.xAxis.setAxis(null, null, -1, -1, values, null, Boolean.FALSE);
                } else {
                    this.xAxis.setShowMissing(this.missingBin, this.xMinD - this.xBinWidth);
                    this.xAxis.setAxis(new Double(this.xMinD), new Double(this.xMaxD), binNames.size(), -1, null, Boolean.FALSE, null);
                }
            }
            this.yAxis.setDataSource((DataFilterReadInterface)this.histModel.getDataSource());
            if (this.histModel.isBivariateHistogram()) {
                if (this.histModel.isRoleYChanged()) {
                    this.yAxis.setRole(this.yVariable, "YAxis");
                    this.yAxis.setLabel(this.buildAxisLabel(false, this.yVariable));
                    this.histModel.setRoleYChanged(false);
                }
                binNames = this.histModel.getYBinNames();
                nm = binNames.keySet().toArray();
                nm[nm.length - 1] = ".";
                boolean bl2 = this.oneObsY = nm != null && nm[0] instanceof Number && nm.length == 2;
                if (binNames != null) {
                    if (this.isDiscrete("Y") || !this.dataIn.isNumericVariable(this.getVariable("Y")) || this.oneObsY || nm.length == 1) {
                        this.yBinWidth = 1.0;
                        this.yAxis.setTickInCenter(true, this.yBinWidth / 2.0);
                        this.yAxis.setAxis(null, null, -1, -1, nm, null, null);
                    } else {
                        this.yAxis.setTickInCenter(false, 0.0);
                        Object nmi = nm[0];
                        this.yMinD = ((double[])nmi)[0];
                        this.yBinWidth = ((double[])nmi)[1] - ((double[])nmi)[0];
                        nmi = nm[binNames.size() - 2];
                        this.yMaxD = ((double[])nmi)[1];
                        if (this.histModel.isUserSetYBinNames()) {
                            values = new Object[binNames.size()];
                            for (int i = 0; i < binNames.size() - 1; ++i) {
                                Object val = nm[i];
                                values[i] = new Double(((double[])val)[0]);
                            }
                            Object val = nm[binNames.size() - 2];
                            values[binNames.size() - 1] = new Double(((double[])val)[1]);
                            this.yBinWidth = (((Number)values[values.length - 1]).doubleValue() - ((Number)values[0]).doubleValue()) / (double)(binNames.size() - 1);
                            this.yAxis.setAxis(null, null, -1, -1, values, null, Boolean.FALSE);
                        } else {
                            this.yAxis.setShowMissing(this.missingBin, this.yMin - this.yBinWidth);
                            this.yAxis.setAxis(new Double(this.yMinD), new Double(this.yMaxD), binNames.size(), -1, null, Boolean.FALSE, null);
                        }
                    }
                }
            } else {
                if (this.histModel.isRoleResponseChanged()) {
                    this.yAxis.setRole(this.yVariable, "YAxis");
                    if (this.statistic == 3) {
                        SASFormat sf = SASFormat.getInstance((String)"NLNUM8.0");
                        this.yAxis.setFormat(sf);
                    } else {
                        this.yAxis.setFormat((SASFormat)this.dataOut.getFormat(this.yVariable, SASFormat.class));
                    }
                    this.yAxis.setLabel(this.buildAxisLabel(false, this.yVariable));
                    this.histModel.setRoleResponseChanged(false);
                }
                double min = Math.min(0.0, this.histModel.getMinimumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                double max = Math.max(0.0, this.histModel.getMaximumValue(this.yVariable, 0L, this.dataOut.getNumberObservations(-1)));
                if (this.statistic == 4) {
                    min = min * 100.0 / this.totalCount;
                    max = max * 100.0 / this.totalCount;
                }
                if (this.histModel.isDensitySet()) {
                    double[] minmax = this.histModel.getDensityYMinMax();
                    min = Math.min(min, minmax[0]);
                    max = Math.max(max, minmax[1]);
                }
                this.yAxis.setTickInCenter(false, 0.0);
                this.yAxis.setAxis(new Double(min), new Double(max), -1, -1, null, new Boolean(true), null);
            }
            this.setMargins();
            this.cMin = this.histModel.getMinimumValue(this.colorVariable);
            this.cMax = this.histModel.getMaximumValue(this.colorVariable);
            String title = this.legend.getTitle() == null ? null : (String)this.legend.getTitle().getText();
            Object object = fmt = this.legend.getLabel() == null ? null : this.legend.getLabel().getFormat();
            if (this.density) {
                if (title == null || title.length() == 0) {
                    title = ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Density.txt", (String)"Density");
                }
                if (fmt == null) {
                    fmt = this.globalDefaults == null ? "Best12" : this.globalDefaults.defaultNumericFormat;
                }
            } else if (this.histModel.getVariable("STAT") == null) {
                if (title == null || title.length() == 0) {
                    title = this.statistic2 == 4 ? statName[this.statistic2].toString() : (String)this.getNLSName(this.colorVariable);
                }
                if (fmt == null) {
                    fmt = this.globalDefaults == null ? "Best12" : this.globalDefaults.defaultNumericFormat;
                }
            } else {
                if (title == null || title.length() == 0) {
                    title = (String)this.histModel.getVariableDescription("STAT");
                }
                if (fmt == null && ((fmt = this.dataOut.getFormat(this.colorVariable, null)) == null || fmt instanceof String && ((String)fmt).trim().equals(""))) {
                    Object object2 = fmt = this.globalDefaults == null ? "Best12" : this.globalDefaults.defaultNumericFormat;
                }
            }
            if (this.histModel.isBivariateHistogram()) {
                this.legend.setTitle(title);
                this.legend.setLabel(fmt);
                Color[] colors = this.colorRamp.getColors();
                this.legendValues = colors != null && colors.length == 3 ? new Object[3] : new Object[2];
                double d1 = 0.0;
                double d2 = 0.0;
                if (this.density) {
                    d1 = this.cMin / this.totalCount;
                    d2 = this.cMax / this.totalCount;
                } else if (this.statistic2 == 4) {
                    d1 = this.cMin * 100.0 / this.totalCount;
                    d2 = this.cMax * 100.0 / this.totalCount;
                } else {
                    d1 = this.cMin;
                    d2 = this.cMax;
                }
                this.legendValues[0] = new Double(d1);
                if (this.legendValues.length == 2) {
                    this.legendValues[1] = new Double(d2);
                } else {
                    this.legendValues[1] = new Double((d1 + d2) / 2.0);
                    this.legendValues[2] = new Double(d2);
                }
                this.legend.setValues(colors, null, this.legendValues, null, true);
            } else if (this.histModel.isGroup()) {
                this.setGroupColorIndices();
                this.setGroupLegend();
            } else {
                this.legend.setValues(null, null, null, (boolean[])null, true);
            }
            this.dataPrepared = true;
            this.histModel.setRoleXChanged(false);
            this.histModel.setRoleYChanged(false);
            return true;
        }
        return false;
    }

    private boolean buildChart_2d() {
        long obs = this.dataOut.getNumberObservations(-1);
        int cIdx = this.dataOut.getVariableIndex(this.colorVariable);
        double x = 0.0;
        double y = 0.0;
        double c = 0.0;
        double s = 0.0;
        double f = 0.0;
        HistogramElement e = null;
        HashMap xBinNames = this.histModel.getXBinNames();
        HashMap yBinNames = this.histModel.getYBinNames();
        double xMidPt = 0.0;
        double yMidPt = 0.0;
        double binWidthX = this.xBinWidth;
        double binWidthY = this.yBinWidth;
        int i = 0;
        while ((long)i < obs) {
            Object cObj = this.dataOut.getValue(cIdx, (long)i);
            Object fObj = this.dataOut.getValue((Object)"Frequency", (long)i);
            if (!this.dataOut.isMissing(cIdx, cObj)) {
                Object nmi;
                Object[] nm;
                if (!this.dataIn.isNumericVariable(this.getVariable("X")) || this.oneObsX) {
                    x = this.histModel.getXBinNo(i);
                    xMidPt = x + 0.5;
                } else if (this.isDiscrete("X")) {
                    if (((Number)this.getSortOrder(new Integer(24))).intValue() == 1 && xBinNames != null && this.isOrdinal(xBinNames) && !this.histModel.isBivariateHistogram() && (this.xMinMaxSet || this.intervalAxis || this.scaledSpacingX)) {
                        nm = xBinNames.keySet().toArray();
                        nmi = nm[i % xBinNames.size()];
                        xMidPt = nmi instanceof String ? this.xMinD - this.xBinWidth / 2.0 : ((Number)nmi).doubleValue();
                    } else {
                        x = this.histModel.getXBinNo(i);
                        xMidPt = x + 0.5;
                    }
                } else {
                    Object[] nm2 = xBinNames.keySet().toArray();
                    nmi = nm2[i % xBinNames.size()];
                    if (nmi instanceof String) {
                        if (this.missingBin) {
                            xMidPt = this.xMinD - this.xBinWidth / 2.0;
                            binWidthX = this.xBinWidth;
                        } else {
                            xMidPt = this.xMinD;
                            binWidthX = 0.0;
                        }
                    } else {
                        binWidthX = ((double[])nmi)[1] - ((double[])nmi)[0];
                        xMidPt = ((double[])nmi)[0] + (((double[])nmi)[1] - ((double[])nmi)[0]) / 2.0;
                    }
                }
                if (this.isDiscrete("Y") || !this.dataIn.isNumericVariable(this.getVariable("Y")) || this.oneObsY) {
                    y = this.histModel.getYBinNo(i);
                    yMidPt = y + 0.5;
                } else {
                    nm = yBinNames.keySet().toArray();
                    nmi = nm[i / xBinNames.size()];
                    if (nmi instanceof String) {
                        if (this.missingBin) {
                            binWidthY = this.yBinWidth;
                        } else {
                            yMidPt = this.yMinD;
                            binWidthY = 0.0;
                        }
                    } else {
                        binWidthY = ((double[])nmi)[1] - ((double[])nmi)[0];
                        yMidPt = ((double[])nmi)[0] + (((double[])nmi)[1] - ((double[])nmi)[0]) / 2.0;
                    }
                }
                c = (Double)cObj;
                s = this.selectedValues[i];
                f = (Double)fObj;
                if (f != 0.0) {
                    double c_uniform = this.cMax - this.cMin == 0.0 ? 1.0 : (c - this.cMin) / (this.cMax - this.cMin);
                    Color color = this.colorRamp.queryDouble(c_uniform, false, null);
                    e = new HistogramElement(color);
                    this.displayList.addElement(e);
                    double xo = xMidPt - binWidthX * this.scaleFactor / 2.0;
                    double yo = yMidPt + binWidthY * this.scaleFactor / 2.0;
                    double wt = binWidthX * this.scaleFactor;
                    double ht = binWidthY * this.scaleFactor;
                    Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
                    e = new HistogramElement(rect2D);
                    this.displayList.addElement(e);
                    e.obsNo = i;
                    if (s != 0.0) {
                        Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
                        this.selectionList.addElement(tmp);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean buildChart_1d() {
        long obs = this.dataOut.getNumberObservations(-1);
        int yIdx = this.dataOut.getVariableIndex(this.yVariable2);
        int cIdx = this.dataOut.getVariableIndex(this.colorVariable);
        int gIdx = this.dataOut.getVariableIndex(this.groupVariable);
        double x = 0.0;
        double y = 0.0;
        double c = 0.0;
        double s = 0.0;
        double f = 0.0;
        HistogramElement e = null;
        HashMap binNames = this.histModel.getXBinNames();
        Object[] nm = binNames != null ? binNames.keySet().toArray() : null;
        double midPt = 0.0;
        int grpSize = this.histModel.isGroup() ? this.histModel.getGroupSize() : 1;
        long num = this.missingBin ? obs : obs - (long)grpSize;
        double binWidthX = this.xBinWidth;
        int i = 0;
        while ((long)i < num) {
            Object yObj = this.dataOut.getValue(yIdx, (long)i);
            Object cObj = this.dataOut.getValue(cIdx, (long)i);
            Object fObj = this.dataOut.getValue((Object)"Frequency", (long)i);
            Object gObj = this.dataOut.getValue(gIdx, (long)i);
            if (!this.dataOut.isMissing(yIdx, yObj) && !this.dataOut.isMissing(cIdx, cObj)) {
                if (!this.dataIn.isNumericVariable(this.getVariable("X")) || this.oneObsX) {
                    x = this.histModel.getXBinNo(i / grpSize);
                    midPt = x + 0.5;
                } else if (this.isDiscrete("X")) {
                    if (((Number)this.getSortOrder(new Integer(24))).intValue() == 1 && binNames != null && this.isOrdinal(binNames) && !this.histModel.isBivariateHistogram() && (this.xMinMaxSet || this.intervalAxis || this.scaledSpacingX)) {
                        midPt = nm[i / grpSize] instanceof String ? this.xMinD - this.xBinWidth / 2.0 : ((Number)nm[i / grpSize]).doubleValue();
                    } else {
                        x = this.histModel.getXBinNo(i / grpSize);
                        midPt = x + 0.5;
                    }
                } else if (binNames != null) {
                    Object nmi = nm[i / grpSize];
                    if (nmi instanceof String) {
                        midPt = this.xMinD - this.xBinWidth / 2.0;
                        binWidthX = this.xBinWidth;
                    } else {
                        binWidthX = ((double[])nmi)[1] - ((double[])nmi)[0];
                        midPt = ((double[])nmi)[0] + (((double[])nmi)[1] - ((double[])nmi)[0]) / 2.0;
                    }
                }
                y = (Double)yObj;
                if (this.density) {
                    y = y / this.totalCount / this.xBinWidth;
                }
                c = (Double)cObj;
                s = this.selectedValues[i];
                f = (Double)fObj;
                if (f != 0.0) {
                    Color color;
                    if (this.statistic2 == 4) {
                        y = f * 100.0 / this.totalCount;
                    }
                    if (this.histModel.isGroup()) {
                        if (this.grpClrIndices[i % grpSize] == Integer.MAX_VALUE) {
                            color = this.colorRamp.getMissingColor();
                        } else {
                            String gValueStr = gObj.toString();
                            DataStyleElement dse = SILKUtilities.getStyleElement(gValueStr, this.grpClrIndices[i % grpSize], 2, this.style, this.styleElement, null).getAsDataStyle();
                            color = i % grpSize == 0 ? dse.getFillColor() : dse.getLineColor();
                        }
                    } else {
                        double c_uniform = this.cMax - this.cMin == 0.0 ? 1.0 : (c - this.cMin) / (this.cMax - this.cMin);
                        color = this.colorRamp.queryDouble(c_uniform, false, null);
                    }
                    e = new HistogramElement(color);
                    this.displayList.addElement(e);
                    double xo = midPt - binWidthX * this.scaleFactor / 2.0;
                    double wt = binWidthX * this.scaleFactor;
                    double yo = y < 0.0 ? 0.0 : y;
                    double ht = Math.abs(y);
                    Rectangle2D.Double rect2D = new Rectangle2D.Double(xo, yo, wt, ht);
                    e = grpSize > 1 ? (i % grpSize == 0 ? new HistogramElement(rect2D) : new HistogramElement(rect2D, "Empty")) : new HistogramElement(rect2D);
                    this.displayList.addElement(e);
                    e.obsNo = i;
                    if (s != 0.0) {
                        Object[] tmp = new Object[]{new Integer(this.displayList.size() - 1), new Double(s / f)};
                        this.selectionList.addElement(tmp);
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected String getDescription(Object x, Object y, Object c, Object t, Object g) {
        String cstr;
        String ystr;
        double[] val;
        String xstr;
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Probe.fmt.txt", (String)"{0} = {1}"));
        Message binMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.BinRange.fmt.txt", (String)"{0} = [{1}, {2}]"));
        Message statMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.StatisticType.fmt.txt", (String)"{0} ({1})"));
        if (!(x instanceof double[])) {
            xstr = probeMessage.toString((Object)((String)this.histModel.getVariableDescription("X")), (Object)this.getValueLabel(this.xVariable, x));
        } else {
            val = (double[])x;
            xstr = binMessage.toString((Object)((String)this.histModel.getVariableDescription("X")), (Object)this.getValueLabel(this.xVariable, new Double(val[0])), (Object)this.getValueLabel(this.xVariable, new Double(val[1])));
        }
        String tstr = t == null ? "" : "\n" + probeMessage.toString((Object)((String)this.histModel.getVariableDescription("Tip")), (Object)this.getValueLabel(this.tipVariable, t));
        if (y == null) {
            ystr = "";
        } else if (!(y instanceof double[])) {
            ystr = "\n" + probeMessage.toString((Object)((String)this.histModel.getVariableDescription("Y")), (Object)this.getValueLabel(this.yVariable, y));
        } else {
            val = (double[])y;
            ystr = "\n" + binMessage.toString((Object)((String)this.histModel.getVariableDescription("Y")), (Object)this.getValueLabel(this.yVariable, new Double(val[0])), (Object)this.getValueLabel(this.yVariable, new Double(val[1])));
        }
        if (c == null) {
            cstr = "";
        } else if (this.density) {
            double d = (Double)c / this.totalCount / this.xBinWidth;
            c = new Double(d);
            cstr = this.histModel.getVariable("STAT") == null ? "\n" + probeMessage.toString((Object)ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Density.txt", (String)"Density"), (Object)this.getValueLabel(this.colorVariable, c)) : "\n" + probeMessage.toString((Object)statMessage.toString((Object)((String)this.histModel.getVariableDescription("STAT")), this.getNLSName((Object)statName[this.statistic2])), (Object)this.getValueLabel(this.colorVariable, c));
        } else if (this.histModel.getVariable("STAT") == null) {
            if (this.histModel.getVariable("Freq") == null) {
                if (this.statistic2 == 4) {
                    double d = (Double)c * 100.0 / this.totalCount;
                    c = new Double(d);
                    cstr = "\n" + probeMessage.toString(this.getNLSName((Object)statName[this.statistic2]), (Object)this.getValueLabel(this.colorVariable, c));
                } else {
                    cstr = "\n" + probeMessage.toString((Object)((String)this.colorVariable), (Object)this.getValueLabel(this.colorVariable, c));
                }
            } else if (this.statistic2 == 4) {
                double d = (Double)c * 100.0 / this.totalCount;
                c = new Double(d);
                cstr = "\n" + probeMessage.toString((Object)statMessage.toString((Object)((String)this.histModel.getVariableDescription("FREQ")), this.getNLSName((Object)statName[this.statistic2])), (Object)this.getValueLabel(this.colorVariable, c));
            } else {
                cstr = "\n" + probeMessage.toString((Object)statMessage.toString((Object)((String)this.histModel.getVariableDescription("FREQ")), this.getNLSName((Object)statName[this.statistic2])), (Object)this.getValueLabel(this.colorVariable, c));
            }
        } else {
            cstr = "\n" + probeMessage.toString((Object)statMessage.toString((Object)((String)this.histModel.getVariableDescription("STAT")), this.getNLSName((Object)statName[this.statistic2])), (Object)this.getValueLabel(this.colorVariable, c));
        }
        String gstr = g == null ? "" : "\n" + probeMessage.toString((Object)((String)this.histModel.getVariableDescription("Group")), (Object)this.getValueLabel(this.groupVariable, g));
        String str = xstr + ystr + cstr + tstr + gstr;
        str = str.replaceAll("=", "\t=\t");
        str = str.replaceAll("\\[", "\t \t\\[");
        return str;
    }

    protected String getValueLabel(Object variableId, Object value) {
        Object format = this.dataOut.getFormat(variableId, null);
        String label = value instanceof String && value.equals("") ? "." : this.dataOut.getFormattedValue(variableId, value, format);
        return label.trim();
    }

    @Override
    public boolean setSelection(Rectangle2D rect, boolean extend) {
        HistogramElement e;
        int i;
        Vector<Object> sel = new Vector<Object>();
        int size = this.displayList.size();
        if (extend) {
            for (i = 0; i < this.selectionList.size(); ++i) {
                sel.addElement(((Object[])this.selectionList.elementAt(i))[0]);
            }
            for (i = 0; i < size; ++i) {
                e = (HistogramElement)this.displayList.elementAt(i);
                if (!(e.element instanceof Rectangle2D.Double) || e.projectedRect == null || !rect.intersects(e.projectedRect)) continue;
                Integer obj = new Integer(i);
                if (sel.contains(obj)) {
                    sel.removeElement(obj);
                    continue;
                }
                sel.addElement(obj);
            }
        } else {
            for (i = 0; i < size; ++i) {
                e = (HistogramElement)this.displayList.elementAt(i);
                if (!(e.element instanceof Rectangle2D.Double) || e.projectedRect == null || !rect.intersects(e.projectedRect)) continue;
                sel.addElement(new Integer(i));
            }
        }
        boolean fire = false;
        if (this.selectionList.size() != sel.size()) {
            fire = true;
        } else {
            size = this.selectionList.size();
            for (int i2 = 0; i2 < size; ++i2) {
                int idx = (Integer)((Object[])this.selectionList.elementAt(i2))[0];
                double percent = (Double)((Object[])this.selectionList.elementAt(i2))[1];
                if ((Integer)sel.elementAt(i2) == idx && percent == 1.0) continue;
                fire = true;
                break;
            }
        }
        if (fire) {
            this.histModel.setSelectionAll(false);
            size = sel.size();
            if (size > 0) {
                int[] obs = new int[size];
                for (int i3 = 0; i3 < size; ++i3) {
                    int n = (Integer)sel.elementAt(i3);
                    obs[i3] = (int)((HistogramElement)this.displayList.elementAt((int)n)).obsNo;
                }
                this.histModel.setSelection(obs, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void setSelection(int mouseX, int mouseY, boolean extend) {
        int index = this.getIndexOfDisplayList(mouseX, mouseY);
        if (extend) {
            if (index >= 0) {
                HistogramElement e = (HistogramElement)this.displayList.elementAt(index);
                boolean selected = false;
                for (int i = 0; i < this.selectionList.size(); ++i) {
                    if (index != (Integer)((Object[])this.selectionList.elementAt(i))[0]) continue;
                    selected = true;
                    break;
                }
                if (selected) {
                    this.histModel.setSelection(e.obsNo, false);
                } else {
                    this.histModel.setSelection(e.obsNo, true);
                }
            }
        } else {
            this.histModel.setSelectionAll(false);
            if (index >= 0) {
                HistogramElement e = (HistogramElement)this.displayList.elementAt(index);
                this.histModel.setSelection(e.obsNo, true);
            }
        }
    }

    public String getToolTipText(int mouseX, int mouseY) {
        if (!this.visible) {
            return null;
        }
        String desc = null;
        int index = this.getIndexOfDisplayList(mouseX, mouseY);
        if (index >= 0) {
            HistogramElement e = (HistogramElement)this.displayList.elementAt(index);
            Object xObj = this.dataOut.getValue(this.xVariable, e.obsNo);
            Object yObj = this.isData2D ? this.dataOut.getValue(this.yVariable, e.obsNo) : null;
            Object cObj = this.dataOut.getValue(this.colorVariable, e.obsNo);
            Object tObj = this.dataOut.getValue(this.tipVariable, e.obsNo);
            Object gObj = this.isData2D ? null : this.dataOut.getValue(this.groupVariable, e.obsNo);
            desc = this.getDescription(xObj, yObj, cObj, tObj, gObj);
        }
        return desc;
    }

    private int getIndexOfDisplayList(int mouseX, int mouseY) {
        if (this.redraw) {
            return -1;
        }
        int size = this.displayList.size();
        int index = -1;
        for (int i = 0; i < size; ++i) {
            HistogramElement e = (HistogramElement)this.displayList.elementAt(i);
            if (!(e.element instanceof Rectangle2D.Double) || e.projectedRect == null || !e.projectedRect.contains(mouseX, mouseY)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public boolean create(Object createData) {
        return true;
    }

    @Override
    public boolean isRebuildRequired() {
        return this.rebuildRequired;
    }

    @Override
    public boolean build(Object buildData) {
        if (!this.rebuildRequired) {
            return true;
        }
        this.displayList.removeAllElements();
        this.selectionList.removeAllElements();
        this.selectedValues = this.histModel.getSelectedValues();
        boolean rc = this.isData2D ? this.buildChart_2d() : this.buildChart_1d();
        this.rebuildRequired = false;
        this.dataChanged = false;
        this.redraw = true;
        return rc;
    }

    @Override
    public boolean buildAndDraw(Object buildData, Object drawContext, Object drawData) {
        boolean status = this.build(buildData);
        this.draw(drawContext, false);
        return status;
    }

    @Override
    public long getMasks() {
        return 0L;
    }

    @Override
    public long setMasks(long mask, long bits) {
        return 0L;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean viz) {
        this.visible = viz;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Object getOpacityValue() {
        return new Double(this.opacity);
    }

    @Override
    public boolean setOpacityValue(Object newOpacity) {
        if (newOpacity == null || !(newOpacity instanceof Number)) {
            return false;
        }
        double newValue = ((Number)newOpacity).doubleValue();
        if (newValue < 0.0 || newValue > 1.0) {
            return false;
        }
        if (newValue != this.opacity) {
            this.opacity = newValue;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
        return true;
    }

    @Override
    public void draw(Object p, boolean callHighlightDraw) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        Graphics2D g = this.graphics2D = (Graphics2D)p;
        Composite comp = g.getComposite();
        if (this.opacity < 1.0) {
            AlphaComposite alphaComp = AlphaComposite.getInstance(3, (float)this.opacity);
            g.setComposite(alphaComp);
        }
        int size = this.displayList.size();
        Color clr = g.getColor();
        for (int i = 0; i < size; ++i) {
            HistogramElement e = (HistogramElement)this.displayList.elementAt(i);
            if (e.element instanceof Color) {
                clr = !this.colorByChart || this.isData2D || this.histModel.isGroup() ? (Color)e.element : this.barColor;
                g.setColor(clr);
                continue;
            }
            if (!(e.element instanceof Rectangle2D.Double)) continue;
            Rectangle2D.Double rect2D = (Rectangle2D.Double)e.element;
            double xVal1 = rect2D.x;
            double xVal2 = rect2D.x + rect2D.width;
            double yVal1 = rect2D.y;
            double yVal2 = rect2D.y - rect2D.height;
            if (this.transObj.isReverse(0)) {
                xVal1 = rect2D.x + rect2D.width;
                xVal2 = rect2D.x;
            }
            if (this.transObj.isReverse(1)) {
                yVal1 = rect2D.y - rect2D.height;
                yVal2 = rect2D.y;
            }
            this.transObj.project(xVal1, yVal1, 0.0, this.scr1);
            this.transObj.project(xVal2, yVal2, 0.0, this.scr2);
            e.projectedRect = new Rectangle2D.Double(this.scr1[0], this.scr1[1], Math.max(1.0, this.scr2[0] - this.scr1[0]), this.scr2[1] - this.scr1[1]);
            double midPt = xVal1 + (xVal2 - xVal1) / 2.0;
            boolean outlier = false;
            if (!this.histModel.isBivariateHistogram() && this.xMinMaxSet && (midPt < this.xAxisMin || midPt > this.xAxisMax)) {
                outlier = true;
            }
            if (!outlier) {
                if (e.description == null) {
                    if (!this.histModel.isBivariateHistogram() && this.gradient) {
                        GradientPaint gp = new GradientPaint((float)((this.scr2[0] - this.scr1[0]) / 2.0), (float)this.scr1[1], ColorUtilities.brighter(clr, 0.2), (float)((this.scr2[0] - this.scr1[0]) / 2.0), (float)this.scr2[1], clr);
                        g.setPaint(gp);
                    }
                    g.fillRect((int)Math.round(this.scr1[0]), (int)Math.round(this.scr1[1]), (int)Math.round(Math.max(1.0, this.scr2[0] - this.scr1[0])), (int)Math.round(this.scr2[1] - this.scr1[1]));
                    if (!this.outlineOn || !(e.projectedRect.getWidth() > 2.0) || !(e.projectedRect.getHeight() > 2.0) && this.isData2D) continue;
                    g.setColor(this.outlineColor);
                    g.draw(e.projectedRect);
                    continue;
                }
                Stroke oldStroke = g.getStroke();
                g.setStroke(new BasicStroke(2.0f));
                g.drawLine((int)this.scr1[0], (int)this.scr2[1], (int)this.scr1[0], (int)this.scr1[1]);
                g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr1[1]);
                g.drawLine((int)this.scr2[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
                g.drawLine((int)this.scr1[0], (int)this.scr2[1], (int)this.scr2[0], (int)this.scr2[1]);
                g.setStroke(oldStroke);
                continue;
            }
            g.setColor(this.outlineColor);
            g.draw(e.projectedRect);
        }
        if (this.chartBorderOn) {
            if (this.histModel.isGroup()) {
                g.setColor(this.groupColor);
            } else {
                g.setColor(this.chartBorderColor);
            }
            this.transObj.project(this.xMin, this.yMin, 0.0, this.scr1);
            this.transObj.project(this.xMax, this.yMax, 0.0, this.scr2);
            g.drawRect((int)this.scr1[0], (int)this.scr2[1], (int)(this.scr2[0] - this.scr1[0]), (int)(this.scr1[1] - this.scr2[1]));
        }
        if (this.histModel.isDensitySet()) {
            Map densityNames = this.histModel.getDensityNames();
            Object[] nm = densityNames != null ? densityNames.keySet().toArray() : null;
            int size1 = this.histModel.getDensityNames().size();
            if (this.densityCurveLine == null) {
                this.densityCurveLine = new LineAttrib();
            }
            if (size1 > 1) {
                g.setColor(this.densityCurveLine.getColor());
                Stroke oldStroke = g.getStroke();
                g.setStroke(new BasicStroke(this.densityCurveLine.getWidth()));
                for (int i = 0; i < size1 - 1; ++i) {
                    Object nmi = nm[i];
                    this.transObj.project(((double[])nmi)[0], ((double[])nmi)[1], 0.0, this.scr1);
                    nmi = nm[i + 1];
                    this.transObj.project(((double[])nmi)[0], ((double[])nmi)[1], 0.0, this.scr2);
                    g.drawLine((int)this.scr1[0], (int)this.scr1[1], (int)this.scr2[0], (int)this.scr2[1]);
                }
                g.setStroke(oldStroke);
            }
        }
        double[] ends = this.yAxis.getMinMaxTickMarkValues();
        if (!this.histModel.isBivariateHistogram() && ends[0] < 0.0) {
            Object obj = null;
            this.transObj.project(this.xMin, 0.0, 0.0, this.scr1);
            this.transObj.project(this.xMax, 0.0, 0.0, this.scr2);
            obj = this.xAxis.getPropertyValue(201);
            Line2D.Double line = new Line2D.Double(this.scr1[0], this.scr1[1], this.scr2[0], this.scr2[1]);
            g.setColor(obj instanceof Color ? (Color)obj : Color.black);
            g.draw(line);
        }
        if (callHighlightDraw) {
            this.drawHighlight(p);
        }
        g.setComposite(comp);
        this.redraw = false;
    }

    @Override
    public void drawHighlight(Object p) {
        if (p == null || !(p instanceof Graphics2D) || this.transObj == null || !this.visible) {
            return;
        }
        if (this.displayList == null) {
            return;
        }
        if (this.histModel != null && this.histModel.isGroup()) {
            return;
        }
        Graphics2D g = this.graphics2D = (Graphics2D)p;
        Stroke oldStroke = g.getStroke();
        g.setStroke(new BasicStroke(2.0f));
        int size = this.selectionList.size();
        TexturePaint tp = null;
        if (!this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
            FillPattern fillPattern = new FillPattern();
            tp = fillPattern.getHatch45(this.selectionColor);
        }
        for (int i = 0; i < size; ++i) {
            int index = (Integer)((Object[])this.selectionList.elementAt(i))[0];
            double percent = (Double)((Object[])this.selectionList.elementAt(i))[1];
            HistogramElement e = (HistogramElement)this.displayList.elementAt(index);
            if (e.projectedRect == null) continue;
            double x = e.projectedRect.getX();
            double y = e.projectedRect.getY() + e.projectedRect.getHeight() * (1.0 - percent);
            double w = e.projectedRect.getWidth();
            double h = e.projectedRect.getHeight() * percent;
            Rectangle2D.Double highlightedRect = new Rectangle2D.Double(x, y, w, h);
            g.setColor(this.selectionColor);
            if (this.globalDefaults.selectionStyle.equalsIgnoreCase("Solid")) {
                g.fill(highlightedRect);
                if (!this.outlineOn || !(e.projectedRect.getWidth() > 2.0) || !(e.projectedRect.getHeight() > 2.0) && this.isData2D) continue;
                g.setColor(this.outlineColor);
                g.draw(e.projectedRect);
                continue;
            }
            g.setPaint(tp);
            g.fill(highlightedRect);
            g.setPaint(this.selectionColor);
            g.draw(highlightedRect);
        }
        g.setStroke(oldStroke);
    }

    public Object getDataSource() {
        if (this.dataIn == null) {
            return null;
        }
        return this.dataIn.getSource();
    }

    public Object getDataSource(Object id) {
        return null;
    }

    public Object[] getDataIds() {
        return null;
    }

    public boolean setDataSource(Object source, Object id) {
        if (source == null && !(source instanceof DataFilterReadInterface)) {
            return false;
        }
        if (id == null) {
            this.dataIn = (DataFilterReadInterface)source;
        }
        if (this.histModel == null) {
            this.histModel = new HistogramModel();
        }
        if (this.histModel != null) {
            this.histModel.setDataSource(source, id);
            this.dataOut = null;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.resetLegendFormat(null);
        if (this.xAxis != null) {
            this.xAxis.setRangeMinSet(false);
            this.xAxis.setRangeMaxSet(false);
        }
        if (this.yAxis != null) {
            this.yAxis.setRangeMinSet(false);
            this.yAxis.setRangeMaxSet(false);
        }
        return true;
    }

    public boolean setDataSource(Object source) {
        return this.setDataSource(source, null);
    }

    @Override
    public Object getAllVariables(Object role) {
        return this.getVariable(role);
    }

    @Override
    public Object getVariable(Object role) {
        if (this.histModel == null) {
            return null;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatisticObject();
        }
        return this.histModel.getVariable(role);
    }

    @Override
    public Object getRole(Object variableId) {
        if (this.histModel == null) {
            return null;
        }
        if (variableId instanceof Number) {
            if (this.isData2D) {
                return ((Number)variableId).intValue() == -3 ? "X" : (((Number)variableId).intValue() == -4 ? "Y" : null);
            }
            return ((Number)variableId).intValue() == -3 ? "X" : (((Number)variableId).intValue() == -4 ? "Response" : null);
        }
        return this.histModel.getRole(variableId);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (this.histModel == null || role == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            this.setStatistic(variableId.toString());
            this.histModel.setMaximumResponse(Double.NaN);
            this.histModel.setMinimumResponse(Double.NaN);
            return true;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.resetLegendFormat(role);
        boolean rc = this.histModel.setRole(variableId, role);
        if (this.histModel.isRoleYChanged()) {
            Object yVar = this.histModel.getVariable("Y");
            if (yVar == null) {
                if (this.xAxis != null) {
                    this.xAxis.setGridLines(Boolean.FALSE);
                }
            } else if (this.xAxis != null) {
                this.xAxis.setGridLines(Boolean.TRUE);
            }
        }
        return rc;
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (this.histModel == null || role == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            this.setStatistic(variableId.toString());
            this.histModel.setMaximumResponse(Double.NaN);
            this.histModel.setMinimumResponse(Double.NaN);
            return true;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.resetLegendFormat(role);
        return this.histModel.addRole(variableId, role);
    }

    @Override
    public boolean removeRole(Object variableId, Object role) {
        if (this.histModel == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.resetLegendFormat(role);
        return this.histModel.removeRole(variableId, role);
    }

    @Override
    public boolean isDiscrete(Object role) {
        if (this.histModel == null) {
            return false;
        }
        return this.histModel.isDiscrete(role);
    }

    @Override
    public boolean setDiscrete(Object role, boolean discrete) {
        if (this.histModel == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.resetLegendFormat(role);
        if (role != null && role instanceof String) {
            if (((String)role).equalsIgnoreCase("X")) {
                this.userSetProperties.set(812);
            } else if (((String)role).equalsIgnoreCase("Y")) {
                this.userSetProperties.set(813);
            }
        }
        return this.histModel.setDiscrete(role, discrete);
    }

    @Override
    public Object getRoleValue(Object role, int which) {
        if (this.histModel == null) {
            return null;
        }
        return this.histModel.getRoleValue(role, which);
    }

    @Override
    public Object[] getSupportedRoles(Object id, boolean discrete) {
        Object[] rolesObj = discrete ? new Object[]{this.roles.getRoleObject("ROLE_X"), this.roles.getRoleObject("ROLE_Y"), this.roles.getRoleObject("ROLE_FREQUENCY"), this.roles.getRoleObject("ROLE_RESPONSE"), this.roles.getRoleObject("ROLE_TIP"), this.roles.getRoleObject("ROLE_GROUP"), this.roles.getRoleObject("ROLE_COLOR_INDEX")} : new Object[]{this.roles.getRoleObject("ROLE_FREQUENCY"), this.roles.getRoleObject("ROLE_RESPONSE"), this.roles.getRoleObject("ROLE_COLOR_INDEX")};
        return rolesObj;
    }

    @Override
    public int getMaxAllowed(Object role) {
        return 1;
    }

    @Override
    public Object getSortOrder(Object role) {
        if (this.histModel == null || role == null) {
            return null;
        }
        return this.histModel.getSortOrder(role);
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (this.histModel == null || order == null || role == null) {
            return false;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        if (role instanceof Number) {
            if (((Number)role).intValue() == 24) {
                this.userSetProperties.set(815);
            } else if (((Number)role).intValue() == 25) {
                this.userSetProperties.set(815);
            }
        }
        return this.histModel.setSortOrder(role, order);
    }

    @Override
    public void addRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public void removeRoleListener(RoleListenerInterface listener) {
    }

    @Override
    public Object getLimit(Object role) {
        return null;
    }

    @Override
    public boolean setLimit(Object role, Object value) {
        return false;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.histModel == null) {
            return null;
        }
        return this.histModel.getSupportedSortableRoles();
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (this.histModel == null || role == null) {
            return null;
        }
        return this.histModel.getSupportedSortDirections(role);
    }

    @Override
    public boolean requiresMultipleRoleAssignments() {
        return false;
    }

    @Override
    public Object getTransformObject() {
        return this.transObj;
    }

    @Override
    public boolean setTransformObject(Object transIn) {
        if (transIn == null || !(transIn instanceof TransformInterface)) {
            return false;
        }
        this.transObj = (TransformInterface)transIn;
        return true;
    }

    @Override
    public double[] getBoundingBox() {
        if (!this.dataChanged) {
            return this.chartBBox;
        }
        if (!this.prepareChartData()) {
            return null;
        }
        if (this.histModel.isZeroObservation()) {
            this.yMin = 0.0;
            this.xMin = 0.0;
            this.yMax = 1.0;
            this.xMax = 1.0;
            this.chartBBox[0] = this.xMin;
            this.chartBBox[1] = this.yMin;
            this.chartBBox[2] = 0.0;
            this.chartBBox[3] = this.xMax;
            this.chartBBox[4] = this.yMax;
            this.chartBBox[5] = 0.0;
            return this.chartBBox;
        }
        if (!this.dataIn.isNumericVariable(this.getVariable("X")) || this.oneObsX) {
            this.xMin = 0.0;
            this.xMax = this.histModel.getNumberXBins();
            if (this.missingBin) {
                this.xMax += 1.0;
            }
        } else if (this.isDiscrete("X")) {
            if (((Number)this.getSortOrder(new Integer(24))).intValue() == 1 && this.isOrdinal(this.histModel.getXBinNames()) && !this.histModel.isBivariateHistogram() && (this.xMinMaxSet || this.intervalAxis || this.scaledSpacingX)) {
                this.xMin = this.xMinD;
                this.xMax = this.xMaxD;
                if (this.missingBin) {
                    this.xMin -= this.xBinWidth;
                }
            } else {
                this.xMin = 0.0;
                this.xMax = this.histModel.getNumberXBins();
                if (this.missingBin) {
                    this.xMax += 1.0;
                }
            }
        } else {
            this.xMin = this.xMinD;
            this.xMax = this.xMaxD;
            if (this.missingBin) {
                this.xMin -= this.xBinWidth;
            }
        }
        if (!this.histModel.isBivariateHistogram()) {
            double[] ends = this.yAxis.getMinMaxTickMarkValues();
            if (ends[0] == ends[1]) {
                ends[1] = ends[1] + 1.0;
            }
            this.yMin = ends[0] < 0.0 ? ends[0] - 0.02 * (ends[1] - ends[0]) : ends[0];
            this.yMax = ends[1] + 0.02 * (ends[1] - ends[0]);
        } else {
            if (this.isDiscrete("Y") || !this.dataIn.isNumericVariable(this.getVariable("Y")) || this.oneObsY) {
                this.yMin = 0.0;
                this.yMax = this.histModel.getNumberYBins();
                if (this.missingBin) {
                    this.yMax += 1.0;
                }
            } else {
                this.yMin = this.yMinD;
                this.yMax = this.yMaxD;
                if (this.missingBin) {
                    this.yMin -= this.yBinWidth;
                }
            }
            this.respTickmarkOffset = 0.0;
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = 0.0;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = 0.0;
        return this.chartBBox;
    }

    @Override
    public boolean setBoundingBox(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.xMin = xmin;
        this.xMax = xmax;
        this.yMax = ymax;
        if (this.isData2D || this.fixedDataRange) {
            this.yMin = ymin;
        } else if (!this.fixedDataRange) {
            double[] ends = new double[2];
            ends = this.yAxis.getMinMaxTickMarkValues();
            if (ends[0] == ends[1]) {
                ends[1] = ends[1] + 1.0;
            }
            this.yMin = ends[0];
            this.yMax = ends[1];
        }
        this.chartBBox[0] = this.xMin;
        this.chartBBox[1] = this.yMin;
        this.chartBBox[2] = zmin;
        this.chartBBox[3] = this.xMax;
        this.chartBBox[4] = this.yMax;
        this.chartBBox[5] = zmax;
        boolean minMaxSet = false;
        if (!this.isDiscrete("X") && this.rebinOnZoom) {
            this.histModel.setMinimumData("X", this.xMin);
            this.histModel.setMaximumData("X", this.xMax);
            this.histModel.setMinimumResponse(this.histModel.getMinimumResponse());
            this.histModel.setMaximumResponse(this.histModel.getMaximumResponse());
            minMaxSet = true;
        }
        if (this.isData2D && !this.isDiscrete("Y") && this.rebinOnZoom) {
            this.histModel.setMinimumData("Y", this.yMin);
            this.histModel.setMaximumData("Y", this.yMax);
            minMaxSet = true;
        }
        if (minMaxSet) {
            this.rebuildRequired = true;
            this.dataPrepared = false;
            this.prepareChartData();
        }
        RedrawEvent e = new RedrawEvent(this);
        e.newBoundingBox = this.chartBBox;
        e.type = 2;
        this.fireRedrawEvent(e);
        return true;
    }

    @Override
    public Rectangle getScreenArea() {
        return null;
    }

    @Override
    public boolean setScreenArea(int xmin, int ymin, int width, int height) {
        return false;
    }

    public void dataFilterChanged(DvrDataFilterEvent evt) {
        int i;
        if (evt.source == this.dataOut) {
            if (evt.type == 1) {
                this.rebuildRequired = true;
                this.dataChanged = true;
                this.dataPrepared = false;
                this.prepareChartData();
                if (this.xAxis != null) {
                    this.xAxis.setRangeMinSet(false);
                    this.xAxis.setRangeMaxSet(false);
                }
                if (this.yAxis != null) {
                    this.yAxis.setRangeMinSet(false);
                    this.yAxis.setRangeMaxSet(false);
                }
            } else if (evt.type == 2) {
                this.selectedValues = this.histModel.getSelectedValues();
                ArrayList currSel = this.histModel.getCurrentSelectedObservations();
                int rows = currSel == null ? this.dataOut.getNumberObservations(-1) : currSel.size();
                if (currSel == null && this.histModel.isUnselectedAll()) {
                    this.selectionList.removeAllElements();
                    RedrawEvent e = new RedrawEvent(this);
                    e.type = 5;
                    this.fireRedrawEvent(e);
                    return;
                }
                for (int cs = 0; cs < rows; ++cs) {
                    int o = currSel == null ? cs : (Integer)currSel.get(cs);
                    double s = this.selectedValues[o];
                    double f = this.dataOut.getNumericValue((Object)"Frequency", (long)o);
                    int size = this.displayList.size();
                    int index = -1;
                    for (i = 0; i < size; ++i) {
                        HistogramElement e = (HistogramElement)this.displayList.elementAt(i);
                        if (!(e.element instanceof Rectangle2D.Double) || e.obsNo != (long)o) continue;
                        index = i;
                        break;
                    }
                    if (index < 0) continue;
                    Object[] tmp = new Object[]{new Integer(index), new Double(s / f)};
                    int idx = -1;
                    for (int i2 = 0; i2 < this.selectionList.size(); ++i2) {
                        if (index != (Integer)((Object[])this.selectionList.elementAt(i2))[0]) continue;
                        idx = i2;
                        break;
                    }
                    if (idx < 0 && s > 0.0) {
                        this.selectionList.addElement(tmp);
                        continue;
                    }
                    if (idx >= 0 && s > 0.0) {
                        this.selectionList.setElementAt(tmp, idx);
                        continue;
                    }
                    if (idx < 0 || s != 0.0) continue;
                    this.selectionList.removeElementAt(idx);
                }
                RedrawEvent e = new RedrawEvent(this);
                e.type = 5;
                this.fireRedrawEvent(e);
            }
        }
        if (evt.type == 7) {
            this.selectedValues = this.histModel.getSelectedValues();
            int rows = this.dataOut.getNumberObservations(-1);
            for (int o = 0; o < rows; ++o) {
                double s = this.selectedValues[o];
                double f = this.dataOut.getNumericValue((Object)"Frequency", (long)o);
                int size = this.displayList.size();
                int index = -1;
                for (int i3 = 0; i3 < size; ++i3) {
                    HistogramElement e = (HistogramElement)this.displayList.elementAt(i3);
                    if (!(e.element instanceof Rectangle2D.Double) || e.obsNo != (long)o) continue;
                    index = i3;
                    break;
                }
                if (index < 0) continue;
                Object[] tmp = new Object[]{new Integer(index), new Double(s / f)};
                int idx = -1;
                for (i = 0; i < this.selectionList.size(); ++i) {
                    if (index != (Integer)((Object[])this.selectionList.elementAt(i))[0]) continue;
                    idx = i;
                    break;
                }
                if (idx < 0 && s > 0.0) {
                    this.selectionList.addElement(tmp);
                    continue;
                }
                if (idx >= 0 && s > 0.0) {
                    this.selectionList.setElementAt(tmp, idx);
                    continue;
                }
                if (idx < 0 || s != 0.0) continue;
                this.selectionList.removeElementAt(idx);
            }
            RedrawEvent e = new RedrawEvent(this);
            e.type = 5;
            this.fireRedrawEvent(e);
        }
    }

    @Override
    public HistogramModel getHistogramModel() {
        return this.histModel;
    }

    @Override
    public int getNumberXBins() {
        if (this.histModel == null) {
            return -1;
        }
        return this.histModel.getNumberXBins();
    }

    @Override
    public void setNumberXBins(int num) {
        if (this.histModel == null) {
            return;
        }
        if (num <= 0) {
            return;
        }
        this.histModel.setNumberXBins(num);
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public int getNumberYBins() {
        if (this.histModel == null) {
            return -1;
        }
        return this.histModel.getNumberYBins();
    }

    @Override
    public void setNumberYBins(int num) {
        if (this.histModel == null) {
            return;
        }
        if (num <= 0) {
            return;
        }
        this.histModel.setNumberYBins(num);
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public String getStatistic() {
        return statName[this.statistic2].toString();
    }

    public SILKNumber getStatisticObject() {
        return statName[this.statistic2];
    }

    @Override
    public void setStatistic(String type) {
        if (type == null) {
            return;
        }
        boolean valid = false;
        for (int i = 0; i < statName.length; ++i) {
            if (!statName[i].toString().equalsIgnoreCase(type) && !statName[i].getEnglishName().equalsIgnoreCase(type)) continue;
            this.statistic = i;
            valid = true;
            break;
        }
        if (valid) {
            this.rebuildRequired = true;
            this.dataChanged = true;
            this.dataPrepared = false;
            this.fireRedrawEvent(new RedrawEvent(this));
        }
    }

    @Override
    public ColorInterface getColorRamp() {
        return this.colorRamp;
    }

    @Override
    public void setColorRamp(ColorInterface ramp) {
        this.colorRamp = ramp;
        this.rebuildRequired = true;
        if (this.legend != null) {
            Color[] colors = this.colorRamp.getColors();
            if (colors != null && this.legendValues != null && colors.length != this.legendValues.length) {
                this.legendValues = colors != null && colors.length == 3 ? new Object[3] : new Object[2];
                double d1 = 0.0;
                double d2 = 0.0;
                if (this.density) {
                    d1 = this.cMin / this.totalCount;
                    d2 = this.cMax / this.totalCount;
                } else if (this.statistic2 == 4) {
                    d1 = this.cMin * 100.0 / this.totalCount;
                    d2 = this.cMax * 100.0 / this.totalCount;
                } else {
                    d1 = this.cMin;
                    d2 = this.cMax;
                }
                this.legendValues[0] = new Double(d1);
                if (this.legendValues.length == 2) {
                    this.legendValues[1] = new Double(d2);
                } else {
                    this.legendValues[1] = new Double((d1 + d2) / 2.0);
                    this.legendValues[2] = new Double(d2);
                }
            }
            this.legend.setValues(colors, null, this.legendValues, null, true);
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public double getBarScaleFactor() {
        return this.scaleFactor;
    }

    @Override
    public void setBarScaleFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.scaleFactor = fac;
        this.rebuildRequired = true;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public boolean isFixedDataRange() {
        return this.fixedDataRange;
    }

    @Override
    public void setFixedDataRange(boolean fixed) {
        this.fixedDataRange = fixed;
    }

    @Override
    public boolean isDisplayMissingBin() {
        return this.missingBin;
    }

    @Override
    public void setDisplayMissingBin(boolean show) {
        this.missingBin = show;
        this.dataChanged = true;
        this.rebuildRequired = true;
        this.dataPrepared = false;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color getSelectionColor() {
        return this.selectionColor;
    }

    @Override
    public void setSelectionColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.selectionColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.selectionColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color getOutlineColor() {
        return this.outlineColor;
    }

    @Override
    public void setOutlineColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.outlineColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.outlineColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public boolean isOutlineOn() {
        return this.outlineOn;
    }

    @Override
    public void setOutlineOn(boolean on) {
        this.outlineOn = on;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color getChartBorderColor() {
        return this.chartBorderColor;
    }

    @Override
    public void setChartBorderColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartBorderColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartBorderColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public boolean isChartBorderOn() {
        return this.chartBorderOn;
    }

    @Override
    public void setChartBorderOn(boolean on) {
        this.chartBorderOn = on;
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public Color getChartWallColor() {
        return this.chartWallColor;
    }

    public void setChartWallColor(Object c) {
        if (c == null) {
            return;
        }
        if (c instanceof Color) {
            this.chartWallColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.chartWallColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public Color getBarColor() {
        return this.barColor;
    }

    @Override
    public void setBarColor(Object c) {
        if (c == null) {
            this.colorByChart = false;
        } else if (c instanceof Color) {
            this.barColor = (Color)c;
        } else if (c instanceof String) {
            Color col = ColorParse.getColorFromString((String)((String)c));
            if (col == null) {
                return;
            }
            this.barColor = col;
        }
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public void setColorByChart(boolean byChart) {
        this.colorByChart = byChart;
        this.userSetProperties.set(808);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    @Override
    public void setColorByStat(boolean byStat) {
        this.colorByChart = !byStat;
        this.userSetProperties.set(820);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    protected void fireRedrawEvent(RedrawEvent e) {
        block4: for (int i = 0; i < this.redrawListener.size(); ++i) {
            RedrawListener listener = (RedrawListener)this.redrawListener.elementAt(i);
            if (listener == null) continue;
            switch (e.type) {
                default: {
                    listener.redraw(e);
                    continue block4;
                }
                case 2: {
                    listener.boundingBoxChanged(e);
                    listener.outerMarginChanged(e);
                    continue block4;
                }
                case 3: {
                    listener.outerMarginChanged(e);
                }
            }
        }
    }

    public void addRedrawListener(RedrawListener listener) {
        if (!this.redrawListener.contains(listener)) {
            this.redrawListener.addElement(listener);
        }
    }

    public void removeRedrawListener(RedrawListener listener) {
        if (this.redrawListener.contains(listener)) {
            this.redrawListener.removeElement(listener);
        }
    }

    public Object getPropertyValue(int idx) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            return this.propertyValue.elementAt(i);
        }
        switch (idx) {
            case 801: {
                return this.barColor;
            }
            case 802: {
                return this.outlineColor;
            }
            case 803: {
                return new Boolean(this.outlineOn);
            }
            case 804: {
                return new Double(this.scaleFactor);
            }
            case 805: {
                return new Integer(this.getNumberXBins());
            }
            case 806: {
                return new Integer(this.getNumberYBins());
            }
            case 807: {
                return new Boolean(this.missingBin);
            }
            case 808: {
                return new Boolean(this.colorByChart);
            }
            case 820: {
                return new Boolean(!this.colorByChart);
            }
            case 809: {
                boolean byScheme = this.histModel.isBivariateHistogram();
                return new Boolean(byScheme);
            }
            case 810: {
                HashMap binNames;
                boolean fix;
                if (this.histModel == null) {
                    return new Boolean(true);
                }
                boolean bl = fix = this.isDiscrete("X") || !this.dataIn.isNumericVariable(this.getVariable("X"));
                if (!fix && ((binNames = this.histModel.getXBinNames()) == null || binNames.size() == 1 && !(binNames.keySet().iterator().next() instanceof double[]))) {
                    fix = true;
                }
                return new Boolean(fix);
            }
            case 811: {
                HashMap binNames;
                boolean fix;
                if (this.histModel == null) {
                    return new Boolean(true);
                }
                boolean bl = fix = this.isDiscrete("Y") || !this.dataIn.isNumericVariable(this.getVariable("Y"));
                if (!fix && ((binNames = this.histModel.getYBinNames()) == null || binNames.size() == 1 && !(binNames.keySet().iterator().next() instanceof double[]))) {
                    fix = true;
                }
                return new Boolean(fix);
            }
            case 812: {
                return new Boolean(this.isDiscrete("X"));
            }
            case 813: {
                return new Boolean(this.isDiscrete("Y"));
            }
            case 814: {
                return this.getSortOrder(new Integer(24));
            }
            case 815: {
                return this.getSortOrder(new Integer(25));
            }
            case 816: {
                return new Boolean(this.dataIn.isNumericVariable(this.getVariable("X")));
            }
            case 817: {
                return new Boolean(this.dataIn.isNumericVariable(this.getVariable("Y")));
            }
            case 818: {
                return new Boolean(this.rebinOnZoom);
            }
            case 819: {
                return new Boolean(this.gradient);
            }
            case 821: {
                return new Boolean(this.intervalAxis);
            }
            case 822: {
                return new Boolean(this.scaledSpacingX);
            }
        }
        return null;
    }

    public boolean setPropertyValue(int idx, Object value) {
        int i = this.propertyIndex.indexOf(new Integer(idx));
        if (i >= 0) {
            this.propertyValue.setElementAt(value, i);
        } else {
            this.propertyIndex.addElement(new Integer(idx));
            this.propertyValue.addElement(value);
        }
        return true;
    }

    public int getNumberProperties() {
        return 37;
    }

    public boolean applyPropertyChanges() {
        if (this.propertyIndex.size() <= 0) {
            return false;
        }
        block19: for (int i = 0; i < this.propertyIndex.size(); ++i) {
            int idx = (Integer)this.propertyIndex.elementAt(i);
            Object value = this.propertyValue.elementAt(i);
            switch (idx) {
                case 821: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.intervalAxis = (Boolean)value;
                    this.userSetProperties.set(821);
                    this.rebuildRequired = true;
                    this.dataChanged = true;
                    this.dataPrepared = false;
                    continue block19;
                }
                case 822: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.scaledSpacingX = (Boolean)value;
                    this.userSetProperties.set(822);
                    this.rebuildRequired = true;
                    this.dataChanged = true;
                    this.dataPrepared = false;
                    continue block19;
                }
                case 801: {
                    if (value != null && !(value instanceof Color)) continue block19;
                    this.barColor = (Color)value;
                    this.userSetProperties.set(801);
                    continue block19;
                }
                case 802: {
                    if (!(value instanceof Color)) continue block19;
                    this.outlineColor = (Color)value;
                    this.userSetProperties.set(802);
                    continue block19;
                }
                case 803: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.outlineOn = (Boolean)value;
                    this.userSetProperties.set(803);
                    continue block19;
                }
                case 804: {
                    if (!(value instanceof Number)) continue block19;
                    this.scaleFactor = ((Number)value).doubleValue();
                    this.userSetProperties.set(804);
                    this.rebuildRequired = true;
                    continue block19;
                }
                case 805: {
                    if (!(value instanceof Number)) continue block19;
                    this.histModel.setNumberXBins(((Number)value).intValue());
                    this.userSetProperties.set(805);
                    this.rebuildRequired = true;
                    this.dataChanged = true;
                    this.dataPrepared = false;
                    continue block19;
                }
                case 806: {
                    if (!(value instanceof Number)) continue block19;
                    this.histModel.setNumberYBins(((Number)value).intValue());
                    this.userSetProperties.set(806);
                    this.rebuildRequired = true;
                    this.dataChanged = true;
                    this.dataPrepared = false;
                    continue block19;
                }
                case 807: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.missingBin = (Boolean)value;
                    this.userSetProperties.set(807);
                    this.rebuildRequired = true;
                    this.dataChanged = true;
                    this.dataPrepared = false;
                    continue block19;
                }
                case 808: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.colorByChart = (Boolean)value;
                    this.userSetProperties.set(808);
                    continue block19;
                }
                case 820: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.colorByChart = (Boolean)value == false;
                    this.userSetProperties.set(820);
                    continue block19;
                }
                case 812: {
                    this.setDiscrete("X", (Boolean)value);
                    continue block19;
                }
                case 813: {
                    this.setDiscrete("Y", (Boolean)value);
                    continue block19;
                }
                case 814: {
                    this.setSortOrder(new Integer(24), value);
                    continue block19;
                }
                case 815: {
                    this.setSortOrder(new Integer(25), value);
                    continue block19;
                }
                case 818: {
                    this.setRebinOnZoom((Boolean)value);
                    if (!this.rebinOnZoom) {
                        this.histModel.setMinimumData("X", Double.NaN);
                        this.histModel.setMaximumData("X", Double.NaN);
                        if (this.histModel.isBivariateHistogram()) {
                            this.histModel.setMinimumData("Y", Double.NaN);
                            this.histModel.setMaximumData("Y", Double.NaN);
                        }
                    }
                    this.rebuildRequired = true;
                    this.dataPrepared = false;
                    continue block19;
                }
                case 819: {
                    if (!(value instanceof Boolean)) continue block19;
                    this.setGradientOn((Boolean)value);
                    continue block19;
                }
            }
        }
        this.fireRedrawEvent(new RedrawEvent(this));
        this.propertyIndex.removeAllElements();
        this.propertyValue.removeAllElements();
        return true;
    }

    public boolean applyPropertyChanges(Object source) {
        return true;
    }

    public void cancelPropertyChanges() {
        this.propertyIndex.removeAllElements();
        this.propertyValue.removeAllElements();
    }

    public void cancelPropertyChanges(Object source) {
    }

    public int[] getPendingChanges() {
        int[] index = new int[this.propertyIndex.size()];
        for (int i = 0; i < this.propertyIndex.size(); ++i) {
            index[i] = (Integer)this.propertyIndex.elementAt(i);
        }
        return index;
    }

    public int[] getPendingChanges(Object source) {
        int[] index = new int[this.propertyIndex.size()];
        return index;
    }

    public boolean isPropertySupported(int idx) {
        switch (idx) {
            case 801: 
            case 802: 
            case 803: 
            case 804: 
            case 805: 
            case 806: 
            case 807: 
            case 808: 
            case 809: 
            case 810: 
            case 811: 
            case 812: 
            case 813: 
            case 814: 
            case 815: 
            case 816: 
            case 817: 
            case 818: 
            case 819: 
            case 820: 
            case 821: 
            case 822: {
                return true;
            }
        }
        return false;
    }

    public boolean isPropertyPending(int idx) {
        return false;
    }

    public int getNumberPendingProperties() {
        return -1;
    }

    public boolean hasUserSetValue(int id) {
        return this.userSetProperties.get(id);
    }

    @Override
    public void addDataListener() {
        if (this.dataOut != null) {
            this.dataOut.addDataFilterListener((Object)this);
        }
        this.dataIn.addDataFilterListener((Object)this.histModel);
    }

    @Override
    public void removeDataListener() {
        if (this.dataOut != null) {
            this.dataOut.removeDataFilterListener((Object)this);
        }
        this.dataIn.removeDataFilterListener((Object)this.histModel);
    }

    @Override
    public boolean supportsMultipleAssignments(Object role) {
        return false;
    }

    private String buildAxisLabel(boolean xAxis, Object variableId) {
        String axisLabel;
        Message statMessage = new Message(ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.StatisticType.fmt.txt", (String)"{0}({1})"));
        if (xAxis) {
            axisLabel = (String)this.histModel.getVariableDescription("X");
        } else if (this.histModel.isBivariateHistogram()) {
            axisLabel = (String)this.histModel.getVariableDescription("Y");
        } else {
            if (this.histModel.isShowDensity()) {
                String axisLabel2 = ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Density.txt", (String)"Density");
                return axisLabel2;
            }
            String ss = (String)this.histModel.getVariable("STAT");
            axisLabel = ss == null ? ((ss = (String)this.histModel.getVariable("FREQ")) == null ? (this.statistic2 == 4 ? (String)this.getNLSName("Percent") : (String)this.getNLSName(variableId)) : (String)this.histModel.getVariableDescription("FREQ")) : (this.histModel.isSummarized() ? statMessage.toString((Object)((String)this.histModel.getVariableDescription("STAT")), this.getNLSName(variableId)) : (String)this.histModel.getVariableDescription("STAT"));
        }
        return axisLabel;
    }

    public void setDataPrepare(boolean flag) {
        this.dataPrepared = flag;
    }

    public void setDataChange() {
        this.rebuildRequired = true;
        this.dataChanged = true;
    }

    public void setDataPrepare() {
        this.rebuildRequired = true;
        this.dataPrepared = false;
    }

    protected void setMargins() {
        int halfBar;
        if (this.graphics2D == null) {
            return;
        }
        if (this.chartAreaDimension == null || this.chartAreaDimension.width < 0 || this.chartAreaDimension.height < 0) {
            return;
        }
        int leftx = (int)((double)this.xAxis.getValueWidth(this.graphics2D, -1) * 0.5);
        int lefty = this.yAxis.getLeftWidth(this.graphics2D);
        int top1 = 0;
        int top2 = this.xAxis.getRangeSliderThumbSize();
        int top = this.xAxis.getTopHeight(this.graphics2D);
        int right_rl = this.yAxis.getReferenceLineLabelWidth(this.graphics2D);
        int top_rl = this.xAxis.getReferenceLineLabelHeight(this.graphics2D);
        int bottom = 0;
        int right = 0;
        for (int i = 0; i < 2; ++i) {
            right = Math.max(right, right_rl);
            int axisLen = this.chartAreaDimension.width - right - Math.max(leftx, lefty);
            this.xAxis.setAxisLength(axisLen);
            bottom = this.xAxis.getBottomHeight(this.graphics2D);
            right = (int)((double)this.xAxis.getTickMarkValueWidth(this.graphics2D, -1, true) * 0.5);
            this.xOffset[1] = 0.0;
            this.xOffset[0] = 0.0;
            if (this.isDiscrete("X") && (this.histModel.isBivariateHistogram() || !this.intervalAxis && !this.xMinMaxSet) || !this.dataIn.isNumericVariable(this.getVariable("X"))) {
                halfBar = (int)(0.5 * (double)axisLen / (double)this.numberOfVirtualBins);
                this.xOffset[0] = this.xOffset[1] = (double)halfBar;
                right -= halfBar;
                right = Math.max(0, right);
            }
            if (right == 0) break;
        }
        right = Math.max(right, right_rl);
        right += this.yAxis.getRangeSliderThumbSize();
        int axisLen = this.clipRect != null && this.clipRect.getHeight() > 0.0 ? (int)this.clipRect.getHeight() : this.chartAreaDimension.height - top - bottom;
        double[] ends = this.yAxis.getMinMaxTickMarkValues();
        if (this.transObj.isReverse(1)) {
            this.yOffset[1] = ends[0] < 0.0 ? 0.02 * (double)axisLen : 0.0;
            this.yOffset[0] = 0.02 * (double)axisLen;
        } else {
            this.yOffset[0] = ends[0] < 0.0 ? 0.02 * (double)axisLen : 0.0;
            this.yOffset[1] = 0.02 * (double)axisLen;
        }
        if (!this.histModel.isBivariateHistogram() || this.isDiscrete("Y") || !this.dataIn.isNumericVariable(this.getVariable("Y"))) {
            if (this.histModel.isBivariateHistogram() && (this.isDiscrete("Y") || !this.dataIn.isNumericVariable(this.getVariable("Y")))) {
                halfBar = (int)(0.5 * (double)axisLen / (double)this.histModel.getNumberYBins());
                this.yOffset[0] = this.yOffset[1] = (double)halfBar;
            } else {
                int n = (int)this.yOffset[1];
            }
        } else {
            this.yOffset[1] = 0.0;
            this.yOffset[0] = 0.0;
        }
        top = top1 + top2;
        top = Math.max(Math.max(top, top1), top_rl);
        this.outerMargin.left = Math.max(leftx, lefty);
        this.outerMargin.right = right;
        this.outerMargin.top = top;
        this.outerMargin.bottom = bottom;
        this.innerMargin.left = (int)this.xOffset[0];
        this.innerMargin.right = (int)this.xOffset[1];
        this.innerMargin.top = (int)this.yOffset[1];
        this.innerMargin.bottom = (int)this.yOffset[0];
    }

    public void setGraphicContent(Graphics2D g) {
        this.graphics2D = g;
    }

    public Object getNLSName(Object defaultName) {
        if (!(defaultName instanceof String)) {
            return defaultName;
        }
        String name = (String)defaultName;
        String NLSName = name.equalsIgnoreCase("Density") ? ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Density.txt", (String)"Density") : (name.equalsIgnoreCase("Frequency") ? (this.statistic2 == 4 ? ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Percent.txt", (String)"Percent") : ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Frequency.txt", (String)"Frequency")) : (name.equalsIgnoreCase("Percent") ? ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Percent.txt", (String)"Percent") : (name.equalsIgnoreCase("Sum") ? ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Sum.txt", (String)"Sum") : (name.equalsIgnoreCase("Mean") ? ResourceLoader.getResourceString((Object)this.rb, (String)"Histogram.Mean.txt", (String)"Mean") : name))));
        return NLSName;
    }

    @Override
    public void setResponseScaleToNonMissingOnly(boolean scaleToNonMissing) {
        if (this.histModel != null) {
            this.histModel.setResponseScaleToNonMissingOnly(scaleToNonMissing);
        }
    }

    private boolean isOrdinal(HashMap names) {
        return true;
    }

    public double getXBinWidth() {
        return this.xBinWidth;
    }

    public double getYBinWidth() {
        return this.yBinWidth;
    }

    public void setDensityCurveLine(LineAttrib lineAttrib) {
        this.densityCurveLine = lineAttrib;
    }

    public void setDensityCurveColor(Color color) {
        if (this.densityCurveLine == null) {
            this.densityCurveLine = new LineAttrib(color, 2);
        } else {
            this.densityCurveLine.setColor(color);
        }
    }

    public void setXAxisMinMax(double min, double max) {
        if (Double.isNaN(min) || Double.isNaN(max)) {
            this.xMinMaxSet = false;
            this.xAxisMin = Double.NaN;
            this.xAxisMax = Double.NaN;
        } else {
            this.xMinMaxSet = true;
            this.xAxisMin = min;
            this.xAxisMax = max;
        }
        this.rebuildRequired = true;
        this.dataChanged = true;
        this.dataPrepared = false;
    }

    public void setDataColor(Color[] color, Color[] lineClr) {
        this.dataColor = color;
        this.lineColor = lineClr;
        this.rebuildRequired = true;
        if (this.legend != null) {
            this.setGroupLegend();
        }
        RedrawEvent e = new RedrawEvent(this);
        e.type = 2;
        this.fireRedrawEvent(e);
    }

    public void setStyle(Style s) {
        this.style = s;
    }

    private void setGroupColorIndices() {
        Map groupNames;
        if (this.histModel != null && this.histModel.isGroup() && (groupNames = this.histModel.getGroupNames()) != null) {
            Object[] clrArray = groupNames.values().toArray();
            this.grpClrIndices = new int[clrArray.length];
            for (int i = 0; i < clrArray.length; ++i) {
                this.grpClrIndices[i] = ((Number)clrArray[i]).intValue();
            }
        }
    }

    private void setGroupLegend() {
        if (this.dataOut != null && this.histModel != null && this.histModel.isGroup()) {
            Object fmt;
            String title;
            String string = title = this.legend.getTitle() == null ? null : (String)this.legend.getTitle().getText();
            if (title == null || title.length() == 0) {
                title = (String)this.histModel.getVariableDescription("GROUP");
            }
            this.legend.setTitle(title);
            Object object = fmt = this.legend.getLabel() == null ? null : this.legend.getLabel().getFormat();
            if (fmt == null && ((fmt = this.dataOut.getFormat(this.groupVariable, null)) == null || fmt instanceof String && ((String)fmt).trim().equals("")) && this.dataIn.isNumericVariable(this.getVariable(this.groupVariable))) {
                fmt = this.globalDefaults == null ? "Best12" : this.globalDefaults.defaultNumericFormat;
            }
            this.legend.setLabel(fmt);
            this.legendValues = new Object[this.histModel.getGroupSize()];
            Map groupNames = this.histModel.getGroupNames();
            if (groupNames != null) {
                Object[] objArray = groupNames.keySet().toArray();
                for (int i = objArray.length - 1; i > -1; --i) {
                    if (!(objArray[i] instanceof String) || !objArray[i].equals("")) continue;
                    objArray[i] = ".";
                    i = -1;
                }
                Color[] colorArray = new Color[this.histModel.getGroupSize()];
                for (int i = 0; i < this.histModel.getGroupSize(); ++i) {
                    String fmtV = this.dataOut.getFormattedValue((Object)"Group", objArray[i], fmt);
                    this.legendValues[i] = fmtV;
                    if (this.grpClrIndices[i] == Integer.MAX_VALUE) {
                        colorArray[i] = this.colorRamp.getMissingColor();
                        continue;
                    }
                    String attrValueStr = this.legendValues[i].toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, this.grpClrIndices[i], 2, this.style, this.styleElement, null).getAsDataStyle();
                    if (i == 0) {
                        colorArray[0] = dse.getFillColor();
                        continue;
                    }
                    colorArray[i] = dse.getLineColor();
                }
                this.legend.setValues(colorArray, null, this.legendValues, null, false);
            }
        }
    }

    public HashMap getBinNames(String which) {
        HashMap binNames = null;
        HashMap clonedBinNames = null;
        if (this.histModel != null) {
            if (which.equalsIgnoreCase("X")) {
                binNames = this.histModel.getXBinNames();
            } else if (which.equalsIgnoreCase("Y")) {
                binNames = this.histModel.getYBinNames();
            }
            if (binNames != null) {
                clonedBinNames = (HashMap)binNames.clone();
            }
            if (clonedBinNames != null) {
                clonedBinNames.remove("");
            }
        }
        return clonedBinNames;
    }

    private void resetLegendFormat(Object role) {
        if (this.legend == null || this.legend.getLabel() == null) {
            return;
        }
        if (this.legend.getLabel().getFormat() == null) {
            return;
        }
        boolean reset = false;
        if (role == null) {
            reset = true;
        } else if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(HistogramModel.X_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            if (this.getVariable("Y") != null) {
                reset = true;
            }
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(HistogramModel.Y_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            reset = true;
        } else if (role instanceof Number && (((Number)role).intValue() == 17 || ((Number)role).intValue() == 38) || role instanceof String && (((String)role).equalsIgnoreCase("STAT") || ((String)role).equalsIgnoreCase("Response") || ((String)role).equalsIgnoreCase(HistogramModel.STAT_ROLE_NAME.toString()) || ((String)role).equalsIgnoreCase(HistogramModel.RESPONSE_ROLE_NAME.toString()))) {
            if (this.getVariable("Y") != null) {
                reset = true;
            }
        } else if (role instanceof Number && ((Number)role).intValue() == 6 || role instanceof String && ((String)role).equalsIgnoreCase(HistogramModel.GROUP_ROLE_NAME.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Group")) {
            if (this.getVariable("Y") == null) {
                reset = true;
            }
        } else {
            reset = false;
        }
        if (reset) {
            this.legend.getLabel().setFormat(null);
            if (this.legend.getTitle() != null) {
                this.legend.getTitle().setText("");
            }
        }
    }

    public void setRebinOnZoom(boolean rebin) {
        this.rebinOnZoom = rebin;
        this.userSetProperties.set(818);
    }

    private double getBinWidth(Object[] valueArray) {
        this.equalWidth_X = true;
        if (valueArray == null) {
            return 0.0;
        }
        if (valueArray[0] instanceof Number) {
            int size = valueArray.length - 2;
            if (size > 0) {
                double val = Double.MAX_VALUE;
                for (int i = 0; i < size; ++i) {
                    double currVal = ((Number)valueArray[i + 1]).doubleValue() - ((Number)valueArray[i]).doubleValue();
                    if (i != 0 && currVal != val) {
                        this.equalWidth_X = false;
                    }
                    val = Math.min(val, currVal);
                }
                return val;
            }
            return 1.0;
        }
        return 0.0;
    }

    public void setGradientOn(boolean onOff) {
        if (this.gradient == onOff) {
            return;
        }
        this.gradient = onOff;
        this.userSetProperties.set(819);
        this.fireRedrawEvent(new RedrawEvent(this));
    }

    public boolean getGradientOn() {
        return this.gradient;
    }

    class HistogramElement {
        public Object element;
        public Rectangle2D projectedRect;
        public String description;
        public long obsNo;

        public HistogramElement(Object e, String desc) {
            this.element = e;
            this.description = desc;
            this.projectedRect = null;
        }

        public HistogramElement(Object e) {
            this(e, null);
        }
    }
}

