/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.data;

import com.sas.graphics.util.DynamicIntArray;
import com.sas.graphics.util.StringCompare;
import java.util.List;

public class StableHeapSort {
    public static int[] heapSort(List list, int[] indexes, int sortDirection, int startIndex, int endIndex) {
        int heapSize;
        if (list == null) {
            return null;
        }
        int n = heapSize = endIndex - startIndex + 1;
        for (int i = startIndex + heapSize / 2 - 1; i >= startIndex; --i) {
            StableHeapSort.heapify(list, indexes, sortDirection, i, startIndex, heapSize);
        }
        Object currentByValue = null;
        DynamicIntArray byGroups = new DynamicIntArray();
        for (int i = n; i >= 1; --i) {
            StableHeapSort.swap(indexes, startIndex + i - 1, startIndex);
            StableHeapSort.stabalizeIndexList(list, indexes, sortDirection, --heapSize, endIndex);
            Object value = list.get(indexes[startIndex + i - 1]);
            if (StableHeapSort.compare(currentByValue, value, sortDirection) != 0) {
                byGroups.add(startIndex + i - 1);
                currentByValue = value;
            }
            StableHeapSort.heapify(list, indexes, sortDirection, startIndex, startIndex, heapSize);
        }
        return indexes;
    }

    private static void heapify(List list, int[] indexes, int sortDirection, int i, int heapStartIndex, int heapSize) {
        int left = heapStartIndex + 2 * (i - heapStartIndex) + 1;
        int right = heapStartIndex + 2 * (i - heapStartIndex) + 2;
        int largest = left < heapStartIndex + heapSize && StableHeapSort.compare(list.get(indexes[left]), list.get(indexes[i]), sortDirection) > 0 ? left : i;
        if (right < heapStartIndex + heapSize && StableHeapSort.compare(list.get(indexes[right]), list.get(indexes[largest]), sortDirection) > 0) {
            largest = right;
        }
        if (largest != i) {
            StableHeapSort.swap(indexes, i, largest);
            StableHeapSort.heapify(list, indexes, sortDirection, largest, heapStartIndex, heapSize);
        }
    }

    public int getSortedIndex(int[] indexes, int i) {
        if (indexes == null || i < 0 || i >= indexes.length) {
            return i;
        }
        return indexes[i];
    }

    private static int compare(Object a, Object b, int sortDirection) {
        if (a == null && b == null) {
            return 0;
        }
        if (a == null || b == null) {
            return -999;
        }
        if (a instanceof Number) {
            if (!(b instanceof Number)) {
                return -999;
            }
            double aVal = ((Number)a).doubleValue();
            double bVal = ((Number)b).doubleValue();
            if (Double.isNaN(aVal) && Double.isNaN(bVal)) {
                return 0;
            }
            if (Double.isNaN(aVal)) {
                return sortDirection == 1 ? -1 : 1;
            }
            if (Double.isNaN(bVal)) {
                return sortDirection == 1 ? 1 : -1;
            }
            if (aVal < bVal) {
                return sortDirection == 1 ? -1 : 1;
            }
            if (bVal < aVal) {
                return sortDirection == 1 ? 1 : -1;
            }
            return 0;
        }
        String aVal = a.toString();
        String bVal = b.toString();
        int rc = StringCompare.compareTo((String)aVal, (String)bVal);
        if (sortDirection == -1) {
            return -rc;
        }
        return rc;
    }

    private static void stabalizeIndexList(List list, int[] indexes, int sortDirection, int lockPosition, int endIndex) {
        if (lockPosition >= indexes.length || lockPosition > endIndex) {
            return;
        }
        Object iValue = list.get(indexes[lockPosition]);
        int swapPosition = lockPosition;
        int i = lockPosition + 1;
        while (i <= endIndex) {
            Object compareValue = list.get(indexes[i]);
            if (StableHeapSort.compare(iValue, compareValue, sortDirection) == 0) {
                if (indexes[i] >= indexes[swapPosition]) {
                    return;
                }
                StableHeapSort.swap(indexes, swapPosition, i);
            } else {
                return;
            }
            swapPosition = i++;
        }
    }

    private static void swap(int[] indexes, int a, int b) {
        if (a < 0 || a >= indexes.length || b < 0 || b >= indexes.length || a == b) {
            return;
        }
        int temp = indexes[a];
        indexes[a] = indexes[b];
        indexes[b] = temp;
    }
}

