/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.boxplot;

import com.sas.graphics.silk.interfaces.TransformInterface;
import com.sas.graphics.util.Markers;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class TukeyBox {
    public static final int CAP_NONE = 0;
    public static final int CAP_SERIF = 1;
    public static final int CAP_LINE = 2;
    public static final int CAP_BRACKET = 3;
    public static final int ORIENT_VERTICAL = 0;
    public static final int ORIENT_HORIZONTAL = 1;
    public boolean extreme = false;
    public boolean notched = false;
    public boolean fillOn = false;
    public Color fillColor = Color.blue;
    public Color outlineColor = Color.black;
    public int outlineWidth = 1;
    public int capShape = 2;
    public Color medianColor = Color.black;
    public int medianShape = -1;
    public int medianWidth = 12;
    public Color meanColor = Color.red;
    public int meanShape = 6;
    public int meanWidth = 12;
    public boolean markerOn = true;
    public Color markerColor = Color.black;
    public int markerShape = 0;
    public int markerWidth = 10;
    public Color whiskerColor = Color.black;
    public int whiskerWidth = 1;
    public Color capColor = Color.black;
    public int capWidth = 1;
    public int orientation = 0;
    public double boxWidth;
    public double x;
    public double[] y;
    public double extremeMin;
    public double extremeMax;
    public int catIdx = -1;
    public int groupIdx = -1;
    protected Rectangle2D.Double boundingBox = new Rectangle2D.Double();
    protected String description;
    protected boolean valid;
    protected boolean validating = true;
    protected boolean[] graphed = new boolean[8];
    TransformInterface transform;
    private int boxCenter = 0;

    public TukeyBox(TransformInterface aTransform) {
        this.transform = aTransform;
    }

    public void draw(Graphics2D g) {
        if (!this.validateData()) {
            return;
        }
        if (this.orientation == 0) {
            this.drawVerticalBox(g);
        } else {
            this.drawHorizontalBox(g);
        }
    }

    private void drawVerticalBox(Graphics2D g) {
        double[] scr = new double[3];
        if (Double.isNaN(this.x)) {
            scr[0] = this.boxCenter;
        } else {
            this.transform.project(this.x, 0.0, 0.0, scr);
        }
        double minX = scr[0] - this.boxWidth * 0.5;
        double maxX = scr[0] + this.boxWidth * 0.5;
        double temp = Math.min(minX, maxX);
        double temp2 = Math.max(minX, maxX);
        minX = temp;
        maxX = temp2;
        double halfX = minX + (maxX - minX) / 2.0;
        this.transform.project(0.0, this.y[1], 0.0, scr);
        double q1 = scr[1];
        this.transform.project(0.0, this.y[2], 0.0, scr);
        double median = scr[1];
        this.transform.project(0.0, this.y[3], 0.0, scr);
        double q3 = scr[1];
        this.transform.project(0.0, this.y[5], 0.0, scr);
        double mean = scr[1];
        double n = this.y[6];
        n = Math.max(1.0, n);
        double min = this.y[0];
        double max = this.y[4];
        if (this.extreme) {
            min = Double.isNaN(this.extremeMin) ? this.y[0] : this.extremeMin;
            max = Double.isNaN(this.extremeMax) ? this.y[4] : this.extremeMax;
        }
        this.transform.project(0.0, min, 0.0, scr);
        double minY = scr[1];
        this.transform.project(0.0, max, 0.0, scr);
        double maxY = scr[1];
        boolean graphMin = this.extreme ? true : this.graphed[0];
        boolean graphMedian = this.graphed[2];
        boolean graphMax = this.extreme ? true : this.graphed[4];
        boolean graphMean = this.graphed[5];
        boolean graphN = this.graphed[6];
        temp = Math.min(q1, q3);
        q1 = temp2 = Math.max(q1, q3);
        q3 = temp;
        boolean notched = this.notched && graphMedian && graphN;
        double endY = notched ? 1.58 * (q1 - q3) / Math.sqrt(n) : 0.0;
        double endX = notched ? 0.25 * (maxX - minX) : 0.0;
        int[] polyX = new int[10];
        int[] polyY = new int[10];
        if (notched) {
            polyX[0] = (int)maxX;
            polyY[0] = (int)q1;
            polyX[1] = (int)maxX;
            polyY[1] = (int)(median + endY);
            polyX[2] = (int)(maxX - endX);
            polyY[2] = (int)median;
            polyX[3] = (int)maxX;
            polyY[3] = (int)(median - endY);
            polyX[4] = (int)maxX;
            polyY[4] = (int)q3;
            polyX[5] = (int)minX;
            polyY[5] = (int)q3;
            polyX[6] = (int)minX;
            polyY[6] = (int)(median - endY);
            polyX[7] = (int)(minX + endX);
            polyY[7] = (int)median;
            polyX[8] = (int)minX;
            polyY[8] = (int)(median + endY);
            polyX[9] = (int)minX;
            polyY[9] = (int)q1;
        }
        Stroke oldStroke = g.getStroke();
        if (graphMin || graphMax) {
            g.setColor(this.whiskerColor);
            g.setStroke(new BasicStroke(this.whiskerWidth));
            if (graphMin) {
                g.drawLine((int)halfX, (int)q1, (int)halfX, (int)minY);
            }
            if (graphMax) {
                g.drawLine((int)halfX, (int)q3, (int)halfX, (int)maxY);
            }
        }
        if ((this.capShape == 1 || this.capShape == 2 || this.capShape == 3) && (graphMin || graphMax)) {
            double quarterX = (maxX - minX) / 4.0;
            g.setColor(this.capColor);
            g.setStroke(new BasicStroke(this.capWidth));
            if (this.capShape == 1) {
                if (graphMin) {
                    g.drawLine((int)(minX + quarterX), (int)minY, (int)(maxX - quarterX), (int)minY);
                }
                if (graphMax) {
                    g.drawLine((int)(minX + quarterX), (int)maxY, (int)(maxX - quarterX), (int)maxY);
                }
            } else if (this.capShape == 2) {
                if (graphMin) {
                    g.drawLine((int)minX, (int)minY, (int)maxX, (int)minY);
                }
                if (graphMax) {
                    g.drawLine((int)minX, (int)maxY, (int)maxX, (int)maxY);
                }
            } else if (this.capShape == 3) {
                double m1Y = Math.max(minY, maxY);
                double m2Y = Math.min(minY, maxY);
                double t1 = Math.max(q1, q3);
                double t2 = Math.min(q1, q3);
                double quarterY = Math.min(Math.abs(m1Y - t1), Math.abs(t2 - m2Y)) / 4.0;
                if (graphMin) {
                    g.drawLine((int)minX, (int)(m1Y - quarterY), (int)minX, (int)m1Y);
                    g.drawLine((int)minX, (int)m1Y, (int)maxX, (int)m1Y);
                    g.drawLine((int)maxX, (int)(m1Y - quarterY), (int)maxX, (int)m1Y);
                }
                if (graphMax) {
                    g.drawLine((int)minX, (int)(m2Y + quarterY), (int)minX, (int)m2Y);
                    g.drawLine((int)minX, (int)m2Y, (int)maxX, (int)m2Y);
                    g.drawLine((int)maxX, (int)(m2Y + quarterY), (int)maxX, (int)m2Y);
                }
            }
        }
        if (this.fillOn) {
            g.setColor(this.fillColor);
            if (!notched) {
                g.fillRect((int)minX, (int)q3, (int)(maxX - minX), (int)(q1 - q3));
            } else {
                g.fillPolygon(polyX, polyY, 10);
            }
        }
        g.setColor(this.outlineColor);
        g.setStroke(new BasicStroke(this.outlineWidth));
        if (!notched) {
            g.drawRect((int)minX, (int)q3, (int)(maxX - minX), (int)(q1 - q3));
        } else {
            g.drawPolygon(polyX, polyY, 10);
        }
        if (graphMedian) {
            if (this.medianShape >= 0) {
                Markers.draw((Graphics)g, (Color)this.medianColor, (Color)this.medianColor, (int)this.medianShape, (int)this.medianWidth, (int)((int)halfX), (int)((int)median));
            } else {
                g.setColor(this.medianColor);
                g.setStroke(new BasicStroke(1.0f));
                if (notched) {
                    g.drawLine((int)(minX + endX), (int)median, (int)(maxX - endX), (int)median);
                } else {
                    g.drawLine((int)minX, (int)median, (int)maxX, (int)median);
                }
            }
        }
        if (graphMean) {
            if (this.meanShape >= 0) {
                Markers.draw((Graphics)g, (Color)this.meanColor, (Color)this.meanColor, (int)this.meanShape, (int)this.meanWidth, (int)((int)halfX), (int)((int)mean));
            } else {
                g.setColor(this.meanColor);
                g.setStroke(new BasicStroke(1.0f));
                if (notched) {
                    double deltaX = 0.0;
                    double dist = Math.abs(median - mean);
                    deltaX = dist >= endY ? 0.0 : (endY - dist) * endX / endY;
                    g.drawLine((int)(minX + deltaX), (int)mean, (int)(maxX - deltaX), (int)mean);
                } else {
                    g.drawLine((int)minX, (int)mean, (int)maxX, (int)mean);
                }
            }
        }
        if (this.markerOn && !this.extreme) {
            for (int i = 8; i < this.y.length; ++i) {
                this.transform.project(0.0, this.y[i], 0.0, scr);
                Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)((int)halfX), (int)((int)scr[1]));
            }
        }
        g.setStroke(oldStroke);
        this.boundingBox.x = minX;
        this.boundingBox.y = q3;
        this.boundingBox.width = maxX - minX;
        this.boundingBox.height = q1 - q3;
    }

    private void drawHorizontalBox(Graphics2D g) {
        double[] scr = new double[3];
        if (Double.isNaN(this.x)) {
            scr[1] = this.boxCenter;
        } else {
            this.transform.project(0.0, this.x, 0.0, scr);
        }
        double minY = scr[1] + this.boxWidth * 0.5;
        double maxY = scr[1] - this.boxWidth * 0.5;
        double temp1 = Math.min(minY, maxY);
        double temp2 = Math.max(minY, maxY);
        minY = temp1;
        maxY = temp2;
        double halfY = minY + (maxY - minY) / 2.0;
        this.transform.project(this.y[1], 0.0, 0.0, scr);
        double q1 = scr[0];
        this.transform.project(this.y[2], 0.0, 0.0, scr);
        double median = scr[0];
        this.transform.project(this.y[3], 0.0, 0.0, scr);
        double q3 = scr[0];
        this.transform.project(this.y[5], 0.0, 0.0, scr);
        double mean = scr[0];
        double n = this.y[6];
        n = Math.max(1.0, n);
        double min = this.y[0];
        double max = this.y[4];
        if (this.extreme) {
            min = Double.isNaN(this.extremeMin) ? this.y[0] : this.extremeMin;
            max = Double.isNaN(this.extremeMax) ? this.y[4] : this.extremeMax;
        }
        this.transform.project(min, 0.0, 0.0, scr);
        double minX = scr[0];
        this.transform.project(max, 0.0, 0.0, scr);
        double maxX = scr[0];
        boolean graphMin = this.extreme ? true : this.graphed[0];
        boolean graphMedian = this.graphed[2];
        boolean graphMax = this.extreme ? true : this.graphed[4];
        boolean graphMean = this.graphed[5];
        boolean graphN = this.graphed[6];
        boolean notched = this.notched && graphMedian && graphN;
        double endX = 1.58 * (q3 - q1) / Math.sqrt(n);
        double endY = notched ? 0.25 * (maxY - minY) : 0.0;
        int[] polyX = new int[10];
        int[] polyY = new int[10];
        if (notched) {
            polyY[0] = (int)maxY;
            polyX[0] = (int)q1;
            polyY[1] = (int)maxY;
            polyX[1] = (int)(median - endX);
            polyY[2] = (int)(maxY - endY);
            polyX[2] = (int)median;
            polyY[3] = (int)maxY;
            polyX[3] = (int)(median + endX);
            polyY[4] = (int)maxY;
            polyX[4] = (int)q3;
            polyY[5] = (int)minY;
            polyX[5] = (int)q3;
            polyY[6] = (int)minY;
            polyX[6] = (int)(median + endX);
            polyY[7] = (int)(minY + endY);
            polyX[7] = (int)median;
            polyY[8] = (int)minY;
            polyX[8] = (int)(median - endX);
            polyY[9] = (int)minY;
            polyX[9] = (int)q1;
        }
        Stroke oldStroke = g.getStroke();
        if (graphMin || graphMax) {
            g.setColor(this.whiskerColor);
            g.setStroke(new BasicStroke(this.whiskerWidth));
            if (graphMin) {
                g.drawLine((int)q1, (int)halfY, (int)minX, (int)halfY);
            }
            if (graphMax) {
                g.drawLine((int)q3, (int)halfY, (int)maxX, (int)halfY);
            }
        }
        if ((this.capShape == 1 || this.capShape == 2 || this.capShape == 3) && (graphMin || graphMax)) {
            double quarterY = (maxY - minY) / 4.0;
            g.setColor(this.capColor);
            g.setStroke(new BasicStroke(this.capWidth));
            if (this.capShape == 1) {
                if (graphMin) {
                    g.drawLine((int)minX, (int)(minY + quarterY), (int)minX, (int)(maxY - quarterY));
                }
                if (graphMax) {
                    g.drawLine((int)maxX, (int)(minY + quarterY), (int)maxX, (int)(maxY - quarterY));
                }
            } else if (this.capShape == 2) {
                if (graphMin) {
                    g.drawLine((int)minX, (int)minY, (int)minX, (int)maxY);
                }
                if (graphMax) {
                    g.drawLine((int)maxX, (int)minY, (int)maxX, (int)maxY);
                }
            } else if (this.capShape == 3) {
                double quarterX = Math.min(Math.abs(minX - q1), Math.abs(q3 - maxX)) / 4.0;
                double m1X = Math.min(minX, maxX);
                double m2X = Math.max(minX, maxX);
                if (graphMin) {
                    g.drawLine((int)(m1X + quarterX), (int)minY, (int)m1X, (int)minY);
                    g.drawLine((int)m1X, (int)minY, (int)m1X, (int)maxY);
                    g.drawLine((int)(m1X + quarterX), (int)maxY, (int)m1X, (int)maxY);
                }
                if (graphMax) {
                    g.drawLine((int)(m2X - quarterX), (int)minY, (int)m2X, (int)minY);
                    g.drawLine((int)m2X, (int)minY, (int)m2X, (int)maxY);
                    g.drawLine((int)(m2X - quarterX), (int)maxY, (int)m2X, (int)maxY);
                }
            }
        }
        double t1 = Math.min(q1, q3);
        double t2 = Math.abs(q3 - q1);
        if (this.fillOn) {
            g.setColor(this.fillColor);
            if (!notched) {
                g.fillRect((int)t1, (int)minY, (int)t2, (int)(maxY - minY));
            } else {
                g.fillPolygon(polyX, polyY, 10);
            }
        }
        g.setColor(this.outlineColor);
        g.setStroke(new BasicStroke(this.outlineWidth));
        if (!notched) {
            g.drawRect((int)t1, (int)minY, (int)t2, (int)(maxY - minY));
        } else {
            g.drawPolygon(polyX, polyY, 10);
        }
        if (graphMedian) {
            if (this.medianShape >= 0) {
                Markers.draw((Graphics)g, (Color)this.medianColor, (Color)this.medianColor, (int)this.medianShape, (int)this.medianWidth, (int)((int)median), (int)((int)halfY));
            } else {
                g.setColor(this.medianColor);
                g.setStroke(new BasicStroke(1.0f));
                if (notched) {
                    g.drawLine((int)median, (int)(minY + endY), (int)median, (int)(maxY - endY));
                } else {
                    g.drawLine((int)median, (int)minY, (int)median, (int)maxY);
                }
            }
        }
        if (graphMean) {
            if (this.meanShape >= 0) {
                Markers.draw((Graphics)g, (Color)this.meanColor, (Color)this.meanColor, (int)this.meanShape, (int)this.meanWidth, (int)((int)mean), (int)((int)halfY));
            } else {
                g.setColor(this.meanColor);
                g.setStroke(new BasicStroke(1.0f));
                if (notched) {
                    double deltaY = 0.0;
                    double dist = Math.abs(median - mean);
                    deltaY = dist >= endX ? 0.0 : (endX - dist) * endY / endX;
                    g.drawLine((int)mean, (int)(minY + deltaY), (int)mean, (int)(maxY - deltaY));
                } else {
                    g.drawLine((int)mean, (int)minY, (int)mean, (int)maxY);
                }
            }
        }
        if (this.markerOn && !this.extreme) {
            for (int i = 8; i < this.y.length; ++i) {
                this.transform.project(this.y[i], 0.0, 0.0, scr);
                Markers.draw((Graphics)g, (Color)this.markerColor, (Color)this.markerColor, (int)this.markerShape, (int)this.markerWidth, (int)((int)scr[0]), (int)((int)halfY));
            }
        }
        g.setStroke(oldStroke);
        this.boundingBox.x = q1;
        this.boundingBox.y = minY;
        this.boundingBox.width = q3 - q1;
        this.boundingBox.height = maxY - minY;
    }

    private boolean validateData() {
        if (!this.validating) {
            return this.valid;
        }
        this.validating = false;
        double min = this.y[0];
        double q1 = this.y[1];
        double median = this.y[2];
        double q3 = this.y[3];
        double max = this.y[4];
        double mean = this.y[5];
        double n = this.y[6];
        double std = this.y[7];
        for (int i = 0; i < 8; ++i) {
            this.graphed[i] = true;
        }
        if (Double.isNaN(q1) || Double.isNaN(q3) || !Double.isNaN(q1) && !Double.isNaN(q3) && q1 > q3) {
            this.valid = false;
            return this.valid;
        }
        if (Double.isNaN(min)) {
            this.y[0] = 0.0;
            this.graphed[0] = false;
        } else if (min > q1) {
            this.valid = false;
            return this.valid;
        }
        if (Double.isNaN(median)) {
            this.y[2] = 0.0;
            this.graphed[2] = false;
        } else if (median > q3 || median < q1) {
            this.valid = false;
            return this.valid;
        }
        if (Double.isNaN(max)) {
            this.y[4] = 0.0;
            this.graphed[4] = false;
        } else if (max < q3) {
            this.valid = false;
            return this.valid;
        }
        if (Double.isNaN(mean)) {
            this.y[5] = 0.0;
            this.graphed[5] = false;
        }
        if (Double.isNaN(n)) {
            this.y[6] = 0.0;
            this.graphed[6] = false;
        } else if (n <= 0.0) {
            this.valid = false;
            return this.valid;
        }
        if (!Double.isNaN(std) && std < 0.0) {
            this.valid = false;
            return this.valid;
        }
        this.valid = true;
        return this.valid;
    }

    public Rectangle2D getBoundingBox() {
        return this.boundingBox;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String des) {
        this.description = des;
    }

    public boolean isValid() {
        return this.validateData();
    }

    public boolean isGraphed(int idx) {
        if (idx >= 0 && idx < 8) {
            return this.graphed[idx];
        }
        return false;
    }

    public int getBoxCenter() {
        return this.boxCenter;
    }

    public void setBoxCenter(int boxCenter) {
        this.boxCenter = boxCenter;
    }
}

