/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.silk.base.BaseElement;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class TextElement
extends BaseElement {
    String text;
    int alignment;

    public TextElement() {
        this(null);
    }

    public TextElement(String text) {
        this(text, 0);
    }

    public TextElement(String text, int alignment) {
        this.setText(text);
        this.setAlignment(alignment);
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public int getAlignment() {
        return this.alignment;
    }

    @Override
    protected void drawChart(Graphics g) {
        FontMetrics fm;
        Rectangle2D r;
        if (this.bounds != null && this.text != null && (r = (fm = g.getFontMetrics()).getStringBounds(this.text, g)) != null) {
            int x;
            int y = (int)Math.max((this.bounds.getHeight() - r.getHeight()) / 2.0, 0.0);
            switch (this.alignment) {
                case 0: {
                    x = (int)Math.max((this.bounds.getWidth() - r.getWidth()) / 2.0, 0.0);
                    break;
                }
                case 4: {
                    x = (int)(this.bounds.getWidth() - r.getWidth());
                    break;
                }
                default: {
                    x = 0;
                }
            }
            g.setColor(this.style.getTextStyleElement("ValueText").getTextColor());
            g.drawString(this.text, x, y);
        }
    }

    public boolean isInteractionEnabled() {
        return false;
    }

    public void setInteractionEnabled(boolean interactionEnabled) {
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        return false;
    }

    @Override
    protected void drawSelected(Graphics g) {
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        return null;
    }
}

