/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.SpiralPropertyInterface;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.MarkerRenderer;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.Roles;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.RangeInfoModel;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Vector;

public class SpiralElement
extends BaseElement
implements SpiralPropertyInterface {
    protected TabPanelInterface spiralPanel = null;
    protected static final int[] supportedSpiralProps = new int[]{1301, 1300, 1307, 1308, 1302, 1100, 1303, 1305, 1304, 1200, 1306, 1001, 1401, 1500, 24, 25, 23, 433, 426, 434, 441, 19001, 19002, 19003, 1309, 1310};
    protected SILKNumber timeRole;
    protected SILKNumber respRole;
    protected int timeINDEX;
    protected int respINDEX;
    protected int numberOfPeriods;
    protected double[] timeDATA = new double[2];
    protected double[] respDATA = new double[4];
    protected double[] data = new double[8];
    protected double[] oldData = new double[8];
    protected double[] array1 = new double[8];
    protected double[] array2 = new double[8];
    int[] periodData;
    int[] bucketData;
    int period;
    int bucket;
    int NUMBER_OF_OBS;
    protected Object[] revolutions;
    protected int[] variableFormats;
    protected boolean needToAnalyze = true;
    protected double axisRange;
    protected double radiusBase;
    protected double radiusSpacing;
    protected double radiusDeltaMax;
    protected int mathOp;
    protected int revolutionAngle;
    protected int revolutionAngleMin;
    protected int revolutionAngleMax;
    protected int numberOfBuckets;
    protected double bucketAngle;
    protected int needleWidth;
    protected boolean drawSpiral;
    protected boolean drawAxes;
    protected boolean drawConnectMarkerLines;
    protected boolean drawSpiralLabels;
    protected boolean drawAxisLabels;
    protected boolean needleAA;
    protected boolean markersFilled = true;
    protected boolean markersOutlined = true;
    protected int markerSize = 5;
    protected int halfMarkerSize = this.markerSize / 2;
    protected int markerOutlineWidth = 1;
    private Color referenceLineColor = this.style.getLineStyleElement("GridLines").getLineColor();
    private Color positiveValueColor = this.style.getLineStyleElement("GraphDataStyle1").getLineColor();
    private Color negativeValueColor = this.style.getLineStyleElement("GraphDataStyle2").getLineColor();
    private Color selectedValueColor = this.style.getLineStyleElement("Selection").getLineColor();
    private double pointsInReferenceSpiral = 1000.0;
    protected int responseBaselineRule;
    protected int spiralRule;
    protected int plotStyle;
    protected double responseAbsoluteMaximum;
    protected int numberOfAxes;
    private boolean debug;
    Vector bucketList = new Vector();
    Object[] bucketDataByPeriod;
    protected double[] aBucket;
    protected int oldId = Integer.MAX_VALUE;
    protected int lowestBucket;

    public SpiralElement() {
        Roles r = Roles.getInstance(null);
        this.timeRole = r.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.timeRole, "TIME", 1);
        this.roles.setRoleType((Object)this.timeRole, 1);
        this.respRole = r.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.respRole, "RESPONSE", 1);
        this.roles.setRoleType((Object)this.respRole, 1);
        if (!this.userSetProperties.get(0)) {
            this.markersFilled = true;
            this.markersOutlined = true;
        }
        this.setSupportedProperties(supportedSpiralProps);
        this.userSetProperties.appendProperties(supportedSpiralProps);
        this.addChartTabInfo("com.sas.graphics.silk.ui.SpiralPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"__Spiral.txt.key.WhichDoesNotExist__", (String)"Spiral"));
        this.period = 1002;
        this.bucket = 1405;
        this.revolutionAngle = 360;
        this.plotStyle = 1102;
        this.responseBaselineRule = 1201;
        this.mathOp = 1501;
        this.numberOfAxes = 4;
        this.drawSpiral = true;
        this.drawAxes = true;
        this.drawConnectMarkerLines = false;
        this.drawSpiralLabels = true;
        this.drawAxisLabels = true;
        this.debug = false;
        this.radiusBase = 0.0;
        this.radiusSpacing = 1.0;
        this.radiusDeltaMax = 0.9;
        this.needleWidth = 1;
        this.needleAA = true;
        this.needToAnalyze = true;
    }

    private void analyzeData() {
        this.timeINDEX = this.filter.getVariableIndex(this.roles.getVariable((Object)this.timeRole, 0));
        this.respINDEX = this.filter.getVariableIndex(this.roles.getVariable((Object)this.respRole, 0));
        if (this.timeINDEX < 0 || this.respINDEX < 0) {
            return;
        }
        this.variableFormats = new int[]{SILKUtilities.getFormatType((SASFormat)((SASFormat)this.filter.getFormat(this.roles.getVariable((Object)this.timeRole, 0), SASFormat.class))), SILKUtilities.getFormatType((SASFormat)((SASFormat)this.filter.getFormat(this.roles.getVariable((Object)this.respRole, 0), SASFormat.class)))};
        RangeInfoModel rangeInfoModel = (RangeInfoModel)this.filter.getAdapter(RangeInfoModel.class);
        this.respDATA[0] = Double.MAX_VALUE;
        this.respDATA[1] = Double.MIN_VALUE;
        this.timeDATA[0] = rangeInfoModel.getMinimum(this.roles.getVariable((Object)this.timeRole, 0));
        this.timeDATA[1] = rangeInfoModel.getMaximum(this.roles.getVariable((Object)this.timeRole, 0));
        this.buildMetaDataTables();
        this.lowestBucket = this.getBucketFromTable(0, 0);
        if (this.debug) {
            for (int i = 0; i < this.NUMBER_OF_OBS; ++i) {
                System.out.println("time: " + this.filter.getNumericValue(this.timeINDEX, (long)i) + ", resp: " + this.filter.getNumericValue(this.respINDEX, (long)i));
            }
            System.out.println();
            System.out.println("respMin:" + this.respDATA[0] + ", respMax:" + this.respDATA[1] + ", respMed:" + this.respDATA[2]);
            System.out.println("timeMin:" + this.timeDATA[0] + ", timeMax:" + this.timeDATA[1]);
            System.out.println("axisRange:" + this.axisRange + ", BucketAngleInDegrees:" + this.bucketAngle + ", numberOfPeriods:" + this.numberOfPeriods);
            System.out.println();
        }
        this.needToAnalyze = false;
    }

    private void buildMetaDataTables() {
        this.NUMBER_OF_OBS = this.filter.getNumberObservations(-1);
        this.makePeriodData();
        this.makeBucketData();
        this.axisRange = this.radiusBase + this.radiusSpacing * (double)(this.numberOfPeriods + 2);
        double currentB = 0.0;
        double B = 0.0;
        int currentP = 0;
        int P = 0;
        double respTotal = 0.0;
        double timeTotal = 0.0;
        double theta = 0.0;
        double currentTheta = 0.0;
        double bucketCount = 0.0;
        int i = 0;
        int min = 0;
        this.bucketList.clear();
        this.responseAbsoluteMaximum = 0.0;
        while (i < this.NUMBER_OF_OBS) {
            P = this.getPeriod(i);
            B = this.getBucketFromTable(i, P);
            theta = B * (double)this.revolutionAngle / (double)this.getNumberOfBuckets(P);
            if (P == currentP && B == currentB) {
                respTotal = this.mathOperation(this.filter.getNumericValue(this.respINDEX, (long)i), respTotal);
                timeTotal += this.filter.getNumericValue(this.timeINDEX, (long)i);
                currentTheta = theta;
                bucketCount += 1.0;
                ++i;
                continue;
            }
            if (i == 0) {
                respTotal = 0.0;
                timeTotal = 0.0;
                bucketCount = 0.0;
                currentB = B;
                currentP = P;
                continue;
            }
            timeTotal /= bucketCount;
            if (this.mathOp == 1504) {
                respTotal /= bucketCount;
            }
            this.bucketList.add(new double[]{currentP + 1, timeTotal, respTotal, currentTheta, currentB, min, i});
            this.respDATA[0] = Math.min(respTotal, this.respDATA[0]);
            this.respDATA[1] = Math.max(respTotal, this.respDATA[1]);
            this.respDATA[3] = this.respDATA[3] + respTotal;
            min = i;
            respTotal = 0.0;
            timeTotal = 0.0;
            bucketCount = 0.0;
            currentB = B;
            currentP = P;
        }
        timeTotal /= bucketCount;
        if (this.mathOp == 1504) {
            respTotal /= bucketCount;
        }
        this.bucketList.add(new double[]{P + 1, timeTotal, respTotal, theta, B, min, i});
        this.respDATA[0] = Math.min(respTotal, this.respDATA[0]);
        this.respDATA[1] = Math.max(respTotal, this.respDATA[1]);
        this.respDATA[3] = this.respDATA[3] + respTotal;
        this.respDATA[2] = (this.respDATA[0] + this.respDATA[1]) / 2.0;
        this.respDATA[3] = this.respDATA[3] / (double)this.bucketList.size();
        this.responseAbsoluteMaximum = Math.max(Math.abs(this.respDATA[0]), Math.abs(this.respDATA[1]));
    }

    private double mathOperation(double a, double b) {
        switch (this.mathOp) {
            case 1501: {
                return a + b;
            }
            case 1504: {
                return a + b;
            }
            case 1502: {
                return Math.max(a, b);
            }
            case 1503: {
                return Math.min(a, b);
            }
        }
        return -1.0;
    }

    private void getNumberOfPeriods() {
        int startYear = this.getYear(this.timeDATA[0]);
        int endYear = this.getYear(this.timeDATA[1]);
        Calendar c = Calendar.getInstance();
        switch (this.period) {
            case 1002: {
                this.numberOfPeriods = endYear - startYear + 1;
                break;
            }
            case 1003: {
                int n = endYear - startYear + 1;
                if (n == 0) {
                    this.numberOfPeriods = 11 - this.getMonth(this.timeDATA[0]) + this.getMonth(this.timeDATA[1]) + 1;
                    break;
                }
                this.numberOfPeriods = n * 12 - (11 - this.getMonth(this.timeDATA[1])) - this.getMonth(this.timeDATA[0]);
                break;
            }
            case 1004: {
                if (endYear != startYear) {
                    for (int year = startYear; year < endYear; ++year) {
                        c.set(1, year);
                        this.numberOfPeriods += c.getActualMaximum(3);
                    }
                    break;
                }
                c.setTimeInMillis(this.getJavaTime(this.timeDATA[0]));
                int first = c.get(3);
                c.setTimeInMillis(this.getJavaTime(this.timeDATA[1]));
                int last = c.get(3);
                this.numberOfPeriods = last - first + 1;
                break;
            }
            case 1005: {
                if (endYear != startYear) {
                    for (int year = startYear; year < endYear; ++year) {
                        c.set(1, year);
                        this.numberOfPeriods += c.getActualMaximum(3);
                    }
                    break;
                }
                c.setTimeInMillis(this.getJavaTime(this.timeDATA[0]));
                int first = c.get(6);
                c.setTimeInMillis(this.getJavaTime(this.timeDATA[1]));
                int last = c.get(6);
                this.numberOfPeriods = last - first + 1;
            }
        }
    }

    private int getNumberOfBuckets(int whichPeriod) {
        switch (this.bucket) {
            case 1403: 
            case 1404: 
            case 1405: {
                Calendar c = Calendar.getInstance();
                if (this.periodData[whichPeriod] == 0) {
                    c.setTimeInMillis(this.getJavaTime(this.filter.getNumericValue(this.timeINDEX, (long)(this.periodData[whichPeriod] - 1))));
                } else {
                    c.setTimeInMillis(this.getJavaTime(this.filter.getNumericValue(this.timeINDEX, (long)this.periodData[whichPeriod])));
                }
                return this.getMaxValue(c);
            }
        }
        return -1;
    }

    private void makePeriodData() {
        this.getNumberOfPeriods();
        this.periodData = new int[this.numberOfPeriods];
        int index = 0;
        switch (this.period) {
            case 1002: {
                int currentYear = this.getYear(this.timeDATA[0]);
                int nextYear = 0;
                int i = 0;
                while (i < this.NUMBER_OF_OBS) {
                    nextYear = this.getYear(this.filter.getNumericValue(this.timeINDEX, (long)i));
                    if (nextYear == currentYear) {
                        this.periodData[index] = i++;
                        continue;
                    }
                    ++index;
                    currentYear = nextYear;
                }
                break;
            }
            case 1003: {
                int currentMonth = this.getMonth(this.timeDATA[0]);
                int nextMonth = 0;
                int i = 0;
                while (i < this.NUMBER_OF_OBS) {
                    nextMonth = this.getMonth(this.filter.getNumericValue(this.timeINDEX, (long)i));
                    if (nextMonth == currentMonth) {
                        this.periodData[index] = i++;
                        continue;
                    }
                    ++index;
                    currentMonth = nextMonth;
                }
                break;
            }
            case 1004: {
                int currentWeek = this.getWeek(this.timeDATA[0]);
                int nextWeek = 0;
                int i = 0;
                while (i < this.NUMBER_OF_OBS) {
                    nextWeek = this.getWeek(this.filter.getNumericValue(this.timeINDEX, (long)i));
                    if (nextWeek == currentWeek) {
                        this.periodData[index] = i++;
                        continue;
                    }
                    ++index;
                    currentWeek = nextWeek;
                }
                break;
            }
        }
    }

    private void makeBucketData() {
        this.bucketDataByPeriod = new Object[this.numberOfPeriods];
        int[] bucketData = new int[this.getNumberOfBuckets(0)];
        int currentPeriod = 0;
        int thisPeriod = 0;
        int currentBucket = 0;
        int thisBucket = 0;
        int i = 0;
        while (i < this.NUMBER_OF_OBS) {
            thisPeriod = this.getPeriod(i);
            thisBucket = this.getBucket(this.filter.getNumericValue(this.timeINDEX, (long)i));
            if (thisBucket == currentBucket && thisPeriod == currentPeriod) {
                ++i;
                continue;
            }
            if (thisPeriod == currentPeriod) {
                bucketData[currentBucket] = i;
                ++currentBucket;
                continue;
            }
            bucketData[currentBucket] = i++;
            this.bucketDataByPeriod[currentPeriod] = bucketData;
            bucketData = new int[this.getNumberOfBuckets(++currentPeriod)];
            currentBucket = 0;
        }
        bucketData[currentBucket] = i + 1;
        this.bucketDataByPeriod[currentPeriod] = bucketData;
    }

    private int getPeriod(int obs) {
        for (int i = 0; i < this.periodData.length; ++i) {
            if (obs > this.periodData[i]) continue;
            return i;
        }
        System.out.println("Could not compute obs number " + obs);
        return -1;
    }

    private int getBucketFromTable(int obs, int whichPeriod) {
        int[] bucketData = (int[])this.bucketDataByPeriod[whichPeriod];
        for (int i = 0; i < bucketData.length; ++i) {
            if (obs >= bucketData[i]) continue;
            return i;
        }
        return -1;
    }

    private int getBucketFromObs(int obs) {
        int b;
        int p = this.getPeriod(obs);
        if ((p - 1985) * ((b = this.getBucketFromTable(obs, p)) - 9999) == this.oldId) {
            return -1;
        }
        this.oldId = (p - 1985) * (b - 9999);
        for (int bucketNumber = this.getNumberOfBuckets(0) * p - 2 * p + b - this.lowestBucket; bucketNumber < this.bucketList.size(); ++bucketNumber) {
            this.aBucket = (double[])this.bucketList.get(bucketNumber);
            if (this.aBucket[0] - 1.0 != (double)p || this.aBucket[4] != (double)b) continue;
            return bucketNumber;
        }
        return -1;
    }

    private int getBucket(double sasDate) {
        switch (this.bucket) {
            case 1405: {
                return this.getDay(sasDate) - 1;
            }
            case 1404: {
                return this.getWeek(sasDate) - 1;
            }
            case 1403: {
                return this.getMonth(sasDate);
            }
        }
        return -1;
    }

    private int getMaxValue(Calendar c) {
        switch (this.period) {
            case 1002: {
                switch (this.bucket) {
                    case 1405: {
                        return 366;
                    }
                    case 1404: {
                        return 53;
                    }
                    case 1403: {
                        return 12;
                    }
                }
            }
            case 1003: {
                switch (this.bucket) {
                    case 1405: {
                        return 31;
                    }
                    case 1404: {
                        return 6;
                    }
                }
            }
            case 1004: {
                switch (this.bucket) {
                    case 1405: {
                        return 7;
                    }
                }
            }
        }
        return 0;
    }

    private long getJavaTime(double sasDate) {
        switch (this.variableFormats[0]) {
            case 2: {
                return SASDateTimeFormat.SASDateTimeToJavaDate((double)sasDate);
            }
            case 1: {
                return SASDateTimeFormat.SASDateToJavaDate((double)sasDate);
            }
        }
        return 0L;
    }

    private int getDay(double sasDate) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.getJavaTime(sasDate));
        switch (this.period) {
            case 1002: {
                return c.get(6);
            }
            case 1003: {
                return c.get(5);
            }
            case 1004: {
                return c.get(7);
            }
        }
        return -1;
    }

    private int getWeek(double sasDate) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.getJavaTime(sasDate));
        switch (this.period) {
            case 1002: {
                int simple = c.get(3);
                if (simple == 1 && c.get(2) == 11) {
                    return 53;
                }
                return simple;
            }
            case 1003: {
                return c.get(4);
            }
        }
        return -1;
    }

    private int getMonth(double sasDate) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.getJavaTime(sasDate));
        return c.get(2);
    }

    private int getYear(double sasDate) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(this.getJavaTime(sasDate));
        return c.get(1);
    }

    private double[] getCoordinateData(double revolutionNumber, double timeValue, double respValue, double thetaDeg) {
        if (this.filter == null) {
            return null;
        }
        if (!Double.isNaN(respValue)) {
            int maxValue = (int)Math.pow(2.0, 15.0) - 100;
            int minValue = -maxValue;
            this.data[6] = this.getResponseOffset(respValue);
            this.data[7] = this.data[6] > 0.0 ? 1.0 : -1.0;
            this.data[6] = Math.abs(this.data[6]);
            this.data[5] = this.radiusBase + this.radiusSpacing * revolutionNumber + thetaDeg * this.radiusSpacing / (double)this.revolutionAngle;
            this.data[6] = this.data[5] + this.data[6];
            this.data[5] = this.data[5] / this.axisRange;
            this.data[6] = this.data[6] / this.axisRange;
            this.data[0] = this.data[6] * Math.cos(Math.toRadians(thetaDeg));
            this.data[1] = this.data[6] * Math.sin(Math.toRadians(thetaDeg));
            this.data = this.transformObject.project(this.data[0], this.data[1], 0.0, this.data);
            this.data[0] = Math.max((double)minValue, Math.min((double)maxValue, this.data[0]));
            this.data[1] = Math.max((double)minValue, Math.min((double)maxValue, this.data[1]));
            this.data[2] = timeValue;
            this.data[3] = respValue;
            this.data[4] = thetaDeg;
        }
        if (this.debug) {
            System.out.println();
            System.out.println("screenX:" + this.data[0]);
            System.out.println("screenY:" + this.data[1]);
            System.out.println("timeValue:" + this.data[2]);
            System.out.println("respValue:" + this.data[3]);
            System.out.println("thetaDeg:" + this.data[4]);
            System.out.println("spiralRadius:" + this.data[5]);
            System.out.println("dataRadius:" + this.data[6]);
            System.out.println("isResponseNegative:" + this.data[7]);
            System.out.println();
        }
        return this.data;
    }

    private double getResponseOffset(double respValue) {
        switch (this.responseBaselineRule) {
            case 1201: {
                this.array2[0] = this.radiusDeltaMax / this.responseAbsoluteMaximum * respValue;
                return this.array2[0] == Double.NaN ? 0.0 : this.array2[0];
            }
            case 1202: {
                this.array2[0] = 2.0 * this.radiusDeltaMax / (this.respDATA[1] - this.respDATA[0]) * (-(this.respDATA[2] - respValue) - -(this.respDATA[2] - this.respDATA[0])) - this.radiusDeltaMax;
                return this.array2[0] == Double.NaN ? 0.0 : this.array2[0];
            }
            case 1203: {
                this.array2[0] = 2.0 * this.radiusDeltaMax / (this.respDATA[1] - this.respDATA[0]) * (-(this.respDATA[3] - respValue) - -(this.respDATA[3] - this.respDATA[0])) - this.radiusDeltaMax;
                return this.array2[0] == Double.NaN ? 0.0 : this.array2[0];
            }
        }
        return 0.0;
    }

    private boolean plotPoint(Graphics g, MarkerAttrib ma, double[] data, double[] oldData, boolean isSelected) {
        switch (this.plotStyle) {
            case 1101: {
                if (isSelected) {
                    g.setColor(this.selectedValueColor);
                } else if (data[7] > 0.0) {
                    g.setColor(this.positiveValueColor);
                } else {
                    g.setColor(this.negativeValueColor);
                }
                MarkerRenderer.drawStandardMarker(g, (int)data[0], (int)data[1], g.getColor(), ma.getOutline().getColor(), ma.getShapeInt(), this.markersOutlined, this.markerSize, this.halfMarkerSize, this.markerOutlineWidth);
                if (this.drawConnectMarkerLines) {
                    if (oldData[0] != 0.0 && oldData[1] != 0.0) {
                        g.drawLine((int)oldData[0], (int)oldData[1], (int)data[0], (int)data[1]);
                    }
                    oldData[0] = data[0];
                    oldData[1] = data[1];
                }
                return true;
            }
            case 1102: {
                this.array1[0] = data[5] * Math.cos(Math.toRadians(data[4]));
                this.array1[1] = data[5] * Math.sin(Math.toRadians(data[4]));
                this.array1 = this.transformObject.project(this.array1[0], this.array1[1], 0.0, this.array1);
                if (isSelected) {
                    g.setColor(this.selectedValueColor);
                } else if (data[7] > 0.0) {
                    g.setColor(this.positiveValueColor);
                } else {
                    g.setColor(this.negativeValueColor);
                }
                g.drawLine((int)this.array1[0], (int)this.array1[1], (int)data[0], (int)data[1]);
                return true;
            }
        }
        return false;
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (this.filter == null) {
            return null;
        }
        ContinuousRange range = null;
        Enumeration e = Extract.elements((Object)which);
        while (e.hasMoreElements()) {
            Object element = e.nextElement();
            if (this.timeRole.equals(element)) {
                if (this.revolutionAngle <= 90) {
                    range = new ContinuousRange(-0.2, 1.0);
                    continue;
                }
                range = new ContinuousRange(-1.0, 1.0);
                continue;
            }
            if (!this.respRole.equals(element)) continue;
            if (this.revolutionAngle <= 180) {
                range = new ContinuousRange(-0.2, 1.0);
                continue;
            }
            range = new ContinuousRange(-1.0, 1.0);
        }
        return range;
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.needToAnalyze) {
            this.analyzeData();
            if (this.needToAnalyze) {
                return;
            }
        }
        MarkerAttrib ma = new MarkerAttrib();
        this.oldData = this.transformObject.project(this.radiusBase + this.radiusSpacing, 0.0, 0.0, this.oldData);
        Graphics2D g2 = (Graphics2D)g;
        Color oldC = g2.getColor();
        g2.setColor(this.referenceLineColor);
        if (this.drawSpiral) {
            this.drawSpiral(g2, ma);
        }
        if (this.drawAxes) {
            this.drawAxes(g2, ma);
        }
        g2.setColor(oldC);
        Stroke oldS = g2.getStroke();
        g2.setStroke(new BasicStroke(this.needleWidth, 1, 1));
        if (this.needleAA) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        for (int i = 0; i < this.bucketList.size(); ++i) {
            this.aBucket = (double[])this.bucketList.get(i);
            this.data = this.getCoordinateData(this.aBucket[0], this.aBucket[1], this.aBucket[2], this.aBucket[3]);
            this.plotPoint(g2, ma, this.data, this.oldData, false);
        }
        g2.setStroke(oldS);
    }

    protected void drawSpiral(Graphics2D g, MarkerAttrib ma) {
        double thetaIncrement = (double)this.revolutionAngle / this.pointsInReferenceSpiral;
        double startPoint = 0.0;
        for (int revolutionNumber = 1; revolutionNumber <= this.numberOfPeriods; ++revolutionNumber) {
            startPoint = this.radiusBase + (double)revolutionNumber * this.radiusSpacing;
            this.oldData = this.transformObject.project(startPoint /= this.axisRange, 0.0, 0.0, this.oldData);
            GeneralPath spiral = new GeneralPath();
            spiral.moveTo((float)this.oldData[0], (float)this.oldData[1]);
            for (double theta = thetaIncrement; theta < (double)this.revolutionAngle; theta += thetaIncrement) {
                double thetaMid = theta - thetaIncrement / 2.0;
                double thetaRadius = this.radiusBase + this.radiusSpacing * (double)revolutionNumber + theta * this.radiusSpacing / (double)this.revolutionAngle;
                double thetaMidRadius = this.radiusBase + this.radiusSpacing * (double)revolutionNumber + thetaMid * this.radiusSpacing / (double)this.revolutionAngle;
                this.array1 = this.transformObject.project((thetaRadius /= this.axisRange) * Math.cos(Math.toRadians(theta)), thetaRadius * Math.sin(Math.toRadians(theta)), 0.0, this.array1);
                this.array2 = this.transformObject.project((thetaMidRadius /= this.axisRange) * Math.cos(Math.toRadians(thetaMid)), thetaMidRadius * Math.sin(Math.toRadians(thetaMid)), 0.0, this.array2);
                spiral.quadTo((float)this.array2[0], (float)this.array2[1], (float)this.array1[0], (float)this.array1[1]);
            }
            g.draw(spiral);
        }
    }

    protected void drawAxes(Graphics2D g, MarkerAttrib ma) {
        this.oldData = this.transformObject.project(0.0, 0.0, 0.0, this.oldData);
        double axisAngle = (double)this.revolutionAngle / (double)this.numberOfAxes;
        for (int i = 0; i <= this.numberOfAxes; ++i) {
            this.data = this.transformObject.project(Math.cos(Math.toRadians((double)i * axisAngle)), Math.sin(Math.toRadians((double)i * axisAngle)), 0.0, this.data);
            GeneralPath line = new GeneralPath();
            line.moveTo((int)this.oldData[0], (int)this.oldData[1]);
            line.lineTo((int)this.data[0], (int)this.data[1]);
            g.draw(line);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        MarkerAttrib ma = new MarkerAttrib();
        this.oldId = Integer.MAX_VALUE;
        Graphics2D g2 = (Graphics2D)g;
        Stroke oldS = g2.getStroke();
        g2.setStroke(new BasicStroke(this.needleWidth, 1, 1));
        if (this.needleAA) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        while (this.selections.hasMoreSelections()) {
            int bucketNumber = this.getBucketFromObs(this.selections.nextSelectedIndex());
            if (bucketNumber == -1) continue;
            this.aBucket = (double[])this.bucketList.get(bucketNumber);
            this.data = this.getCoordinateData(this.aBucket[0], this.aBucket[1], this.aBucket[2], this.aBucket[3]);
            this.plotPoint(g2, ma, this.data, this.oldData, true);
        }
        g2.setStroke(oldS);
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        double error = 5.0;
        for (int i = 0; i < this.bucketList.size(); ++i) {
            this.aBucket = (double[])this.bucketList.get(i);
            this.data = this.getCoordinateData(this.aBucket[0], this.aBucket[1], this.aBucket[2], this.aBucket[3]);
            if (!(Math.abs((double)screenX - this.data[0]) < error) || !(Math.abs((double)screenY - this.data[1]) < error)) continue;
            Calendar c = Calendar.getInstance();
            c.setTimeInMillis(this.getJavaTime(this.data[2]));
            String out = this.roles.getVariable((Object)this.timeRole, 0).toString() + " = " + (c.get(2) + 1) + "/" + c.get(5) + "/" + c.get(1) + "\n" + this.roles.getVariable((Object)this.respRole, 0).toString() + " = " + this.data[3];
            return out;
        }
        return null;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        if (this.filter == null) {
            return false;
        }
        int[] sel = new int[1];
        for (int i = 0; i < this.bucketList.size(); ++i) {
            this.aBucket = (double[])this.bucketList.get(i);
            this.data = this.getCoordinateData(this.aBucket[0], this.aBucket[1], this.aBucket[2], this.aBucket[3]);
            if (!selectArea.contains(this.data[0], this.data[1])) continue;
            int j = (int)this.aBucket[5];
            while ((double)j < this.aBucket[6]) {
                if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                    sel[0] = j;
                    ((AbstractDataFilter)this.filter).setSelected((Object)sel, 3, null);
                } else {
                    this.filter.setSelected((long)j, select);
                }
                ++j;
            }
        }
        return false;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 269: 
            case 270: 
            case 19064: 
            case 19065: 
            case 19068: 
            case 19069: {
                rc = Boolean.FALSE;
                break;
            }
            case 1001: {
                rc = new Integer(this.period);
                break;
            }
            case 1401: {
                rc = new Integer(this.bucket);
                break;
            }
            case 1100: {
                rc = new Integer(this.plotStyle);
                break;
            }
            case 1300: {
                rc = this.drawSpiral;
                break;
            }
            case 1301: {
                rc = this.drawAxes;
                break;
            }
            case 1307: {
                rc = this.drawSpiralLabels;
                break;
            }
            case 1308: {
                rc = this.drawAxisLabels;
                break;
            }
            case 1500: {
                rc = new Integer(this.mathOp);
                break;
            }
            case 1200: {
                rc = new Integer(this.responseBaselineRule);
                break;
            }
            case 1303: {
                rc = new Integer((int)this.radiusBase);
                break;
            }
            case 1305: {
                rc = new Double(this.radiusDeltaMax);
                break;
            }
            case 1304: {
                rc = new Integer((int)this.radiusSpacing);
                break;
            }
            case 1306: {
                rc = new Integer(this.revolutionAngle);
                break;
            }
            case 1302: {
                rc = new Integer(this.numberOfAxes);
                break;
            }
            case 1310: {
                rc = new Integer(this.needleWidth);
                break;
            }
            case 1309: {
                rc = this.needleAA;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        this.needToAnalyze = true;
        switch (key) {
            case 1301: {
                if (value == null) break;
                this.drawAxes = (Boolean)value;
                break;
            }
            case 1300: {
                if (value == null) break;
                this.drawSpiral = (Boolean)value;
                break;
            }
            case 1307: {
                if (value == null) break;
                this.drawSpiralLabels = (Boolean)value;
                break;
            }
            case 1308: {
                if (value == null) break;
                this.drawAxisLabels = (Boolean)value;
                break;
            }
            case 1309: {
                if (value == null) break;
                this.needleAA = (Boolean)value;
                break;
            }
            case 1001: {
                if (value == null) break;
                this.period = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1500: {
                if (value == null) break;
                this.mathOp = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1401: {
                if (value == null) break;
                this.bucket = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1100: {
                if (value == null) break;
                this.plotStyle = ((Number)value).intValue();
                break;
            }
            case 1200: {
                if (value == null) break;
                this.responseBaselineRule = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1303: {
                if (value == null) break;
                this.radiusBase = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1305: {
                if (value == null) break;
                double request = this.radiusSpacing * ((Number)value).doubleValue();
                this.radiusDeltaMax = request > 1.0 ? 1.0 : (request < 0.0 ? 0.0 : request);
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1304: {
                if (value == null) break;
                this.radiusSpacing = ((Number)value).doubleValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1306: {
                if (value == null) break;
                this.revolutionAngle = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 1302: {
                if (value == null) break;
                this.numberOfAxes = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 19001: {
                if (value == null) break;
                this.applyStyleElement();
                break;
            }
            case 1310: {
                if (value == null) break;
                this.needleWidth = ((Number)value).intValue();
                this.lce.setAction(5);
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (rc) {
            this.applyStyleElement();
        }
        return rc;
    }

    protected void applyStyleElement() {
    }

    public boolean areMarkerOutlinesOn() {
        return this.markersOutlined;
    }

    public boolean isMarkerFilled() {
        return this.markersFilled;
    }

    public void setMarkerFilled(boolean fill) {
        if (this.markersFilled == fill) {
            return;
        }
        this.markersFilled = fill;
        this.userSetProperties.set(2017);
    }

    public void setMarkerOutlinesOn(boolean on) {
        if (this.markersOutlined == on) {
            return;
        }
        this.markersOutlined = on;
        this.userSetProperties.set(2018);
    }

    public boolean setMarkerShape(Object shape) {
        if (shape instanceof Number) {
            this.userSetProperties.set(2015);
            return true;
        }
        return false;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        this.needToAnalyze = true;
    }
}

