/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.FilterPickInterface;
import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.sort.SortContextFactory;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.scatter.ScatterDefaults;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.geom.GeneralPath;
import java.util.HashMap;
import java.util.Vector;

public class SeriesElement
extends BaseElement {
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber groupIndexRole = null;
    private double[] projectValues = new double[3];
    SortContext sort = null;
    protected static final int MAX_RESPONSES = 100;
    protected Vector yVars = null;
    protected FilterPickInterface pickInterface = null;
    protected Rectangle pickArea = null;
    protected String currentLegend = null;
    protected ScatterDefaults scatterDefaults = new ScatterDefaults();
    public static final int[] supportedSeriesProperties = new int[]{24, 25, 23, 433, 427, 434, 441};

    public SeriesElement() {
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 100);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.groupIndexRole = this.role.getRoleObject("ROLE_GROUP_INDEX");
        this.roles.newRole((Object)this.groupIndexRole, "Group Index", 1);
        this.roles.setRoleType((Object)this.groupIndexRole, 1);
        this.setSupportedProperties(supportedSeriesProperties);
        this.userSetProperties.appendProperties(supportedSeriesProperties);
        this.addChartTabInfo("com.sas.graphics.silk.ui.BaseScatterPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseScatterElement.Scatter.txt", (String)"Scatter"));
    }

    protected Object getLegendTitle(String currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend)) {
            return this.roles.getVariable((Object)this.groupRole, 0);
        }
        if (this.yRole.toString().equalsIgnoreCase(currentLegend)) {
            return this.yRole.toString();
        }
        return null;
    }

    protected boolean isContinuousLegend(String currentLegend) {
        return false;
    }

    protected Object getLegendEntries(String currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        int groupIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupIndexRole, 0));
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        Object[] subsetGroupValues = this.fetchUniqueValues(groupVarIndex, true);
        Color[] dataColors = this.style.getDataFillColors();
        Color[] lineColors = this.style.getDataLineColors();
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend)) {
            int i;
            if (groupVar == null) {
                return null;
            }
            if (allGroupValues == null || subsetGroupValues == null) {
                return null;
            }
            HashMap<Object, Number> groupIndexMap = new HashMap<Object, Number>();
            if (groupIndexVarIndex >= 0) {
                for (i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                    double gi;
                    Object group = this.filter.getValue(groupVarIndex, (long)i, this.sort);
                    if (!groupIndexMap.containsKey(group) && (gi = this.filter.getNumericValue(groupIndexVarIndex, (long)i, this.sort)) >= 0.0) {
                        groupIndexMap.put(group, new Double(gi));
                    }
                    if (groupIndexMap.size() != allGroupValues.length) {
                        continue;
                    }
                    break;
                }
            } else {
                for (i = 0; i < allGroupValues.length; ++i) {
                    groupIndexMap.put(allGroupValues[i], new Integer(i));
                }
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(subsetGroupValues.length);
            for (int i2 = 0; i2 < subsetGroupValues.length; ++i2) {
                Color color = Color.black;
                int groupIndex = -1;
                Object o = null;
                if (subsetGroupValues[i2] != null) {
                    o = groupIndexMap.get(subsetGroupValues[i2]);
                }
                if (o != null) {
                    groupIndex = ((Number)o).intValue();
                }
                if (groupIndex >= 0) {
                    if (dataColors != null) {
                        color = dataColors[groupIndex % dataColors.length];
                    }
                } else {
                    color = this.style.getLineStyleElement("Outlines").getLineColor();
                }
                LineAttrib ls = new LineAttrib(true, color, 1);
                legendEntries.add(new LegendEntry(subsetGroupValues[i2], null, ls));
            }
            return legendEntries;
        }
        if (this.yRole.toString().equalsIgnoreCase(currentLegend)) {
            Object yVars = this.roles.getAllVariables((Object)this.yRole);
            if (yVars == null) {
                return null;
            }
            int type = Extract.getSourceType((Object)yVars);
            int num = Extract.getNumberItems((Object)yVars, (int)type);
            if (num < 2) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(num);
            for (int i = 0; i < num; ++i) {
                Object yVar = Extract.getObject((Object)yVars, (int)i, (int)type);
                if (yVar == null) continue;
                Object desc = this.filter.getVariableDescription(yVar);
                Color color = Color.black;
                LineAttrib ls = new LineAttrib();
                if (subsetGroupValues != null) {
                    ls.setColor(color);
                } else {
                    if (lineColors != null) {
                        color = lineColors[i % lineColors.length];
                    }
                    ls.setColor(color);
                }
                legendEntries.add(new LegendEntry(desc, null, ls));
            }
            return legendEntries;
        }
        return null;
    }

    protected void setRole(RoleEvent e) {
        Object var = null;
        switch (e.role) {
            case 25: {
                if (this.yVars == null) {
                    this.yVars = new Vector();
                }
                this.yVars.removeAllElements();
                var = this.roles.getVariable((Object)this.yRole);
                int varType = Extract.getSourceType((Object)var);
                int numResponse = Extract.getNumberItems((Object)var, (int)varType);
                for (int i = 0; i < numResponse; ++i) {
                    Object v = Extract.getObject((Object)var, (int)i, (int)varType);
                    this.yVars.add(v);
                }
                break;
            }
            case 6: {
                this.lce.setAction(4);
                this.lce.setBuildData(this.groupRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                this.lce.setAction(1);
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        Object var = null;
        switch (e.role) {
            case 25: {
                if (this.yVars == null) {
                    this.yVars = new Vector();
                }
                this.yVars.removeAllElements();
                var = this.roles.getVariable((Object)this.yRole);
                int varType = Extract.getSourceType((Object)var);
                int numResponse = Extract.getNumberItems((Object)var, (int)varType);
                for (int i = 0; i < numResponse; ++i) {
                    Object v = Extract.getObject((Object)var, (int)i, (int)varType);
                    this.yVars.add(v);
                }
                break;
            }
        }
    }

    private int getGroupIndex(int obs, int groupVarIndex, int groupIndexVarIndex) {
        if (this.filter == null) {
            return -1;
        }
        Object value = null;
        if (groupVarIndex >= 0) {
            value = this.filter.getValue(groupVarIndex, (long)obs, this.sort);
        }
        if (value == null) {
            return -1;
        }
        Object[] groupValues = this.fetchUniqueValues(groupVarIndex, false);
        if (groupValues != null) {
            if (groupIndexVarIndex >= 0) {
                double idx = this.filter.getNumericValue(groupIndexVarIndex, (long)obs, this.sort);
                if (idx >= 0.0) {
                    return (int)idx;
                }
            } else {
                for (int i = 0; i < groupValues.length; ++i) {
                    if (!value.equals(groupValues[i])) continue;
                    return i;
                }
            }
        }
        return -1;
    }

    protected Object[] fetchUniqueValues(int varIndex, boolean useSubset) {
        Object[] uniqueValues = null;
        if (varIndex >= 0 && this.infoFilter != null) {
            uniqueValues = this.infoFilter.getUniqueValues(this.filter.getVariableId(varIndex), useSubset);
        }
        return uniqueValues;
    }

    protected boolean isLegendValid(Object role) {
        Object o = null;
        o = this.getLegendEntries(role.toString());
        return o != null && o instanceof Vector && ((Vector)o).size() > 0;
    }

    protected String getTipText(int obs) {
        if (obs < 0 || obs > this.filter.getNumberObservations(-1)) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        sb.append(xVar);
        sb.append(" \t= \t ");
        sb.append(this.getFormattedValue(xVar, obs));
        for (int i = 0; i < this.yVars.size(); ++i) {
            sb.append("\n");
            Object yVar = this.yVars.elementAt(i);
            sb.append(yVar);
            sb.append(" \t= \t ");
            sb.append(this.getFormattedValue(yVar, obs));
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        if (groupVar != null) {
            sb.append("\n");
            sb.append(groupVar);
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(groupVar, obs));
        }
        return sb.toString();
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Vector<Object> v = new Vector<Object>();
        if (groupVar != null) {
            v.addElement(groupVar);
        }
        if (xVar != null) {
            v.addElement(xVar);
        }
        Object[] vars = new String[v.size()];
        v.copyInto(vars);
        this.sort = SortContextFactory.getSortContext((Object)this.filter.getSource(), (String[])vars, (int)1);
    }

    @Override
    protected void drawChart(Graphics g) {
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0) {
            return;
        }
        int[] yVarIndex = new int[this.yVars.size()];
        int validYVar = 0;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            ++validYVar;
        }
        if (validYVar <= 0) {
            return;
        }
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int groupIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupIndexRole, 0));
        Color[] lineColors = this.style.getDataLineColors();
        GeneralPath line = new GeneralPath();
        Color color = this.style.getLineStyleElement("Outlines").getLineColor();
        if (lineColors != null) {
            color = lineColors[0];
        }
        int thickness = 2;
        int pattern = 1;
        for (int i = 0; i < yVarIndex.length; ++i) {
            int lastGroup = -999;
            pattern = (i + 1) % 46;
            if (yVarIndex.length > 1 && lineColors != null) {
                color = lineColors[i % lineColors.length];
            }
            for (int j = 0; j < this.filter.getNumberObservations(-1); ++j) {
                int group = -1;
                if (groupVarIndex >= 0) {
                    group = this.getGroupIndex(j, groupVarIndex, groupIndexVarIndex);
                }
                double xValue = this.filter.getNumericValue(xVarIndex, (long)j, this.sort);
                double yValue = this.filter.getNumericValue(yVarIndex[i], (long)j, this.sort);
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                if (lastGroup >= 0) {
                    color = lineColors[lastGroup % lineColors.length];
                }
                if (group != lastGroup) {
                    if (group >= 0 && lastGroup >= 0) {
                        this.drawLine(g, line, color, thickness, pattern);
                    }
                    line.reset();
                    line.moveTo((float)this.projectValues[0], (float)this.projectValues[1]);
                    lastGroup = group;
                    continue;
                }
                line.lineTo((float)this.projectValues[0], (float)this.projectValues[1]);
            }
            this.drawLine(g, line, color, thickness, pattern);
        }
    }

    private void drawLine(Graphics g, GeneralPath line, Color color, int thickness, int linePattern) {
        g.setColor(color);
        if (linePattern > 1 && g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)linePattern, (int)thickness));
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(2.0f, 1, 1));
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).draw(line);
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        double[] pv1 = new double[3];
        double[] pv2 = new double[3];
        pv1 = this.transformObject.unProject(selectArea.x - 2, selectArea.y + selectArea.height + 2, 0.0, pv1);
        pv2 = this.transformObject.unProject(selectArea.x + selectArea.width + 2, selectArea.y - 2, 0.0, pv2);
        double minX = Math.min(pv1[0], pv2[0]);
        double maxX = Math.max(pv1[0], pv2[0]);
        double minY = Math.min(pv1[1], pv2[1]);
        double maxY = Math.max(pv1[1], pv2[1]);
        ContinuousRange[] ranges = new ContinuousRange[]{new ContinuousRange(minX, maxX), new ContinuousRange(minY, maxY)};
        String[] vars = new String[2];
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return false;
        }
        vars[0] = xVar.toString();
        for (int j = 0; j < this.yVars.size(); ++j) {
            vars[1] = this.yVars.elementAt(j).toString();
            if (this.filter == null) continue;
            if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                ((AbstractDataFilter)this.filter).toggleSelected(vars, (DataRange[])ranges, false);
                continue;
            }
            this.filter.setSelected(vars, (DataRange[])ranges, select);
        }
        return true;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (this.pickArea == null) {
            this.pickArea = new Rectangle();
        }
        this.pickArea.x = screenX;
        this.pickArea.y = screenY;
        this.pickArea.width = 2;
        this.pickArea.height = 2;
        if (this.pickInterface == null) {
            return null;
        }
        double[] pv1 = new double[3];
        double[] pv2 = new double[3];
        pv1 = this.transformObject.unProject(this.pickArea.x, this.pickArea.y + this.pickArea.height, 0.0, pv1);
        pv2 = this.transformObject.unProject(this.pickArea.x + this.pickArea.width, this.pickArea.y, 0.0, pv2);
        double minX = Math.min(pv1[0], pv2[0]);
        double maxX = Math.max(pv1[0], pv2[0]);
        double minY = Math.min(pv1[1], pv2[1]);
        double maxY = Math.max(pv1[1], pv2[1]);
        ContinuousRange[] ranges = new ContinuousRange[]{new ContinuousRange(minX, maxX), new ContinuousRange(minY, maxY)};
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return null;
        }
        String[] vars = new String[2];
        vars[0] = xVar.toString();
        if (this.yVars == null) {
            return null;
        }
        for (int j = 0; j < this.yVars.size(); ++j) {
            vars[1] = this.yVars.elementAt(j).toString();
            int index = this.pickInterface.pickFirst(vars, (DataRange[])ranges);
            if (index < 0) continue;
            return this.getTipText(index);
        }
        return null;
    }

    @Override
    public void dispose() {
        this.xRole = null;
        this.yRole = null;
        this.groupRole = null;
        this.groupIndexRole = null;
        this.projectValues = null;
        if (this.yVars != null) {
            this.yVars.removeAllElements();
        }
        this.yVars = null;
        this.pickInterface = null;
        this.pickArea = null;
        this.currentLegend = null;
        this.scatterDefaults = null;
        super.dispose();
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object[] rc = null;
        switch (id) {
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (!this.groupRole.toString().equalsIgnoreCase(this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.groupRole, 0);
                break;
            }
            case 24: 
            case 25: {
                Vector<String> legNames = new Vector<String>();
                if (this.isLegendValid((Object)this.groupRole)) {
                    legNames.add(this.groupRole.toString());
                }
                if (this.isLegendValid((Object)this.yRole)) {
                    legNames.add(this.yRole.toString());
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 427: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = new Boolean(this.isContinuousLegend(this.currentLegend));
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                String leg;
                if (value == null || !(leg = value.toString()).equalsIgnoreCase(this.groupRole.toString()) && !leg.equalsIgnoreCase(this.yRole.toString())) break;
                this.currentLegend = leg;
                return true;
            }
        }
        return rc;
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        Object o;
        boolean rc = super.setDataSource(source, id);
        if (this.filter != null && (o = this.filter.getAdapter(FilterPickInterface.class)) instanceof FilterPickInterface) {
            this.pickInterface = (FilterPickInterface)o;
        }
        return rc;
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        boolean rc = super.setColorScheme(newScheme);
        return rc;
    }

    protected boolean isGroupRoleSet() {
        if (this.filter == null) {
            return false;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        return groupVar != null && this.filter.getVariableIndex(groupVar) >= 0;
    }

    protected int getNumberYVars() {
        Object yVars = this.roles.getAllVariables((Object)this.yRole);
        return Extract.getNumberItems((Object)yVars, (int)Extract.getSourceType((Object)yVars));
    }
}

