/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.data.FilterPickInterface;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.BaseScatterInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.scatter.ScatterDefaults;
import com.sas.graphics.silk.ui.BaseScatterPanel;
import com.sas.graphics.silk.ui.TabPanelInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.MarkerRenderer;
import com.sas.graphics.silk.util.MarkerShapeOption;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.Extract;
import com.sas.graphics.util.HTMLColors;
import com.sas.graphics.util.Markers;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.Vector;

public class ScatterElement
extends BaseElement
implements BaseScatterInterface {
    private static final int INTERNAL_GAP = 2;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber groupIndexRole = null;
    protected SILKNumber colorRole = null;
    protected SILKNumber tipRole = null;
    protected SILKNumber dataLabelRole = null;
    protected double[] projectValues = new double[3];
    protected int markerSize = 5;
    protected int halfMarkerSize = this.markerSize / 2;
    private Color markerColor;
    private Color markerOutlineColor;
    private Color defaultOutlineColor;
    private boolean markersFilled;
    protected boolean markersOutlined;
    protected static final int MAX_RESPONSES = 100;
    protected Vector yVars = new Vector();
    protected FilterPickInterface pickInterface = null;
    protected Rectangle pickArea = null;
    protected SILKNumber currentLegend = null;
    protected ScatterDefaults scatterDefaults = null;
    protected MarkerShapeOption[] supportedMarkersShapes = null;
    protected HashMap groupIndexMap = null;
    protected CharacterVariableMapper xCharMapper = null;
    protected CharacterVariableMapper yCharMapper = null;
    protected TabPanelInterface scatterPanel = null;
    protected static final int ADD_SORTABLE_ROLE = 1;
    protected static final int REMOVE_SORTABLE_ROLE = 2;
    protected Vector sortableRoles = null;
    protected int[] sortableDirections = new int[]{1, 0, -1};
    protected BaseScatterPanel panel = null;
    protected boolean showMarkers = true;
    private int ANTI_ALIAS_THRESHOLD = 500;
    public static final int[] supportedScatterProperties = new int[]{24, 25, 23, 433, 426, 434, 441, 2036, 2070, 2006, 2007, 2008, 2009, 2012, 2043, 2073, 2013, 2074, 2019, 2015, 2017, 2018, 2005, 2058, 2037, 19055, 19054};
    protected int compWidth;
    protected int compHeight;
    long buildAttribInitTime = 0L;
    long buildAttribIfs = 0L;
    long setColors = 0L;
    long getStyleElementTime = 0L;

    public ScatterElement() {
        this.scatterDefaults = new ScatterDefaults();
        this.scatterDefaults.autoSizeMarkers = !SILKGlobal.isFlagSet(4);
        this.ANTI_ALIAS_THRESHOLD = this.scatterDefaults.antiAliasThreshold;
        this.sortableRoles = new Vector();
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.roles.setSortsSupported((Object)this.xRole, this.sortableDirections);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 100);
        this.roles.setRoleType((Object)this.yRole, 0);
        this.roles.setSortsSupported((Object)this.yRole, this.sortableDirections);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1, null, this.scatterDefaults.maxGroups);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.groupIndexRole = this.role.getRoleObject("ROLE_GROUP_INDEX");
        this.roles.newRole((Object)this.groupIndexRole, "Group Index", 1);
        this.roles.setRoleType((Object)this.groupIndexRole, 1);
        this.colorRole = this.role.getRoleObject("ROLE_COLOR");
        this.roles.newRole((Object)this.colorRole, "Color", 1);
        this.roles.setRoleType((Object)this.colorRole, 1);
        this.tipRole = this.role.getRoleObject("ROLE_TIP");
        this.roles.newRole((Object)this.tipRole, "Tip", 10);
        this.roles.setRoleType((Object)this.tipRole, 0);
        if (!this.userSetProperties.get(0)) {
            this.markersFilled = true;
            this.markersOutlined = true;
        }
        this.setSupportedProperties(supportedScatterProperties);
        this.userSetProperties.appendProperties(supportedScatterProperties);
        this.actions.put("EXCLUSIVE_SELECT", Boolean.FALSE);
        this.addChartTabInfo("com.sas.graphics.silk.ui.BaseScatterPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseScatterElement.Scatter.txt", (String)"Scatter"));
        this.initMarkerShapeList();
    }

    private void initMarkerShapeList() {
        this.supportedMarkersShapes = new MarkerShapeOption[2];
        this.supportedMarkersShapes[0] = new MarkerShapeOption(3, ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseScatterElement.MarkerShape.Square.txt", (String)"Square"), false);
        this.supportedMarkersShapes[1] = new MarkerShapeOption(19, ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseScatterElement.MarkerShape.FilledSquare.txt", (String)"Filled Square"), true);
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        CharacterVariableMapper charMapper = null;
        if (1 == dim && range instanceof DiscreteRange) {
            charMapper = this.xCharMapper;
        } else if (2 == dim && range instanceof DiscreteRange) {
            charMapper = this.yCharMapper;
        }
        if (charMapper != null) {
            DiscreteRange dr = (DiscreteRange)range;
            Vector values = dr.getValues();
            int size = values.size();
            charMapper.removeAllValues();
            for (int catIndex = 0; catIndex < size; ++catIndex) {
                charMapper.addValue(values.elementAt(catIndex));
            }
        }
    }

    protected Object getLegendTitle(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.groupRole, 0));
        }
        if (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.filter.getVariableDescription(this.roles.getVariable((Object)this.colorRole, 0));
        }
        if (this.yRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.yRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return this.yRole.toString();
        }
        return null;
    }

    protected boolean isContinuousLegend(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return false;
        }
        if (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return false;
        }
        if (this.yRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.yRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) {
            return false;
        }
        return this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName());
    }

    protected LineAttrib getLineStyle(Object yVar, Object group) {
        return null;
    }

    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        Object[] subsetGroupValues = this.fetchUniqueValues(groupVarIndex, true);
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = this.filter.getVariableIndex(colorVar);
        boolean statGraphCompat = SILKGlobal.isFlagSet(4);
        if (this.groupRole != null && (this.groupRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName()))) {
            if (groupVar == null) {
                return null;
            }
            if (allGroupValues == null || subsetGroupValues == null) {
                return null;
            }
            this.buildGroupIndexMap();
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(subsetGroupValues.length);
            Object yVar = null;
            if (this.yVars != null && this.yVars.size() > 0) {
                yVar = this.yVars.elementAt(0);
            }
            for (int i = 0; i < subsetGroupValues.length; ++i) {
                int mrkrShape = this.getMarkerShapeEnum();
                Color color = this.markerColor;
                Color outlineColor = this.markerOutlineColor;
                int groupIndex = -1;
                Object o = null;
                if (subsetGroupValues[i] != null) {
                    o = this.groupIndexMap.get(subsetGroupValues[i]);
                }
                if (o != null) {
                    groupIndex = ((Number)o).intValue();
                }
                if (groupIndex >= 0) {
                    String groupValue = subsetGroupValues[i].toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(groupValue, groupIndex, 2, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
                    color = dse.getFillColor();
                    outlineColor = dse.getLineColor();
                    if (statGraphCompat) {
                        mrkrShape = dse.getMarkerSymbol();
                    }
                } else {
                    color = this.style.getDataStyleElement("Missing").getFillColor();
                    outlineColor = this.style.getDataStyleElement("Missing").getLineColor();
                }
                MarkerAttrib ms = null;
                if (this.showMarkers) {
                    ms = new MarkerAttrib(true, color);
                    ms.setShape(new Integer(mrkrShape));
                    ms.setFilled(this.isMarkerFilled());
                    ms.setOutline(new Boolean(this.areMarkerOutlinesOn()));
                    ms.setOutline(outlineColor);
                }
                legendEntries.add(new LegendEntry(subsetGroupValues[i], ms, this.getLineStyle(yVar, subsetGroupValues[i])));
            }
            return legendEntries;
        }
        if (this.yRole != null && (this.yRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.yRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName()))) {
            Object yVars = this.roles.getAllVariables((Object)this.yRole);
            if (yVars == null) {
                return null;
            }
            int type = Extract.getSourceType((Object)yVars);
            int num = Extract.getNumberItems((Object)yVars, (int)type);
            if (num < 2) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(num);
            for (int i = 0; i < num; ++i) {
                DataStyleElement dse;
                String yId;
                int mrkrShape = this.getMarkerShapeEnum();
                Object yVar = Extract.getObject((Object)yVars, (int)i, (int)type);
                if (yVar == null) continue;
                Object desc = this.filter.getVariableDescription(yVar);
                Color color = this.markerColor;
                Color outlineColor = this.markerOutlineColor;
                MarkerAttrib ms = new MarkerAttrib();
                if (subsetGroupValues != null || colorVarIndex >= 0) {
                    yId = yVar.toString();
                    dse = SILKUtilities.getStyleElement(yId, i, 1, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
                    ms.setColor(this.markerColor);
                    dse = SILKUtilities.getStyleElement(yId, i, 1, this.style, this.markerAttrs, null).getAsDataStyle();
                    ms.setShape(new Integer(dse.getMarkerSymbol()));
                } else {
                    yId = yVar.toString();
                    dse = SILKUtilities.getStyleElement(yId, i, 1, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
                    color = dse.getFillColor();
                    outlineColor = dse.getLineColor();
                    if (statGraphCompat) {
                        mrkrShape = dse.getMarkerSymbol();
                    }
                    ms.setColor(color);
                    ms.setShape(new Integer(mrkrShape));
                }
                ms.setFilled(this.isMarkerFilled());
                ms.setOutline(new Boolean(this.areMarkerOutlinesOn()));
                ms.setOutline(outlineColor);
                if (!this.showMarkers) {
                    ms = null;
                }
                legendEntries.add(new LegendEntry(desc, ms, this.getLineStyle(yVar, null)));
            }
            return legendEntries;
        }
        if (this.colorRole != null && (this.colorRole.toString().equalsIgnoreCase(currentLegend.toString()) || this.colorRole.getEnglishName().equalsIgnoreCase(currentLegend.getEnglishName())) && colorVarIndex >= 0) {
            if (this.colorMapper == null) {
                this.initColorRamp();
            }
            if (this.colorMapper == null) {
                return null;
            }
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            ContinuousRange r = (ContinuousRange)this.getDataRange((byte)4, false);
            Color c = this.colorMapper.getColor(r.getMin());
            double cv = r.getMin();
            MarkerAttrib msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            c = this.colorMapper.getNeutralColor();
            if (c != null && r.contains((DataPoint)new ContinuousPoint(this.colorMapper.getNeutralValue()))) {
                cv = this.colorMapper.getNeutralValue();
                msi = new MarkerAttrib(true, c);
                legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            }
            c = this.colorMapper.getColor(r.getMax());
            cv = r.getMax();
            msi = new MarkerAttrib(true, c);
            legendEntries.addElement(new LegendEntry(new Double(cv), msi, null));
            return legendEntries;
        }
        return null;
    }

    protected void setRole(RoleEvent e) {
        Object var = null;
        switch (e.role) {
            case 24: {
                if (this.filter == null) break;
                if (this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0)) && !this.isDiscrete((Object)this.xRole)) {
                    if (this.xCharMapper != null) {
                        this.xCharMapper.removeAllValues();
                        this.xCharMapper.dispose();
                    }
                    this.xCharMapper = null;
                    this.updateSortableRoles(this.xRole, 2);
                    break;
                }
                if (this.xCharMapper == null) {
                    this.xCharMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.xRole, 0));
                } else {
                    this.xCharMapper.setVariable(this.roles.getVariable((Object)this.xRole, 0));
                }
                this.updateSortableRoles(this.xRole, 1);
                break;
            }
            case 25: {
                if (this.yVars == null) {
                    this.yVars = new Vector();
                }
                if (this.filter != null && !this.filter.isNumericVariable(e.newValue)) {
                    if (e.type == 2) {
                        Object charVar = e.newValue;
                        var = this.roles.getVariable((Object)this.yRole);
                        int varType = Extract.getSourceType((Object)var);
                        int numResponse = Extract.getNumberItems((Object)var, (int)varType);
                        for (int i = 0; i < numResponse; ++i) {
                            Object v = Extract.getObject((Object)var, (int)i, (int)varType);
                            if (v == null || v.equals(charVar)) continue;
                            this.roles.removeRole(v, (Object)this.yRole);
                        }
                    }
                    this.roles.setMaxAllowed((Object)this.yRole, 1);
                } else {
                    this.roles.setMaxAllowed((Object)this.yRole, 100);
                }
                this.yVars.removeAllElements();
                var = this.roles.getVariable((Object)this.yRole);
                int varType = Extract.getSourceType((Object)var);
                int numResponse = Extract.getNumberItems((Object)var, (int)varType);
                for (int i = 0; i < numResponse; ++i) {
                    Object v = Extract.getObject((Object)var, (int)i, (int)varType);
                    this.yVars.add(v);
                }
                if (numResponse == 1 && this.filter != null && !this.filter.isNumericVariable(this.yVars.elementAt(0))) {
                    if (this.yCharMapper == null) {
                        this.yCharMapper = new CharacterVariableMapper(this.filter, this.yVars.elementAt(0));
                    } else {
                        this.yCharMapper.setVariable(this.yVars.elementAt(0));
                    }
                    this.updateSortableRoles(this.yRole, 1);
                    break;
                }
                if (this.yCharMapper == null) break;
                this.yCharMapper.removeAllValues();
                this.yCharMapper = null;
                this.updateSortableRoles(this.yRole, 2);
                break;
            }
            case 6: {
                this.groupIndexMap = null;
                this.lce.setAction(4);
                this.lce.setBuildData(this.groupRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                if (this.roles.getVariable((Object)this.colorRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.colorRole, 0), (Object)this.colorRole);
                }
                this.lce.setAction(1);
                break;
            }
            case 7: {
                this.groupIndexMap = null;
                break;
            }
            case 2: {
                this.initColorRamp();
                if (this.roles.getVariable((Object)this.groupRole, 0) != null) {
                    this.roles.removeRole(this.roles.getVariable((Object)this.groupRole, 0), (Object)this.groupRole);
                }
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 4));
                this.lce.setAction(4);
                this.lce.setBuildData(this.colorRole.toString());
                this.fireLayerListenerChanged(this.lce);
                this.lce.setBuildData(null);
                this.lce.setAction(1);
                break;
            }
            case 8: {
                this.calculateMarkerSize(this.compWidth, this.compHeight);
                if (this.scatterDefaults.autoSizeMarkers) break;
                this.adjustMarginForLabels();
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        Object var = null;
        switch (e.role) {
            case 25: {
                if (this.yVars == null) {
                    this.yVars = new Vector();
                }
                this.yVars.removeAllElements();
                var = this.roles.getVariable((Object)this.yRole);
                int varType = Extract.getSourceType((Object)var);
                int numResponse = Extract.getNumberItems((Object)var, (int)varType);
                for (int i = 0; i < numResponse; ++i) {
                    Object v = Extract.getObject((Object)var, (int)i, (int)varType);
                    this.yVars.add(v);
                }
                this.currentLegend = null;
                break;
            }
            case 2: {
                this.clearColorRamp();
                break;
            }
            case 6: 
            case 7: {
                this.groupIndexMap = null;
                this.currentLegend = null;
            }
        }
    }

    protected void sortRole(RoleEvent e) {
        int sortOrder = 0;
        Object o = null;
        switch (e.role) {
            case 24: {
                o = this.roles.getSortOrder((Object)this.xRole);
                if (!(o instanceof Number)) break;
                sortOrder = ((Number)o).intValue();
                if (this.xCharMapper != null && this.xCharMapper.getSort() == sortOrder) {
                    return;
                }
                this.setSortOrderToCharMapper(this.xRole, this.xCharMapper, sortOrder);
                break;
            }
            case 25: {
                o = this.roles.getSortOrder((Object)this.yRole);
                if (!(o instanceof Number)) break;
                sortOrder = ((Number)o).intValue();
                if (this.yCharMapper != null && this.yCharMapper.getSort() == sortOrder) {
                    return;
                }
                this.setSortOrderToCharMapper(this.yRole, this.yCharMapper, sortOrder);
            }
        }
        this.fireLayerListenerChanged(7);
        this.fireLayerListenerChanged(3);
    }

    protected int getGroupIndex(int obs) {
        if (this.filter == null) {
            return -1;
        }
        String value = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)obs, null);
        if (value == null) {
            return -1;
        }
        return this.getGroupIndex(value);
    }

    protected int getGroupIndex(Object value) {
        if (this.groupIndexMap == null) {
            Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
            if (groupVar == null) {
                return -1;
            }
            this.buildGroupIndexMap();
        }
        if (this.groupIndexMap == null || value == null) {
            return -1;
        }
        Object o = this.groupIndexMap.get(value);
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return -1;
    }

    protected void buildGroupIndexMap() {
        if (this.filter == null || this.roles == null) {
            return;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        Object groupIndexVar = this.roles.getVariable((Object)this.groupIndexRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        int groupIndexVarIndex = this.filter.getVariableIndex(groupIndexVar);
        if (groupVarIndex < 0 || groupVar == null) {
            return;
        }
        if (this.groupIndexMap == null) {
            this.groupIndexMap = new HashMap();
        } else {
            this.groupIndexMap.clear();
        }
        Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
        if (allGroupValues == null) {
            return;
        }
        if (groupIndexVarIndex >= 0) {
            for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                double gi;
                String group = this.filter.getFormattedValue(groupVar, (long)i, null);
                if (!this.groupIndexMap.containsKey(group) && (gi = this.filter.getNumericValue(groupIndexVarIndex, (long)i)) >= 0.0) {
                    this.groupIndexMap.put(group, new Double(gi));
                }
                if (this.groupIndexMap.size() != allGroupValues.length) {
                    continue;
                }
                break;
            }
        } else {
            for (int i = 0; i < allGroupValues.length; ++i) {
                this.groupIndexMap.put(allGroupValues[i], new Integer(i));
            }
        }
    }

    protected Object[] fetchUniqueValues(int varIndex, boolean useSubset) {
        Object[] uniqueValues = null;
        if (varIndex >= 0 && this.infoFilter != null) {
            uniqueValues = this.infoFilter.getUniqueValues(this.filter.getVariableId(varIndex), useSubset);
        }
        return uniqueValues;
    }

    protected boolean isLegendValid(SILKNumber role) {
        if (role == null) {
            return false;
        }
        Object o = null;
        o = this.getLegendEntries(role);
        return o != null && o instanceof Vector && ((Vector)o).size() > 0;
    }

    protected String getTipText(int obs, boolean[] yvarindex) {
        Object dataLabelVar;
        Object colorVar;
        if (obs < 0 || obs > this.filter.getNumberObservations(-1)) {
            return null;
        }
        if (this.tipRoles != null && this.tipRoles.size() > 0) {
            return this.getCustomTipText(obs);
        }
        StringBuffer sb = new StringBuffer();
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        sb.append(this.filter.getVariableDescription(xVar));
        sb.append(" \t= \t ");
        sb.append(this.getFormattedValue(xVar, obs));
        for (int i = 0; i < this.yVars.size(); ++i) {
            if (!yvarindex[i]) continue;
            sb.append("\n");
            Object yVar = this.yVars.elementAt(i);
            sb.append(this.filter.getVariableDescription(yVar));
            sb.append(" \t= \t ");
            sb.append(this.getFormattedValue(yVar, obs));
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        if (groupVar != null) {
            sb.append("\n");
            sb.append(this.filter.getVariableDescription(groupVar));
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(groupVar, obs));
        }
        if ((colorVar = this.roles.getVariable((Object)this.colorRole, 0)) != null) {
            sb.append("\n");
            sb.append(this.filter.getVariableDescription(colorVar));
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(colorVar, obs));
        }
        if ((dataLabelVar = this.roles.getVariable((Object)this.dataLabelRole, 0)) != null) {
            sb.append("\n");
            sb.append(this.filter.getVariableDescription(dataLabelVar));
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(dataLabelVar, obs));
        }
        Object tipVars = this.roles.getAllVariables((Object)this.tipRole);
        int type = Extract.getSourceType((Object)tipVars);
        int n = Extract.getNumberItems((Object)tipVars, (int)type);
        for (int i = 0; i < n; ++i) {
            Object var = Extract.getObject((Object)tipVars, (int)i, (int)type);
            if (var == null) continue;
            sb.append("\n");
            sb.append(this.filter.getVariableDescription(var));
            sb.append(" \t=\t ");
            sb.append(this.getFormattedValue(var, obs));
        }
        return sb.toString();
    }

    public void calculateMarkerSize(int compWidth, int compHeight) {
        if (compHeight <= 0) {
            return;
        }
        this.compHeight = compHeight;
        this.compWidth = compWidth;
        if (!this.scatterDefaults.autoSizeMarkers) {
            return;
        }
        int oldSize = this.markerSize;
        int isize = (int)((double)compHeight * this.scatterDefaults.autoSizeFraction);
        isize = Math.max(isize, this.scatterDefaults.defaultMinMarkerSize);
        this.markerSize = (isize = Math.min(isize, this.scatterDefaults.defaultMaxMarkerSize)) % 2 == 0 ? isize - 1 : isize;
        this.halfMarkerSize = this.markerSize / 2;
        this.prefInnerMargin = new Insets(this.halfMarkerSize + 2, this.halfMarkerSize + 2, this.halfMarkerSize + 2, this.halfMarkerSize + 2);
        this.adjustMarginForLabels();
        if (oldSize != isize) {
            this.fireLayerListenerChanged(3);
        }
    }

    private void adjustMarginForLabels() {
        if (this.filter != null) {
            int dataLabelVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.dataLabelRole, 0));
            if (dataLabelVarIndex >= 0) {
                TextStyleElement selem = this.getDataLabelStyle().getAsTextStyle();
                int size = selem.getFont().getSize();
                this.prefInnerMargin.bottom += size + 2;
                this.prefInnerMargin.top += size + 2;
                this.prefInnerMargin.left += size + 2;
                this.prefInnerMargin.right += size + 2;
            } else {
                this.prefInnerMargin = new Insets(this.halfMarkerSize + 2, this.halfMarkerSize + 2, this.halfMarkerSize + 2, this.halfMarkerSize + 2);
            }
        }
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
                break;
            }
            case 5: {
                this.sortRole(e);
            }
        }
    }

    protected MarkerAttrib getDefaultMarkerAttrib(StyleElement se) {
        MarkerAttrib rc = new MarkerAttrib();
        DataStyleElement dse = se.getAsDataStyle();
        rc.setColor(SILKGlobal.isFlagSet(4) ? dse.getLineColor() : dse.getFillColor());
        rc.setOutline(dse.getLineColor());
        rc.setOutline(new Boolean(this.areMarkerOutlinesOn()));
        rc.setShape(dse.getMarkerSymbol());
        return rc;
    }

    @Override
    protected void drawChart(Graphics g) {
        long t1 = System.currentTimeMillis();
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0) {
            return;
        }
        int numYVars = this.yVars.size();
        int[] yVarIndex = new int[this.yVars.size()];
        boolean validYVar = false;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            validYVar = true;
        }
        if (!validYVar) {
            return;
        }
        Object renderingHint = null;
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (this.filter.getNumberObservations(-1) > this.ANTI_ALIAS_THRESHOLD) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = this.filter.getVariableIndex(colorVar);
        int markerOutlineWidth = 1;
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        double x = 0.0;
        double y = 0.0;
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex) && !this.isDiscrete((Object)this.xRole);
        boolean yIsNum = this.filter.isNumericVariable(this.yVars.elementAt(0));
        StyleElement se = SILKUtilities.getStyleElement(this.roles.getVariable((Object)this.yRole, 0).toString(), -1, 1, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false));
        DataStyleElement defaultElement = se.getAsDataStyle();
        MarkerAttrib ma = new MarkerAttrib();
        MarkerAttrib dma = numYVars == 1 && groupVar == null && colorVar == null ? this.getDefaultMarkerAttrib(se) : null;
        DataStyleElement missingElement = this.style.getDataStyleElement("Missing");
        Color missingFillColor = missingElement.getFillColor();
        Color missingLineColor = missingElement.getLineColor();
        int mShape = this.getMarkerShapeEnum();
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            if (!this.filter.isGraphed((long)i) && this.croppedTransparency == 1.0) continue;
            double xValue = Double.NaN;
            xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)i) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)i, null));
            String groupValue = null;
            if (groupVarIndex >= 0) {
                groupValue = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)i, null);
            }
            double colorValue = Double.NaN;
            if (colorVarIndex >= 0) {
                colorValue = this.filter.getNumericValue(colorVarIndex, (long)i);
            }
            for (int j = 0; j < yVarIndex.length; ++j) {
                double yValue = Double.NaN;
                yValue = yIsNum ? this.filter.getNumericValue(yVarIndex[j], (long)i) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(0), (long)i, null));
                ma = dma != null ? dma : this.buildMarkerAttrib(ma, defaultElement, groupValue, this.yVars, j, colorValue, groupVar, colorVar, missingFillColor, missingLineColor, numYVars, mShape);
                if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                x = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                y = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                if (this.filter.isGraphed((long)i)) {
                    MarkerRenderer.drawStandardMarker(g, (int)x, (int)y, ma.getColor(), ma.getOutline().getColor(), ma.getShapeInt(), this.markersOutlined, this.markerSize, this.halfMarkerSize, markerOutlineWidth);
                    continue;
                }
                Color mc = new Color(ma.getColor().getRed(), ma.getColor().getGreen(), ma.getColor().getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
                Color oc = new Color(ma.getOutline().getColor().getRed(), ma.getOutline().getColor().getGreen(), ma.getOutline().getColor().getBlue(), (int)(this.croppedTransparency * 255.0));
                MarkerRenderer.drawStandardMarker(g, (int)x, (int)y, mc, oc, ma.getShapeInt(), this.markersOutlined, this.markerSize, this.halfMarkerSize, markerOutlineWidth);
            }
        }
        if (g2 != null && renderingHint != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
        long t2 = System.currentTimeMillis();
        if (SILKGlobal.isFlagSet(1)) {
            long numMarkers = this.filter.getNumberObservations(-1);
            double rate = t2 - t1 > 0L ? (double)(numMarkers / (t2 - t1)) : Double.NaN;
            System.out.println("ScatterElement: numMarkers=" + numMarkers + " size=" + this.markerSize + " time=" + (double)(t2 - t1) / 1000.0 + "sec rate=" + rate + "k/sec");
        }
    }

    protected MarkerAttrib buildMarkerAttrib(MarkerAttrib ma, DataStyleElement defaultElement, String groupValue, Vector yVars, int yVarIndex, double colorValue) {
        return this.buildMarkerAttrib(ma, defaultElement, groupValue, yVars, yVarIndex, colorValue, this.roles.getVariable((Object)this.groupRole, 0), this.roles.getVariable((Object)this.colorRole, 0), null, null, yVars.size(), this.getMarkerShapeEnum());
    }

    protected MarkerAttrib buildMarkerAttrib(MarkerAttrib ma, DataStyleElement defaultElement, String groupValue, Vector yVars, int yVarIndex, double colorValue, Object groupVar, Object colorVar, Color missingFillColor, Color missingLineColor, int numYVars, int mrkrShape) {
        long b1 = System.currentTimeMillis();
        int groupIndex = -1;
        if (groupValue != null) {
            groupIndex = this.getGroupIndex(groupValue);
        }
        if (yVars == null) {
            return null;
        }
        if (ma == null) {
            ma = new MarkerAttrib();
        }
        if (missingFillColor == null || missingLineColor == null) {
            DataStyleElement missingElement = this.style.getDataStyleElement("Missing");
            missingFillColor = missingElement.getFillColor();
            missingLineColor = missingElement.getLineColor();
        }
        Color color = this.markerColor;
        Color outlineColor = this.markerOutlineColor;
        Color mappedColor = null;
        boolean statGraphCompat = SILKGlobal.isFlagSet(4);
        long b2 = System.currentTimeMillis();
        this.buildAttribInitTime += b2 - b1;
        b1 = System.currentTimeMillis();
        if (numYVars > 1 && (groupVar != null || colorVar != null)) {
            String yId = yVars.get(yVarIndex).toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(yId, yVarIndex, 1, this.style, this.markerAttrs, null).getAsDataStyle();
            mrkrShape = dse.getMarkerSymbol();
            if (groupIndex >= 0) {
                dse = SILKUtilities.getStyleElement(groupValue, groupIndex, 2, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
                color = SILKGlobal.isFlagSet(4) ? dse.getLineColor() : dse.getFillColor();
                outlineColor = dse.getLineColor();
            } else {
                mappedColor = this.getMappedColor(colorValue);
                if (mappedColor != null) {
                    color = mappedColor;
                    outlineColor = this.getAutoOutlineColor(mappedColor);
                } else {
                    color = missingFillColor;
                    outlineColor = missingLineColor;
                }
            }
        } else if (numYVars > 1) {
            String yId = yVars.get(yVarIndex).toString();
            DataStyleElement dse = SILKUtilities.getStyleElement(yId, yVarIndex, 1, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
            color = SILKGlobal.isFlagSet(4) ? dse.getLineColor() : dse.getFillColor();
            outlineColor = dse.getLineColor();
            if (statGraphCompat) {
                mrkrShape = dse.getMarkerSymbol();
            }
        } else if (groupVar != null) {
            if (groupIndex >= 0) {
                long bt1 = System.currentTimeMillis();
                DataStyleElement dse = SILKUtilities.getStyleElement(groupValue, groupIndex, 2, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false)).getAsDataStyle();
                long bt2 = System.currentTimeMillis();
                this.getStyleElementTime += bt2 - bt1;
                color = SILKGlobal.isFlagSet(4) ? dse.getLineColor() : dse.getFillColor();
                outlineColor = dse.getLineColor();
                if (statGraphCompat) {
                    mrkrShape = dse.getMarkerSymbol();
                }
            } else {
                color = missingFillColor;
                outlineColor = missingLineColor;
            }
        } else if (colorVar != null) {
            mappedColor = this.getMappedColor(colorValue);
            if (mappedColor != null) {
                color = mappedColor;
                outlineColor = this.getAutoOutlineColor(mappedColor);
            } else {
                color = missingFillColor;
                outlineColor = missingLineColor;
            }
        } else {
            color = defaultElement.getLineColor();
            outlineColor = SILKGlobal.isFlagSet(4) ? defaultElement.getLineColor() : defaultElement.getFillColor();
        }
        b2 = System.currentTimeMillis();
        this.buildAttribIfs += b2 - b1;
        b1 = System.currentTimeMillis();
        ma.setColorObject(color);
        ma.setOutlineColor(outlineColor);
        ma.setShape(mrkrShape);
        b2 = System.currentTimeMillis();
        this.setColors += b2 - b1;
        return ma;
    }

    protected Color getAutoOutlineColor(Color markerColor) {
        return ColorUtilities.darker(markerColor, 0.2);
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        long st = System.currentTimeMillis();
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0) {
            return;
        }
        int numYVars = this.yVars.size();
        int[] yVarIndex = new int[this.yVars.size()];
        boolean validYVar = false;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            validYVar = true;
        }
        if (!validYVar) {
            return;
        }
        Object renderingHint = null;
        Graphics2D g2 = null;
        if (g instanceof Graphics2D) {
            g2 = (Graphics2D)g;
            renderingHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            if (this.filter.getNumberObservations(-1) > this.ANTI_ALIAS_THRESHOLD) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            }
        }
        Object colorVar = this.roles.getVariable((Object)this.colorRole, 0);
        int colorVarIndex = this.filter.getVariableIndex(colorVar);
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        int groupVarIndex = this.filter.getVariableIndex(groupVar);
        StyleElement se = SILKUtilities.getStyleElement(this.roles.getVariable((Object)this.yRole, 0).toString(), -1, 1, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false));
        DataStyleElement defaultElement = se.getAsDataStyle();
        DataStyleElement missingElement = this.style.getDataStyleElement("Missing");
        Color missingFillColor = missingElement.getFillColor();
        Color missingLineColor = missingElement.getLineColor();
        int markerOutlineWidth = 3;
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        double x = 0.0;
        double y = 0.0;
        int numSelected = 0;
        int mkrSize = this.markerSize;
        int halfMkrSize = this.halfMarkerSize;
        MarkerAttrib ma = new MarkerAttrib();
        MarkerAttrib dma = numYVars == 1 && groupVar == null && colorVar == null ? this.getDefaultMarkerAttrib(se) : null;
        int mShape = this.getMarkerShapeEnum();
        while (this.selections.hasMoreSelections()) {
            int index = this.selections.nextSelectedIndex();
            ++numSelected;
            if (!this.filter.isGraphed((long)index)) continue;
            double xValue = Double.NaN;
            xValue = this.filter.isNumericVariable(xVarIndex) && !this.isDiscrete((Object)this.xRole) ? this.filter.getNumericValue(xVarIndex, (long)index) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.roles.getVariable((Object)this.xRole, 0), (long)index, null));
            String groupValue = null;
            if (groupVarIndex >= 0) {
                groupValue = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)index, null);
            }
            double colorValue = Double.NaN;
            if (colorVarIndex >= 0) {
                colorValue = this.filter.getNumericValue(colorVarIndex, (long)index);
            }
            for (int j = 0; j < yVarIndex.length; ++j) {
                double yValue = Double.NaN;
                yValue = this.filter.isNumericVariable(this.yVars.elementAt(0)) ? this.filter.getNumericValue(yVarIndex[j], (long)index) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(0), (long)index, null));
                ma = dma != null ? dma : this.buildMarkerAttrib(ma, defaultElement, groupValue, this.yVars, j, colorValue, groupVar, colorVar, missingFillColor, missingLineColor, numYVars, mShape);
                if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                x = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                y = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                MarkerRenderer.drawStandardMarker(g, (int)x, (int)y, ma.getColor(), ma.getOutline().getColor(), ma.getShapeInt(), true, mkrSize, halfMkrSize, markerOutlineWidth);
            }
        }
        if (g2 != null && renderingHint != null) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, renderingHint);
        }
        long et = System.currentTimeMillis();
        if (SILKGlobal.isFlagSet(2)) {
            double rate = et - st > 0L ? (double)((long)numSelected / (et - st)) : Double.NaN;
            System.out.println("ScatterElement drawSelected: numMarkers=" + numSelected + " size=" + this.markerSize + " time=" + (double)(et - st) / 1000.0 + "sec rate=" + rate + "k/sec");
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        boolean extendedSelect = this.isExtendedSelectMode(event);
        if (selectRegion instanceof Rectangle) {
            int halfMkrSize;
            selectArea = (Rectangle)selectRegion;
            double[] pv1 = new double[3];
            double[] pv2 = new double[3];
            int mkrSize = (int)((double)this.markerSize * 2.0 / 3.0 + 0.5);
            int hms = halfMkrSize = mkrSize / 2;
            pv1 = this.transformObject.unProject(selectArea.x - hms, selectArea.y + selectArea.height + hms, 0.0, pv1);
            pv2 = this.transformObject.unProject(selectArea.x + selectArea.width + hms, selectArea.y - hms, 0.0, pv2);
            double minX = Math.min(pv1[0], pv2[0]);
            double maxX = Math.max(pv1[0], pv2[0]);
            double minY = Math.min(pv1[1], pv2[1]);
            double maxY = Math.max(pv1[1], pv2[1]);
            DataRange[] ranges = new DataRange[]{this.xCharMapper == null ? new ContinuousRange(minX, maxX) : this.getRangeForIndicies(minX, maxX, this.xCharMapper), this.yCharMapper == null ? new ContinuousRange(minY, maxY) : this.getRangeForIndicies(minY, maxY, this.yCharMapper)};
            String[] vars = new String[2];
            Object xVar = this.roles.getVariable((Object)this.xRole, 0);
            if (xVar == null) {
                return false;
            }
            vars[0] = xVar.toString();
            for (int j = 0; j < this.yVars.size(); ++j) {
                vars[1] = this.yVars.elementAt(j).toString();
                if (this.filter == null) continue;
                if (extendedSelect && this.filter instanceof AbstractDataFilter) {
                    ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, false);
                    continue;
                }
                this.filter.setSelected(vars, ranges, select);
            }
            return true;
        }
        if (selectRegion instanceof Shape) {
            Shape selectShape = (Shape)selectRegion;
            int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
            if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0) {
                return false;
            }
            int[] yVarIndex = new int[this.yVars.size()];
            boolean validYVar = false;
            for (int i = 0; i < yVarIndex.length; ++i) {
                yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
                if (yVarIndex[i] < 0) continue;
                validYVar = true;
            }
            if (!validYVar) {
                return false;
            }
            int maxValue = (int)Math.pow(2.0, 15.0) - 100;
            int minValue = -maxValue;
            double x = 0.0;
            double y = 0.0;
            boolean xIsNum = this.filter.isNumericVariable(xVarIndex) && !this.isDiscrete((Object)this.xRole);
            boolean yIsNum = this.filter.isNumericVariable(this.yVars.elementAt(0));
            Rectangle markerRectangle = new Rectangle();
            for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                if (!this.filter.isGraphed((long)i) && this.croppedTransparency == 1.0) continue;
                double xValue = Double.NaN;
                xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)i) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)i, null));
                for (int j = 0; j < yVarIndex.length; ++j) {
                    double yValue = Double.NaN;
                    yValue = yIsNum ? this.filter.getNumericValue(yVarIndex[j], (long)i) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(0), (long)i, null));
                    if (Double.isNaN(xValue) || Double.isNaN(yValue)) continue;
                    this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                    x = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                    y = Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                    markerRectangle.setBounds((int)x - this.halfMarkerSize, (int)y - this.halfMarkerSize, this.markerSize, this.markerSize);
                    if (!selectShape.intersects(markerRectangle)) continue;
                    this.filter.setSelected((long)i, true);
                }
            }
            return true;
        }
        return false;
    }

    private DataRange[] getDataRanges(int screenX, int screenY) {
        if (this.pickArea == null) {
            this.pickArea = new Rectangle();
        }
        this.pickArea.x = screenX - this.halfMarkerSize;
        this.pickArea.y = screenY - this.halfMarkerSize;
        this.pickArea.width = this.markerSize;
        this.pickArea.height = this.markerSize;
        double[] pv1 = new double[3];
        double[] pv2 = new double[3];
        pv1 = this.transformObject.unProject(this.pickArea.x, this.pickArea.y + this.pickArea.height, 0.0, pv1);
        pv2 = this.transformObject.unProject(this.pickArea.x + this.pickArea.width, this.pickArea.y, 0.0, pv2);
        double minX = Math.min(pv1[0], pv2[0]);
        double maxX = Math.max(pv1[0], pv2[0]);
        double minY = Math.min(pv1[1], pv2[1]);
        double maxY = Math.max(pv1[1], pv2[1]);
        DataRange[] ranges = new DataRange[]{this.filter.isNumericVariable(this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0))) ? new ContinuousRange(minX, maxX) : this.getRangeForIndicies(minX, maxX, this.xCharMapper), this.yVars.size() > 0 && this.filter.isNumericVariable(this.yVars.elementAt(0)) ? new ContinuousRange(minY, maxY) : this.getRangeForIndicies(minY, maxY, this.yCharMapper)};
        return ranges;
    }

    public int getObservationAt(int screenX, int screenY) {
        DataRange[] ranges = this.getDataRanges(screenX, screenY);
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return -1;
        }
        String[] vars = new String[2];
        vars[0] = xVar.toString();
        if (this.yVars == null) {
            return -1;
        }
        for (int j = 0; j < this.yVars.size(); ++j) {
            vars[1] = this.yVars.elementAt(j).toString();
            int index = this.pickInterface.pickFirst(vars, ranges);
            if (index < 0) continue;
            return index;
        }
        return -1;
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        int obs = this.getObservationAt(screenX, screenY);
        if (obs >= 0) {
            Object xVar = this.roles.getVariable((Object)this.xRole, 0);
            String[] vars = new String[2];
            vars[0] = xVar.toString();
            DataRange[] ranges = this.getDataRanges(screenX, screenY);
            boolean[] yvarindex = new boolean[this.yVars.size()];
            for (int j = 0; j < this.yVars.size(); ++j) {
                vars[1] = this.yVars.elementAt(j).toString();
                int index = this.pickInterface.pickFirst(vars, ranges);
                yvarindex[j] = index >= 0;
            }
            return this.getTipText(obs, yvarindex);
        }
        return null;
    }

    @Override
    public void dispose() {
        this.projectValues = null;
        this.markerColor = null;
        this.markerOutlineColor = null;
        if (this.yVars != null) {
            this.yVars.removeAllElements();
        }
        this.yVars = null;
        this.pickInterface = null;
        this.pickArea = null;
        this.currentLegend = null;
        this.scatterDefaults = null;
        if (this.scatterPanel != null) {
            this.scatterPanel.removePropertyListener(this);
        }
        if (this.sortableRoles != null) {
            this.sortableRoles.clear();
        }
        this.sortableRoles = null;
        this.supportedMarkersShapes = null;
        if (this.xCharMapper != null) {
            this.xCharMapper.dispose();
            this.xCharMapper = null;
        }
        if (this.yCharMapper != null) {
            this.yCharMapper.dispose();
            this.yCharMapper = null;
        }
        super.dispose();
        this.xRole = null;
        this.yRole = null;
        this.groupRole = null;
        this.groupIndexRole = null;
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties != null && this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 23: {
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (this.currentLegend == null) {
                    rc = null;
                    break;
                }
                if (this.groupRole.toString().equalsIgnoreCase(this.currentLegend.toString()) || this.groupRole.getEnglishName().equalsIgnoreCase(this.currentLegend.getEnglishName())) {
                    rc = this.roles.getVariable((Object)this.groupRole, 0);
                    break;
                }
                if (!this.colorRole.toString().equalsIgnoreCase(this.currentLegend.toString()) && !this.colorRole.getEnglishName().equalsIgnoreCase(this.colorRole.getEnglishName())) break;
                rc = this.roles.getVariable((Object)this.colorRole, 0);
                break;
            }
            case 24: 
            case 25: {
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                if (this.isLegendValid(this.groupRole)) {
                    legNames.add(this.groupRole);
                }
                if (this.isLegendValid(this.yRole)) {
                    legNames.add(this.yRole);
                }
                if (this.isLegendValid(this.colorRole)) {
                    legNames.add(this.colorRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 444: {
                rc = this.getOverlayLegendEntry();
                break;
            }
            case 433: {
                rc = this.getLegendEntries(this.currentLegend);
                break;
            }
            case 426: {
                rc = this.getLegendTitle(this.currentLegend);
                break;
            }
            case 441: {
                rc = new Boolean(this.isContinuousLegend(this.currentLegend));
                break;
            }
            case 2070: {
                rc = new Boolean(true);
                break;
            }
            case 2036: {
                rc = new Boolean(true);
                break;
            }
            case 2006: {
                rc = this.getMarkerSize();
                break;
            }
            case 2007: {
                rc = new Boolean(this.areMarkersAutoSized());
                break;
            }
            case 2008: {
                rc = new Integer(this.getMinimumMarkerSize());
                break;
            }
            case 2009: {
                rc = new Integer(this.getMaximumMarkerSize());
                break;
            }
            case 2012: {
                rc = new Boolean(this.isMarkerColorMapped());
                break;
            }
            case 2043: {
                rc = new Boolean(this.isMarkerShapeMapped());
                break;
            }
            case 2013: {
                rc = this.getMarkerColor();
                break;
            }
            case 2019: {
                rc = this.markerOutlineColor;
                break;
            }
            case 2034: {
                rc = new Boolean(true);
                break;
            }
            case 2015: {
                rc = this.getMarkerShapeEnum();
                break;
            }
            case 2017: {
                rc = new Boolean(this.isMarkerFilled());
                break;
            }
            case 2018: {
                rc = new Boolean(this.areMarkerOutlinesOn());
                break;
            }
            case 2005: {
                rc = this.isRoleSet((Object)this.groupRole) ? this.roles.getVariable((Object)this.groupRole, 0) : null;
                break;
            }
            case 2058: {
                rc = new Integer(this.getNumberYVars());
                break;
            }
            case 2037: {
                rc = this.supportedMarkersShapes;
                break;
            }
            case 2073: 
            case 2074: {
                rc = new Boolean(false);
                break;
            }
            case 19078: {
                if (this.roles.getVariable((Object)this.xRole, 0) != null && this.roles.getVariable((Object)this.yRole, 0) != null) {
                    rc = Boolean.TRUE;
                    break;
                }
                rc = Boolean.FALSE;
                break;
            }
            case 19079: {
                Vector<Integer> v = new Vector<Integer>();
                if (this.roles.getVariable((Object)this.xRole, 0) == null) {
                    v.addElement(new Integer(2));
                }
                if (this.roles.getVariable((Object)this.yRole, 0) == null) {
                    v.addElement(new Integer(3));
                }
                if (v.size() <= 0) break;
                int[] errIds = new int[v.size()];
                for (int i = 0; i < v.size(); ++i) {
                    errIds[i] = ((Number)v.elementAt(i)).intValue();
                }
                rc = errIds;
                break;
            }
            case 19089: {
                rc = Boolean.TRUE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = super.setPropertyValue(id, value);
        switch (id) {
            case 23: {
                String leg;
                if (value == null || !(leg = value.toString()).equalsIgnoreCase(this.groupRole.toString()) && !leg.equalsIgnoreCase(this.groupRole.getEnglishName()) && !leg.equalsIgnoreCase(this.yRole.toString()) && !leg.equalsIgnoreCase(this.yRole.getEnglishName()) && !leg.equalsIgnoreCase(this.colorRole.getEnglishName()) && !leg.equalsIgnoreCase(this.colorRole.toString())) break;
                if (value instanceof SILKNumber) {
                    this.currentLegend = (SILKNumber)((Object)value);
                }
                return true;
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 2006: {
                this.setMarkerSize(value);
                break;
            }
            case 2007: {
                if (!(value instanceof Boolean)) break;
                this.setAutoSizeMarkers((Boolean)value);
                break;
            }
            case 2013: {
                this.setMarkerColor(value);
                break;
            }
            case 2019: {
                this.setMarkerOutlineColor(value);
                break;
            }
            case 2015: {
                this.setMarkerShape(value);
                break;
            }
            case 2017: {
                if (!(value instanceof Boolean)) break;
                this.setMarkerFilled((Boolean)value);
                break;
            }
            case 2018: {
                if (!(value instanceof Boolean)) break;
                this.setMarkerOutlinesOn((Boolean)value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        Object o;
        boolean rc = super.setDataSource(source, id);
        if (this.filter != null && (o = this.filter.getAdapter(FilterPickInterface.class)) instanceof FilterPickInterface) {
            this.pickInterface = (FilterPickInterface)o;
        }
        return rc;
    }

    @Override
    public boolean setStyle(Object newStyle) {
        boolean rc = super.setStyle(newStyle);
        if (rc) {
            this.applyStyleElement();
        }
        return rc;
    }

    protected void applyStyleElement() {
        this.markerColor = this.style.getDataStyleElement(this.markerAttrs.getReference()).getFillColor();
        this.defaultOutlineColor = this.style.getLineStyleElement(this.markerAttrs.getReference()).getLineColor();
        if (this.defaultOutlineColor == null) {
            this.defaultOutlineColor = Color.black;
        }
        this.markerOutlineColor = this.defaultOutlineColor;
        DataStyleElement dse = this.style.getDataStyleElement(this.markerAttrs.getReference());
        int markerSymbol = dse.getMarkerSymbol();
        this.markersFilled = Markers.isFilled((int)markerSymbol);
        if (SILKGlobal.isFlagSet(4)) {
            int ms = dse.getMarkerSize().getSizeValue();
            int n = this.markerSize = ms % 2 == 0 ? ms - 1 : ms;
        }
        if (this.isRoleSet((Object)this.colorRole)) {
            this.initColorRamp();
        }
    }

    protected int getMinimumMarkerSize() {
        return this.scatterDefaults.defaultMinMarkerSize;
    }

    protected int getMaximumMarkerSize() {
        return this.scatterDefaults.defaultMaxMarkerSize;
    }

    protected int getNumberYVars() {
        Object yVars = this.roles.getAllVariables((Object)this.yRole);
        return Extract.getNumberItems((Object)yVars, (int)Extract.getSourceType((Object)yVars));
    }

    protected boolean isMarkerColorMapped() {
        return this.isRoleSet((Object)this.groupRole) || this.isRoleSet((Object)this.colorRole) || this.getNumberYVars() > 1;
    }

    protected boolean isMarkerShapeMapped() {
        return (this.isRoleSet((Object)this.groupRole) || this.isRoleSet((Object)this.colorRole)) && this.getNumberYVars() > 1;
    }

    @Override
    public Color getMarkerOutlineColor() {
        return this.getBasicStyleElement().getAsDataStyle().getLineColor();
    }

    @Override
    public boolean setMarkerOutlineColor(Object color) {
        if (color == null) {
            return false;
        }
        this.markerAttrs.getOverrides(true).setAttribute("altColor", HTMLColors.getColorString((Color)this.getColor(color)));
        this.markerAttrs.getOverrides(true).setAttribute("lineColor", HTMLColors.getColorString((Color)this.getColor(color)));
        return false;
    }

    @Override
    public boolean areMarkerOutlinesOn() {
        return this.markersOutlined;
    }

    @Override
    public Object getMarkerColor() {
        return this.getBasicStyleElement().getAsDataStyle().getFillColor();
    }

    @Override
    public boolean isMarkerFilled() {
        return this.markersFilled;
    }

    @Override
    public boolean setMarkerColor(Object color) {
        if (color == null) {
            return false;
        }
        this.markerAttrs.getOverrides(true).setAttribute("color", HTMLColors.getColorString((Color)this.getColor(color)));
        this.markerAttrs.getOverrides(true).setAttribute("markerColor", HTMLColors.getColorString((Color)this.getColor(color)));
        return true;
    }

    @Override
    public void setMarkerFilled(boolean fill) {
        if (this.markersFilled == fill) {
            return;
        }
        this.markersFilled = fill;
        this.userSetProperties.set(2017);
    }

    @Override
    public void setMarkerOutlinesOn(boolean on) {
        if (this.markersOutlined == on) {
            return;
        }
        this.markersOutlined = on;
        this.userSetProperties.set(2018);
    }

    @Override
    public Object getMarkerSize() {
        return new Integer(this.markerSize);
    }

    @Override
    public boolean setMarkerSize(Object value) {
        if (this.scatterDefaults.autoSizeMarkers) {
            return false;
        }
        if (value instanceof Number) {
            if (this.markerSize == ((Number)value).intValue()) {
                this.userSetProperties.set(2006);
                return true;
            }
            int ms = ((Number)value).intValue();
            this.markerSize = ms % 2 == 0 ? ms - 1 : ms;
            this.halfMarkerSize = this.markerSize / 2;
            this.prefInnerMargin = new Insets(this.halfMarkerSize + 2, this.halfMarkerSize + 2, this.halfMarkerSize + 2, this.halfMarkerSize + 2);
            this.layoutChart();
            this.userSetProperties.set(2006);
            this.adjustMarginForLabels();
            this.fireMarginChanged(new MarginChangeEvent((Object)this));
            return true;
        }
        return false;
    }

    @Override
    public String getMarkerShapeString() {
        return Markers.getShapeName((int)this.getMarkerShapeEnum());
    }

    @Override
    public Object getMarkerShape() {
        return new Integer(this.getMarkerShapeEnum());
    }

    public int getMarkerShapeEnum() {
        StyleElement lo = this.markerAttrs.getOverrides(false);
        if (lo != null && lo.hasAttribute("markerSymbol")) {
            return lo.getAsDataStyle().getMarkerSymbol();
        }
        return this.getBasicStyleElement().getAsDataStyle().getMarkerSymbol();
    }

    @Override
    public boolean setMarkerShape(Object shape) {
        if (shape instanceof Number) {
            this.markerAttrs.getOverrides(true).getAsDataStyle().setMarkerSymbol(((Number)shape).intValue());
            this.userSetProperties.set(2015);
            return true;
        }
        return false;
    }

    @Override
    public boolean areMarkersAutoSized() {
        return this.scatterDefaults.autoSizeMarkers;
    }

    @Override
    public void setAutoSizeMarkers(boolean auto) {
        boolean prevVal = this.scatterDefaults.autoSizeMarkers;
        if (this.scatterDefaults.autoSizeMarkers == auto) {
            return;
        }
        this.scatterDefaults.autoSizeMarkers = auto;
        this.userSetProperties.set(2007);
        if (!auto) {
            this.userSetProperties.set(2006);
        } else {
            this.userSetProperties.clear(2006);
        }
        if (auto && !prevVal) {
            this.calculateMarkerSize(this.compWidth, this.compHeight);
            this.fireMarginChanged(new MarginChangeEvent((Object)this));
        }
    }

    @Override
    public boolean areOutlinesAutoColored() {
        return true;
    }

    @Override
    public boolean setAutoColorOutlines(boolean auto) {
        return false;
    }

    @Override
    public void setComponentSize(int compWidth, int compHeight) {
        super.setComponentSize(compWidth, compHeight);
        this.calculateMarkerSize(compWidth, compHeight);
    }

    protected void updateSortableRoles(SILKNumber role, int action) {
        if (role == null || this.sortableRoles == null) {
            return;
        }
        switch (action) {
            case 1: {
                if (this.sortableRoles.contains((Object)role)) {
                    return;
                }
                this.sortableRoles.add(role);
                break;
            }
            case 2: {
                this.sortableRoles.remove((Object)role);
            }
        }
        Object[][] sortRoles = null;
        if (this.sortableRoles.size() > 0) {
            sortRoles = new Object[this.sortableRoles.size()][];
            for (int i = 0; i < this.sortableRoles.size(); ++i) {
                sortRoles[i] = new Object[]{this.sortableRoles.elementAt(i)};
            }
        }
        this.roles.setSupportedSortRoles(sortRoles);
    }

    protected void setSortOrderToCharMapper(SILKNumber role, CharacterVariableMapper charMapper, int sortOrder) {
        if (this.filter == null) {
            return;
        }
        if (this.filter.isNumericVariable(this.roles.getVariable((Object)role, 0))) {
            return;
        }
        if (charMapper == null) {
            return;
        }
        charMapper.setSort(sortOrder);
    }

    protected StyleElement getBasicStyleElement() {
        String id = null;
        if (this.roles != null && this.roles.getVariable((Object)this.yRole, 0) != null) {
            id = this.roles.getVariable((Object)this.yRole, 0).toString();
        }
        return SILKUtilities.getStyleElement(id, -1, 1, this.style, this.markerAttrs, this.markerAttrs.getOverrides(false));
    }

    protected LegendEntry getOverlayLegendEntry() {
        Object id = this.getId();
        if (this.overlayLegendLabel != null) {
            id = this.overlayLegendLabel;
        }
        MarkerAttrib marker = null;
        if (this.showMarkers) {
            marker = new MarkerAttrib();
            marker.setColor(this.getMarkerColor());
            marker.setOutline(this.getMarkerOutlineColor());
            marker.setOutline(new Boolean(this.areMarkerOutlinesOn()));
            marker.setShape(this.getMarkerShape());
        }
        Object yVar = this.yVars != null && this.yVars.size() > 0 ? this.yVars.elementAt(0) : null;
        LegendEntry entry = new LegendEntry(id, marker, this.getLineStyle(yVar, null));
        return entry;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: 
            case 3: {
                this.groupIndexMap = null;
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    protected String getMenuXML() {
        return "/com/sas/graphics/silk/util/menus/ScatterMenu.xml";
    }
}

