/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.data.sort.SortContext;
import com.sas.graphics.data.sort.SortContextFactory;
import com.sas.graphics.silk.base.ScatterElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.MarkerRenderer;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKGlobal;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.StyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.PropertyEvent;
import com.sas.graphics.util.SASLinePatterns;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class LinePlotElement
extends ScatterElement {
    private static final int INTERNAL_GAP = 2;
    protected SortContext sort = null;
    protected Hashtable lineStyles = new Hashtable();
    protected MyLineAttrib defaultLineStyle = new MyLineAttrib(true, Color.black, SILKGlobal.isFlagSet(4) ? 1 : 2, 0);
    protected Object currentResponse = null;
    protected Object currentGroup = null;
    protected boolean skipMiss = !SILKGlobal.isFlagSet(4);
    protected static final int MAX_RESPONSES = 100;
    private boolean antiAliasOn = true;
    public static final int[] supportedJoinProperties = new int[]{24, 25, 23, 433, 427, 434, 441, 18504, 18503, 18502, 18501, 2036, 2075, 18506, 18505, 9504, 9503, 9502, 9505};
    public static final int CONNECT_ORDER_XVALUES = 1;
    public static final int CONNECT_ORDER_XAXIS = 2;
    private int connectOrder = 2;
    protected Hashtable lineStyleTable = new Hashtable();

    public LinePlotElement() {
        this.showMarkers = false;
        this.roles.deleteRole((Object)this.colorRole);
        this.dataLabelRole = this.role.getRoleObject("ROLE_LABEL");
        this.roles.newRole((Object)this.dataLabelRole, "Data Label", 1);
        this.roles.setRoleType((Object)this.dataLabelRole, 0);
        this.setSupportedProperties(supportedJoinProperties);
        this.userSetProperties.appendProperties(supportedJoinProperties);
        this.removeChartTabInfo("com.sas.graphics.silk.ui.BaseScatterPanel");
        this.addChartTabInfo("com.sas.graphics.silk.ui.JoinPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseJoinElement.Join.txt", (String)"Join"));
        this.addChartTabInfo("com.sas.graphics.silk.ui.BaseScatterPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"BaseJoinElement.Markers.txt", (String)"Markers"));
    }

    @Override
    public void dispose() {
        this.sort = null;
        if (this.lineStyles != null) {
            this.lineStyles.clear();
        }
        this.lineStyles = null;
        this.defaultLineStyle = null;
        if (this.lineStyleTable != null) {
            this.lineStyleTable.clear();
        }
        this.lineStyleTable = null;
        super.dispose();
    }

    @Override
    public void roleChanged(RoleEvent e) {
        if ((this.yRole.equals(e.role) || this.groupRole.equals(e.role) || this.groupIndexRole.equals(e.role)) && this.lineStyleTable != null) {
            this.lineStyleTable.clear();
        }
        super.roleChanged(e);
        if (this.filter == null) {
            return;
        }
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                this.currentResponse = null;
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
        this.setupSortContext();
        this.lce.setAction(4);
        this.lce.setBuildData(ResourceLoader.getResourceString((Object)this.rb, (String)"LinePlotElement.Lines.txt", (String)"Lines"));
        this.fireLayerListenerChanged(this.lce);
        this.lce.setBuildData(null);
        this.lce.setAction(1);
    }

    protected MyLineAttrib getCustomLineStyle(Object yVar, Object group) {
        String key = yVar.toString();
        if (group != null) {
            key = key + ":" + group.toString();
        }
        MyLineAttrib rc = (MyLineAttrib)this.lineStyles.get(key);
        return rc;
    }

    @Override
    protected LineAttrib getLineStyle(Object yVar, Object group) {
        return this.getLineStyle(yVar, group, false);
    }

    protected MyLineAttrib getLineStyle(Object yVar, Object group, boolean create) {
        if (yVar == null) {
            return this.defaultLineStyle;
        }
        MyLineAttrib rc = this.getCustomLineStyle(yVar, group);
        if (rc == null && create) {
            rc = new MyLineAttrib(true, this.defaultLineStyle.getColor(), this.defaultLineStyle.getWidth(), this.defaultLineStyle.getPattern());
            String key = yVar.toString();
            if (group != null) {
                key = key + ":" + group.toString();
            }
            this.lineStyles.put(key, rc);
            return rc;
        }
        if (this.filter == null) {
            return this.defaultLineStyle;
        }
        if (rc == null) {
            rc = this.getCachedLineStyle(yVar, group);
        }
        if (rc == null) {
            int numGroups = -1;
            Object[] groupValues = this.fetchUniqueValues(this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)), false);
            boolean statGraphCompat = SILKGlobal.isFlagSet(4);
            if (groupValues != null) {
                numGroups = groupValues.length;
            }
            if (numGroups > 0) {
                int linePattern;
                int groupIndex = this.getGroupIndex(group);
                DataStyleElement dse = SILKUtilities.getStyleElement(group.toString(), groupIndex, 2, this.style, this.lineAttrs, this.lineAttrs.getOverrides(false)).getAsDataStyle();
                Color c = null;
                c = groupIndex < 0 ? this.style.getLineStyleElement("Outlines").getLineColor() : dse.getLineColor();
                int n = linePattern = statGraphCompat ? dse.getLineStyle() : 1;
                if (this.yVars.size() > 1) {
                    int index = -1;
                    if (this.yVars.size() > 1) {
                        for (int i = 0; i < this.yVars.size(); ++i) {
                            if (!yVar.equals(this.yVars.elementAt(i))) continue;
                            index = i;
                        }
                    }
                    DataStyleElement ydse = SILKUtilities.getStyleElement(yVar.toString(), index, 1, this.style, this.lineAttrs, this.lineAttrs.getOverrides(false)).getAsDataStyle();
                    linePattern = ydse.getLineStyle();
                }
                int lineWidth = dse.getLineThickness().getSizeValue();
                rc = new MyLineAttrib(true, c, lineWidth, linePattern);
            } else {
                int index = -1;
                if (this.yVars.size() > 1) {
                    for (int i = 0; i < this.yVars.size(); ++i) {
                        if (!yVar.equals(this.yVars.elementAt(i))) continue;
                        index = i;
                    }
                }
                DataStyleElement dse = SILKUtilities.getStyleElement(yVar.toString(), index, 1, this.style, this.lineAttrs, this.lineAttrs.getOverrides(false)).getAsDataStyle();
                int lineWidth = dse.getLineThickness().getSizeValue();
                rc = new MyLineAttrib(true, dse.getLineColor(), lineWidth, statGraphCompat ? dse.getLineStyle() : 1);
            }
            this.addLineStyleToCache(yVar, group, rc);
        }
        return rc;
    }

    private void addLineStyleToCache(Object yVar, Object group, MyLineAttrib la) {
        if (group != null) {
            Hashtable h = null;
            if (this.lineStyleTable.containsKey(yVar)) {
                h = (Hashtable)this.lineStyleTable.get(yVar);
            } else {
                h = new Hashtable();
                this.lineStyleTable.put(yVar, h);
            }
            h.put(group, la);
        } else {
            this.lineStyleTable.put(yVar, la);
        }
    }

    private MyLineAttrib getCachedLineStyle(Object yVar, Object group) {
        MyLineAttrib rc = null;
        if (group != null) {
            Hashtable h = (Hashtable)this.lineStyleTable.get(yVar);
            if (h != null) {
                rc = (MyLineAttrib)h.get(group);
            }
        } else {
            rc = (MyLineAttrib)this.lineStyleTable.get(yVar);
        }
        return rc;
    }

    private boolean isDrawableObs(int index, int xVarIndex, int yVarIndex, Object yVar) {
        if (this.filter == null || index < 0 || index >= this.filter.getNumberObservations(-1)) {
            return false;
        }
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex);
        boolean yIsNum = this.filter.isNumericVariable(yVar);
        double xValue = Double.NaN;
        xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)index, this.sort) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)index, this.sort, null));
        if (Double.isNaN(xValue)) {
            return false;
        }
        double yValue = Double.NaN;
        yValue = yIsNum ? this.filter.getNumericValue(yVarIndex, (long)index, this.sort) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(yVar, (long)index, this.sort, null));
        return !Double.isNaN(yValue);
    }

    @Override
    protected void drawChart(Graphics g) {
        int xVarIndex;
        Object aaHint = null;
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            aaHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            oldStroke = ((Graphics2D)g).getStroke();
        }
        if ((xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0))) < 0 || this.yVars == null || this.yVars.size() == 0) {
            return;
        }
        int[] yVarIndex = new int[this.yVars.size()];
        int validYVar = 0;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            ++validYVar;
        }
        if (validYVar <= 0) {
            return;
        }
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        GeneralPath line = new GeneralPath();
        GeneralPath croppedLine = new GeneralPath();
        LineAttrib mla = null;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean lastGraphed = true;
        double lastValidX = 0.0;
        double lastValidY = 0.0;
        double x = 0.0;
        double y = 0.0;
        boolean graphed = true;
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex);
        boolean yIsNum = this.filter.isNumericVariable(this.yVars.elementAt(0));
        Object groupValue = null;
        MarkerAttrib ma = null;
        boolean lastWasMoveTo = false;
        int numPointsInLine = 0;
        if (this.lineStyleTable != null) {
            this.lineStyleTable.clear();
        }
        int croppedPoints = 0;
        ArrayList<labelInfo> labelList = new ArrayList<labelInfo>();
        int dataLabelVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.dataLabelRole, 0));
        Object dataLabelVariable = this.filter.getVariableId(dataLabelVarIndex);
        for (int i = 0; i < yVarIndex.length; ++i) {
            Object lastGroup = null;
            Object nextGroup = null;
            lastWasMoveTo = false;
            for (int j = 0; j < this.filter.getNumberObservations(-1); ++j) {
                int group = -1;
                if (groupVarIndex >= 0) {
                    group = this.getGroupIndex(this.sort.getSortedIndex(j, this.filter));
                }
                double xValue = Double.NaN;
                xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)j, this.sort) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)j, this.sort, null));
                double yValue = Double.NaN;
                yValue = yIsNum ? this.filter.getNumericValue(yVarIndex[i], (long)j, this.sort) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(i), (long)j, this.sort, null));
                groupValue = this.filter.getValue(groupVarIndex, (long)j, this.sort);
                if (j + 1 < this.filter.getNumberObservations(-1)) {
                    nextGroup = this.filter.getValue(groupVarIndex, (long)(j + 1), this.sort);
                }
                lastX = x;
                lastY = y;
                lastGraphed = graphed;
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                x = Double.isNaN(xValue) ? Double.NaN : Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                y = Double.isNaN(yValue) ? Double.NaN : Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                boolean hasNan = Double.isNaN(xValue) || Double.isNaN(yValue);
                graphed = this.isGraphed(this.filter, j, this.sort);
                boolean nextGraphed = this.isGraphed(this.filter, j + 1, this.sort);
                if (groupValue != null && !groupValue.equals(lastGroup)) {
                    if (group >= 0 && lastGroup != null) {
                        if (numPointsInLine == 1 || lastWasMoveTo && lastGraphed) {
                            String grp = lastGroup == null ? null : this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), lastGroup, null);
                            ma = this.buildMarkerAttrib(ma, this.getBasicStyleElement().getAsDataStyle(), grp, this.yVars, i, Double.NaN);
                            MarkerRenderer.drawStandardMarker(g, (int)lastValidX, (int)lastValidY, ma.getColor(), ma.getOutline().getColor(), ma.getShapeInt(), this.markersOutlined, this.markerSize, this.halfMarkerSize, 1);
                        }
                        if (numPointsInLine > 1) {
                            this.drawLine(g, line, mla, this.getCurveLabel(this.yVars.elementAt(i), groupValue));
                        }
                        if (croppedPoints > 0) {
                            Color lc = new Color(mla.getColor().getRed(), mla.getColor().getGreen(), mla.getColor().getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
                            MyLineAttrib croppedMLA = new MyLineAttrib(mla.isVisible(), lc, mla.getWidth(), mla.getPattern());
                            this.drawLine(g, croppedLine, croppedMLA, null);
                        }
                        numPointsInLine = 0;
                    }
                    if ((mla = this.getLineStyle(this.yVars.elementAt(i), this.filter.getFormattedValue(groupVar, (long)j, this.sort, null), false)) == null) {
                        mla = this.defaultLineStyle;
                    }
                    line.reset();
                    croppedLine.reset();
                    if (!Double.isNaN(x) && !Double.isNaN(y)) {
                        line.moveTo((float)x, (float)y);
                        if (graphed) {
                            ++numPointsInLine;
                        }
                        lastWasMoveTo = true;
                    } else {
                        lastWasMoveTo = false;
                    }
                    lastGroup = groupValue;
                    if (!graphed || !nextGraphed) {
                        croppedLine.moveTo((float)x, (float)y);
                        ++croppedPoints;
                    }
                } else {
                    mla = this.getLineStyle(this.yVars.elementAt(i), this.filter.getFormattedValue(groupVar, (long)j, this.sort, null), false);
                    if (mla == null) {
                        mla = this.defaultLineStyle;
                    }
                    if (!Double.isNaN(x) && !Double.isNaN(y)) {
                        boolean drawSeg;
                        double x0 = lastX;
                        double y0 = lastY;
                        double x1 = x;
                        double y1 = y;
                        boolean bl = drawSeg = j != 0;
                        if (!(graphed && lastGraphed && (!Double.isNaN(x0) && !Double.isNaN(y0) || this.skipMiss && line.getCurrentPoint() != null))) {
                            drawSeg = false;
                        } else if (line.getCurrentPoint() != null) {
                            x0 = line.getCurrentPoint().getX();
                            y0 = line.getCurrentPoint().getY();
                        }
                        switch (((MyLineAttrib)mla).getJoinType()) {
                            case 1: {
                                if (drawSeg) {
                                    line.lineTo((float)x0, (float)y1);
                                    break;
                                }
                                line.moveTo((float)x0, (float)y1);
                                break;
                            }
                            case 2: {
                                if (drawSeg) {
                                    line.lineTo((float)(x0 + (x1 - x0) / 2.0), (float)y0);
                                } else {
                                    line.moveTo((float)(x0 + (x1 - x0) / 2.0), (float)y0);
                                }
                                line.lineTo((float)(x0 + (x1 - x0) / 2.0), (float)y1);
                                break;
                            }
                            case 3: {
                                if (drawSeg) {
                                    line.lineTo((float)x1, (float)y0);
                                    break;
                                }
                                line.moveTo((float)x1, (float)y0);
                            }
                        }
                        if (drawSeg) {
                            line.lineTo((float)x1, (float)y1);
                            ++numPointsInLine;
                            lastWasMoveTo = false;
                        } else {
                            boolean move = false;
                            int obs = this.filter.getNumberObservations(-1);
                            for (int idx = j + 1; idx < obs && !(move = this.isDrawableObs(idx, xVarIndex, yVarIndex[i], this.yVars.elementAt(i))); ++idx) {
                            }
                            if (groupVarIndex >= 0 && groupValue != null && !groupValue.equals(nextGroup)) {
                                move = false;
                            }
                            if (!nextGraphed) {
                                move = false;
                            }
                            if (move) {
                                line.moveTo((float)x1, (float)y1);
                                ++numPointsInLine;
                            }
                            if (lastWasMoveTo) {
                                String grp = groupValue == null ? null : this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), groupValue, null);
                                ma = this.buildMarkerAttrib(ma, this.getBasicStyleElement().getAsDataStyle(), grp, this.yVars, i, Double.NaN);
                                if (lastGraphed) {
                                    MarkerRenderer.drawStandardMarker(g, (int)lastValidX, (int)lastValidY, ma.getColor(), ma.getOutline().getColor(), ma.getShapeInt(), this.markersOutlined, this.markerSize, this.halfMarkerSize, 1);
                                }
                            }
                            lastWasMoveTo = true;
                        }
                        if (!lastGraphed || !graphed) {
                            croppedLine.lineTo((float)x1, (float)y1);
                            ++croppedPoints;
                        } else if (!nextGraphed) {
                            croppedLine.moveTo((float)x1, (float)y1);
                        }
                    }
                }
                if (graphed) {
                    if (!hasNan) {
                        lastValidX = x;
                    }
                    if (!hasNan) {
                        lastValidY = y;
                    }
                }
                if (dataLabelVarIndex < 0) continue;
                if (Double.isNaN(xValue) || Double.isNaN(yValue)) {
                    labelInfo info = new labelInfo((float)this.projectValues[0], (float)this.projectValues[1], yValue, "");
                    labelList.add(info);
                    continue;
                }
                TextStyleElement selem = this.getDataLabelStyle().getAsTextStyle();
                FontMetrics dataLabelFontMetrics = g.getFontMetrics(selem.getFont());
                String formattedlabel = this.filter.getFormattedValue(dataLabelVariable, (long)j, this.sort, null);
                labelInfo info = new labelInfo((float)this.projectValues[0], (float)this.projectValues[1], yValue, formattedlabel);
                labelList.add(info);
            }
            if (numPointsInLine == 1 || lastWasMoveTo && graphed) {
                String grp = groupValue == null ? null : this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), groupValue, null);
                ma = this.buildMarkerAttrib(ma, this.getBasicStyleElement().getAsDataStyle(), grp, this.yVars, i, Double.NaN);
                MarkerRenderer.drawStandardMarker(g, (int)lastValidX, (int)lastValidY, ma.getColor(), ma.getOutline().getColor(), ma.getShapeInt(), this.markersOutlined, this.markerSize, this.halfMarkerSize, 1);
            }
            if (numPointsInLine > 1) {
                this.drawLine(g, line, mla, this.getCurveLabel(this.yVars.elementAt(i), groupValue));
            }
            if (croppedPoints > 0) {
                Color lc = new Color(mla.getColor().getRed(), mla.getColor().getGreen(), mla.getColor().getBlue(), (int)((1.0 - this.croppedTransparency) * 255.0));
                MyLineAttrib croppedMLA = new MyLineAttrib(mla.isVisible(), lc, mla.getWidth(), mla.getPattern());
                this.drawLine(g, croppedLine, croppedMLA, null);
            }
            croppedPoints = 0;
            croppedLine.reset();
            numPointsInLine = 0;
            line.reset();
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            ((Graphics2D)g).setStroke(oldStroke);
        }
        if (this.showMarkers) {
            super.drawChart(g);
        }
        this.drawLabels(g, labelList);
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }
    }

    public boolean intersects(Rectangle r, Object yVar, Object groupVal) {
        if (r == null || r.width == 0 || r.height == 0) {
            return false;
        }
        int xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        if (xVarIndex < 0 || this.yVars == null || this.yVars.size() == 0) {
            return false;
        }
        int[] yVarIndex = new int[this.yVars.size()];
        int validYVar = 0;
        for (int i = 0; i < yVarIndex.length; ++i) {
            yVarIndex[i] = this.filter.getVariableIndex(this.yVars.elementAt(i));
            if (yVarIndex[i] < 0) continue;
            ++validYVar;
        }
        if (validYVar <= 0) {
            return false;
        }
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int maxValue = (int)Math.pow(2.0, 15.0) - 100;
        int minValue = -maxValue;
        GeneralPath line = new GeneralPath();
        GeneralPath croppedLine = new GeneralPath();
        MyLineAttrib mla = null;
        double lastX = 0.0;
        double lastY = 0.0;
        boolean lastGraphed = true;
        double x = 0.0;
        double y = 0.0;
        boolean graphed = true;
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        boolean xIsNum = this.filter.isNumericVariable(xVarIndex);
        boolean yIsNum = this.filter.isNumericVariable(this.yVars.elementAt(0));
        Object groupValue = null;
        int numPointsInLine = 0;
        if (this.lineStyleTable != null) {
            this.lineStyleTable.clear();
        }
        int croppedPoints = 0;
        for (int i = 0; i < yVarIndex.length; ++i) {
            if (yVar != null && !yVar.equals(this.yVars.get(i))) continue;
            Object lastGroup = null;
            Object nextGroup = null;
            for (int j = 0; j < this.filter.getNumberObservations(-1); ++j) {
                boolean drawSeg;
                int group = -1;
                if (groupVarIndex >= 0) {
                    group = this.getGroupIndex(this.sort.getSortedIndex(j, this.filter));
                }
                double xValue = Double.NaN;
                xValue = xIsNum ? this.filter.getNumericValue(xVarIndex, (long)j, this.sort) : (double)this.xCharMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(xVarIndex), (long)j, this.sort, null));
                double yValue = Double.NaN;
                yValue = yIsNum ? this.filter.getNumericValue(yVarIndex[i], (long)j, this.sort) : (double)this.yCharMapper.getIndex(this.filter.getFormattedValue(this.yVars.elementAt(i), (long)j, this.sort, null));
                groupValue = this.filter.getValue(groupVarIndex, (long)j, this.sort);
                if (groupVal != null && !groupVal.equals(groupVal)) continue;
                if (j + 1 < this.filter.getNumberObservations(-1)) {
                    nextGroup = this.filter.getValue(groupVarIndex, (long)(j + 1), this.sort);
                }
                lastX = x;
                lastY = y;
                lastGraphed = graphed;
                this.projectValues = this.transformObject.project(xValue, yValue, 0.0, this.projectValues);
                x = Double.isNaN(xValue) ? Double.NaN : Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[0]));
                y = Double.isNaN(yValue) ? Double.NaN : Math.max((double)minValue, Math.min((double)maxValue, this.projectValues[1]));
                graphed = this.isGraphed(this.filter, j, this.sort);
                boolean nextGraphed = this.isGraphed(this.filter, j + 1, this.sort);
                if (groupValue != null && !groupValue.equals(lastGroup)) {
                    if (group < 0 || lastGroup != null) {
                        // empty if block
                    }
                    if ((mla = this.getLineStyle(this.yVars.elementAt(i), this.filter.getFormattedValue(groupVar, (long)j, this.sort, null), false)) == null) {
                        mla = this.defaultLineStyle;
                    }
                    line.reset();
                    croppedLine.reset();
                    if (!Double.isNaN(x) && !Double.isNaN(y)) {
                        line.moveTo((float)x, (float)y);
                        if (graphed) {
                            ++numPointsInLine;
                        }
                    }
                    lastGroup = groupValue;
                    if (graphed && nextGraphed) continue;
                    croppedLine.moveTo((float)x, (float)y);
                    ++croppedPoints;
                    continue;
                }
                mla = this.getLineStyle(this.yVars.elementAt(i), this.filter.getFormattedValue(groupVar, (long)j, this.sort, null), false);
                if (mla == null) {
                    mla = this.defaultLineStyle;
                }
                if (Double.isNaN(x) || Double.isNaN(y)) continue;
                double x0 = lastX;
                double y0 = lastY;
                double x1 = x;
                double y1 = y;
                boolean bl = drawSeg = j != 0;
                if (!graphed || !lastGraphed || (Double.isNaN(x0) || Double.isNaN(y0)) && (this.skipMiss || line.getCurrentPoint() == null)) {
                    drawSeg = false;
                } else if (line.getCurrentPoint() != null) {
                    x0 = line.getCurrentPoint().getX();
                    y0 = line.getCurrentPoint().getY();
                }
                switch (mla.getJoinType()) {
                    case 1: {
                        if (drawSeg) {
                            if (r.intersectsLine(lastX, lastY, x0, y1)) {
                                return true;
                            }
                            line.lineTo((float)x0, (float)y1);
                            break;
                        }
                        line.moveTo((float)x0, (float)y1);
                        break;
                    }
                    case 2: {
                        if (drawSeg) {
                            if (r.intersectsLine(lastX, lastY, x0 + (x1 - x0) / 2.0, y0)) {
                                return true;
                            }
                            line.lineTo((float)(x0 + (x1 - x0) / 2.0), (float)y0);
                        } else {
                            line.moveTo((float)(x0 + (x1 - x0) / 2.0), (float)y0);
                        }
                        if (r.intersectsLine(lastX, lastY, x0 + (x1 - x0) / 2.0, y1)) {
                            return true;
                        }
                        line.lineTo((float)(x0 + (x1 - x0) / 2.0), (float)y1);
                        break;
                    }
                    case 3: {
                        if (drawSeg) {
                            if (r.intersectsLine(lastX, lastY, x1, y0)) {
                                return true;
                            }
                            line.lineTo((float)x1, (float)y0);
                            break;
                        }
                        line.moveTo((float)x1, (float)y0);
                    }
                }
                if (drawSeg) {
                    if (r.intersectsLine(lastX, lastY, x1, y1)) {
                        return true;
                    }
                    line.lineTo((float)x1, (float)y1);
                    ++numPointsInLine;
                } else {
                    boolean move = this.isDrawableObs(j + 1, xVarIndex, yVarIndex[i], this.yVars.elementAt(i));
                    if (groupVarIndex >= 0 && groupValue != null && !groupValue.equals(nextGroup)) {
                        move = false;
                    }
                    if (!nextGraphed) {
                        move = false;
                    }
                    if (move) {
                        line.moveTo((float)x1, (float)y1);
                        ++numPointsInLine;
                    }
                }
                if (!lastGraphed || !graphed) {
                    croppedLine.lineTo((float)x1, (float)y1);
                    ++croppedPoints;
                    continue;
                }
                if (nextGraphed) continue;
                croppedLine.moveTo((float)x1, (float)y1);
            }
            numPointsInLine = 0;
            line.reset();
        }
        return false;
    }

    private String getCurveLabel(Object response, Object group) {
        return "Foobar";
    }

    private void drawLine(Graphics g, GeneralPath line, LineAttrib lineAttrib, String curveLabel) {
        if (lineAttrib == null || !lineAttrib.isVisible()) {
            return;
        }
        g.setColor(lineAttrib.getColor());
        if (lineAttrib.getPattern() > 1 && g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(SASLinePatterns.getStroke((int)lineAttrib.getPattern(), (int)lineAttrib.getWidth()));
        } else if (g instanceof Graphics2D) {
            ((Graphics2D)g).setStroke(new BasicStroke(lineAttrib.getWidth(), 1, 1));
        }
        if (this.antiAliasOn && g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).draw(line);
        }
    }

    @Override
    protected Object getLegendEntries(SILKNumber currentLegend) {
        if (currentLegend == null) {
            return null;
        }
        if (this.filter == null) {
            return null;
        }
        int groupVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        if (ResourceLoader.getResourceString((Object)this.rb, (String)"LinePlotElement.Lines.txt", (String)"Lines").equalsIgnoreCase(currentLegend.toString())) {
            Vector<LegendEntry> legendEntries = new Vector<LegendEntry>();
            Object[] groupValues = this.fetchUniqueValues(groupVarIndex, true);
            Object[] allGroupValues = this.fetchUniqueValues(groupVarIndex, false);
            if (this.yVars == null) {
                return null;
            }
            for (int i = 0; i < this.yVars.size(); ++i) {
                Object yVar = this.yVars.elementAt(i);
                Object desc = this.filter.getVariableDescription(yVar);
                Color[] dataColors = this.style.getDataFillColors();
                Color[] contrastColors = this.style.getDataLineColors();
                Color styleOutlineColor = this.style.getLineStyleElement("Outlines").getLineColor();
                StyleElement yStyleElement = SILKUtilities.getStyleElement(yVar.toString(), i, 1, this.style, this.lineAttrs, this.lineAttrs.getOverrides(false));
                if (groupValues != null && groupValues.length > 0) {
                    for (int j = 0; j < allGroupValues.length; ++j) {
                        boolean found = false;
                        for (int k = 0; k < groupValues.length; ++k) {
                            if (!groupValues[k].equals(allGroupValues[j])) continue;
                            found = true;
                        }
                        if (!found) continue;
                        MarkerAttrib ma = null;
                        if (this.showMarkers) {
                            ma = new MarkerAttrib();
                            int groupIndex = this.getGroupIndex(allGroupValues[j]);
                            Color c = null;
                            StyleElement e = SILKUtilities.getStyleElement(allGroupValues[j].toString(), groupIndex, 2, this.style, this.lineAttrs, this.lineAttrs.getOverrides(false));
                            c = e.getAsDataStyle().getFillColor();
                            ma.setColor(c);
                            if (this.yVars.size() > 1 && SILKGlobal.isFlagSet(4)) {
                                ma.setShape(new Integer(yStyleElement.getAsDataStyle().getMarkerSymbol()));
                            } else if (this.yVars.size() > 1 || SILKGlobal.isFlagSet(4)) {
                                ma.setShape(new Integer(e.getAsDataStyle().getMarkerSymbol()));
                            } else {
                                ma.setShape(this.getMarkerShape());
                            }
                            ma.setFilled(this.isMarkerFilled());
                            ma.setOutline(new Boolean(this.areMarkerOutlinesOn()));
                            c = groupIndex < 0 ? styleOutlineColor : contrastColors[groupIndex % contrastColors.length];
                            ma.setOutline(c);
                        }
                        MyLineAttrib la = this.getLineStyle(yVar, allGroupValues[j], false);
                        String entryString = null;
                        entryString = this.yVars.size() > 1 ? desc + " (" + allGroupValues[j] + ")" : allGroupValues[j].toString();
                        legendEntries.addElement(new LegendEntry(entryString, ma, la));
                    }
                    continue;
                }
                if (this.yVars.size() == 1) {
                    return null;
                }
                MarkerAttrib ma = null;
                if (this.showMarkers) {
                    ma = new MarkerAttrib();
                    ma.setColor(dataColors[i % dataColors.length]);
                    ma.setFilled(this.isMarkerFilled());
                    ma.setOutline(new Boolean(this.areMarkerOutlinesOn()));
                    ma.setShape(this.getMarkerShape());
                    ma.setOutline(contrastColors[i % contrastColors.length]);
                    if (SILKGlobal.isFlagSet(4)) {
                        ma.setShape(new Integer(yStyleElement.getAsDataStyle().getMarkerSymbol()));
                    }
                }
                MyLineAttrib la = this.getLineStyle(yVar, null, false);
                legendEntries.addElement(new LegendEntry(desc, ma, la));
            }
            return legendEntries;
        }
        return super.getLegendEntries(currentLegend);
    }

    @Override
    public boolean setColorScheme(Object newScheme) {
        boolean rc = super.setColorScheme(newScheme);
        if (this.defaultLineStyle == null) {
            this.defaultLineStyle = new MyLineAttrib(true, Color.BLACK, 2, 0);
        }
        this.defaultLineStyle.setColor(this.style.getLineStyleElement(this.lineAttrs.getReference()).getLineColor());
        this.defaultLineStyle.setPattern(this.style.getLineStyleElement(this.lineAttrs.getReference()).getLineStyle());
        return rc;
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        MyLineAttrib la = null;
        if (this.pendingProperties != null && this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        switch (id) {
            case 24: 
            case 25: {
                if (this.filter == null) {
                    rc = null;
                    break;
                }
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                SILKNumber legendId = new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"LinePlotElement.Lines.txt", (String)"Lines"), "Lines");
                if (this.isLegendValid(this.groupRole) && this.yVars != null && this.yVars.size() > 1) {
                    legNames.add(legendId);
                } else if (this.yVars != null && this.yVars.size() > 1) {
                    legNames.add(legendId);
                } else if (this.isLegendValid(this.groupRole)) {
                    legNames.add(this.groupRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 434: {
                if (this.currentLegend == null) {
                    rc = null;
                    break;
                }
                if (!this.groupRole.toString().equalsIgnoreCase(this.currentLegend.toString()) && !this.groupRole.getEnglishName().equalsIgnoreCase(this.currentLegend.getEnglishName())) break;
                rc = this.roles.getVariable((Object)this.groupRole, 0);
                break;
            }
            case 444: {
                boolean groups;
                int numy = this.yVars == null ? 0 : this.yVars.size();
                boolean bl = groups = this.roles.getVariable((Object)this.groupRole, 0) != null;
                if (numy == 0 || numy > 1 || groups) {
                    rc = new LegendEntry(this.getId(), new MarkerAttrib(this.areMarkersOn(), this.style.getMarkerStyleElement(this.lineAttrs.getReference()).getMarkerColor()), new LineAttrib(true, this.style.getLineStyleElement(this.lineAttrs.getReference()).getLineColor(), 2));
                    break;
                }
                LegendEntry entry = this.getOverlayLegendEntry();
                rc = entry;
                break;
            }
            case 18501: {
                rc = this.yVars;
                break;
            }
            case 18502: {
                if (this.filter == null) break;
                rc = this.fetchUniqueValues(this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)), true);
                break;
            }
            case 18504: {
                rc = this.currentGroup;
                break;
            }
            case 18503: {
                rc = this.currentResponse;
                break;
            }
            case 9501: 
            case 9502: 
            case 9503: 
            case 9504: 
            case 18505: {
                la = this.getLineStyle(this.currentResponse, this.currentGroup, false);
                if (la == null) break;
                rc = ((LineAttrib)la).getPropertyValue(id);
                break;
            }
            case 18506: {
                rc = new Boolean(this.skipMiss);
                break;
            }
            case 18507: {
                rc = this.getCustomLineStyle(this.currentResponse, this.currentGroup);
                break;
            }
            case 18508: {
                rc = this.getLineStyle(this.currentResponse, this.currentGroup, true);
                break;
            }
            case 2075: {
                rc = Boolean.TRUE;
                break;
            }
            case 2036: {
                rc = new Boolean(this.showMarkers);
                break;
            }
            case 9505: {
                rc = this.getConnectOrder();
                break;
            }
            case 19089: {
                rc = Boolean.FALSE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        switch (id) {
            case 23: {
                String leg;
                if (value == null || (!(leg = value.toString()).equalsIgnoreCase(ResourceLoader.getResourceString((Object)this.rb, (String)"LinePlotElement.Lines.txt", (String)"Lines")) || !this.isLegendValid(new SILKNumber(0, ResourceLoader.getResourceString((Object)this.rb, (String)"LinePlotElement.Lines.txt", (String)"Lines"), "Lines"))) && !leg.equalsIgnoreCase(this.groupRole.toString())) break;
                if (value instanceof SILKNumber) {
                    this.currentLegend = (SILKNumber)((Object)value);
                }
                return true;
            }
            case 18504: {
                this.currentGroup = value;
                break;
            }
            case 18503: {
                this.currentResponse = value;
            }
        }
        return super.setPropertyValue(id, value);
    }

    @Override
    public boolean applyPropertyChanges(Object source) {
        Enumeration e = this.lineStyles.keys();
        while (e.hasMoreElements()) {
            ((LineAttrib)this.lineStyles.get(e.nextElement())).applyPropertyChanges(source);
        }
        return super.applyPropertyChanges(source);
    }

    @Override
    public void cancelPropertyChanges(Object source) {
        Enumeration e = this.lineStyles.keys();
        while (e.hasMoreElements()) {
            ((LineAttrib)this.lineStyles.get(e.nextElement())).cancelPropertyChanges(source);
        }
        super.cancelPropertyChanges(source);
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 18504: {
                this.currentGroup = value;
                break;
            }
            case 18503: {
                this.currentResponse = value;
                break;
            }
            case 18506: {
                if (value instanceof Boolean) {
                    this.skipMiss = (Boolean)value;
                }
                if (this.skipMiss) {
                    this.userSetProperties.clear(18506);
                    break;
                }
                this.userSetProperties.set(18506);
                break;
            }
            case 2036: {
                if (!(value instanceof Boolean)) break;
                this.setMarkersOn((Boolean)value);
                break;
            }
            case 9502: {
                if (!(value instanceof Color)) break;
                MyLineAttrib mla = this.getLineStyle(this.currentResponse, this.currentGroup, true);
                mla.setColor((Color)value);
                break;
            }
            case 9504: {
                if (!(value instanceof Number)) break;
                MyLineAttrib mla = this.getLineStyle(this.currentResponse, this.currentGroup, true);
                mla.setPattern(((Number)value).intValue());
                break;
            }
            case 9501: {
                if (!(value instanceof Boolean)) break;
                MyLineAttrib mla = this.getLineStyle(this.currentResponse, this.currentGroup, true);
                mla.setVisible((Boolean)value);
                break;
            }
            case 9503: {
                if (!(value instanceof Number)) break;
                MyLineAttrib mla = this.getLineStyle(this.currentResponse, this.currentGroup, true);
                mla.setWidth(((Number)value).intValue());
                break;
            }
            case 18505: {
                if (!(value instanceof Number)) break;
                MyLineAttrib mla = this.getLineStyle(this.currentResponse, this.currentGroup, true);
                mla.setJoinType(((Number)value).intValue());
                break;
            }
            case 9505: {
                if (value instanceof Number) {
                    this.setConnectOrder(((Number)value).intValue());
                }
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public void setMarkersOn(boolean on) {
        this.showMarkers = on;
        if (!this.showMarkers) {
            this.userSetProperties.clear(2036);
        } else {
            this.userSetProperties.set(2036);
        }
        this.fireLayerListenerChanged(1);
    }

    public boolean areMarkersOn() {
        return this.showMarkers;
    }

    private void setupSortContext() {
        if (this.filter == null) {
            return;
        }
        Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Vector<Object> v = new Vector<Object>();
        if (groupVar != null) {
            v.addElement(groupVar);
        }
        if (xVar != null && this.filter.isNumericVariable(xVar)) {
            v.addElement(xVar);
        }
        Object[] vars = new String[v.size()];
        v.copyInto(vars);
        this.sort = SortContextFactory.getSortContext((Object)this.filter.getSource(), (String[])vars, (int)(this.connectOrder == 1 ? 0 : 1));
    }

    @Override
    public boolean setDataSource(Object source, Object id) {
        boolean rc = super.setDataSource(source, id);
        this.setupSortContext();
        return rc;
    }

    protected void drawLabels(Graphics g, ArrayList labelList) {
        if (labelList != null && labelList.size() > 0) {
            double slopeDiff = 15.0;
            TextStyleElement selem = this.getDataLabelStyle().getAsTextStyle();
            FontMetrics dataLabelFontMetrics = g.getFontMetrics(selem.getFont());
            FontRenderContext frc = new FontRenderContext(null, true, true);
            TextStyleElement tse = this.style.getTextStyleElement("ValueText");
            block6: for (int i = 0; i < labelList.size(); ++i) {
                double resp0;
                labelInfo prevOBS;
                int type = -1;
                labelInfo currOBS = (labelInfo)labelList.get(i);
                double resp1 = currOBS.getRespvalue();
                float y1 = currOBS.getY();
                if (i > 0 && i < labelList.size() - 1) {
                    prevOBS = (labelInfo)labelList.get(i - 1);
                    resp0 = prevOBS.getRespvalue();
                    float y0 = prevOBS.getY();
                    labelInfo nextOBS = (labelInfo)labelList.get(i + 1);
                    double resp2 = nextOBS.getRespvalue();
                    float y2 = nextOBS.getY();
                    if (resp1 > resp0 && resp2 > resp1) {
                        type = 1;
                        if ((double)(y0 - y1) < slopeDiff && (double)(y1 - y2) < slopeDiff) {
                            type = 2;
                        }
                        if ((double)(y0 - y1) < slopeDiff && (double)(y1 - y2) > slopeDiff) {
                            type = 3;
                        }
                        if ((double)(y0 - y1) > slopeDiff && (double)(y1 - y2) < slopeDiff) {
                            type = 2;
                        }
                    }
                    if (resp1 > resp0 && resp1 > resp2 || resp1 > resp0 && resp1 == resp2 || resp1 == resp0 && resp1 > resp2 || resp1 == resp0 && resp1 == resp2) {
                        type = 2;
                    }
                    if (resp1 < resp0 && resp1 < resp2 || resp0 > resp1 && resp1 == resp2 || resp0 == resp1 && resp1 < resp2) {
                        type = 3;
                    }
                    if (resp1 < resp0 && resp2 < resp1) {
                        type = 4;
                        if ((double)(y1 - y0) < slopeDiff && (double)(y2 - y1) < slopeDiff) {
                            type = 3;
                        }
                        if ((double)(y1 - y0) < slopeDiff && (double)(y2 - y1) > slopeDiff) {
                            type = 2;
                        }
                        if ((double)(y1 - y0) > slopeDiff && (double)(y2 - y1) < slopeDiff) {
                            type = 3;
                        }
                    }
                    if (Double.isNaN(resp0) || Double.isNaN(resp2)) {
                        type = 2;
                    }
                }
                if (i == 0 && labelList.size() > 1) {
                    labelInfo nextOBS = (labelInfo)labelList.get(i + 1);
                    double resp2 = nextOBS.getRespvalue();
                    double y2 = nextOBS.getY();
                    if (Double.isNaN(resp2) || resp1 > resp2 || resp1 == resp2) {
                        type = 2;
                    } else if (resp2 > resp1) {
                        type = 3;
                    }
                }
                if (labelList.size() > 1 && i == labelList.size() - 1) {
                    prevOBS = (labelInfo)labelList.get(i - 1);
                    resp0 = prevOBS.getRespvalue();
                    if (resp0 > resp1) {
                        type = 3;
                    } else if (Double.isNaN(resp0) || resp1 > resp0 || resp1 == resp0) {
                        type = 2;
                    }
                }
                if (labelList.size() == 1) {
                    type = 2;
                }
                g.setColor(tse.getTextColor());
                String label = currOBS.getLabel();
                if (label == null || label.trim().length() <= 0) continue;
                TextLayout txtStr = new TextLayout(label.trim(), dataLabelFontMetrics.getFont(), frc);
                switch (type) {
                    case 1: {
                        txtStr.draw((Graphics2D)g, currOBS.getX() - (float)(this.markerSize / 2) - txtStr.getVisibleAdvance() - 4.0f, (float)((double)currOBS.getY() + txtStr.getBounds().getHeight() / 2.0));
                        continue block6;
                    }
                    case 2: {
                        txtStr.draw((Graphics2D)g, (float)((double)currOBS.getX() - txtStr.getBounds().getWidth() / 2.0), currOBS.getY() - (float)(this.markerSize / 2) - 2.0f);
                        continue block6;
                    }
                    case 3: {
                        txtStr.draw((Graphics2D)g, (float)((double)currOBS.getX() - txtStr.getBounds().getWidth() / 2.0), currOBS.getY() + (float)(this.markerSize / 2) + 12.0f);
                        continue block6;
                    }
                    case 4: {
                        txtStr.draw((Graphics2D)g, currOBS.getX() + (float)(this.markerSize / 2) + 4.0f, (float)((double)currOBS.getY() + txtStr.getBounds().getHeight() / 2.0));
                        continue block6;
                    }
                    default: {
                        txtStr.draw((Graphics2D)g, currOBS.getX() + (float)this.markerSize + 2.0f, currOBS.getY());
                    }
                }
            }
        }
    }

    public int getConnectOrder() {
        return this.connectOrder;
    }

    public void setConnectOrder(int connectOrder) {
        this.connectOrder = connectOrder;
        this.userSetProperties.set(9505);
    }

    public boolean isAntiAliasOn() {
        return this.antiAliasOn;
    }

    public void setAntiAliasOn(boolean antiAliasOn) {
        this.antiAliasOn = antiAliasOn;
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 1: 
            case 3: {
                if (this.lineStyleTable == null) break;
                this.lineStyleTable.clear();
            }
        }
        super.dataFilterChanged(evt);
    }

    class labelInfo {
        private float x;
        private float y;
        private double respvalue;
        private String label;

        labelInfo(float x, float y, double respvalue, String label) {
            this.x = x;
            this.y = y;
            this.respvalue = respvalue;
            this.label = label;
        }

        public float getX() {
            return this.x;
        }

        public float getY() {
            return this.y;
        }

        public double getRespvalue() {
            return this.respvalue;
        }

        public String getLabel() {
            return this.label;
        }
    }

    class MyLineAttrib
    extends LineAttrib {
        int joinStyle;

        public MyLineAttrib(boolean visible, Object color, int width, int pattern) {
            super(visible, color, width, pattern);
            this.joinStyle = 0;
            this.userSetProperties.appendProperties(new int[]{18505});
        }

        public int getJoinType() {
            return this.joinStyle;
        }

        public boolean setJoinType(int type) {
            if (type == this.joinStyle) {
                return true;
            }
            if (type == 0 || type == 2 || type == 1 || type == 3) {
                this.userSetProperties.set(18505);
                this.joinStyle = type;
                return true;
            }
            return false;
        }

        @Override
        public Object getPropertyValue(int id) {
            if (id == 18505) {
                return new Integer(this.joinStyle);
            }
            return super.getPropertyValue(id);
        }

        @Override
        public boolean applyPropertyChanges(Object source) {
            Vector v = this.pendingProperties.getChangesBySource(source);
            block3: for (int i = 0; i < v.size(); ++i) {
                PropertyEvent pe = (PropertyEvent)v.elementAt(i);
                switch (pe.id) {
                    case 18505: {
                        if (!(pe.value instanceof Number)) continue block3;
                        this.setJoinType(((Number)pe.value).intValue());
                    }
                }
            }
            return super.applyPropertyChanges(source);
        }
    }
}

