/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.AxisDefaults;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.CollectionSorter;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.LineAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.styles.TextStyleElement;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.FontManager;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.ResourceBundle;
import java.util.Vector;

public class LineChartElement
extends BaseElement {
    protected static final int MAX_RESPONSES = 10;
    protected SILKNumber categoryRole = null;
    protected SILKNumber responseRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber statTypeRole = null;
    protected CharacterVariableMapper categoryMapper = null;
    protected CharacterVariableMapper groupMapper = null;
    protected ResourceBundle rbBar = null;
    protected double widthFactor;
    protected String currentLegend = null;
    protected Color outlineClr;
    protected DefaultStatistics defaultStatistics = null;
    protected Vector tuple = null;
    protected Object[] summaryVars;
    protected Object respVar;
    protected int statType = 12;
    protected static ResourceBundle rbUI = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected static SILKNumber statName_Frequency = new SILKNumber(0, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Frequency.txt", (String)"Frequency"), "Frequency");
    protected static SILKNumber statName_Percent = new SILKNumber(1, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Percent.txt", (String)"Percent"), "Percent");
    protected static SILKNumber statName_Sum = new SILKNumber(2, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Sum.txt", (String)"Sum"), "Sum");
    protected static SILKNumber statName_Mean = new SILKNumber(3, ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Mean.txt", (String)"Mean"), "Mean");
    protected boolean showLabels = false;
    protected boolean negResp = false;
    protected double fullBarWidth;
    protected boolean honorBarWidth = false;
    protected int anchor = 19304;
    protected boolean skipMiss = true;
    protected Font labelFont = null;
    protected AxisDefaults axisDefaults;
    protected int numberOfResponse = 1;
    protected Object[] respVars = null;
    protected boolean allowMultiResponse = true;
    protected Object categorySortType = RoleInterface.ROLE_SORT_DATA;
    protected Object responseSortType = null;
    protected boolean limitResponseAxisToDataVals = false;
    public static final int[] supportedBarElementProperties = new int[]{19307, 19303, 19308, 19302, 19301, 19307, 19309, 24, 25, 23, 433, 426, 434, 441};

    public LineChartElement() {
        this.categoryRole = this.role.getRoleObject("ROLE_CATEGORY");
        this.roles.newRole((Object)this.categoryRole, "Category", 1);
        this.roles.setRoleType((Object)this.categoryRole, 0);
        this.roles.setDiscrete((Object)this.categoryRole, true);
        this.roles.setSupportsDiscrete((Object)this.categoryRole, false);
        this.responseRole = this.role.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "Response", 10);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.roles.setDiscrete((Object)this.groupRole, true);
        this.rbBar = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.bar.silk_bar_NLS");
        this.setSupportedProperties(supportedBarElementProperties);
        this.userSetProperties.appendProperties(supportedBarElementProperties);
        this.statTypeRole = this.role.getRoleObject("ROLE_STATISTIC_TYPE");
        this.outlineClr = this.style.getLineStyleElement("Outlines").getLineColor();
        this.widthFactor = 0.85;
        this.axisDefaults = new AxisDefaults();
        this.labelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)12);
        this.addChartTabInfo("com.sas.graphics.silk.ui.LineChartPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"LineChartElement.LineChart.txt", (String)"LineChart"));
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        if (this instanceof LineChartElement && dim == 1 && (range instanceof DiscreteRange || range instanceof OrdinalRange) && this.categoryMapper != null) {
            DiscreteRange dr = (DiscreteRange)range;
            Vector values = dr.getValues();
            int size = values.size();
            boolean rebuild = false;
            if (size != this.categoryMapper.getNumberValues()) {
                rebuild = true;
            }
            this.categoryMapper.removeAllValues();
            for (int catIndex = 0; catIndex < size; ++catIndex) {
                this.categoryMapper.addValue(values.elementAt(catIndex));
            }
            if (rebuild) {
                this.prefInnerMargin.left = 0;
                this.prefInnerMargin.right = 0;
                this.layoutChart();
            }
        }
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.filter == null) {
            return;
        }
        if (this.tuple == null) {
            return;
        }
        Object aaHint = null;
        Stroke oldStroke = null;
        if (g instanceof Graphics2D) {
            aaHint = ((Graphics2D)g).getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            oldStroke = ((Graphics2D)g).getStroke();
        }
        Color[] lineColors = this.style.getDataLineColors();
        double[] projectValues = new double[3];
        int barWidth = (int)(this.fullBarWidth * this.widthFactor);
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Object[] summaryVarVals = grpVarIndex > -1 ? new Object[2] : new Object[1];
        Object[] catArray = this.categoryMapper.getValues();
        int grpValue = 0;
        LinkedHashMap<Integer[], Double> labelList = new LinkedHashMap<Integer[], Double>();
        Object[] groupVals = null;
        if (grpVarIndex > -1) {
            groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false, 10000);
        }
        int size = 1;
        if (groupVals != null) {
            size = groupVals.length;
        }
        LinkedHashMap<Integer, Integer> lineList = new LinkedHashMap<Integer, Integer>();
        LinkedHashMap<Integer, Double> catList = new LinkedHashMap<Integer, Double>();
        int nPoints = 0;
        int nextJ = 0;
        boolean missingVal = false;
        int j = 0;
        int respSize = this.allowMultiResponse ? this.numberOfResponse : 1;
        for (int i = 0; i < size; ++i) {
            if (grpVarIndex > -1 && groupVals != null) {
                summaryVarVals[1] = groupVals[i];
            }
            for (int respI = 0; respI < respSize; ++respI) {
                Color clr;
                DataStyleElement dse;
                String attrValueStr;
                this.respVar = this.respVars != null ? this.respVars[respI] : null;
                lineList.clear();
                labelList.clear();
                nPoints = 0;
                if (grpVarIndex == -1) {
                    catList.clear();
                }
                for (j = nextJ; j < catArray.length; ++j) {
                    Integer catKey;
                    summaryVarVals[0] = catArray[j];
                    double respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                    missingVal = false;
                    if (Double.isNaN(respValue)) {
                        if (!this.skipMiss || j + 1 >= catArray.length) continue;
                        missingVal = true;
                        break;
                    }
                    int catValue = this.categoryMapper.getIndex(catArray[j]);
                    if (respValue >= 0.0) {
                        catKey = new Integer(catValue + 1);
                        catList.put(catKey, new Double(respValue));
                    } else {
                        catKey = new Integer(-(catValue + 1));
                        catList.put(catKey, new Double(respValue));
                    }
                    double catPos = 0.0;
                    if (this.honorBarWidth) {
                        switch (this.anchor) {
                            case 19305: {
                                catPos = -(barWidth / 2);
                                break;
                            }
                            case 19306: {
                                catPos = barWidth / 2;
                                break;
                            }
                            default: {
                                catPos = 0.0;
                            }
                        }
                    }
                    projectValues = this.transformObject.project(catValue, respValue, 0.0, projectValues);
                    lineList.put(new Integer((int)(projectValues[0] + catPos)), new Integer((int)projectValues[1]));
                    if (!this.showLabels) continue;
                    Integer[] objXY = new Integer[]{new Integer((int)(projectValues[0] + catPos)), new Integer((int)projectValues[1])};
                    labelList.put(objXY, new Double(respValue));
                }
                nPoints = lineList.size();
                int[] xVals = new int[nPoints];
                int[] yVals = new int[nPoints];
                Object[] xObjs = lineList.keySet().toArray();
                Object[] yObjs = lineList.values().toArray();
                for (int k = 0; k < nPoints; ++k) {
                    xVals[k] = ((Number)xObjs[k]).intValue();
                    yVals[k] = ((Number)yObjs[k]).intValue();
                }
                if (grpVarIndex > -1 && this.groupMapper != null && groupVals != null) {
                    grpValue = i;
                    attrValueStr = groupVals[i].toString();
                    dse = SILKUtilities.getStyleElement(attrValueStr, grpValue, 2, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
                    clr = dse.getLineColor();
                } else {
                    grpValue = 0;
                    if (respSize > 1) {
                        clr = lineColors[respI % lineColors.length];
                    } else {
                        attrValueStr = this.roles.getVariable((Object)this.categoryRole, 0).toString();
                        dse = SILKUtilities.getStyleElement(attrValueStr, -1, 2, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
                        clr = dse.getLineColor();
                    }
                }
                g.setColor(clr);
                if (nPoints > 1) {
                    ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                    g.drawPolyline(xVals, yVals, nPoints);
                } else if (nPoints == 1) {
                    ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
                    g.drawRect(xVals[0] - 2, yVals[0] - 2, 4, 4);
                }
                if (this.showLabels) {
                    this.drawLabels(g, labelList);
                }
                if (!this.allowMultiResponse) continue;
                if (missingVal) {
                    nextJ = j + 1;
                    --respI;
                    continue;
                }
                nextJ = 0;
            }
            if (missingVal) {
                nextJ = j + 1;
                --i;
                continue;
            }
            nextJ = 0;
        }
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
            ((Graphics2D)g).setStroke(oldStroke);
        }
    }

    protected void drawLabels(Graphics g, LinkedHashMap labelList) {
        if (labelList != null && labelList.size() > 0) {
            FontRenderContext frc = new FontRenderContext(null, true, true);
            Object[] keyArray = labelList.keySet().toArray();
            Object[] valArray = labelList.values().toArray();
            TextStyleElement tse = this.style.getTextStyleElement("ValueText");
            for (int i = 0; i < keyArray.length; ++i) {
                Object[] objXY = (Object[])keyArray[i];
                int xPos = ((Number)objXY[0]).intValue();
                int yPos = ((Number)objXY[1]).intValue();
                g.setColor(tse.getTextColor());
                String label = this.getFormattedLabel(valArray[i]);
                if (label == null) continue;
                label = label.trim();
                TextLayout txtStr = new TextLayout(label, this.labelFont, frc);
                txtStr.draw((Graphics2D)g, (float)xPos - (float)((int)(txtStr.getVisibleAdvance() / 2.0f)), yPos - 2);
            }
        }
    }

    protected String getFormattedLabel(Object object) {
        if (object != null) {
            Object format = null;
            double value = ((Number)object).doubleValue();
            if (this.statType == 11) {
                format = SASFormat.getInstance((String)"Percent8.2");
                value /= 100.0;
            } else {
                format = this.statType == 12 ? SASFormat.getInstance((String)"Best8.0") : this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, 0), SASFormat.class);
            }
            if (this.statType == 11) {
                String percentString = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(value), format).trim();
                int length = percentString.length();
                String temp = percentString.substring(0, length - 1);
                return temp;
            }
            return this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(value), format);
        }
        return null;
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        if (this.tuple == null) {
            return;
        }
        Color selectionColor = this.style.getLineStyleElement("Selection").getLineColor();
        double[] projectValues = new double[3];
        int barWidth = (int)(this.fullBarWidth * this.widthFactor);
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Object[] summaryVarVals = grpVarIndex > -1 ? new Object[2] : new Object[1];
        String catObj = null;
        String grpObj = null;
        LinkedHashMap<Integer, Object[]> selectionList = new LinkedHashMap<Integer, Object[]>();
        int num = 0;
        while (this.selections.hasMoreSelections()) {
            int index = this.selections.nextSelectedIndex();
            catObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.categoryRole, 0), (long)index, null);
            grpObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.groupRole, 0), (long)index, null);
            Object[] catgrpObj = new Object[]{catObj, grpObj};
            selectionList.put(new Integer(num), catgrpObj);
            ++num;
        }
        Object[] selectionKeyArray = selectionList.keySet().toArray();
        Object[] selectionValArray = selectionList.values().toArray();
        int catValue = 0;
        Object[] groupVals = null;
        if (grpVarIndex > -1) {
            groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false, 10000);
        }
        int size = 1;
        if (groupVals != null) {
            size = groupVals.length;
        }
        Object[] catArray = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), false, 10000);
        LinkedHashMap<Integer, Double> catList = new LinkedHashMap<Integer, Double>();
        int nextJ = 0;
        int j = 0;
        int respSize = this.allowMultiResponse ? this.numberOfResponse : 1;
        for (int i = 0; i < size; ++i) {
            if (grpVarIndex > -1 && groupVals != null) {
                summaryVarVals[1] = groupVals[i];
            }
            for (int respI = 0; respI < respSize; ++respI) {
                Object object = this.respVar = this.respVars != null ? this.respVars[respI] : null;
                if (grpVarIndex == -1) {
                    catList.clear();
                }
                for (j = nextJ; j < catArray.length; ++j) {
                    Integer catKey;
                    summaryVarVals[0] = catArray[j];
                    double respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                    if (Double.isNaN(respValue)) continue;
                    catValue = this.categoryMapper.getIndex(summaryVarVals[0]);
                    if (respValue >= 0.0) {
                        catKey = new Integer(catValue + 1);
                        catList.put(catKey, new Double(respValue));
                    } else {
                        catKey = new Integer(-(catValue + 1));
                        catList.put(catKey, new Double(respValue));
                    }
                    double catPos = 0.0;
                    if (this.honorBarWidth) {
                        switch (this.anchor) {
                            case 19305: {
                                catPos = -(barWidth / 2);
                                break;
                            }
                            case 19306: {
                                catPos = barWidth / 2;
                                break;
                            }
                            default: {
                                catPos = 0.0;
                            }
                        }
                    }
                    projectValues = this.transformObject.project(catValue, respValue, 0.0, projectValues);
                    boolean drawSel = false;
                    for (int selIndx = 0; selIndx < selectionKeyArray.length; ++selIndx) {
                        if (grpVarIndex > -1 && groupVals != null) {
                            if (!((Object[])selectionValArray[selIndx])[1].equals(groupVals[i]) || !((Object[])selectionValArray[selIndx])[0].equals(catArray[j])) continue;
                            drawSel = true;
                            break;
                        }
                        if (!((Object[])selectionValArray[selIndx])[0].equals(catArray[j])) continue;
                        drawSel = true;
                        break;
                    }
                    if (!drawSel) continue;
                    ((Graphics2D)g).setPaint(selectionColor);
                    g.fillRect((int)(projectValues[0] + catPos) - 2, (int)projectValues[1] - 2, 4, 4);
                }
            }
        }
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (this.filter == null) {
            return null;
        }
        if (this.tuple == null) {
            return null;
        }
        double[] projectValues = new double[3];
        int barWidth = (int)(this.fullBarWidth * this.widthFactor);
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Object[] summaryVarVals = grpVarIndex > -1 ? new Object[2] : new Object[1];
        Object[] catArray = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), false, 10000);
        int catValue = 0;
        LinkedHashMap<Integer, Double> catList = new LinkedHashMap<Integer, Double>();
        Object[] groupVals = null;
        if (grpVarIndex > -1) {
            groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false, 10000);
        }
        int size = 1;
        if (groupVals != null) {
            size = groupVals.length;
        }
        int respSize = this.allowMultiResponse ? this.numberOfResponse : 1;
        Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rbBar, (String)"Bar.Probe.fmt.txt", (String)"{0} : {1}"));
        for (int i = 0; i < size; ++i) {
            if (grpVarIndex > -1 && groupVals != null) {
                summaryVarVals[1] = groupVals[i];
            }
            for (int respI = 0; respI < respSize; ++respI) {
                Object object = this.respVar = this.respVars != null ? this.respVars[respI] : null;
                if (grpVarIndex == -1) {
                    catList.clear();
                }
                for (int j = 0; j < catArray.length; ++j) {
                    String str;
                    Rectangle rect;
                    Integer catKey;
                    double respValue;
                    summaryVarVals[0] = catArray[j];
                    double actualRespVal = respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                    if (Double.isNaN(respValue)) continue;
                    catValue = this.categoryMapper.getIndex(catArray[j]);
                    if (respValue >= 0.0) {
                        catKey = new Integer(catValue + 1);
                        catList.put(catKey, new Double(respValue));
                    } else {
                        catKey = new Integer(-(catValue + 1));
                        catList.put(catKey, new Double(respValue));
                    }
                    double catPos = 0.0;
                    if (this.honorBarWidth) {
                        switch (this.anchor) {
                            case 19305: {
                                catPos = -(barWidth / 2);
                                break;
                            }
                            case 19306: {
                                catPos = barWidth / 2;
                                break;
                            }
                            default: {
                                catPos = 0.0;
                            }
                        }
                    }
                    if (!(rect = new Rectangle((int)((projectValues = this.transformObject.project(catValue, respValue, 0.0, projectValues))[0] + catPos - 2.0), (int)projectValues[1] - 2, 4, 4)).contains(screenX, screenY)) continue;
                    String xstr = probeMessage.toString(this.filter.getVariableDescription(this.roles.getVariable((Object)this.categoryRole, 0)), catArray[j]);
                    Object format = null;
                    Object yVar = this.roles.getVariable((Object)this.responseRole, respI);
                    if (yVar != null) {
                        String suffixStr = this.statType == 1 ? statName_Sum.toString() : statName_Mean.toString();
                        yVar = this.filter.getVariableDescription(yVar);
                        yVar = yVar.toString() + "(" + suffixStr + ")";
                        format = this.filter.getFormat(this.roles.getVariable((Object)this.responseRole, respI), SASFormat.class);
                    }
                    if (yVar == null) {
                        if (this.statType == 11) {
                            yVar = statName_Percent;
                            format = SASFormat.getInstance((String)"Percent8.2");
                            actualRespVal /= 100.0;
                        } else {
                            yVar = statName_Frequency;
                            format = SASFormat.getInstance((String)"Best8.0");
                        }
                    }
                    String yValStr = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, respI), (Object)new Double(actualRespVal), format);
                    String ystr = "\n" + probeMessage.toString((Object)(this.userComputedResponseLabel == null ? yVar.toString() : this.userComputedResponseLabel), (Object)yValStr);
                    if (grpVarIndex > -1) {
                        String grpstr = "\n" + probeMessage.toString(this.filter.getVariableDescription(this.roles.getVariable((Object)this.groupRole, 0)), groupVals[i]);
                        str = xstr + ystr + grpstr;
                    } else {
                        str = xstr + ystr;
                    }
                    str = str.replaceAll("=", "\t=\t");
                    str = str.replaceAll("\\[", "\t \t\\[");
                    return str;
                }
            }
        }
        return null;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        DataRange[] ranges;
        String[] vars;
        if (this.filter == null) {
            return false;
        }
        if (this.tuple == null) {
            return false;
        }
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        double[] projectValues = new double[3];
        int barWidth = (int)(this.fullBarWidth * this.widthFactor);
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        Object[] summaryVarVals = grpVarIndex > -1 ? new Object[2] : new Object[1];
        Object[] catArray = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.categoryRole, 0), false, 10000);
        int catValue = 0;
        LinkedHashMap<Integer, Double> catList = new LinkedHashMap<Integer, Double>();
        Object[] groupVals = null;
        if (grpVarIndex > -1) {
            groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false, 10000);
        }
        int size = 1;
        if (groupVals != null) {
            size = groupVals.length;
        }
        int respSize = this.allowMultiResponse ? this.numberOfResponse : 1;
        Vector<Object> catVector = new Vector<Object>();
        Vector<Object> grpVector = new Vector<Object>();
        for (int i = 0; i < size; ++i) {
            if (grpVarIndex > -1 && groupVals != null) {
                summaryVarVals[1] = groupVals[i];
            }
            for (int respI = 0; respI < respSize; ++respI) {
                Object object = this.respVar = this.respVars != null ? this.respVars[respI] : null;
                if (grpVarIndex == -1) {
                    catList.clear();
                }
                for (int j = 0; j < catArray.length; ++j) {
                    Integer catKey;
                    summaryVarVals[0] = catArray[j];
                    double respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                    if (Double.isNaN(respValue)) continue;
                    catValue = this.categoryMapper.getIndex(catArray[j]);
                    if (respValue >= 0.0) {
                        catKey = new Integer(catValue + 1);
                        catList.put(catKey, new Double(respValue));
                    } else {
                        catKey = new Integer(-(catValue + 1));
                        catList.put(catKey, new Double(respValue));
                    }
                    double catPos = 0.0;
                    if (this.honorBarWidth) {
                        switch (this.anchor) {
                            case 19305: {
                                catPos = -(barWidth / 2);
                                break;
                            }
                            case 19306: {
                                catPos = barWidth / 2;
                                break;
                            }
                            default: {
                                catPos = 0.0;
                            }
                        }
                    }
                    projectValues = this.transformObject.project(catValue, respValue, 0.0, projectValues);
                    projectValues[0] = projectValues[0] + catPos;
                    if (!selectArea.contains(projectValues[0], projectValues[1])) continue;
                    catVector.addElement(summaryVarVals[0]);
                    if (grpVarIndex <= -1) continue;
                    grpVector.addElement(summaryVarVals[1]);
                }
            }
        }
        if (grpVarIndex > -1) {
            vars = new String[]{this.roles.getVariable((Object)this.categoryRole, 0).toString(), this.roles.getVariable((Object)this.groupRole, 0).toString()};
            ranges = new DataRange[]{new DiscreteRange(catVector.toArray()), new DiscreteRange(grpVector.toArray())};
        } else {
            vars = new String[]{this.roles.getVariable((Object)this.categoryRole, 0).toString()};
            ranges = new DataRange[]{new DiscreteRange(catVector.toArray())};
        }
        if (this.filter != null) {
            if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                ((AbstractDataFilter)this.filter).toggleSelected(vars, ranges, true);
            } else {
                this.filter.setSelected(vars, ranges, select, true);
            }
        }
        return true;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
            }
        }
        this.createTuple();
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        this.fireLayerListenerChanged(3);
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 1: 
            case 24: {
                if (this.filter == null) break;
                Object o = this.roles.getVariable((Object)this.categoryRole, 0);
                if (this.filter.isNumericVariable(o)) {
                    this.responseSortType = RoleInterface.ROLE_SORT_NONE;
                } else {
                    this.categorySortType = RoleInterface.ROLE_SORT_DATA;
                }
                if (this.categoryMapper == null) {
                    this.categoryMapper = new CharacterVariableMapper(this.filter, o);
                } else {
                    this.categoryMapper.setVariable(o);
                }
                this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
                break;
            }
            case 6: {
                if (this.filter == null) break;
                if (this.groupMapper == null) {
                    this.groupMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable((Object)this.groupRole, 0));
                } else {
                    this.groupMapper.setVariable(this.roles.getVariable((Object)this.groupRole, 0));
                }
                this.allowMultiResponse = false;
                this.lce.setAction(6);
                this.lce.setBuildData(this.groupRole.toString());
                this.fireLayerListenerChanged(this.lce);
                break;
            }
            case 17: {
                this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
                int n = this.numberOfResponse = this.respVars != null ? this.respVars.length : 1;
                if (this.numberOfResponse > 1) {
                    this.allowMultiResponse = true;
                    this.roles.deleteRole((Object)this.groupRole);
                } else {
                    this.roles.newRole((Object)this.groupRole, "Group", 1);
                }
                Object object = this.respVar = this.respVars != null ? this.respVars[0] : null;
                if (this.respVar == null || this.statType != 12 && this.statType != 11) break;
                this.statType = 1;
                break;
            }
            case 38: {
                Object obj = this.roles.getVariable((Object)this.statTypeRole);
                if (!(obj instanceof String)) break;
                this.setStatistic(obj);
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.categoryMapper = null;
                break;
            }
            case 6: {
                this.groupMapper = null;
                this.allowMultiResponse = true;
                break;
            }
            case 17: {
                this.respVar = null;
                this.respVars = null;
                this.numberOfResponse = 1;
                this.respVars = (Object[])this.roles.getVariable((Object)this.responseRole);
                int n = this.numberOfResponse = this.respVars != null ? this.respVars.length : 1;
                if (this.respVars != null) {
                    this.numberOfResponse = this.respVars.length;
                    this.respVar = this.respVars != null ? this.respVars[0] : null;
                } else {
                    this.statType = 12;
                }
                if (this.numberOfResponse > 1) {
                    this.allowMultiResponse = true;
                    this.roles.deleteRole((Object)this.groupRole);
                    break;
                }
                this.roles.newRole((Object)this.groupRole, "Group", 1);
            }
        }
    }

    @Override
    protected void layoutChart() {
        int xVarIndex;
        super.layoutChart();
        if (this.filter != null && (this.honorBarWidth || this.showLabels) && (xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0))) > -1 && this.categoryMapper != null) {
            int halfWidth = 0;
            this.fullBarWidth = this.bounds.width / this.categoryMapper.getNumberValues();
            if (this.honorBarWidth) {
                halfWidth = (int)(this.fullBarWidth / 2.0);
            }
            int offsetBottom = 0;
            int offsetTop = 0;
            if (this.showLabels) {
                this.setDefaultLabelFont();
                offsetTop = this.labelFont.getSize();
            }
            this.prefInnerMargin = new Insets(offsetTop, halfWidth, offsetBottom, halfWidth);
        }
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        if (which == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        if (rolesEnum.hasMoreElements()) {
            role = rolesEnum.nextElement();
        }
        if (role == null) {
            return null;
        }
        if (this.tuple != null && (role instanceof Number && role == RoleInterface.ROLE_Y || role.equals("Y") || role.equals(RoleInterface.ROLE_Y) || role.equals("Response") || role.equals(RoleInterface.ROLE_RESPONSE))) {
            double max = 0.0;
            double min = 0.0;
            Object[] tupleArray = this.tuple.toArray();
            int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
            LinkedHashMap<Integer, Double> respList = new LinkedHashMap<Integer, Double>();
            int respSize = this.allowMultiResponse ? this.numberOfResponse : 1;
            boolean flag = true;
            for (int respI = 0; respI < respSize; ++respI) {
                this.respVar = this.respVars != null ? this.respVars[respI] : null;
                for (int i = 0; i < tupleArray.length; ++i) {
                    Object[] summaryVarVals = (Object[])tupleArray[i];
                    int catValue = this.categoryMapper.getIndex(((Object[])tupleArray[i])[0]);
                    double respval = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                    if (Double.isNaN(respval)) continue;
                    if (grpVarIndex > -1) {
                        double val;
                        int catKey;
                        Object tmpVal;
                        double dVal;
                        if (respval >= 0.0) {
                            dVal = 0.0;
                            dVal = respval;
                            tmpVal = null;
                            catKey = catValue + 1;
                            if (respList.containsKey(new Integer(catKey)) && (tmpVal = respList.get(new Integer(catKey))) != null) {
                                val = ((Number)tmpVal).doubleValue();
                                dVal += val;
                            }
                            respList.put(new Integer(catKey), new Double(dVal));
                            respval = dVal;
                        } else {
                            dVal = 0.0;
                            dVal = respval;
                            tmpVal = null;
                            catKey = catValue + 1;
                            if (respList.containsKey(new Integer(catKey = -catKey)) && (tmpVal = respList.get(new Integer(catKey))) != null) {
                                val = ((Number)tmpVal).doubleValue();
                                dVal += val;
                            }
                            respList.put(new Integer(catKey), new Double(dVal));
                            respval = dVal;
                        }
                    }
                    if (this.limitResponseAxisToDataVals && respSize > 0 && flag) {
                        min = respval;
                        max = respval;
                        flag = false;
                    }
                    max = Math.max(max, respval);
                    min = Math.min(min, respval);
                }
            }
            this.negResp = min < 0.0;
            ContinuousRange cr = new ContinuousRange(min, max);
            ContinuousRange dr = new ContinuousRange((DataRange)cr);
            return dr;
        }
        if (this.tuple != null && (role != null && role.equals("Category") || role.equals(RoleInterface.ROLE_X) || role.equals(RoleInterface.ROLE_CATEGORY)) && (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING || this.responseSortType == RoleInterface.ROLE_SORT_DESCENDING)) {
            return new DiscreteRange(this.categoryMapper.getValues());
        }
        return super.getPreferredRange(which);
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                this.createTuple();
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 19054: {
                if (this.roles.getVariable((Object)this.responseRole, 0) == null) {
                    if (this.statType == 11) {
                        rc = this.defaults.defaultNumericFormat;
                        break;
                    }
                    rc = SASFormat.getInstance((String)"F2.0");
                    break;
                }
                Object var = this.roles.getVariable((Object)this.responseRole, 0);
                if (var == null || this.filter == null) break;
                rc = this.filter.getFormat(var, SASFormat.class);
                break;
            }
            case 19307: {
                rc = new Boolean(this.honorBarWidth);
                break;
            }
            case 19303: {
                rc = new Integer(this.anchor);
                break;
            }
            case 19308: {
                rc = new Double(this.widthFactor);
                break;
            }
            case 19302: {
                rc = new Boolean(this.showLabels);
                break;
            }
            case 19301: {
                rc = new Boolean(this.skipMiss);
                break;
            }
            case 19309: {
                rc = new Boolean(this.limitResponseAxisToDataVals);
                break;
            }
            case 23: {
                this.currentLegend = null;
                if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1) {
                    this.currentLegend = this.groupRole.toString();
                } else if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    this.currentLegend = this.responseRole.toString();
                }
                rc = this.currentLegend;
                break;
            }
            case 434: {
                if (!this.groupRole.toString().equalsIgnoreCase(this.currentLegend)) break;
                rc = this.roles.getVariable((Object)this.groupRole, 0);
                break;
            }
            case 24: 
            case 25: {
                if (this.filter == null) break;
                Vector<SILKNumber> legNames = new Vector<SILKNumber>();
                int grpIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                if (grpIndex > -1) {
                    legNames.add(this.groupRole);
                } else if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    legNames.add(this.responseRole);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                int groupIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
                Color color = null;
                if (groupIndex > -1 && this.tuple != null) {
                    Object[] groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false);
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(groupVals.length);
                    for (int i = 0; i < groupVals.length; ++i) {
                        int grpVal = this.groupMapper.getIndex(groupVals[i]);
                        if (grpVal < 0) continue;
                        grpVal = i;
                        String attrValueStr = groupVals[i].toString();
                        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, grpVal, 2, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
                        color = dse.getLineColor();
                        LineAttrib ls = new LineAttrib(true, color, 1, 0);
                        legendEntries.add(new LegendEntry(groupVals[i], null, ls));
                    }
                    rc = legendEntries;
                    break;
                }
                if (!this.allowMultiResponse || this.numberOfResponse <= 1) break;
                Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(this.numberOfResponse);
                for (int i = 0; i < this.numberOfResponse; ++i) {
                    Object var = this.roles.getVariable((Object)this.responseRole, i);
                    var = this.filter.getVariableDescription(var);
                    String attrValueStr = var.toString();
                    DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, i, 1, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
                    color = dse.getLineColor();
                    LineAttrib ls = new LineAttrib(true, color, 1, 0);
                    legendEntries.add(new LegendEntry(var, null, ls));
                }
                rc = legendEntries;
                break;
            }
            case 426: {
                Object groupVar = this.roles.getVariable((Object)this.groupRole, 0);
                if (groupVar != null && this.filter != null) {
                    rc = this.filter.getVariableDescription(groupVar);
                }
                if (rc != null) break;
                rc = groupVar;
                break;
            }
            case 441: {
                rc = Boolean.FALSE;
                break;
            }
            case 19057: {
                rc = new Object[]{RoleInterface.ROLE_CATEGORY};
                break;
            }
            case 19056: {
                rc = new Object[]{RoleInterface.ROLE_RESPONSE};
                break;
            }
            case 19059: {
                rc = Boolean.FALSE;
                break;
            }
            case 19061: {
                rc = Boolean.FALSE;
                break;
            }
            case 19053: {
                rc = null;
                if (this.tuple == null) break;
                Object catVar = this.roles.getVariable((Object)this.categoryRole, 0);
                if (this.filter != null && catVar != null) {
                    rc = this.filter.getVariableDescription(catVar);
                }
                if (rc != null) break;
                rc = catVar;
                break;
            }
            case 19052: {
                rc = null;
                if (this.tuple == null) break;
                Object rVar = null;
                if (this.allowMultiResponse && this.numberOfResponse > 1) {
                    rVar = this.getStatistic();
                } else {
                    rVar = this.roles.getVariable((Object)this.responseRole, 0);
                    if ((rVar = this.filter.getVariableDescription(rVar)) != null) {
                        String suffixStr = this.statType == 1 ? statName_Sum.toString() : statName_Mean.toString();
                        rVar = rVar.toString() + "(" + suffixStr + ")";
                    }
                    if (rVar == null) {
                        rVar = this.userComputedResponseLabel != null ? this.userComputedResponseLabel : (this.statType == 11 ? statName_Percent : statName_Frequency);
                    }
                }
                rc = rVar;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 19307: {
                if (!(value instanceof Boolean)) break;
                this.setHonorBarWidth((Boolean)value);
                break;
            }
            case 19303: {
                if (!(value instanceof Number)) break;
                this.setAnchor(((Number)value).intValue());
                break;
            }
            case 19308: {
                if (!(value instanceof Number)) break;
                this.setWidthFactor(((Number)value).doubleValue());
                break;
            }
            case 19302: {
                if (!(value instanceof Boolean)) break;
                this.setShowLabel((Boolean)value);
                break;
            }
            case 19301: {
                if (!(value instanceof Boolean)) break;
                this.setSkipMiss((Boolean)value);
                break;
            }
            case 19309: {
                if (!(value instanceof Boolean)) break;
                this.setLimitResponseAxisToDataVals((Boolean)value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    protected void createTuple() {
        int grpVarIndex;
        if (this.filter == null) {
            return;
        }
        int catVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.categoryRole, 0));
        if (catVarIndex < 0) {
            this.tuple = null;
            return;
        }
        if (this.defaultStatistics == null) {
            this.defaultStatistics = new DefaultStatistics((Object)this.filter);
        }
        if (this.defaultStatistics == null) {
            this.tuple = null;
        }
        this.summaryVars = (grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0))) > -1 ? new Object[]{this.roles.getVariable((Object)this.categoryRole, 0), this.roles.getVariable((Object)this.groupRole, 0)} : new Object[]{this.roles.getVariable((Object)this.categoryRole, 0)};
        this.tuple = this.defaultStatistics.getSummaryVarsTuples(this.summaryVars, this.respVar);
        if (this.tuple == null) {
            return;
        }
    }

    public void setShowLabel(boolean flag) {
        this.userSetProperties.set(19302);
        this.showLabels = flag;
        this.fireLayerListenerChanged(3);
    }

    public void setHonorBarWidth(boolean flag) {
        this.honorBarWidth = flag;
        this.fireLayerListenerChanged(3);
    }

    public void setAnchor(int val) {
        this.anchor = val;
        this.fireLayerListenerChanged(3);
    }

    public void setSkipMiss(boolean flag) {
        this.userSetProperties.set(19301);
        this.skipMiss = flag;
        this.fireLayerListenerChanged(3);
    }

    public boolean getSkipMiss() {
        return this.skipMiss;
    }

    public void setLimitResponseAxisToDataVals(boolean flag) {
        this.userSetProperties.set(19309);
        this.limitResponseAxisToDataVals = flag;
        this.fireLayerListenerChanged(7);
    }

    public void setWidthFactor(double fac) {
        if (fac <= 0.0 || fac > 1.0) {
            return;
        }
        this.widthFactor = fac;
        this.userSetProperties.set(19308);
        this.fireLayerListenerChanged(1);
    }

    public double getWidthFactor() {
        return this.widthFactor;
    }

    @Override
    public void dispose() {
        this.categoryRole = null;
        this.responseRole = null;
        this.groupRole = null;
        this.rbBar = null;
        this.defaultStatistics = null;
        this.tuple = null;
        this.labelFont = null;
        this.axisDefaults = null;
        if (this.categoryMapper != null) {
            this.categoryMapper.dispose();
            this.categoryMapper = null;
        }
        if (this.groupMapper != null) {
            this.groupMapper.dispose();
            this.groupMapper = null;
        }
        super.dispose();
    }

    protected void setDefaultLabelFont() {
        int size = 0;
        size = (int)(0.5 * Math.sqrt(this.bounds.height) * this.axisDefaults.fontSizeAdjust);
        size = Math.max(this.axisDefaults.minAdjustedValueFontSize, Math.min(this.axisDefaults.maxAdjustedValueFontSize, size));
        this.labelFont = FontManager.getFont((String)this.axisDefaults.valueFontName, (int)this.axisDefaults.valueFontType, (int)size);
    }

    @Override
    public Object getVariable(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatistic();
        }
        return super.getVariable(role);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            int currStatType = DefaultStatistics.getStatisticIndex((Object)variableId);
            if (currStatType == this.statType) {
                return true;
            }
            this.setStatistic(variableId);
            this.setSortOrder((Object)this.responseRole, this.getSortOrder((Object)this.responseRole));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
            return true;
        }
        return super.setRole(variableId, role);
    }

    public void setStatistic(Object type) {
        if (type == null) {
            return;
        }
        int currStatType = DefaultStatistics.getStatisticIndex((Object)type);
        if (currStatType == this.statType) {
            return;
        }
        this.statType = currStatType;
        switch (this.statType) {
            case 11: 
            case 12: {
                if (this.respVar == null) break;
                this.statType = 1;
                break;
            }
            case 1: 
            case 2: {
                if (this.respVar != null) break;
                this.statType = 12;
                break;
            }
            default: {
                this.statType = this.respVar == null ? 12 : 1;
            }
        }
        this.fireLayerListenerChanged(3);
    }

    public Object getStatistic() {
        SILKNumber rc = null;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        switch (this.statType) {
            case 1: {
                rc = statName_Sum;
                break;
            }
            case 2: {
                rc = statName_Mean;
                break;
            }
            case 11: {
                rc = statName_Percent;
                break;
            }
            case 12: {
                rc = statName_Frequency;
                break;
            }
            default: {
                rc = respVar == null ? statName_Frequency : statName_Sum;
            }
        }
        return rc;
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        if (this.filter == null) {
            return null;
        }
        boolean cat = false;
        boolean resp = false;
        if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
            cat = true;
        }
        if (!(this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1)) {
            resp = true;
        }
        if (cat && resp) {
            return new Object[][]{{this.categoryRole, this.responseRole}};
        }
        if (cat) {
            return new Object[][]{{this.categoryRole}};
        }
        if (resp) {
            return new Object[][]{{this.responseRole}};
        }
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (role == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 1) {
            return new int[]{1, -1, 0};
        }
        if (role instanceof Number && ((Number)role).intValue() == 17) {
            if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
                return new int[]{1, -1};
            }
            return new int[]{-2, 1, -1};
        }
        return null;
    }

    @Override
    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 1) {
            return this.categorySortType;
        }
        if (role instanceof Number && ((Number)role).intValue() == 17) {
            return this.responseSortType;
        }
        return null;
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (this.filter == null || this.categoryMapper == null) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 1) {
            this.categorySortType = order;
            this.responseSortType = null;
            if (this.categoryMapper != null) {
                this.categoryMapper.setSort(((Number)order).intValue());
            }
        }
        if (role instanceof Number && ((Number)role).intValue() == 17) {
            if (this.tuple == null || this.defaultStatistics == null || order == RoleInterface.ROLE_SORT_DATA) {
                return false;
            }
            this.responseSortType = order;
            if (order == RoleInterface.ROLE_SORT_NONE) {
                if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.categoryRole, 0))) {
                    this.categorySortType = new Integer(0);
                }
                this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
                return super.setSortOrder(role, order);
            }
            if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0)) > -1 || this.allowMultiResponse && this.numberOfResponse > 1) {
                this.responseSortType = null;
                if (this.categorySortType == null) {
                    this.categorySortType = new Integer(-3);
                }
                this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
            } else {
                this.categorySortType = new Integer(-3);
                this.categoryMapper.setSort(((Number)this.categorySortType).intValue());
                Object[] catArray = this.categoryMapper.getValues();
                ArrayList<Double> responseValsList = new ArrayList<Double>();
                Object[] summaryVarVals = new Object[2];
                for (int i = 0; i < catArray.length; ++i) {
                    summaryVarVals[0] = catArray[i];
                    double respValue = this.defaultStatistics.getSummaryStatistic(this.summaryVars, this.respVar, summaryVarVals, this.statType);
                    if (Double.isNaN(respValue)) {
                        respValue = Double.NEGATIVE_INFINITY;
                    }
                    responseValsList.add(new Double(respValue));
                }
                int cOrder = -1;
                if (this.responseSortType == RoleInterface.ROLE_SORT_ASCENDING) {
                    cOrder = 1;
                } else if (this.responseSortType == RoleInterface.ROLE_SORT_DESCENDING) {
                    cOrder = -1;
                }
                Collection c = CollectionSorter.getValues(responseValsList.subList(0, responseValsList.size()), cOrder);
                Object[] sortedSumValsArray = c.toArray();
                int size = c.size();
                this.categoryMapper.removeAllValues();
                for (int i = 0; i < size; ++i) {
                    for (int k = 0; k < responseValsList.size(); ++k) {
                        if (!sortedSumValsArray[i].equals(responseValsList.get(k))) continue;
                        this.categoryMapper.addValue(catArray[k]);
                    }
                }
            }
        }
        return super.setSortOrder(role, order);
    }

    @Override
    public Object getAllVariables(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatistic();
        }
        return super.getAllVariables(role);
    }

    @Override
    public boolean addRole(Object variableId, Object role) {
        if (role == null || variableId == null) {
            return false;
        }
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            int currStatType = DefaultStatistics.getStatisticIndex((Object)variableId);
            if (currStatType == this.statType) {
                return true;
            }
            this.setStatistic((String)variableId);
            this.setSortOrder((Object)this.responseRole, this.getSortOrder((Object)this.responseRole));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
            return true;
        }
        return super.addRole(variableId, role);
    }
}

