/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.grid.MarginChangeEvent;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataPoint;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.applets.statgraph.sgchart.range.OrdinalRange;
import com.sas.graphics.applets.statgraph.sgchart.range.RangeChangedEvent;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.event.DvrDataFilterEvent;
import com.sas.graphics.silk.interfaces.DataFilterInfoInterface;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.Extract;
import com.sas.graphics.silk.util.LegendEntry;
import com.sas.graphics.silk.util.MarkerAttrib;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.DefaultStatistics;
import com.sas.graphics.util.FillPattern;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.Vector;

public class HistogramElement
extends BaseElement {
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    protected SILKNumber responseRole = null;
    protected SILKNumber frequencyRole = null;
    protected SILKNumber groupRole = null;
    protected SILKNumber colorIndexRole = null;
    protected SILKNumber statTypeRole = null;
    protected CharacterVariableMapper xMapper = null;
    protected CharacterVariableMapper yMapper = null;
    protected CharacterVariableMapper groupMapper = null;
    protected ResourceBundle rbHist = null;
    protected String currentLegend = null;
    protected int numberOfXBins = 10;
    protected int numberOfYBins = 10;
    protected int numberOfBins_X = this.numberOfXBins;
    protected int numberOfBins_Y = this.numberOfYBins;
    protected LinkedHashMap binMinMaxList_X;
    protected LinkedHashMap binMidList_X;
    protected LinkedHashMap freqList;
    protected LinkedHashMap responseList;
    protected LinkedHashMap groupList;
    protected LinkedHashMap groupFreqList;
    protected LinkedHashMap colorIndexList;
    protected LinkedHashMap binMinMaxList_Y;
    protected LinkedHashMap binMidList_Y;
    protected boolean bivariate = false;
    protected double scaleFactor = 1.0;
    protected boolean outlineOn;
    protected Color outlineColor;
    protected boolean gradient = true;
    protected boolean gradientDisable = false;
    protected boolean colorByStat = false;
    protected boolean intervalAxis = false;
    protected boolean xDiscrete = false;
    protected boolean xMinMaxSet = false;
    protected double xAxisMin = Double.NaN;
    protected double xAxisMax = Double.NaN;
    protected double[] xBinNames = null;
    protected boolean colorMapperEnabled = false;
    protected boolean styleElementSelectorEnabled = true;
    protected int statType = 12;
    protected static ResourceBundle rbUI = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.ui.silk_ui_NLS");
    protected static String statName_Frequency = ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Frequency.txt", (String)"Frequency");
    protected static String statName_Percent = ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Percent.txt", (String)"Percent");
    protected static String statName_Sum = ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Sum.txt", (String)"Sum");
    protected static String statName_Mean = ResourceLoader.getResourceString((Object)rbUI, (String)"RoleSelectionTable.Mean.txt", (String)"Mean");
    protected int sortOrderX;
    protected int sortOrderY;
    protected int groupDisplayStyle = 0;
    protected int binningInclusive = 0;
    private boolean rebuildRequired = false;
    private String styleElement = "GraphDataStyleDefault";
    public static final int[] supportedHistElementProperties = new int[]{802, 803, 804, 805, 806, 807, 820, 812, 813, 814, 815, 819, 821, 823, 809, 816, 817, 810, 811, 824, 24, 25, 23, 433, 426, 434, 441};

    public HistogramElement() {
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.roles.setSortOrder((Object)this.xRole, RoleInterface.ROLE_SORT_ASCENDING);
        this.sortOrderX = 1;
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 0);
        this.roles.setSortOrder((Object)this.yRole, RoleInterface.ROLE_SORT_ASCENDING);
        this.sortOrderY = 1;
        this.responseRole = this.role.getRoleObject("ROLE_RESPONSE");
        this.roles.newRole((Object)this.responseRole, "Response", 1);
        this.roles.setRoleType((Object)this.responseRole, 1);
        this.frequencyRole = this.role.getRoleObject("ROLE_FREQUENCY");
        this.roles.newRole((Object)this.frequencyRole, "Frequency", 1);
        this.roles.setRoleType((Object)this.frequencyRole, 1);
        this.groupRole = this.role.getRoleObject("ROLE_GROUP");
        this.roles.newRole((Object)this.groupRole, "Group", 1);
        this.roles.setRoleType((Object)this.groupRole, 0);
        this.roles.setDiscrete((Object)this.groupRole, true);
        this.colorIndexRole = this.role.getRoleObject("ROLE_COLOR_INDEX");
        this.roles.setRoleType((Object)this.colorIndexRole, 1);
        this.rbHist = ResourceLoader.loadBundle((String)"com.sas.graphics.silk.histogram.silk_histogram_NLS");
        this.statTypeRole = this.role.getRoleObject("ROLE_STATISTIC_TYPE");
        this.setSupportedProperties(supportedHistElementProperties);
        this.userSetProperties.appendProperties(supportedHistElementProperties);
        this.outlineColor = this.style.getLineStyleElement("Outlines").getLineColor();
        this.outlineOn = true;
        this.addChartTabInfo("com.sas.graphics.silk.ui.HistogramElementPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"HistogramElement.Histogram.txt", (String)"Histogram"));
    }

    @Override
    protected void drawChart(Graphics g) {
        if (this.filter == null) {
            return;
        }
        if (this.rebuildRequired) {
            this.build(Boolean.TRUE);
        }
        if (this.bivariate) {
            this.drawChart_Bivariate(g);
        } else {
            this.drawChart_Univariate(g);
        }
    }

    protected void drawChart_Univariate(Graphics g) {
        Object[] uniqueGroupVals;
        double respValue;
        if (this.filter == null) {
            return;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return;
        }
        if (this.binMidList_X != null && this.binMidList_X.size() < 1 || this.binMidList_Y != null && this.binMinMaxList_X.size() < 1) {
            return;
        }
        this.outlineColor = this.style.getLineStyleElement("Outlines").getLineColor();
        Color[] fillColors = this.style.getDataFillColors();
        Color[] lineColors = this.style.getDataLineColors();
        String attrValueStr = this.roles.getVariable((Object)this.xRole, 0).toString();
        DataStyleElement dse = SILKUtilities.getStyleElement(attrValueStr, -1, 2, this.style, this.styleElement, null).getAsDataStyle();
        Color clr = dse.getFillColor();
        Color bclr = ColorUtilities.brighter(clr, 0.2);
        Color clr1 = clr;
        Color clr2 = bclr;
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        double v1 = ((Number)((Object[])binMinMax_X_Values[0])[0]).doubleValue();
        double v2 = ((Number)((Object[])binMinMax_X_Values[0])[1]).doubleValue();
        int barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
        double respMin = 0.0;
        double respMax = 0.0;
        int size = this.binMidList_X.size();
        int xBin = 0;
        int index = 0;
        Iterator iter = this.responseList.values().iterator();
        while (iter.hasNext()) {
            respValue = ((Number)iter.next()).doubleValue();
            respMax = Math.max(respMax, respValue);
            respMin = Math.min(respMin, respValue);
        }
        Object respObj = null;
        LinkedHashMap<Object, Integer> uniqueGroupList = null;
        if (this.groupList != null && (uniqueGroupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false)).length > 0) {
            uniqueGroupList = new LinkedHashMap<Object, Integer>();
            for (int i = 0; i < uniqueGroupVals.length; ++i) {
                uniqueGroupList.put(uniqueGroupVals[i], new Integer(i));
            }
        }
        for (int i = 0; i < size; ++i) {
            GradientPaint gp;
            double endY;
            double startY;
            if (this.xBinNames != null) {
                v1 = ((Number)((Object[])binMinMax_X_Values[i])[0]).doubleValue();
                v2 = ((Number)((Object[])binMinMax_X_Values[i])[1]).doubleValue();
                barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
            }
            double center = ((Number)binMid_X[i]).doubleValue();
            index = xBin = ((Number)binMinMax_X_KeySet[i]).intValue();
            if (this.groupList != null) {
                Map grpList = (Map)this.groupList.get(new Integer(index));
                if (grpList == null) continue;
                for (Map.Entry e : grpList.entrySet()) {
                    Object grpKeyObj = e.getKey();
                    int grpVal = ((Number)grpKeyObj).intValue();
                    respObj = e.getValue();
                    if (respObj == null || (respValue = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respValue)) continue;
                    if (respValue < 0.0) {
                        if (this.transformObject.isReverse(1)) {
                            startY = respValue;
                            endY = 0.0;
                        } else {
                            startY = 0.0;
                            endY = respValue;
                        }
                    } else if (this.transformObject.isReverse(1)) {
                        startY = 0.0;
                        endY = respValue;
                    } else {
                        startY = respValue;
                        endY = 0.0;
                    }
                    projectValues = this.transformObject.project(center, startY, 0.0, projectValues);
                    projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1);
                    if (this.xMinMaxSet && (center < this.xAxisMin || center > this.xAxisMax)) {
                        g.setColor(this.outlineColor);
                        g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                        continue;
                    }
                    int grpIndx = ((Number)uniqueGroupList.get(this.groupMapper.getValue(grpVal))).intValue();
                    attrValueStr = this.groupMapper.getValue(grpVal).toString();
                    dse = SILKUtilities.getStyleElement(attrValueStr, grpIndx, 2, this.style, this.styleElement, null).getAsDataStyle();
                    clr = dse.getLineColor();
                    if (barWidth > 3) {
                        Stroke oldStroke;
                        Object clrIndexObj;
                        int clrIndex = grpVal;
                        if (this.colorIndexList != null && (clrIndexObj = this.colorIndexList.get(grpKeyObj)) != null) {
                            clrIndex = ((Number)clrIndexObj).intValue();
                        }
                        if (this.groupDisplayStyle == 1) {
                            clr = this.colorIndexList != null ? fillColors[clrIndex % fillColors.length] : dse.getFillColor();
                            if (this.gradient) {
                                bclr = ColorUtilities.brighter(clr, 0.2);
                                if (respValue < 0.0) {
                                    if (this.transformObject.isReverse(1)) {
                                        clr1 = clr;
                                        clr2 = bclr;
                                    } else {
                                        clr1 = bclr;
                                        clr2 = clr;
                                    }
                                } else if (this.transformObject.isReverse(1)) {
                                    clr1 = bclr;
                                    clr2 = clr;
                                } else {
                                    clr1 = clr;
                                    clr2 = bclr;
                                }
                                gp = new GradientPaint((float)projectValues[0], (float)projectValues[1], clr2, (float)projectValues[0], (float)projectValues_1[1], clr1);
                                ((Graphics2D)g).setPaint(gp);
                            } else {
                                g.setColor(clr);
                            }
                            g.fillRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                            if (!this.outlineOn) continue;
                            g.setColor(this.outlineColor);
                            g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                            continue;
                        }
                        if (this.groupDisplayStyle == 2) {
                            if (this.colorIndexList != null) {
                                clr = lineColors[clrIndex % lineColors.length];
                            }
                            g.setColor(clr);
                            oldStroke = ((Graphics2D)g).getStroke();
                            ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                            g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                            ((Graphics2D)g).setStroke(oldStroke);
                            continue;
                        }
                        if (grpVal == 0) {
                            clr = this.colorIndexList != null ? fillColors[clrIndex % fillColors.length] : dse.getFillColor();
                            if (this.gradient) {
                                bclr = ColorUtilities.brighter(clr, 0.2);
                                if (respValue < 0.0) {
                                    if (this.transformObject.isReverse(1)) {
                                        clr1 = clr;
                                        clr2 = bclr;
                                    } else {
                                        clr1 = bclr;
                                        clr2 = clr;
                                    }
                                } else if (this.transformObject.isReverse(1)) {
                                    clr1 = bclr;
                                    clr2 = clr;
                                } else {
                                    clr1 = clr;
                                    clr2 = bclr;
                                }
                                gp = new GradientPaint((float)projectValues[0], (float)projectValues[1], clr2, (float)projectValues[0], (float)projectValues_1[1], clr1);
                                ((Graphics2D)g).setPaint(gp);
                            } else {
                                g.setColor(clr);
                            }
                            g.fillRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                            if (!this.outlineOn) continue;
                            g.setColor(this.outlineColor);
                            g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                            continue;
                        }
                        if (this.colorIndexList != null) {
                            clr = lineColors[clrIndex % lineColors.length];
                        }
                        g.setColor(clr);
                        oldStroke = ((Graphics2D)g).getStroke();
                        ((Graphics2D)g).setStroke(new BasicStroke(2.0f));
                        g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                        ((Graphics2D)g).setStroke(oldStroke);
                        continue;
                    }
                    Stroke oldStroke = ((Graphics2D)g).getStroke();
                    ((Graphics2D)g).setStroke(new BasicStroke(barWidth));
                    g.setColor(clr);
                    g.drawLine((int)projectValues[0], (int)projectValues[1], (int)projectValues[0], (int)projectValues_1[1]);
                    ((Graphics2D)g).setStroke(oldStroke);
                }
                continue;
            }
            respObj = this.responseList.get(new Integer(index));
            if (respObj == null || (respValue = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respValue)) continue;
            if (this.colorByStat) {
                clr = this.colorMapper.getColor(respValue);
                bclr = ColorUtilities.brighter(clr, 0.2);
            }
            if (respValue < 0.0) {
                if (this.transformObject.isReverse(1)) {
                    startY = respValue;
                    endY = 0.0;
                    clr1 = clr;
                    clr2 = bclr;
                } else {
                    startY = 0.0;
                    endY = respValue;
                    clr1 = bclr;
                    clr2 = clr;
                }
            } else if (this.transformObject.isReverse(1)) {
                startY = 0.0;
                endY = respValue;
                clr1 = bclr;
                clr2 = clr;
            } else {
                startY = respValue;
                endY = 0.0;
                clr1 = clr;
                clr2 = bclr;
            }
            projectValues = this.transformObject.project(center, startY, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1);
            if (this.xMinMaxSet && (center < this.xAxisMin || center > this.xAxisMax)) {
                g.setColor(this.outlineColor);
                g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                continue;
            }
            if (barWidth > 3) {
                if (this.gradient) {
                    gp = new GradientPaint((float)projectValues[0], (float)projectValues[1], clr2, (float)projectValues[0], (float)projectValues_1[1], clr1);
                    ((Graphics2D)g).setPaint(gp);
                } else {
                    g.setColor(clr);
                }
                g.fillRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                if (!this.outlineOn) continue;
                g.setColor(this.outlineColor);
                g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
                continue;
            }
            Stroke oldStroke = ((Graphics2D)g).getStroke();
            ((Graphics2D)g).setStroke(new BasicStroke(barWidth));
            g.setColor(clr);
            g.drawLine((int)projectValues[0], (int)projectValues[1], (int)projectValues[0], (int)projectValues_1[1]);
            ((Graphics2D)g).setStroke(oldStroke);
        }
        this.drawBaseLine(g);
    }

    protected void drawBaseLine(Graphics g) {
        double[] projectValues = new double[3];
        projectValues = this.transformObject.project(0.0, 0.0, 0.0, projectValues);
        Color baseLineColor = this.style.getLineStyleElement("AxisLines").getLineColor();
        g.setColor(baseLineColor);
        g.drawLine(this.bounds.x, (int)projectValues[1], this.bounds.x + this.bounds.width, (int)projectValues[1]);
    }

    protected void drawChart_Bivariate(Graphics g) {
        double respValue;
        if (this.filter == null) {
            return;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1 || this.binMidList_Y.size() < 1 || this.binMinMaxList_Y.size() < 1) {
            return;
        }
        this.outlineColor = this.style.getLineStyleElement("Outlines").getLineColor();
        double respMin = 0.0;
        double respMax = 0.0;
        Iterator iter = this.responseList.values().iterator();
        while (iter.hasNext()) {
            respValue = ((Number)iter.next()).doubleValue();
            respMax = Math.max(respMax, respValue);
            respMin = Math.min(respMin, respValue);
        }
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        Object[] binMinMax_Y_KeySet = this.binMinMaxList_Y.keySet().toArray();
        Object[] binMinMax_Y_Values = this.binMinMaxList_Y.values().toArray();
        Object[] binMid_Y = this.binMidList_Y.values().toArray();
        double[] projectValues = new double[3];
        double v1 = ((Number)((Object[])binMinMax_X_Values[0])[0]).doubleValue();
        double v2 = ((Number)((Object[])binMinMax_X_Values[0])[1]).doubleValue();
        int barWidth_X = this.getBinWidthOnScreen((byte)1, v1, v2);
        v1 = ((Number)((Object[])binMinMax_Y_Values[0])[0]).doubleValue();
        v2 = ((Number)((Object[])binMinMax_Y_Values[0])[1]).doubleValue();
        int barWidth_Y = this.getBinWidthOnScreen((byte)2, v1, v2);
        barWidth_X = (int)((double)barWidth_X * this.scaleFactor);
        barWidth_Y = (int)((double)barWidth_Y * this.scaleFactor);
        int size_X = this.binMidList_X.size();
        int size_Y = this.binMidList_Y.size();
        Object respObj = null;
        for (int j = 0; j < size_Y; ++j) {
            double center_Y = ((Number)binMid_Y[j]).doubleValue();
            int yBin = ((Number)binMinMax_Y_KeySet[j]).intValue();
            for (int i = 0; i < size_X; ++i) {
                double center_X = ((Number)binMid_X[i]).doubleValue();
                int xBin = ((Number)binMinMax_X_KeySet[i]).intValue();
                int index = xBin + yBin * this.numberOfBins_X;
                respObj = this.responseList.get(new Integer(index));
                if (respObj == null || (respValue = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respValue)) continue;
                projectValues = this.transformObject.project(center_X, center_Y, 0.0, projectValues);
                Color respclr = this.colorMapper.getColor(respValue);
                g.setColor(respclr);
                g.fillRect((int)(projectValues[0] - (double)(barWidth_X / 2)), (int)(projectValues[1] - (double)(barWidth_Y / 2)), barWidth_X, barWidth_Y);
                if (!this.outlineOn) continue;
                g.setColor(this.outlineColor);
                g.drawRect((int)(projectValues[0] - (double)(barWidth_X / 2)), (int)(projectValues[1] - (double)(barWidth_Y / 2)), barWidth_X, barWidth_Y);
            }
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        if (this.bivariate) {
            this.drawSelected_Bivariate(g);
        } else {
            this.drawSelected_Univariate(g);
        }
    }

    protected void drawSelected_Univariate(Graphics g) {
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1) {
            return;
        }
        if (this.groupList != null) {
            return;
        }
        Color selectionColor = this.style.getLineStyleElement("Selection").getLineColor();
        TexturePaint tp = null;
        FillPattern fillPattern = new FillPattern();
        tp = fillPattern.getHatch45(selectionColor);
        LinkedHashMap<Object, Double> selectionList = new LinkedHashMap<Object, Double>();
        Object xObj = null;
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        int size = this.binMidList_X.size();
        int xBin = 0;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        Object freqVar = this.roles.getVariable((Object)this.frequencyRole, 0);
        double resp = 1.0;
        double freq = 1.0;
        while (this.selections.hasMoreSelections()) {
            int index = this.selections.nextSelectedIndex();
            if (this.xMapper != null) {
                xObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.xRole, 0), (long)index, null);
                xObj = new Double(this.xMapper.getIndex(xObj));
            } else {
                xObj = this.filter.getValue(this.roles.getVariable((Object)this.xRole, 0), (long)index);
                double xValue = ((Number)xObj).doubleValue();
                for (int j = 0; j < size; ++j) {
                    double lowLimit;
                    double highLimit;
                    xBin = ((Number)binMinMax_X_KeySet[j]).intValue();
                    if (this.binningInclusive == 1) {
                        highLimit = ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue();
                        double d = lowLimit = xBin != 0 ? ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue() : ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue() - 0.1;
                        if (!(xValue > lowLimit) || !(xValue <= highLimit)) continue;
                        xObj = binMid_X[j];
                        continue;
                    }
                    lowLimit = ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue();
                    double d = highLimit = xBin != this.numberOfBins_X - 1 ? ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue() : ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue() + 0.1;
                    if (!(xValue >= lowLimit) || !(xValue < highLimit)) continue;
                    xObj = binMid_X[j];
                }
            }
            resp = 1.0;
            freq = 1.0;
            if (freqVar != null) {
                freq = ((Number)this.filter.getValue(freqVar, (long)index)).doubleValue();
            }
            if (respVar != null) {
                resp = ((Number)this.filter.getValue(respVar, (long)index)).doubleValue();
            }
            if (Double.isNaN(resp) || Double.isNaN(freq) || freq <= 0.0) continue;
            if (selectionList.containsKey(xObj)) {
                double tempVal = ((Number)selectionList.get(xObj)).doubleValue();
                selectionList.put(xObj, new Double(tempVal += freq));
                continue;
            }
            selectionList.put(xObj, new Double(freq));
        }
        Object[] selectionKeyArray = selectionList.keySet().toArray();
        Object[] selectionValArray = selectionList.values().toArray();
        double respValue = 0.0;
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        int index = 0;
        Object freqObj = null;
        Object respObj = null;
        for (int i = 0; i < selectionKeyArray.length; ++i) {
            double endY;
            double startY;
            xObj = selectionKeyArray[i];
            respValue = ((Number)selectionValArray[i]).doubleValue();
            int j = 0;
            for (j = 0; j < size && ((Number)xObj).doubleValue() != ((Number)binMid_X[j]).doubleValue(); ++j) {
            }
            if (j == size) continue;
            double v1 = ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue();
            double v2 = ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue();
            int barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
            index = xBin = ((Number)binMinMax_X_KeySet[j]).intValue();
            freqObj = this.freqList.get(new Integer(index));
            respObj = this.responseList.get(new Integer(index));
            if (respObj == null || freqObj == null) continue;
            respValue /= ((Number)freqObj).doubleValue();
            if ((respValue *= ((Number)respObj).doubleValue()) == 0.0) continue;
            if (respValue < 0.0) {
                if (this.transformObject.isReverse(1)) {
                    startY = respValue;
                    endY = 0.0;
                } else {
                    startY = 0.0;
                    endY = respValue;
                }
            } else if (this.transformObject.isReverse(1)) {
                startY = 0.0;
                endY = respValue;
            } else {
                startY = respValue;
                endY = 0.0;
            }
            double center = ((Number)binMid_X[j]).doubleValue();
            projectValues = this.transformObject.project(center, startY, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1);
            ((Graphics2D)g).setPaint(tp);
            g.fillRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            ((Graphics2D)g).setPaint(selectionColor);
            g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
        }
    }

    protected void drawSelected_Bivariate(Graphics g) {
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        if (xVar == null || yVar == null) {
            return;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1 || this.binMidList_Y.size() < 1 || this.binMinMaxList_Y.size() < 1) {
            return;
        }
        Color selectionColor = this.style.getLineStyleElement("Selection").getLineColor();
        TexturePaint tp = null;
        FillPattern fillPattern = new FillPattern();
        tp = fillPattern.getHatch45(selectionColor);
        LinkedHashMap<Integer, Double> selectionList = new LinkedHashMap<Integer, Double>();
        Object xObj = null;
        Object yObj = null;
        Integer indexObj = null;
        Object[] xyObj = null;
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMinMax_Y_KeySet = this.binMinMaxList_Y.keySet().toArray();
        Object[] binMinMax_Y_Values = this.binMinMaxList_Y.values().toArray();
        int xIndex = 0;
        int yIndex = 0;
        int size_X = this.binMidList_X.size();
        int size_Y = this.binMidList_Y.size();
        int xBin = 0;
        int yBin = 0;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        Object freqVar = this.roles.getVariable((Object)this.frequencyRole, 0);
        double resp = 1.0;
        double freq = 1.0;
        while (this.selections.hasMoreSelections()) {
            int j;
            int index = this.selections.nextSelectedIndex();
            if (this.xMapper != null) {
                xObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.xRole, 0), (long)index, null);
                xIndex = this.xMapper.getIndex(xObj);
            } else {
                xObj = this.filter.getValue(this.roles.getVariable((Object)this.xRole, 0), (long)index);
                double xValue = ((Number)xObj).doubleValue();
                for (j = 0; j < size_X; ++j) {
                    double lowLimit_X;
                    double highLimit_X;
                    xBin = ((Number)binMinMax_X_KeySet[j]).intValue();
                    if (this.binningInclusive == 1) {
                        highLimit_X = ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue();
                        double d = lowLimit_X = xBin != 0 ? ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue() : ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue() - 0.1;
                        if (!(xValue > lowLimit_X) || !(xValue <= highLimit_X)) continue;
                        xIndex = xBin;
                        continue;
                    }
                    lowLimit_X = ((Number)((Object[])binMinMax_X_Values[j])[0]).doubleValue();
                    double d = highLimit_X = xBin != this.numberOfBins_X - 1 ? ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue() : ((Number)((Object[])binMinMax_X_Values[j])[1]).doubleValue() + 0.1;
                    if (!(xValue >= lowLimit_X) || !(xValue < highLimit_X)) continue;
                    xIndex = xBin;
                }
            }
            if (this.yMapper != null) {
                yObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.yRole, 0), (long)index, null);
                yIndex = this.yMapper.getIndex(yObj);
            } else {
                yObj = this.filter.getValue(this.roles.getVariable((Object)this.yRole, 0), (long)index);
                double yValue = ((Number)yObj).doubleValue();
                for (j = 0; j < size_Y; ++j) {
                    double lowLimit_Y;
                    double highLimit_Y;
                    yBin = ((Number)binMinMax_Y_KeySet[j]).intValue();
                    if (this.binningInclusive == 1) {
                        highLimit_Y = ((Number)((Object[])binMinMax_Y_Values[j])[1]).doubleValue();
                        double d = lowLimit_Y = yBin != 0 ? ((Number)((Object[])binMinMax_Y_Values[j])[0]).doubleValue() : ((Number)((Object[])binMinMax_Y_Values[j])[0]).doubleValue() - 0.1;
                        if (!(yValue > lowLimit_Y) || !(yValue <= highLimit_Y)) continue;
                        yIndex = yBin;
                        continue;
                    }
                    lowLimit_Y = ((Number)((Object[])binMinMax_Y_Values[j])[0]).doubleValue();
                    double d = highLimit_Y = yBin != this.numberOfBins_Y - 1 ? ((Number)((Object[])binMinMax_Y_Values[j])[1]).doubleValue() : ((Number)((Object[])binMinMax_Y_Values[j])[1]).doubleValue() + 0.1;
                    if (!(yValue >= lowLimit_Y) || !(yValue < highLimit_Y)) continue;
                    yIndex = yBin;
                }
            }
            xyObj = new Object[]{xObj, yObj};
            indexObj = new Integer(xIndex + yIndex * this.numberOfBins_X);
            resp = 1.0;
            freq = 1.0;
            if (freqVar != null) {
                freq = ((Number)this.filter.getValue(freqVar, (long)index)).doubleValue();
            }
            if (respVar != null) {
                resp = ((Number)this.filter.getValue(respVar, (long)index)).doubleValue();
            }
            if (Double.isNaN(resp) || Double.isNaN(freq) || freq <= 0.0) continue;
            if (selectionList.containsKey(indexObj)) {
                double tempVal = ((Number)selectionList.get(indexObj)).doubleValue();
                selectionList.put(indexObj, new Double(tempVal += freq));
                continue;
            }
            selectionList.put(indexObj, new Double(freq));
        }
        Object[] selectionKeyArray = selectionList.keySet().toArray();
        Object[] selectionValArray = selectionList.values().toArray();
        double respValue = 0.0;
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        double v1 = ((Number)((Object[])binMinMax_X_Values[0])[0]).doubleValue();
        double v2 = ((Number)((Object[])binMinMax_X_Values[0])[1]).doubleValue();
        int barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
        Object freqObj = null;
        Object respObj = null;
        for (int i = 0; i < selectionKeyArray.length; ++i) {
            double endY;
            double startY;
            Object obj1;
            respValue = ((Number)selectionValArray[i]).doubleValue();
            int j = 0;
            int k = 0;
            int index = ((Number)selectionKeyArray[i]).intValue();
            j = index % this.numberOfBins_X;
            k = (index - j) / this.numberOfBins_X;
            if (respValue == 0.0 || (obj1 = this.binMinMaxList_Y.get(new Integer(k))) == null) continue;
            Object[] obj2 = (Object[])obj1;
            double adjust = (((Number)obj2[1]).doubleValue() - ((Number)obj2[0]).doubleValue()) * (1.0 - this.scaleFactor) / 2.0;
            double binMinY = ((Number)obj2[0]).doubleValue() + adjust;
            double binMaxY = ((Number)obj2[1]).doubleValue() - adjust;
            freqObj = this.freqList.get(new Integer(index));
            respObj = this.responseList.get(new Integer(index));
            if (respObj == null || freqObj == null) continue;
            if (respValue < 0.0) {
                if (this.transformObject.isReverse(1)) {
                    startY = binMinY + (binMaxY - binMinY) / ((Number)freqObj).doubleValue() * respValue;
                    endY = binMinY;
                } else {
                    startY = binMaxY - (binMaxY - binMinY) / ((Number)freqObj).doubleValue() * respValue;
                    endY = binMaxY;
                }
            } else if (this.transformObject.isReverse(1)) {
                startY = binMaxY - (binMaxY - binMinY) / ((Number)freqObj).doubleValue() * respValue;
                endY = binMaxY;
            } else {
                startY = binMinY + (binMaxY - binMinY) / ((Number)freqObj).doubleValue() * respValue;
                endY = binMinY;
            }
            double center = ((Number)this.binMidList_X.get(new Integer(j))).doubleValue();
            projectValues = this.transformObject.project(center, startY, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1);
            ((Graphics2D)g).setPaint(tp);
            g.fillRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            ((Graphics2D)g).setPaint(selectionColor);
            g.drawRect((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
        }
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        if (this.filter == null) {
            return null;
        }
        if (this.bivariate) {
            return this.getTipText_Bivariate(screenX, screenY);
        }
        return this.getTipText_Univariate(screenX, screenY);
    }

    protected String getTipText_Univariate(int screenX, int screenY) {
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return null;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1) {
            return null;
        }
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        double v1 = ((Number)((Object[])binMinMax_X_Values[0])[0]).doubleValue();
        double v2 = ((Number)((Object[])binMinMax_X_Values[0])[1]).doubleValue();
        int barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
        int xBin = 0;
        int index = 0;
        int size = this.binMidList_X.size();
        Object respObj = null;
        for (int i = 0; i < size; ++i) {
            Object format;
            String xstr;
            Object xObj;
            double endY;
            double startY;
            double respVal;
            double center = ((Number)binMid_X[i]).doubleValue();
            xBin = ((Number)binMinMax_X_KeySet[i]).intValue();
            v1 = ((Number)((Object[])binMinMax_X_Values[i])[0]).doubleValue();
            v2 = ((Number)((Object[])binMinMax_X_Values[i])[1]).doubleValue();
            barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
            index = xBin;
            if (this.groupList != null) {
                Map grpList = (Map)this.groupList.get(new Integer(index));
                if (grpList == null) continue;
                for (Map.Entry e : grpList.entrySet()) {
                    Object format2;
                    String xstr2;
                    Object xObj2;
                    Rectangle rect;
                    Object grpKeyObj = e.getKey();
                    int grpVal = ((Number)grpKeyObj).intValue();
                    respObj = e.getValue();
                    if (respObj == null) continue;
                    respVal = ((Number)respObj).doubleValue();
                    if (respVal < 0.0) {
                        if (this.transformObject.isReverse(1)) {
                            startY = respVal;
                            endY = 0.0;
                        } else {
                            startY = 0.0;
                            endY = respVal;
                        }
                    } else if (this.transformObject.isReverse(1)) {
                        startY = 0.0;
                        endY = respVal;
                    } else {
                        startY = respVal;
                        endY = 0.0;
                    }
                    if (!(rect = new Rectangle((int)((projectValues = this.transformObject.project(center, startY, 0.0, projectValues))[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)(projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1))[1] - (int)projectValues[1])).contains(screenX, screenY)) continue;
                    Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.Probe.fmt.txt", (String)"{0} = {1}"));
                    Message binMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.BinRange.fmt.txt", (String)"{0} = [{1}, {2}]"));
                    if (this.xMapper != null) {
                        xObj2 = this.xMapper.getValue(xBin);
                        xstr2 = probeMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), xObj2);
                    } else if (this.xDiscrete && (this.intervalAxis || this.xMinMaxSet)) {
                        xObj2 = binMid_X[i];
                        xstr2 = probeMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), xObj2);
                    } else {
                        Object[] valObj = (Object[])binMinMax_X_Values[i];
                        format2 = this.filter.getFormat(xVar, SASFormat.class);
                        String valStr0 = this.filter.getFormattedValue(xVar, valObj[0], format2);
                        String valStr1 = this.filter.getFormattedValue(xVar, valObj[1], format2);
                        valStr0 = valStr0.trim();
                        valStr1 = valStr1.trim();
                        xstr2 = binMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), (Object)valStr0, (Object)valStr1);
                    }
                    String yValStr = Double.toString(respVal);
                    Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
                    String suffixStr = "";
                    if (respVar != null) {
                        format2 = this.filter.getFormat(respVar, SASFormat.class);
                        yValStr = this.filter.getFormattedValue(respVar, respObj, format2);
                        suffixStr = this.statType == 1 ? statName_Sum : statName_Mean;
                        respVar = respVar.toString() + suffixStr;
                    }
                    if (respVar == null && (respVar = this.roles.getVariable((Object)this.frequencyRole, 0)) != null) {
                        format2 = this.filter.getFormat(respVar, SASFormat.class);
                        yValStr = this.filter.getFormattedValue(respVar, respObj, format2);
                    }
                    if (respVar == null) {
                        if (this.statType == 11) {
                            respVar = statName_Percent;
                            format2 = SASFormat.getInstance((String)"Percent8.2");
                            respVal /= 100.0;
                        } else {
                            respVar = statName_Frequency;
                            format2 = SASFormat.getInstance((String)"Best8.0");
                        }
                        yValStr = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(respVal), format2);
                    }
                    String respstr = "\n" + probeMessage.toString(respVar, (Object)yValStr);
                    String grpValStr = this.groupMapper.getValue(grpVal).toString();
                    Object grpVar = this.roles.getVariable((Object)this.groupRole, 0);
                    String grpstr = "\n" + probeMessage.toString(grpVar, (Object)grpValStr);
                    String str = xstr2 + respstr + grpstr;
                    str = str.replaceAll("=", "\t=\t");
                    str = str.replaceAll("\\[", "\t \t\\[");
                    return str;
                }
                continue;
            }
            respObj = this.responseList.get(new Integer(index));
            if (respObj == null || (respVal = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respVal)) continue;
            if (respVal < 0.0) {
                if (this.transformObject.isReverse(1)) {
                    startY = respVal;
                    endY = 0.0;
                } else {
                    startY = 0.0;
                    endY = respVal;
                }
            } else if (this.transformObject.isReverse(1)) {
                startY = 0.0;
                endY = respVal;
            } else {
                startY = respVal;
                endY = 0.0;
            }
            projectValues = this.transformObject.project(center, startY, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1);
            Rectangle rect = new Rectangle((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            if (!rect.contains(screenX, screenY)) continue;
            Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.Probe.fmt.txt", (String)"{0} = {1}"));
            Message binMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.BinRange.fmt.txt", (String)"{0} = [{1}, {2}]"));
            if (this.xMapper != null) {
                xObj = this.xMapper.getValue(xBin);
                xstr = probeMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), xObj);
            } else if (this.xDiscrete && (this.intervalAxis || this.xMinMaxSet)) {
                xObj = binMid_X[i];
                xstr = probeMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), xObj);
            } else {
                Object[] valObj = (Object[])binMinMax_X_Values[i];
                format = this.filter.getFormat(xVar, SASFormat.class);
                String valStr0 = this.filter.getFormattedValue(xVar, valObj[0], format);
                String valStr1 = this.filter.getFormattedValue(xVar, valObj[1], format);
                valStr0 = valStr0.trim();
                valStr1 = valStr1.trim();
                xstr = binMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), (Object)valStr0, (Object)valStr1);
            }
            String yValStr = Double.toString(respVal);
            Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
            if (respVar != null) {
                format = this.filter.getFormat(respVar, SASFormat.class);
                yValStr = this.filter.getFormattedValue(respVar, respObj, format);
                String suffixStr = this.statType == 1 ? statName_Sum : statName_Mean;
                respVar = respVar.toString() + "(" + suffixStr + ")";
            }
            if (respVar == null && (respVar = this.roles.getVariable((Object)this.frequencyRole, 0)) != null) {
                format = this.filter.getFormat(respVar, SASFormat.class);
                yValStr = this.filter.getFormattedValue(respVar, respObj, format);
            }
            if (respVar == null) {
                if (this.statType == 11) {
                    respVar = statName_Percent;
                    format = SASFormat.getInstance((String)"Percent8.2");
                    respVal /= 100.0;
                } else {
                    respVar = statName_Frequency;
                    format = SASFormat.getInstance((String)"Best8.0");
                }
                yValStr = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(respVal), format);
            }
            String respstr = "\n" + probeMessage.toString(respVar, (Object)yValStr);
            String str = xstr + respstr;
            str = str.replaceAll("=", "\t=\t");
            str = str.replaceAll("\\[", "\t \t\\[");
            return str;
        }
        return null;
    }

    protected String getTipText_Bivariate(int screenX, int screenY) {
        double respVal;
        if (this.filter == null) {
            return null;
        }
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        if (xVar == null || yVar == null) {
            return null;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1 || this.binMidList_Y.size() < 1 || this.binMinMaxList_Y.size() < 1) {
            return null;
        }
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        Object[] binMinMax_Y_KeySet = this.binMinMaxList_Y.keySet().toArray();
        Object[] binMinMax_Y_Values = this.binMinMaxList_Y.values().toArray();
        Object[] binMid_Y = this.binMidList_Y.values().toArray();
        double[] projectValues = new double[3];
        double respMin = 0.0;
        double respMax = 0.0;
        Iterator iter = this.responseList.values().iterator();
        while (iter.hasNext()) {
            respVal = ((Number)iter.next()).doubleValue();
            respMax = Math.max(respMax, respVal);
            respMin = Math.min(respMin, respVal);
        }
        int barWidth_X = this.getBinWidthOnScreen((byte)1, ((Number)((Object[])binMinMax_X_Values[0])[0]).doubleValue(), ((Number)((Object[])binMinMax_X_Values[0])[1]).doubleValue());
        int barWidth_Y = this.getBinWidthOnScreen((byte)2, ((Number)((Object[])binMinMax_Y_Values[0])[0]).doubleValue(), ((Number)((Object[])binMinMax_Y_Values[0])[1]).doubleValue());
        int size_X = this.binMidList_X.size();
        int size_Y = this.binMidList_Y.size();
        Object respObj = null;
        double v1 = 0.0;
        double v2 = 0.0;
        for (int j = 0; j < size_Y; ++j) {
            double center_Y = ((Number)binMid_Y[j]).doubleValue();
            int yBin = ((Number)binMinMax_Y_KeySet[j]).intValue();
            v1 = ((Number)((Object[])binMinMax_Y_Values[j])[0]).doubleValue();
            v2 = ((Number)((Object[])binMinMax_Y_Values[j])[1]).doubleValue();
            barWidth_Y = this.getBinWidthOnScreen((byte)2, v1, v2);
            for (int i = 0; i < size_X; ++i) {
                String ystr;
                String valStr1;
                String valStr0;
                Object format;
                Object[] valObj;
                String xstr;
                Rectangle rect;
                double center_X = ((Number)binMid_X[i]).doubleValue();
                int xBin = ((Number)binMinMax_X_KeySet[i]).intValue();
                v1 = ((Number)((Object[])binMinMax_X_Values[i])[0]).doubleValue();
                v2 = ((Number)((Object[])binMinMax_X_Values[i])[1]).doubleValue();
                barWidth_X = this.getBinWidthOnScreen((byte)1, v1, v2);
                int index = xBin + yBin * this.numberOfBins_X;
                respObj = this.responseList.get(new Integer(index));
                if (respObj == null || (respVal = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respVal) || !(rect = new Rectangle((int)((projectValues = this.transformObject.project(center_X, center_Y, 0.0, projectValues))[0] - (double)(barWidth_X / 2)), (int)(projectValues[1] - (double)(barWidth_Y / 2)), barWidth_X, barWidth_Y)).contains(screenX, screenY)) continue;
                Message probeMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.Probe.fmt.txt", (String)"{0} = {1}"));
                Message binMessage = new Message(ResourceLoader.getResourceString((Object)this.rbHist, (String)"Histogram.BinRange.fmt.txt", (String)"{0} = [{1}, {2}]"));
                if (this.xMapper != null) {
                    Object xObj = this.xMapper.getValue(xBin);
                    xstr = probeMessage.toString((Object)((String)this.filter.getVariableDescription(xVar)), xObj);
                } else {
                    valObj = (Object[])binMinMax_X_Values[i];
                    format = this.filter.getFormat(xVar, SASFormat.class);
                    valStr0 = this.filter.getFormattedValue(xVar, valObj[0], format);
                    valStr1 = this.filter.getFormattedValue(xVar, valObj[1], format);
                    valStr0 = valStr0.trim();
                    valStr1 = valStr1.trim();
                    xstr = binMessage.toString((Object)((String)this.filter.getVariableDescription(this.roles.getVariable((Object)this.xRole, 0))), (Object)valStr0, (Object)valStr1);
                }
                if (this.yMapper != null) {
                    Object yObj = this.yMapper.getValue(yBin);
                    ystr = probeMessage.toString((Object)((String)this.filter.getVariableDescription(yVar)), yObj);
                } else {
                    valObj = (Object[])binMinMax_Y_Values[j];
                    format = this.filter.getFormat(yVar, SASFormat.class);
                    valStr0 = this.filter.getFormattedValue(yVar, valObj[0], format);
                    valStr1 = this.filter.getFormattedValue(yVar, valObj[1], format);
                    valStr0 = valStr0.trim();
                    valStr1 = valStr1.trim();
                    ystr = binMessage.toString((Object)((String)this.filter.getVariableDescription(this.roles.getVariable((Object)this.yRole, 0))), (Object)valStr0, (Object)valStr1);
                }
                ystr = "\n" + ystr;
                String respValStr = Double.toString(respVal);
                Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
                if (respVar != null) {
                    format = this.filter.getFormat(respVar, SASFormat.class);
                    respValStr = this.filter.getFormattedValue(respVar, respObj, format);
                }
                if (respVar == null && (respVar = this.roles.getVariable((Object)this.responseRole, 0)) != null) {
                    format = this.filter.getFormat(respVar, SASFormat.class);
                    respValStr = this.filter.getFormattedValue(respVar, respObj, format);
                }
                if (respVar == null) {
                    if (this.statType == 11) {
                        respVar = statName_Percent;
                        format = SASFormat.getInstance((String)"Percent8.2");
                        respVal /= 100.0;
                    } else {
                        respVar = statName_Frequency;
                        format = SASFormat.getInstance((String)"Best8.0");
                    }
                    respValStr = this.filter.getFormattedValue(this.roles.getVariable((Object)this.responseRole, 0), (Object)new Double(respVal), format);
                }
                String respstr = "\n" + probeMessage.toString(respVar, (Object)respValStr);
                String str = xstr + ystr + respstr;
                str = str.replaceAll("=", "\t=\t");
                str = str.replaceAll("\\[", "\t \t\\[");
                return str;
            }
        }
        return null;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        if (this.bivariate) {
            return this.selectInLayer_Bivariate(select, selectRegion, event);
        }
        return this.selectInLayer_Univariate(select, selectRegion, event);
    }

    protected boolean selectInLayer_Univariate(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return false;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1) {
            return false;
        }
        if (this.groupList != null) {
            return false;
        }
        double[] upv1 = new double[3];
        double[] upv2 = new double[3];
        upv1 = this.transformObject.unProject(selectArea.x, 0.0, 0.0, upv1);
        upv2 = this.transformObject.unProject(selectArea.x + selectArea.width, 0.0, 0.0, upv2);
        double[] projectValues = new double[3];
        double[] projectValues_1 = new double[3];
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        Vector<Object> xVector = new Vector<Object>();
        boolean selected = false;
        int size = this.binMidList_X.size();
        int xBin = 0;
        int index = 0;
        Object respObj = null;
        boolean adjustBound = true;
        for (int i = 0; i < size; ++i) {
            double endY;
            double startY;
            double respVal;
            double center = ((Number)binMid_X[i]).doubleValue();
            double v1 = ((Number)((Object[])binMinMax_X_Values[i])[0]).doubleValue();
            double v2 = ((Number)((Object[])binMinMax_X_Values[i])[1]).doubleValue();
            int barWidth = this.getBinWidthOnScreen((byte)1, v1, v2);
            xBin = ((Number)binMinMax_X_KeySet[i]).intValue();
            index = xBin;
            respObj = this.responseList.get(new Integer(index));
            if (respObj == null || (respVal = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respVal)) continue;
            if (respVal < 0.0) {
                if (this.transformObject.isReverse(1)) {
                    startY = respVal;
                    endY = 0.0;
                } else {
                    startY = 0.0;
                    endY = respVal;
                }
            } else if (this.transformObject.isReverse(1)) {
                startY = 0.0;
                endY = respVal;
            } else {
                startY = respVal;
                endY = 0.0;
            }
            projectValues = this.transformObject.project(center, startY, 0.0, projectValues);
            projectValues_1 = this.transformObject.project(center, endY, 0.0, projectValues_1);
            Rectangle rect = new Rectangle((int)(projectValues[0] - (double)(barWidth / 2)), (int)projectValues[1], barWidth, (int)projectValues_1[1] - (int)projectValues[1]);
            if (!rect.intersects(selectArea)) continue;
            selected = true;
            if (this.xMapper != null) {
                Object xObj = this.xMapper.getValue(xBin);
                xVector.addElement(xObj);
                continue;
            }
            min = Math.min(min, ((Number)((Object[])binMinMax_X_Values[i])[0]).doubleValue());
            max = Math.max(max, ((Number)((Object[])binMinMax_X_Values[i])[1]).doubleValue());
            if (this.binningInclusive == 1) {
                if (xBin != 0) continue;
                adjustBound = false;
                continue;
            }
            if (xBin != this.numberOfBins_X - 1) continue;
            adjustBound = false;
        }
        if (adjustBound) {
            if (this.binningInclusive == 1) {
                min += 1.0E-6;
            } else {
                max -= 1.0E-6;
            }
        }
        if (selected) {
            String[] vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString()};
            DataRange[] ranges = new DataRange[1];
            boolean useFormat = false;
            if (this.xMapper != null) {
                ranges[0] = new DiscreteRange(xVector.toArray());
                useFormat = true;
            } else {
                ranges[0] = new ContinuousRange(min, max);
            }
            this.filter.setSelected(vars, ranges, select, useFormat);
        }
        return true;
    }

    protected boolean selectInLayer_Bivariate(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return false;
        }
        if (this.binMidList_X.size() < 1 || this.binMinMaxList_X.size() < 1 || this.binMidList_Y.size() < 1 || this.binMinMaxList_Y.size() < 1) {
            return false;
        }
        double[] upv1 = new double[3];
        double[] upv2 = new double[3];
        upv1 = this.transformObject.unProject(selectArea.x, 0.0, 0.0, upv1);
        upv2 = this.transformObject.unProject(selectArea.x + selectArea.width, 0.0, 0.0, upv2);
        Object[] binMinMax_X_KeySet = this.binMinMaxList_X.keySet().toArray();
        Object[] binMinMax_X_Values = this.binMinMaxList_X.values().toArray();
        Object[] binMid_X = this.binMidList_X.values().toArray();
        Object[] binMinMax_Y_KeySet = this.binMinMaxList_Y.keySet().toArray();
        Object[] binMinMax_Y_Values = this.binMinMaxList_Y.values().toArray();
        Object[] binMid_Y = this.binMidList_Y.values().toArray();
        double[] projectValues = new double[3];
        int barWidth_X = this.getBinWidthOnScreen((byte)1, ((Number)((Object[])binMinMax_X_Values[0])[0]).doubleValue(), ((Number)((Object[])binMinMax_X_Values[0])[1]).doubleValue());
        int barWidth_Y = this.getBinWidthOnScreen((byte)2, ((Number)((Object[])binMinMax_Y_Values[0])[0]).doubleValue(), ((Number)((Object[])binMinMax_Y_Values[0])[1]).doubleValue());
        barWidth_X = (int)((double)barWidth_X * this.scaleFactor);
        barWidth_Y = (int)((double)barWidth_Y * this.scaleFactor);
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double min_Y = Double.POSITIVE_INFINITY;
        double max_Y = Double.NEGATIVE_INFINITY;
        Vector<Object> xVector = new Vector<Object>();
        Vector<Object> yVector = new Vector<Object>();
        boolean selected = false;
        int index = 0;
        int size_X = this.binMidList_X.size();
        int size_Y = this.binMidList_Y.size();
        int xBin = 0;
        int yBin = 0;
        Object respObj = null;
        boolean adjustBoundX = true;
        boolean adjustBoundY = true;
        for (int j = 0; j < size_Y; ++j) {
            double center_Y = ((Number)binMid_Y[j]).doubleValue();
            yBin = ((Number)binMinMax_Y_KeySet[j]).intValue();
            for (int i = 0; i < size_X; ++i) {
                Rectangle rect;
                double respVal;
                double center_X = ((Number)binMid_X[i]).doubleValue();
                xBin = ((Number)binMinMax_X_KeySet[i]).intValue();
                index = xBin + yBin * this.numberOfBins_X;
                respObj = this.responseList.get(new Integer(index));
                if (respObj == null || (respVal = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respVal) || !(rect = new Rectangle((int)((projectValues = this.transformObject.project(center_X, center_Y, 0.0, projectValues))[0] - (double)(barWidth_X / 2)), (int)(projectValues[1] - (double)(barWidth_Y / 2)), barWidth_X, barWidth_Y)).intersects(selectArea)) continue;
                selected = true;
                if (this.xMapper != null) {
                    Object xObj = this.xMapper.getValue(xBin);
                    xVector.addElement(xObj);
                } else {
                    min = Math.min(min, ((Number)((Object[])binMinMax_X_Values[i])[0]).doubleValue());
                    max = Math.max(max, ((Number)((Object[])binMinMax_X_Values[i])[1]).doubleValue());
                    if (this.binningInclusive == 1) {
                        if (xBin == 0) {
                            adjustBoundX = false;
                        }
                    } else if (xBin == this.numberOfBins_X - 1) {
                        adjustBoundX = false;
                    }
                }
                if (this.yMapper != null) {
                    Object yObj = this.yMapper.getValue(yBin);
                    yVector.addElement(yObj);
                    continue;
                }
                min_Y = Math.min(min_Y, ((Number)((Object[])binMinMax_Y_Values[j])[0]).doubleValue());
                max_Y = Math.max(max_Y, ((Number)((Object[])binMinMax_Y_Values[j])[1]).doubleValue());
                if (this.binningInclusive == 1) {
                    if (yBin != 0) continue;
                    adjustBoundY = false;
                    continue;
                }
                if (yBin != this.numberOfBins_Y - 1) continue;
                adjustBoundY = false;
            }
        }
        if (adjustBoundX) {
            if (this.binningInclusive == 1) {
                min += 1.0E-6;
            } else {
                max -= 1.0E-6;
            }
        }
        if (adjustBoundY) {
            if (this.binningInclusive == 1) {
                min_Y += 1.0E-6;
            } else {
                max_Y -= 1.0E-6;
            }
        }
        if (selected) {
            String[] vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString(), this.roles.getVariable((Object)this.yRole, 0).toString()};
            DataRange[] ranges = new DataRange[]{this.xMapper != null ? new DiscreteRange(xVector.toArray()) : new ContinuousRange(min, max), this.yMapper != null ? new DiscreteRange(yVector.toArray()) : new ContinuousRange(min_Y, max_Y)};
            this.filter.setSelected(vars, ranges, select, false);
        }
        return true;
    }

    @Override
    public void setDataRange(byte dim, int index, DataRange range) {
        super.setDataRange(dim, index, range);
        if (this.xDataRange instanceof DiscreteRange && this.xMapper != null) {
            this.updateMapper(this.xMapper, (DiscreteRange)this.xDataRange);
        }
        if (this.yDataRange instanceof DiscreteRange && this.yMapper != null) {
            this.updateMapper(this.yMapper, (DiscreteRange)this.yDataRange);
        }
        if (dim == 1) {
            this.build(Boolean.TRUE);
        } else if (dim == 2 && this.roles.getVariable((Object)this.yRole, 0) != null) {
            this.build(Boolean.TRUE);
        }
        this.fireMarginChanged(new MarginChangeEvent((Object)this));
    }

    protected void updateMapper(CharacterVariableMapper mapper, DiscreteRange range) {
        if (mapper == null) {
            return;
        }
        mapper.removeAllValues();
        if (range == null) {
            return;
        }
        Vector v = range.getValues();
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.size(); ++i) {
            mapper.addValue(v.elementAt(i));
        }
    }

    @Override
    public boolean build(Object buildData) {
        boolean build = false;
        if (buildData instanceof Boolean) {
            build = (Boolean)buildData;
        }
        if (!this.rebuildRequired && !build) {
            return true;
        }
        super.build(buildData);
        this.createBins();
        this.rebuildRequired = false;
        return true;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        switch (e.type) {
            case 1: 
            case 2: {
                this.setRole(e);
                break;
            }
            case 3: {
                this.removeRole(e);
                break;
            }
            case 4: {
                this.applyDiscreteChange(e);
            }
        }
        this.build(Boolean.TRUE);
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
    }

    protected void applyDiscreteChange(RoleEvent e) {
        if (e.role == 24) {
            if (e.newValue instanceof Boolean) {
                boolean charX;
                Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                this.xDiscrete = (Boolean)e.newValue;
                boolean bl = charX = !this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0)) || this.xDiscrete && !this.intervalAxis && !this.xMinMaxSet;
                if (charX) {
                    if (this.xMapper == null) {
                        this.xMapper = new CharacterVariableMapper(this.filter, xVar);
                    } else {
                        this.xMapper.setVariable(xVar);
                    }
                    if (this.filter.isNumericVariable(xVar)) {
                        OrdinalRange dr = null;
                        LinkedHashMap<String, Object> catRawList = new LinkedHashMap<String, Object>();
                        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                            Object value = this.filter.getValue(xVar, (long)i);
                            String formattedValueObj = this.filter.getFormattedValue(xVar, value, null);
                            catRawList.put(formattedValueObj, value);
                        }
                        dr = new OrdinalRange(catRawList.keySet().toArray(), catRawList.values().toArray());
                        this.xMapper.removeAllValues();
                        Vector values = dr.getValues();
                        int size = values.size();
                        for (int i = 0; i < size; ++i) {
                            this.xMapper.addValue(values.elementAt(i));
                        }
                    } else {
                        this.xMapper.setSort(this.sortOrderX);
                    }
                } else if (((Boolean)e.newValue).booleanValue() && (this.bivariate || !this.intervalAxis && !this.xMinMaxSet)) {
                    if (this.xBinNames != null) {
                        this.clearXBinNames();
                        this.xAxisMin = Double.NaN;
                        this.xAxisMax = Double.NaN;
                    }
                    if (this.xMapper == null) {
                        this.xMapper = new CharacterVariableMapper(this.filter, xVar);
                    } else {
                        this.xMapper.setVariable(xVar);
                    }
                    if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                        this.xMapper.setSort(this.sortOrderX);
                    }
                } else {
                    this.xMapper = null;
                }
            }
        } else if (e.role == 25 && e.newValue instanceof Boolean) {
            Object yVar = this.roles.getVariable((Object)this.yRole, 0);
            if (((Boolean)e.newValue).booleanValue()) {
                if (this.yMapper == null) {
                    this.yMapper = new CharacterVariableMapper(this.filter, yVar);
                } else {
                    this.yMapper.setVariable(yVar);
                }
                if (this.filter.isNumericVariable(yVar)) {
                    OrdinalRange dr = null;
                    LinkedHashMap<String, Object> catRawList = new LinkedHashMap<String, Object>();
                    for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                        Object value = this.filter.getValue(yVar, (long)i);
                        String formattedValueObj = this.filter.getFormattedValue(yVar, value, null);
                        catRawList.put(formattedValueObj, value);
                    }
                    dr = new OrdinalRange(catRawList.keySet().toArray(), catRawList.values().toArray());
                    this.yMapper.removeAllValues();
                    Vector values = dr.getValues();
                    int size = values.size();
                    for (int i = 0; i < size; ++i) {
                        this.yMapper.addValue(values.elementAt(i));
                    }
                }
                if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                    this.yMapper.setSort(this.sortOrderY);
                }
            } else if (this.filter.isNumericVariable(yVar) && !this.isDiscrete((Object)this.yRole)) {
                this.yMapper = null;
            } else {
                if (this.yMapper == null) {
                    this.yMapper = new CharacterVariableMapper(this.filter, yVar);
                } else {
                    this.yMapper.setVariable(yVar);
                }
                if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                    this.yMapper.setSort(this.sortOrderY);
                }
            }
        }
    }

    protected void setRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                if (this.filter == null) break;
                Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                if (this.filter.isNumericVariable(xVar) && !this.isDiscrete((Object)this.xRole)) {
                    this.xMapper = null;
                } else {
                    if (this.xMapper == null) {
                        this.xMapper = new CharacterVariableMapper(this.filter, xVar);
                    } else {
                        this.xMapper.setVariable(xVar);
                    }
                    this.xMapper.setSort(this.sortOrderX);
                }
                if (this.xBinNames == null) break;
                this.clearXBinNames();
                this.xAxisMin = Double.NaN;
                this.xAxisMax = Double.NaN;
                break;
            }
            case 25: {
                if (this.filter == null) break;
                Object yVar = this.roles.getVariable((Object)this.yRole, 0);
                if (this.filter.isNumericVariable(yVar) && !this.isDiscrete((Object)this.yRole)) {
                    this.yMapper = null;
                } else {
                    if (this.yMapper == null) {
                        this.yMapper = new CharacterVariableMapper(this.filter, yVar);
                    } else {
                        this.yMapper.setVariable(yVar);
                    }
                    this.yMapper.setSort(this.sortOrderY);
                }
                if (yVar != null) {
                    this.bivariate = true;
                }
                if (this.xDiscrete && this.intervalAxis) {
                    this.setDiscrete((Object)this.xRole, this.xDiscrete);
                }
                this.initColorRamp();
                this.roles.deleteRole((Object)this.groupRole);
                break;
            }
            case 6: {
                if (this.filter == null) break;
                Object grpVar = this.roles.getVariable((Object)this.groupRole, 0);
                if (this.groupMapper == null) {
                    this.groupMapper = new CharacterVariableMapper(this.filter, grpVar);
                } else {
                    this.groupMapper.setVariable(grpVar);
                }
                this.roles.deleteRole((Object)this.yRole);
                this.roles.newRole((Object)this.colorIndexRole, "Color Index", 1);
                break;
            }
            case 17: {
                if (this.statType == 1 && this.statType == 2) break;
                this.statType = 1;
                break;
            }
            case 38: {
                Object obj = this.roles.getVariable((Object)this.statTypeRole);
                if (!(obj instanceof String)) break;
                this.setStatistic(obj.toString());
            }
        }
    }

    protected void removeRole(RoleEvent e) {
        switch (e.role) {
            case 24: {
                this.xMapper = null;
                if (this.xBinNames == null) break;
                this.clearXBinNames();
                this.xAxisMin = Double.NaN;
                this.xAxisMax = Double.NaN;
                break;
            }
            case 25: {
                this.yMapper = null;
                this.bivariate = false;
                if (this.xDiscrete && !this.bivariate) {
                    this.setDiscrete((Object)this.xRole, this.xDiscrete);
                }
                this.roles.newRole((Object)this.groupRole, "Group", 1);
                if (this.colorMapper == null) break;
                this.colorMapper.unRegister(this);
                break;
            }
            case 6: {
                this.groupMapper = null;
                this.roles.newRole((Object)this.yRole, "Y", 1);
                this.roles.deleteRole((Object)this.colorIndexRole);
                break;
            }
            case 17: {
                this.statType = 12;
            }
        }
    }

    @Override
    protected void layoutChart() {
        Object xVar;
        super.layoutChart();
        if (this.filter != null && (xVar = this.roles.getVariable((Object)this.xRole, 0)) != null) {
            int offsetLeft = 0;
            int offsetRight = 0;
            int offsetBottom = 0;
            int offsetTop = 0;
            if (this.xMapper != null && this.xMapper.getNumberValues() > 0) {
                offsetLeft = offsetRight = this.bounds.width / this.xMapper.getNumberValues() / 2;
            }
            if (this.bivariate && this.yMapper != null && this.yMapper.getNumberValues() > 0) {
                offsetBottom = offsetTop = this.bounds.height / this.yMapper.getNumberValues() / 2;
            }
            boolean fireEvent = false;
            if (this.prefInnerMargin.top != offsetTop || this.prefInnerMargin.bottom != offsetBottom || this.prefInnerMargin.right != offsetRight || this.prefInnerMargin.left != offsetLeft) {
                fireEvent = true;
            }
            this.prefInnerMargin = new Insets(offsetTop, offsetLeft, offsetBottom, offsetRight);
            if (fireEvent) {
                this.fireMarginChanged(new MarginChangeEvent((Object)this));
            }
        }
    }

    protected Object[] getXAxisRoles() {
        return new Object[]{RoleInterface.ROLE_X};
    }

    @Override
    public DataRange getPreferredRange(Object which) {
        DiscreteRange dr;
        if (which == null || this.filter == null) {
            return null;
        }
        Object role = null;
        Enumeration rolesEnum = Extract.elements((Object)which);
        if (rolesEnum.hasMoreElements()) {
            role = rolesEnum.nextElement();
        }
        if (role == null) {
            return null;
        }
        if (!this.bivariate && role != null && role instanceof Number && (role == RoleInterface.ROLE_RESPONSE || role == RoleInterface.ROLE_Y)) {
            Object xVar = this.roles.getVariable((Object)this.xRole, 0);
            if (xVar == null) {
                return null;
            }
            double max = 0.0;
            double min = 0.0;
            if (this.groupList == null) {
                Iterator iter = this.responseList.values().iterator();
                while (iter.hasNext()) {
                    double respValue = ((Number)iter.next()).doubleValue();
                    max = Math.max(max, respValue);
                    min = Math.min(min, respValue);
                }
            } else {
                Object respObj = null;
                Map grpList = null;
                Object[] grpKeySet = this.groupList.keySet().toArray();
                for (int i = 0; i < this.groupList.size(); ++i) {
                    grpList = (Map)this.groupList.get(grpKeySet[i]);
                    if (grpList == null) continue;
                    for (Map.Entry e : grpList.entrySet()) {
                        respObj = e.getValue();
                        double respValue = ((Number)respObj).doubleValue();
                        if (Double.isNaN(respValue)) continue;
                        max = Math.max(max, respValue);
                        min = Math.min(min, respValue);
                    }
                }
            }
            ContinuousRange cr = new ContinuousRange(min, max);
            ContinuousRange dr2 = new ContinuousRange((DataRange)cr);
            return dr2;
        }
        if (role != null && (role instanceof Number && role == RoleInterface.ROLE_X || role.equals("X") || role.equals(RoleInterface.ROLE_X))) {
            Object xVar = this.roles.getVariable((Object)this.xRole, 0);
            if (xVar == null) {
                return null;
            }
            if (xVar != null) {
                boolean charX;
                dr = null;
                boolean bl = charX = !this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0)) || this.xDiscrete && !this.intervalAxis && !this.xMinMaxSet;
                if (charX) {
                    Object varObj = this.roles.getVariable((Object)this.xRole, 0);
                    if (this.filter.isNumericVariable(varObj)) {
                        LinkedHashMap<String, Object> catRawList = new LinkedHashMap<String, Object>();
                        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                            Object value = this.filter.getValue(varObj, (long)i);
                            String formattedValueObj = this.filter.getFormattedValue(varObj, value, null);
                            catRawList.put(formattedValueObj, value);
                        }
                        dr = new OrdinalRange(catRawList.keySet().toArray(), catRawList.values().toArray());
                        this.xMapper.removeAllValues();
                        Vector values = ((OrdinalRange)dr).getValues();
                        int size = values.size();
                        for (int i = 0; i < size; ++i) {
                            this.xMapper.addValue(values.elementAt(i));
                        }
                    } else {
                        dr = new DiscreteRange(this.xMapper.getValues());
                    }
                } else if (!(this.bivariate || this.xMapper != null || Double.isNaN(this.xAxisMin) || Double.isNaN(this.xAxisMax))) {
                    dr = new ContinuousRange(this.xAxisMin, this.xAxisMax);
                } else if (!this.bivariate && this.xDiscrete && this.intervalAxis) {
                    Object[] nm = new Object[this.filter.getNumberObservations(-1)];
                    AbstractMap lhm = new LinkedHashMap<Double, Object>();
                    double minX = ((Number)((DataFilterInfoInterface)this.filter).getMinimumValue(xVar)).doubleValue();
                    double maxX = ((Number)((DataFilterInfoInterface)this.filter).getMaximumValue(xVar)).doubleValue();
                    for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                        lhm.put(new Double(this.filter.getNumericValue(xVar, (long)i)), null);
                    }
                    lhm = new TreeMap(lhm);
                    nm = lhm.keySet().toArray();
                    double xBinWidth = this.getBinWidth(nm);
                    dr = new ContinuousRange(minX -= xBinWidth / 2.0, maxX += xBinWidth / 2.0);
                }
                if (dr != null) {
                    return dr;
                }
            }
        }
        if (this.bivariate && role != null && (role instanceof Number && role == RoleInterface.ROLE_Y || role.equals("Y") || role.equals(RoleInterface.ROLE_Y))) {
            Object yVar = this.roles.getVariable((Object)this.yRole, 0);
            if (yVar == null) {
                return null;
            }
            dr = null;
            if (yVar != null && (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0)) || this.isDiscrete((Object)this.yRole))) {
                Object varObj = this.roles.getVariable((Object)this.yRole, 0);
                if (this.filter.isNumericVariable(varObj)) {
                    LinkedHashMap<String, Object> catRawList = new LinkedHashMap<String, Object>();
                    for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                        Object value = this.filter.getValue(varObj, (long)i);
                        String formattedValueObj = this.filter.getFormattedValue(varObj, value, null);
                        catRawList.put(formattedValueObj, value);
                    }
                    dr = new OrdinalRange(catRawList.keySet().toArray(), catRawList.values().toArray());
                    this.yMapper.removeAllValues();
                    Vector values = ((OrdinalRange)dr).getValues();
                    int size = values.size();
                    for (int i = 0; i < size; ++i) {
                        this.yMapper.addValue(values.elementAt(i));
                    }
                } else {
                    dr = new DiscreteRange(this.yMapper.getValues());
                }
            }
            if (dr != null) {
                return dr;
            }
        }
        return super.getPreferredRange(which);
    }

    @Override
    public void dataFilterChanged(DvrDataFilterEvent evt) {
        switch (evt.type) {
            case 3: {
                LinkedHashMap<String, Object> catRawList;
                OrdinalRange dr;
                if (this.xMapper != null) {
                    Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                    if (this.isDiscrete((Object)this.xRole) || !this.filter.isNumericVariable(xVar)) {
                        dr = null;
                        catRawList = new LinkedHashMap<String, Object>();
                        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                            Object value = this.filter.getValue(xVar, (long)i);
                            String formattedValueObj = this.filter.getFormattedValue(xVar, value, null);
                            catRawList.put(formattedValueObj, value);
                        }
                        dr = new OrdinalRange(catRawList.keySet().toArray(), catRawList.values().toArray());
                        this.xMapper.removeAllValues();
                        Vector values = dr.getValues();
                        int size = values.size();
                        for (int i = 0; i < size; ++i) {
                            this.xMapper.addValue(values.elementAt(i));
                        }
                    }
                }
                if (this.yMapper != null) {
                    Object yVar = this.roles.getVariable((Object)this.yRole, 0);
                    if (this.isDiscrete((Object)this.yRole) || !this.filter.isNumericVariable(yVar)) {
                        dr = null;
                        catRawList = new LinkedHashMap();
                        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                            Object value = this.filter.getValue(yVar, (long)i);
                            String formattedValueObj = this.filter.getFormattedValue(yVar, value, null);
                            catRawList.put(formattedValueObj, value);
                        }
                        dr = new OrdinalRange(catRawList.keySet().toArray(), catRawList.values().toArray());
                        this.yMapper.removeAllValues();
                        Vector values = dr.getValues();
                        int size = values.size();
                        for (int i = 0; i < size; ++i) {
                            this.yMapper.addValue(values.elementAt(i));
                        }
                    }
                }
                this.build(Boolean.TRUE);
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
                this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            }
        }
        super.dataFilterChanged(evt);
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        if (id == 820 && value instanceof Boolean) {
            this.colorMapperEnabled = (Boolean)value;
            this.styleElementSelectorEnabled = (Boolean)value == false;
        }
        return super.setPropertyValue(id, value);
    }

    @Override
    public Object getPropertyValue(int id) {
        Object rc = null;
        switch (id) {
            case 19065: {
                if (this.roles.getVariable((Object)this.yRole, 0) != null) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case 19070: {
                if (this.xBinNames == null) break;
                rc = new Object[this.xBinNames.length];
                for (int i = 0; i < this.xBinNames.length; ++i) {
                    ((Object[])rc)[i] = new Double(this.xBinNames[i]);
                }
                break;
            }
            case 19064: {
                return Boolean.FALSE;
            }
            case 19061: {
                return this.roles.getVariable((Object)this.yRole, 0) == null ? Boolean.FALSE : Boolean.TRUE;
            }
            case 802: {
                return this.outlineColor;
            }
            case 803: {
                return new Boolean(this.outlineOn);
            }
            case 804: {
                return new Double(this.scaleFactor);
            }
            case 805: {
                return new Integer(this.getNumberXBins());
            }
            case 806: {
                return new Integer(this.getNumberYBins());
            }
            case 807: {
                return Boolean.FALSE;
            }
            case 820: {
                return new Boolean(this.colorByStat);
            }
            case 809: {
                return new Boolean(this.bivariate || this.groupMapper != null);
            }
            case 810: {
                boolean fix = this.isDiscrete((Object)this.xRole) || !this.filter.isNumericVariable(this.getVariable((Object)this.xRole));
                return new Boolean(fix);
            }
            case 811: {
                boolean fix_y = this.isDiscrete((Object)this.yRole) || !this.filter.isNumericVariable(this.getVariable((Object)this.yRole));
                return new Boolean(fix_y);
            }
            case 812: {
                return new Boolean(this.xDiscrete);
            }
            case 813: {
                return new Boolean(this.isDiscrete((Object)this.yRole));
            }
            case 814: {
                return this.getSortOrder(new Integer(24));
            }
            case 815: {
                return this.getSortOrder(new Integer(25));
            }
            case 816: {
                if (this.xBinNames != null) {
                    return Boolean.FALSE;
                }
                if (this.filter != null) {
                    return new Boolean(this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0)));
                }
                return null;
            }
            case 817: {
                if (this.filter != null) {
                    return new Boolean(this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0)));
                }
                return null;
            }
            case 819: {
                return new Boolean(this.gradient);
            }
            case 821: {
                return new Boolean(this.intervalAxis);
            }
            case 823: {
                return new Integer(this.groupDisplayStyle);
            }
            case 23: {
                this.currentLegend = null;
                if (this.bivariate) {
                    this.currentLegend = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0)) > -1 ? this.responseRole.toString() : (this.statType == 11 ? statName_Percent : statName_Frequency);
                }
                if (this.currentLegend == null) {
                    if (this.groupList != null) {
                        this.currentLegend = this.groupRole.toString();
                    } else if (this.colorByStat) {
                        this.currentLegend = this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0)) > -1 ? this.responseRole.toString() : (this.statType == 11 ? statName_Percent : statName_Frequency);
                    }
                }
                rc = this.currentLegend;
                break;
            }
            case 24: 
            case 25: {
                if (this.filter == null || !this.bivariate && !this.colorByStat && this.groupList == null) break;
                Vector<String> legNames = new Vector<String>();
                if (this.groupList != null) {
                    legNames.add(this.groupRole.toString());
                } else if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0)) > -1) {
                    legNames.add(this.responseRole.toString());
                } else if (this.statType == 11) {
                    legNames.add(statName_Percent);
                } else {
                    legNames.add(statName_Frequency);
                }
                Object[] ln = new Object[legNames.size()];
                legNames.copyInto(ln);
                rc = ln;
                break;
            }
            case 433: {
                if (this.roles.getVariable((Object)this.xRole, 0) == null) break;
                if (this.groupList != null) {
                    Object[] groupVals = ((DataFilterInfoInterface)this.filter).getUniqueValues(this.roles.getVariable((Object)this.groupRole, 0), false, 10000);
                    Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(groupVals.length);
                    Color[] fillColors = this.style.getDataFillColors();
                    Color[] lineColors = this.style.getDataLineColors();
                    for (int i = 0; i < groupVals.length; ++i) {
                        DataStyleElement dse;
                        String attrValueStr;
                        Color color;
                        Object clrIndexObj;
                        int grpVal = this.groupMapper.getIndex(groupVals[i]);
                        MarkerAttrib ms = new MarkerAttrib();
                        ms.setVisible(true);
                        int clrIndex = grpVal;
                        int grpIndx = i;
                        if (grpVal < 0) continue;
                        if (this.colorIndexList != null && (clrIndexObj = this.colorIndexList.get(new Integer(grpVal))) != null) {
                            clrIndex = ((Number)clrIndexObj).intValue();
                        }
                        if (this.groupDisplayStyle == 1) {
                            if (this.colorIndexList != null) {
                                color = fillColors[clrIndex % fillColors.length];
                            } else {
                                attrValueStr = groupVals[i].toString();
                                dse = SILKUtilities.getStyleElement(attrValueStr, grpIndx, 2, this.style, this.styleElement, null).getAsDataStyle();
                                color = dse.getFillColor();
                            }
                            ms.setColor(color);
                            ms.setOutline(new Boolean(this.outlineOn));
                            ms.setOutline(this.outlineColor);
                        } else if (this.groupDisplayStyle == 2) {
                            if (this.colorIndexList != null) {
                                color = lineColors[clrIndex % lineColors.length];
                            } else {
                                attrValueStr = groupVals[i].toString();
                                dse = SILKUtilities.getStyleElement(attrValueStr, grpIndx, 2, this.style, this.styleElement, null).getAsDataStyle();
                                color = dse.getLineColor();
                            }
                            ms.setOutline(Boolean.FALSE);
                            ms.setOutline(color);
                            ms.setShape(new Integer(3));
                        } else if (grpVal == 0) {
                            if (this.colorIndexList != null) {
                                color = fillColors[clrIndex % fillColors.length];
                            } else {
                                attrValueStr = groupVals[i].toString();
                                dse = SILKUtilities.getStyleElement(attrValueStr, grpIndx, 2, this.style, this.styleElement, null).getAsDataStyle();
                                color = dse.getFillColor();
                            }
                            ms.setColor(color);
                            ms.setOutline(new Boolean(this.outlineOn));
                            ms.setOutline(this.outlineColor);
                        } else {
                            if (this.colorIndexList != null) {
                                color = lineColors[clrIndex % lineColors.length];
                            } else {
                                attrValueStr = groupVals[i].toString();
                                dse = SILKUtilities.getStyleElement(attrValueStr, grpIndx, 2, this.style, this.styleElement, null).getAsDataStyle();
                                color = dse.getLineColor();
                            }
                            ms.setOutline(Boolean.FALSE);
                            ms.setOutline(color);
                            ms.setShape(new Integer(3));
                        }
                        legendEntries.add(new LegendEntry(groupVals[i], ms, null));
                    }
                    rc = legendEntries;
                    break;
                }
                if (this.colorMapper == null) break;
                Vector<LegendEntry> legendEntries = new Vector<LegendEntry>(2);
                ContinuousRange cr = (ContinuousRange)this.getDataRange((byte)4);
                double minVal = cr.getMin();
                double maxVal = cr.getMax();
                Color clr = this.colorMapper.getColor(minVal);
                MarkerAttrib msi = new MarkerAttrib(true, clr);
                legendEntries.addElement(new LegendEntry(new Double(minVal), msi, null));
                if (minVal != 0.0 && maxVal != 0.0) {
                    double midVal = this.colorMapper.getNeutralValue();
                    clr = this.colorMapper.getNeutralColor();
                    if (clr != null && cr.contains((DataPoint)new ContinuousPoint(midVal))) {
                        msi = new MarkerAttrib(true, clr);
                        legendEntries.addElement(new LegendEntry(new Double(midVal), msi, null));
                    }
                }
                clr = this.colorMapper.getColor(maxVal);
                MarkerAttrib msi1 = new MarkerAttrib(true, clr);
                legendEntries.addElement(new LegendEntry(new Double(maxVal), msi1, null));
                rc = legendEntries;
                break;
            }
            case 426: 
            case 427: {
                if (this.groupList != null) {
                    rc = this.roles.getVariable((Object)this.groupRole, 0);
                } else if (this.filter.getVariableIndex(this.roles.getVariable((Object)this.responseRole, 0)) > -1) {
                    String suffixStr = this.statType == 1 ? statName_Sum : statName_Mean;
                    String rVar = this.roles.getVariable((Object)this.responseRole, 0).toString();
                    rVar = rVar + "(" + suffixStr + ")";
                    rc = rVar;
                }
                if (rc == null && this.bivariate) {
                    rc = this.statType == 11 ? (Object)statName_Percent : (Object)statName_Frequency;
                }
                if (!this.colorByStat) break;
                if (this.statType == 11) {
                    rc = statName_Percent;
                    break;
                }
                rc = statName_Frequency;
                break;
            }
            case 434: {
                if (this.groupRole.toString().equalsIgnoreCase(this.currentLegend)) {
                    rc = null;
                    break;
                }
                if (this.responseRole.toString().equalsIgnoreCase(this.currentLegend)) {
                    rc = this.roles.getVariable((Object)this.responseRole, 0);
                    break;
                }
                if (this.statType == 11) {
                    rc = statName_Percent;
                    break;
                }
                rc = statName_Frequency;
                break;
            }
            case 441: {
                if (this.groupList != null) {
                    rc = Boolean.FALSE;
                    break;
                }
                rc = Boolean.TRUE;
                break;
            }
            case 53: {
                rc = this.colorMapperEnabled || this.bivariate ? this.rampName : null;
                break;
            }
            case 19056: {
                if (this.bivariate) {
                    rc = new Object[]{RoleInterface.ROLE_Y};
                    break;
                }
                rc = new Object[]{RoleInterface.ROLE_RESPONSE};
                break;
            }
            case 19052: {
                rc = null;
                if (this.filter == null) break;
                Object rVar = null;
                if (this.bivariate) {
                    rVar = this.filter.getVariableDescription(this.roles.getVariable((Object)this.yRole, 0));
                } else {
                    rVar = this.roles.getVariable((Object)this.responseRole, 0);
                    if ((rVar = this.filter.getVariableDescription(rVar)) != null) {
                        String suffixStr = this.statType == 1 ? statName_Sum : statName_Mean;
                        rVar = rVar.toString() + "(" + suffixStr + ")";
                    }
                    if (rVar == null) {
                        rVar = this.roles.getVariable((Object)this.frequencyRole, 0);
                        rVar = this.filter.getVariableDescription(rVar);
                    }
                    if (rVar == null) {
                        rVar = this.statType == 11 ? statName_Percent : statName_Frequency;
                    }
                }
                rc = rVar;
                break;
            }
            case 824: {
                rc = this.xBinNames;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 821: {
                if (!(value instanceof Boolean)) break;
                this.intervalAxis = (Boolean)value;
                this.userSetProperties.set(821);
                if (!this.xDiscrete || this.bivariate) break;
                this.setDiscrete((Object)this.xRole, this.xDiscrete);
                break;
            }
            case 812: {
                this.xDiscrete = (Boolean)value;
                this.setDiscrete((Object)this.xRole, (Boolean)value);
                break;
            }
            case 802: {
                if (!(value instanceof Color)) break;
                this.outlineColor = (Color)value;
                this.userSetProperties.set(802);
                break;
            }
            case 803: {
                if (!(value instanceof Boolean)) break;
                this.outlineOn = (Boolean)value;
                this.userSetProperties.set(803);
                break;
            }
            case 804: {
                if (!(value instanceof Number)) break;
                this.scaleFactor = ((Number)value).doubleValue();
                this.userSetProperties.set(804);
                break;
            }
            case 805: {
                if (!(value instanceof Number)) break;
                this.setNumberXBins(((Number)value).intValue());
                this.userSetProperties.set(805);
                break;
            }
            case 806: {
                if (!(value instanceof Number)) break;
                this.setNumberYBins(((Number)value).intValue());
                this.userSetProperties.set(806);
                break;
            }
            case 807: {
                break;
            }
            case 820: {
                if (!(value instanceof Boolean)) break;
                this.colorByStat = (Boolean)value;
                this.userSetProperties.set(820);
                if (this.colorByStat) {
                    this.initColorRamp();
                    break;
                }
                if (this.colorMapper == null) break;
                this.colorMapper.unRegister(this);
                break;
            }
            case 813: {
                this.setDiscrete((Object)this.yRole, (Boolean)value);
                break;
            }
            case 814: {
                break;
            }
            case 815: {
                break;
            }
            case 819: {
                if (!(value instanceof Boolean)) break;
                this.setGradientOn((Boolean)value);
                break;
            }
            case 823: {
                if (!(value instanceof Number)) break;
                this.setGroupDisplayStyle(((Number)value).intValue());
                break;
            }
            case 824: {
                if (!(value instanceof double[])) break;
                this.setXBinNames((double[])value);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    public void setGradientOn(boolean onOff) {
        if (this.gradient == onOff) {
            return;
        }
        this.gradient = onOff;
        this.userSetProperties.set(819);
        this.fireLayerListenerChanged(1);
    }

    @Override
    public void dispose() {
        this.xRole = null;
        this.yRole = null;
        this.responseRole = null;
        this.xMapper = null;
        this.yMapper = null;
        this.groupMapper = null;
        this.rbHist = null;
        this.binMinMaxList_X = null;
        this.binMidList_X = null;
        this.freqList = null;
        this.responseList = null;
        this.groupList = null;
        this.groupFreqList = null;
        this.colorIndexList = null;
        this.binMinMaxList_Y = null;
        this.binMidList_Y = null;
        super.dispose();
    }

    protected void createBins() {
        this.numberOfBins_Y = 1;
        this.binMinMaxList_X = null;
        this.binMidList_X = null;
        this.freqList = null;
        this.responseList = null;
        this.groupList = null;
        this.groupFreqList = null;
        this.colorIndexList = null;
        this.binMinMaxList_Y = null;
        this.binMidList_Y = null;
        if (this.bivariate) {
            this.createBins_Bivariate();
        } else {
            this.createBins_Univariate();
        }
    }

    protected void createBins_Univariate() {
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        if (xVar == null) {
            return;
        }
        double minX = 0.0;
        double maxX = 0.0;
        double binRange_X = 0.0;
        if (this.xBinNames != null) {
            this.numberOfBins_X = this.xBinNames.length - 1;
        } else if (this.xMapper == null) {
            minX = ((Number)((DataFilterInfoInterface)this.filter).getMinimumValue(xVar)).doubleValue();
            maxX = ((Number)((DataFilterInfoInterface)this.filter).getMaximumValue(xVar)).doubleValue();
            if (this.xDataRange != null && this.xDataRange instanceof ContinuousRange) {
                minX = ((ContinuousRange)this.xDataRange).getMin();
                maxX = ((ContinuousRange)this.xDataRange).getMax();
            }
            double xRange = maxX - minX;
            this.numberOfBins_X = this.numberOfXBins;
            binRange_X = xRange / (double)this.numberOfBins_X;
            Object[] nm = new Object[this.filter.getNumberObservations(-1)];
            AbstractMap lhm = new LinkedHashMap<Double, Object>();
            if (this.xDiscrete && (this.intervalAxis || this.xMinMaxSet)) {
                double xBinWidth;
                for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
                    lhm.put(new Double(this.filter.getNumericValue(xVar, (long)i)), null);
                }
                lhm = new TreeMap(lhm);
                nm = lhm.keySet().toArray();
                binRange_X = xBinWidth = this.getBinWidth(nm);
                this.numberOfBins_X = (int)Math.round(((maxX += xBinWidth / 2.0) - (minX -= xBinWidth / 2.0)) / xBinWidth);
            }
        } else {
            binRange_X = 1.0;
            minX = -0.5;
            this.numberOfBins_X = this.xMapper.getNumberValues();
        }
        this.binMidList_X = new LinkedHashMap();
        this.binMinMaxList_X = new LinkedHashMap();
        this.freqList = new LinkedHashMap();
        this.responseList = new LinkedHashMap();
        boolean binned = false;
        double resp = 1.0;
        double freq = 1.0;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        Map<Integer, Double> grpList = new LinkedHashMap<Integer, Double>();
        Map<Integer, Double> grpFreqList = new LinkedHashMap<Integer, Double>();
        int grpVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.groupRole, 0));
        int colorIndexVarIndex = -1;
        if (this.groupList != null) {
            this.groupList.clear();
            this.groupList = null;
        }
        if (this.groupFreqList != null) {
            this.groupFreqList.clear();
            this.groupFreqList = null;
        }
        Object grpVar = null;
        String grpObj = null;
        Integer grpKeyObj = null;
        if (grpVarIndex > -1) {
            this.groupList = new LinkedHashMap();
            this.groupFreqList = new LinkedHashMap();
            grpVar = this.roles.getVariable((Object)this.groupRole, 0);
            colorIndexVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.colorIndexRole, 0));
            if (colorIndexVarIndex > -1) {
                this.colorIndexList = new LinkedHashMap();
            }
        }
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double xVal;
            if (this.xMapper != null) {
                String xObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.xRole, 0), (long)i, null);
                xVal = this.xMapper.getIndex(xObj);
            } else {
                xVal = this.filter.getNumericValue(xVar, (long)i);
            }
            resp = respVar != null ? this.filter.getNumericValue(respVar, (long)i) : 1.0;
            freq = this.roles.getVariable((Object)this.frequencyRole, 0) != null ? this.filter.getNumericValue(this.roles.getVariable((Object)this.frequencyRole, 0), (long)i) : 1.0;
            if (Double.isNaN(resp) || Double.isNaN(freq) || freq <= 0.0) continue;
            resp = freq * resp;
            binned = false;
            double epsilon = 0.0;
            for (int j = 0; j < this.numberOfBins_X && !binned; ++j) {
                double binMax;
                double binMin = this.xBinNames != null ? this.xBinNames[j] : minX + binRange_X * (double)j;
                double d = binMax = this.xBinNames != null ? this.xBinNames[j + 1] : binMin + binRange_X;
                if (this.xBinNames == null && this.xMapper == null && j == this.numberOfBins_X - 1) {
                    binMax = maxX;
                }
                double binMid = binMin + (binMax - binMin) / 2.0;
                epsilon = 0.0;
                boolean within = false;
                if (this.binningInclusive == 1) {
                    if (j == 0) {
                        epsilon = 0.1;
                    }
                    if (xVal > binMin - epsilon && xVal <= binMax) {
                        within = true;
                    }
                } else {
                    if (j == this.numberOfBins_X - 1) {
                        epsilon = 0.1;
                    }
                    if (xVal >= binMin && xVal < binMax + epsilon) {
                        within = true;
                    }
                }
                if (!within) continue;
                if (this.freqList.containsKey(new Integer(j))) {
                    double tmp = ((Number)this.freqList.get(new Integer(j))).doubleValue();
                    this.freqList.put(new Integer(j), new Double(tmp += freq));
                } else {
                    this.freqList.put(new Integer(j), new Double(freq));
                }
                if (!Double.isNaN(resp)) {
                    if (this.responseList.containsKey(new Integer(j))) {
                        double temp = ((Number)this.responseList.get(new Integer(j))).doubleValue();
                        this.responseList.put(new Integer(j), new Double(temp += resp));
                    } else {
                        this.responseList.put(new Integer(j), new Double(resp));
                    }
                }
                if (!this.binMidList_X.containsKey(new Integer(j))) {
                    this.binMidList_X.put(new Integer(j), new Double(binMid));
                    Double[] dbl = new Double[]{new Double(binMin), new Double(binMax)};
                    this.binMinMaxList_X.put(new Integer(j), dbl);
                }
                if (grpVarIndex > -1) {
                    grpObj = this.filter.getFormattedValue(grpVar, (long)i, null);
                    grpKeyObj = new Integer(this.groupMapper.getIndex(grpObj));
                    if (grpKeyObj != null) {
                        if (this.groupList.containsKey(new Integer(j))) {
                            grpList = (Map)this.groupList.get(new Integer(j));
                            if (grpList != null) {
                                if (grpList.containsKey(grpKeyObj)) {
                                    double temp = ((Number)grpList.get(grpKeyObj)).doubleValue();
                                    grpList.put(grpKeyObj, new Double(temp += resp));
                                    grpList = new TreeMap(grpList);
                                } else {
                                    grpList.put(grpKeyObj, new Double(resp));
                                    grpList = new TreeMap(grpList);
                                }
                            } else {
                                grpList = new LinkedHashMap();
                                grpList.put(grpKeyObj, new Double(resp));
                                grpList = new TreeMap(grpList);
                            }
                        } else {
                            grpList = new LinkedHashMap();
                            grpList.put(grpKeyObj, new Double(resp));
                            grpList = new TreeMap(grpList);
                        }
                        this.groupList.put(new Integer(j), grpList);
                        if (this.groupFreqList.containsKey(new Integer(j))) {
                            grpFreqList = (Map)this.groupFreqList.get(new Integer(j));
                            if (grpFreqList != null) {
                                if (grpFreqList.containsKey(grpKeyObj)) {
                                    double tmp = ((Number)grpFreqList.get(grpKeyObj)).doubleValue();
                                    grpFreqList.put(grpKeyObj, new Double(tmp += freq));
                                    grpFreqList = new TreeMap(grpFreqList);
                                } else {
                                    grpFreqList.put(grpKeyObj, new Double(freq));
                                    grpFreqList = new TreeMap(grpFreqList);
                                }
                            } else {
                                grpFreqList = new LinkedHashMap();
                                grpFreqList.put(grpKeyObj, new Double(freq));
                                grpFreqList = new TreeMap(grpFreqList);
                            }
                        } else {
                            grpFreqList = new LinkedHashMap();
                            grpFreqList.put(grpKeyObj, new Double(freq));
                            grpFreqList = new TreeMap(grpFreqList);
                        }
                        this.groupFreqList.put(new Integer(j), grpFreqList);
                    }
                    if (colorIndexVarIndex > -1) {
                        Object clrIndex = this.filter.getValue(this.roles.getVariable((Object)this.colorIndexRole, 0), (long)i);
                        this.colorIndexList.put(grpKeyObj, clrIndex);
                    }
                }
                binned = true;
            }
        }
        this.applyStat();
    }

    protected void createBins_Bivariate() {
        double binRange_X;
        double minX;
        this.numberOfBins_Y = 1;
        this.binMinMaxList_X = null;
        this.binMidList_X = null;
        this.freqList = null;
        this.responseList = null;
        this.binMinMaxList_Y = null;
        this.binMidList_Y = null;
        Object xVar = this.roles.getVariable((Object)this.xRole, 0);
        Object yVar = this.roles.getVariable((Object)this.yRole, 0);
        if (xVar == null || yVar == null) {
            return;
        }
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        double binRange_Y = 0.0;
        if (this.xMapper == null) {
            minX = ((Number)((DataFilterInfoInterface)this.filter).getMinimumValue(xVar)).doubleValue();
            maxX = ((Number)((DataFilterInfoInterface)this.filter).getMaximumValue(xVar)).doubleValue();
            if (this.xDataRange != null && this.xDataRange instanceof ContinuousRange) {
                minX = ((ContinuousRange)this.xDataRange).getMin();
                maxX = ((ContinuousRange)this.xDataRange).getMax();
            }
            double xRange = maxX - minX;
            this.numberOfBins_X = this.numberOfXBins;
            binRange_X = xRange / (double)this.numberOfBins_X;
        } else {
            binRange_X = 1.0;
            minX = -0.5;
            this.numberOfBins_X = this.xMapper.getNumberValues();
        }
        if (this.yMapper == null) {
            minY = ((Number)((DataFilterInfoInterface)this.filter).getMinimumValue(yVar)).doubleValue();
            maxY = ((Number)((DataFilterInfoInterface)this.filter).getMaximumValue(yVar)).doubleValue();
            if (this.yDataRange != null && this.yDataRange instanceof ContinuousRange) {
                minY = ((ContinuousRange)this.yDataRange).getMin();
                maxY = ((ContinuousRange)this.yDataRange).getMax();
            }
            double yRange = maxY - minY;
            this.numberOfBins_Y = this.numberOfYBins;
            binRange_Y = yRange / (double)this.numberOfBins_Y;
        } else {
            minY = -0.5;
            binRange_Y = 1.0;
            this.numberOfBins_Y = this.yMapper.getNumberValues();
        }
        this.binMidList_X = new LinkedHashMap();
        this.binMinMaxList_X = new LinkedHashMap();
        this.binMidList_Y = new LinkedHashMap();
        this.binMinMaxList_Y = new LinkedHashMap();
        this.freqList = new LinkedHashMap();
        this.responseList = new LinkedHashMap();
        boolean binned = false;
        double resp = 1.0;
        double freq = 1.0;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        double epsilon_X = 0.0;
        double epsilon_Y = 0.0;
        for (int i = 0; i < this.filter.getNumberObservations(-1); ++i) {
            double yVal;
            double xVal;
            if (this.xMapper != null) {
                String xObj = this.filter.getFormattedValue(this.roles.getVariable((Object)this.xRole, 0), (long)i, null);
                xVal = this.xMapper.getIndex(xObj);
            } else {
                xVal = this.filter.getNumericValue(xVar, (long)i);
            }
            resp = respVar != null ? this.filter.getNumericValue(respVar, (long)i) : 1.0;
            freq = this.roles.getVariable((Object)this.frequencyRole, 0) != null ? this.filter.getNumericValue(this.roles.getVariable((Object)this.frequencyRole, 0), (long)i) : 1.0;
            if (Double.isNaN(resp) || Double.isNaN(freq) || freq <= 0.0) continue;
            resp = freq * resp;
            binned = false;
            if (this.yMapper != null) {
                String yObj = this.filter.getFormattedValue(yVar, (long)i, null);
                yVal = this.yMapper.getIndex(yObj);
            } else {
                yVal = this.filter.getNumericValue(yVar, (long)i);
            }
            for (int k = 0; k < this.numberOfBins_Y && !binned; ++k) {
                double ybinMin = minY + binRange_Y * (double)k;
                double ybinMax = ybinMin + binRange_Y;
                if (this.yMapper == null && k == this.numberOfBins_Y - 1) {
                    ybinMax = maxY;
                }
                double ybinMid = ybinMin + (ybinMax - ybinMin) / 2.0;
                for (int j = 0; j < this.numberOfBins_X && !binned; ++j) {
                    double xbinMin = minX + binRange_X * (double)j;
                    double xbinMax = xbinMin + binRange_X;
                    if (this.xMapper == null && j == this.numberOfBins_X - 1) {
                        xbinMax = maxX;
                    }
                    double xbinMid = xbinMin + (xbinMax - xbinMin) / 2.0;
                    epsilon_X = 0.0;
                    epsilon_Y = 0.0;
                    boolean withinX = false;
                    if (this.binningInclusive == 1) {
                        if (j == 0) {
                            epsilon_X = 0.1;
                        }
                        if (xVal > xbinMin - epsilon_X && xVal <= xbinMax) {
                            withinX = true;
                        }
                    } else {
                        if (j == this.numberOfBins_X - 1) {
                            epsilon_X = 0.1;
                        }
                        if (xVal >= xbinMin && xVal < xbinMax + epsilon_X) {
                            withinX = true;
                        }
                    }
                    boolean withinY = false;
                    if (this.binningInclusive == 1) {
                        if (k == 0) {
                            epsilon_Y = 0.1;
                        }
                        if (yVal > ybinMin - epsilon_Y && yVal <= ybinMax) {
                            withinY = true;
                        }
                    } else {
                        if (k == this.numberOfBins_Y - 1) {
                            epsilon_Y = 0.1;
                        }
                        if (yVal >= ybinMin && yVal < ybinMax + epsilon_Y) {
                            withinY = true;
                        }
                    }
                    if (!withinX || !withinY) continue;
                    int index = j + k * this.numberOfBins_X;
                    if (this.freqList.containsKey(new Integer(index))) {
                        double tmp = ((Number)this.freqList.get(new Integer(index))).doubleValue();
                        this.freqList.put(new Integer(index), new Double(tmp += freq));
                    } else {
                        this.freqList.put(new Integer(index), new Double(freq));
                    }
                    if (!Double.isNaN(resp)) {
                        if (this.responseList.containsKey(new Integer(index))) {
                            double temp = ((Number)this.responseList.get(new Integer(index))).doubleValue();
                            this.responseList.put(new Integer(index), new Double(temp += resp));
                        } else {
                            this.responseList.put(new Integer(index), new Double(resp));
                        }
                    }
                    if (!this.binMidList_X.containsKey(new Integer(j))) {
                        this.binMidList_X.put(new Integer(j), new Double(xbinMid));
                        Double[] dbl = new Double[]{new Double(xbinMin), new Double(xbinMax)};
                        this.binMinMaxList_X.put(new Integer(j), dbl);
                    }
                    if (!this.binMidList_Y.containsKey(new Integer(k))) {
                        this.binMidList_Y.put(new Integer(k), new Double(ybinMid));
                        Double[] dbl = new Double[]{new Double(ybinMin), new Double(ybinMax)};
                        this.binMinMaxList_Y.put(new Integer(k), dbl);
                    }
                    binned = true;
                }
            }
        }
        this.applyStat();
    }

    public int getNumberXBins() {
        return this.numberOfXBins;
    }

    public void setNumberXBins(int num) {
        if (num <= 0) {
            return;
        }
        this.numberOfXBins = num;
        this.createBins();
        if (!this.bivariate) {
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        }
        this.fireLayerListenerChanged(3);
    }

    public int getNumberYBins() {
        return this.numberOfYBins;
    }

    public void setNumberYBins(int num) {
        if (num <= 0) {
            return;
        }
        this.numberOfYBins = num;
        this.createBins();
        this.fireLayerListenerChanged(3);
    }

    public void setXAxisMinMax(double min, double max) {
        if (Double.isNaN(min) || Double.isNaN(max)) {
            this.xMinMaxSet = false;
            this.xAxisMin = Double.NaN;
            this.xAxisMax = Double.NaN;
        } else {
            this.xMinMaxSet = true;
            this.xAxisMin = min;
            this.xAxisMax = max;
        }
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
    }

    private double getBinWidth(Object[] valueArray) {
        if (valueArray == null) {
            return 0.0;
        }
        if (valueArray[0] instanceof Number) {
            int size = valueArray.length - 2;
            if (size > 0) {
                double val = Double.MAX_VALUE;
                for (int i = 0; i < size; ++i) {
                    double currVal = ((Number)valueArray[i + 1]).doubleValue() - ((Number)valueArray[i]).doubleValue();
                    val = Math.min(val, currVal);
                }
                return val;
            }
            return 1.0;
        }
        return 0.0;
    }

    public void setXBinNames(double[] binNames) {
        this.xBinNames = binNames;
        this.numberOfXBins = this.xBinNames.length - 1;
        this.xAxisMin = this.xBinNames[0];
        this.xAxisMax = this.xBinNames[this.numberOfXBins];
        this.createBins();
        this.userSetProperties.set(824);
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
        this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
        this.fireLayerListenerChanged(7);
    }

    protected void clearXBinNames() {
        this.xBinNames = null;
        this.userSetProperties.clear(824);
    }

    @Override
    public DataRange getDataRange(byte dimension) {
        DataRange rc = null;
        switch (dimension) {
            case 4: {
                Object xVar = this.roles.getVariable((Object)this.xRole, 0);
                if (this.filter == null || xVar == null) {
                    return null;
                }
                double max = 0.0;
                double min = 0.0;
                if (this.groupList == null) {
                    Iterator iter = this.responseList.values().iterator();
                    while (iter.hasNext()) {
                        double respValue = ((Number)iter.next()).doubleValue();
                        max = Math.max(max, respValue);
                        min = Math.min(min, respValue);
                    }
                } else {
                    Object respObj = null;
                    Map grpList = null;
                    for (int i = 0; i < this.groupList.size(); ++i) {
                        grpList = (Map)this.groupList.get(new Integer(i));
                        if (grpList == null) continue;
                        for (Map.Entry e : grpList.entrySet()) {
                            respObj = e.getValue();
                            double respValue = ((Number)respObj).doubleValue();
                            if (Double.isNaN(respValue)) continue;
                            max = Math.max(max, respValue);
                            min = Math.min(min, respValue);
                        }
                    }
                }
                double colorMin = min;
                double colorMax = max;
                rc = new ContinuousRange(colorMin, colorMax);
                break;
            }
            default: {
                rc = super.getDataRange(dimension);
            }
        }
        return rc;
    }

    @Override
    public Object getVariable(Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            return this.getStatistic();
        }
        return super.getVariable(role);
    }

    @Override
    public boolean setRole(Object variableId, Object role) {
        if (role instanceof String && ((String)role).equalsIgnoreCase("StatisticType") || role instanceof Number && ((Number)role).intValue() == 38) {
            this.setStatistic(variableId);
            this.createBins();
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 1));
            this.fireRangeChangeEvent(new RangeChangedEvent((Object)this, 0, null, 2));
            this.fireLayerListenerChanged(7);
            this.fireLayerListenerChanged(3);
        }
        return super.setRole(variableId, role);
    }

    public void setStatistic(Object type) {
        if (type == null) {
            return;
        }
        this.statType = DefaultStatistics.getStatisticIndex((Object)type);
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        switch (this.statType) {
            case 11: 
            case 12: {
                if (respVar == null) break;
                this.statType = 1;
                break;
            }
            case 1: 
            case 2: {
                if (respVar != null) break;
                this.statType = 12;
                break;
            }
            default: {
                this.statType = respVar == null ? 12 : 1;
            }
        }
        this.fireLayerListenerChanged(6, this.responseRole.toString());
        this.fireLayerListenerChanged(3);
    }

    public Object getStatistic() {
        String rc = null;
        Object respVar = this.roles.getVariable((Object)this.responseRole, 0);
        switch (this.statType) {
            case 1: {
                rc = statName_Sum;
                break;
            }
            case 2: {
                rc = statName_Mean;
                break;
            }
            case 11: {
                rc = statName_Percent;
                break;
            }
            case 12: {
                rc = statName_Frequency;
                break;
            }
            default: {
                rc = respVar == null ? statName_Frequency : statName_Sum;
            }
        }
        return rc;
    }

    protected void applyStat() {
        block14: {
            block13: {
                if (this.groupList == null) break block13;
                if (this.statType == 11) {
                    Iterator iter = this.freqList.values().iterator();
                    double freqValue = 0.0;
                    double totalFreq = 0.0;
                    while (iter.hasNext()) {
                        freqValue = ((Number)iter.next()).doubleValue();
                        totalFreq += freqValue;
                    }
                    if (totalFreq == 0.0) {
                        return;
                    }
                    Object[] catArray = this.groupList.keySet().toArray();
                    double respValue = 0.0;
                    for (int catIndex = 0; catIndex < catArray.length; ++catIndex) {
                        Map grpList = (Map)this.groupList.get(catArray[catIndex]);
                        if (grpList == null) continue;
                        for (Map.Entry e : grpList.entrySet()) {
                            Object grpKeyObj = e.getKey();
                            Object respObj = e.getValue();
                            if (respObj == null || (respValue = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respValue)) continue;
                            respValue = respValue * 100.0 / totalFreq;
                            grpList.put(grpKeyObj, new Double(respValue));
                        }
                    }
                }
                if (this.statType != 2) break block14;
                Object[] catArray = this.groupList.keySet().toArray();
                double respValue = 0.0;
                for (int catIndex = 0; catIndex < catArray.length; ++catIndex) {
                    Map grpList = (Map)this.groupList.get(catArray[catIndex]);
                    Map grpFreqList = (Map)this.groupFreqList.get(catArray[catIndex]);
                    if (grpList == null) continue;
                    for (Map.Entry e : grpList.entrySet()) {
                        Object grpKeyObj = e.getKey();
                        Object respObj = e.getValue();
                        if (respObj == null || (respValue = ((Number)respObj).doubleValue()) == 0.0 || Double.isNaN(respValue)) continue;
                        Object freqObj = grpFreqList.get(grpKeyObj);
                        double freqValue = ((Number)freqObj).doubleValue();
                        grpList.put(grpKeyObj, new Double(respValue /= freqValue));
                    }
                }
                break block14;
            }
            if (this.statType == 11) {
                Iterator iter = this.freqList.values().iterator();
                double freqValue = 0.0;
                double totalFreq = 0.0;
                while (iter.hasNext()) {
                    freqValue = ((Number)iter.next()).doubleValue();
                    totalFreq += freqValue;
                }
                if (totalFreq == 0.0) {
                    return;
                }
                Object[] respArray = this.responseList.values().toArray();
                Object[] catArray = this.responseList.keySet().toArray();
                double respValue = 0.0;
                for (int catIndex = 0; catIndex < catArray.length; ++catIndex) {
                    respValue = ((Number)respArray[catIndex]).doubleValue();
                    respValue = respValue * 100.0 / totalFreq;
                    this.responseList.put(catArray[catIndex], new Double(respValue));
                }
            }
            if (this.statType == 2) {
                Object[] respArray = this.responseList.values().toArray();
                Object[] catArray = this.responseList.keySet().toArray();
                Object[] freqArray = this.freqList.values().toArray();
                double respValue = 0.0;
                double freqValue = 0.0;
                for (int catIndex = 0; catIndex < catArray.length; ++catIndex) {
                    respValue = ((Number)respArray[catIndex]).doubleValue();
                    freqValue = ((Number)freqArray[catIndex]).doubleValue();
                    if (Double.isNaN(freqValue) || freqValue == 0.0) continue;
                    this.responseList.put(catArray[catIndex], new Double(respValue /= freqValue));
                }
            }
        }
    }

    @Override
    public Object[][] getSupportedSortableRoles() {
        boolean sortX = false;
        boolean sortY = false;
        if (!this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
            sortX = true;
        }
        if (this.bivariate && !this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
            sortY = true;
        }
        if (sortX && sortY) {
            return new Object[][]{{this.xRole, this.yRole}};
        }
        if (sortX) {
            return new Object[][]{{this.xRole}};
        }
        if (sortY) {
            return new Object[][]{{this.yRole}};
        }
        return null;
    }

    @Override
    public int[] getSupportedSortDirections(Object role) {
        if (role == null) {
            return null;
        }
        return new int[]{1, -1, 0};
    }

    @Override
    public Object getSortOrder(Object role) {
        if (role == null) {
            return null;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(this.xRole.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            return new Integer(this.sortOrderX);
        }
        if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(this.yRole.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            return new Integer(this.sortOrderY);
        }
        return null;
    }

    @Override
    public boolean setSortOrder(Object role, Object order) {
        if (role == null || order == null) {
            return false;
        }
        if (role instanceof Number && ((Number)role).intValue() == 24 || role instanceof String && ((String)role).equalsIgnoreCase(this.xRole.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("X")) {
            this.sortOrderX = ((Number)order).intValue();
            if (this.xMapper != null && !this.filter.isNumericVariable(this.roles.getVariable((Object)this.xRole, 0))) {
                this.xMapper.setSort(this.sortOrderX);
            }
        } else if (role instanceof Number && ((Number)role).intValue() == 25 || role instanceof String && ((String)role).equalsIgnoreCase(this.yRole.toString()) || role instanceof String && ((String)role).equalsIgnoreCase("Y")) {
            this.sortOrderY = ((Number)order).intValue();
            if (this.yMapper != null && !this.filter.isNumericVariable(this.roles.getVariable((Object)this.yRole, 0))) {
                this.yMapper.setSort(this.sortOrderY);
            }
        } else {
            return false;
        }
        return super.setSortOrder(role, order);
    }

    public void setGroupDisplayStyle(int displayStyle) {
        this.groupDisplayStyle = displayStyle;
        this.userSetProperties.set(823);
    }

    public void setBinningInclusive(int inclusive) {
        this.binningInclusive = inclusive;
        this.rebuildRequired = true;
    }

    protected int getBinWidthOnScreen(byte dim, double binStart, double binEnd) {
        if (this.xBinNames != null) {
            if (this.xBinNames.length <= 2) {
                binEnd = 0.0;
                binStart = 0.0;
            }
        } else {
            switch (dim) {
                case 1: {
                    Object[] binMid_X = this.binMidList_X.values().toArray();
                    if (this.xMapper != null) {
                        binStart = 0.0;
                        binEnd = 1.0;
                        if (this.xMapper.getNumberValues() > 1) break;
                        binEnd = 0.0;
                        break;
                    }
                    if (this.xOutputRange instanceof ContinuousRange) {
                        ContinuousRange cr = (ContinuousRange)this.xOutputRange;
                        if (cr.getMin() != cr.getMax()) break;
                        binEnd = binStart;
                        break;
                    }
                    if (binMid_X == null || binMid_X.length != 1) break;
                    binEnd = 0.0;
                    binStart = 0.0;
                    break;
                }
                case 2: {
                    Object[] binMid_Y = this.binMidList_Y.values().toArray();
                    if (this.yMapper != null) {
                        binStart = 0.0;
                        binEnd = 1.0;
                        if (this.yMapper.getNumberValues() > 1) break;
                        binEnd = 0.0;
                        break;
                    }
                    if (this.yOutputRange instanceof ContinuousRange) {
                        ContinuousRange cr = (ContinuousRange)this.yOutputRange;
                        if (cr.getMin() != cr.getMax()) break;
                        binEnd = binStart;
                        break;
                    }
                    if (binMid_Y == null || binMid_Y.length != 1) break;
                    binEnd = 0.0;
                    binStart = 0.0;
                }
            }
        }
        int barWidth = this.getScreenSpacing(dim, binStart, binEnd);
        barWidth = (int)((double)barWidth * this.scaleFactor);
        return barWidth;
    }
}

