/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.interfaces.RoleInterface;
import com.sas.graphics.silk.util.CharacterVariableMapper;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import com.sas.graphics.silk.util.SILKUtilities;
import com.sas.graphics.silk.util.TransformObject;
import com.sas.graphics.styles.DataStyleElement;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Vector;

public class DistributionElement
extends BaseElement {
    int xVarIndex = -1;
    int yVarIndex = -1;
    protected SILKNumber xRole = this.role.getRoleObject("ROLE_X");
    protected SILKNumber yRole = null;
    int[] binArray = null;
    int[] selectBinArray = null;
    double scale = 1.0;
    int w1 = 0;
    int h1 = 0;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double xScale;
    double yScale;
    CharacterVariableMapper charMapper = null;
    public static final int[] supportedDensityProperties = new int[0];

    public DistributionElement() {
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 0);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 0);
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        int loc;
        if (this.binArray == null) {
            return null;
        }
        double[] vals = this.transformObject.unProject(screenX, screenY, 0.0, null);
        double x = vals[0];
        double y = vals[1];
        String s = "";
        Object var = this.roles.getVariable((Object)this.xRole, 0);
        if (var != null) {
            s = s + this.filter.getVariableDescription(var) + " \t = \t " + this.getFormattedValue(var, new Double(x)) + "\n";
        }
        if ((var = this.roles.getVariable((Object)this.yRole, 0)) != null) {
            s = s + this.filter.getVariableDescription(var) + " \t = \t " + this.getFormattedValue(var, new Double(y)) + "\n";
        }
        if (this.xVarIndex < 0) {
            int loc2 = screenY - this.innerMargin.top;
            if (loc2 >= 0 && loc2 < this.binArray.length) {
                s = s + ResourceLoader.getResourceString((Object)this.rb, (String)"DensityElement.Freq.txt", (String)"freq.") + " \t = \t " + this.getDefaultFormattedValue(new Double(Math.round((double)this.binArray[loc2] / this.scale)));
            }
        } else if (this.yVarIndex < 0 && (loc = screenX - this.innerMargin.left) >= 0 && loc < this.binArray.length) {
            s = s + ResourceLoader.getResourceString((Object)this.rb, (String)"DensityElement.Freq.txt", (String)"freq.") + " \t = \t " + this.getDefaultFormattedValue(new Double(Math.round((double)this.binArray[loc] / this.scale)));
        }
        return s;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        int w = this.bounds.width - this.innerMargin.left - this.innerMargin.right;
        int h = this.bounds.height - this.innerMargin.top - this.innerMargin.bottom;
        if (w == this.w1 && h == this.h1) {
            return;
        }
        this.w1 = w;
        this.h1 = h;
        this.allocateDataStructures();
    }

    private void allocateDataStructures() {
        if (this.filter == null) {
            return;
        }
        this.xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        this.yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0));
        if (this.charMapper != null) {
            this.charMapper.dispose();
            this.charMapper = null;
        }
        if (this.xVarIndex >= 0 && !this.filter.isNumericVariable(this.xVarIndex)) {
            this.charMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable(RoleInterface.ROLE_X, 0));
        } else if (this.yVarIndex >= 0 && !this.filter.isNumericVariable(this.yVarIndex)) {
            this.charMapper = new CharacterVariableMapper(this.filter, this.roles.getVariable(RoleInterface.ROLE_Y, 0));
        }
        if (this.w1 > 0 && this.h1 > 0) {
            if (this.xVarIndex >= 0) {
                this.binArray = new int[this.w1 + 1];
                this.selectBinArray = new int[this.w1 + 1];
            } else if (this.yVarIndex >= 0) {
                this.binArray = new int[this.h1 + 1];
                this.selectBinArray = new int[this.h1 + 1];
            }
            this.build(Boolean.TRUE);
        }
    }

    @Override
    public boolean build(Object buildData) {
        int varIndex;
        boolean rc = super.build(buildData);
        if (this.filter == null) {
            return false;
        }
        this.xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
        this.yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0));
        if (this.xOutputRange == null && this.xVarIndex >= 0) {
            this.xOutputRange = this.getPreferredRange(this.getPropertyValue(19057));
            if (this.transformObject instanceof TransformObject) {
                ((TransformObject)this.transformObject).setXRange(this.xOutputRange);
            }
        }
        if (this.yOutputRange == null && this.yVarIndex >= 0) {
            this.yOutputRange = this.getPreferredRange(this.getPropertyValue(19056));
            if (this.transformObject instanceof TransformObject) {
                ((TransformObject)this.transformObject).setYRange(this.yOutputRange);
            }
        }
        int n = varIndex = this.xVarIndex >= 0 ? this.xVarIndex : this.yVarIndex;
        if (this.filter.isNumericVariable(varIndex)) {
            this.buildNumeric();
        } else {
            this.buildCharachter();
        }
        return rc;
    }

    private void buildCharachter() {
        if (this.charMapper == null) {
            return;
        }
        DataRange xdr = this.getOutputRange((byte)1);
        DataRange ydr = this.getOutputRange((byte)2);
        if (xdr instanceof ContinuousRange) {
            return;
        }
        if (ydr instanceof ContinuousRange) {
            return;
        }
        DiscreteRange xRange = (DiscreteRange)xdr;
        DiscreteRange yRange = (DiscreteRange)ydr;
        if (xRange != null) {
            this.xMin = 0.0;
            this.xMax = xRange.getValuesSize() - 1;
            this.yMax = Double.NaN;
            this.yMin = Double.NaN;
        }
        if (yRange != null) {
            this.yMin = 0.0;
            this.yMax = yRange.getValuesSize() - 1;
            this.xMax = Double.NaN;
            this.xMin = Double.NaN;
        }
        int numValues = 0;
        if (xRange != null) {
            numValues = xRange.getValuesSize();
        } else if (yRange != null) {
            numValues = yRange.getValuesSize();
        }
        this.xScale = xRange == null ? Double.NaN : 1.0 / (double)(numValues - 1);
        double d = this.yScale = yRange == null ? Double.NaN : 1.0 / (double)(numValues - 1);
        if (this.bounds != null && this.w1 != 0 && this.h1 != 0 && this.binArray != null) {
            int i;
            int count = this.filter.getNumberObservations(-1);
            int maxCount = 0;
            for (i = 0; i < this.binArray.length; ++i) {
                this.binArray[i] = 0;
            }
            for (i = 0; i < count; ++i) {
                String val = this.filter.getFormattedValue(this.filter.getVariableId(this.xVarIndex >= 0 ? this.xVarIndex : this.yVarIndex), (long)i, null);
                int x1 = this.project(this.charMapper.getIndex(val));
                if (x1 < 0 || x1 >= this.binArray.length) continue;
                int n = x1;
                this.binArray[n] = this.binArray[n] + 1;
                maxCount = Math.max(maxCount, this.binArray[x1]);
            }
            this.scale = (double)(this.xVarIndex >= 0 ? this.h1 : this.w1) / ((double)maxCount * 1.1);
            for (i = 0; i < this.binArray.length; ++i) {
                this.binArray[i] = (int)((double)this.binArray[i] * this.scale);
            }
        }
    }

    private void buildNumeric() {
        ContinuousRange xRange = (ContinuousRange)this.getOutputRange((byte)1);
        ContinuousRange yRange = (ContinuousRange)this.getOutputRange((byte)2);
        this.xMin = xRange == null ? Double.NaN : xRange.getMin();
        this.xMax = xRange == null ? Double.NaN : xRange.getMax();
        this.yMin = yRange == null ? Double.NaN : yRange.getMin();
        this.yMax = yRange == null ? Double.NaN : yRange.getMax();
        this.xScale = xRange == null ? Double.NaN : 1.0 / (this.xMax - this.xMin);
        double d = this.yScale = yRange == null ? Double.NaN : 1.0 / (this.yMax - this.yMin);
        if (this.bounds != null && this.w1 != 0 && this.h1 != 0 && this.binArray != null) {
            int i;
            int count = this.filter.getNumberObservations(-1);
            int maxCount = 0;
            for (i = 0; i < this.binArray.length; ++i) {
                this.binArray[i] = 0;
            }
            for (i = 0; i < count; ++i) {
                int x1;
                double val = this.filter.getNumericValue(this.xVarIndex >= 0 ? this.xVarIndex : this.yVarIndex, (long)i);
                if (Double.isNaN(val) || (x1 = this.project(val)) < 0 || x1 >= this.binArray.length) continue;
                int n = x1;
                this.binArray[n] = this.binArray[n] + 1;
                maxCount = Math.max(maxCount, this.binArray[x1]);
            }
            this.scale = (double)(this.xVarIndex >= 0 ? this.h1 : this.w1) / ((double)maxCount * 1.1);
            for (i = 0; i < this.binArray.length; ++i) {
                this.binArray[i] = (int)((double)this.binArray[i] * this.scale);
            }
        }
    }

    @Override
    public void roleChanged(RoleEvent e) {
        this.yOutputRange = null;
        this.xOutputRange = null;
        super.roleChanged(e);
        switch (e.type) {
            case 1: 
            case 2: {
                if (e.role == 24) {
                    Object y = this.roles.getVariable(RoleInterface.ROLE_Y, 0);
                    this.roles.removeRole(y, RoleInterface.ROLE_Y);
                } else if (e.role == 25) {
                    Object x = this.roles.getVariable(RoleInterface.ROLE_X, 0);
                    this.roles.removeRole(x, RoleInterface.ROLE_X);
                }
                this.allocateDataStructures();
            }
        }
        if (this.xVarIndex < 0 && this.yVarIndex < 0) {
            this.binArray = null;
        }
    }

    @Override
    public int getYAxisMapping() {
        if (this.yVarIndex >= 0) {
            return super.getYAxisMapping();
        }
        return -1;
    }

    @Override
    public int getXAxisMapping() {
        if (this.xVarIndex >= 0) {
            return super.getXAxisMapping();
        }
        return -1;
    }

    @Override
    protected void drawChart(Graphics g) {
        Object var;
        if (this.binArray == null) {
            this.build(Boolean.TRUE);
            if (this.binArray == null) {
                return;
            }
        }
        Object object = var = this.xVarIndex >= 0 ? this.roles.getVariable((Object)this.xRole, 0) : this.roles.getVariable((Object)this.yRole, 0);
        if (var == null) {
            return;
        }
        String id = var.toString();
        DataStyleElement dse = SILKUtilities.getStyleElement(id, -1, 1, this.style, this.lineAttrs.getReference(), this.lineAttrs.getOverrides(false)).getAsDataStyle();
        Color dataColor = dse.getLineColor();
        g.setColor(dataColor);
        double totalLen = this.xVarIndex >= 0 ? (double)this.h1 : (double)this.w1;
        int startX = this.innerMargin.left;
        if (this.transformObject instanceof TransformObject) {
            startX = this.bounds.x + this.innerMargin.left;
        }
        int startY = this.innerMargin.bottom;
        if (this.transformObject instanceof TransformObject) {
            startY = this.bounds.y + this.innerMargin.bottom;
        }
        for (int i = 0; i < this.binArray.length; ++i) {
            int len;
            int index = i;
            if (this.xVarIndex >= 0 && this.transformObject.isReverse(0)) {
                index = this.binArray.length - 1 - i;
            } else if (this.yVarIndex >= 0 && this.transformObject.isReverse(1)) {
                index = this.binArray.length - 1 - i;
            }
            if (this.binArray[index] == 0) continue;
            int n = len = this.xVarIndex >= 0 ? (int)(totalLen - (double)this.binArray[index]) : this.binArray[index];
            if (this.xVarIndex >= 0) {
                g.drawLine(i + startX, this.h1 + startY, i + startX, len + startY);
                continue;
            }
            g.drawLine(startX, i + startY, len + startX, i + startY);
        }
    }

    private final int project(double value) {
        if (this.xVarIndex >= 0) {
            if (this.xMin == this.xMax) {
                return this.w1 / 2;
            }
            return (int)((double)this.w1 * (value - this.xMin) * this.xScale);
        }
        if (this.yMin == this.yMax) {
            return this.h1 / 2;
        }
        return (int)((double)this.h1 - (double)this.h1 * (value - this.yMin) * this.yScale);
    }

    @Override
    protected void drawSelected(Graphics g) {
        block16: {
            boolean ch;
            int startY;
            int startX;
            Color selectionColor;
            block15: {
                boolean ch2;
                if (this.selections == null || !this.selections.hasMoreSelections()) {
                    return;
                }
                if (this.xVarIndex < 0 && this.yVarIndex < 0) {
                    return;
                }
                for (int i = 0; i < this.selectBinArray.length; ++i) {
                    this.selectBinArray[i] = 0;
                }
                selectionColor = this.style.getLineStyleElement("Selection").getLineColor();
                g.setColor(selectionColor);
                startX = this.innerMargin.left;
                if (this.transformObject instanceof TransformObject) {
                    startX = this.bounds.x + this.innerMargin.left;
                }
                startY = this.innerMargin.bottom;
                if (this.transformObject instanceof TransformObject) {
                    startY = this.bounds.y + this.innerMargin.bottom;
                }
                if (this.xVarIndex < 0) break block15;
                boolean bl = ch2 = !this.filter.isNumericVariable(this.xVarIndex);
                while (this.selections.hasMoreSelections()) {
                    int index = this.selections.nextSelectedIndex();
                    int x1 = -1;
                    x1 = !ch2 ? this.project(this.filter.getNumericValue(this.xVarIndex, (long)index)) : this.project(this.charMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(this.xVarIndex), (long)index, null)));
                    if (x1 < 0 || x1 >= this.selectBinArray.length) continue;
                    int n = x1;
                    this.selectBinArray[n] = this.selectBinArray[n] + 1;
                }
                for (int i = 0; i < this.selectBinArray.length; ++i) {
                    int index = i;
                    if (this.xVarIndex >= 0 && this.transformObject.isReverse(0)) {
                        index = this.selectBinArray.length - 1 - i;
                    } else if (this.yVarIndex >= 0 && this.transformObject.isReverse(1)) {
                        index = this.selectBinArray.length - 1 - i;
                    }
                    if (this.selectBinArray[index] == 0) continue;
                    int y1 = (int)((double)this.h1 - (double)this.selectBinArray[index] * this.scale);
                    g.drawLine(i + startX, this.h1 + startY, i + startX, y1 + startY);
                }
                break block16;
            }
            if (this.yVarIndex < 0) break block16;
            boolean bl = ch = !this.filter.isNumericVariable(this.yVarIndex);
            while (this.selections.hasMoreSelections()) {
                int index = this.selections.nextSelectedIndex();
                int y1 = -1;
                y1 = !ch ? this.project(this.filter.getNumericValue(this.yVarIndex, (long)index)) : this.project(this.charMapper.getIndex(this.filter.getFormattedValue(this.filter.getVariableId(this.yVarIndex), (long)index, null)));
                if (y1 < 0 || y1 >= this.selectBinArray.length) continue;
                int n = y1;
                this.selectBinArray[n] = this.selectBinArray[n] + 1;
            }
            for (int i = 0; i < this.selectBinArray.length; ++i) {
                int index = i;
                if (this.xVarIndex >= 0 && this.transformObject.isReverse(0)) {
                    index = this.selectBinArray.length - 1 - i;
                } else if (this.yVarIndex >= 0 && this.transformObject.isReverse(1)) {
                    index = this.selectBinArray.length - 1 - i;
                }
                if (this.selectBinArray[index] == 0) continue;
                int x1 = (int)((double)this.selectBinArray[index] * this.scale);
                g.setColor(selectionColor);
                g.drawLine(startX, i + startY, x1 + startX, i + startY);
            }
        }
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        double[] pv1 = new double[3];
        double[] pv2 = new double[3];
        pv1 = this.transformObject.unProject(selectArea.x, selectArea.y + selectArea.height, 0.0, pv1);
        pv2 = this.transformObject.unProject(selectArea.x + selectArea.width, selectArea.y, 0.0, pv2);
        double minX = Math.min(pv1[0], pv2[0]);
        double maxX = Math.max(pv1[0], pv2[0]);
        double minY = Math.min(pv1[1], pv2[1]);
        double maxY = Math.max(pv1[1], pv2[1]);
        ContinuousRange[] ranges = null;
        String[] vars = null;
        if (this.xVarIndex >= 0) {
            if (this.filter.isNumericVariable(this.xVarIndex)) {
                ranges = new ContinuousRange[]{new ContinuousRange(minX, maxX)};
            } else {
                ranges = new DiscreteRange[1];
                Vector<Object> v = new Vector<Object>();
                int min = (int)Math.ceil(minX);
                int max = (int)Math.floor(maxX);
                for (int i = min; i <= max; ++i) {
                    Object value = this.charMapper.getValue(i);
                    if (value == null) continue;
                    v.addElement(value);
                }
                ranges[0] = new DiscreteRange(v.toArray());
            }
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString()};
        } else if (this.yVarIndex >= 0) {
            if (this.filter.isNumericVariable(this.yVarIndex)) {
                ranges = new ContinuousRange[]{new ContinuousRange(minY, maxY)};
            } else {
                ranges = new DiscreteRange[1];
                Vector<Object> v = new Vector<Object>();
                int min = (int)Math.ceil(minY);
                int max = (int)Math.floor(maxY);
                for (int i = min; i <= max; ++i) {
                    Object value = this.charMapper.getValue(i);
                    if (value == null) continue;
                    v.addElement(value);
                }
                ranges[0] = new DiscreteRange(v.toArray());
            }
            vars = new String[]{this.roles.getVariable((Object)this.yRole, 0).toString()};
        }
        if (this.filter != null) {
            if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                ((AbstractDataFilter)this.filter).toggleSelected(vars, (DataRange[])ranges, false);
            } else {
                this.filter.setSelected(vars, (DataRange[])ranges, select);
            }
        }
        return true;
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        this.build(Boolean.TRUE);
    }

    @Override
    public void dispose() {
        this.xRole = null;
        this.yRole = null;
        this.binArray = null;
        this.selectBinArray = null;
        if (this.charMapper != null) {
            this.charMapper.dispose();
            this.charMapper = null;
        }
        super.dispose();
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 19089: {
                rc = Boolean.TRUE;
                break;
            }
            case 19058: 
            case 19059: 
            case 19060: 
            case 19061: 
            case 19062: 
            case 19063: {
                rc = Boolean.FALSE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    protected String getMenuXML() {
        return "/com/sas/graphics/silk/util/menus/DensityMenu.xml";
    }
}

