/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.silk.base;

import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.data.AbstractDataFilter;
import com.sas.graphics.silk.base.BaseElement;
import com.sas.graphics.silk.interfaces.RoleEvent;
import com.sas.graphics.silk.util.ColorUtilities;
import com.sas.graphics.silk.util.ResourceLoader;
import com.sas.graphics.silk.util.SILKNumber;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class DensityPlotElement
extends BaseElement {
    BufferedImage db = null;
    float[][] rPix = null;
    float[][] gPix = null;
    float[][] bPix = null;
    boolean[][] flags = null;
    int[][] bin2d = null;
    int xVarIndex = -1;
    int yVarIndex = -1;
    protected SILKNumber xRole = null;
    protected SILKNumber yRole = null;
    double computedAlpha = Double.NaN;
    double userSetAlpha = Double.NaN;
    double default1DAlpha = 0.8;
    int[] xTicks = null;
    int[] yTicks = null;
    double scale = 1.0;
    int w1 = 0;
    int h1 = 0;
    double xMin;
    double xMax;
    double yMin;
    double yMax;
    double xScale;
    double yScale;
    public static final int[] supportedDensityProperties = new int[]{13000, 13001};

    public DensityPlotElement() {
        this.xRole = this.role.getRoleObject("ROLE_X");
        this.roles.newRole((Object)this.xRole, "X", 1);
        this.roles.setRoleType((Object)this.xRole, 1);
        this.yRole = this.role.getRoleObject("ROLE_Y");
        this.roles.newRole((Object)this.yRole, "Y", 1);
        this.roles.setRoleType((Object)this.yRole, 1);
        this.setSupportedProperties(supportedDensityProperties);
        this.userSetProperties.appendProperties(supportedDensityProperties);
        this.addChartTabInfo("com.sas.graphics.silk.ui.DensityPlotPanel", ResourceLoader.getResourceString((Object)"com.sas.graphics.silk.base.silk_base_NLS", (String)"DensityElement.Density_Plot.txt", (String)"Density Plot"));
    }

    @Override
    public String getTipText(int screenX, int screenY) {
        double[] vals = this.transformObject.unProject(screenX, screenY, 0.0, null);
        double x = vals[0];
        double y = vals[1];
        String s = "";
        Object var = this.roles.getVariable((Object)this.xRole, 0);
        if (var != null) {
            s = s + this.filter.getVariableDescription(var) + " \t = \t " + this.getFormattedValue(var, new Double(x)) + "\n";
        }
        if ((var = this.roles.getVariable((Object)this.yRole, 0)) != null) {
            s = s + this.filter.getVariableDescription(var) + " \t = \t " + this.getFormattedValue(var, new Double(y)) + "\n";
        }
        int xloc = screenX - this.innerMargin.left;
        int yloc = screenY - this.innerMargin.top;
        if (xloc >= 0 && xloc < this.bin2d.length && yloc >= 0 && yloc < this.bin2d[xloc].length) {
            s = s + ResourceLoader.getResourceString((Object)this.rb, (String)"DensityElement.Freq.txt", (String)"freq.") + " \t = \t " + this.getDefaultFormattedValue(new Double(this.bin2d[xloc][yloc]));
        }
        return s;
    }

    protected double getAlpha() {
        if (!Double.isNaN(this.userSetAlpha)) {
            return this.userSetAlpha;
        }
        if (this.xVarIndex < 0 || this.yVarIndex < 0) {
            return this.default1DAlpha;
        }
        if (Double.isNaN(this.computedAlpha)) {
            int numPixels = this.w1 * this.h1;
            int numObs = this.filter.getNumberObservations(-1);
            this.computedAlpha = 0.2 * (double)numPixels / (double)numObs;
            this.computedAlpha = Math.max(this.computedAlpha, 0.01);
            this.computedAlpha = Math.min(this.computedAlpha, 0.95);
        }
        return this.computedAlpha;
    }

    @Override
    public void setBounds(Rectangle r) {
        super.setBounds(r);
        int w = this.bounds.width - this.innerMargin.left - this.innerMargin.right;
        int h = this.bounds.height - this.innerMargin.top - this.innerMargin.bottom;
        if (w == this.w1 && h == this.h1) {
            return;
        }
        this.w1 = w;
        this.h1 = h;
        if (this.w1 > 0 && this.h1 > 0) {
            this.db = new BufferedImage(w, h, 1);
            this.rPix = new float[this.w1][this.h1];
            this.gPix = new float[this.w1][this.h1];
            this.bPix = new float[this.w1][this.h1];
            this.flags = new boolean[this.w1][this.h1];
            this.bin2d = new int[this.w1][this.h1];
            this.xTicks = null;
            this.yTicks = null;
            this.build(Boolean.TRUE);
        }
        System.gc();
        this.computedAlpha = Double.NaN;
    }

    @Override
    public boolean build(Object buildData) {
        double temp;
        boolean rc = super.build(buildData);
        ContinuousRange xRange = (ContinuousRange)this.getOutputRange((byte)1);
        ContinuousRange yRange = (ContinuousRange)this.getOutputRange((byte)2);
        this.xMin = xRange == null ? Double.NaN : xRange.getMin();
        this.xMax = xRange == null ? Double.NaN : xRange.getMax();
        this.yMin = yRange == null ? Double.NaN : yRange.getMin();
        double d = this.yMax = yRange == null ? Double.NaN : yRange.getMax();
        if (this.transformObject.isReverse(0)) {
            temp = this.xMin;
            this.xMin = this.xMax;
            this.xMax = temp;
        }
        if (this.transformObject.isReverse(1)) {
            temp = this.yMin;
            this.yMin = this.yMax;
            this.yMax = temp;
        }
        this.xScale = xRange == null ? Double.NaN : 1.0 / (this.xMax - this.xMin);
        this.yScale = yRange == null ? Double.NaN : 1.0 / (this.yMax - this.yMin);
        return rc;
    }

    @Override
    public void roleChanged(RoleEvent e) {
        super.roleChanged(e);
        if (this.filter == null) {
            this.yVarIndex = -1;
            this.xVarIndex = -1;
        } else {
            this.xVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.xRole, 0));
            this.yVarIndex = this.filter.getVariableIndex(this.roles.getVariable((Object)this.yRole, 0));
        }
        this.computedAlpha = Double.NaN;
    }

    @Override
    protected void drawChart(Graphics g) {
        Color backColor = this.style.getFillStyleElement("WallFill").getFillColor();
        int v1r = backColor.getRed();
        int v1g = backColor.getGreen();
        int v1b = backColor.getBlue();
        for (int i = 0; i < this.w1; ++i) {
            if (i >= this.rPix.length) continue;
            for (int j = 0; j < this.h1; ++j) {
                if (j >= this.rPix[i].length) continue;
                this.rPix[i][j] = v1r;
                this.gPix[i][j] = v1g;
                this.bPix[i][j] = v1b;
            }
        }
        this.drawGridlines();
        if (this.xVarIndex >= 0 && this.yVarIndex >= 0) {
            this.build_2D();
        }
        this.drawBackBuffer(g);
    }

    private final int projectX(double xValue) {
        return (int)((double)this.w1 * (xValue - this.xMin) * this.xScale);
    }

    private final int projectY(double yValue) {
        return (int)((double)this.h1 - (double)this.h1 * (yValue - this.yMin) * this.yScale);
    }

    protected void build_2D() {
        if (this.bounds == null || this.w1 == 0 || this.h1 == 0) {
            return;
        }
        for (int i = 0; i < this.w1; ++i) {
            for (int j = 0; j < this.h1; ++j) {
                this.bin2d[i][j] = 0;
            }
        }
        Color dataColor = Color.white;
        Color[] colors = this.style.getDataLineColors();
        if (colors != null) {
            dataColor = colors[0];
        }
        int count = this.filter.getNumberObservations(-1);
        double alpha = this.getAlpha();
        double rs = dataColor.getRed();
        double gs = dataColor.getGreen();
        double bs = dataColor.getBlue();
        double alpha2 = 1.0 - alpha;
        if (this.rPix == null || this.gPix == null || this.bPix == null) {
            return;
        }
        for (int i = 0; i < count; ++i) {
            double x = this.filter.getNumericValue(this.xVarIndex, (long)i);
            double y = this.filter.getNumericValue(this.yVarIndex, (long)i);
            if (Double.isNaN(x) || Double.isNaN(y)) continue;
            int x1 = this.projectX(x);
            int y1 = this.projectY(y);
            if (x1 < 0 || y1 < 0 || x1 >= this.rPix.length || y1 >= this.rPix[0].length) continue;
            this.rPix[x1][y1] = (float)(rs * alpha + (double)this.rPix[x1][y1] * alpha2);
            this.gPix[x1][y1] = (float)(gs * alpha + (double)this.gPix[x1][y1] * alpha2);
            this.bPix[x1][y1] = (float)(bs * alpha + (double)this.bPix[x1][y1] * alpha2);
            int[] nArray = this.bin2d[x1];
            int n = y1;
            nArray[n] = nArray[n] + 1;
        }
    }

    private void drawBackBuffer(Graphics g) {
        int rgb = 0xFFFFFF;
        for (int i = 0; i < this.w1; ++i) {
            for (int j = 0; j < this.h1; ++j) {
                int r1 = (int)this.rPix[i][j] & 0xFF;
                int g1 = (int)this.gPix[i][j] & 0xFF;
                int b1 = (int)this.bPix[i][j] & 0xFF;
                rgb = r1 << 16 | g1 << 8 | b1;
                this.db.setRGB(i, j, rgb);
            }
        }
        g.drawImage(this.db, this.innerMargin.left + this.bounds.x, this.innerMargin.top + this.bounds.y, null);
    }

    private void drawGridlines() {
        int loc;
        int j;
        int i;
        Color wallColor = this.style.getFillStyleElement("WallFill").getFillColor();
        Color color = ColorUtilities.darker(wallColor);
        Color color2 = ColorUtilities.brighter(wallColor);
        int r1 = color.getRed();
        int g1 = color.getGreen();
        int b1 = color.getBlue();
        int r2 = color2.getRed();
        int g2 = color2.getGreen();
        int b2 = color2.getBlue();
        if (this.xTicks != null) {
            for (i = 0; i < this.xTicks.length; ++i) {
                for (j = 0; j < this.h1; ++j) {
                    loc = this.xTicks[i] - this.bounds.x - this.innerMargin.left;
                    if (loc < 0 || loc >= this.rPix.length || j < 0 || j >= this.rPix[loc].length) continue;
                    this.rPix[loc][j] = r1;
                    this.gPix[loc][j] = g1;
                    this.bPix[loc][j] = b1;
                    if (loc >= this.rPix.length - 1) continue;
                    this.rPix[loc + 1][j] = r2;
                    this.gPix[loc + 1][j] = g2;
                    this.bPix[loc + 1][j] = b2;
                }
            }
        }
        if (this.yTicks != null) {
            for (i = 0; i < this.yTicks.length; ++i) {
                for (j = 0; j < this.w1; ++j) {
                    loc = this.yTicks[i] - this.bounds.y - this.innerMargin.top;
                    if (loc < 0 || loc >= this.rPix[j].length) continue;
                    this.rPix[j][loc] = r1;
                    this.gPix[j][loc] = g1;
                    this.bPix[j][loc] = b1;
                    if (loc >= this.rPix[j].length - 1) continue;
                    this.rPix[j][loc + 1] = r2;
                    this.gPix[j][loc + 1] = g2;
                    this.bPix[j][loc + 1] = b2;
                }
            }
        }
    }

    @Override
    protected void drawSelected(Graphics g) {
        if (this.selections == null || !this.selections.hasMoreSelections()) {
            return;
        }
        if (this.xVarIndex < 0 && this.yVarIndex < 0) {
            return;
        }
        if (this.xVarIndex >= 0 && this.yVarIndex >= 0) {
            for (int i = 0; i < this.flags.length; ++i) {
                for (int j = 0; j < this.flags[i].length; ++j) {
                    this.flags[i][j] = false;
                }
            }
        }
        Color selectionColor = this.style.getLineStyleElement("Selection").getLineColor();
        float[] hsb = new float[3];
        Color.RGBtoHSB(selectionColor.getRed(), selectionColor.getGreen(), selectionColor.getBlue(), hsb);
        float selectionHue = hsb[0];
        int startX = this.bounds.x + this.innerMargin.left;
        int startY = this.bounds.y + this.innerMargin.top;
        if (this.xVarIndex >= 0 && this.yVarIndex >= 0) {
            while (this.selections.hasMoreSelections()) {
                int index = this.selections.nextSelectedIndex();
                double xValue = this.filter.getNumericValue(this.xVarIndex, (long)index);
                double yValue = this.filter.getNumericValue(this.yVarIndex, (long)index);
                int x1 = this.projectX(xValue);
                int y1 = this.projectY(yValue);
                if (x1 < 0 || y1 < 0 || x1 >= this.flags.length || y1 >= this.flags[x1].length || this.flags[x1][y1]) continue;
                this.flags[x1][y1] = true;
                Color.RGBtoHSB((int)this.rPix[x1][y1], (int)this.gPix[x1][y1], (int)this.bPix[x1][y1], hsb);
                g.setColor(Color.getHSBColor(selectionHue, 1.0f, hsb[2]));
                g.fillRect(x1 + startX, y1 + startY, 1, 1);
            }
        }
    }

    @Override
    public boolean setPropertyValue(int id, Object value) {
        boolean rc = false;
        switch (id) {
            case 19074: {
                if (value != null && !(value instanceof int[]) || this.getXAxisMapping() != 0) break;
                this.setXTicks((int[])value);
                rc = true;
                break;
            }
            case 19075: {
                if (value != null && !(value instanceof int[]) || this.getYAxisMapping() != 1) break;
                this.setYTicks((int[])value);
                rc = true;
                break;
            }
            case 19076: {
                if (value != null && !(value instanceof int[]) || this.getXAxisMapping() != 3) break;
                this.setXTicks((int[])value);
                rc = true;
                break;
            }
            case 19077: {
                if (value != null && !(value instanceof int[]) || this.getYAxisMapping() != 4) break;
                this.setYTicks((int[])value);
                rc = true;
                break;
            }
            default: {
                rc = super.setPropertyValue(id, value);
            }
        }
        return rc;
    }

    @Override
    public boolean selectInLayer(boolean select, Object selectRegion, MouseEvent event) {
        Rectangle selectArea = null;
        if (!(selectRegion instanceof Rectangle)) {
            return false;
        }
        selectArea = (Rectangle)selectRegion;
        double[] pv1 = new double[3];
        double[] pv2 = new double[3];
        pv1 = this.transformObject.unProject(selectArea.x, selectArea.y + selectArea.height, 0.0, pv1);
        pv2 = this.transformObject.unProject(selectArea.x + selectArea.width, selectArea.y, 0.0, pv2);
        double minX = Math.min(pv1[0], pv2[0]);
        double maxX = Math.max(pv1[0], pv2[0]);
        double minY = Math.min(pv1[1], pv2[1]);
        double maxY = Math.max(pv1[1], pv2[1]);
        ContinuousRange[] ranges = null;
        String[] vars = null;
        if (this.xVarIndex >= 0 && this.yVarIndex >= 0) {
            ranges = new ContinuousRange[]{new ContinuousRange(minX, maxX), new ContinuousRange(minY, maxY)};
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString(), this.roles.getVariable((Object)this.yRole, 0).toString()};
        } else if (this.xVarIndex >= 0) {
            ranges = new ContinuousRange[]{new ContinuousRange(minX, maxX)};
            vars = new String[]{this.roles.getVariable((Object)this.xRole, 0).toString()};
        } else if (this.yVarIndex >= 0) {
            ranges = new ContinuousRange[]{new ContinuousRange(minY, maxY)};
            vars = new String[]{this.roles.getVariable((Object)this.yRole, 0).toString()};
        }
        if (this.filter != null) {
            if (this.filter instanceof AbstractDataFilter && this.isExtendedSelectMode(event)) {
                ((AbstractDataFilter)this.filter).toggleSelected(vars, (DataRange[])ranges, false);
            } else {
                this.filter.setSelected(vars, (DataRange[])ranges, select);
            }
        }
        return true;
    }

    public int[] getXTicks() {
        return this.xTicks;
    }

    public void setXTicks(int[] ticks) {
        this.xTicks = ticks;
    }

    public int[] getYTicks() {
        return this.yTicks;
    }

    public void setYTicks(int[] ticks) {
        this.yTicks = ticks;
    }

    @Override
    protected void applyChange(int key, Object value) {
        switch (key) {
            case 13000: {
                if (value != null && value instanceof Number) {
                    this.computedAlpha = ((Number)value).doubleValue();
                }
                this.userSetProperties.set(13000);
                this.userSetProperties.set(13001);
                break;
            }
            case 13001: {
                if (value != null && value instanceof Number) {
                    this.userSetAlpha = ((Number)value).doubleValue();
                }
                this.userSetProperties.set(13000);
                this.userSetProperties.set(13001);
                break;
            }
            default: {
                super.applyChange(key, value);
            }
        }
    }

    @Override
    public Object getPropertyValue(int id) {
        if (this.pendingProperties == null) {
            return null;
        }
        if (this.pendingProperties.isPending(id)) {
            return this.pendingProperties.getValueById(id);
        }
        Object rc = null;
        switch (id) {
            case 19089: {
                rc = Boolean.TRUE;
                break;
            }
            case 13000: {
                if (Double.isNaN(this.computedAlpha)) {
                    this.getAlpha();
                }
                rc = new Double(this.computedAlpha);
                break;
            }
            case 13001: {
                rc = new Double(this.userSetAlpha);
                break;
            }
            case 19058: 
            case 19059: 
            case 19060: 
            case 19061: 
            case 19062: 
            case 19063: {
                rc = Boolean.FALSE;
                break;
            }
            default: {
                rc = super.getPropertyValue(id);
            }
        }
        return rc;
    }

    @Override
    public void setRange(byte dim, int index, DataRange range) {
        super.setRange(dim, index, range);
        this.build(Boolean.TRUE);
    }

    @Override
    public void dispose() {
        this.db = null;
        this.rPix = null;
        this.gPix = null;
        this.bPix = null;
        this.flags = null;
        this.xRole = null;
        this.yRole = null;
        this.xTicks = null;
        this.yTicks = null;
        super.dispose();
    }

    @Override
    public boolean isUsingSelectionBuffer() {
        return false;
    }

    @Override
    protected String getMenuXML() {
        return "/com/sas/graphics/silk/util/menus/DensityMenu.xml";
    }
}

